/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: addonmenu.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: obo $ $Date: 2006/10/12 10:39:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_framework.hxx"

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_CLASSES_ADDONMENU_HXX_
#include "classes/addonmenu.hxx"
#endif

#ifndef __FRAMEWORK_CLASSES_ADDONSOPTIONS_HXX_
#include "classes/addonsoptions.hxx"
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_ASSERTION_HXX_
#include <macros/debug/assertion.hxx>
#endif

#ifndef __FRAMEWORK_HELPER_IMAGEPRODUCER_HXX_
#include <helper/imageproducer.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_MENUCONFIGURATION_HXX_
#include <classes/menuconfiguration.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UTIL_URL_HPP_
#include <com/sun/star/util/URL.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif
#include <vcl/svapp.hxx>
#include <svtools/menuoptions.hxx>

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

using namespace ::rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::beans;

// Please look at sfx2/inc/sfxsids.hrc the values are defined there. Due to build dependencies
// we cannot include the header file.
const USHORT SID_SFX_START           = 5000;
const USHORT SID_HELPMENU            = (SID_SFX_START + 410);
const USHORT SID_ONLINE_REGISTRATION = (SID_SFX_START + 1537);

namespace framework
{

AddonMenu::AddonMenu( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >& rFrame ) :
    m_xFrame( rFrame )
{
}

AddonMenu::~AddonMenu()
{
	for ( USHORT i = 0; i < GetItemCount(); i++ )
	{
		if ( GetItemType( i ) != MENUITEM_SEPARATOR )
		{
			// delete user attributes created with new!
			USHORT nId = GetItemId( i );
			MenuConfiguration::Attributes* pUserAttributes = (MenuConfiguration::Attributes*)GetUserValue( nId );
			delete pUserAttributes;
			delete GetPopupMenu( nId );
		}
	}
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
// Check if command URL string has the unique prefix to identify addon popup menus
sal_Bool AddonPopupMenu::IsCommandURLPrefix( const OUString& aCmdURL )
{
	const char aPrefixCharBuf[] = ADDONSPOPUPMENU_URL_PREFIX_STR;

	return aCmdURL.matchAsciiL( aPrefixCharBuf, sizeof( aPrefixCharBuf )-1, 0 );
}

AddonPopupMenu::AddonPopupMenu( com::sun::star::uno::Reference< com::sun::star::frame::XFrame >& rFrame ) :
    m_xFrame( rFrame )
{
}

AddonPopupMenu::~AddonPopupMenu()
{
	for ( USHORT i = 0; i < GetItemCount(); i++ )
	{
		if ( GetItemType( i ) != MENUITEM_SEPARATOR )
		{
			// delete user attributes created with new!
			USHORT nId = GetItemId( i );
			MenuConfiguration::Attributes* pUserAttributes = (MenuConfiguration::Attributes*)GetUserValue( nId );
			delete pUserAttributes;
			delete GetPopupMenu( nId );
		}
	}
}

// ------------------------------------------------------------------------

static Reference< XModel > GetModelFromFrame( Reference< XFrame >& rFrame )
{
    // Query for the model to get check the context information
    Reference< XModel > xModel;
	if ( rFrame.is() )
	{
	    Reference< XController > xController( rFrame->getController(), UNO_QUERY );
	    if ( xController.is() )
	        xModel = xController->getModel();
	}       

    return xModel;
}

// ------------------------------------------------------------------------

sal_Bool AddonMenuManager::HasAddonMenuElements()
{
	return AddonsOptions().HasAddonsMenu();
}

sal_Bool AddonMenuManager::HasAddonHelpMenuElements()
{
	return AddonsOptions().HasAddonsHelpMenu();
}
    
// Factory method to create different Add-On menu types
PopupMenu* AddonMenuManager::CreatePopupMenuType( MenuType eMenuType, Reference< XFrame >& rFrame )
{
    if ( eMenuType == ADDON_MENU )
        return new AddonMenu( rFrame );
    else if ( eMenuType == ADDON_POPUPMENU )
        return new AddonPopupMenu( rFrame );
    else
        return NULL;
}

// Create the Add-Ons menu
AddonMenu* AddonMenuManager::CreateAddonMenu( Reference< XFrame >& rFrame )
{
    AddonsOptions aOptions;
    AddonMenu*  pAddonMenu      = NULL;
    USHORT      nUniqueMenuId   = ADDONMENU_ITEMID_START;
	
	const Sequence< Sequence< PropertyValue > >& rAddonMenuEntries = aOptions.GetAddonsMenu();
	if ( rAddonMenuEntries.getLength() > 0 )
	{
        pAddonMenu = (AddonMenu *)AddonMenuManager::CreatePopupMenuType( ADDON_MENU, rFrame );
		Reference< XModel > xModel = GetModelFromFrame( rFrame );
        AddonMenuManager::BuildMenu( pAddonMenu, ADDON_MENU, MENU_APPEND, nUniqueMenuId, rAddonMenuEntries, rFrame, xModel );
        
        // Don't return an empty Add-On menu
        if ( pAddonMenu->GetItemCount() == 0 )
        {
            delete pAddonMenu;
            pAddonMenu = NULL;
        }
    }
    
    return pAddonMenu;
}
            
// Returns the next insert position from nPos.
USHORT AddonMenuManager::GetNextPos( USHORT nPos )
{
    return ( nPos == MENU_APPEND ) ? MENU_APPEND : ( nPos+1 );
}


static USHORT FindMenuId( Menu* pMenu, const String aCommand )
{
    USHORT nPos = 0;
    String aCmd;
    for ( nPos = 0; nPos < pMenu->GetItemCount(); nPos++ )
    {
        USHORT nId = pMenu->GetItemId( nPos );
        aCmd = pMenu->GetItemCommand( nId );
        if ( aCmd == aCommand )
            return nId;
    }

    return USHRT_MAX;
}


// Merge the Add-Ons help menu items into the given menu bar at a defined pos
void AddonMenuManager::MergeAddonHelpMenu( Reference< XFrame >& rFrame, MenuBar* pMergeMenuBar )
{
    if ( pMergeMenuBar )
    {
        PopupMenu* pHelpMenu = pMergeMenuBar->GetPopupMenu( SID_HELPMENU );
        if ( !pHelpMenu )
        {
            USHORT nId = FindMenuId( pMergeMenuBar, String::CreateFromAscii( ".uno:HelpMenu" ));
            if ( nId != USHRT_MAX )
                pHelpMenu = pMergeMenuBar->GetPopupMenu( nId );
        }

        if ( pHelpMenu )
        {
            // Add-Ons help menu items should be inserted after the "registration" menu item
            USHORT nItemCount       = pHelpMenu->GetItemCount();
            USHORT nRegPos          = pHelpMenu->GetItemPos( SID_ONLINE_REGISTRATION );
            USHORT nInsPos          = nRegPos;
            USHORT nInsSepAfterPos  = MENU_APPEND;
            USHORT nUniqueMenuId    = ADDONMENU_ITEMID_START;
            AddonsOptions aOptions;

            if ( nRegPos == USHRT_MAX )
            {
                // try to detect the online registration dialog menu item with the command URL
                USHORT nId = FindMenuId( pHelpMenu, String::CreateFromAscii( ".uno:OnlineRegistrationDlg" ));
                nRegPos = pHelpMenu->GetItemPos( nId );
                nInsPos = nRegPos;
            }

	        Sequence< Sequence< PropertyValue > > aAddonSubMenu;
	        const Sequence< Sequence< PropertyValue > >& rAddonHelpMenuEntries = aOptions.GetAddonsHelpMenu();
	        
	        nInsPos = AddonMenuManager::GetNextPos( nInsPos );
	        if ( nInsPos < nItemCount && pHelpMenu->GetItemType( nInsPos ) != MENUITEM_SEPARATOR )
	            nInsSepAfterPos = nInsPos;
	        
			Reference< XModel > xModel = GetModelFromFrame( rFrame );
	        AddonMenuManager::BuildMenu( pHelpMenu, ADDON_MENU, nInsPos, nUniqueMenuId, rAddonHelpMenuEntries, rFrame, xModel );
	        
	        if ( pHelpMenu->GetItemCount() > nItemCount )
	        {
	            if ( nInsSepAfterPos < MENU_APPEND )
	            {
	                nInsSepAfterPos += ( pHelpMenu->GetItemCount() - nItemCount );
	                if ( pHelpMenu->GetItemType( nInsSepAfterPos ) != MENUITEM_SEPARATOR )
	                    pHelpMenu->InsertSeparator( nInsSepAfterPos );
	            }
	            if ( nRegPos < MENU_APPEND )
	                pHelpMenu->InsertSeparator( nRegPos+1 );
	            else
	                pHelpMenu->InsertSeparator( nItemCount );
	        }	        
	    }
	}
}

// Merge the addon popup menus into the given menu bar at the provided pos.
void AddonMenuManager::MergeAddonPopupMenus( Reference< XFrame >& rFrame,
											 Reference< XModel >& rModel,
										     USHORT	              nMergeAtPos,
											 MenuBar*             pMergeMenuBar )
{
	if ( pMergeMenuBar )
	{
		AddonsOptions	aAddonsOptions;
		USHORT			nInsertPos = nMergeAtPos;

	    OUString                              aTitle;
	    OUString                              aURL;
	    OUString                              aTarget;
	    OUString                              aImageId;
	    OUString                              aContext;
	    Sequence< Sequence< PropertyValue > > aAddonSubMenu;
	    USHORT                                nUniqueMenuId = ADDONMENU_ITEMID_START;

		const Sequence< Sequence< PropertyValue > >&	rAddonMenuEntries = aAddonsOptions.GetAddonsMenuBarPart();
		for ( sal_Int32 i = 0; i < rAddonMenuEntries.getLength(); i++ )
		{
            AddonMenuManager::GetMenuEntry( rAddonMenuEntries[i], 
                                            aTitle, 
                                            aURL,
                                            aTarget,
                                            aImageId,
                                            aContext,
                                            aAddonSubMenu );
            if ( aTitle.getLength() > 0 &&
                 aURL.getLength() > 0 &&
                 aAddonSubMenu.getLength() > 0 &&
                 AddonMenuManager::IsCorrectContext( rModel, aContext ))
            {
                USHORT          nId             = nUniqueMenuId++;
                AddonPopupMenu* pAddonPopupMenu = (AddonPopupMenu *)AddonMenuManager::CreatePopupMenuType( ADDON_POPUPMENU, rFrame );
                    
                AddonMenuManager::BuildMenu( pAddonPopupMenu, ADDON_MENU, MENU_APPEND, nUniqueMenuId, aAddonSubMenu, rFrame, rModel );
                
                if ( pAddonPopupMenu->GetItemCount() > 0 )
                {
                    pAddonPopupMenu->SetCommandURL( aURL );
				    pMergeMenuBar->InsertItem( nId, aTitle, 0, nInsertPos++ );
				    pMergeMenuBar->SetPopupMenu( nId, pAddonPopupMenu );
				    
				    // Store the command URL into the VCL menu bar for later identification
				    pMergeMenuBar->SetItemCommand( nId, aURL );
                }
                else
                    delete pAddonPopupMenu;
            }
        }
    }
}
        
// Insert the menu and sub menu entries into pCurrentMenu with the aAddonMenuDefinition provided
void AddonMenuManager::BuildMenu( PopupMenu*                            pCurrentMenu,
                                  MenuType                              nSubMenuType,
                                  USHORT                                nInsPos,
                                  USHORT&                               nUniqueMenuId,
                                  Sequence< Sequence< PropertyValue > > aAddonMenuDefinition, 
                                  Reference< XFrame >&                  rFrame,
                                  Reference< XModel >&                  rModel )
{
	Sequence< Sequence< PropertyValue > >	aAddonSubMenu;
	BOOL                                    bInsertSeparator    = FALSE;
	UINT32									i                   = 0;
	UINT32                                  nElements           = 0;
	UINT32                                  nCount			    = aAddonMenuDefinition.getLength();
	AddonsOptions							aAddonsOptions;
	
	::rtl::OUString aTitle;
	::rtl::OUString aURL;
	::rtl::OUString aTarget;
	::rtl::OUString aImageId;
	::rtl::OUString aContext;

	for ( i = 0; i < nCount; ++i )
	{
		GetMenuEntry( aAddonMenuDefinition[i], aTitle, aURL, aTarget, aImageId, aContext, aAddonSubMenu );

		if ( !IsCorrectContext( rModel, aContext ) || ( !aTitle.getLength() && !aURL.getLength() ))
		    continue;

        if ( aURL == ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "private:separator" )))
			bInsertSeparator = TRUE;
		else
		{
            PopupMenu* pSubMenu = NULL;
			if ( aAddonSubMenu.getLength() > 0 )
			{
	            pSubMenu = AddonMenuManager::CreatePopupMenuType( nSubMenuType, rFrame );
				AddonMenuManager::BuildMenu( pSubMenu, nSubMenuType, MENU_APPEND, nUniqueMenuId, aAddonSubMenu, rFrame, rModel );
                
                // Don't create a menu item for an empty sub menu
				if ( pSubMenu->GetItemCount() == 0 )
				{
				    delete pSubMenu;
				    pSubMenu =  NULL;
				    continue;
				}
		    }

            if ( bInsertSeparator && nElements > 0 )
            {
                // Insert a separator only when we insert a new element afterwards and we
                // have already one before us
                nElements = 0;
                bInsertSeparator = FALSE;
                pCurrentMenu->InsertSeparator( nInsPos );
                nInsPos = AddonMenuManager::GetNextPos( nInsPos );
            }

			USHORT nId = nUniqueMenuId++;
            pCurrentMenu->InsertItem( nId, aTitle, 0, nInsPos );
            nInsPos = AddonMenuManager::GetNextPos( nInsPos );
			
			++nElements;

			// Store values from configuration to the New and Wizard menu entries to enable
			// sfx2 based code to support high contrast mode correctly!
			pCurrentMenu->SetUserValue( nId, ULONG( new MenuConfiguration::Attributes( aTarget, aImageId )) );
			pCurrentMenu->SetItemCommand( nId, aURL );
			
			if ( pSubMenu )
				pCurrentMenu->SetPopupMenu( nId, pSubMenu );
		}
	}
}

// Retrieve the menu entry property values from a sequence
void AddonMenuManager::GetMenuEntry( const Sequence< PropertyValue >& rAddonMenuEntry,
	                                 OUString& rTitle,
	                                 OUString& rURL,
	                                 OUString& rTarget,
	                                 OUString& rImageId,
	                                 OUString& rContext,
	                                 Sequence< Sequence< PropertyValue > >&	rAddonSubMenu )
{
	// Reset submenu parameter
	rAddonSubMenu	= Sequence< Sequence< PropertyValue > >();
	
	for ( int i = 0; i < rAddonMenuEntry.getLength(); i++ )
	{
		OUString aMenuEntryPropName = rAddonMenuEntry[i].Name;
		if ( aMenuEntryPropName == ADDONSMENUITEM_PROPERTYNAME_URL )
			rAddonMenuEntry[i].Value >>= rURL;
		else if ( aMenuEntryPropName == ADDONSMENUITEM_PROPERTYNAME_TITLE )
			rAddonMenuEntry[i].Value >>= rTitle;
		else if ( aMenuEntryPropName == ADDONSMENUITEM_PROPERTYNAME_TARGET )
			rAddonMenuEntry[i].Value >>= rTarget;
		else if ( aMenuEntryPropName == ADDONSMENUITEM_PROPERTYNAME_IMAGEIDENTIFIER )
			rAddonMenuEntry[i].Value >>= rImageId;
		else if ( aMenuEntryPropName == ADDONSMENUITEM_PROPERTYNAME_SUBMENU )
			rAddonMenuEntry[i].Value >>= rAddonSubMenu;
		else if ( aMenuEntryPropName == ADDONSMENUITEM_PROPERTYNAME_CONTEXT )
			rAddonMenuEntry[i].Value >>= rContext;
	}
}

// Check if the context string matches the provided xModel context
sal_Bool AddonMenuManager::IsCorrectContext( Reference< XModel >& rModel, const OUString& aContext )
{
	if ( rModel.is() )
	{
		Reference< com::sun::star::lang::XServiceInfo > xServiceInfo( rModel, UNO_QUERY );
		if ( xServiceInfo.is() )
		{
			sal_Int32 nIndex = 0;
			do
			{
				OUString aToken = aContext.getToken( 0, ',', nIndex );
				
				if ( xServiceInfo->supportsService( aToken ))
					return sal_True;
			}
			while ( nIndex >= 0 );
		}
	}
	
	return ( aContext.getLength() == 0 );
}

}
