/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: axisid.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 14:52:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"


#include "axisid.hxx"
#include "glob.hxx"



/*************************************************************************
|*
|* Objekt-Id ermitteln;
|* Liefert -1, wenn das Objekt keine Id hat
|*
\************************************************************************/

SchAxisId* GetAxisId (const SdrObject& rObj)
{
	for (long i = 0;
			  i < rObj.GetUserDataCount();
			  i ++)
	{
		SdrObjUserData *pData = rObj.GetUserData(i);

		if (pData && (pData->GetId() == SCH_AXIS_ID)) return (SchAxisId*) pData;
	}

	return NULL;
}

/*************************************************************************
|*
|* Objekt mit Id suchen;
|* liefert NULL, wenn kein Objekt gefunden wurde.
|*
\************************************************************************/

SdrObject *GetObjWithAxisId (long             nAxisId,
							 const SdrObjList &rObjList,
							 long             *pIndex,
							 SdrIterMode      eMode)
{
	long           nIndex = 0;
	SdrObjListIter aIterator (rObjList, eMode);

	while (aIterator.IsMore ())
	{
		SdrObject *pObj    = aIterator.Next ();
		SchAxisId *pAxisId = GetAxisId (*pObj);

		if (pAxisId && (pAxisId->AxisId () == nAxisId))
		{
			if (pIndex) *pIndex = nIndex;
			return pObj;
		}

		nIndex++;
	}

	return NULL;
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchAxisId::SchAxisId () :
	SdrObjUserData (SchInventor, SCH_AXIS_ID, 0),
	nAxisId (0)
{
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchAxisId::SchAxisId (long nId) :
	SdrObjUserData (SchInventor, SCH_AXIS_ID, 0),
	nAxisId (nId)
{
}

/*************************************************************************
|*
|* Kopier-Konstruktor
|*
\************************************************************************/

SchAxisId::SchAxisId (const SchAxisId &rAxisId) :
	SdrObjUserData (rAxisId),
	nAxisId (rAxisId.nAxisId)
{
}

/*************************************************************************
|*
|* Kopie erzeugen
|*
\************************************************************************/

SdrObjUserData* SchAxisId::Clone(SdrObject *pObj) const
{
	return new SchAxisId (*this);
}

// eof
