/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: undatrow.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:16:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

//svdraw.hxx
//#define _SVDRAW_HXX
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
//#define _SDR_NOOBJECTS
//#define _SDR_NOVIEWS
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV

#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif




#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif

#include "schdll.hxx"
#include "schresid.hxx"
#include "strings.hrc"
#include "schview.hxx"
#include "datarow.hxx"
#include "undatrow.hxx"

TYPEINIT1(SchUndoDataRow, SchUndoAttr);


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoDataRow::Undo()
{
	const SfxPoolItem* pPoolItem=NULL;
	if(pOldAttr->GetItemState(CHATTR_DIAGRAM_GAPWIDTH, TRUE, &pPoolItem) == SFX_ITEM_SET)
		rDoc.SetGap((long)((const SfxInt32Item*)pPoolItem)->GetValue(),nRow);
	if(pOldAttr->GetItemState(CHATTR_DIAGRAM_OVERLAP, TRUE, &pPoolItem) == SFX_ITEM_SET)
		rDoc.SetOverlap((long)((const SfxInt32Item*)pPoolItem)->GetValue(),nRow);
	if(pOldAttr->GetItemState(CHATTR_BARCONNECT, TRUE, &pPoolItem) == SFX_ITEM_SET)
		rDoc.SetBarConnectors(((const SfxBoolItem*)pPoolItem)->GetValue(),nRow);

	rDoc.ChangeDataRowAttr(*pOldAttr, nRow, FALSE);//#54870# nRow statt pObj
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoDataRow::Redo()
{
	const SfxPoolItem* pPoolItem=NULL;
	if(pNewAttr->GetItemState(CHATTR_DIAGRAM_GAPWIDTH, TRUE, &pPoolItem) == SFX_ITEM_SET)
		rDoc.SetGap((long)((const SfxInt32Item*)pPoolItem)->GetValue(),nRow);
	if(pNewAttr->GetItemState(CHATTR_DIAGRAM_OVERLAP, TRUE, &pPoolItem) == SFX_ITEM_SET)
		rDoc.SetOverlap((long)((const SfxInt32Item*)pPoolItem)->GetValue(),nRow);
	if(pNewAttr->GetItemState(CHATTR_BARCONNECT, TRUE, &pPoolItem) == SFX_ITEM_SET)
		rDoc.SetBarConnectors(((const SfxBoolItem*)pPoolItem)->GetValue(),nRow);

	rDoc.ChangeDataRowAttr(*pNewAttr, nRow);//#54870# nRow statt pObj
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoDataRow::Repeat(SfxRepeatTarget& rView)
{
	if (((SchView&)rView).AreObjectsMarked())
	{
		const SdrMarkList& rMarkList = ((SchView&)rView).GetMarkedObjectList();

		if (rMarkList.GetMarkCount() == 1)
		{
			SdrObject* pObj = rMarkList.GetMark(0)->GetMarkedSdrObj();
			SchDataRow* pDataRow = GetDataRow(*pObj);

			if (pDataRow)
			{
				short nRow = pDataRow->GetRow();

				SfxItemSet aOldAttr(rDoc.GetDataRowAttr(nRow));

				if (rDoc.ChangeDataRowAttr(*pNewAttr, nRow))//#54870# nRow statt pObj
				{
					SchUndoDataRow* pUndo =
						new SchUndoDataRow(rDoc, nRow, aOldAttr, *pNewAttr);
					pUndo->SetComment(String(SchResId(STR_UNDO_DATA_ROW)));

					rDoc.GetObjectShell()->
						GetUndoManager()->AddUndoAction(pUndo);
				}
			}
		}
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchUndoDataRow::CanRepeat(SfxRepeatTarget& rView) const
{
	if (((SchView&)rView).AreObjectsMarked())
	{
		const SdrMarkList& rMarkList = ((SchView&)rView).GetMarkedObjectList();

		if (rMarkList.GetMarkCount() == 1 &&
			GetDataRow(*rMarkList.GetMark(0)->GetMarkedSdrObj()))
			return TRUE;
	}

	return FALSE;
}



