/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: datstat.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:42:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _SCH_DATSTAT_HXX
#define _SCH_DATSTAT_HXX

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _VALUESET_HXX //autogen
#include <svtools/valueset.hxx>
#endif
#ifndef _SVX_CHRTITEM_HXX //autogen
#include <svx/chrtitem.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif


#include "datstat.hrc"

/*************************************************************************
|*
|* Datenbeschriftungen-Dialog
|*
\************************************************************************/
class SchDataStatisticsDlg : public ModalDialog
{
private:
	CheckBox            aCbxAverage;
	RadioButton         aRbtNone;
	RadioButton         aRbtVariant;
	RadioButton         aRbtSigma;
	RadioButton         aRbtPercent;
	RadioButton         aRbtBigError;
	RadioButton         aRbtConst;
	FixedLine			aFlDescr;
	MetricField         aMtrFldPercent;
	MetricField         aMtrFldBigError;
	FixedText		    aFTConstPlus;
	MetricField         aMtrFldConstPlus;
	FixedText		    aFTConstMinus;
	MetricField         aMtrFldConstMinus;
	FixedText		    aFTIndicate;
	FixedText		    aFTRegress;
	ValueSet 		    aSet;
	ValueSet 		    aRegression;
	OKButton			aBtnOK;
	CancelButton		aBtnCancel;
	HelpButton			aBtnHelp;
	BOOL                bRegressionDisabled;

	const SfxItemSet    &rInAttrs;
	SvxChartKindError   eKindError;
	SvxChartIndicate    eIndicate;
	SvxChartRegress     eRegression;

	DECL_LINK(CbxClick, CheckBox *);
	DECL_LINK(RBtnClick, Button *);
	DECL_LINK(SelectIndicate, void *);
	DECL_LINK(SelectRegression, void *);
	DECL_LINK(EditLoseFocusHdl, Control*);

	void Reset();
    void FillValueSets();

public:
	SchDataStatisticsDlg (Window           *pParent,
						  const SfxItemSet &rMyAttrs);

	virtual ~SchDataStatisticsDlg ();

	void GetAttr(SfxItemSet &rOutAttrs);

    virtual void	DataChanged( const DataChangedEvent& rDCEvt );
};

#endif // _SCH_DATDESCR_HXX

