/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: slidview.cxx,v $
 *
 *  $Revision: 1.48 $
 *
 *  last change: $Author: kz $ $Date: 2006/12/12 19:22:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#include "SlideView.hxx"

#include <math.h>

#include <sfx2/viewfrm.hxx>

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _VIEW3D_HXX
#include <svx/view3d.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <sfx2/app.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXDOCFILE_HXX
#include <sfx2/docfile.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _SVDUNDO_HXX //autogen
#include <svx/svdundo.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _GRFMGR_HXX
#include <goodies/grfmgr.hxx>
#endif
#include <svx/svdoutl.hxx>

#include "DrawDocShell.hxx"
#ifndef SD_SLIDE_VIEW_SHELL_HXX
#include "SlideViewShell.hxx"
#endif
#ifndef SD_WINDOW_HXX
#include "Window.hxx"
#endif
#ifndef SD_VIEW_SHELL_HXX
#include "ViewShell.hxx"
#endif
#ifndef SD_FRAME_VIEW
#include "FrameView.hxx"
#endif
#include "sdpage.hxx"
#include "pres.hxx"
#include "drawdoc.hxx"
#include "sdresid.hxx"
#include "bmcache.hxx"
#ifndef SD_SHOW_VIEW_HXX
#include "showview.hxx"
#endif
#include "glob.hrc"
#ifndef SD_FU_SLIDE_SELECTION_HXX
#include "fuslsel.hxx"
#endif
#include "sdxfer.hxx"
#include "sdmod.hxx"
#include "sdresid.hxx"
#include "strings.hrc"
#include "app.hrc"
#ifndef SD_ACCESSIBILITY_ACCESSIBLE_SLIDE_VIEW_HXX
#include "AccessibleSlideView.hxx"
#endif

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif

#include "sdabstdlg.hxx"

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SDR_OVERLAY_OVERLAYMANAGER_HXX
#include <svx/sdr/overlay/overlaymanager.hxx>
#endif

#ifndef _SV_VIRDEV_HXX
#include <vcl/virdev.hxx>
#endif

#ifndef _SDRPAINTWINDOW_HXX
#include <svx/sdrpaintwindow.hxx>
#endif

#include <algorithm>

using namespace ::com::sun::star;

namespace sd {

#define NAME_HEIGHT_FRACTION  (ULONG)	   25
#define NAME_OFFSET_FRACTION  (ULONG)		4
#define SELRECT_OFFSET		  (ULONG)		2
#define SELRECT_THICKNESS	  (ULONG)		2
#define BITMAPCACHE_SIZE	  (ULONG) 4000000
#define ZOOM_TOLERANCE		  (long)	  -10
#define DELAYED_PAINT_TIMEOUT (ULONG)	   50

// ---------------------
// - DelayedPaintEvent -
// ---------------------

struct DelayedPaintEvent
{
	OutputDevice* mpOut;
	Rectangle	  aRect;
};

// ---------------
// - SlideView -
// ---------------

TYPEINIT1( SlideView, ::sd::View );

// -----------------------------------------------------------------------------

SlideView::SlideView( SdDrawDocument* pDoc, ::Window* pWindow, SlideViewShell* pSlideVShell)
: ::sd::View(pDoc, pWindow, pSlideVShell)
, pSlideViewShell(pSlideVShell)
, pCache(NULL)
, pShowView(NULL)
, mpVDev(NULL)
, nAllowInvalidateSmph(0)
, nPagesPerRow(4)
, nFocusPage( SDRPAGE_NOTFOUND )
, bInPaint(FALSE)
, bInDelayedPaint(FALSE)
{
	SetAnimationEnabled( FALSE );

	aDelayedPaintTimer.SetTimeout( DELAYED_PAINT_TIMEOUT );
	aDelayedPaintTimer.SetTimeoutHdl( LINK( this,SlideView,PaintDelayed ) );
	aDelayedPaintTimer.Start();
}

// -----------------------------------------------------------------------------

SlideView::~SlideView()
{
    aDelayedPaintTimer.Stop();

	delete pCache;
	delete pShowView;
	delete mpVDev;

    for( void* pEvt = aDelayedPaints.First(); pEvt; pEvt = aDelayedPaints.Next() )
        delete static_cast< DelayedPaintEvent* >( pEvt );
}

// -----------------------------------------------------------------------------

USHORT SlideView::ChangePagesPerRow(USHORT nNum)
{
    nPagesPerRow = nNum;
    return nPagesPerRow;
}

// -----------------------------------------------------------------------------

void SlideView::InvalidateOneWin (::Window& rWin )
{
	if( IsInvalidateAllowed() )
		SdrPaintView::InvalidateOneWin(rWin);
}

// -----------------------------------------------------------------------------

void SlideView::InvalidateOneWin (::Window& rWin, const Rectangle& rRect )
{
	if( IsInvalidateAllowed() )
		SdrPaintView::InvalidateOneWin(rWin, rRect);
}

// -----------------------------------------------------------------------------

void SlideView::Paint( const Rectangle& rRect, OutputDevice* pOut )
{
    if( !bInPaint )
    {
        // set this flag to avoid 'paint in paint' calls, caused by a call to Application::Reschedule
        bInPaint = TRUE;

	    const Rectangle aOutputRect( pOut->PixelToLogic( Point() ), pOut->GetOutputSize() );
        const Color     aOldLineColor( pOut->GetLineColor() );
	    const Color     aOldFillColor( pOut->GetFillColor() );
	    SdPage*         pPage = 0;
	    USHORT	        nNoOfPages = mpDoc->GetSdPageCount(PK_STANDARD);
	    USHORT	        nPage;
	    Point	        aPos;					// Position fuer Name
	    Font	        aOldFont( pOut->GetFont() );
	    Font	        aNewFont( OutputDevice::GetDefaultFont( DEFAULTFONT_SANS_UNICODE,
	                              pOut->GetSettings().GetLanguage(), FALSE, pOut ) );

	    if( nNoOfPages > 0 )
	    {
		    pPage = mpDoc->GetSdPage( 0, PK_STANDARD );

            Size    aPageSize( pPage->GetSize() );
		    Size    aPixelSize( pOut->PixelToLogic(Size( 1, 1 ) ) );
		    Size    aCPageSize( aPageSize.Width() + aPixelSize.Width(), aPageSize.Height() + aPixelSize.Height() );
		    Size    aFontSize ( 0, pPage->GetSize().Height() / NAME_HEIGHT_FRACTION );
            Point   aNullPt;

		    aNewFont.SetSize( aFontSize );
		    aNewFont.SetTransparent( TRUE );
		    pOut->SetFont( aNewFont );

			// Paint page background
			svtools::ColorConfig aColorConfig;
			Color aFillColor = Color( aColorConfig.GetColorValue( svtools::APPBACKGROUND ).nColor );
			pOut->SetBackground(Wallpaper(aFillColor));
			pOut->Erase();

			if( pShowView )
		    {
			    // ShowView und VDev existieren schon
			    MapMode aMapMode( pOut->GetMapMode() );
			    aMapMode.SetOrigin( aNullPt);
			    mpVDev->SetMapMode( aMapMode );
			    mpVDev->SetOutputSize( aCPageSize );
                mpVDev->SetDigitLanguage (pOut->GetDigitLanguage());
			    pShowView->HideSdrPage();
		    }

			for( nPage = 0; nPage < nNoOfPages; nPage++ )
		    {
                const Rectangle aPageArea( GetPageArea( nPage ) );

                pSlideViewShell->PageVisibilityHasChanged( nPage, aOutputRect.IsOver( aPageArea ) );

			    // Seitenbereich getroffen?
			    if( rRect.IsOver( aPageArea ) )
			    {
				    pPage = mpDoc->GetSdPage(nPage, PK_STANDARD);

					SdrOutliner& rOutl=mpDoc->GetDrawOutliner(NULL);
					rOutl.SetBackgroundColor( pPage->GetBackgroundColor() );

                    Rectangle aPageRect( CalcPagePos( nPage ), aPageSize );

				    // die Seite selbst getroffen
				    if( rRect.IsOver( aPageRect ) )
				    {
					    Fraction                aScale( pOut->GetMapMode().GetScaleX() );
					    long	                nZoom = aScale.GetNumerator() * 100L / aScale.GetDenominator();
					    long                    nZoomOfBitmap = nZoom;
					    const GraphicObject*    pGraphicObject = GetFromCache( pPage, nZoomOfBitmap, ZOOM_TOLERANCE );

                        // die Seite selbst zeichnen?
					    if( bInDelayedPaint || pGraphicObject )
					    {
						    // nicht im Cache, erzeugen und in Cache stellen
						    if( !pGraphicObject )
						    {
                                // wenn noetig, virtuelles Device und View erzeugen
							    if( !pShowView )
							    {
								    mpVDev = new VirtualDevice;
								    MapMode aMapMode( pOut->GetMapMode() );
								    aMapMode.SetOrigin( aNullPt );
								    mpVDev->SetMapMode( aMapMode );
								    mpVDev->SetOutputSize( aCPageSize );
                                    mpVDev->SetDigitLanguage (pOut->GetDigitLanguage());

									// adjust contrast mode initially
									bool bUseContrast = Application::GetSettings().GetStyleSettings().GetHighContrastMode();
									mpVDev->SetDrawMode( bUseContrast
                                        ? ViewShell::OUTPUT_DRAWMODE_CONTRAST
                                        : ViewShell::OUTPUT_DRAWMODE_COLOR );

    							    pShowView = new ShowView( mpDoc, mpVDev, pSlideViewShell );
								    pShowView->SetLineDraft( IsLineDraft() );
								    pShowView->SetFillDraft( IsFillDraft() );
								    pShowView->SetTextDraft( IsTextDraft() );
								    pShowView->SetGrafDraft( IsGrafDraft() );
							    }

							    SdrPageView*    pPageView = pShowView->ShowSdrPage( pPage );
							    FrameView*      pFrameView = pSlideViewShell->GetFrameView();
							    Region          aRegion( Rectangle( aNullPt, aCPageSize ) );

                                pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );

                                // set draw-mode for rendering the cache bitmap
                                mpVDev->SetDrawMode( pFrameView->GetDrawMode() );

                                // redraw
								// Use new StandardCheckVisisbilityRedirector
								StandardCheckVisisbilityRedirector aRedirector;

								pShowView->CompleteRedraw(mpVDev, aRegion, 0, &aRedirector);
                                // #111097# IsRedrawReady() always gives sal_True while(!pShowView->IsRedrawReady()) {}

							    AddToCache( pPage, mpVDev->GetBitmap( aNullPt, aCPageSize ), nZoom );
                                pShowView->HideSdrPage();
                                pPage->ForceSwapOutObjects();
                                pGraphicObject = GetFromCache( pPage, nZoomOfBitmap, ZOOM_TOLERANCE );
						    }

                            ULONG nPreviousDrawMode( pOut->GetDrawMode());
                            // the bitmap was rendered in the correct draw-mode
                            // so use default mode to display it 'as is'
                            pOut->SetDrawMode( DRAWMODE_DEFAULT );

                            if( pGraphicObject )
                                const_cast< GraphicObject* >( pGraphicObject )->Draw( pOut, aPageRect.TopLeft(), aCPageSize );

                            pOut->SetDrawMode( nPreviousDrawMode );
					    }
					    else
					    {
    					    // spaeter zeichnen (kommt Zeit, kommt Paint)
						    DelayedPaintEvent* pEvent = new DelayedPaintEvent;

						    pEvent->aRect = aPageRect.GetIntersection(rRect);
						    pEvent->aRect.Right() += aPixelSize.Width();
						    pEvent->aRect.Bottom() += aPixelSize.Height();
						    pEvent->mpOut  = pOut;

                            aDelayedPaints.Insert(pEvent, LIST_APPEND);
					    }

					    // draw border around page (in every case)
					    pOut->SetLineColor( Color( COL_BLACK ) );
					    pOut->SetFillColor();
					    pOut->DrawRect( aPageRect );
				    }

				    if( !bInDelayedPaint )
				    {
					    // Symbol fuer Ueberblendeffekt
					    Rectangle aRect( GetFadeIconArea(nPage) );

                        if (pPage->GetFadeEffect() != presentation::FadeEffect_NONE )
					    {
						    pOut->SetLineColor( Color( COL_BLACK ) );
						    pOut->SetFillColor();
						    pOut->DrawRect(aRect);

						    pOut->SetLineColor();
						    pOut->SetFillColor( Color( COL_BLACK ) );

						    Point aTriangle[3];
						    aTriangle[0] = aRect.TopLeft();
						    aTriangle[1] = aRect.Center();
						    aTriangle[2] = aRect.BottomLeft();
						    pOut->DrawPolygon(Polygon(3, aTriangle));
					    }

					    // Name der Seite
					    aPos = CalcPagePos(nPage);

                        aPageSize = pPage->GetSize();
					    Size    aSize( pOut->PixelToLogic( Size( 0, SELRECT_OFFSET + SELRECT_THICKNESS + 2 ) ) );
					    String  aName (pPage->GetName());

					    aPos.Y() += aPageSize.Height() + aSize.Height();


				        if( !aName.Len() )
					    {
						    String aStandardName( SdResId(STR_PAGE) );
						    aName = aStandardName;
						    aName += String::CreateFromInt32( nPage + 1 );
					    }

					    if( pOut->GetTextWidth(aName) > aPageSize.Width() - 2 * aRect.GetWidth() )
					    {
						    aName.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );

                            while( pOut->GetTextWidth( aName ) > aPageSize.Width() - 2 * aRect.GetWidth() )
							    aName.Erase(aName.Len() - 4, 1);
					    }

					    // rechtsbuendig unter der Seite
					    aPos.X() += aPageSize.Width() - pOut->GetTextWidth( aName );

					    // grau hinterlegen, wenn Seite ausgeschlossen
					    if( pPage->IsExcluded() )
					    {
						    Size aTextSize( Size( pOut->GetTextWidth( aName ), pOut->GetTextHeight() ) );

						    pOut->SetFillColor( Color( COL_LIGHTGRAY ) );
						    pOut->SetLineColor();
						    pOut->DrawRect( Rectangle( aPos, aTextSize ) );
					    }

					    pOut->DrawText( aPos, aName );
                        pSlideViewShell->DrawSelectionRect( nPage );
                    }
			    }
		    }
	    }

		// paint overlay
		SdrPaintWindow* pCandidate = FindPaintWindow(*pOut);
		if(pCandidate)
		{
			// for test draw handles from new OverlayManager here
			if(pCandidate->GetOverlayManager())
			{
				Region aRectangleRegion(rRect);
				pCandidate->GetOverlayManager()->completeRedraw(aRectangleRegion);
			}
		}

		pOut->SetFont( aOldFont );
	    pOut->SetFillColor( aOldLineColor );
	    pOut->SetFillColor( aOldFillColor );

        bInPaint = FALSE;
    }
}

// -----------------------------------------------------------------------------

void SlideView::Select( USHORT nSdPageNum, BOOL bSelect )
{
	SdPage* pPage = mpDoc->GetSdPage( nSdPageNum, PK_STANDARD );

	if( pPage->IsSelected() != bSelect )
	{
        const uno::Any  aOldAny, aNewAny;
        mpDoc->SetSelected( mpDoc->GetSdPage( nSdPageNum, PK_STANDARD ), bSelect );
        pSlideViewShell->DrawSelectionRect( nSdPageNum );
        pSlideViewShell->SelectionHasChanged();
    }
}

// -----------------------------------------------------------------------------

void SlideView::SelectAllSlides( BOOL bSelect )
{
    BOOL bChanged = FALSE;

    for( USHORT i = 0, nCount = mpDoc->GetSdPageCount( PK_STANDARD ); i < nCount; ++i )
    {
    	SdPage* pPage = mpDoc->GetSdPage( i, PK_STANDARD );

        if( pPage->IsSelected() != bSelect )
        {
            mpDoc->SetSelected( mpDoc->GetSdPage( i, PK_STANDARD ), bSelect );
            pSlideViewShell->DrawSelectionRect( i );
            bChanged = TRUE;
        }
    }

    if( bChanged )
        pSlideViewShell->SelectionHasChanged();
}

// -----------------------------------------------------------------------------

void SlideView::MoveFocus( SlideViewFocusMove eMove )
{
    const USHORT nPageCount = mpDoc->GetSdPageCount( PK_STANDARD );

    if( nPageCount )
    {
        const USHORT nOldFocusPage = nFocusPage;

        if( SLIDEVIEWFOCUSMOVE_TOGGLE == eMove )
            pSlideViewShell->DrawFocusRect( nFocusPage = ( SDRPAGE_NOTFOUND == nFocusPage ) ? 0 : SDRPAGE_NOTFOUND );
        else if( SDRPAGE_NOTFOUND != nFocusPage )
        {
            if( SLIDEVIEWFOCUSMOVE_SELECT == eMove )
            {
            	SdPage* pPage = mpDoc->GetSdPage( nFocusPage, PK_STANDARD );

                if( pPage )
                    Select( nFocusPage, !pPage->IsSelected() );
            }
            else
            {
                switch( eMove )
                {
                    case( SLIDEVIEWFOCUSMOVE_LEFT ):
                        nFocusPage = ( nFocusPage ? --nFocusPage : ( nPageCount - 1 ) );
                    break;

                    case( SLIDEVIEWFOCUSMOVE_TOP ):
                    {
                        const sal_Int32 nNewFocusPage = nFocusPage - nPagesPerRow;

                        if( nNewFocusPage < 0 )
                        {
                            const USHORT    nColumn = nFocusPage % nPagesPerRow;
                            USHORT          nRow = nPageCount / nPagesPerRow;

                            if( ( nRow * nPagesPerRow + nColumn ) >= nPageCount )
                                --nRow;

                            nFocusPage = nRow * nPagesPerRow + nColumn;
                        }
                        else
                            nFocusPage = (USHORT) nNewFocusPage;
                    }
                    break;

                    case( SLIDEVIEWFOCUSMOVE_RIGHT ):
                        nFocusPage = ( nFocusPage < ( nPageCount - 1 ) ? ++nFocusPage : 0 );
                    break;

                    case( SLIDEVIEWFOCUSMOVE_BOTTOM ):
                    {
                        const sal_Int32 nNewFocusPage = nFocusPage + nPagesPerRow;

                        if( nNewFocusPage >= nPageCount )
                            nFocusPage %= nPagesPerRow;
                        else
                            nFocusPage = (USHORT) nNewFocusPage;
                    }
                    break;
					default:
						break;
                }

                pSlideViewShell->DrawFocusRect( nFocusPage );
            }
        }

        pSlideViewShell->FocusHasChanged( nOldFocusPage, nFocusPage );
    }
}

// -----------------------------------------------------------------------------

BOOL SlideView::HasFocus() const
{
    return( SDRPAGE_NOTFOUND != nFocusPage );
}

// -----------------------------------------------------------------------------

USHORT SlideView::GetFocusPage() const
{
    return( nFocusPage );
}

// -----------------------------------------------------------------------------

Point SlideView::CalcPagePos( USHORT nPageNo ) const
{
    OutputDevice*   pOut = dynamic_cast< OutputDevice* >( pSlideViewShell->GetActiveWindow() );
	Point           aResult;

	if( pOut && (mpDoc->GetSdPageCount( PK_STANDARD ) > 0) )
	{
		Size            aPageSize( mpDoc->GetSdPage( 0, PK_STANDARD )->GetSize() );
		ULONG           nGapX = GetPageGap();
		ULONG           nGapY = nGapX;
		Size            aSize( 0, SELRECT_OFFSET + SELRECT_THICKNESS + 2 );

        aSize = pOut->PixelToLogic( aSize );
		aSize.Height() += aPageSize.Height() / NAME_HEIGHT_FRACTION;

        if( (long) nGapY < aSize.Height() )
			nGapY = aSize.Height() * 2;

		aResult.X() = nPageNo % nPagesPerRow * ( nGapX + aPageSize.Width() ) + nGapX;
		aResult.Y() = nPageNo / nPagesPerRow * ( nGapY + aPageSize.Height() ) + nGapY;
	}

    return( aResult );
}

// -----------------------------------------------------------------------------

Rectangle SlideView::GetPageArea( USHORT nPageNo ) const
{
	Size    aSize( mpDoc->GetSdPage( nPageNo, PK_STANDARD )->GetSize() );
	Point   aPos( CalcPagePos( nPageNo ) );

	aSize.Height() += aSize.Height() / NAME_HEIGHT_FRACTION + aSize.Height() / NAME_HEIGHT_FRACTION / NAME_OFFSET_FRACTION;
	Rectangle aResult( aPos, aSize );

	// dazu auf jeder Seite SELRECT_OFFSET Pixel Abstand + SELRECT_THICKNESS Pixel Selektionsrahmen + 2 Pixel Toleranz
	OutputDevice*   pOut = dynamic_cast< OutputDevice* >( pSlideViewShell->GetActiveWindow() );
	if( pOut )
	{
		Size            aPixelSize( pOut->PixelToLogic( Size( 1, 1 ) ) );
		USHORT          nFactor = SELRECT_OFFSET + SELRECT_THICKNESS + 2;

		aResult.Left() -= nFactor * aPixelSize.Width();
		aResult.Right() += nFactor * aPixelSize.Width();
		aResult.Top() -= nFactor * aPixelSize.Height();
		aResult.Bottom() += nFactor * aPixelSize.Height();
	}

	return( aResult );
}

// -----------------------------------------------------------------------------

ULONG SlideView::GetPageGap() const
{
	ULONG nResult;

    if( mpDoc->GetSdPageCount( PK_STANDARD ) > 0 )
		nResult = mpDoc->GetSdPage( 0, PK_STANDARD )->GetSize().Width() / 8;
    else
        nResult = 0;

	return nResult;
}

// -----------------------------------------------------------------------------

Rectangle SlideView::GetFadeIconArea( USHORT nPageNo ) const
{
	SdPage*         pPage = mpDoc->GetSdPage( nPageNo, PK_STANDARD );
	Size	        aPageSize( pPage->GetSize() );
	Point	        aPos( CalcPagePos( nPageNo ) );
	OutputDevice*   pOut = static_cast< OutputDevice* >( pSlideViewShell->GetActiveWindow() );
	Size            aSize( 0, SELRECT_OFFSET + SELRECT_THICKNESS + 2 );

    aSize = pOut->PixelToLogic( aSize );
	aPos.Y() += aPageSize.Height() + aSize.Height();

    Rectangle aResult( aPos, Size( aPageSize.Height() / NAME_HEIGHT_FRACTION, aPageSize.Height() / NAME_HEIGHT_FRACTION ) );

    return( aResult );
}

// -----------------------------------------------------------------------------

SdPage* SlideView::GetHitPage( const Point& rPos ) const
{
    SdPage* pRet = NULL;

    for( USHORT nPage = 0, nCount = mpDoc->GetSdPageCount( PK_STANDARD ); ( nPage < nCount ) && !pRet; nPage++ )
        if( GetPageArea( nPage ).IsInside( rPos ) )
            pRet = mpDoc->GetSdPage( nPage, PK_STANDARD );

    return pRet;
}

// -----------------------------------------------------------------------------

SdPage* SlideView::GetNearestPage( const Point& rPos ) const
{
    SdPage* pRet = NULL;
    USHORT  nPageCount = mpDoc->GetSdPageCount( PK_STANDARD );

    if( nPageCount )
    {
        Point       aCenter( GetPageArea( 0 ).Center() );
        USHORT      nBestPage = 0;
        double      fBestDist = hypot( rPos.X() - aCenter.X(), rPos.Y() - aCenter.Y() );

        for( USHORT nPage = 1; nPage < nPageCount; nPage++ )
        {
            aCenter = GetPageArea( nPage ).Center();
            const double fDist = hypot( rPos.X() - aCenter.X(), rPos.Y() - aCenter.Y() );

            if( fDist < fBestDist )
            {
                nBestPage = nPage;
                fBestDist = fDist;

            }
        }

        pRet = mpDoc->GetSdPage( nBestPage, PK_STANDARD );
    }

    return pRet;
}

// -----------------------------------------------------------------------------

SdPage* SlideView::GetFadePage( const Point& rPos ) const
{
    SdPage* pRet = NULL;

    for( USHORT nPage = 0, nCount = mpDoc->GetSdPageCount( PK_STANDARD ); ( nPage < nCount ) && !pRet; nPage++ )
        if( GetFadeIconArea( nPage ).IsInside( rPos ) )
            pRet = mpDoc->GetSdPage( nPage, PK_STANDARD );

    return pRet;
}

// -----------------------------------------------------------------------------

void SlideView::AddToCache( SdPage* pPage, const Bitmap& rBitmap, long nZoom )
{
	if( !pCache )
        pCache = new BitmapCache( BITMAPCACHE_SIZE );

    pCache->Add(pPage, rBitmap, nZoom);
}

// -----------------------------------------------------------------------------

const GraphicObject* SlideView::GetFromCache( SdPage* pPage, long& rZoom, long nZoomTolerance) const
{
	const GraphicObject* pGraphicObject = NULL;

    if( pCache )
		pGraphicObject = pCache->Get( pPage, rZoom, nZoomTolerance );

	return pGraphicObject;
}

// -----------------------------------------------------------------------------

IMPL_LINK( SlideView, PaintDelayed, Timer *, pTimer )
{
	do
	{
		if( aDelayedPaints.Count() > 0 )
		{
			bool bIsShowingEffect = false;

			{
				FunctionReference xFunc( pSlideViewShell->GetCurrentFunction() );
				if( xFunc.is() && xFunc->ISA(FuSlideSelection) )
					bIsShowingEffect = static_cast<FuSlideSelection*>(xFunc.get())->IsShowingEffect() ? true : false;
			}

            if(!bIsShowingEffect)
			{
				DelayedPaintEvent* pEvent = static_cast< DelayedPaintEvent* >( aDelayedPaints.Remove( (ULONG) 0 ) );

                bInDelayedPaint = TRUE;

				if( OUTDEV_WINDOW == pEvent->mpOut->GetOutDevType() )
				{
					static_cast< Window* >( pEvent->mpOut )->Invalidate( pEvent->aRect );
					static_cast< Window* >( pEvent->mpOut )->Update();
				}
				else
					Paint( pEvent->aRect, pEvent->mpOut );

				bInDelayedPaint = FALSE;
				delete pEvent;
			}
		}
	}
	while (!GetpApp()->AnyInput() && aDelayedPaints.Count() > 0 );

	pTimer->Start();

    return 0;
}

// -----------------------------------------------------------------------------

void SlideView::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
							           const SfxHint& rHint, const TypeId& rHintType)
{
	SdrHint* pSdrHint = PTR_CAST( SdrHint, &rHint );

	if( pSdrHint )
	{
		SdrHintKind eHint = pSdrHint->GetKind();

		if( eHint == HINT_PAGEORDERCHG )
		{
			InvalidateAllWin();
		}
		else
		{
			const SdrPage* pChangedPage = pSdrHint->GetPage();

			if( pChangedPage )
			{
				if( pChangedPage->IsMasterPage() )
				{
					if( pCache )
						delete pCache, pCache = NULL;
				}
				else
				{
					SdrPageView* pPageView = GetSdrPageView();

					if( pPageView && pCache )
					    pCache->Remove( (SdPage*) pChangedPage );
				}
			}
		}
	}

	::sd::View::SFX_NOTIFY( rBC, rBCType, rHint, rHintType );
}

// -----------------------------------------------------------------------------

void SlideView::SetAllowInvalidate(BOOL bFlag)
{
	if( !bFlag )
		nAllowInvalidateSmph++;
	else if( nAllowInvalidateSmph > 0 )
		nAllowInvalidateSmph--;
}

// -----------------------------------------------------------------------------

BOOL SlideView::IsInvalidateAllowed() const
{
	return( nAllowInvalidateSmph == 0 );
}

// -----------------------------------------------------------------------------

void SlideView::DeleteMarked()
{
	String  aStr( SdResId( STR_UNDO_DELETEPAGES ) );
	USHORT  nPage = 0, nOldFocusPage = nFocusPage;
	SdPage* pPage = mpDoc->GetSdPage( nPage, PK_STANDARD );

    // hide focus if necessary
    if( SDRPAGE_NOTFOUND != nOldFocusPage )
        pSlideViewShell->DrawFocusRect( nFocusPage = SDRPAGE_NOTFOUND );

    BegUndo( aStr );

	while( pPage )
	{
		pPage = mpDoc->GetSdPage( nPage, PK_STANDARD );

		if( pPage->IsSelected() && mpDoc->GetSdPageCount( PK_STANDARD ) > 1 )
		{
			AddUndo( mpDoc->GetSdrUndoFactory().CreateUndoDeletePage( *pPage ) );
			mpDoc->RemovePage( pPage->GetPageNum() );
			pPage = mpDoc->GetSdPage( nPage, PK_NOTES );
			AddUndo( mpDoc->GetSdrUndoFactory().CreateUndoDeletePage( *pPage ) );
			mpDoc->RemovePage( pPage->GetPageNum() );
		}
		else
			nPage++;

		pPage = mpDoc->GetSdPage( nPage, PK_STANDARD );
	}

	EndUndo();

    // show focus if necessary
    const USHORT nNewPageCount = mpDoc->GetSdPageCount( PK_STANDARD );
    if( ( SDRPAGE_NOTFOUND != nOldFocusPage ) && nNewPageCount )
        pSlideViewShell->DrawFocusRect( nFocusPage = (USHORT) Min( (ULONG) nOldFocusPage, (ULONG) nNewPageCount - 1 ) );
}

// -----------------------------------------------------------------------------

void SlideView::MoveMarked( USHORT nTargetPage )
{
	String                      aComment ( SdResId( STR_UNDO_SLIDE_MOVE ) );
	USHORT	                    nPage, nNoOfPages = mpDoc->GetSdPageCount( PK_STANDARD );
    ::std::vector< SdPage* >    aOldPageVect( nNoOfPages );

	for( nPage = 0; nPage < nNoOfPages; nPage++ )
		aOldPageVect[ nPage ] = mpDoc->GetSdPage( nPage, PK_STANDARD );

	SetAllowInvalidate( FALSE );
	BOOL bMoved = mpDoc->MovePages( nTargetPage );
	SetAllowInvalidate( TRUE );

	if( bMoved )
	{
        ::std::vector< SdPage* > aNewPageVect( nNoOfPages );

		for( nPage = 0; nPage < nNoOfPages; nPage++ )
		    aNewPageVect[ nPage ] = mpDoc->GetSdPage( nPage, PK_STANDARD );

		for( nPage = 0; nPage < nNoOfPages; nPage++ )
		{
			if( aNewPageVect[ nPage ] != aOldPageVect[ nPage ] )
			{
				InvalidateAllWin( GetPageArea( nPage ) );
				mpViewSh->UpdateWindows();
			}
		}
	}
}

// -----------------------------------------------------------------------------

void SlideView::CreateSlideTransferable (::Window* pWindow, BOOL bDrag )
{
	List	aBookmarkList;
	SdPage* pPage = NULL;

	for( USHORT nPage = 0, nPgCnt = mpDoc->GetSdPageCount( PK_STANDARD ); nPage < nPgCnt; nPage++ )
	{
		pPage = mpDoc->GetSdPage( nPage, PK_STANDARD );

		if( pPage->IsSelected() )
			aBookmarkList.Insert( new String( pPage->GetName() ), LIST_APPEND );
	}

	if( aBookmarkList.Count() )
	{
		BrkAction();

    	SdTransferable* pTransferable = new SdTransferable( mpDoc, NULL, FALSE );
	    ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > xRet( pTransferable );
    	TransferableObjectDescriptor aObjDesc;

        if( bDrag )
    	    SD_MOD()->pTransferDrag = pTransferable;
        else
    	    SD_MOD()->pTransferClip = pTransferable;

	    mpDoc->CreatingDataObj( pTransferable );
	    pTransferable->SetWorkDocument( (SdDrawDocument*) GetAllMarkedModel() );
	    mpDoc->CreatingDataObj( NULL );
        pTransferable->GetWorkDocument()->GetDocSh()->FillTransferableObjectDescriptor( aObjDesc );

	    if( mpDocSh )
		    aObjDesc.maDisplayName = mpDocSh->GetMedium()->GetURLObject().GetURLNoPass();

        ::Window* pActionWindow = ( pWindow ? pWindow : mpViewSh->GetActiveWindow() );

    	pTransferable->SetStartPos( pActionWindow->PixelToLogic( pActionWindow->GetPointerPosPixel() ) );
    	pTransferable->SetObjectDescriptor( aObjDesc );
		pTransferable->SetPageBookmarks( aBookmarkList, !bDrag );

		for( void* p = aBookmarkList.First(); p; p = aBookmarkList.Next() )
			delete static_cast< String* >( p );

        if( bDrag )
        {
            pTransferable->SetView( this );
    	    pTransferable->StartDrag( pActionWindow, DND_ACTION_COPY | DND_ACTION_MOVE );
        }
        else
    	    pTransferable->CopyToClipboard( pActionWindow );
	}
}

// -----------------------------------------------------------------------------

void SlideView::DoCut (::Window* pWindow )
{
	if( mpDoc->GetSdPageCount( PK_STANDARD ) > 1 )
	{
		DoCopy( pWindow );
		DeleteMarked();
	}
}

// -----------------------------------------------------------------------------

void SlideView::DoCopy (::Window* pWindow )
{
    CreateSlideTransferable( pWindow, FALSE );
}

// -----------------------------------------------------------------------------

void SlideView::DoPaste (::Window* pWindow )
{
    SdTransferable* pClipTransferable = SD_MOD()->pTransferClip;

    if( pClipTransferable && pClipTransferable->IsPageTransferable() )
    {
		USHORT	nInsertPgCnt, nInsertPos = 0; // mpDoc->GetSdPageCount( PK_STANDARD ) * 2 + 1;
		BOOL	bMergeMasterPages = !pClipTransferable->HasSourceDoc( mpDoc );

		USHORT nCount = mpDoc->GetSdPageCount( PK_STANDARD );
		while( (nInsertPos < nCount) && !mpDoc->GetSdPage( nInsertPos, PK_STANDARD )->IsSelected() )
			nInsertPos++;

		if( nInsertPos < nCount )
			nInsertPos++;

		nInsertPos = nInsertPos * 2 + 1;

        if( HasFocus() )
        {
			SdAbstractDialogFactory* pFact = SdAbstractDialogFactory::Create();
			AbstractSdInsertPasteDlg* pDlg = pFact ? pFact->CreateSdInsertPasteDlg( pWindow ) : 0;
            
			USHORT nRet = RET_CANCEL;
			if( pDlg )
			{
				nRet = pDlg->Execute();
	            nInsertPos = GetFocusPage() * 2 + ( pDlg->IsInsertBefore() ? 1 : 3 );
				delete pDlg;
				if( nRet != RET_OK )
					return;
			}
        }

        if( pClipTransferable->HasPageBookmarks() )
        {
            const List&         rBookmarkList = pClipTransferable->GetPageBookmarks();
            const ::vos::OGuard aGuard( Application::GetSolarMutex() );

            nInsertPgCnt = (USHORT) rBookmarkList.Count();
		    mpDoc->InsertBookmarkAsPage( const_cast< List* >( &rBookmarkList ), NULL, FALSE, FALSE, nInsertPos,
                                        FALSE, pClipTransferable->GetPageDocShell(), TRUE, bMergeMasterPages, FALSE );
        }
        else
        {
            SfxObjectShell*   pObj = pClipTransferable->GetDocShell();
			DrawDocShell*		pDataDocSh = (DrawDocShell*) pObj;
			SdDrawDocument*		pDataDoc = pDataDocSh->GetDoc();

			if( pDataDoc && pDataDoc->GetSdPageCount( PK_STANDARD ) )
			{
                const ::vos::OGuard aGuard( Application::GetSolarMutex() );

                nInsertPgCnt = pDataDoc->GetSdPageCount( PK_STANDARD );
				mpDoc->InsertBookmarkAsPage( NULL, NULL, FALSE, FALSE, nInsertPos,
                                            FALSE, pDataDocSh, TRUE, bMergeMasterPages, FALSE );
			}
        }

	    SfxUInt16Item aItem( SID_PAGES_PER_ROW, nPagesPerRow);

	    ( mpDocSh->GetViewShell() ? mpDocSh->GetViewShell()->GetViewFrame() : SfxViewFrame::Current() )->GetDispatcher()->Execute(
		    SID_PAGES_PER_ROW, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L, 0L );
    }
}

// -----------------------------------------------------------------------------

void SlideView::StartDrag( const Point&, ::Window* pWindow )
{
    CreateSlideTransferable( pWindow, TRUE );
}

// -----------------------------------------------------------------------------

void SlideView::DragFinished( sal_Int8 nDropAction )
{
	SdTransferable* pDragTransferable = SD_MOD()->pTransferDrag;

	if( pDragTransferable )
		pDragTransferable->SetView( NULL );

	if( nDropAction & DND_ACTION_MOVE )
        DeleteMarked();
}

// -----------------------------------------------------------------------------

sal_Int8 SlideView::AcceptDrop( const AcceptDropEvent& rEvt, DropTargetHelper&, ::sd::Window*, USHORT, USHORT)
{
    SdTransferable* pDragTransferable = SD_MOD()->pTransferDrag;
    sal_Int8        nRet = DND_ACTION_NONE;

    if( pDragTransferable && pDragTransferable->IsPageTransferable() )
        nRet = rEvt.mnAction;

    return nRet;
}

// -----------------------------------------------------------------------------

sal_Int8 SlideView::ExecuteDrop( const ExecuteDropEvent& rEvt, DropTargetHelper&, ::sd::Window* pTargetWindow, USHORT, USHORT)
{
    SdTransferable* pDragTransferable = SD_MOD()->pTransferDrag;
    sal_Int8        nRet = DND_ACTION_NONE;

    if( pDragTransferable && pDragTransferable->IsPageTransferable() )
    {
        const Point aEvtPos( pTargetWindow->PixelToLogic( rEvt.maPosPixel ) );
        const BOOL  bCont = ( pDragTransferable->GetView() != this ) ||
                            ( ( labs( pDragTransferable->GetStartPos().X() - aEvtPos.X() ) >= 2 ) &&
                              ( labs( pDragTransferable->GetStartPos().Y() - aEvtPos.Y() ) >= 2 ) );

        if( bCont )
        {
            SdPage* pNearestSdPage = GetNearestPage( aEvtPos );
            USHORT  nNearestSdPagePos = pNearestSdPage ? ( ( pNearestSdPage->GetPageNum() - 1 ) / 2 ) : ( mpDoc->GetSdPageCount( PK_STANDARD ) - 1 );

            if( ( pDragTransferable->GetView() == this ) && ( DND_ACTION_MOVE == rEvt.mnAction ) )
            {
                MoveMarked( nNearestSdPagePos );
                nRet = DND_ACTION_NONE;
            }
            else
            {
		        USHORT	nInsertPgCnt, nInsertPos = ( nNearestSdPagePos + 1 ) * 2 + 1;
                BOOL    bMergeMasterPages = !pDragTransferable->HasSourceDoc( mpDoc );

                if( pDragTransferable->HasPageBookmarks() )
                {
                    const List& rBookmarkList = pDragTransferable->GetPageBookmarks();

                    nInsertPgCnt = (USHORT) rBookmarkList.Count();
		            mpDoc->InsertBookmarkAsPage( const_cast< List* >( &rBookmarkList ), NULL, FALSE, FALSE, nInsertPos, TRUE, pDragTransferable->GetPageDocShell(), TRUE, bMergeMasterPages, FALSE );
                }
                else
                {
                    SfxObjectShell*   pObj = pDragTransferable->GetDocShell();
		            DrawDocShell*		pDataDocSh = pDragTransferable->HasPageBookmarks() ? pDragTransferable->GetPageDocShell() : ( (DrawDocShell*) pObj );
		            SdDrawDocument*		pDataDoc = pDataDocSh->GetDoc();

                    nInsertPgCnt = pDataDoc->GetSdPageCount( PK_STANDARD );
		            mpDoc->InsertBookmarkAsPage( NULL, NULL, FALSE, FALSE, nInsertPos, TRUE, pDataDocSh, TRUE, bMergeMasterPages, FALSE );
                }

		        // deselect all pages
		        for( USHORT nPage = 0, nPgCnt = mpDoc->GetSdPageCount( PK_STANDARD ); nPage < nPgCnt; nPage++ )
			        mpDoc->GetSdPage( nPage, PK_STANDARD )->SetSelected( FALSE );

		        // select inserted pages
                for( USHORT i = 1; i <= nInsertPgCnt; i++ )
                {
    		        SdPage*	pPage = mpDoc->GetSdPage( nNearestSdPagePos + i, PK_STANDARD );

	    	        if( pPage )
		    	        pPage->SetSelected( TRUE );
                }

                // Update
                ( (SlideViewShell*) mpViewSh )->SetPagesPerRow( nPagesPerRow );
                nRet = rEvt.mnAction;
            }
        }
    }

	return nRet;
}

// -----------------------------------------------------------------------------

void SlideView::UpdateAllPages()
{
	delete pCache, pCache = NULL;
	InvalidateAllWin();
}

} // end of namespace sd
