/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccessibleBrowseBoxHeaderCell.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 14:14:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svtools.hxx"

#include "AccessibleBrowseBoxHeaderCell.hxx"

#ifndef _SVTOOLS_ACCESSIBLETABLEPROVIDER_HXX
#include "accessibletableprovider.hxx"
#endif
#ifndef _SVTOOLS_ACCESSIBLEBROWSEBOX_HXX
#include "AccessibleBrowseBox.hxx"
#endif

namespace svt
{
	using namespace ::com::sun::star::accessibility;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::uno;

AccessibleBrowseBoxHeaderCell::AccessibleBrowseBoxHeaderCell(sal_Int32 _nColumnRowId,
								  const Reference< XAccessible >& rxParent,
								  IAccessibleTableProvider&                  rBrowseBox,
								  const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >& _xFocusWindow,
								  AccessibleBrowseBoxObjType  eObjType)
: BrowseBoxAccessibleElement(rxParent,
						  rBrowseBox,
						  _xFocusWindow,
						  eObjType,
						  rBrowseBox.GetAccessibleObjectName( eObjType ,_nColumnRowId),
						  rBrowseBox.GetAccessibleObjectDescription( eObjType ,_nColumnRowId))
, m_nColumnRowId(_nColumnRowId)
{
}
/** Creates a new AccessibleStateSetHelper and fills it with states of the
	current object.
	@return
		A filled AccessibleStateSetHelper.
*/
::utl::AccessibleStateSetHelper* AccessibleBrowseBoxHeaderCell::implCreateStateSetHelper()
{
	::osl::MutexGuard aGuard( getOslMutex() );
	::utl::AccessibleStateSetHelper*
		pStateSetHelper = new ::utl::AccessibleStateSetHelper;

	if( isAlive() )
	{
		// SHOWING done with mxParent
		if( implIsShowing() )
			pStateSetHelper->AddState( AccessibleStateType::SHOWING );

		BBSolarGuard aSolarGuard;
		pStateSetHelper->AddState( AccessibleStateType::VISIBLE );
		pStateSetHelper->AddState( AccessibleStateType::FOCUSABLE );
		pStateSetHelper->AddState( AccessibleStateType::TRANSIENT );
		pStateSetHelper->AddState( AccessibleStateType::SELECTABLE );

		sal_Bool bSelected = isRowBarCell() ? mpBrowseBox->IsRowSelected(m_nColumnRowId) : mpBrowseBox->IsColumnSelected(m_nColumnRowId);
		if ( bSelected )
			pStateSetHelper->AddState( AccessibleStateType::SELECTED );
	}
	else
		pStateSetHelper->AddState( AccessibleStateType::DEFUNC );

	return pStateSetHelper;
}
// -----------------------------------------------------------------------------
/** @return
		The count of visible children.
*/
sal_Int32 SAL_CALL AccessibleBrowseBoxHeaderCell::getAccessibleChildCount()
	throw ( RuntimeException )
{
	return 0;
}
// -----------------------------------------------------------------------------

/** @return
		The XAccessible interface of the specified child.
*/
Reference<XAccessible > SAL_CALL AccessibleBrowseBoxHeaderCell::getAccessibleChild( sal_Int32 )
	throw ( IndexOutOfBoundsException,RuntimeException )
{
	throw IndexOutOfBoundsException();
}
// -----------------------------------------------------------------------------

/** Grabs the focus to the column header. */
void SAL_CALL AccessibleBrowseBoxHeaderCell::grabFocus()
	throw ( ::com::sun::star::uno::RuntimeException )
{
	BBSolarGuard aSolarGuard;
	::osl::MutexGuard aGuard( getOslMutex() );
	ensureIsAlive();
	if ( isRowBarCell() )
		mpBrowseBox->SelectRow(m_nColumnRowId);
	else
		mpBrowseBox->SelectColumn(static_cast<sal_uInt16>(m_nColumnRowId)); //!!!
}
// -----------------------------------------------------------------------------
/** @return
		The name of this class.
*/
::rtl::OUString SAL_CALL AccessibleBrowseBoxHeaderCell::getImplementationName()
	throw ( ::com::sun::star::uno::RuntimeException )
{
	return ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.svtools.AccessibleBrowseBoxHeaderCell" ) );
}
// -----------------------------------------------------------------------------
namespace
{
	Rectangle getRectangle(IAccessibleTableProvider* _pBrowseBox,sal_Int32 _nRowColIndex, BOOL _bOnScreen,BOOL _bRowBar)
	{
		sal_Int32 nRow  = 0;
		sal_uInt16 nCol =  (sal_uInt16)_nRowColIndex;
		if ( _bRowBar )
		{
			nRow = _nRowColIndex + 1;
			nCol = 0;
		}

		Rectangle aRet(_pBrowseBox->GetFieldRectPixelAbs( nRow , nCol, TRUE, _bOnScreen));
		return Rectangle(aRet.TopLeft() - Point(0,aRet.GetHeight()),aRet.GetSize());
	}
}

Rectangle AccessibleBrowseBoxHeaderCell::implGetBoundingBox()
{
	return getRectangle(mpBrowseBox,m_nColumnRowId,FALSE,isRowBarCell());
}
// -----------------------------------------------------------------------------

Rectangle AccessibleBrowseBoxHeaderCell::implGetBoundingBoxOnScreen()
{
	return getRectangle(mpBrowseBox,m_nColumnRowId,TRUE,isRowBarCell());
}
// -----------------------------------------------------------------------------
sal_Int32 SAL_CALL AccessibleBrowseBoxHeaderCell::getAccessibleIndexInParent()
    throw ( RuntimeException )
{
    ::osl::MutexGuard aGuard( getOslMutex() );
    ensureIsAlive();
	sal_Int32 nIndex = m_nColumnRowId;
	if ( mpBrowseBox->HasRowHeader() )
		--nIndex;
	return nIndex;
}
// -----------------------------------------------------------------------------
} // namespace svt
// -----------------------------------------------------------------------------


