/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: captionproperties.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 13:35:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifndef _SDR_PROPERTIES_CAPTIONPROPERTIES_HXX
#include <svx/sdr/properties/captionproperties.hxx>
#endif

#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif

#ifndef _SFXSTYLE_HXX
#include <svtools/style.hxx>
#endif

#ifndef _SVDDEF_HXX
#include <svddef.hxx>
#endif

#ifndef _EEITEM_HXX
#include <eeitem.hxx>
#endif

#ifndef _SVDCAPT_HXX
#include <svdocapt.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		// create a new itemset
		SfxItemSet& CaptionProperties::CreateObjectSpecificItemSet(SfxItemPool& rPool)
		{
			return *(new SfxItemSet(rPool,

				// range from SdrAttrObj
				SDRATTR_START, SDRATTR_SHADOW_LAST,
				SDRATTR_MISC_FIRST, SDRATTR_MISC_LAST,
				SDRATTR_TEXTDIRECTION, SDRATTR_TEXTDIRECTION,

				// range from SdrCaptionObj
				SDRATTR_CAPTION_FIRST, SDRATTR_CAPTION_LAST,

				// range from SdrTextObj
				EE_ITEMS_START, EE_ITEMS_END,

				// end
				0, 0));
		}

		CaptionProperties::CaptionProperties(SdrObject& rObj)
		:	RectangleProperties(rObj)
		{
		}

		CaptionProperties::CaptionProperties(const CaptionProperties& rProps, SdrObject& rObj)
		:	RectangleProperties(rProps, rObj)
		{
		}

		CaptionProperties::~CaptionProperties()
		{
		}
		
		BaseProperties& CaptionProperties::Clone(SdrObject& rObj) const
		{
			return *(new CaptionProperties(*this, rObj));
		}

		void CaptionProperties::ItemSetChanged(const SfxItemSet& rSet)
		{
			SdrCaptionObj& rObj = (SdrCaptionObj&)GetSdrObject();

			// local changes
			rObj.ImpRecalcTail();

			// call parent
			RectangleProperties::ItemSetChanged(rSet);
		}

		void CaptionProperties::SetStyleSheet(SfxStyleSheet* pNewStyleSheet, sal_Bool bDontRemoveHardAttr)
		{
			SdrCaptionObj& rObj = (SdrCaptionObj&)GetSdrObject();

			// call parent
			RectangleProperties::SetStyleSheet(pNewStyleSheet, bDontRemoveHardAttr);

			// local changes
			rObj.ImpRecalcTail();
		}

		void CaptionProperties::ForceDefaultAttributes()
		{
			// call parent
			RectangleProperties::ForceDefaultAttributes();

			// force ItemSet
			GetObjectItemSet();

			// this was set by TextProperties::ForceDefaultAttributes(),
			// retet to default
			mpItemSet->ClearItem(XATTR_LINESTYLE);
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
