/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svdovirt.cxx,v $
 *
 *  $Revision: 1.17.86.1 $
 *
 *  last change: $Author: rt $ $Date: 2007/01/19 14:15:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#include "svdovirt.hxx"
#include "xpool.hxx"
#include "svdxout.hxx"
#include "svdtrans.hxx"
#include "svdetc.hxx"
#include "svdhdl.hxx"

#ifndef _SDR_CONTACT_VIEWCONTACTOFVIRTOBJ_HXX
#include <svx/sdr/contact/viewcontactofvirtobj.hxx>
#endif

#ifndef _BGFX_MATRIX_B2DHOMMATRIX_HXX
#include <basegfx/matrix/b2dhommatrix.hxx>
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////

sdr::properties::BaseProperties& SdrVirtObj::GetProperties() const
{
	return rRefObj.GetProperties();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// AW, OD 2004-05-03 #i27224#
sdr::contact::ViewContact* SdrVirtObj::CreateObjectSpecificViewContact()
{
	return new sdr::contact::ViewContactOfVirtObj(*this);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

TYPEINIT1(SdrVirtObj,SdrObject);

SdrVirtObj::SdrVirtObj(SdrObject& rNewObj):
	rRefObj(rNewObj)
{
	bVirtObj=TRUE; // Ja, ich bin ein virtuelles Objekt
	rRefObj.AddReference(*this);
	bClosedObj=rRefObj.IsClosedObj();
}

SdrVirtObj::SdrVirtObj(SdrObject& rNewObj, const Point& rAnchorPos):
	rRefObj(rNewObj)
{
	aAnchor=rAnchorPos;
	bVirtObj=TRUE; // Ja, ich bin ein virtuelles Objekt
	rRefObj.AddReference(*this);
	bClosedObj=rRefObj.IsClosedObj();
}

SdrVirtObj::~SdrVirtObj()
{
	rRefObj.DelReference(*this);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

const SdrObject& SdrVirtObj::GetReferencedObj() const
{
	return rRefObj;
}

SdrObject& SdrVirtObj::ReferencedObj()
{
	return rRefObj;
}

void __EXPORT SdrVirtObj::SFX_NOTIFY(SfxBroadcaster& /*rBC*/, const TypeId& rBCType, const SfxHint& /*rHint*/, const TypeId& rHintType)
{
	bClosedObj=rRefObj.IsClosedObj();
	SetRectsDirty(); // hier noch Optimieren.

	// Only a repaint here, rRefObj may have changed and broadcasts
	ActionChanged();
	// BroadcastObjectChange();
}

void SdrVirtObj::NbcSetAnchorPos(const Point& rAnchorPos)
{
	aAnchor=rAnchorPos;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

void SdrVirtObj::SetModel(SdrModel* pNewModel)
{
	SdrObject::SetModel(pNewModel);
	rRefObj.SetModel(pNewModel);
}

void SdrVirtObj::TakeObjInfo(SdrObjTransformInfoRec& rInfo) const
{
	rRefObj.TakeObjInfo(rInfo);
}

UINT32 SdrVirtObj::GetObjInventor() const
{
	return rRefObj.GetObjInventor();
}

UINT16 SdrVirtObj::GetObjIdentifier() const
{
	return rRefObj.GetObjIdentifier();
}

SdrObjList* SdrVirtObj::GetSubList() const
{
	return rRefObj.GetSubList();
}

const Rectangle& SdrVirtObj::GetCurrentBoundRect() const
{
	((SdrVirtObj*)this)->aOutRect=rRefObj.GetCurrentBoundRect(); // Hier noch optimieren
	((SdrVirtObj*)this)->aOutRect+=aAnchor;
	return aOutRect;
}

const Rectangle& SdrVirtObj::GetLastBoundRect() const
{
	((SdrVirtObj*)this)->aOutRect=rRefObj.GetLastBoundRect(); // Hier noch optimieren
	((SdrVirtObj*)this)->aOutRect+=aAnchor;
	return aOutRect;
}

void SdrVirtObj::RecalcBoundRect()
{
	aOutRect=rRefObj.GetCurrentBoundRect();
	aOutRect+=aAnchor;
}

void SdrVirtObj::SetChanged()
{
	SdrObject::SetChanged();
}

sal_Bool SdrVirtObj::DoPaintObject(XOutputDevice& rOut, const SdrPaintInfoRec& rInfoRec) const
{
	Point aOfs(rOut.GetOffset());
	rOut.SetOffset(aOfs+aAnchor);
	sal_Bool bRet(rRefObj.DoPaintObject(rOut, rInfoRec));
	rOut.SetOffset(aOfs);
	return bRet;
}

SdrObject* SdrVirtObj::CheckHit(const Point& rPnt, USHORT nTol, const SetOfByte* pVisiLayer) const
{
	Point aPnt(rPnt-aAnchor);
	FASTBOOL bRet=rRefObj.CheckHit(aPnt,nTol,pVisiLayer)!=NULL;
	return bRet ? (SdrObject*)this : NULL;
}

SdrObject* SdrVirtObj::Clone() const
{
	SdrObject* pObj=new SdrVirtObj(((SdrVirtObj*)this)->rRefObj); // Nur eine weitere Referenz
	return pObj;
}

void SdrVirtObj::operator=(const SdrObject& rObj)
{   // ???anderes Objekt referenzieren???
	SdrObject::operator=(rObj);
	aAnchor=((SdrVirtObj&)rObj).aAnchor;
}

void SdrVirtObj::TakeObjNameSingul(XubString& rName) const
{
	rRefObj.TakeObjNameSingul(rName);
	rName.Insert(sal_Unicode('['), 0);
	rName += sal_Unicode(']');

	String aName( GetName() );
	if(aName.Len())
	{
		rName += sal_Unicode(' ');
		rName += sal_Unicode('\'');
		rName += aName;
		rName += sal_Unicode('\'');
	}
}

void SdrVirtObj::TakeObjNamePlural(XubString& rName) const
{
	rRefObj.TakeObjNamePlural(rName);
	rName.Insert(sal_Unicode('['), 0);
	rName += sal_Unicode(']');
}

void operator +=(PolyPolygon& rPoly, const Point& rOfs)
{
	if (rOfs.X()!=0 || rOfs.Y()!=0) {
		USHORT i,j;
		for (j=0; j<rPoly.Count(); j++) {
			Polygon aP1(rPoly.GetObject(j));
			for (i=0; i<aP1.GetSize(); i++) {
				 aP1[i]+=rOfs;
			}
			rPoly.Replace(aP1,j);
		}
	}
}

basegfx::B2DPolyPolygon SdrVirtObj::TakeXorPoly(sal_Bool bDetail) const
{
	basegfx::B2DPolyPolygon aPolyPolygon(rRefObj.TakeXorPoly(bDetail));

	if(aAnchor.X() || aAnchor.Y())
	{
		basegfx::B2DHomMatrix aMatrix;
		aMatrix.translate(aAnchor.X(), aAnchor.Y());
		aPolyPolygon.transform(aMatrix);
	}

	return aPolyPolygon;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

sal_uInt32 SdrVirtObj::GetHdlCount() const
{
	return rRefObj.GetHdlCount();
}

SdrHdl* SdrVirtObj::GetHdl(sal_uInt32 nHdlNum) const
{
	SdrHdl* pHdl=rRefObj.GetHdl(nHdlNum);

	// #i73248#
	// GetHdl() at SdrObject is not guaranteed to return an object
	if(pHdl)
	{
		Point aP(pHdl->GetPos()+aAnchor);
		pHdl->SetPos(aP);
	}

	return pHdl;
}

sal_uInt32 SdrVirtObj::GetPlusHdlCount(const SdrHdl& rHdl) const
{
	return rRefObj.GetPlusHdlCount(rHdl);
}

SdrHdl* SdrVirtObj::GetPlusHdl(const SdrHdl& rHdl, sal_uInt32 nPlNum) const
{
	SdrHdl* pHdl=rRefObj.GetPlusHdl(rHdl,nPlNum);
	pHdl->SetPos(pHdl->GetPos() + aAnchor);
	return pHdl;
}

void SdrVirtObj::AddToHdlList(SdrHdlList& rHdlList) const
{
	// #i73248#
	// SdrObject::AddToHdlList(rHdlList) is not a good thing to call
	// since at SdrPathObj, only AddToHdlList may be used and the call
	// will instead use the standard implementation which uses GetHdlCount()
	// and GetHdl instead. This is not wrong, but may be much less effective
	// and may not be prepared to GetHdl returning NULL

	// get handles using AddToHdlList from ref object
	SdrHdlList aLocalList(0);
	rRefObj.AddToHdlList(aLocalList);
	const sal_uInt32 nHdlCount(aLocalList.GetHdlCount());

	if(nHdlCount)
	{
		// translate handles and add them to dest list. They are temporarily part of
		// two lists then
		const Point aOffset(GetOffset());

		for(sal_uInt32 a(0L); a < nHdlCount; a++)
		{
			SdrHdl* pCandidate = aLocalList.GetHdl(a);
			pCandidate->SetPos(pCandidate->GetPos() + aOffset);
			rHdlList.AddHdl(pCandidate);
		}

		// remove them from source list, else they will be deleted when
		// source list is deleted
		while(aLocalList.GetHdlCount())
		{
			aLocalList.RemoveHdl(aLocalList.GetHdlCount() - 1L);
		}
	}
}

FASTBOOL SdrVirtObj::HasSpecialDrag() const
{
	return rRefObj.HasSpecialDrag();
}

FASTBOOL SdrVirtObj::BegDrag(SdrDragStat& rDrag) const
{
	return rRefObj.BegDrag(rDrag);
}

FASTBOOL SdrVirtObj::MovDrag(SdrDragStat& rDrag) const
{
	return rRefObj.MovDrag(rDrag);
}

FASTBOOL SdrVirtObj::EndDrag(SdrDragStat& rDrag)
{
	return rRefObj.EndDrag(rDrag);
}

void SdrVirtObj::BrkDrag(SdrDragStat& rDrag) const
{
	rRefObj.BrkDrag(rDrag);
}

basegfx::B2DPolyPolygon SdrVirtObj::TakeDragPoly(const SdrDragStat& rDrag) const
{
	return rRefObj.TakeDragPoly(rDrag);
	// Offset handlen !!!!!! fehlt noch !!!!!!!
}

XubString SdrVirtObj::GetDragComment(const SdrDragStat& rDrag, FASTBOOL bUndoDragComment, FASTBOOL bCreateComment) const
{
	return rRefObj.GetDragComment(rDrag,bUndoDragComment,bCreateComment);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

FASTBOOL SdrVirtObj::BegCreate(SdrDragStat& rStat)
{
	return rRefObj.BegCreate(rStat);
}

FASTBOOL SdrVirtObj::MovCreate(SdrDragStat& rStat)
{
	return rRefObj.MovCreate(rStat);
}

FASTBOOL SdrVirtObj::EndCreate(SdrDragStat& rStat, SdrCreateCmd eCmd)
{
	return rRefObj.EndCreate(rStat,eCmd);
}

FASTBOOL SdrVirtObj::BckCreate(SdrDragStat& rStat)
{
	return rRefObj.BckCreate(rStat);
}

void SdrVirtObj::BrkCreate(SdrDragStat& rStat)
{
	rRefObj.BrkCreate(rStat);
}

basegfx::B2DPolyPolygon SdrVirtObj::TakeCreatePoly(const SdrDragStat& rDrag) const
{
	return rRefObj.TakeCreatePoly(rDrag);
	// Offset handlen !!!!!! fehlt noch !!!!!!!
}

////////////////////////////////////////////////////////////////////////////////////////////////////

void SdrVirtObj::NbcMove(const Size& rSiz)
{
	MovePoint(aAnchor,rSiz);
	SetRectsDirty();
}

void SdrVirtObj::NbcResize(const Point& rRef, const Fraction& xFact, const Fraction& yFact)
{
	rRefObj.NbcResize(rRef-aAnchor,xFact,yFact);
	SetRectsDirty();
}

void SdrVirtObj::NbcRotate(const Point& rRef, long nWink, double sn, double cs)
{
	rRefObj.NbcRotate(rRef-aAnchor,nWink,sn,cs);
	SetRectsDirty();
}

void SdrVirtObj::NbcMirror(const Point& rRef1, const Point& rRef2)
{
	rRefObj.NbcMirror(rRef1-aAnchor,rRef2-aAnchor);
	SetRectsDirty();
}

void SdrVirtObj::NbcShear(const Point& rRef, long nWink, double tn, FASTBOOL bVShear)
{
	rRefObj.NbcShear(rRef-aAnchor,nWink,tn,bVShear);
	SetRectsDirty();
}

////////////////////////////////////////////////////////////////////////////////////////////////////

void SdrVirtObj::Move(const Size& rSiz)
{
	if (rSiz.Width()!=0 || rSiz.Height()!=0) {
		Rectangle aBoundRect0; if (pUserCall!=NULL) aBoundRect0=GetLastBoundRect();
		// #110094#-14 SendRepaintBroadcast();
		NbcMove(rSiz);
		SetChanged();
		BroadcastObjectChange();
		SendUserCall(SDRUSERCALL_MOVEONLY,aBoundRect0);
	}
}

void SdrVirtObj::Resize(const Point& rRef, const Fraction& xFact, const Fraction& yFact)
{
	if (xFact.GetNumerator()!=xFact.GetDenominator() || yFact.GetNumerator()!=yFact.GetDenominator()) {
		Rectangle aBoundRect0; if (pUserCall!=NULL) aBoundRect0=GetLastBoundRect();
		rRefObj.Resize(rRef-aAnchor,xFact,yFact);
		SetRectsDirty();
		SendUserCall(SDRUSERCALL_RESIZE,aBoundRect0);
	}
}

void SdrVirtObj::Rotate(const Point& rRef, long nWink, double sn, double cs)
{
	if (nWink!=0) {
		Rectangle aBoundRect0; if (pUserCall!=NULL) aBoundRect0=GetLastBoundRect();
		rRefObj.Rotate(rRef-aAnchor,nWink,sn,cs);
		SetRectsDirty();
		SendUserCall(SDRUSERCALL_RESIZE,aBoundRect0);
	}
}

void SdrVirtObj::Mirror(const Point& rRef1, const Point& rRef2)
{
	Rectangle aBoundRect0; if (pUserCall!=NULL) aBoundRect0=GetLastBoundRect();
	rRefObj.Mirror(rRef1-aAnchor,rRef2-aAnchor);
	SetRectsDirty();
	SendUserCall(SDRUSERCALL_RESIZE,aBoundRect0);
}

void SdrVirtObj::Shear(const Point& rRef, long nWink, double tn, FASTBOOL bVShear)
{
	if (nWink!=0) {
		Rectangle aBoundRect0; if (pUserCall!=NULL) aBoundRect0=GetLastBoundRect();
		rRefObj.Shear(rRef-aAnchor,nWink,tn,bVShear);
		SetRectsDirty();
		SendUserCall(SDRUSERCALL_RESIZE,aBoundRect0);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////

void SdrVirtObj::RecalcSnapRect()
{
	aSnapRect=rRefObj.GetSnapRect();
	aSnapRect+=aAnchor;
}

const Rectangle& SdrVirtObj::GetSnapRect() const
{
	((SdrVirtObj*)this)->aSnapRect=rRefObj.GetSnapRect();
	((SdrVirtObj*)this)->aSnapRect+=aAnchor;
	return aSnapRect;
}

void SdrVirtObj::SetSnapRect(const Rectangle& rRect)
{
	{
		Rectangle aBoundRect0; if (pUserCall!=NULL) aBoundRect0=GetLastBoundRect();
		Rectangle aR(rRect);
		aR-=aAnchor;
		rRefObj.SetSnapRect(aR);
		SetRectsDirty();
		SendUserCall(SDRUSERCALL_RESIZE,aBoundRect0);
	}
}

void SdrVirtObj::NbcSetSnapRect(const Rectangle& rRect)
{
	Rectangle aR(rRect);
	aR-=aAnchor;
	SetRectsDirty();
	rRefObj.NbcSetSnapRect(aR);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

const Rectangle& SdrVirtObj::GetLogicRect() const
{
	((SdrVirtObj*)this)->aSnapRect=rRefObj.GetLogicRect();  // !!! Missbrauch von aSnapRect !!!
	((SdrVirtObj*)this)->aSnapRect+=aAnchor;                // Wenns mal Aerger gibt, muss ein weiteres Rectangle Member her (oder Heap)
	return aSnapRect;
}

void SdrVirtObj::SetLogicRect(const Rectangle& rRect)
{
	Rectangle aBoundRect0; if (pUserCall!=NULL) aBoundRect0=GetLastBoundRect();
	Rectangle aR(rRect);
	aR-=aAnchor;
	rRefObj.SetLogicRect(aR);
	SetRectsDirty();
	SendUserCall(SDRUSERCALL_RESIZE,aBoundRect0);
}

void SdrVirtObj::NbcSetLogicRect(const Rectangle& rRect)
{
	Rectangle aR(rRect);
	aR-=aAnchor;
	SetRectsDirty();
	rRefObj.NbcSetLogicRect(aR);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

long SdrVirtObj::GetRotateAngle() const
{
	return rRefObj.GetRotateAngle();
}

long SdrVirtObj::GetShearAngle(FASTBOOL bVertical) const
{
	return rRefObj.GetShearAngle(bVertical);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

sal_uInt32 SdrVirtObj::GetSnapPointCount() const
{
	return rRefObj.GetSnapPointCount();
}

Point SdrVirtObj::GetSnapPoint(sal_uInt32 i) const
{
	Point aP(rRefObj.GetSnapPoint(i));
	aP+=aAnchor;
	return aP;
}

sal_Bool SdrVirtObj::IsPolyObj() const
{
	return rRefObj.IsPolyObj();
}

sal_uInt32 SdrVirtObj::GetPointCount() const
{
	return rRefObj.GetPointCount();
}

Point SdrVirtObj::GetPoint(sal_uInt32 i) const
{
	return Point(rRefObj.GetPoint(i) + aAnchor);
}

void SdrVirtObj::NbcSetPoint(const Point& rPnt, sal_uInt32 i)
{
	Point aP(rPnt);
	aP-=aAnchor;
	rRefObj.SetPoint(aP,i);
	SetRectsDirty();
}

////////////////////////////////////////////////////////////////////////////////////////////////////

SdrObjGeoData* SdrVirtObj::NewGeoData() const
{
	return rRefObj.NewGeoData();
}

void SdrVirtObj::SaveGeoData(SdrObjGeoData& rGeo) const
{
	rRefObj.SaveGeoData(rGeo);
}

void SdrVirtObj::RestGeoData(const SdrObjGeoData& rGeo)
{
	rRefObj.RestGeoData(rGeo);
	SetRectsDirty();
}

////////////////////////////////////////////////////////////////////////////////////////////////////

SdrObjGeoData* SdrVirtObj::GetGeoData() const
{
	return rRefObj.GetGeoData();
}

void SdrVirtObj::SetGeoData(const SdrObjGeoData& rGeo)
{
	Rectangle aBoundRect0; if (pUserCall!=NULL) aBoundRect0=GetLastBoundRect();
	rRefObj.SetGeoData(rGeo);
	SetRectsDirty();
	SendUserCall(SDRUSERCALL_RESIZE,aBoundRect0);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

void SdrVirtObj::NbcReformatText()
{
	rRefObj.NbcReformatText();
}

void SdrVirtObj::ReformatText()
{
	rRefObj.ReformatText();
}

////////////////////////////////////////////////////////////////////////////////////////////////////

FASTBOOL SdrVirtObj::HasMacro() const
{
	return rRefObj.HasMacro();
}

SdrObject* SdrVirtObj::CheckMacroHit(const SdrObjMacroHitRec& rRec) const
{
	return rRefObj.CheckMacroHit(rRec); // Todo: Positionsversatz
}

Pointer SdrVirtObj::GetMacroPointer(const SdrObjMacroHitRec& rRec) const
{
	return rRefObj.GetMacroPointer(rRec); // Todo: Positionsversatz
}

void SdrVirtObj::PaintMacro(XOutputDevice& rXOut, const Rectangle& rDirtyRect, const SdrObjMacroHitRec& rRec) const
{
	rRefObj.PaintMacro(rXOut,rDirtyRect,rRec); // Todo: Positionsversatz
}

FASTBOOL SdrVirtObj::DoMacro(const SdrObjMacroHitRec& rRec)
{
	return rRefObj.DoMacro(rRec); // Todo: Positionsversatz
}

XubString SdrVirtObj::GetMacroPopupComment(const SdrObjMacroHitRec& rRec) const
{
	return rRefObj.GetMacroPopupComment(rRec); // Todo: Positionsversatz
}

const Point SdrVirtObj::GetOffset() const
{
	// #i73248# default offset of SdrVirtObj is aAnchor
    return aAnchor;
}

// eof
