/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xout1.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 06:24:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#include "xoutx.hxx"

#ifdef JOEDEBUG
#include "Q:\joedebug.hxx"
#endif

#define GLOBALOVERFLOW

/*************************************************************************
|*
|*    XOutputDevice::SetOffset()
|*
|*    Beschreibung
|*    Ersterstellung    08.11.94
|*    Letzte Aenderung  08.11.94
|*
*************************************************************************/

void XOutputDevice::SetOffset( const Point& rOfs )
{
	if (rOfs!=aOfs)
	{
		Point aDelta(rOfs);
		Fraction aFact1(1,1);
		aDelta-=aOfs;
#ifdef neeJOEDEBUG
		DebWrite("XOutputDevice::SetOffset(");
		DebOut(rOfs);
		DebWrite("Alter Offset: ");
		DebOut(aOfs);
		DebWrite("Alter Origin: ");
		DebOut(pOut->GetMapMode().GetOrigin());
		DebWrite("Delta: ");
		DebOut(aDelta);
#endif
//#ifdef JOEDEBUG
////        pOut->SetMapMode(MapMode(MAP_RELATIVE,Point(-aOfs.X(),-aOfs.Y()),aFact1,aFact1));
////        pOut->SetMapMode(MapMode(MAP_RELATIVE,rOfs,aFact1,aFact1));
		pOut->SetMapMode(MapMode(MAP_RELATIVE,aDelta,aFact1,aFact1));
//#else
//        MapMode aMap(pOut->GetMapMode());
//        Point   aOrg(aMap.GetOrigin());
//        aOrg.X()+=aDelta.X();
//        aOrg.Y()+=aDelta.Y();
//        aMap.SetOrigin(aOrg);
//        pOut->SetMapMode(aMap);
//#endif
		aOfs=rOfs;
#ifdef neeJOEDEBUG
		DebWrite("Neuer Offset: ");
		DebOut(aOfs);
		DebWrite("Neuer Origin: ");
		DebOut(pOut->GetMapMode().GetOrigin());
#endif
	}
}

/*************************************************************************
|*
|*    XOutputDevice::GetMapMode()
|*
|*    Beschreibung
|*    Ersterstellung    08.11.94
|*    Letzte Aenderung  08.11.94
|*
*************************************************************************/

MapMode XOutputDevice::GetMapMode() const
{
	MapMode aMap = pOut->GetMapMode();
	Point   aPos = aMap.GetOrigin();

	aPos.X() -= aOfs.X();
	aPos.Y() -= aOfs.Y();

	aMap.SetOrigin( aPos );

	return aMap;
}


/*************************************************************************
|*
|*    XOutputDevice::SetMapMode()
|*
|*    Beschreibung
|*    Ersterstellung    08.11.94
|*    Letzte Aenderung  08.11.94
|*
*************************************************************************/

void XOutputDevice::SetMapMode( const MapMode& rMap )
{
	Point aPos = rMap.GetOrigin();
	aPos.X() += aOfs.X();
	aPos.Y() += aOfs.Y();

	MapMode aMap( rMap );
	aMap.SetOrigin( aPos );

	pOut->SetMapMode( aMap );
}



