/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: edredln.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: vg $ $Date: 2006/09/25 09:27:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"


#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#include "redline.hxx"
#include "doc.hxx"
#include "swundo.hxx"
#include "editsh.hxx"
#include "edimp.hxx"
#include "frmtool.hxx"


USHORT SwEditShell::GetRedlineMode() const
{
	return GetDoc()->GetRedlineMode();
}

void SwEditShell::SetRedlineMode( USHORT eMode )
{
	if( eMode != GetDoc()->GetRedlineMode() )
	{
		SET_CURR_SHELL( this );
		StartAllAction();
		GetDoc()->SetRedlineMode( (IDocumentRedlineAccess::RedlineMode_t)eMode );
		EndAllAction();
	}
}

BOOL SwEditShell::IsRedlineOn() const
{
	return GetDoc()->IsRedlineOn();
}

USHORT SwEditShell::GetRedlineCount() const
{
	return GetDoc()->GetRedlineTbl().Count();
}

const SwRedline& SwEditShell::GetRedline( USHORT nPos ) const
{
	return *GetDoc()->GetRedlineTbl()[ nPos ];
}

void lcl_InvalidateAll( ViewShell* pSh )
{
	ViewShell *pStop = pSh;
	do
	{
		if ( pSh->GetWin() )
			pSh->GetWin()->Invalidate();
		pSh = (ViewShell*)pSh->GetNext();

	} while ( pSh != pStop );
}

BOOL SwEditShell::AcceptRedline( USHORT nPos )
{
	SET_CURR_SHELL( this );
	StartAllAction();
	BOOL bRet = GetDoc()->AcceptRedline( nPos, true );
	if( !nPos && !::IsExtraData( GetDoc() ) )
		lcl_InvalidateAll( this );
	EndAllAction();
	return bRet;
}

BOOL SwEditShell::RejectRedline( USHORT nPos )
{
	SET_CURR_SHELL( this );
	StartAllAction();
	BOOL bRet = GetDoc()->RejectRedline( nPos, true );
	if( !nPos && !::IsExtraData( GetDoc() ) )
		lcl_InvalidateAll( this );
	EndAllAction();
	return bRet;
}

// Kommentar am Redline setzen
BOOL SwEditShell::SetRedlineComment( const String& rS )
{
	BOOL bRet = FALSE;
	FOREACHPAM_START(this)
		bRet = bRet || GetDoc()->SetRedlineComment( *PCURCRSR, rS );
	FOREACHPAM_END()

	return bRet;
}

const SwRedline* SwEditShell::GetCurrRedline() const
{
	return GetDoc()->GetRedline( *GetCrsr()->GetPoint(), 0 );
}

void SwEditShell::UpdateRedlineAttr()
{
	if( ( IDocumentRedlineAccess::REDLINE_SHOW_INSERT | IDocumentRedlineAccess::REDLINE_SHOW_DELETE ) ==
		( IDocumentRedlineAccess::REDLINE_SHOW_MASK & GetDoc()->GetRedlineMode() ))
	{
		SET_CURR_SHELL( this );
		StartAllAction();

		GetDoc()->UpdateRedlineAttr();

		EndAllAction();
	}
}

	// suche das Redline zu diesem Data und returne die Pos im Array
	// USHRT_MAX wird returnt, falls nicht vorhanden
USHORT SwEditShell::FindRedlineOfData( const SwRedlineData& rData ) const
{
	const SwRedlineTbl& rTbl = GetDoc()->GetRedlineTbl();

	for( USHORT i = 0, nCnt = rTbl.Count(); i < nCnt; ++i )
		if( &rTbl[ i ]->GetRedlineData() == &rData )
			return i;
	return USHRT_MAX;
}



