/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SmartTagMgr.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2007/01/02 16:49:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    Initial Contributer was Fabalabs Software GmbH, Jakob Lechner
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// SMARTTAGS

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"

#include <SmartTagMgr.hxx>

#ifndef _UTL_BOOTSTRAP_HXX
#include <unotools/bootstrap.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _COMPHELPER_SEQUENCE_HXX_
#include <comphelper/sequence.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSINGLECOMPONENTFACTORY_HPP_
#include <com/sun/star/lang/XSingleComponentFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XCONTENTENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XContentEnumerationAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif


using namespace com::sun::star::container;
using namespace com::sun::star::smarttags;
using namespace cppu;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::beans;
using namespace ::rtl;

#define C2U(cChar) OUString::createFromAscii(cChar)

#ifdef WNT
#define FILEPATH_OFFSET 8
#else
#define FILEPATH_OFFSET 7
#endif

SmartTagMgr* SmartTagMgr::pSmartTagMgr = NULL;

ActionReference::ActionReference(Reference<XSmartTagAction> _aSmartTagAction, sal_Int32 _nSmartTagIndex) :
       aSmartTagAction(_aSmartTagAction), nSmartTagIndex(_nSmartTagIndex) { }

sal_Bool SmartTagMgr::Recognize(const OUString aWord, Reference <XController> xController)
{
  //  std::multimap <OUString, SmartTagReference> :: iterator wordIter;
  //  wordIter = recognizedWords.find(aWord);

    recognizedWords.erase(aWord);
    sal_Bool bResult = sal_False;

    for (sal_uInt32 i=0; i<recognizerList.size(); i++)
    {
        for (sal_Int32 j=0; j<recognizerList[i]->getSmartTagCount(); j++)
        {
            if (recognizerList[i]->Recognize(aWord, j, xController))
            {
                // get list of actions that are associated with actual recognizer
                OUString smarttagName = recognizerList[i]->getSmartTagName(j);
                std::multimap <OUString, ActionReference> :: const_iterator aPos;
                for (aPos = smarttagMap.find(smarttagName); aPos != smarttagMap.end(); ++aPos)
                {
                    if (aPos->first.equals(smarttagName))
                    {
                        // ActionReference aAction(aPos->second, j);
                        recognizedWords.insert(word_action_Pair(aWord, aPos->second));
                        bResult = sal_True;
                    }
                    else
                    {
                        break;
                    }
                }

   /*  RecognizerReference recRef (recognizerList[i], j);

   std::multimap <RecognizerReference, ActionReference> :: const_iterator aPos;
           for (aPos = smarttagMap.find(recRef); aPos != smarttagMap.end(); ++aPos) {
     if ( (aPos->first.aSmartTagRecognizer == recognizerList[i]) &&
          (aPos->first.nSmartTagIndex == j) ) {

       // ActionReference aAction(aPos->second, j);
       recognizedWords.insert(word_action_Pair(aWord, aPos->second));
       bResult = sal_True;
     }
     else {
       break;
     }
     }*/

            }
        }
    }

    return bResult;
}

void SmartTagMgr::getMostlXmlFiles( std::vector <OUString>& rfilelist )
{
    // get path for shared data in ooo install directory
    OUString aShareData;
    ::utl::Bootstrap::locateSharedData( aShareData );

    // iterate through directory contents
    osl::FileStatus aFileStatus(FileStatusMask_All);
    osl::DirectoryItem aDirItem;
    osl::FileBase::RC next;
    osl::Directory aDir( aShareData + C2U("/smarttags"));
    aDir.open();

    while ((next = aDir.getNextItem( aDirItem )) == osl::FileBase::E_None)
    {
        aDirItem.getFileStatus(aFileStatus);

        if (aFileStatus.getFileType() == osl::FileStatus::Regular)
        {
            OUString fileurl = aFileStatus.getFileURL();
            if (fileurl.indexOf(C2U("file://"))==0)
            {
                fileurl = fileurl.copy(FILEPATH_OFFSET);
            }

            if (fileurl.lastIndexOf(C2U(".xml")) != fileurl.getLength()-4) continue;
            rfilelist.push_back(fileurl);
        }
    }

    aDir.close();
}


void SmartTagMgr::associateActionWithRecognizer(Reference <XSmartTagAction> aAction)
{
    sal_Int32 smarttagCount = aAction->getSmartTagCount();

    // iterate over smarttags in action library
    for (sal_Int32 i=0; i<smarttagCount; i++)
    {
        OUString smarttagName = aAction->getSmartTagName(i);
        // iterate over recognizers
        for (sal_uInt32 j=0; j<recognizerList.size(); j++)
        {
            Reference <XSmartTagRecognizer> aRecognizer = recognizerList[j];
            sal_Int32 smarttagCount2 = aRecognizer->getSmartTagCount();

            for (int k=0; k<smarttagCount2; k++)
            {
                OUString smarttagName2 = aRecognizer->getSmartTagName(k);
                if (smarttagName.equals(smarttagName2))
                {
                    // found actions and recognizer for same smarttag
                    //RecognizerReference recRef(aRecognizer, k);
                    ActionReference actionRef(aAction, i);

                    // add recognizer/action pair to map
                    smarttagMap.insert(recognizer_action_Pair(smarttagName2, actionRef));
                }
            }
        }
    }
}

void SmartTagMgr::LoadLibraries()
{
    Reference< XMultiServiceFactory > xMSF = ::comphelper::getProcessServiceFactory();
    if ( !xMSF.is() ) return;

    Reference< com::sun::star::container::XContentEnumerationAccess > rContent( xMSF , UNO_QUERY );
    if ( !rContent.is() ) return;

    // load recognizers: No recognizers -> nothing to do.
    Reference < com::sun::star::container::XEnumeration > rEnum = rContent->createContentEnumeration( C2U("com.sun.star.smarttags.SmartTagRecognizer"));
    if ( !rEnum.is() || !rEnum->hasMoreElements() ) return;

    // get component context to pass to component:
    Reference< XPropertySet > xPropSet = Reference< XPropertySet>(xMSF, UNO_QUERY);
    Any aAny = xPropSet->getPropertyValue( OUString::createFromAscii("DefaultContext"));
    Reference< XComponentContext> xContext;
    aAny >>= xContext;
    if (!xContext.is()) return;

    std::vector<OUString> mostlfilelist;

    // iterate over all implementations of the smart tag recognizer service:
    while( rEnum->hasMoreElements())
    {
        Any a = rEnum->nextElement();
        Reference< XSingleComponentFactory > xSCF;
        Reference< XServiceInfo > xsInfo;
        OUString implName;

        if (a >>= xsInfo)
        {
            implName = xsInfo->getImplementationName();
            xSCF = Reference< XSingleComponentFactory >(xsInfo, UNO_QUERY);
        }
        else continue;

        if (implName.equals(C2U("org.openoffice.comp.smarttags.recognizer.mostl")))
        {
            // create mostl instances for every xml file found in SHARE/smarttags
            getMostlXmlFiles( mostlfilelist );
            Sequence<Any> aArguments(1);

            for (sal_uInt32 i=0; i<mostlfilelist.size(); i++)
            {
                Reference< XSmartTagRecognizer > xLib ( xSCF->
                    createInstanceWithContext(xContext), UNO_QUERY );

                if (!xLib.is()) continue;

                aArguments[0] <<= mostlfilelist[i];
                xLib->initialize(aArguments);

                recognizerList.push_back(xLib);
            }
        }
        else
        {
            Reference< XSmartTagRecognizer > xLib ( xSCF->
                    createInstanceWithContext(xContext), UNO_QUERY );

            if (!xLib.is()) continue;

            recognizerList.push_back(xLib);
        }

    }

    // load action libraries
    rEnum = rContent->createContentEnumeration( C2U("com.sun.star.smarttags.SmartTagAction"));
    if ( !rEnum.is() ) return;

    while( rEnum->hasMoreElements())
    {
        Any a = rEnum->nextElement();
        Reference< XServiceInfo > xsInfo;
        Reference< XSingleComponentFactory > xSCF;
        OUString implName;

        if (a >>= xsInfo)
        {
            implName = xsInfo->getImplementationName();
            xSCF = Reference< XSingleComponentFactory >(xsInfo, UNO_QUERY);
        }
        else continue;

        if (implName.equals(C2U("org.openoffice.comp.smarttags.action.mostl")))
        {
            // create mostl instances for every xml file found in SHARE/smarttags
            Sequence<Any> aArguments(1);

            for (sal_uInt32 i=0; i<mostlfilelist.size(); i++)
            {
                Reference< XSmartTagAction > xLib ( xSCF->
                    createInstanceWithContext(xContext), UNO_QUERY );

                if (!xLib.is()) continue;

                aArguments[0] <<= mostlfilelist[i];
                xLib->initialize(aArguments);

                associateActionWithRecognizer(xLib);
            }
        }
        else
        {
            Reference< XSmartTagAction > xLib ( xSCF->
                    createInstanceWithContext(xContext), UNO_QUERY );

            if (!xLib.is()) continue;

            associateActionWithRecognizer(xLib);
        }
    }

    //  Reference< XComponent >::query( xContext )->dispose();
}

SmartTagMgr::SmartTagMgr()
{
   LoadLibraries();
}

SmartTagMgr::~SmartTagMgr()
{
}

SmartTagMgr& SmartTagMgr::getSmartTagMgr()
{
    if (!pSmartTagMgr)
       _Create();

    return *pSmartTagMgr;
}

void SmartTagMgr::_Create()
{
    delete pSmartTagMgr, pSmartTagMgr = new SmartTagMgr;
}

void SmartTagMgr::_Delete()
{
    delete pSmartTagMgr, pSmartTagMgr = 0;
}

std::vector <ActionReference> SmartTagMgr::getActionRefsByWord(OUString aWord) const
{
    std::vector <ActionReference> aRef;
    std::multimap <OUString, ActionReference> :: const_iterator aPos;

    for (aPos = recognizedWords.find(aWord); aPos != recognizedWords.end(); ++aPos)
    {
        if (!aPos->first.compareTo(aWord))
        {
            aRef.push_back(aPos->second);
        }
        else break;
    }

    return aRef;
}

