/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: FormattedTextReadHandler.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/07/09 11:56:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2007 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *    Copyright 2007 by Pentaho Corporation
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.report.pentaho.parser.rpt;

import com.sun.star.report.pentaho.model.FormattedTextElement;
import com.sun.star.report.pentaho.parser.ElementReadHandler;
import com.sun.star.report.pentaho.parser.StarXmlFactoryModule;
import com.sun.star.report.pentaho.OfficeNamespaces;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Element;
import org.jfree.xmlns.parser.XmlReadHandler;
import org.jfree.xmlns.parser.IgnoreAnyChildReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * Creation-Date: 01.10.2006, 19:06:45
 *
 * @author Thomas Morgner
 */
public class FormattedTextReadHandler extends ElementReadHandler
{
  private FormattedTextElement element;

  public FormattedTextReadHandler()
  {
    element = new FormattedTextElement();
  }

  /**
   * Starts parsing.
   *
   * @param attrs the attributes.
   * @throws org.xml.sax.SAXException if there is a parsing error.
   */
  protected void startParsing(final Attributes attrs) throws SAXException
  {
    super.startParsing(attrs);

    String formula = attrs.getValue
        (OfficeNamespaces.OOREPORT_NS, "formula");
    if (formula != null)
    {
      final FormulaExpression valueExpression = new FormulaExpression();
      valueExpression.setFormula(formula);
      element.setValueExpression(valueExpression);
    }

    // * Print-Repeated-Values
    // * Print-In-First-New-Section
    // * Print-When-Group-Changes

    // * Print-When-Section-Overflows
    // That property cannot be evaluated yet, as this would require us to
    // have a clue about pagebreaking. We dont have that - not yet and never
    // in the future, as pagebreaks are computed by OpenOffice instead
  }

  /**
   * Returns the handler for a child element.
   *
   * @param tagName the tag name.
   * @param atts    the attributes.
   * @return the handler or null, if the tagname is invalid.
   * @throws org.xml.sax.SAXException if there is a parsing error.
   */
  protected XmlReadHandler getHandlerForChild(final String uri,
                                              final String tagName,
                                              final Attributes atts)
      throws SAXException
  {
    if (OfficeNamespaces.OOREPORT_NS.equals(uri))
    {
      // expect a report control. The control will modifiy the current
      // element (as we do not separate the elements that strictly ..)
      if ("report-control".equals(tagName))
      {
        return new IgnoreAnyChildReadHandler();
      }
      if ("report-element".equals(tagName))
      {
        return new ReportElementReadHandler(element);
      }
    }
    return null;
  }


  public Element getElement()
  {
    return element;
  }
}
