/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: notemark.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 21:40:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_NOTEMARK_HXX
#define SC_NOTEMARK_HXX

#ifndef _MAPMOD_HXX //autogen
#include <vcl/mapmod.hxx>
#endif
#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif

#ifndef SC_SCGLOB_HXX
#include "global.hxx"
#endif

#ifndef SC_ADDRESS_HXX
#include "address.hxx"
#endif

class SdrModel;
class SdrObject;

class ScNoteMarker
{
private:
	Window*		pWindow;
	Window*		pRightWin;
	Window*		pBottomWin;
	Window*		pDiagWin;
	ScDocument*	pDoc;
	ScAddress	aDocPos;
	String		aUserText;
	Timer		aTimer;
	MapMode		aMapMode;
	BOOL		bLeft;
	BOOL		bByKeyboard;

	Rectangle		aRect;
	SdrModel*		pModel;
	SdrObject*		pObject;
	BOOL			bVisible;

	DECL_LINK( TimeHdl, Timer* );

public:
				ScNoteMarker( Window* pWin,
								Window* pRight, Window* pBottom, Window* pDiagonal,
								ScDocument* pD, ScAddress aPos,
								const String& rUser, const MapMode& rMap,
								BOOL bLeftEdge, BOOL bForce, BOOL bKeyboard );
				~ScNoteMarker();

	void		Draw();
	void		InvalidateWin();

	ScAddress	GetDocPos() const		{ return aDocPos; }
	BOOL		IsByKeyboard() const	{ return bByKeyboard; }
};



#endif

