/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TaskPaneService.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/03 16:20:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "precompiled_sd.hxx"

#include "TaskPaneService.hxx"

#include "TaskPaneViewShell.hxx"
#include "DrawController.hxx"

#include "framework/FrameworkHelper.hxx"

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::drawing::framework;

using ::rtl::OUString;
using ::sd::framework::FrameworkHelper;
using ::sd::toolpanel::TaskPaneViewShell;

namespace sd { namespace framework {

Reference<XInterface> SAL_CALL TaskPaneService_createInstance (
    const Reference<XComponentContext>& rxContext)
{
    return Reference<XInterface>(static_cast<XWeak*>(new TaskPaneService(rxContext)));
}




::rtl::OUString TaskPaneService_getImplementationName (void) throw(RuntimeException)
{
    return ::rtl::OUString(
        RTL_CONSTASCII_USTRINGPARAM("com.sun.star.comp.Draw.framework.TaskPaneService"));
}




Sequence<rtl::OUString> SAL_CALL TaskPaneService_getSupportedServiceNames (void)
    throw (RuntimeException)
{
	static const ::rtl::OUString sServiceName(
        ::rtl::OUString::createFromAscii("com.sun.star.drawing.framework.TaskPaneService"));
	return Sequence<rtl::OUString>(&sServiceName, 1);
}




//===== TaskPaneService =======================================================

TaskPaneService::TaskPaneService (
    const ::com::sun::star::uno::Reference<com::sun::star::uno::XComponentContext>& rxContext)
    : TaskPaneServiceInterfaceBase(maMutex),
      mpViewShellBase(NULL)
{
    (void)rxContext;
}




TaskPaneService::~TaskPaneService (void)
{
}




void SAL_CALL TaskPaneService::disposing (void)
{
}



    
//===== XInitialization =======================================================
    
void SAL_CALL TaskPaneService::initialize(
    const ::com::sun::star::uno::Sequence<com::sun::star::uno::Any>& aArguments)
    throw (::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException)
{
    if (aArguments.getLength() > 0)
    {
        try
        {
            // Get the XController from the first argument.
            Reference<frame::XController> xController (aArguments[0], UNO_QUERY_THROW);

            // Tunnel through the controller to obtain access to the ViewShellBase.
            try
            {
                Reference<lang::XUnoTunnel> xTunnel (xController, UNO_QUERY_THROW);
                DrawController* pController
                    = reinterpret_cast<DrawController*>(
                        sal::static_int_cast<sal_uIntPtr>(
                            xTunnel->getSomething(DrawController::getUnoTunnelId())));
                if (pController != NULL)
                    mpViewShellBase = pController->GetViewShellBase();
            }
            catch(RuntimeException&)
            {}
        }
        catch (RuntimeException&)
        {
        }
    }
}


//===== XResourceController ===================================================

void SAL_CALL TaskPaneService::updateStart (
    const Reference<XConfiguration>& rxRequestedConfiguration,
    const Reference<XConfiguration>& rxCurrentConfiguration,
    const Sequence<Reference<XResourceId> >& rResourcesToDeactivate)
    throw (RuntimeException)
{
    (void)rxRequestedConfiguration;

    for (sal_Int32 nIndex=0; nIndex<rResourcesToDeactivate.getLength(); ++nIndex)
    {
        const OUString sResourceURL (rResourcesToDeactivate[nIndex]->getResourceURL());
        if (sResourceURL.match(FrameworkHelper::msTaskPanelURLPrefix))
        {
            rxCurrentConfiguration->removeResource(rResourcesToDeactivate[nIndex]);
        }
    }
}




void SAL_CALL TaskPaneService::updateEnd (
    const Reference<XConfiguration>& rxRequestedConfiguration,
    const Reference<XConfiguration>& rxCurrentConfiguration,
    const Sequence<Reference<XResourceId> >& rResourcesToActivate)
    throw (RuntimeException)
{
    (void)rxRequestedConfiguration;
    (void)rxCurrentConfiguration;

    for (sal_Int32 nIndex=0; nIndex<rResourcesToActivate.getLength(); ++nIndex)
    {
        const OUString sResourceURL (rResourcesToActivate[nIndex]->getResourceURL());
        if (sResourceURL.match(FrameworkHelper::msTaskPanelURLPrefix))
        {
            TaskPaneViewShell::PanelId ePaneId (TaskPaneViewShell::PID_UNKNOWN);

            if (sResourceURL.equals(FrameworkHelper::msMasterPagesTaskPanelURL))
            {
                ePaneId = TaskPaneViewShell::PID_MASTER_PAGES;
            }
            else if (sResourceURL.equals(FrameworkHelper::msLayoutTaskPanelURL))
            {
                ePaneId = TaskPaneViewShell::PID_LAYOUT;
            }
            else if (sResourceURL.equals(FrameworkHelper::msCustomAnimationTaskPanelURL))
            {
                ePaneId = TaskPaneViewShell::PID_CUSTOM_ANIMATION;
            }
            else if (sResourceURL.equals(FrameworkHelper::msSlideTransitionTaskPanelURL))
            {
                ePaneId = TaskPaneViewShell::PID_SLIDE_TRANSITION;
            }

            if (ePaneId!=TaskPaneViewShell::PID_UNKNOWN && mpViewShellBase!=NULL)
            {
                toolpanel::TaskPaneViewShell* pTaskPane
                    = dynamic_cast<toolpanel::TaskPaneViewShell*>(
                        FrameworkHelper::Instance(*mpViewShellBase)
                            ->GetViewShell(FrameworkHelper::msRightPaneURL).get());
                if (pTaskPane != NULL)
                {
                    pTaskPane->ShowPanel(ePaneId);
                    rxCurrentConfiguration->addResource(rResourcesToActivate[nIndex]);
                }
            }
        }
    }
}




//=============================================================================

void TaskPaneService::ThrowIfDisposed (void) const
    throw (lang::DisposedException)
{
	if (rBHelper.bDisposed || rBHelper.bInDispose)
	{
        throw lang::DisposedException (
            ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                "TaskPaneService object has already been disposed")),
            const_cast<uno::XWeak*>(static_cast<const uno::XWeak*>(this)));
    }
}

} } // end of namespace sd::framework
