/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: inethist.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2007/04/11 19:23:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _INETHIST_HXX
#define _INETHIST_HXX

#ifndef INCLUDED_SVLDLLAPI_H
#include "svtools/svldllapi.h"
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _SFXBRDCST_HXX
#include <svtools/brdcst.hxx>
#endif

#ifndef _SFXHINT_HXX
#include <svtools/hint.hxx>
#endif

/*========================================================================
 *
 * INetURLHistory interface.
 *
 *=======================================================================*/
class INetURLHistory_Impl;
class INetURLHistory : public SfxBroadcaster
{
	struct StaticInstance
	{
		INetURLHistory * operator()();
	};
	friend INetURLHistory * StaticInstance::operator()();

	/** Representation.
	*/
	INetURLHistory_Impl *m_pImpl;

	/** Construction/Destruction.
	*/
	INetURLHistory (void);
	virtual ~INetURLHistory (void);

	/** Implementation.
	*/
	static void NormalizeUrl_Impl (INetURLObject &rUrl);

	SVL_DLLPUBLIC void PutUrl_Impl   (const INetURLObject &rUrl);
	SVL_DLLPUBLIC BOOL QueryUrl_Impl (const INetURLObject &rUrl);

	/** Not implemented.
	*/
	INetURLHistory (const INetURLHistory&);
	INetURLHistory& operator= (const INetURLHistory&);

public:
	/** GetOrCreate.
	*/
	SVL_DLLPUBLIC static INetURLHistory* GetOrCreate (void);

	/** QueryProtocol.
	*/
	BOOL QueryProtocol (INetProtocol eProto) const
	{
		return ((eProto == INET_PROT_FILE ) ||
				(eProto == INET_PROT_FTP  ) ||
				(eProto == INET_PROT_HTTP ) ||
				(eProto == INET_PROT_HTTPS)    );
	}

	/** QueryUrl.
	*/
	BOOL QueryUrl (const INetURLObject &rUrl)
	{
		if (QueryProtocol (rUrl.GetProtocol()))
			return QueryUrl_Impl (rUrl);
		else
			return FALSE;
	}

	BOOL QueryUrl (const String &rUrl)
	{
		INetProtocol eProto =
			INetURLObject::CompareProtocolScheme (rUrl);
		if (QueryProtocol (eProto))
			return QueryUrl_Impl (INetURLObject (rUrl));
		else
			return FALSE;
	}

	/** PutUrl.
	*/
	void PutUrl (const INetURLObject &rUrl)
	{
		if (QueryProtocol (rUrl.GetProtocol()))
			PutUrl_Impl (rUrl);
	}

	void PutUrl (const String &rUrl)
	{
		INetProtocol eProto =
			INetURLObject::CompareProtocolScheme (rUrl);
		if (QueryProtocol (eProto))
			PutUrl_Impl (INetURLObject (rUrl));
	}
};

/*========================================================================
 *
 * INetURLHistoryHint (broadcasted from PutUrl()).
 *
 *=======================================================================*/
DECL_PTRHINT (SVL_DLLPUBLIC, INetURLHistoryHint, const INetURLObject);

#endif /* _INETHIST_HXX */

