#! /bin/sh
#
#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile,v $
#
#   $Revision: 1.1 $
#
#   last change: $Author: st $ $Date: 2000/11/22 02:32:00 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************
# checkdll.sh - execute checkdll with all -L arguments to this script
#               prepended to LD_LIBRARY_PATH

set -- `getopt "L:" "$@"` ||  {
    echo "Usage: `basename $0` [-L library_path] <shared_library>" 1>&2
    exit 1
}

checkdll="$SOLARVERSION/$INPATH/bin$UPDMINOREXT/checkdll"

if [ -x $checkdll ]; then
    while :
    do
	case $1 in
	    -L) shift; option=$1;;
	    --) break;;
	esac
	case "${libpath+X}" in
	    X) libpath=$libpath:$option;;
	    *) libpath=$option;;
	esac
	shift
    done
    shift  # remove the trailing ---

    case `uname -s` in
    Darwin) case "${DYLD_LIBRARY_PATH+X}" in
	    X) DYLD_LIBRARY_PATH=$libpath:$DYLD_LIBRARY_PATH;;
	    *) DYLD_LIBRARY_PATH=$libpath;;
        esac
        export DYLD_LIBRARY_PATH;;
    IRIX) case "${LD_LIBRARYN32_PATH+X}" in
	    X) LD_LIBRARYN32_PATH=$libpath:$LD_LIBRARYN32_PATH;;
	    *) LD_LIBRARYN32_PATH=$libpath;;
	esac
        export LD_LIBRARYN32_PATH;;
    IRIX64) case "${LD_LIBRARYN32_PATH+X}" in
	    X) LD_LIBRARYN32_PATH=$libpath:$LD_LIBRARYN32_PATH;;
	    *) LD_LIBRARYN32_PATH=$libpath;;
	esac
        export LD_LIBRARYN32_PATH;;
	*)  case "${LD_LIBRARY_PATH+X}" in
	    X) LD_LIBRARY_PATH=$libpath:$LD_LIBRARY_PATH;;
	    *) LD_LIBRARY_PATH=$libpath;;
        esac
        export LD_LIBRARY_PATH;;
    esac

    $checkdll "$*"
    if [ $? -ne 0 ]; then exit 1 ; fi

    for parameter in $*; do
        library=$parameter;
    done
    realname=`echo $library | sed "s/check_//"`
    if [ $library != $realname ]; then
		LD_LIBRARY_PATH=
		export LD_LIBRARY_PATH
        mv $library $realname
    fi
else
	echo "WARNING: checkdll not found!" 1>&2
fi

exit 0
