/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef DBAUI_APPICONCONTROL_HXX
#define DBAUI_APPICONCONTROL_HXX

#ifndef _ICNVW_HXX
#include <svtools/ivctrl.hxx>
#endif
#ifndef _TRANSFER_HXX
#include <svtools/transfer.hxx>
#endif


namespace dbaui
{
	class IControlActionListener;
	//==================================================================
	class OApplicationIconControl	:public SvtIconChoiceCtrl 
									,public DropTargetHelper
	{
		Point						m_aMousePos;
		IControlActionListener*		m_pActionListener;

	public:
		OApplicationIconControl(Window* _pParent);
		virtual ~OApplicationIconControl();

		void					setControlActionListener( IControlActionListener* _pListener ) { m_pActionListener = _pListener; }
		IControlActionListener*	getControlActionListener( ) const { return m_pActionListener; }

	protected:
		// DropTargetHelper overridables
		virtual sal_Int8	AcceptDrop( const AcceptDropEvent& _rEvt );
		virtual sal_Int8	ExecuteDrop( const ExecuteDropEvent& _rEvt );
	};
}
#endif // DBAUI_APPICONCONTROL_HXX

