/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#include "strimp.h"

sal_Int16 rtl_ImplGetDigit( sal_Unicode ch, sal_Int16 nRadix )
{
	sal_Int16 n = -1;
	if ( (ch >= '0') && (ch <= '9') )
		n = ch-'0';
	else if ( (ch >= 'a') && (ch <= 'z') )
		n = ch-'a'+10;
	else if ( (ch >= 'A') && (ch <= 'Z') )
		n = ch-'A'+10;
	return (n < nRadix) ? n : -1;
}

sal_Bool rtl_ImplIsWhitespace( sal_Unicode c )
{
	/* Space or Control character? */
	if ( (c <= 32) && c )
		return sal_True;

	/* Only in the General Punctuation area Space or Control characters are included? */
	if ( (c < 0x2000) || (c > 0x206F) )
		return sal_False;

	if ( ((c >= 0x2000) && (c <= 0x200B)) ||	/* All Spaces			*/
		 (c == 0x2028) ||						/* LINE SEPARATOR		*/
		 (c == 0x2029) )						/* PARAGRAPH SEPARATOR	*/
		return sal_True;

	return sal_False;
}
