/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_textlayout_drawhelper.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:33:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVWIN_H
#include <tools/svwin.h>
#define _SVWIN_H
#endif

#undef max
#undef min

#ifndef _TOOLS_COLOR_HXX
#include <tools/color.hxx>
#endif

#ifndef _COM_SUN_STAR_RENDERING_FONTREQUEST_HPP_
#include <com/sun/star/rendering/FontRequest.hpp>
#endif

#ifndef _COMPHELPER_SEQUENCE_HXX_
#include <comphelper/sequence.hxx>
#endif

#ifndef _VCL_CANVASTOOLS_HXX
#include <vcl/canvastools.hxx>
#endif
#ifndef _SV_VIRDEV_HXX
#include <vcl/virdev.hxx>
#endif
#ifndef _SV_SYSDATA_HXX
#include <vcl/sysdata.hxx>
#endif
#ifndef _SV_METRIC_HXX
#include <vcl/metric.hxx>
#endif

#include <basegfx/numeric/ftools.hxx>
#include <basegfx/polygon/b2dpolypolygon.hxx>
#include <basegfx/tools/canvastools.hxx>

#ifndef BOOST_SCOPED_ARRAY_HPP_INCLUDED 
#include <boost/scoped_array.hpp>
#endif

#include <canvas/canvastools.hxx>
#include <dx_impltools.hxx>
#include <dx_textlayout_drawhelper.hxx>


using namespace ::com::sun::star;

//////////////////////////////////////////////////////////////////////////////

namespace dxcanvas
{
	TextLayoutDrawHelper::TextLayoutDrawHelper(
		HDC aHDC,
		const uno::Reference< rendering::XGraphicDevice >& xGraphicDevice)
	:	maHDC(aHDC),
		mxGraphicDevice(xGraphicDevice),
		mpVirtualDevice(0L)
	{
		// use a VirtualDevice opened with SystemGraphicsData containing
		// the destinstion HDC
		SystemGraphicsData aSystemGraphicsData;

		aSystemGraphicsData.nSize = sizeof(SystemGraphicsData);
		aSystemGraphicsData.hDC = maHDC;

		mpVirtualDevice = new VirtualDevice(&aSystemGraphicsData, 0);

        // TODO(F3): Currently, antialiasing does not seem to work (on
        // none of the GDI+ surfaces), but produces a frame of black
        // pixels around every glyph. Thus, disabled for now, but we
        // urgently need this working.
        mpVirtualDevice->SetAntialiasing( ANTIALIASING_DISABLE_TEXT );
	}

	TextLayoutDrawHelper::~TextLayoutDrawHelper()
	{
		// get rid of the virtual device
		delete mpVirtualDevice;
	}

	void TextLayoutDrawHelper::drawText(
		const rendering::ViewState& rViewState, 
		const rendering::RenderState& rRenderState,
		const ::basegfx::B2ISize& rOutputOffset,
		const rendering::StringContext& rText,
		const uno::Sequence< double >& rLogicalAdvancements,
		const uno::Reference< ::com::sun::star::rendering::XCanvasFont >& rCanvasFont,
		const geometry::Matrix2D& rFontMatrix)
	{
		if(mpVirtualDevice && rText.Length)
		{
			// create the DXArray
			::boost::scoped_array<sal_Int32> pDXArray( new sal_Int32[rLogicalAdvancements.getLength()] );
			::comphelper::sequenceToArray(pDXArray.get(), rLogicalAdvancements);

			// set text color. Make sure to remove transparence part first.
            Color aColor( rRenderState.DeviceColor.getLength() > 2 
				? ::vcl::unotools::sequenceToColor(mxGraphicDevice, rRenderState.DeviceColor) 
				: COL_WHITE);
            aColor.SetTransparency(0);
			mpVirtualDevice->SetTextColor(aColor);

			// create the font
			const ::com::sun::star::rendering::FontRequest& rFontRequest = rCanvasFont->getFontRequest();
			Font aFont(
				rFontRequest.FontDescription.FamilyName,
				rFontRequest.FontDescription.StyleName,
				Size( 0, ::basegfx::fround(rFontRequest.CellSize)));

			aFont.SetAlign( ALIGN_BASELINE );
			aFont.SetCharSet( (rFontRequest.FontDescription.IsSymbolFont==com::sun::star::util::TriState_YES) ? RTL_TEXTENCODING_SYMBOL : RTL_TEXTENCODING_UNICODE );
			aFont.SetVertical( (rFontRequest.FontDescription.IsVertical==com::sun::star::util::TriState_YES) ? TRUE : FALSE );
			aFont.SetWeight( static_cast<FontWeight>(rFontRequest.FontDescription.FontDescription.Weight) );
			aFont.SetItalic( (rFontRequest.FontDescription.FontDescription.Letterform<=8) ? ITALIC_NONE : ITALIC_NORMAL );

            // setup font color
            aFont.SetColor( aColor );
            aFont.SetFillColor( aColor );

			// adjust to stretched font
			if(!::rtl::math::approxEqual(rFontMatrix.m00, rFontMatrix.m11))
			{
				const Size aSize = mpVirtualDevice->GetFontMetric( aFont ).GetSize();
				const double fDividend( rFontMatrix.m10 + rFontMatrix.m11 );
				double fStretch = (rFontMatrix.m00 + rFontMatrix.m01);            

				if( !::basegfx::fTools::equalZero( fDividend) )
					fStretch /= fDividend;

				const long nNewWidth = ::basegfx::fround( aSize.Width() * fStretch );

				aFont.SetWidth( nNewWidth );
			}

			// set font
			mpVirtualDevice->SetFont(aFont);

			// create world transformation matrix
	        ::basegfx::B2DHomMatrix aWorldTransform;
			::canvas::tools::mergeViewAndRenderTransform(aWorldTransform, rViewState, rRenderState);

			if(!rOutputOffset.equalZero())
			{
				aWorldTransform.translate(rOutputOffset.getX(), rOutputOffset.getY());
			}

			// set ViewState clipping
			if(rViewState.Clip.is())
			{
				::basegfx::B2DPolyPolygon aClipPoly(dxcanvas::tools::polyPolygonFromXPolyPolygon2D(rViewState.Clip));
				::basegfx::B2DHomMatrix aMatrix;
				::basegfx::unotools::homMatrixFromAffineMatrix(aMatrix, rViewState.AffineTransform );
				
				if(!rOutputOffset.equalZero())
				{
					aMatrix.translate(rOutputOffset.getX(), rOutputOffset.getY());
				}

				aClipPoly.transform(aMatrix);
				const Region& rClipRegion = Region(::PolyPolygon(aClipPoly));
				mpVirtualDevice->IntersectClipRegion(rClipRegion);
			}

			if(rRenderState.Clip.is())
			{
				::basegfx::B2DPolyPolygon aClipPoly(dxcanvas::tools::polyPolygonFromXPolyPolygon2D(rRenderState.Clip));
				aClipPoly.transform(aWorldTransform);
				const Region& rClipRegion = Region(::PolyPolygon(aClipPoly));
				mpVirtualDevice->IntersectClipRegion(rClipRegion);
			}

			// set world transform
			XFORM aXForm;
			aXForm.eM11 = (FLOAT)aWorldTransform.get(0, 0);
			aXForm.eM12 = (FLOAT)aWorldTransform.get(1, 0);
			aXForm.eM21 = (FLOAT)aWorldTransform.get(0, 1);
			aXForm.eM22 = (FLOAT)aWorldTransform.get(1, 1);
			aXForm.eDx = (FLOAT)aWorldTransform.get(0, 2);
			aXForm.eDy = (FLOAT)aWorldTransform.get(1, 2);

			SetGraphicsMode(maHDC, GM_ADVANCED);
			SetTextAlign(maHDC, TA_BASELINE);
			SetWorldTransform(maHDC, &aXForm);

			// use a empty StartPosition for text rendering
			const Point aEmptyPoint(0, 0);

			// create the String
			const String aText(rText.Text.getStr());

			// draw the String
			mpVirtualDevice->DrawTextArray(aEmptyPoint, aText, 
				pDXArray.get(), (xub_StrLen)rText.StartPosition, (xub_StrLen)rText.Length);
		}
	}
}

// eof
