#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.10 $
#
#   last change: $Author: rt $ $Date: 2005/09/09 07:23:12 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..$/..
PRJNAME=sdk_oo
TARGET=copying

#----------------------------------------------------------------
.INCLUDE: settings.mk
.INCLUDE: $(PRJ)$/util$/makefile.pmk
#----------------------------------------------------------------

IDL_DOCU_INDEX_FILE = $(DESTDIRGENIDLREF)$/module-ix.html
IDL_CHAPTER_REFS=idl_chapter_refs.txt

DOCUHTMLFILES= \
    $(DESTDIR)$/index.html \
    $(DESTDIRDOCU)$/tools.html \
    $(DESTDIRDOCU)$/notsupported.html \
    $(DESTDIRDOCU)$/install.html \
    $(DESTDIRDOCU)$/DevelopersGuide_intro.html \
    $(DESTDIREXAMPLES)$/examples.html \
    $(DESTDIREXAMPLES)$/DevelopersGuide$/examples.html

DOCUFILES= \
    $(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.htm \
    $(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.pdf
#    $(DESTDIRDOCU)$/sdk_styles.css \
#    $(DESTDIRDOCUIMAGES)$/logo.gif \
#    $(DESTDIRDOCUIMAGES)$/sdk_logo.gif

.IF "$(GUI)"=="WNT"
DOCUFILES += \
    $(DESTDIR)$/license.html \
    $(DESTDIR)$/license.txt
.ELSE
DOCUFILES += \
    $(DESTDIR)$/license.html \
    $(DESTDIR)$/LICENSE
.ENDIF

DIR_FILE_LIST=\
    $(DOCUFILES) \
    $(DESTDIR)$/settings$/dk.mk \
    $(IDL_DOCU_INDEX_FILE) \
    $(CONVERTTAGFLAG) 

DIR_DIRECTORY_LIST=$(uniq $(DIR_FILE_LIST:d))
DIR_FILE_FLAG=$(MISC)$/copying_files.txt

all : 	\
    $(DIR_FILE_LIST) \
    $(DIR_FILE_FLAG)

#$(DESTDIRDOCU)$/sdk_styles.css : $(PRJ)$/docs$/sdk_styles.css
#	+-rm -f $(CONVERTTAGFLAG) >& $(NULLDEV)
#	$(MY_COPY) $? $@

$(DESTDIR)$/license.html : $(PRJ)$/license$/license.html
	+-$(MKDIRHIER) $(@:d)        
	+-rm -f $@ >& $(NULLDEV)
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $? $(MY_TEXTCOPY_TARGETPRE) $@

$(DESTDIR)$/license.txt : $(PRJ)$/license$/license.txt
	+-$(MKDIRHIER) $(@:d)        
	+-rm -f $@ >& $(NULLDEV)
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $? $(MY_TEXTCOPY_TARGETPRE) $@

$(DESTDIR)$/LICENSE : $(PRJ)$/license$/LICENSE
	+-$(MKDIRHIER) $(@:d)        
	+-rm -f $@ >& $(NULLDEV)
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $? $(MY_TEXTCOPY_TARGETPRE) $@

#$(DESTDIRDOCUIMAGES)$/% : $(PRJ)$/docs$/images$/%
#	+-rm -f $@ >& $(NULLDEV)
#	$(MY_COPY) $? $@

$(DESTDIR)$/settings$/dk.mk :
	+-$(MKDIRHIER) $(@:d)    
	+-rm -f $@ >& $(NULLDEV)
	echo #$(PRODUCT_NAME) dependent settings > $@
	echo SDKNAME=$(PRODUCT_NAME)>> $@
.IF "$(GUI)"=="UNX" || "$(USE_SHELL)"!="4nt"
	echo 'BUILDID= $(RSCREVISION)'>> $@
.ELSE
	echo BUILDID= $(RSCREVISION)>> $@
.ENDIF
.IF "$(GUI)"=="WNT"
	+$(RENAME) $(BIN)$/$(PRODUCT_NAME)$/configureWindows.bat $(BIN)$/$(PRODUCT_NAME)$/configureWindows.bat_
	+cat $(BIN)$/$(PRODUCT_NAME)$/configureWindows.bat_ | sed 's/\[SDKNAME\]/$(PRODUCT_NAME)/g' > $(BIN)$/$(PRODUCT_NAME)$/configureWindows.bat
	+rm $(BIN)$/$(PRODUCT_NAME)$/configureWindows.bat_
	+$(RENAME) $(BIN)$/$(PRODUCT_NAME)$/setsdkenv_windows.bat $(BIN)$/$(PRODUCT_NAME)$/setsdkenv_windows.bat_
	+cat $(BIN)$/$(PRODUCT_NAME)$/setsdkenv_windows.bat_ | sed 's/\[SDKNAME\]/$(PRODUCT_NAME)/g' > $(BIN)$/$(PRODUCT_NAME)$/setsdkenv_windows.bat
	+rm $(BIN)$/$(PRODUCT_NAME)$/setsdkenv_windows.bat_
.ENDIF

$(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.pdf : DevelopersGuide.pdf
	+-$(MKDIRHIER) $(@:d)    
	+-rm -f $@ >& $(NULLDEV)
	$(MY_COPY) DevelopersGuide.pdf $(DESTDIRDOCU)$/DevelopersGuide

$(DESTDIRDOCU)$/DevelopersGuide$/DevelopersGuide.htm : DevelopersGuide.zip
	+-$(MKDIRHIER) $(@:d)    
	+unzip -quod $(DESTDIRDOCU) DevelopersGuide.zip && touch $@

$(CONVERTTAGFLAG) : $(MISC)$/deltree.txt
    +$(PERL) $(CONVERTTAGSCRIPT) 1 $(TITLE) $(OFFICEPRODUCTNAME) $(DOCUHTMLFILES)
    @echo "tags converted" > $@

$(IDL_DOCU_INDEX_FILE) : $(IDL_CHAPTER_REFS) $(IDLFILES)
	+-$(MKDIRHIER) $(@:d)        
	+$(MY_AUTODOC) -html $(DESTDIRGENIDLREF) -dvgroot ../../DevelopersGuide -sincefile apiref-autodoc.since  -name $(IDLDOCREFNAME) -lg \
	idl -dvgfile $(IDL_CHAPTER_REFS) -t $(DESTDIRIDL)
	+-rm $(@:d)$/idl.css
	$(MY_TEXTCOPY) $(MY_TEXTCOPY_SOURCEPRE) $(PRJ)$/docs$/common$/ref$/idl.css $(MY_TEXTCOPY_TARGETPRE) $(@:d)$/idl.css


$(DIR_FILE_FLAG) : $(DIR_FILE_LIST)
    @echo "must be zipped" > $@

