package com.sun.star.wizards.tutorial.executer.util;

import com.sun.star.accessibility.XAccessibleContext;

/**
 * This class contains all important child properties.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class Child {
	private XAccessibleContext m_context = null;
	private int m_count = -1;

	/**
	 * Create a new Child.
	 *
	 * @param context node
	 * @param count node index in parent node
	 *
	 * @return Child object
	 */
	public static Child createNewChild(XAccessibleContext context, int count) {
		Child child = new Child();
		child.m_context = context;
		child.m_count = count;

		return child;
	}

	/**
	 * Get the context form child object
	 *
	 * @return child context
	 */
	public XAccessibleContext getXAccessibleContext() {
		return m_context;
	}

	/**
	 * Get the child index in parent node
	 *
	 * @return child index
	 */
	public int getIndex() {
		return m_count;
	}
}
