/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: starmath_view.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:07:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLE_HPP_
// auto strip #include <com/sun/star/accessibility/XAccessible.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTOBJECT_HPP_
// auto strip #include <com/sun/star/accessibility/AccessibleEventObject.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
// auto strip #include <com/sun/star/accessibility/AccessibleEventId.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
// auto strip #include <com/sun/star/accessibility/AccessibleStateType.hpp>
// auto strip #endif

// auto strip #ifndef _SV_MENU_HXX //autogen
// auto strip #include <vcl/menu.hxx>
// auto strip #endif
#ifndef _SV_DECOVIEW_HXX //autogen
#include <vcl/decoview.hxx>
#endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif

#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
// auto strip #ifndef _UNDO_HXX //autogen
// auto strip #include <svtools/undo.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXPTITEM_HXX //autogen
// auto strip #include <svtools/ptitem.hxx>
// auto strip #endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
// auto strip #ifndef _SFXITEMSET_HXX //autogen
// auto strip #include <svtools/itemset.hxx>
// auto strip #endif
// auto strip #ifndef _SFXPOOLITEM_HXX //autogen
// auto strip #include <svtools/poolitem.hxx>
// auto strip #endif

// auto strip #ifndef _SFXMSG_HXX //autogen
// auto strip #include <bf_sfx2/msg.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_PRINTER_HXX //autogen
// auto strip #include <bf_sfx2/printer.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif

#ifndef _SVX_ZOOMITEM_HXX //autogen
#include <bf_svx/zoomitem.hxx>
#endif
// auto strip #ifndef _SVX_ZOOM_HXX //autogen
// auto strip #include <bf_svx/zoom.hxx>
// auto strip #endif
#ifndef _MyEDITENG_HXX
#include <bf_svx/editeng.hxx>
#endif
// auto strip #ifndef _SV_WRKWIN_HXX //autogen
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif
// auto strip #ifndef _TRANSFER_HXX
// auto strip #include <svtools/transfer.hxx>
// auto strip #endif


#ifndef VIEW_HXX
#include "view.hxx"
#endif
#ifndef DOCUMENT_HXX
#include "document.hxx"
#endif
// auto strip #ifndef CONFIG_HXX
// auto strip #include "config.hxx"
// auto strip #endif
#ifndef TOOLBOX_HXX
#include "toolbox.hxx"
#endif
#ifndef DIALOG_HXX
#include "dialog.hxx"
#endif
#ifndef _STARMATH_HRC
#include "starmath.hrc"
#endif


#define MINWIDTH		200
#define MINHEIGHT		200
#define MINSPLIT		40
#define SPLITTERWIDTH	2

#define MINZOOM 25
#define MAXZOOM 800

#define SmViewShell
namespace binfilter {
#include "smslots.hxx"

using namespace ::com::sun::star::accessibility;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;

//////////////////////////////////////////////////////////////////////

/*N*/ SmGraphicWindow::SmGraphicWindow(SmViewShell* pShell):
/*N*/ 	ScrollableWindow(&pShell->GetViewFrame()->GetWindow(), 0),
//STRIP001     pAccessible(0),
/*N*/ 	pViewShell(pShell),
/*N*/ 	nZoom(100),
/*N*/ 	bIsCursorVisible(FALSE)
/*N*/ {
/*N*/ 	Hide();
/*N*/ 	const Fraction aFraction (1,1);
/*N*/ 	SetMapMode( MapMode(MAP_100TH_MM, Point(), aFraction, aFraction));
/*N*/ 
/*N*/     ApplyColorConfigValues( SM_MOD1()->GetColorConfig() );
/*N*/ 
/*N*/     SetTotalSize();
/*N*/ 
/*N*/ 	SetHelpId(HID_SMA_WIN_DOCUMENT);
/*N*/ 	SetUniqueId(HID_SMA_WIN_DOCUMENT);
/*N*/ }

/*N*/ SmGraphicWindow::~SmGraphicWindow()
/*N*/ {
//STRIP001 /*N*/     if (pAccessible)
//STRIP001 /*?*/         pAccessible->ClearWin();    // make Accessible defunctional
/*N*/     // Note: memory for pAccessible will be freed when the reference
/*N*/     // xAccessible is released.
/*N*/ }

/*N*/  void SmGraphicWindow::StateChanged( StateChangedType eType )
/*N*/  {
/*N*/  	if ( eType == STATE_CHANGE_INITSHOW )
/*N*/  		Show();
/*N*/  	ScrollableWindow::StateChanged( eType );
/*N*/  }


/*N*/ void SmGraphicWindow::ApplyColorConfigValues( const svtools::ColorConfig &rColorCfg )
/*N*/ {
/*N*/     // Note: SetTextColor not necessary since the nodes that
/*N*/     // get painted have the color information.
/*N*/ #if OSL_DEBUG_LEVEL > 1
/*N*/ 	ColorData nVal = rColorCfg.GetColorValue(svtools::DOCCOLOR).nColor;
/*N*/ #endif
/*N*/     SetBackground( Color( (ColorData) rColorCfg.GetColorValue(svtools::DOCCOLOR).nColor ) );
/*N*/     Invalidate();
/*N*/ }


//STRIP001 void SmGraphicWindow::DataChanged( const DataChangedEvent& rEvt )
//STRIP001 {
//STRIP001     ApplyColorConfigValues( SM_MOD1()->GetColorConfig() );
//STRIP001 
//STRIP001     ScrollableWindow::DataChanged( rEvt );
//STRIP001 }


//STRIP001 void SmGraphicWindow::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 //	GrabFocus();
//STRIP001 
//STRIP001 	ScrollableWindow::MouseButtonDown(rMEvt);
//STRIP001 
//STRIP001 	//
//STRIP001 	// set formula-cursor and selection of edit window according to the
//STRIP001 	// position clicked at
//STRIP001 	//
//STRIP001 	DBG_ASSERT(rMEvt.GetClicks() > 0, "Sm : 0 clicks");
//STRIP001 	if ( rMEvt.IsLeft() && pViewShell->GetEditWindow() )
//STRIP001 	{
//STRIP001 		const SmNode *pTree = pViewShell->GetDoc()->GetFormulaTree();
//STRIP001 		//! kann NULL sein! ZB wenn bereits beim laden des Dokuments (bevor der
//STRIP001 		//! Parser angeworfen wurde) ins Fenster geklickt wird.
//STRIP001 		if (!pTree)
//STRIP001 			return;
//STRIP001 
//STRIP001 		// get click position relativ to formula
//STRIP001 		Point  aPos (PixelToLogic(rMEvt.GetPosPixel())
//STRIP001 					 - GetFormulaDrawPos());
//STRIP001 
//STRIP001 		// if it was clicked inside the formula then get the appropriate node
//STRIP001 		const SmNode *pNode = 0;
//STRIP001 		if (pTree->OrientedDist(aPos) <= 0)
//STRIP001 			pNode = pTree->FindRectClosestTo(aPos);
//STRIP001 
//STRIP001 		if (pNode)
//STRIP001 		{	SmEditWindow  *pEdit = pViewShell->GetEditWindow();
//STRIP001 			const SmToken  aToken (pNode->GetToken());
//STRIP001 
//STRIP001 #ifdef notnow
//STRIP001 			// include introducing symbols of special char and text
//STRIP001 			// (ie '%' and '"')
//STRIP001 			USHORT  nExtra = (aToken.eType == TSPECIAL  ||  aToken.eType == TTEXT) ? 1 : 0;
//STRIP001 
//STRIP001 			// set selection to the beginning of the token
//STRIP001 			ESelection  aSel (aToken.nRow - 1, aToken.nCol - 1 - nExtra);
//STRIP001 
//STRIP001 			if (rMEvt.GetClicks() != 1)
//STRIP001 			{	// select whole token
//STRIP001 				// for text include terminating symbol (ie '"')
//STRIP001 				aSel.nEndPos += aToken.aText.Len() + nExtra
//STRIP001 								+ (aToken.eType == TTEXT ? 1 : 0);
//STRIP001 			}
//STRIP001 #endif
//STRIP001 			// set selection to the beginning of the token
//STRIP001 			ESelection	aSel (aToken.nRow - 1, aToken.nCol - 1);
//STRIP001 
//STRIP001 			if (rMEvt.GetClicks() != 1)
//STRIP001 				aSel.nEndPos += aToken.aText.Len();
//STRIP001 
//STRIP001 			pEdit->SetSelection(aSel);
//STRIP001 			SetCursor(pNode);
//STRIP001 
//STRIP001 			// allow for immediate editing and
//STRIP001 			//! implicitly synchronize the cursor position mark in this window
//STRIP001 			pEdit->GrabFocus();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*N*/ void SmGraphicWindow::GetFocus()
/*N*/ {
/*N*/     ScrollableWindow::GetFocus();
//STRIP001 /*N*/     if (xAccessible.is())
//STRIP001 /*N*/     {
//STRIP001 /*?*/         uno::Any aOldValue, aNewValue;
//STRIP001 /*?*/         // aOldValue remains empty
//STRIP001 /*?*/         aNewValue <<= AccessibleStateType::FOCUSED;
//STRIP001 /*?*/         pAccessible->LaunchEvent( AccessibleEventId::STATE_CHANGED,
//STRIP001 /*?*/                 aOldValue, aNewValue );
//STRIP001 /*N*/     }
/*N*/ }

/*N*/ void SmGraphicWindow::LoseFocus()
/*N*/ {
/*N*/     ScrollableWindow::LoseFocus();
//STRIP001 /*N*/     if (xAccessible.is())
//STRIP001 /*N*/     {
//STRIP001 /*?*/         uno::Any aOldValue, aNewValue;
//STRIP001 /*?*/         aOldValue <<= AccessibleStateType::FOCUSED;
//STRIP001 /*?*/         // aNewValue remains empty
//STRIP001 /*?*/         pAccessible->LaunchEvent( AccessibleEventId::STATE_CHANGED,
//STRIP001 /*?*/                 aOldValue, aNewValue );
//STRIP001 /*N*/     }
/*N*/ }

/*N*/ void SmGraphicWindow::ShowCursor(BOOL bShow)
/*N*/ 	// shows or hides the formula-cursor depending on 'bShow' is TRUE or not
/*N*/ {
/*N*/ 	BOOL  bInvert = bShow != IsCursorVisible();
/*N*/ 
/*N*/ 	if (bInvert)
/*N*/ 		InvertTracking(aCursorRect, SHOWTRACK_SMALL | SHOWTRACK_WINDOW);
/*N*/ 
/*N*/ 	SetIsCursorVisible(bShow);
/*N*/ }


/*N*/ void SmGraphicWindow::SetCursor(const SmNode *pNode)
/*N*/ {
/*N*/ 	const SmNode *pTree = pViewShell->GetDoc()->GetFormulaTree();
/*N*/ 
/*N*/ 	// get appropriate rectangle
/*N*/ 	Point aOffset (pNode->GetTopLeft() - pTree->GetTopLeft()),
/*N*/ 		  aTLPos  (GetFormulaDrawPos() + aOffset);
/*N*/ 	aTLPos.X() -= pNode->GetItalicLeftSpace();
/*N*/ 	Size  aSize   (pNode->GetItalicSize());
/*N*/ 	Point aBRPos  (aTLPos.X() + aSize.Width(), aTLPos.Y() + aSize.Height());
/*N*/ 
/*N*/ 	SetCursor(Rectangle(aTLPos, aSize));
/*N*/ }

/*N*/ void SmGraphicWindow::SetCursor(const Rectangle &rRect)
/*N*/ 	// sets cursor to new position (rectangle) 'rRect'.
/*N*/ 	// The old cursor will be removed, and the new one will be shown if
/*N*/ 	// that is activated in the ConfigItem
/*N*/ {
/*N*/ 	SmModule *pp = SM_MOD1();
/*N*/ 
/*N*/ 	if (IsCursorVisible())
/*?*/ 		ShowCursor(FALSE);		// clean up remainings of old cursor
/*N*/ 	aCursorRect = rRect;
/*N*/ 	if (pp->GetConfig()->IsShowFormulaCursor())
/*N*/ 		ShowCursor(TRUE);		// draw new cursor
/*N*/ }

/*N*/ const SmNode * SmGraphicWindow::SetCursorPos(USHORT nRow, USHORT nCol)
/*N*/ 	// looks for a VISIBLE node in the formula tree with it's token at
/*N*/ 	// (or around) the position 'nRow', 'nCol' in the edit window
/*N*/ 	// (row and column numbering starts with 1 there!).
/*N*/ 	// If there is such a node the formula-cursor is set to cover that nodes
/*N*/ 	// rectangle. If not the formula-cursor will be hidden.
/*N*/ 	// In any case the search result is being returned.
/*N*/ {
/*N*/ 	// find visible node with token at nRow, nCol
/*N*/ 	const SmNode *pTree = pViewShell->GetDoc()->GetFormulaTree(),
/*N*/ 				 *pNode = 0;
/*N*/ 	if (pTree)
/*N*/ 		pNode = pTree->FindTokenAt(nRow, nCol);
/*N*/ 
/*N*/ 	if (pNode)
/*N*/ 		SetCursor(pNode);
/*N*/ 	else
/*N*/ 		ShowCursor(FALSE);
/*N*/ 
/*N*/ 	return pNode;
/*N*/ }


/*N*/ void SmGraphicWindow::Paint(const Rectangle&)
/*N*/ {
/*N*/ 	DBG_ASSERT(pViewShell, "Sm : NULL pointer");
/*N*/ 
/*N*/ 	SmDocShell &rDoc = *pViewShell->GetDoc();
/*N*/ 	Point aPoint;
/*N*/ 
/*N*/ 	rDoc.Draw(*this, aPoint);	//! modifies aPoint to be the topleft
/*N*/ 								//! corner of the formula
/*N*/ 	SetFormulaDrawPos(aPoint);
/*N*/ 
/*N*/ 	SetIsCursorVisible(FALSE);	// (old) cursor must be drawn again
/*N*/ 
/*N*/ 	const SmEditWindow *pEdit = pViewShell->GetEditWindow();
/*N*/ 	if (pEdit)
/*N*/ 	{	// get new position for formula-cursor (for possible altered formula)
/*N*/ 		USHORT	nRow, nCol;
/*N*/ 		SmGetLeftSelectionPart(pEdit->GetSelection(), nRow, nCol);
/*N*/ 		nRow++;
/*N*/ 		nCol++;
/*N*/ 		const SmNode *pFound = SetCursorPos(nRow, nCol);
/*N*/ 
/*N*/ 		SmModule  *pp = SM_MOD1();
/*N*/ 		if (pFound && pp->GetConfig()->IsShowFormulaCursor())
/*?*/ 			ShowCursor(TRUE);
/*N*/ 	}
/*N*/ }


/*N*/ void SmGraphicWindow::SetTotalSize ()
/*N*/ {
/*N*/ 	SmDocShell &rDoc = *pViewShell->GetDoc();
/*N*/ 	const Size aTmp( PixelToLogic( LogicToPixel( rDoc.GetSize() )));
/*N*/ 	if ( aTmp != ScrollableWindow::GetTotalSize() )
/*N*/ 		ScrollableWindow::SetTotalSize( aTmp );
/*N*/ }


//STRIP001 void SmGraphicWindow::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	if (! (SfxViewShell::Current() &&
//STRIP001 		   SfxViewShell::Current()->KeyInput(rKEvt)))
//STRIP001 		ScrollableWindow::KeyInput(rKEvt);
//STRIP001 }


//STRIP001 void SmGraphicWindow::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	BOOL bCallBase = TRUE;
//STRIP001 	if ( !pViewShell->GetDoc()->GetProtocol().IsInPlaceActive() )
//STRIP001 	{
//STRIP001 		switch ( rCEvt.GetCommand() )
//STRIP001 		{
//STRIP001 			case COMMAND_CONTEXTMENU:
//STRIP001 			{
//STRIP001 				GetParent()->ToTop();
//STRIP001                 SmResId aResId( RID_VIEWMENU );
//STRIP001                 PopupMenu* pPopupMenu = new PopupMenu(aResId);
//STRIP001 				pPopupMenu->SetSelectHdl(LINK(this, SmGraphicWindow, MenuSelectHdl));
//STRIP001                 Point aPos(5, 5);
//STRIP001                 if (rCEvt.IsMouseEvent())
//STRIP001                     aPos = rCEvt.GetMousePosPixel();
//STRIP001                 DBG_ASSERT( pViewShell, "view shell missing" );
//STRIP001 
//STRIP001                 // added for replaceability of context menus #96085, #93782
//STRIP001                 pViewShell->GetViewFrame()->GetBindings().GetDispatcher()
//STRIP001                         ->ExecutePopup( aResId, this, &aPos );
//STRIP001                 //pPopupMenu->Execute( this, aPos );
//STRIP001 
//STRIP001 				delete pPopupMenu;
//STRIP001 				bCallBase = FALSE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case COMMAND_WHEEL:
//STRIP001 			{
//STRIP001 				const CommandWheelData* pWData = rCEvt.GetWheelData();
//STRIP001 				if  ( pWData && COMMAND_WHEEL_ZOOM == pWData->GetMode() )
//STRIP001 				{
//STRIP001 					USHORT nZoom = GetZoom();
//STRIP001 					if( 0L > pWData->GetDelta() )
//STRIP001 						nZoom -= 10;
//STRIP001 					else
//STRIP001 						nZoom += 10;
//STRIP001 					SetZoom( nZoom );
//STRIP001 					bCallBase = FALSE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( bCallBase )
//STRIP001 		ScrollableWindow::Command (rCEvt);
//STRIP001 }


//STRIP001 IMPL_LINK_INLINE_START( SmGraphicWindow, MenuSelectHdl, Menu *, pMenu )
//STRIP001 {
//STRIP001 	SmViewShell *pViewSh = SmGetActiveView();
//STRIP001 	if (pViewSh)
//STRIP001 		pViewSh->GetViewFrame()->GetDispatcher()->Execute( pMenu->GetCurItemId() );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SmGraphicWindow, MenuSelectHdl, Menu *, pMenu )


//STRIP001 void SmGraphicWindow::SetZoom(USHORT Factor)
//STRIP001 {
//STRIP001 	nZoom = Min(Max((USHORT) Factor, (USHORT) MINZOOM), (USHORT) MAXZOOM);
//STRIP001 	Fraction   aFraction (nZoom, 100);
//STRIP001 	SetMapMode( MapMode(MAP_100TH_MM, Point(), aFraction, aFraction) );
//STRIP001 	SetTotalSize();
//STRIP001 	SmViewShell *pViewSh = SmGetActiveView();
//STRIP001 	if (pViewSh)
//STRIP001 		pViewSh->GetViewFrame()->GetBindings().Invalidate(SID_ATTR_ZOOM);
//STRIP001 	Invalidate();
//STRIP001 }


//STRIP001 void SmGraphicWindow::ZoomToFitInWindow()
//STRIP001 {
//STRIP001 	SmDocShell &rDoc = *pViewShell->GetDoc();
//STRIP001 
//STRIP001 	// set defined mapmode before calling 'LogicToPixel' below
//STRIP001 	SetMapMode(MapMode(MAP_100TH_MM));
//STRIP001 
//STRIP001 	Size	   aSize (LogicToPixel(rDoc.GetSize()));
//STRIP001 	Size	   aWindowSize (GetSizePixel());
//STRIP001 
//STRIP001 	if (aSize.Width() > 0  &&  aSize.Height() > 0)
//STRIP001 		SetZoom (Min ((85 * aWindowSize.Width())  / aSize.Width(),
//STRIP001 					  (85 * aWindowSize.Height()) / aSize.Height()));
//STRIP001 }

//STRIP001 uno::Reference< XAccessible > SmGraphicWindow::CreateAccessible()
//STRIP001 {
//STRIP001     if (!pAccessible)
//STRIP001     {
//STRIP001         pAccessible = new SmGraphicAccessible( this );
//STRIP001         xAccessible = pAccessible;
//STRIP001     }
//STRIP001     return xAccessible;
//STRIP001 }

/**************************************************************************/


/*N*/ SmGraphicController::SmGraphicController(SmGraphicWindow &rSmGraphic,
/*N*/ 						USHORT			nId,
/*N*/ 						SfxBindings 	&rBindings) :
/*N*/ 	rGraphic(rSmGraphic),
/*N*/ 	SfxControllerItem(nId, rBindings)
/*N*/ {
/*N*/ }


/*N*/ void SmGraphicController::StateChanged(USHORT nSID, SfxItemState eState, const SfxPoolItem* pState)
/*N*/ {
/*N*/ 	rGraphic.SetTotalSize();
/*N*/ 	rGraphic.Invalidate();
/*N*/ 	SfxControllerItem::StateChanged (nSID, eState, pState);
/*N*/ }


/**************************************************************************/


/*N*/ SmEditController::SmEditController(SmEditWindow &rSmEdit,
/*N*/ 					 USHORT 	  nId,
/*N*/ 					 SfxBindings  &rBindings) :
/*N*/ 	rEdit(rSmEdit),
/*N*/ 	SfxControllerItem(nId, rBindings)
/*N*/ {
/*N*/ }


/*N*/ #if OSL_DEBUG_LEVEL > 1
/*N*/ SmEditController::~SmEditController()
/*N*/ {
/*N*/ }
#endif


/*N*/ void SmEditController::StateChanged(USHORT nSID, SfxItemState eState, const SfxPoolItem* pState)
/*N*/ {
/*N*/ 	const SfxStringItem *pItem = PTR_CAST(SfxStringItem, pState);
/*N*/ 
/*N*/ 	if ((pItem != NULL) && (rEdit.GetText() != pItem->GetValue()))
/*N*/ 		rEdit.SetText(pItem->GetValue());
/*N*/ 	SfxControllerItem::StateChanged (nSID, eState, pState);
/*N*/ }


/**************************************************************************/

/*N*/ SmCmdBoxWindow::SmCmdBoxWindow(SfxBindings *pBindings, SfxChildWindow *pChildWindow,
/*N*/ 							   Window *pParent) :
/*N*/ 	SfxDockingWindow(pBindings, pChildWindow, pParent, SmResId(RID_CMDBOXWINDOW)),
/*N*/     aEdit       (*this),
/*N*/     aController (aEdit, SID_TEXT, *pBindings),
/*N*/     bExiting    (FALSE)
/*N*/ {
/*N*/ 	Hide ();
/*N*/ 	aGrabTimer.SetTimeout (1000);
/*N*/ 	aGrabTimer.SetTimeoutHdl (LINK (this, SmCmdBoxWindow, UpdateTimeoutHdl));
/*N*/ 	aGrabTimer.Start ();
/*N*/ }


/*N*/ SmCmdBoxWindow::~SmCmdBoxWindow ()
/*N*/ {
/*N*/     bExiting = TRUE;
/*N*/ 	aGrabTimer.Stop ();
/*N*/ }


/*N*/ SmViewShell * SmCmdBoxWindow::GetView()
/*N*/ {
/*N*/     SfxViewShell *pView = GetBindings().GetDispatcher()->GetFrame()->GetViewShell();
/*N*/     return PTR_CAST(SmViewShell, pView);
/*N*/ }

//STRIP001 void SmCmdBoxWindow::Resize()
//STRIP001 {
//STRIP001 	Rectangle aRect = Rectangle(Point(0, 0), GetOutputSizePixel());
//STRIP001 
//STRIP001 	if (! IsFloatingMode())
//STRIP001 	{
//STRIP001 		switch (GetAlignment())
//STRIP001 		{
//STRIP001 			case SFX_ALIGN_TOP:		aRect.Bottom()--;	break;
//STRIP001 			case SFX_ALIGN_BOTTOM:	aRect.Top()++;		break;
//STRIP001 			case SFX_ALIGN_LEFT:	aRect.Right()--;	break;
//STRIP001 			case SFX_ALIGN_RIGHT:	aRect.Left()++;		break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	DecorationView aView(this);
//STRIP001 	aRect.Left() += 8; aRect.Top()	 += 8;
//STRIP001 	aRect.Right()-= 8; aRect.Bottom()-= 8;
//STRIP001 	aRect = aView.DrawFrame( aRect, FRAME_DRAW_DOUBLEIN );
//STRIP001 
//STRIP001 	aEdit.SetPosSizePixel(aRect.TopLeft(), aRect.GetSize());
//STRIP001 	SfxDockingWindow::Resize();
//STRIP001 	Invalidate();
//STRIP001 }


/*N*/ void SmCmdBoxWindow::Paint(const Rectangle& rRect)
/*N*/ {
/*N*/ 	Rectangle aRect = Rectangle(Point(0, 0), GetOutputSizePixel());
/*N*/ 	DecorationView aView(this);
/*N*/ 
/*N*/ 	if (! IsFloatingMode())
/*N*/ 	{
/*?*/ 		Point aFrom, aTo;
/*?*/ 		switch (GetAlignment())
/*?*/ 		{
/*?*/ 			case SFX_ALIGN_TOP:
/*?*/ 				aFrom = aRect.BottomLeft(); aTo = aRect.BottomRight();
/*?*/ 				aRect.Bottom()--;
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SFX_ALIGN_BOTTOM:
/*?*/ 				aFrom = aRect.TopLeft(); aTo = aRect.TopRight();
/*?*/ 				aRect.Top()++;
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SFX_ALIGN_LEFT:
/*?*/ 				aFrom = aRect.TopRight(); aTo = aRect.BottomRight();
/*?*/ 				aRect.Right()--;
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SFX_ALIGN_RIGHT:
/*?*/ 				aFrom = aRect.TopLeft(); aTo = aRect.BottomLeft();
/*?*/ 				aRect.Left()++;
/*?*/ 				break;
/*?*/ 		}
/*?*/ 		DrawLine( aFrom, aTo );
/*?*/ 		aView.DrawFrame(aRect, FRAME_DRAW_OUT);
/*N*/ 	}
/*N*/ 	aRect.Left() += 8; aRect.Top()	 += 8;
/*N*/ 	aRect.Right()-= 8; aRect.Bottom()-= 8;
/*N*/ 	aRect = aView.DrawFrame( aRect, FRAME_DRAW_DOUBLEIN );
/*N*/ }


//STRIP001 Size SmCmdBoxWindow::CalcDockingSize(SfxChildAlignment eAlign)
//STRIP001 {
//STRIP001 	switch (eAlign)
//STRIP001 	{
//STRIP001 		case SFX_ALIGN_LEFT:
//STRIP001 		case SFX_ALIGN_RIGHT:
//STRIP001 			return Size();
/*
		case SFX_ALIGN_TOP:
		case SFX_ALIGN_BOTTOM:
*/
//STRIP001 	}
//STRIP001 	return SfxDockingWindow::CalcDockingSize(eAlign);
//STRIP001 }


/*N*/ IMPL_LINK(SmCmdBoxWindow, UpdateTimeoutHdl, Timer *, pTimer)
/*N*/ {
/*N*/ 	aGrabTimer.Stop ();
/*N*/ 	Grab();
/*N*/ 	return 0;
/*N*/ }


/*N*/ void SmCmdBoxWindow::Grab ()
/*N*/ {
/*N*/ 	GrabFocus ();
/*N*/ 	aEdit.GrabFocus ();
/*N*/ }


/*N*/ SfxChildAlignment SmCmdBoxWindow::CheckAlignment(SfxChildAlignment eActual,
/*N*/ 											 SfxChildAlignment eWish)
/*N*/ {
/*N*/ 	switch (eWish)
/*N*/ 	{
/*N*/ 		case SFX_ALIGN_TOP:
/*N*/ 		case SFX_ALIGN_BOTTOM:
/*N*/ 		case SFX_ALIGN_NOALIGNMENT:
/*N*/ 			return eWish;
/*N*/ 	}
/*N*/ 
/*N*/ 	return eActual;
/*N*/ }


/*N*/ void SmCmdBoxWindow::StateChanged( StateChangedType nStateChange )
/*N*/ {
/*N*/ 	if (STATE_CHANGE_INITSHOW == nStateChange)
/*N*/     {
/*N*/         Resize();   // #98848# avoid SmEditWindow not being painted correctly
/*N*/ 
/*N*/         // set initial position of window in floating mode
/*N*/         if (TRUE == IsFloatingMode())
/*N*/             AdjustPosition();   //! don't change pos in docking-mode !
/*N*/     }
/*N*/ 
/*N*/     SfxDockingWindow::StateChanged( nStateChange );
/*N*/ }


/*N*/ void SmCmdBoxWindow::AdjustPosition()
/*N*/ {
/*N*/ 	Point aPt;
/*N*/ 	const Rectangle aRect( aPt, GetParent()->GetOutputSizePixel() );
/*N*/ 	Point aTopLeft( Point( aRect.Left(),
/*N*/ 						   aRect.Bottom() - GetSizePixel().Height() ) );
/*N*/ 	Point aPos( GetParent()->OutputToScreenPixel( aTopLeft ) );
/*N*/ 	if (aPos.X() < 0)
/*?*/ 		aPos.X() = 0;
/*N*/ 	if (aPos.Y() < 0)
/*?*/ 		aPos.Y() = 0;
/*N*/ 	SetPosPixel( aPos );
/*N*/ }


/*N*/ void SmCmdBoxWindow::ToggleFloatingMode()
/*N*/ {
/*N*/ 	SfxDockingWindow::ToggleFloatingMode();
/*N*/ 
/*N*/ 	if (GetFloatingWindow())
/*N*/ 		GetFloatingWindow()->SetMinOutputSizePixel(Size (200, 50));
/*N*/ }


/*N*/ void SmCmdBoxWindow::GetFocus()
/*N*/ {
/*N*/     if (!bExiting)
/*N*/         aEdit.GrabFocus();
/*N*/ }

/**************************************************************************/


/*N*/ SFX_IMPL_DOCKINGWINDOW(SmCmdBoxWrapper, SID_CMDBOXWINDOW);
/*N*/ 
/*N*/ SmCmdBoxWrapper::SmCmdBoxWrapper(Window *pParentWindow, USHORT nId,
/*N*/ 								 SfxBindings *pBindings,
/*N*/ 								 SfxChildWinInfo *pInfo) :
/*N*/ 	SfxChildWindow(pParentWindow, nId)
/*N*/ {
/*N*/ 	pWindow = new SmCmdBoxWindow(pBindings, this, pParentWindow);
/*N*/ 
/*N*/     // make window docked to the bottom initially (after first start)
/*N*/     eChildAlignment = SFX_ALIGN_BOTTOM;
/*N*/     ((SfxDockingWindow *)pWindow)->Initialize(pInfo);
/*N*/ }


#if OSL_DEBUG_LEVEL > 1
/*N*/ SmCmdBoxWrapper::~SmCmdBoxWrapper()
/*N*/ {
/*N*/ }
#endif


//STRIP001 void SmCmdBoxWrapper::Grab ()
//STRIP001 {
//STRIP001 	((SmCmdBoxWindow *)pWindow)->Grab ();
//STRIP001 }


/**************************************************************************/


/*N*/ TYPEINIT1( SmViewShell, SfxViewShell );

/*N*/ SFX_IMPL_INTERFACE(SmViewShell, SfxViewShell, SmResId(0))
/*N*/ {
//STRIP001 /*N*/ 	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_TOOLS | SFX_VISIBILITY_STANDARD |
//STRIP001 /*N*/ 								SFX_VISIBILITY_FULLSCREEN | SFX_VISIBILITY_SERVER,
//STRIP001 /*N*/ 								SmResId(RID_MATH_TOOLBOX ));
/*N*/ 	//Dummy-Objectbar, damit es bei aktivieren nicht staendig zuppelt.
/*N*/ // Wegen #58705# entfernt (RID wurde nirgends verwendet)
/*N*/ //	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT | SFX_VISIBILITY_SERVER,
/*N*/ //								SmResId(RID_DRAW_OBJECTBAR) );
/*N*/ 
//STRIP001 /*N*/ 	SFX_CHILDWINDOW_REGISTRATION(SmToolBoxWrapper::GetChildWindowId());
//STRIP001 /*N*/ 	SFX_CHILDWINDOW_REGISTRATION(SmCmdBoxWrapper::GetChildWindowId());
/*N*/ }


/*N*/ SFX_IMPL_VIEWFACTORY(SmViewShell, SmResId(RID_VIEWNAME))
/*N*/ {
/*N*/ 	SFX_VIEW_REGISTRATION(SmDocShell);
/*N*/ }


//STRIP001 Size SmViewShell::GetOptimalSizePixel() const
//STRIP001 {
//STRIP001 	return aGraphic.LogicToPixel( ((SmViewShell*)this)->GetDoc()->GetSize() );
//STRIP001 }


//STRIP001 void SmViewShell::AdjustPosSizePixel(const Point &rPos, const Size &rSize)
//STRIP001 {
//STRIP001 	aGraphic.SetPosSizePixel(rPos, rSize);
//STRIP001 }


//STRIP001 void SmViewShell::InnerResizePixel(const Point &rOfs, const Size &rSize)
//STRIP001 {
//STRIP001 	//Ein bischen muessen wir schon raten was die Basisklasse tun wird.
//STRIP001 	//Die Scrollbars muessen einkalkuliert werden damit sie Aussen sitzen,
//STRIP001 	//denn genau dafuer steht ja das InnerResize
//STRIP001 	const Size aDocSz = aGraphic.LogicToPixel( GetDoc()->GetSize() );
//STRIP001 		  Size aSize( rSize );
//STRIP001 
//STRIP001 	SvBorder aBorder;
//STRIP001 
//STRIP001 
//STRIP001 	if ( aSize.Width() < aDocSz.Width() )
//STRIP001 	{
//STRIP001 		if ( 1 == (aDocSz.Width() - aSize.Width()) )
//STRIP001 		{
//STRIP001 			//Einen Pixel daneben, kann ja mal passieren.
//STRIP001 			aSize.Width() += 1;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aBorder.Bottom() = Application::GetSettings().GetStyleSettings().GetScrollBarSize();
//STRIP001 			aSize.Height() += aBorder.Bottom();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( aSize.Height() < aDocSz.Height() )
//STRIP001 	{
//STRIP001 		if ( 1 == (aDocSz.Height() - aSize.Height()) )
//STRIP001 		{
//STRIP001 			aSize.Height() += 1;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aBorder.Right() = Application::GetSettings().GetStyleSettings().GetScrollBarSize();
//STRIP001 			aSize.Width() += aBorder.Right();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	SetBorderPixel( aBorder );
//STRIP001 	GetGraphicWindow().SetPosSizePixel(rOfs, aSize);
//STRIP001 	GetGraphicWindow().SetTotalSize();
//STRIP001 }


/*N*/ void SmViewShell::OuterResizePixel(const Point &rOfs, const Size &rSize)
/*N*/ {
/*N*/     SmGraphicWindow &rWin = GetGraphicWindow();
/*N*/     rWin.SetPosSizePixel(rOfs, rSize);
/*N*/     if (GetDoc()->IsPreview())
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/         rWin.ZoomToFitInWindow();
/*N*/     rWin.Update();
/*N*/ }


//STRIP001 void SmViewShell::QueryObjAreaPixel( Rectangle& rRect ) const
//STRIP001 {
//STRIP001 	rRect.SetSize( GetGraphicWindow().GetSizePixel() );
//STRIP001 }


//STRIP001 void SmViewShell::SetZoomFactor( const Fraction &rX, const Fraction &rY )
//STRIP001 {
//STRIP001 	const Fraction &rFrac = rX < rY ? rX : rY;
//STRIP001 	GetGraphicWindow().SetZoom( (USHORT) long(rFrac * Fraction( 100, 1 )) );
//STRIP001 
//STRIP001 	//Um Rundungsfehler zu minimieren lassen wir von der Basisklasse ggf.
//STRIP001 	//auch die krummen Werte einstellen
//STRIP001 	SfxViewShell::SetZoomFactor( rX, rY );
//STRIP001 }


//STRIP001 Size SmViewShell::GetTextLineSize(OutputDevice& rDevice, const String& rLine)
//STRIP001 {
//STRIP001 	String aText;
//STRIP001 	Size   aSize(rDevice.GetTextWidth(rLine), rDevice.GetTextHeight());
//STRIP001 	USHORT nTabs = rLine.GetTokenCount('\t');
//STRIP001 
//STRIP001 	if (nTabs > 0)
//STRIP001 	{
//STRIP001 		long TabPos = rDevice.GetTextWidth('n') * 8;
//STRIP001 
//STRIP001 		aSize.Width() = 0;
//STRIP001 
//STRIP001 		for (USHORT i = 0; i < nTabs; i++)
//STRIP001 		{
//STRIP001 			if (i > 0)
//STRIP001 				aSize.Width() = ((aSize.Width() / TabPos) + 1) * TabPos;
//STRIP001 
//STRIP001 			aText = rLine.GetToken(i, '\t');
//STRIP001 			aText.EraseLeadingChars('\t');
//STRIP001 			aText.EraseTrailingChars('\t');
//STRIP001 			aSize.Width() += rDevice.GetTextWidth(aText);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return aSize;
//STRIP001 }


//STRIP001 Size SmViewShell::GetTextSize(OutputDevice& rDevice, const String& rText, long MaxWidth)
//STRIP001 {
//STRIP001 	Size	aSize;
//STRIP001 	String	aLine;
//STRIP001 	Size	TextSize;
//STRIP001 	String	aText;
//STRIP001 	USHORT	nLines = rText.GetTokenCount('\n');
//STRIP001 
//STRIP001 	for (USHORT i = 0; i < nLines; i++)
//STRIP001 	{
//STRIP001 		aLine = rText.GetToken(i, '\n');
//STRIP001 		aLine.EraseAllChars('\r');
//STRIP001 		aLine.EraseLeadingChars('\n');
//STRIP001 		aLine.EraseTrailingChars('\n');
//STRIP001 
//STRIP001 		aSize = GetTextLineSize(rDevice, aLine);
//STRIP001 
//STRIP001 		if (aSize.Width() > MaxWidth)
//STRIP001 		{
//STRIP001 			do
//STRIP001 			{
//STRIP001 				xub_StrLen m	= aLine.Len();
//STRIP001 				xub_StrLen nLen = m;
//STRIP001 
//STRIP001 				for (xub_StrLen n = 0; n < nLen; n++)
//STRIP001 				{
//STRIP001 					sal_Unicode cLineChar = aLine.GetChar(n);
//STRIP001 					if ((cLineChar == ' ') || (cLineChar == '\t'))
//STRIP001 					{
//STRIP001 						aText = aLine.Copy(0, n);
//STRIP001 						if (GetTextLineSize(rDevice, aText).Width() < MaxWidth)
//STRIP001 							m = n;
//STRIP001 						else
//STRIP001 							break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				aText = aLine.Copy(0, m);
//STRIP001 				aLine.Erase(0, m);
//STRIP001 				aSize = GetTextLineSize(rDevice, aText);
//STRIP001 				TextSize.Height() += aSize.Height();
//STRIP001 				TextSize.Width() = Max(TextSize.Width(), Min(aSize.Width(), MaxWidth));
//STRIP001 
//STRIP001 				aLine.EraseLeadingChars(' ');
//STRIP001 				aLine.EraseLeadingChars('\t');
//STRIP001 				aLine.EraseLeadingChars(' ');
//STRIP001 			}
//STRIP001 			while (aLine.Len() > 0);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			TextSize.Height() += aSize.Height();
//STRIP001 			TextSize.Width() = Max(TextSize.Width(), aSize.Width());
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return TextSize;
//STRIP001 }


//STRIP001 void SmViewShell::DrawTextLine(OutputDevice& rDevice, const Point& rPosition, const String& rLine)
//STRIP001 {
//STRIP001 	String	aText;
//STRIP001 	Point	aPoint (rPosition);
//STRIP001 	USHORT	nTabs = rLine.GetTokenCount('\t');
//STRIP001 
//STRIP001 	if (nTabs > 0)
//STRIP001 	{
//STRIP001 		long TabPos = rDevice.GetTextWidth('n') * 8;
//STRIP001 
//STRIP001 		for (USHORT i = 0; i < nTabs; i++)
//STRIP001 		{
//STRIP001 			if (i > 0)
//STRIP001 				aPoint.X() = ((aPoint.X() / TabPos) + 1) * TabPos;
//STRIP001 
//STRIP001 			aText = rLine.GetToken(i, '\t');
//STRIP001 			aText.EraseLeadingChars('\t');
//STRIP001 			aText.EraseTrailingChars('\t');
//STRIP001 			rDevice.DrawText(aPoint, aText);
//STRIP001 			aPoint.X() += rDevice.GetTextWidth(aText);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rDevice.DrawText(aPoint, rLine);
//STRIP001 }


//STRIP001 void SmViewShell::DrawText(OutputDevice& rDevice, const Point& rPosition, const String& rText, USHORT MaxWidth)
//STRIP001 {
//STRIP001 	USHORT	nLines = rText.GetTokenCount('\n');
//STRIP001 	Point	aPoint (rPosition);
//STRIP001 	Size	aSize;
//STRIP001 	String	aLine;
//STRIP001 	String	aText;
//STRIP001 
//STRIP001 	for (USHORT i = 0; i < nLines; i++)
//STRIP001 	{
//STRIP001 		aLine = rText.GetToken(i, '\n');
//STRIP001 		aLine.EraseAllChars('\r');
//STRIP001 		aLine.EraseLeadingChars('\n');
//STRIP001 		aLine.EraseTrailingChars('\n');
//STRIP001 		aSize = GetTextLineSize(rDevice, aLine);
//STRIP001 		if (aSize.Width() > MaxWidth)
//STRIP001 		{
//STRIP001 			do
//STRIP001 			{
//STRIP001 				xub_StrLen m	= aLine.Len();
//STRIP001 				xub_StrLen nLen = m;
//STRIP001 
//STRIP001 				for (xub_StrLen n = 0; n < nLen; n++)
//STRIP001 				{
//STRIP001 					sal_Unicode cLineChar = aLine.GetChar(n);
//STRIP001 					if ((cLineChar == ' ') || (cLineChar == '\t'))
//STRIP001 					{
//STRIP001 						aText = aLine.Copy(0, n);
//STRIP001 						if (GetTextLineSize(rDevice, aText).Width() < MaxWidth)
//STRIP001 							m = n;
//STRIP001 						else
//STRIP001 							break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				aText = aLine.Copy(0, m);
//STRIP001 				aLine.Erase(0, m);
//STRIP001 
//STRIP001 				DrawTextLine(rDevice, aPoint, aText);
//STRIP001 				aPoint.Y() += aSize.Height();
//STRIP001 
//STRIP001 				aLine.EraseLeadingChars(' ');
//STRIP001 				aLine.EraseLeadingChars('\t');
//STRIP001 				aLine.EraseLeadingChars(' ');
//STRIP001 			}
//STRIP001 			while (GetTextLineSize(rDevice, aLine).Width() > MaxWidth);
//STRIP001 
//STRIP001 			// print the remaining text
//STRIP001 			if (aLine.Len() > 0)
//STRIP001 			{
//STRIP001 				DrawTextLine(rDevice, aPoint, aLine);
//STRIP001 				aPoint.Y() += aSize.Height();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			DrawTextLine(rDevice, aPoint, aLine);
//STRIP001 			aPoint.Y() += aSize.Height();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*?*/ void SmViewShell::Impl_Print(
/*?*/         OutputDevice &rOutDev, const SmPrintSize ePrintSize,
/*?*/         Rectangle aOutRect, Point aZeroPoint )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 	SmModule *pp = SM_MOD1();
//STRIP001 /*?*/ 
//STRIP001 /*?*/     rOutDev.Push();
//STRIP001 /*?*/     rOutDev.SetLineColor( Color(COL_BLACK) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	// output text on top
//STRIP001 /*?*/ 	if (pp->GetConfig()->IsPrintTitle())
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		Size aSize600 (0, 600);
//STRIP001 /*?*/ 		Size aSize650 (0, 650);
//STRIP001 /*?*/ 		Font aFont(FAMILY_DONTKNOW, aSize600);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		aFont.SetAlign(ALIGN_TOP);
//STRIP001 /*?*/ 		aFont.SetWeight(WEIGHT_BOLD);
//STRIP001 /*?*/ 		aFont.SetSize(aSize650);
//STRIP001 /*?*/         rOutDev.SetFont(aFont);
//STRIP001 /*?*/ 
//STRIP001 /*?*/         Size aTitleSize (GetTextSize(rOutDev, GetDoc()->GetTitle(), aOutRect.GetWidth() - 200));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		aFont.SetWeight(WEIGHT_NORMAL);
//STRIP001 /*?*/ 		aFont.SetSize(aSize600);
//STRIP001 /*?*/         rOutDev.SetFont(aFont);
//STRIP001 /*?*/ 
//STRIP001 /*?*/         Size aDescSize (GetTextSize(rOutDev, GetDoc()->GetComment(), aOutRect.GetWidth() - 200));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// output rectangle
//STRIP001 /*?*/ 		SmModule *pp = SM_MOD1();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if (pp->GetConfig()->IsPrintFrame())
//STRIP001 /*?*/             rOutDev.DrawRect(Rectangle(aOutRect.TopLeft(),
//STRIP001 /*?*/                                Size(aOutRect.GetWidth(), 100 + aTitleSize.Height() + 200 + aDescSize.Height() + 100)));
//STRIP001 /*?*/         aOutRect.Top() += 200;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// output title
//STRIP001 /*?*/ 		aFont.SetWeight(WEIGHT_BOLD);
//STRIP001 /*?*/ 		aFont.SetSize(aSize650);
//STRIP001 /*?*/         rOutDev.SetFont(aFont);
//STRIP001 /*?*/         DrawText(rOutDev, Point (aOutRect.Left() + (aOutRect.GetWidth() - aTitleSize.Width())  / 2,
//STRIP001 /*?*/                                    aOutRect.Top()), GetDoc()->GetTitle(), aOutRect.GetWidth() - 200);
//STRIP001 /*?*/         aOutRect.Top() += aTitleSize.Height() + 200;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// output description
//STRIP001 /*?*/ 		aFont.SetWeight(WEIGHT_NORMAL);
//STRIP001 /*?*/ 		aFont.SetSize(aSize600);
//STRIP001 /*?*/         rOutDev.SetFont(aFont);
//STRIP001 /*?*/         DrawText(rOutDev, Point (aOutRect.Left() + (aOutRect.GetWidth()  - aDescSize.Width())  / 2,
//STRIP001 /*?*/                                    aOutRect.Top()), GetDoc()->GetComment(), aOutRect.GetWidth() - 200);
//STRIP001 /*?*/         aOutRect.Top() += aDescSize.Height() + 300;
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	// output text on bottom
//STRIP001 /*?*/     if (pp->GetConfig()->IsPrintFormulaText())
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ //		  Font aFont(FAMILY_DONTKNOW, Size(0, 600));
//STRIP001 /*?*/ 		Font aFont;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		aFont.SetAlign(ALIGN_TOP);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// get size
//STRIP001 /*?*/         rOutDev.SetFont(aFont);
//STRIP001 /*?*/ 
//STRIP001 /*?*/         Size aSize (GetTextSize(rOutDev, GetDoc()->GetText(), aOutRect.GetWidth() - 200));
//STRIP001 /*?*/ 
//STRIP001 /*?*/         aOutRect.Bottom() -= aSize.Height() + 600;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// output rectangle
//STRIP001 /*?*/ 		SmModule *pp = SM_MOD1();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if (pp->GetConfig()->IsPrintFrame())
//STRIP001 /*?*/             rOutDev.DrawRect(Rectangle(aOutRect.BottomLeft(),
//STRIP001 /*?*/                                Size(aOutRect.GetWidth(), 200 + aSize.Height() + 200)));
//STRIP001 /*?*/ 
//STRIP001 /*?*/         DrawText(rOutDev, Point (aOutRect.Left() + (aOutRect.GetWidth()  - aSize.Width())  / 2,
//STRIP001 /*?*/                                    aOutRect.Bottom() + 300), GetDoc()->GetText(), aOutRect.GetWidth() - 200);
//STRIP001 /*?*/         aOutRect.Bottom() -= 200;
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	if (pp->GetConfig()->IsPrintFrame())
//STRIP001 /*?*/         rOutDev.DrawRect(aOutRect);
//STRIP001 /*?*/ 
//STRIP001 /*?*/     aOutRect.Top()    += 100;
//STRIP001 /*?*/     aOutRect.Left()   += 100;
//STRIP001 /*?*/     aOutRect.Bottom() -= 100;
//STRIP001 /*?*/     aOutRect.Right()  -= 100;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	Size aSize (GetDoc()->GetSize());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	MapMode    OutputMapMode;
//STRIP001 /*?*/     switch (ePrintSize)
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		case PRINT_SIZE_NORMAL:
//STRIP001 /*?*/ 			OutputMapMode = MapMode(MAP_100TH_MM);
//STRIP001 /*?*/ 			break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		case PRINT_SIZE_SCALED:
//STRIP001 /*?*/ 			if ((aSize.Width() > 0) && (aSize.Height() > 0))
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 Size     OutputSize (rOutDev.LogicToPixel(Size(aOutRect.GetWidth(),
//STRIP001 /*?*/                                                             aOutRect.GetHeight()), MapMode(MAP_100TH_MM)));
//STRIP001 /*?*/                 Size     GraphicSize (rOutDev.LogicToPixel(aSize, MapMode(MAP_100TH_MM)));
//STRIP001 /*?*/ 				USHORT	 nZ = (USHORT) Min((long)Fraction(OutputSize.Width()  * 100L, GraphicSize.Width()),
//STRIP001 /*?*/ 											  (long)Fraction(OutputSize.Height() * 100L, GraphicSize.Height()));
//STRIP001 /*?*/ 				Fraction aFraction ((USHORT) Max ((USHORT) MINZOOM, Min((USHORT) MAXZOOM, (USHORT) (nZ - 10))), (USHORT) 100);
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 OutputMapMode = MapMode(MAP_100TH_MM, aZeroPoint, aFraction, aFraction);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				OutputMapMode = MapMode(MAP_100TH_MM);
//STRIP001 /*?*/ 			break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		case PRINT_SIZE_ZOOMED:
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			SmModule *pp = SM_MOD1();
//STRIP001 /*?*/             Fraction aFraction (pp->GetConfig()->GetPrintZoomFactor(), 100);
//STRIP001 /*?*/ 
//STRIP001 /*?*/             OutputMapMode = MapMode(MAP_100TH_MM, aZeroPoint, aFraction, aFraction);
//STRIP001 /*?*/ 			break;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/     aSize = rOutDev.PixelToLogic(rOutDev.LogicToPixel(aSize, OutputMapMode),
//STRIP001 /*?*/ 								   MapMode(MAP_100TH_MM));
//STRIP001 /*?*/ 
//STRIP001 /*?*/     Point aPos (aOutRect.Left() + (aOutRect.GetWidth()  - aSize.Width())  / 2,
//STRIP001 /*?*/                 aOutRect.Top()  + (aOutRect.GetHeight() - aSize.Height()) / 2);
//STRIP001 /*?*/ 
//STRIP001 /*?*/     aPos     = rOutDev.PixelToLogic(rOutDev.LogicToPixel(aPos, MapMode(MAP_100TH_MM)),
//STRIP001 /*?*/ 										  OutputMapMode);
//STRIP001 /*?*/     aOutRect   = rOutDev.PixelToLogic(rOutDev.LogicToPixel(aOutRect, MapMode(MAP_100TH_MM)),
//STRIP001 /*?*/ 										  OutputMapMode);
//STRIP001 /*?*/ 
//STRIP001 /*?*/     rOutDev.SetMapMode(OutputMapMode);
//STRIP001 /*?*/     rOutDev.SetClipRegion(Region(aOutRect));
//STRIP001 /*?*/     GetDoc()->Draw(rOutDev, aPos);
//STRIP001 /*?*/     rOutDev.SetClipRegion();
//STRIP001 /*?*/ 
//STRIP001 /*?*/     rOutDev.Pop();
/*?*/ }

//STRIP001 USHORT SmViewShell::Print(SfxProgress &rProgress, PrintDialog *pPrintDialog)
//STRIP001 {
//STRIP001 	SmPrinterAccess aPrinterAccess( *GetDoc() );
//STRIP001     Printer *pPrinter = aPrinterAccess.GetPrinter();
//STRIP001     OutputDevice *pOutDev = pPrinter;
//STRIP001 
//STRIP001 	SfxViewShell::Print (rProgress, pPrintDialog);
//STRIP001 
//STRIP001 	pPrinter->StartPage();
//STRIP001 
//STRIP001     Point     aZeroPoint;
//STRIP001     Rectangle OutputRect( aZeroPoint, pPrinter->GetOutputSize() );
//STRIP001 
//STRIP001     Point   aPrtPageOffset( pPrinter->GetPageOffset() );
//STRIP001     Size    aPrtPaperSize ( pPrinter->GetPaperSize() );
//STRIP001 
//STRIP001 	// set minimum top and bottom border
//STRIP001     if (aPrtPageOffset.Y() < 2000)
//STRIP001         OutputRect.Top() += 2000 - aPrtPageOffset.Y();
//STRIP001     if ((aPrtPaperSize.Height() - (aPrtPageOffset.Y() + OutputRect.Bottom())) < 2000)
//STRIP001         OutputRect.Bottom() -= 2000 - (aPrtPaperSize.Height() -
//STRIP001                                        (aPrtPageOffset.Y() + OutputRect.Bottom()));
//STRIP001 
//STRIP001 	// set minimum left and right border
//STRIP001     if (aPrtPageOffset.X() < 2500)
//STRIP001         OutputRect.Left() += 2500 - aPrtPageOffset.X();
//STRIP001     if ((aPrtPaperSize.Width() - (aPrtPageOffset.X() + OutputRect.Right())) < 1500)
//STRIP001         OutputRect.Right() -= 1500 - (aPrtPaperSize.Width() -
//STRIP001                                       (aPrtPageOffset.X() + OutputRect.Right()));
//STRIP001 
//STRIP001     SmModule *pp = SM_MOD1();
//STRIP001     Impl_Print( *pPrinter, pp->GetConfig()->GetPrintSize(),
//STRIP001                  OutputRect, aZeroPoint );
//STRIP001 
//STRIP001 	pPrinter->EndPage();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }


/*N*/ SfxPrinter* SmViewShell::GetPrinter(BOOL bCreate)
/*N*/ {
/*N*/ 	SmDocShell *pDoc = GetDoc();
/*N*/ 	if ( pDoc->HasPrinter() || bCreate )
/*N*/ 		return pDoc->GetPrinter();
/*N*/ 	return 0;
/*N*/ }


//STRIP001 USHORT SmViewShell::SetPrinter(SfxPrinter *pNewPrinter, USHORT nDiffFlags)
//STRIP001 {
//STRIP001 	if ((nDiffFlags & SFX_PRINTER_PRINTER) == SFX_PRINTER_PRINTER)
//STRIP001 		GetDoc()->SetPrinter( pNewPrinter );
//STRIP001 
//STRIP001 	if ((nDiffFlags & SFX_PRINTER_OPTIONS) == SFX_PRINTER_OPTIONS)
//STRIP001 	{
//STRIP001 		SmModule *pp = SM_MOD1();
//STRIP001 		pp->GetConfig()->ItemSetToConfig(pNewPrinter->GetOptions());
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }


//STRIP001 SfxTabPage* SmViewShell::CreatePrintOptionsPage(Window *pParent,
//STRIP001 												const SfxItemSet &rOptions)
//STRIP001 {
//STRIP001 	return SmPrintOptionsTabPage::Create(pParent, rOptions);
//STRIP001 }


/*N*/ SmEditWindow *SmViewShell::GetEditWindow()
/*N*/ {
/*N*/ 	SmCmdBoxWrapper *pWrapper = (SmCmdBoxWrapper *) GetViewFrame()->
/*N*/ 			GetChildWindow( SmCmdBoxWrapper::GetChildWindowId() );
/*N*/ 
/*N*/ 	if (pWrapper != NULL)
/*N*/ 	{
/*N*/ 		SmEditWindow *pEditWin	= pWrapper->GetEditWindow();
/*N*/ 		DBG_ASSERT( pEditWin, "SmEditWindow missing" );
/*N*/ 		return pEditWin;
/*N*/ 	}
/*N*/ 
/*N*/ 	return NULL;
/*N*/ }


/*N*/ void SmViewShell::SetStatusText(const String& Text)
/*N*/ {
/*N*/ 	StatusText = Text;
/*N*/ 	GetViewFrame()->GetBindings().Invalidate(SID_TEXTSTATUS);
/*N*/ }


//STRIP001 void SmViewShell::ShowError( const SmErrorDesc *pErrorDesc )
//STRIP001 {
//STRIP001 	DBG_ASSERT(GetDoc(), "Sm : Document missing");
//STRIP001 	if (pErrorDesc || 0 != (pErrorDesc = GetDoc()->GetParser().GetError(0)) )
//STRIP001 	{
//STRIP001 		SetStatusText( pErrorDesc->Text );
//STRIP001 		GetEditWindow()->MarkError( Point( pErrorDesc->pNode->GetColumn(),
//STRIP001 										   pErrorDesc->pNode->GetRow()));
//STRIP001 	}
//STRIP001 }


//STRIP001 void SmViewShell::NextError()
//STRIP001 {
//STRIP001 	DBG_ASSERT(GetDoc(), "Sm : Document missing");
//STRIP001 	const SmErrorDesc   *pErrorDesc = GetDoc()->GetParser().NextError();
//STRIP001 
//STRIP001 	if (pErrorDesc)
//STRIP001 		ShowError( pErrorDesc );
//STRIP001 }


//STRIP001 void SmViewShell::PrevError()
//STRIP001 {
//STRIP001 	DBG_ASSERT(GetDoc(), "Sm : Document missing");
//STRIP001 	const SmErrorDesc   *pErrorDesc = GetDoc()->GetParser().PrevError();
//STRIP001 
//STRIP001 	if (pErrorDesc)
//STRIP001 		ShowError( pErrorDesc );
//STRIP001 }


/*?*/ void SmViewShell::Execute(SfxRequest& rReq)
/*?*/ {
/*?*/ 		DBG_BF_ASSERT(0, "STRIP");//STRIP001 	SmEditWindow *pWin = GetEditWindow();
//STRIP001 
//STRIP001 	switch (rReq.GetSlot())
//STRIP001 	{
//STRIP001 		case SID_FORMULACURSOR:
//STRIP001 		{
//STRIP001 			SmModule *pp = SM_MOD1();
//STRIP001 
//STRIP001 			const SfxItemSet  *pArgs = rReq.GetArgs();
//STRIP001 			const SfxPoolItem *pItem;
//STRIP001 
//STRIP001 			BOOL  bVal;
//STRIP001 			if ( pArgs &&
//STRIP001 				 SFX_ITEM_SET == pArgs->GetItemState( SID_FORMULACURSOR, FALSE, &pItem))
//STRIP001 				bVal = ((SfxBoolItem *) pItem)->GetValue();
//STRIP001 			else
//STRIP001 				bVal = !pp->GetConfig()->IsShowFormulaCursor();
//STRIP001 
//STRIP001 			pp->GetConfig()->SetShowFormulaCursor(bVal);
//STRIP001 			GetGraphicWindow().ShowCursor(bVal);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_DRAW:
//STRIP001 			if (pWin)
//STRIP001 			{
//STRIP001 				GetDoc()->SetText( pWin->GetText() );
//STRIP001 				SetStatusText(String());
//STRIP001 				ShowError( 0 );
//STRIP001 				GetDoc()->Resize();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ADJUST:
//STRIP001         case SID_FITINWINDOW:
//STRIP001 			aGraphic.ZoomToFitInWindow();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_VIEW050:
//STRIP001 			aGraphic.SetZoom(50);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_VIEW100:
//STRIP001 			aGraphic.SetZoom(100);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_VIEW200:
//STRIP001 			aGraphic.SetZoom(200);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ZOOMIN:
//STRIP001 			aGraphic.SetZoom(aGraphic.GetZoom() + 25);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ZOOMOUT:
//STRIP001 			DBG_ASSERT(aGraphic.GetZoom() >= 25, "Sm: falsches USHORT Argument");
//STRIP001 			aGraphic.SetZoom(aGraphic.GetZoom() - 25);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_CUT:
//STRIP001 			if (pWin)
//STRIP001 				pWin->Cut();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_COPY:
//STRIP001 			if (pWin)
//STRIP001 			{
//STRIP001 				if (pWin->IsAllSelected())
//STRIP001 				{
//STRIP001 					SmViewShell *pViewSh = SmGetActiveView();
//STRIP001 					if (pViewSh)
//STRIP001 						pViewSh->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 								SID_COPYOBJECT, SFX_CALLMODE_STANDARD,
//STRIP001 								new SfxVoidItem(SID_COPYOBJECT), 0L);
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pWin->Copy();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_PASTE:
//STRIP001 			{
//STRIP001 				BOOL bCallExec = 0 == pWin;
//STRIP001 				if( !bCallExec )
//STRIP001 				{
//STRIP001 					TransferableDataHelper aDataHelper(
//STRIP001 						TransferableDataHelper::CreateFromSystemClipboard(
//STRIP001 													GetEditWindow()) );
//STRIP001 
//STRIP001 					if( aDataHelper.GetTransferable().is() &&
//STRIP001 						aDataHelper.HasFormat( FORMAT_STRING ))
//STRIP001 						pWin->Paste();
//STRIP001 					else
//STRIP001 						bCallExec = TRUE;
//STRIP001 				}
//STRIP001 				if( bCallExec )
//STRIP001 				{
//STRIP001 					SmViewShell *pViewSh = SmGetActiveView();
//STRIP001 					if( pViewSh )
//STRIP001 						pViewSh->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 							SID_PASTEOBJECT, SFX_CALLMODE_STANDARD,
//STRIP001 							new SfxVoidItem(SID_PASTEOBJECT), 0L);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_DELETE:
//STRIP001 			if (pWin)
//STRIP001 				pWin->Delete();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_SELECT:
//STRIP001 			if (pWin)
//STRIP001 				pWin->SelectAll();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_INSERTCOMMAND:
//STRIP001 		{
//STRIP001 			const SfxInt16Item& rItem =
//STRIP001 				(const SfxInt16Item&)rReq.GetArgs()->Get(SID_INSERTCOMMAND);
//STRIP001 
//STRIP001 			if (pWin)
//STRIP001 				pWin->InsertCommand(rItem.GetValue());
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_INSERTTEXT:
//STRIP001 		{
//STRIP001 			const SfxStringItem& rItem =
//STRIP001 				(const SfxStringItem&)rReq.GetArgs()->Get(SID_INSERTTEXT);
//STRIP001 
//STRIP001 			if (pWin)
//STRIP001 				pWin->InsertText(rItem.GetValue());
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_NEXTERR:
//STRIP001 			NextError();
//STRIP001 			if (pWin)
//STRIP001 				pWin->GrabFocus();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_PREVERR:
//STRIP001 			PrevError();
//STRIP001 			if (pWin)
//STRIP001 				pWin->GrabFocus();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_NEXTMARK:
//STRIP001 			if (pWin)
//STRIP001 			{
//STRIP001 				pWin->SelNextMark();
//STRIP001 				pWin->GrabFocus();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_PREVMARK:
//STRIP001 			if (pWin)
//STRIP001 			{
//STRIP001 				pWin->SelPrevMark();
//STRIP001 				pWin->GrabFocus();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_TEXTSTATUS:
//STRIP001 		{
//STRIP001 			if (rReq.GetArgs() != NULL)
//STRIP001 			{
//STRIP001 				const SfxStringItem& rItem =
//STRIP001 					(const SfxStringItem&)rReq.GetArgs()->Get(SID_TEXTSTATUS);
//STRIP001 
//STRIP001 				SetStatusText(rItem.GetValue());
//STRIP001 			}
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_GETEDITTEXT:
//STRIP001 			if (pWin)
//STRIP001 				if (pWin->GetText ().Len ()) GetDoc()->SetText( pWin->GetText() );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ATTR_ZOOM:
//STRIP001 		{
//STRIP001 			if ( !GetDoc()->GetProtocol().IsInPlaceActive() )
//STRIP001 			{
//STRIP001 				SvxZoomDialog *pDlg = 0;
//STRIP001 				const SfxItemSet *pSet = rReq.GetArgs();
//STRIP001 				if ( !pSet )
//STRIP001 				{
//STRIP001 					SfxItemSet aSet( GetDoc()->GetPool(), SID_ATTR_ZOOM, SID_ATTR_ZOOM);
//STRIP001 					aSet.Put( SvxZoomItem( SVX_ZOOM_PERCENT, aGraphic.GetZoom()));
//STRIP001 					pDlg = new SvxZoomDialog( &GetViewFrame()->GetWindow(), aSet);
//STRIP001 					pDlg->SetLimits( MINZOOM, MAXZOOM );
//STRIP001 					if( pDlg->Execute() != RET_CANCEL )
//STRIP001 						pSet = pDlg->GetOutputItemSet();
//STRIP001 				}
//STRIP001 				if ( pSet )
//STRIP001 				{
//STRIP001 					const SvxZoomItem &rZoom = (const SvxZoomItem &)pSet->Get(SID_ATTR_ZOOM);
//STRIP001 					switch( rZoom.GetType() )
//STRIP001 					{
//STRIP001 						case SVX_ZOOM_PERCENT:
//STRIP001                             aGraphic.SetZoom((USHORT)rZoom.GetValue ());
//STRIP001 							break;
//STRIP001 
//STRIP001 						case SVX_ZOOM_OPTIMAL:
//STRIP001 							aGraphic.ZoomToFitInWindow();
//STRIP001 							break;
//STRIP001 
//STRIP001 						case SVX_ZOOM_PAGEWIDTH:
//STRIP001 						case SVX_ZOOM_WHOLEPAGE:
//STRIP001 						{
//STRIP001 							const MapMode aMap( MAP_100TH_MM );
//STRIP001 							SfxPrinter *pPrinter = GetPrinter( TRUE );
//STRIP001 							Point aPoint;
//STRIP001 							Rectangle  OutputRect(aPoint, pPrinter->GetOutputSize());
//STRIP001 							Size	   OutputSize(pPrinter->LogicToPixel(Size(OutputRect.GetWidth(),
//STRIP001 																			  OutputRect.GetHeight()), aMap));
//STRIP001 							Size	   GraphicSize(pPrinter->LogicToPixel(GetDoc()->GetSize(), aMap));
//STRIP001 							USHORT	   nZ = (USHORT) Min((long)Fraction(OutputSize.Width()	* 100L, GraphicSize.Width()),
//STRIP001 														 (long)Fraction(OutputSize.Height() * 100L, GraphicSize.Height()));
//STRIP001 							aGraphic.SetZoom (nZ);
//STRIP001 							break;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				delete pDlg;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	rReq.Done();
/*?*/ }


/*N*/ void SmViewShell::GetState(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	SfxWhichIter aIter(rSet);
/*N*/ 
/*N*/     SmEditWindow *pEditWin = GetEditWindow();
/*N*/ 	for (USHORT nWh = aIter.FirstWhich(); nWh != 0; nWh = aIter.NextWhich())
/*N*/ 	{
/*N*/ 		switch (nWh)
/*N*/ 		{
/*N*/ 		case SID_CUT:
/*N*/ 		case SID_COPY:
/*N*/ 		case SID_DELETE:
/*N*/             if (! pEditWin || ! pEditWin->IsSelected())
/*N*/ 				rSet.DisableItem(nWh);
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SID_PASTE:
/*N*/             if( !xClipEvtLstnr.is()  &&  pEditWin)
/*N*/ 			{
/*N*/ 				AddRemoveClipboardListener( TRUE );
/*N*/ 				TransferableDataHelper aDataHelper(
/*N*/ 						TransferableDataHelper::CreateFromSystemClipboard(
/*N*/                                                         pEditWin) );
/*N*/ 
/*N*/ 				bPasteState = aDataHelper.GetTransferable().is() &&
/*N*/ 				 ( aDataHelper.HasFormat( FORMAT_STRING ) ||
/*N*/ 				   aDataHelper.HasFormat( SOT_FORMATSTR_ID_EMBEDDED_OBJ ) ||
/*N*/ 				   (aDataHelper.HasFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR )
/*N*/ 				 	 && aDataHelper.HasFormat( SOT_FORMATSTR_ID_EMBED_SOURCE )));
/*N*/ 			}
/*N*/ 			if( !bPasteState )
/*N*/ 				rSet.DisableItem( nWh );
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SID_ATTR_ZOOM:
/*N*/ 			rSet.Put(SvxZoomItem( SVX_ZOOM_PERCENT, aGraphic.GetZoom()));
/*N*/ 			/* no break here */
/*N*/ 		case SID_VIEW050:
/*N*/ 		case SID_VIEW100:
/*N*/ 		case SID_VIEW200:
/*N*/ 		case SID_ADJUST:
/*N*/ 		case SID_ZOOMIN:
/*N*/ 		case SID_ZOOMOUT:
/*N*/ 		case SID_FITINWINDOW:
/*N*/ 			if ( GetDoc()->GetProtocol().IsInPlaceActive() )
/*?*/ 				rSet.DisableItem( nWh );
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SID_NEXTERR:
/*N*/ 		case SID_PREVERR:
/*N*/ 		case SID_NEXTMARK:
/*N*/ 		case SID_PREVMARK:
/*N*/ 		case SID_DRAW:
/*N*/ 		case SID_SELECT:
/*N*/             if (! pEditWin || pEditWin->IsEmpty())
/*N*/ 				rSet.DisableItem(nWh);
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SID_TEXTSTATUS:
/*N*/ 			{
/*N*/ 				rSet.Put(SfxStringItem(nWh, StatusText));
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SID_FORMULACURSOR:
/*N*/ 			{
/*N*/ 				SmModule *pp = SM_MOD1();
/*N*/ 				rSet.Put(SfxBoolItem(nWh, pp->GetConfig()->IsShowFormulaCursor()));
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ }


/*N*/ SmViewShell::SmViewShell(SfxViewFrame *pFrame, SfxViewShell *):
/*N*/ 	SfxViewShell(pFrame, SFX_VIEW_DISABLE_ACCELS | SFX_VIEW_MAXIMIZE_FIRST | SFX_VIEW_HAS_PRINTOPTIONS | SFX_VIEW_CAN_PRINT),
/*N*/ 	aGraphic(this),
/*N*/ 	aGraphicController(aGraphic, SID_GRAPHIC, pFrame->GetBindings())
/*N*/ {
/*N*/ 	pViewFrame = &pFrame->GetWindow();
/*N*/ 
/*N*/ 	SetStatusText(String());
/*N*/ 	SetWindow(&aGraphic);
/*N*/ 	SfxShell::SetName(C2S("SmView"));
/*N*/ 	SfxShell::SetUndoManager( &GetDoc()->GetEditEngine().GetUndoManager() );
/*N*/ 	SetHelpId( HID_SMA_VIEWSHELL_DOCUMENT );
/*N*/ }


/*N*/ SmViewShell::~SmViewShell()
/*N*/ {
/*N*/ 	AddRemoveClipboardListener( FALSE );
/*N*/ 
/*N*/     //!! this view shell is not active anymore !!
/*N*/     // Thus 'SmGetActiveView' will give a 0 pointer.
/*N*/     // Thus we need to supply this view as argument
/*N*/     SmEditWindow *pEditWin = GetEditWindow();
/*N*/     if (pEditWin)
/*?*/     {DBG_BF_ASSERT(0, "STRIP");} //STRIP001     pEditWin->DeleteEditView( *this );
/*N*/ }

/*N*/ void SmViewShell::Deactivate( BOOL bIsMDIActivate )
/*N*/ {
/*N*/ 	SmEditWindow *pEdit = GetEditWindow();
/*N*/ 	if ( pEdit )
/*?*/ 		pEdit->Flush();
/*N*/ 
/*N*/ 	SfxViewShell::Deactivate( bIsMDIActivate );
/*N*/ }


/*N*/ void SmViewShell::Activate( BOOL bIsMDIActivate )
/*N*/ {
/*N*/ 	SfxViewShell::Activate( bIsMDIActivate );
/*N*/ 
/*N*/ 	SmEditWindow *pEdit = GetEditWindow();
/*N*/ 	if ( pEdit )
/*N*/ 	{
        //! Since there is no way to be informed if a "drag and drop"
        //! event has taken place, we call SetText here in order to
        //! syncronize the GraphicWindow display with the text in the
        //! EditEngine.
/*?*/          SmDocShell *pDoc = GetDoc();
/*?*/          pDoc->SetText( pDoc->GetEditEngine().GetText( LINEEND_LF ) );
/*?*/  
/*?*/  		if ( bIsMDIActivate )
/*?*/  			pEdit->GrabFocus();
/*N*/ 	}
/*N*/ }


}
