/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_linectrl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:16:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

// auto strip #ifndef _TOOLBOX_HXX //autogen
// auto strip #include <vcl/toolbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFX_OBJSH_HXX //autogen
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #endif

#include "dialogs.hrc"
#include "helpid.hrc"

#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_DASH_LIST		SID_DASH_LIST
#define ITEMID_LINEEND_LIST		SID_LINEEND_LIST

// auto strip #include "drawitem.hxx"

#ifndef _XDEF_HXX
#include "xdef.hxx"
#endif

#include "xattr.hxx"
// auto strip #include "xtable.hxx"
#include "linectrl.hxx"
// auto strip #include "itemwin.hxx"
// auto strip #include "dialmgr.hxx"
namespace binfilter {

// Fuer Linienenden-Controller
#define MAX_LINES 12

// STATIC DATA -----------------------------------------------------------

#define RESIZE_VALUE_POPUP(value_set)	\
{														\
    Size aSize = GetOutputSizePixel();					\
    aSize.Width()  -= 4;								\
    aSize.Height() -= 4;								\
    (value_set).SetPosSizePixel( Point(2,2), aSize );	\
}

#define CALCSIZE_VALUE_POPUP(value_set,item_size) \
{																	\
    Size aSize = (value_set).CalcWindowSizePixel( (item_size) );	\
    aSize.Width()  += 4;											\
    aSize.Height() += 4;											\
    SetOutputSizePixel( aSize );									\
}


/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxLineStyleToolBoxControl, XLineStyleItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxLineWidthToolBoxControl, XLineWidthItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxLineColorToolBoxControl, XLineColorItem );
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxLineEndToolBoxControl,   SfxBoolItem );

/*************************************************************************
|*
|* SvxLineStyleToolBoxControl
|*
\************************************************************************/

/*?*/ SvxLineStyleToolBoxControl::SvxLineStyleToolBoxControl( USHORT nId,
/*?*/ 														ToolBox& rTbx,
/*?*/ 														SfxBindings& rBind ) :
/*?*/ 	SfxToolBoxControl( nId, rTbx, rBind ),
/*?*/ 	aDashForwarder	( SID_ATTR_LINE_DASH, *this ),
/*?*/ 	pStyleItem		( NULL ),
/*?*/ 	pDashItem		( NULL ),
/*?*/ 	bUpdate			( FALSE )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	StartListening( rBind, TRUE );
/*?*/ }

//STRIP001 //========================================================================
//STRIP001 
//STRIP001 SvxLineStyleToolBoxControl::~SvxLineStyleToolBoxControl()
//STRIP001 {
//STRIP001 	delete pStyleItem;
//STRIP001 	delete pDashItem;
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 void SvxLineStyleToolBoxControl::StateChanged (
//STRIP001 
//STRIP001 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 
//STRIP001 {
//STRIP001 	SvxLineBox* pBox = (SvxLineBox*)GetToolBox().GetItemWindow( GetId() );
//STRIP001 	DBG_ASSERT( pBox, "Window not found!" );
//STRIP001 
//STRIP001 	if( eState == SFX_ITEM_DISABLED )
//STRIP001 	{
//STRIP001 		pBox->Disable();
//STRIP001 		pBox->SetNoSelection();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pBox->Enable();
//STRIP001 
//STRIP001 		if ( eState == SFX_ITEM_AVAILABLE )
//STRIP001 		{
//STRIP001 			if( nSID == SID_ATTR_LINE_STYLE )
//STRIP001 			{
//STRIP001 				delete pStyleItem;
//STRIP001 				pStyleItem = (XLineStyleItem*)pState->Clone();
//STRIP001 			}
//STRIP001 			else if( nSID == SID_ATTR_LINE_DASH )
//STRIP001 			{
//STRIP001 				delete pDashItem;
//STRIP001 				pDashItem = (XLineDashItem*)pState->Clone();
//STRIP001 			}
//STRIP001 			else
//STRIP001 				DBG_ERROR( "Huch wer kommt nach drinnen rein?");
//STRIP001 
//STRIP001 			bUpdate = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			// kein oder uneindeutiger Status
//STRIP001 			pBox->SetNoSelection();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 void SvxLineStyleToolBoxControl::SFX_NOTIFY( SfxBroadcaster& rBC,
//STRIP001 										 const TypeId& rBCType,
//STRIP001 										 const SfxHint& rHint,
//STRIP001 										 const TypeId& rHintType )
//STRIP001 {
//STRIP001 	const SfxSimpleHint *pSimpleHint = PTR_CAST(SfxSimpleHint, &rHint);
//STRIP001 
//STRIP001 	if ( pSimpleHint &&
//STRIP001 		( pSimpleHint->GetId() == SFX_HINT_UPDATEDONE ) &&
//STRIP001 		  bUpdate )
//STRIP001 	{
//STRIP001 		bUpdate = FALSE;
//STRIP001 
//STRIP001 		SvxLineBox* pBox = (SvxLineBox*)GetToolBox().GetItemWindow( GetId() );
//STRIP001 		DBG_ASSERT( pBox, "Window not found!" );
//STRIP001 
//STRIP001 		// Da der Timer unerwartet zuschlagen kann, kann es vorkommen, dass
//STRIP001 		// die LB noch nicht gefuellt ist. Ein ClearCache() am Control im
//STRIP001 		// DelayHdl() blieb ohne Erfolg.
//STRIP001 		if( pBox->GetEntryCount() == 0 )
//STRIP001 		{
//STRIP001 			SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 			if ( pSh )
//STRIP001 			{
//STRIP001 				pBox->InsertEntry( SVX_RESSTR(RID_SVXSTR_INVISIBLE) );
//STRIP001 				pBox->InsertEntry( SVX_RESSTR(RID_SVXSTR_SOLID) );
//STRIP001 				const SvxDashListItem *pItem =
//STRIP001 					(const SvxDashListItem*)( pSh->GetItem( SID_DASH_LIST ) );
//STRIP001 				if(pItem)
//STRIP001 					pBox->Fill( pItem->GetDashList() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		XLineStyle eXLS;
//STRIP001 
//STRIP001 		if ( pStyleItem )
//STRIP001 			eXLS = ( XLineStyle )pStyleItem->GetValue();
//STRIP001 		else
//STRIP001 			eXLS = XLINE_NONE;
//STRIP001 
//STRIP001 		switch( eXLS )
//STRIP001 		{
//STRIP001 			case XLINE_NONE:
//STRIP001 				pBox->SelectEntryPos( 0 );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case XLINE_SOLID:
//STRIP001 				pBox->SelectEntryPos( 1 );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case XLINE_DASH:
//STRIP001 			{
//STRIP001 				if( pDashItem )
//STRIP001 				{
//STRIP001 					String aString( pDashItem->GetName() );
//STRIP001 					pBox->SelectEntry( aString );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pBox->SetNoSelection();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				DBG_ERROR( "Nicht unterstuetzter Linientyp" );
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	const SfxPoolItemHint *pPoolItemHint = PTR_CAST(SfxPoolItemHint, &rHint);
//STRIP001 
//STRIP001 	if ( pPoolItemHint
//STRIP001 		 && ( pPoolItemHint->GetObject()->ISA( SvxDashListItem ) ) )
//STRIP001 	{
//STRIP001 		// Die Liste der Linienstile hat sich geaendert
//STRIP001 		SvxLineBox* pBox = (SvxLineBox*)GetToolBox().GetItemWindow( GetId() );
//STRIP001 		DBG_ASSERT( pBox, "Window not found!" );
//STRIP001 
//STRIP001 		String aString( pBox->GetSelectEntry() );
//STRIP001 		pBox->Clear();
//STRIP001 		pBox->InsertEntry( SVX_RESSTR(RID_SVXSTR_INVISIBLE) );
//STRIP001 		pBox->InsertEntry( SVX_RESSTR(RID_SVXSTR_SOLID) );
//STRIP001 		pBox->Fill( ( (SvxDashListItem*) pPoolItemHint->GetObject() )->GetDashList() );
//STRIP001 		pBox->SelectEntry( aString );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 Window* SvxLineStyleToolBoxControl::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001 	return new SvxLineBox( pParent, GetBindings() );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SvxLineWidthToolBoxControl
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
/*?*/ SvxLineWidthToolBoxControl::SvxLineWidthToolBoxControl( USHORT nId,
/*?*/ 														ToolBox& rTbx,
/*?*/ 														SfxBindings& rBind ) :
/*?*/ 	SfxToolBoxControl( nId, rTbx, rBind )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	SfxApplication* pSfxApp = SFX_APP();
//STRIP001 	SfxModule* pModule = pSfxApp->GetActiveModule();
//STRIP001 
//STRIP001 	if( pModule )
//STRIP001 		StartListening( rBind, TRUE );
//STRIP001 	else
//STRIP001 		StartListening( *pSfxApp , TRUE );
//STRIP001 
/*?*/ }

//STRIP001 //========================================================================
//STRIP001 
//STRIP001 SvxLineWidthToolBoxControl::~SvxLineWidthToolBoxControl()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 void SvxLineWidthToolBoxControl::StateChanged(
//STRIP001 
//STRIP001 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 
//STRIP001 {
//STRIP001 	SvxMetricField* pFld = (SvxMetricField*)
//STRIP001 						   GetToolBox().GetItemWindow( GetId() );
//STRIP001 	DBG_ASSERT( pFld, "Window not found" );
//STRIP001 
//STRIP001 	if ( eState == SFX_ITEM_DISABLED )
//STRIP001 	{
//STRIP001 		pFld->Disable();
//STRIP001 		pFld->SetText( String() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pFld->Enable();
//STRIP001 
//STRIP001 		if ( eState == SFX_ITEM_AVAILABLE )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( pState->ISA(XLineWidthItem), "falscher ItemType" )
//STRIP001 
//STRIP001 			// Core-Unit an MetricField uebergeben
//STRIP001 			// Darf nicht in CreateItemWin() geschehen!
//STRIP001 			SfxMapUnit eUnit = GetCoreMetric();
//STRIP001 			pFld->SetCoreUnit( eUnit );
//STRIP001 
//STRIP001 			pFld->Update( (const XLineWidthItem*)pState );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pFld->Update( NULL );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 void SvxLineWidthToolBoxControl::SFX_NOTIFY( SfxBroadcaster& rBC,
//STRIP001 										 const TypeId& rBCType,
//STRIP001 										 const SfxHint& rHint,
//STRIP001 										 const TypeId& rHintType )
//STRIP001 {
//STRIP001 	// SfxItemSetHint funktioniert nicht mehr und kann laut MI
//STRIP001 	// auch nie funktioniert haben!
//STRIP001 	//const SfxItemSetHint *pOptionsHint = PTR_CAST(SfxItemSetHint, &rHint);
//STRIP001 
//STRIP001 	const SfxPoolItemHint *pOptionsHint = PTR_CAST(SfxPoolItemHint, &rHint);
//STRIP001 	if( pOptionsHint
//STRIP001 		&& ( pOptionsHint->GetObject()->Which() == SID_ATTR_METRIC ) )
//STRIP001 	{
//STRIP001 		SvxMetricField* pFld = (SvxMetricField*)
//STRIP001 							   GetToolBox().GetItemWindow( GetId() );
//STRIP001 		DBG_ASSERT( pFld, "Window not found" );
//STRIP001 
//STRIP001 		pFld->RefreshDlgUnit();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 Window* SvxLineWidthToolBoxControl::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001 	return( new SvxMetricField( pParent, GetBindings() ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SvxLineColorToolBoxControl
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
/*?*/ SvxLineColorToolBoxControl::SvxLineColorToolBoxControl( USHORT nId,
/*?*/ 														ToolBox& rTbx,
/*?*/ 														SfxBindings& rBind ) :
/*?*/ 	SfxToolBoxControl( nId, rTbx, rBind )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	StartListening( GetBindings() );
/*?*/ }

//STRIP001 //========================================================================
//STRIP001 
//STRIP001 SvxLineColorToolBoxControl::~SvxLineColorToolBoxControl()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 void SvxLineColorToolBoxControl::StateChanged(
//STRIP001 
//STRIP001 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 
//STRIP001 {
//STRIP001 	SvxColorBox* pBox = (SvxColorBox*)GetToolBox().GetItemWindow( GetId() );
//STRIP001 	DBG_ASSERT( pBox, "Window not found" );
//STRIP001 
//STRIP001 	if ( eState == SFX_ITEM_DISABLED )
//STRIP001 	{
//STRIP001 		pBox->Disable();
//STRIP001 		pBox->SetNoSelection();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pBox->Enable();
//STRIP001 
//STRIP001 		if ( eState == SFX_ITEM_AVAILABLE )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( pState->ISA(XLineColorItem), "falscher ItemTyoe" );
//STRIP001 			pBox->Update( (const XLineColorItem*) pState );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pBox->Update( NULL );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 void SvxLineColorToolBoxControl::SFX_NOTIFY( SfxBroadcaster& rBC,
//STRIP001 									const TypeId& rBCType,
//STRIP001 									const SfxHint& rHint,
//STRIP001 									const TypeId& rHintType )
//STRIP001 {
//STRIP001 	const SfxPoolItemHint *pPoolItemHint = PTR_CAST(SfxPoolItemHint, &rHint);
//STRIP001 
//STRIP001 	if ( pPoolItemHint
//STRIP001 		 && ( pPoolItemHint->GetObject()->ISA( SvxColorTableItem ) ) )
//STRIP001 	{
//STRIP001 		SvxColorBox* pBox = (SvxColorBox*)GetToolBox().GetItemWindow( GetId() );
//STRIP001 
//STRIP001 		DBG_ASSERT( pBox, "Window not found" );
//STRIP001 
//STRIP001 		// Die Liste der Farben (ColorTable) hat sich geaendert:
//STRIP001 		Color aTmpColor( pBox->GetSelectEntryColor() );
//STRIP001 		pBox->Clear();
//STRIP001 		pBox->Fill( ( (SvxColorTableItem*) pPoolItemHint->GetObject() )->GetColorTable() );
//STRIP001 		pBox->SelectEntry( aTmpColor );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 Window* SvxLineColorToolBoxControl::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001 	return new SvxColorBox( pParent, GetId(), GetBindings() );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SvxLineEndWindow
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxLineEndWindow::SvxLineEndWindow( USHORT nId, const String& rWndTitle, SfxBindings& rBindings ) :
//STRIP001 
//STRIP001 	SfxPopupWindow( nId, WinBits( WB_BORDER | WB_STDFLOATWIN | WB_SIZEABLE | WB_3DLOOK ), rBindings ),
//STRIP001 
//STRIP001 	pLineEndList	( NULL ),
//STRIP001 	aLineEndSet		( this, WinBits( WB_ITEMBORDER | WB_3DLOOK | WB_NO_DIRECTSELECT ) ),
//STRIP001 	nCols			( 2 ),
//STRIP001 	nLines			( 12 ),
//STRIP001 	nLineEndWidth	( 400 ),
//STRIP001 	bPopupMode		( TRUE ),
//STRIP001 	mbInResize		( false )
//STRIP001 {
//STRIP001 	SfxObjectShell*		pDocSh	= SfxObjectShell::Current();
//STRIP001 	const SfxPoolItem*	pItem 	= NULL;
//STRIP001 
//STRIP001 	SetHelpId( HID_POPUP_LINEEND );
//STRIP001 	aLineEndSet.SetHelpId( HID_POPUP_LINEEND_CTRL );
//STRIP001 
//STRIP001 	if ( pDocSh )
//STRIP001 	{
//STRIP001 		if( pItem = pDocSh->GetItem( SID_LINEEND_LIST ) )
//STRIP001 			pLineEndList = ( (SvxLineEndListItem*) pItem )->GetLineEndList();
//STRIP001 
//STRIP001 		if( pItem = pDocSh->GetItem( SID_ATTR_LINEEND_WIDTH_DEFAULT ) )
//STRIP001 			nLineEndWidth = ( (SfxUInt16Item*) pItem )->GetValue();
//STRIP001 	}
//STRIP001 	DBG_ASSERT( pLineEndList, "LineEndList wurde nicht gefunden" );
//STRIP001 
//STRIP001 	aLineEndSet.SetSelectHdl( LINK( this, SvxLineEndWindow, SelectHdl ) );
//STRIP001 	aLineEndSet.SetColCount( nCols );
//STRIP001 
//STRIP001 	// ValueSet mit Eintraegen der LineEndList fuellen
//STRIP001 	FillValueSet();
//STRIP001 
//STRIP001 	//ChangeHelpId( HID_POPUP_LINEENDSTYLE );
//STRIP001 	SetText( rWndTitle );
//STRIP001 	aLineEndSet.Show();
//STRIP001 	StartListening( rBindings );
//STRIP001 }
//STRIP001 
//STRIP001 SfxPopupWindow* SvxLineEndWindow::Clone() const
//STRIP001 {
//STRIP001 	return new SvxLineEndWindow( GetId(), GetText(), (SfxBindings&)GetBindings() );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxLineEndWindow::~SvxLineEndWindow()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLineEndWindow, SelectHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	XLineEndItem*   		pLineEndItem = NULL;
//STRIP001 	XLineStartItem* 		pLineStartItem = NULL;
//STRIP001 	USHORT 					nId = aLineEndSet.GetSelectItemId();
//STRIP001 
//STRIP001 	if( nId == 1 )
//STRIP001 	{
//STRIP001 		pLineStartItem	= new XLineStartItem();
//STRIP001 	}
//STRIP001 	else if( nId == 2 )
//STRIP001 	{
//STRIP001 		pLineEndItem	= new XLineEndItem();
//STRIP001 	}
//STRIP001 	else if( nId % 2 ) // LinienAnfang
//STRIP001 	{
//STRIP001 		XLineEndEntry* pEntry = pLineEndList->Get( ( nId - 1 ) / 2 - 1 );
//STRIP001 		pLineStartItem	= new XLineStartItem( pEntry->GetName(), pEntry->GetLineEnd() );
//STRIP001 	}
//STRIP001 	else // LinienEnde
//STRIP001 	{
//STRIP001 		XLineEndEntry* pEntry = pLineEndList->Get( nId / 2 - 2 );
//STRIP001 		pLineEndItem	= new XLineEndItem( pEntry->GetName(), pEntry->GetLineEnd() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( IsInPopupMode() )
//STRIP001 		EndPopupMode();
//STRIP001 
//STRIP001 	SfxDispatcher* pDisp = GetBindings().GetDispatcher();
//STRIP001 	DBG_ASSERT( pDisp, "invalid Dispatcher" );
//STRIP001 	if ( pLineStartItem )
//STRIP001 		pDisp->Execute( SID_ATTR_LINEEND_STYLE, SFX_CALLMODE_RECORD, pLineStartItem, 0L , 0L );
//STRIP001 	else
//STRIP001 		pDisp->Execute( SID_ATTR_LINEEND_STYLE, SFX_CALLMODE_RECORD, pLineEndItem, 0L , 0L );
//STRIP001 
//STRIP001 	delete pLineEndItem;
//STRIP001 	delete pLineStartItem;
//STRIP001 	aLineEndSet.SetNoSelection();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineEndWindow::FillValueSet()
//STRIP001 {
//STRIP001 	if( pLineEndList )
//STRIP001 	{
//STRIP001 		XLineEndEntry*		pEntry	= NULL;
//STRIP001 		Bitmap*				pBmp	= NULL;
//STRIP001 		VirtualDevice		aVD;
//STRIP001 
//STRIP001 		long nCount = pLineEndList->Count();
//STRIP001 
//STRIP001 		// Erster Eintrag: kein LinienEnde
//STRIP001 		// Temporaer wird ein Eintrag hinzugefuegt, um die UI-Bitmap zu erhalten
//STRIP001 		XPolygon aNothing( 0 );
//STRIP001 		pLineEndList->Insert( new XLineEndEntry( aNothing, SVX_RESSTR( RID_SVXSTR_NONE ) ) );
//STRIP001 		pEntry = pLineEndList->Get( nCount );
//STRIP001 		pBmp = pLineEndList->GetBitmap( nCount );
//STRIP001 		DBG_ASSERT( pBmp, "UI-Bitmap wurde nicht erzeugt" );
//STRIP001 
//STRIP001 		aBmpSize = pBmp->GetSizePixel();
//STRIP001 		aVD.SetOutputSizePixel( aBmpSize, FALSE );
//STRIP001 		aBmpSize.Width() = aBmpSize.Width() / 2;
//STRIP001 		Point aPt0( 0, 0 );
//STRIP001 		Point aPt1( aBmpSize.Width(), 0 );
//STRIP001 
//STRIP001 		aVD.DrawBitmap( Point(), *pBmp );
//STRIP001 		aLineEndSet.InsertItem( 1, aVD.GetBitmap( aPt0, aBmpSize ), pEntry->GetName() );
//STRIP001 		aLineEndSet.InsertItem( 2, aVD.GetBitmap( aPt1, aBmpSize ), pEntry->GetName() );
//STRIP001 
//STRIP001 		delete pLineEndList->Remove( nCount );
//STRIP001 
//STRIP001 		for( long i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			pEntry = pLineEndList->Get( i );
//STRIP001 			DBG_ASSERT( pEntry, "Konnte auf LineEndEntry nicht zugreifen" );
//STRIP001 			pBmp = pLineEndList->GetBitmap( i );
//STRIP001 			DBG_ASSERT( pBmp, "UI-Bitmap wurde nicht erzeugt" );
//STRIP001 
//STRIP001 			aVD.DrawBitmap( aPt0, *pBmp );
//STRIP001 			aLineEndSet.InsertItem( (USHORT)((i+1L)*2L+1L), aVD.GetBitmap( aPt0, aBmpSize ), pEntry->GetName() );
//STRIP001 			aLineEndSet.InsertItem( (USHORT)((i+2L)*2L), 	aVD.GetBitmap( aPt1, aBmpSize ), pEntry->GetName() );
//STRIP001 		}
//STRIP001 		nLines = Min( (USHORT)(nCount + 1), (USHORT) MAX_LINES );
//STRIP001 		aLineEndSet.SetLineCount( nLines );
//STRIP001 
//STRIP001 		SetSize();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineEndWindow::Resize()
//STRIP001 {
//STRIP001 	// since we change the size inside this call, check if we
//STRIP001 	// are called recursive
//STRIP001 	if( !mbInResize )
//STRIP001 	{
//STRIP001 		mbInResize = true;
//STRIP001 		if ( !IsRollUp() )
//STRIP001 		{
//STRIP001 			aLineEndSet.SetColCount( nCols );
//STRIP001 			aLineEndSet.SetLineCount( nLines );
//STRIP001 
//STRIP001 			SetSize();
//STRIP001 
//STRIP001 			Size aSize = GetOutputSizePixel();
//STRIP001 			aSize.Width()  -= 4;
//STRIP001 			aSize.Height() -= 4;
//STRIP001 			aLineEndSet.SetPosSizePixel( Point( 2, 2 ), aSize );
//STRIP001 		}
//STRIP001 		//SfxPopupWindow::Resize();
//STRIP001 		mbInResize = false;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void __EXPORT SvxLineEndWindow::Resizing( Size& rNewSize )
//STRIP001 {
//STRIP001 	Size aBitmapSize = aBmpSize; // -> Member
//STRIP001 	aBitmapSize.Width()  += 6; //
//STRIP001 	aBitmapSize.Height() += 6; //
//STRIP001 
//STRIP001 	Size aItemSize = aLineEndSet.CalcItemSizePixel( aBitmapSize );  // -> Member
//STRIP001 	//Size aOldSize = GetOutputSizePixel(); // fuer Breite
//STRIP001 
//STRIP001 	USHORT nItemCount = aLineEndSet.GetItemCount(); // -> Member
//STRIP001 
//STRIP001 	// Spalten ermitteln
//STRIP001 	long nItemW = aItemSize.Width();
//STRIP001 	long nW = rNewSize.Width();
//STRIP001 	nCols = (USHORT) Max( ( (ULONG)(( nW + nItemW ) / ( nItemW * 2 ) )),
//STRIP001 											(ULONG) 1L );
//STRIP001 	nCols *= 2;
//STRIP001 
//STRIP001 	// Reihen ermitteln
//STRIP001 	long nItemH = aItemSize.Height();
//STRIP001 	long nH = rNewSize.Height();
//STRIP001 	nLines = (USHORT) Max( ( ( nH + nItemH / 2 ) / nItemH ), 1L );
//STRIP001 
//STRIP001 	USHORT nMaxCols  = nItemCount / nLines;
//STRIP001 	if( nItemCount % nLines )
//STRIP001 		nMaxCols++;
//STRIP001 	if( nCols > nMaxCols )
//STRIP001 		nCols = nMaxCols;
//STRIP001 	nW = nItemW * nCols;
//STRIP001 
//STRIP001 	// Keine ungerade Anzahl von Spalten
//STRIP001 	if( nCols % 2 )
//STRIP001 		nCols--;
//STRIP001 	nCols = Max( nCols, (USHORT) 2 );
//STRIP001 
//STRIP001 	USHORT nMaxLines  = nItemCount / nCols;
//STRIP001 	if( nItemCount % nCols )
//STRIP001 		nMaxLines++;
//STRIP001 	if( nLines > nMaxLines )
//STRIP001 		nLines = nMaxLines;
//STRIP001 	nH = nItemH * nLines;
//STRIP001 
//STRIP001 	rNewSize.Width() = nW;
//STRIP001 	rNewSize.Height() = nH;
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineEndWindow::StartSelection()
//STRIP001 {
//STRIP001 	aLineEndSet.StartSelection();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxLineEndWindow::Close()
//STRIP001 {
//STRIP001 	return SfxPopupWindow::Close();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineEndWindow::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
//STRIP001 							 const SfxHint& rHint, const TypeId& rHintType )
//STRIP001 {
//STRIP001 	const SfxPoolItemHint *pPoolItemHint = PTR_CAST(SfxPoolItemHint, &rHint);
//STRIP001 
//STRIP001 	if ( pPoolItemHint
//STRIP001 		 && ( pPoolItemHint->GetObject()->ISA( SvxLineEndListItem ) ) )
//STRIP001 	{
//STRIP001 		// Die Liste der LinienEnden (LineEndList) hat sich geaendert:
//STRIP001 
//STRIP001 		pLineEndList = ( (SvxLineEndListItem*) pPoolItemHint->
//STRIP001 										GetObject() )->GetLineEndList();
//STRIP001 		DBG_ASSERT( pLineEndList, "LineEndList nicht gefunden" );
//STRIP001 
//STRIP001 		aLineEndSet.Clear();
//STRIP001 		FillValueSet();
//STRIP001 
//STRIP001 		Size aSize = GetOutputSizePixel();
//STRIP001 		Resizing( aSize );
//STRIP001 		Resize();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineEndWindow::PopupModeEnd()
//STRIP001 {
//STRIP001 	if ( IsVisible() )
//STRIP001 	{
//STRIP001 		bPopupMode = FALSE;
//STRIP001 		SetSize();
//STRIP001 	}
//STRIP001 	SfxPopupWindow::PopupModeEnd();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineEndWindow::SetSize()
//STRIP001 {
//STRIP001 	//if( !bPopupMode )
//STRIP001 	if( !IsInPopupMode() )
//STRIP001 	{
//STRIP001 		USHORT nItemCount = aLineEndSet.GetItemCount(); // -> Member
//STRIP001 		USHORT nMaxLines  = nItemCount / nCols; // -> Member ?
//STRIP001 		if( nItemCount % nCols )
//STRIP001 			nMaxLines++;
//STRIP001 
//STRIP001 		WinBits nBits = aLineEndSet.GetStyle();
//STRIP001 		if ( nLines == nMaxLines )
//STRIP001 			nBits &= ~WB_VSCROLL;
//STRIP001 		else
//STRIP001 			nBits |= WB_VSCROLL;
//STRIP001 		aLineEndSet.SetStyle( nBits );
//STRIP001 	}
//STRIP001 
//STRIP001 	Size aSize( aBmpSize );
//STRIP001 	aSize.Width()  += 6;
//STRIP001 	aSize.Height() += 6;
//STRIP001 	aSize = aLineEndSet.CalcWindowSizePixel( aSize );
//STRIP001 	aSize.Width()  += 4;
//STRIP001 	aSize.Height() += 4;
//STRIP001 	SetOutputSizePixel( aSize );
//STRIP001 	aSize.Height() = aBmpSize.Height();
//STRIP001 	aSize.Height() += 14;
//STRIP001 	//SetMinOutputSizePixel( aSize );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxLineEndWindow::GetFocus (void)
//STRIP001 {
//STRIP001 	SfxPopupWindow::GetFocus();
//STRIP001     // Grab the focus to the line ends value set so that it can be controlled
//STRIP001     // with the keyboard.
//STRIP001 	aLineEndSet.GrabFocus();
//STRIP001 }

//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SvxLineEndToolBoxControl
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
SvxLineEndToolBoxControl::SvxLineEndToolBoxControl(	USHORT  nId, ToolBox &rTbx, SfxBindings &rBindings ) :

	SfxToolBoxControl( nId, rTbx, rBindings )

{
}
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxLineEndToolBoxControl::~SvxLineEndToolBoxControl()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxPopupWindowType SvxLineEndToolBoxControl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return SFX_POPUPWINDOW_ONCLICK;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxPopupWindow*	SvxLineEndToolBoxControl::CreatePopupWindow()
//STRIP001 {
//STRIP001 	SvxLineEndWindow* pLineEndWin =
//STRIP001 		new SvxLineEndWindow( GetId(),SVX_RESSTR( RID_SVXSTR_LINEEND ), GetBindings() );
//STRIP001 	pLineEndWin->StartPopupMode( &GetToolBox(), TRUE );
//STRIP001 	pLineEndWin->StartSelection();
//STRIP001 	return pLineEndWin;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLineEndToolBoxControl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	USHORT nId = GetId();
//STRIP001 	ToolBox& rTbx = GetToolBox();
//STRIP001 
//STRIP001 	rTbx.EnableItem( nId, SFX_ITEM_DISABLED != eState );
//STRIP001 	rTbx.SetItemState( nId, ( SFX_ITEM_DONTCARE == eState ) ? STATE_DONTKNOW : STATE_NOCHECK );
//STRIP001 }
//STRIP001 
}
