/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_unsect.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:46:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #ifndef _SVXLINKMGR_HXX
// auto strip #include <bf_svx/linkmgr.hxx>
// auto strip #endif

#ifndef _FMTCNTNT_HXX
#include <fmtcntnt.hxx>
#endif
#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
// auto strip #ifndef _DOCARY_HXX
// auto strip #include <docary.hxx>
// auto strip #endif
#ifndef _SWUNDO_HXX
#include <swundo.hxx>			// fuer die UndoIds
#endif
#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif
// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
// auto strip #ifndef _NDTXT_HXX
// auto strip #include <ndtxt.hxx>
// auto strip #endif
#ifndef _UNDOBJ_HXX
#include <undobj.hxx>
#endif
// auto strip #ifndef _SECTION_HXX
// auto strip #include <section.hxx>
// auto strip #endif
#ifndef _ROLBCK_HXX
#include <rolbck.hxx>
#endif
#ifndef _REDLINE_HXX
#include <redline.hxx>
#endif
#ifndef _DOCTXM_HXX
#include <doctxm.hxx>
#endif
// auto strip #ifndef _FTNIDX_HXX
// auto strip #include <ftnidx.hxx>
// auto strip #endif

// auto strip #ifndef _EDITSH_HXX
// auto strip #include <editsh.hxx>
// auto strip #endif
/// OD 04.10.2002 #102894#
/// class Calc needed for calculation of the hidden condition of a section.
// auto strip #ifndef _CALC_HXX
// auto strip #include <calc.hxx>
// auto strip #endif
namespace binfilter {


//STRIP001 inline SwDoc& SwUndoIter::GetDoc() const { return *pAktPam->GetDoc(); }

/*N*/ SfxItemSet* lcl_GetAttrSet( const SwSection& rSect )
/*N*/ {
/*N*/ 	// Attribute des Formate sichern (Spalten, Farbe, ... )
/*N*/ 	// Cntnt- und Protect- Items interessieren nicht (stehen schon in der
/*N*/ 	// Section), muessen also entfernen werden
/*N*/ 	SfxItemSet* pAttr = 0;
/*N*/ 	if( rSect.GetFmt() )
/*N*/ 	{
/*N*/ 		USHORT nCnt = 1;
/*N*/ 		if( rSect.IsProtect() )
/*N*/ 			++nCnt;
/*N*/ 
/*N*/ 		if( nCnt < rSect.GetFmt()->GetAttrSet().Count() )
/*N*/ 		{
/*N*/ 			pAttr = new SfxItemSet( rSect.GetFmt()->GetAttrSet() );
/*N*/ 			pAttr->ClearItem( RES_PROTECT );
/*N*/ 			pAttr->ClearItem( RES_CNTNT );
/*N*/ 			if( !pAttr->Count() )
/*?*/ 				delete pAttr, pAttr = 0;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return pAttr;
/*N*/ }

/*N*/ SwUndoInsSection::SwUndoInsSection( const SwPaM& rPam, const SwSection& rNew,
/*N*/ 									const SfxItemSet* pSet )
/*N*/ 	: SwUndo( UNDO_INSSECTION ), SwUndRng( rPam ), nSectNodePos( 0 ),
/*N*/ 	pHistory( 0 ), pRedlData( 0 ), pAttr( 0 )
/*N*/ {
/*N*/ 	if( rNew.ISA( SwTOXBaseSection ))
/*N*/ 	{
/*N*/ 		const SwTOXBase& rBase = (SwTOXBaseSection&)rNew;
/*N*/ 		pSection = new SwTOXBaseSection( rBase );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		pSection = new SwSection( rNew.GetType(), rNew.GetName() );
/*N*/ 	*pSection = rNew;
/*N*/ 
/*N*/ 	SwDoc& rDoc = *(SwDoc*)rPam.GetDoc();
/*N*/ 	if( rDoc.IsRedlineOn() )
/*N*/ 	{
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pRedlData = new SwRedlineData( REDLINE_INSERT,
//STRIP001 /*?*/ 										rDoc.GetRedlineAuthor() );
//STRIP001 /*?*/ 		SetRedlineMode( rDoc.GetRedlineMode() );
/*N*/ 	}
/*N*/ 
/*N*/ 	bSplitAtStt = FALSE;
/*N*/ 	bSplitAtEnd = FALSE;
/*N*/ 	bUpdateFtn = FALSE;
/*N*/ 
/*N*/ 	if( pSet && pSet->Count() )
/*N*/ 		pAttr = new SfxItemSet( *pSet );
/*N*/ 
/*N*/ 	if( !rPam.HasMark() )
/*N*/ 	{
/*N*/ 		const SwCntntNode* pCNd = rPam.GetPoint()->nNode.GetNode().GetCntntNode();
/*N*/ 		if( pCNd && pCNd->GetpSwAttrSet() && (
/*N*/ 			!rPam.GetPoint()->nContent.GetIndex() ||
/*N*/ 			rPam.GetPoint()->nContent.GetIndex() == pCNd->Len() ))
/*N*/ 		{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	SfxItemSet aBrkSet( rDoc.GetAttrPool(), aBreakSetRange );
//STRIP001 /*?*/ 			aBrkSet.Put( *pCNd->GetpSwAttrSet() );
//STRIP001 /*?*/ 			if( aBrkSet.Count() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pHistory = new SwHistory;
//STRIP001 /*?*/ 				pHistory->CopyFmtAttr( aBrkSet, pCNd->GetIndex() );
//STRIP001 /*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }


/*N*/ SwUndoInsSection::~SwUndoInsSection()
/*N*/ {
/*N*/ 	delete pSection;
//STRIP001 /*?*/ 	delete pRedlData;
/*N*/ 	delete pAttr;
/*N*/ 
/*N*/ 	if( pHistory )
/*?*/ 		delete pHistory;
/*N*/ }



//STRIP001 void SwUndoInsSection::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 
//STRIP001 	RemoveIdxFromSection( rDoc, nSectNodePos );
//STRIP001 
//STRIP001 	SwSectionNode* pNd = rDoc.GetNodes()[ nSectNodePos ]->GetSectionNode();
//STRIP001 	ASSERT( pNd, "wo ist mein SectionNode?" );
//STRIP001 
//STRIP001 	if( IsRedlineOn( GetRedlineMode() ))
//STRIP001 		rDoc.DeleteRedline( *pNd );
//STRIP001 
//STRIP001 	// lag keine Selektion vor ??
//STRIP001 	SwNodeIndex aIdx( *pNd );
//STRIP001 	if( ( !nEndNode && STRING_MAXLEN == nEndCntnt ) ||
//STRIP001 		( nSttNode == nEndNode && nSttCntnt == nEndCntnt ))
//STRIP001 		// loesche einfach alle Nodes
//STRIP001 		rDoc.GetNodes().Delete( aIdx, pNd->EndOfSectionIndex() -
//STRIP001 										aIdx.GetIndex() );
//STRIP001 	else
//STRIP001 		// einfach das Format loeschen, der Rest erfolgt automatisch
//STRIP001 		rDoc.DelSectionFmt( pNd->GetSection().GetFmt() );
//STRIP001 
//STRIP001 	// muessen wir noch zusammenfassen ?
//STRIP001 	if( bSplitAtStt )
//STRIP001 		Join( rDoc, nSttNode );
//STRIP001 
//STRIP001 	if( bSplitAtEnd )
//STRIP001 		Join( rDoc, nEndNode );
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 		pHistory->TmpRollback( &rDoc, 0, FALSE );
//STRIP001 
//STRIP001 	if( bUpdateFtn )
//STRIP001 		rDoc.GetFtnIdxs().UpdateFtn( aIdx );
//STRIP001 
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 }


//STRIP001 void SwUndoInsSection::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 
//STRIP001 	const SwTOXBaseSection* pUpdateTOX = 0;
//STRIP001 	if( pSection->ISA( SwTOXBaseSection ))
//STRIP001 	{
//STRIP001 		const SwTOXBase& rBase = *(SwTOXBaseSection*)pSection;
//STRIP001 		pUpdateTOX = rDoc.InsertTableOf( *rUndoIter.pAktPam->GetPoint(),
//STRIP001 										rBase, pAttr, TRUE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rDoc.Insert( *rUndoIter.pAktPam, *pSection, pAttr, TRUE );
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 		pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 
//STRIP001 	SwSectionNode* pSectNd = rDoc.GetNodes()[ nSectNodePos ]->GetSectionNode();
//STRIP001 	if( pRedlData && IsRedlineOn( GetRedlineMode() ))
//STRIP001 	{
//STRIP001 		SwRedlineMode eOld = rDoc.GetRedlineMode();
//STRIP001 		rDoc.SetRedlineMode_intern( eOld & ~REDLINE_IGNORE );
//STRIP001 
//STRIP001 		SwPaM aPam( *pSectNd->EndOfSectionNode(), *pSectNd, 1 );
//STRIP001 		rDoc.AppendRedline( new SwRedline( *pRedlData, aPam ));
//STRIP001 		rDoc.SetRedlineMode_intern( eOld );
//STRIP001 	}
//STRIP001 	else if( !( REDLINE_IGNORE & GetRedlineMode() ) &&
//STRIP001 			rDoc.GetRedlineTbl().Count() )
//STRIP001 	{
//STRIP001 		SwPaM aPam( *pSectNd->EndOfSectionNode(), *pSectNd, 1 );
//STRIP001 		rDoc.SplitRedline( aPam );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pUpdateTOX )
//STRIP001 	{
//STRIP001 		// Formatierung anstossen
//STRIP001 		SwEditShell* pESh = rDoc.GetEditShell();
//STRIP001 		if( pESh )
//STRIP001 			pESh->CalcLayout();
//STRIP001 
//STRIP001 		// Seitennummern eintragen
//STRIP001 		((SwTOXBaseSection*)pUpdateTOX)->UpdatePageNum();
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwUndoInsSection::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if( pSection->ISA( SwTOXBaseSection ))
//STRIP001 	{
//STRIP001 		const SwTOXBase& rBase = *(SwTOXBaseSection*)pSection;
//STRIP001 		rUndoIter.GetDoc().InsertTableOf( *rUndoIter.pAktPam->GetPoint(),
//STRIP001 											rBase, pAttr, TRUE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rUndoIter.GetDoc().Insert( *rUndoIter.pAktPam, *pSection, pAttr );
//STRIP001 }


//STRIP001 void SwUndoInsSection::Join( SwDoc& rDoc, ULONG nNode )
//STRIP001 {
//STRIP001 	SwNodeIndex aIdx( rDoc.GetNodes(), nNode );
//STRIP001 	SwTxtNode* pTxtNd = aIdx.GetNode().GetTxtNode();
//STRIP001 	ASSERT( pTxtNd, "wo ist mein TextNode?" );
//STRIP001 
//STRIP001 	{
//STRIP001 		RemoveIdxRel( nNode + 1, SwPosition( aIdx,
//STRIP001 							SwIndex( pTxtNd, pTxtNd->GetTxt().Len() )));
//STRIP001 	}
//STRIP001 	pTxtNd->JoinNext();
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 	{
//STRIP001 		SwIndex aCntIdx( pTxtNd, 0 );
//STRIP001 		pTxtNd->RstAttr( aCntIdx, pTxtNd->GetTxt().Len() );
//STRIP001 	}
//STRIP001 }


/*N*/ void SwUndoInsSection::SaveSplitNode( SwTxtNode* pTxtNd, BOOL bAtStt )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if( pTxtNd->GetpSwpHints() )
//STRIP001 	{
//STRIP001 		if( !pHistory )
//STRIP001 			pHistory = new SwHistory;
//STRIP001 		pHistory->CopyAttr( pTxtNd->GetpSwpHints(), pTxtNd->GetIndex(), 0,
//STRIP001 							pTxtNd->GetTxt().Len(), FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bAtStt )
//STRIP001 		bSplitAtStt = TRUE;
//STRIP001 	else
//STRIP001 		bSplitAtEnd = TRUE;
/*N*/ }


// -----------------------------

//STRIP001 SwUndoDelSection::SwUndoDelSection( const SwSectionFmt& rFmt )
//STRIP001 	 : SwUndo( UNDO_DELSECTION )
//STRIP001 {
//STRIP001 	const SwSection& rSect = *rFmt.GetSection();
//STRIP001 	if( rSect.ISA( SwTOXBaseSection ))
//STRIP001 	{
//STRIP001 		const SwTOXBase& rBase = (SwTOXBaseSection&)rSect;
//STRIP001 		pSection = new SwTOXBaseSection( rBase );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pSection = new SwSection( rSect.GetType(), rSect.GetName() );
//STRIP001 	*pSection = rSect;
//STRIP001 
//STRIP001 	pAttr = ::lcl_GetAttrSet( rSect );
//STRIP001 
//STRIP001 	const SwNodeIndex* pIdx = rFmt.GetCntnt().GetCntntIdx();
//STRIP001 	nSttNd = pIdx->GetIndex();
//STRIP001 	nEndNd = pIdx->GetNode().EndOfSectionIndex();
//STRIP001 }


//STRIP001 SwUndoDelSection::~SwUndoDelSection()
//STRIP001 {
//STRIP001 	delete pSection;
//STRIP001 	delete pAttr;
//STRIP001 }


//STRIP001 void SwUndoDelSection::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 
//STRIP001 	if( pSection->ISA( SwTOXBaseSection ))
//STRIP001 	{
//STRIP001 		const SwTOXBase& rBase = *(SwTOXBaseSection*)pSection;
//STRIP001 		SwTOXBaseSection* pBaseSect =  (SwTOXBaseSection*)rDoc.InsertTableOf(
//STRIP001 										nSttNd, nEndNd-2, rBase, pAttr );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SwNodeIndex aStt( rDoc.GetNodes(), nSttNd );
//STRIP001 		SwNodeIndex aEnd( rDoc.GetNodes(), nEndNd-2 );
//STRIP001 		SwSectionFmt* pFmt = rDoc.MakeSectionFmt( 0 );
//STRIP001 		if( pAttr )
//STRIP001 			pFmt->SetAttr( *pAttr );
//STRIP001 
//STRIP001         /// OD 04.10.2002 #102894#
//STRIP001         /// remember inserted section node for further calculations
//STRIP001         SwSectionNode* pInsertedSectNd =
//STRIP001                 rDoc.GetNodes().InsertSection( aStt, *pFmt, *pSection, &aEnd );
//STRIP001 
//STRIP001 		if( SFX_ITEM_SET == pFmt->GetItemState( RES_FTN_AT_TXTEND ) ||
//STRIP001 			SFX_ITEM_SET == pFmt->GetItemState( RES_END_AT_TXTEND ))
//STRIP001         {
//STRIP001 			rDoc.GetFtnIdxs().UpdateFtn( aStt );
//STRIP001         }
//STRIP001 
//STRIP001         /// OD 04.10.2002 #102894#
//STRIP001         /// consider that section is hidden by condition.
//STRIP001         /// If section is hidden by condition,
//STRIP001         /// recalculate condition and update hidden condition flag.
//STRIP001         /// Recalculation is necessary, because fields, on which the hide
//STRIP001         /// condition depends, can be changed - fields changes aren't undoable.
//STRIP001         /// NOTE: setting hidden condition flag also creates/deletes corresponding
//STRIP001         ///     frames, if the hidden condition flag changes.
//STRIP001         SwSection& aInsertedSect = pInsertedSectNd->GetSection();
//STRIP001         if ( aInsertedSect.IsHidden() &&
//STRIP001              aInsertedSect.GetCondition().Len() > 0 )
//STRIP001         {
//STRIP001             SwCalc aCalc( rDoc );
//STRIP001             rDoc.FldsToCalc( aCalc, pInsertedSectNd->GetIndex() );
//STRIP001             bool bRecalcCondHidden =
//STRIP001                     aCalc.Calculate( aInsertedSect.GetCondition() ).GetBool() ? true : false;
//STRIP001             aInsertedSect.SetCondHidden( bRecalcCondHidden );
//STRIP001         }
//STRIP001 
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwUndoDelSection::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 
//STRIP001 	SwSectionNode* pNd = rDoc.GetNodes()[ nSttNd ]->GetSectionNode();
//STRIP001 	ASSERT( pNd, "wo ist mein SectionNode?" );
//STRIP001 	// einfach das Format loeschen, der Rest erfolgt automatisch
//STRIP001 	rDoc.DelSectionFmt( pNd->GetSection().GetFmt() );
//STRIP001 }



/*N*/ SwUndoChgSection::SwUndoChgSection( const SwSectionFmt& rFmt, BOOL bOnlyAttr )
/*N*/ 	 : SwUndo( UNDO_CHGSECTION ), bOnlyAttrChgd( bOnlyAttr )
/*N*/ {
/*N*/ 	const SwSection& rSect = *rFmt.GetSection();
/*N*/ 	pSection = new SwSection( rSect.GetType(), rSect.GetName() );
/*N*/ 	*pSection = rSect;
/*N*/ 
/*N*/ 	pAttr = ::binfilter::lcl_GetAttrSet( rSect );
/*N*/ 
/*N*/ 	nSttNd = rFmt.GetCntnt().GetCntntIdx()->GetIndex();
/*N*/ }


/*N*/ SwUndoChgSection::~SwUndoChgSection()
/*N*/ {
/*N*/ 	delete pSection;
/*N*/ 	delete pAttr;
/*N*/ }


//STRIP001 void SwUndoChgSection::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SwSectionNode* pSectNd = rDoc.GetNodes()[ nSttNd ]->GetSectionNode();
//STRIP001 	ASSERT( pSectNd, "wo ist mein SectionNode?" );
//STRIP001 
//STRIP001 	SwSection& rNdSect = pSectNd->GetSection();
//STRIP001 	SwFmt* pFmt = rNdSect.GetFmt();
//STRIP001 
//STRIP001 	SfxItemSet* pCur = ::lcl_GetAttrSet( rNdSect );
//STRIP001 	if( pAttr )
//STRIP001 	{
//STRIP001 		// das Content- und Protect-Item muss bestehen bleiben
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 		pAttr->Put( pFmt->GetAttr( RES_CNTNT ));
//STRIP001 		if( SFX_ITEM_SET == pFmt->GetItemState( RES_PROTECT, TRUE, &pItem ))
//STRIP001 			pAttr->Put( *pItem );
//STRIP001 		pFmt->DelDiffs( *pAttr );
//STRIP001 		pAttr->ClearItem( RES_CNTNT );
//STRIP001 		pFmt->SetAttr( *pAttr );
//STRIP001 		delete pAttr;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// dann muessen die alten entfernt werden
//STRIP001 		pFmt->ResetAttr( RES_FRMATR_BEGIN, RES_BREAK );
//STRIP001 		pFmt->ResetAttr( RES_HEADER, RES_OPAQUE );
//STRIP001 		pFmt->ResetAttr( RES_SURROUND, RES_FRMATR_END-1 );
//STRIP001 	}
//STRIP001 	pAttr = pCur;
//STRIP001 
//STRIP001 	if( !bOnlyAttrChgd )
//STRIP001 	{
//STRIP001 		BOOL bUpdate = (!rNdSect.IsLinkType() && pSection->IsLinkType() ) ||
//STRIP001 							( pSection->GetLinkFileName().Len() &&
//STRIP001 								pSection->GetLinkFileName() !=
//STRIP001 								rNdSect.GetLinkFileName());
//STRIP001 
//STRIP001 		SwSection* pTmp = new SwSection( CONTENT_SECTION, aEmptyStr );
//STRIP001 		*pTmp = rNdSect;		// das aktuelle sichern
//STRIP001 
//STRIP001 		rNdSect = *pSection;	// das alte setzen
//STRIP001 
//STRIP001 		delete pSection;
//STRIP001 		pSection = pTmp;		// das aktuelle ist jetzt das alte
//STRIP001 
//STRIP001 		if( bUpdate )
//STRIP001 			rNdSect.CreateLink( CREATE_UPDATE );
//STRIP001 		else if( CONTENT_SECTION == rNdSect.GetType() && rNdSect.IsConnected() )
//STRIP001 		{
//STRIP001 			rNdSect.Disconnect();
//STRIP001 			rDoc.GetLinkManager().Remove( &rNdSect.GetBaseLink() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwUndoChgSection::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	Undo( rUndoIter );
//STRIP001 }



//STRIP001 SwUndoChgSectPsswd::SwUndoChgSectPsswd(
//STRIP001 					const ::com::sun::star::uno::Sequence <sal_Int8>& rOld,
//STRIP001 					const SwSectionNode* pSectNd )
//STRIP001 	: SwUndo( UNDO_CHGSECTIONPASSWD ), aPasswd( rOld )
//STRIP001 {
//STRIP001 	nSectNd = pSectNd ? pSectNd->GetIndex() : 0;
//STRIP001 }


//STRIP001 void SwUndoChgSectPsswd::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 	::com::sun::star::uno::Sequence <sal_Int8> aCurr;
//STRIP001 	const SwSection* pSect = 0;
//STRIP001 	if( nSectNd )
//STRIP001 	{
//STRIP001 		SwSectionNode* pNd = rDoc.GetNodes()[ nSectNd ]->GetSectionNode();
//STRIP001 		ASSERT( pNd, "where is the sectionnode?" );
//STRIP001 		pSect = &pNd->GetSection();
//STRIP001 		aCurr = pSect->GetPasswd();
//STRIP001 	}
//STRIP001     rDoc.ChgSectionPasswd( aPasswd, *pSect );
//STRIP001 	aPasswd = aCurr;
//STRIP001 }


//STRIP001 void SwUndoChgSectPsswd::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	Undo( rUndoIter );
//STRIP001 }



}
