/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: graphctl.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:35:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _GRAPHCTL_HXX
#define _GRAPHCTL_HXX

// include ---------------------------------------------------------------

#ifndef _SV_CTRL_HXX //autogen
#include <vcl/ctrl.hxx>
#endif
#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif

#include <bf_svx/svdview.hxx>
#include <bf_svx/svdobj.hxx>
namespace binfilter {

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 class SvxGraphCtrlAccessibleContext;

//STRIP001 #define WB_SDRMODE		((WinBits)0x0080)
//STRIP001 #define WB_ANIMATION	((WinBits)0x0100)

//STRIP001 class GraphCtrl : public Control
//STRIP001 {
//STRIP001 	friend class GraphCtrlView;
//STRIP001 	friend class GraphCtrlUserCall;
//STRIP001 
//STRIP001 	Graphic				aGraphic;
//STRIP001 	Timer				aUpdateTimer;
//STRIP001 	Link				aMousePosLink;
//STRIP001 	Link				aGraphSizeLink;
//STRIP001 	Link				aMarkObjLink;
//STRIP001 	Link				aUpdateLink;
//STRIP001 	MapMode				aMap100;
//STRIP001 	Size				aGraphSize;
//STRIP001 	Point				aMousePos;
//STRIP001 	GraphCtrlUserCall*	pUserCall;
//STRIP001 	WinBits				nWinStyle;
//STRIP001 	SdrObjKind			eObjKind;
//STRIP001 	USHORT				nPolyEdit;
//STRIP001 	BOOL				bEditMode;
//STRIP001 	BOOL				bSdrMode;
//STRIP001 	BOOL				bAnim;
//STRIP001 
//STRIP001 						DECL_LINK( UpdateHdl, Timer* );
//STRIP001 
//STRIP001 	SvxGraphCtrlAccessibleContext* mpAccContext;
//STRIP001 
//STRIP001 protected:
//STRIP001 
//STRIP001 	SdrModel*			pModel;
//STRIP001 	SdrView*			pView;
//STRIP001 
//STRIP001 	virtual void		Paint( const Rectangle& rRect );
//STRIP001 	virtual void		Resize();
//STRIP001 	virtual void		KeyInput(const KeyEvent& rKEvt);
//STRIP001 	virtual void		MouseButtonDown(const MouseEvent& rMEvt);
//STRIP001 	virtual void		MouseButtonUp(const MouseEvent& rMEvt);
//STRIP001 	virtual void		MouseMove(const MouseEvent& rMEvt);
//STRIP001 
//STRIP001 	virtual void		InitSdrModel();
//STRIP001 
//STRIP001 	virtual void		SdrObjCreated( const SdrObject& rObj );
//STRIP001 	virtual void		SdrObjChanged( const SdrObject& rObj );
//STRIP001 	virtual	void		MarkListHasChanged();
//STRIP001 
//STRIP001 	SdrObjUserCall*		GetSdrUserCall() { return (SdrObjUserCall*) pUserCall; }
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 						GraphCtrl( Window* pParent, const WinBits nWinBits = 0 );
//STRIP001 						GraphCtrl( Window* pParent, const ResId& rResId );
//STRIP001 						~GraphCtrl();
//STRIP001 
//STRIP001 	void				SetWinStyle( WinBits nWinBits );
//STRIP001 	WinBits				GetWinStyle() const { return nWinStyle; }
//STRIP001 
//STRIP001 	void				SetGraphic( const Graphic& rGraphic, BOOL bNewModel = TRUE );
//STRIP001 	const Graphic&		GetGraphic() const { return aGraphic; }
//STRIP001 	const Size&			GetGraphicSize() const { return aGraphSize; }
//STRIP001 
//STRIP001 	const Point&		GetMousePos() const { return aMousePos; }
//STRIP001 
//STRIP001 	void				SetEditMode( const BOOL bEditMode );
//STRIP001 	BOOL				IsEditMode() const { return bEditMode; }
//STRIP001 
//STRIP001 	void				SetPolyEditMode( const USHORT nPolyEdit );
//STRIP001 	USHORT				GetPolyEditMode() const { return nPolyEdit; }
//STRIP001 
//STRIP001 	void				SetObjKind( const SdrObjKind eObjKind );
//STRIP001 	SdrObjKind			GetObjKind() const { return eObjKind; }
//STRIP001 
//STRIP001 	SdrModel*			GetSdrModel() const { return pModel; }
//STRIP001 	SdrView*			GetSdrView() const { return pView; }
//STRIP001 	SdrObject*			GetSelectedSdrObject() const;
//STRIP001 	BOOL				IsChanged() const { return bSdrMode ? pModel->IsChanged() : FALSE; }
//STRIP001 
//STRIP001 	void				SetMousePosLink( const Link& rLink ) { aMousePosLink = rLink; }
//STRIP001 	const Link&			GetMousePosLink() const { return aMousePosLink; }
//STRIP001 
//STRIP001 	void				SetGraphSizeLink( const Link& rLink ) { aGraphSizeLink = rLink; }
//STRIP001 	const Link&			GetGraphSizeLink() const { return aGraphSizeLink; }
//STRIP001 
//STRIP001 	void				SetMarkObjLink( const Link& rLink ) { aMarkObjLink = rLink; }
//STRIP001 	const Link&			GetMarkObjLink() const { return aMarkObjLink; }
//STRIP001 
//STRIP001 	void				SetUpdateLink( const Link& rLink ) { aUpdateLink = rLink; }
//STRIP001 	const Link&			GetUpdateLink() const { return aUpdateLink; }
//STRIP001 
//STRIP001 	static String		GetStringFromDouble( const double& rDouble );
//STRIP001 
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > CreateAccessible();
//STRIP001 };

#if _SOLAR__PRIVATE

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 class GraphCtrlUserCall : public SdrObjUserCall
//STRIP001 {
//STRIP001 	GraphCtrl&		rWin;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					GraphCtrlUserCall( GraphCtrl& rGraphWin ) : rWin( rGraphWin ) {};
//STRIP001 	virtual			~GraphCtrlUserCall() {};
//STRIP001 
//STRIP001 	virtual void	Changed( const SdrObject& rObj, SdrUserCallType eType, const Rectangle& rOldBoundRect );
//STRIP001 };

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 class GraphCtrlView : public SdrView
//STRIP001 {
//STRIP001 	GraphCtrl&		rGraphCtrl;
//STRIP001 
//STRIP001 protected:
//STRIP001 
//STRIP001 	virtual void	MarkListHasChanged()
//STRIP001 					{
//STRIP001 						SdrView::MarkListHasChanged();
//STRIP001 						rGraphCtrl.MarkListHasChanged();
//STRIP001 					}
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					GraphCtrlView( SdrModel* pModel, GraphCtrl* pWindow) :
//STRIP001 							SdrView		( pModel, pWindow ),
//STRIP001 							rGraphCtrl	( *pWindow ) {};
//STRIP001 
//STRIP001 	virtual			~GraphCtrlView() {};
//STRIP001 };

#endif // __PRIVATE

}//end of namespace binfilter
#endif // _GRAPHCTL_HXX

