/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: opertype.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 15:54:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_OPERTYPE_HXX
#define ARY_OPERTYPE_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <ary/ids.hxx>
	// PARAMETERS


namespace ary
{


struct S_LocalOperation
{
    udmstri             sLocalName;
    OSid                nSignature;
    Cid                 nId;

                        S_LocalOperation()      : nId(0) {}
                        S_LocalOperation(
                            const udmstri &     i_sLocalName,
                            OSid                i_nSignature,
                            Cid                 i_nId )
                                                :   sLocalName(i_sLocalName),
                                                    nSignature(i_nSignature),
                                                    nId(i_nId) {}
    bool                operator<(
                            const S_LocalOperation &
                                                i_rOther ) const;
};

typedef std::set< S_LocalOperation >        Set_LocalOperation;
typedef std::vector< S_LocalOperation >     List_LocalOperation;



// IMPLEMENTATION



#if 0
//class OperationType
//{
//  public:
//						OperationType();
//						OperationType(
//                            Tid                 i_nReturnType,
//                            OSid                i_nOperationSignature );
//    // OPERATORS
//	bool				operator<(
//							const OperationType &
//												i_rOperType ) const;
//
//    // INQUIRY
//    Tid                 ReturnType() const;
//    OSid                Signature() const;
//
//	/**	Compares just ids of signature and return type.
//		So the result is not always human reconstructable.
//		@return like in strcmp().
//	*/
//	int					Compare(
//							const OperationType &
//												i_rOperType ) const;
//  private:
//	Tid					nReturnType;
//	OSid	            nSig;
//};
//
//inline bool
//OperationType::operator<( const OperationType &	i_rOperType ) const
//	{ return Compare(i_rOperType) < 0; }
//inline Tid
//OperationType::ReturnType() const
//	{ return nReturnType; }
//inline OSid
//OperationType::Signature() const
//	{ return nSig; }
#endif // 0


} // namespace ary


#endif
