/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: l_gate.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:03:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_LOC_L_GATE_HXX
#define ARY_LOC_L_GATE_HXX


// USED SERVICES
	// BASE CLASSES
#include <ary/loc/l_rwgate.hxx>
#include <ary/loc/l_rogate.hxx>
	// COMPONENTS
	// PARAMETERS



namespace ary
{
    namespace store
    {
        class Locations_Ifc;
    }

    class IdGenerator;


namespace loc
{

class Gate : public RwGate,
             public RoGate
{
  public:
                        Gate(
                            ary::store::Locations_Ifc &
                                                i_rStorage,
                            IdGenerator &       i_rIds );
                        ~Gate();
  private:
    // Interface RwGate:
    virtual LocationRoot &
                        do_CheckIn_Root(
                            const csv::ploc::Path &
                                                i_rPath );
    virtual SourceCodeFile &
                        do_CheckIn_File(
                            const udmstri &     i_sFileName,
                            const csv::ploc::DirectoryChain &
                                                i_rFileSubPath,
                            Lid                 i_nRootDir );
    // Interface RoGate:
    virtual LocationRoot *
                        inq_Find_Root(
                            Lid                 i_nRootId ) const;
    virtual SourceCodeFile *
                        inq_Find_File(
                            Lid                 i_nFileId ) const;
    // Locals
    struct CheshireCat;

    // DATA
    Dyn<CheshireCat>    pi;
};


}   // namespace loc
}   // namespace ary


#endif


