/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: types.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:40:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "types.hxx"

#ifndef CONFIGMGR_UPDATEACCESSOR_HXX
#include "updateaccessor.hxx"
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef INCLUDED_STRING_H
#include <string.h>
#define INCLUDED_STRING_H
#endif

namespace configmgr
{
//-----------------------------------------------------------------------------	
    namespace sharable
    {
//-----------------------------------------------------------------------------	
        using memory::Allocator;
        using memory::Accessor;
//-----------------------------------------------------------------------------	
sal_Size const c_nDataOffset        = sizeof(sal_Int32);
sal_Size const c_nStringCharSize    = sizeof(sal_Unicode);
//-----------------------------------------------------------------------------	
static inline
sal_Int32& implGetLength(Allocator const& _anAllocator, String _aString)
{
    OSL_ASSERT(_aString != 0);
    void * pBase = _anAllocator.access(_aString);
    return * static_cast<sal_Int32 *>(pBase);
}

//-----------------------------------------------------------------------------	
static inline
sal_Int32 implGetLength(Accessor const& _anAccessor, String _aString)
{
    OSL_ASSERT(_aString != 0);
    void const * pBase = _anAccessor.access( memory::Pointer(_aString) );
    return * static_cast<sal_Int32 const *>(pBase);
}

//-----------------------------------------------------------------------------	
//-----------------------------------------------------------------------------	
// for now, Name == String
//-----------------------------------------------------------------------------	

Name allocName(Allocator const& _anAllocator, rtl::OUString const & _sString)
{
    return allocString(_anAllocator, _sString);
}
//-----------------------------------------------------------------------------	
// Name copyName(Allocator const& _anAllocator, Name _aName);
//-----------------------------------------------------------------------------	

void freeName(Allocator const& _anAllocator, Name _aName)
{
    freeString(_anAllocator, _aName);
}
//-----------------------------------------------------------------------------	

::rtl::OUString readName(Accessor const& _anAccessor, Name _aName)
{
    return readString(_anAccessor, _aName);
}
//-----------------------------------------------------------------------------	

NameChar const * accessName(Accessor const& _anAccessor, Name _aName)
{
    return accessString(_anAccessor, _aName);
}
//-----------------------------------------------------------------------------	
//-----------------------------------------------------------------------------	

String allocString(Allocator const& _anAllocator, rtl::OUString const & _sString)
{
    sal_Int32 nLength = _sString.getLength();
    sal_Int32 nTextSize = (nLength + 1) * c_nStringCharSize;

    String anAddress = _anAllocator.allocate(c_nDataOffset + nTextSize);
    if (anAddress)
    {
        implGetLength(_anAllocator, anAddress) = nLength;

        void * pData = _anAllocator.access(anAddress + c_nDataOffset);
        ::memcpy(pData, _sString.getStr(), nTextSize);
    }
    return anAddress;
}
//-----------------------------------------------------------------------------	

//String copyString(Allocator const& _anAllocator, String _aString);

//-----------------------------------------------------------------------------	

void freeString(Allocator const& _anAllocator, String _aString)
{
    _anAllocator.deallocate(_aString);
}
//-----------------------------------------------------------------------------	

::rtl::OUString readString(Accessor const& _anAccessor, String _aString)
{
    OSL_ENSURE(_aString, "Trying to read a NULL string");
    if (!_aString) return rtl::OUString();

    sal_Int32 nLength = implGetLength(_anAccessor, _aString);

    void const * pData = _anAccessor.access( memory::Pointer(_aString + c_nDataOffset) );

    sal_Unicode const * pText = static_cast<sal_Unicode const *>(pData);

    return rtl::OUString(pText,nLength);
}
//-----------------------------------------------------------------------------	

StringChar const * accessString(Accessor const& _anAccessor, String _aString)
{
    OSL_ENSURE(_aString, "Trying to read a NULL string");
    if (!_aString) return NULL;

    void const * pData = _anAccessor.access( memory::Pointer(_aString + c_nDataOffset) );

    sal_Unicode const * pText = static_cast<sal_Unicode const *>(pData);

    return pText;
}
//-----------------------------------------------------------------------------	
    }
//-----------------------------------------------------------------------------	
} // namespace
 
