/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: updateaccessor.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:40:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "updateaccessor.hxx"

#ifndef CONFIGMGR_SEGMENT_HXX
#include "segment.hxx"
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

// -----------------------------------------------------------------------------

namespace configmgr
{
// -----------------------------------------------------------------------------
    namespace memory
    {
    // -------------------------------------------------------------------------
        UpdateAccessor::UpdateAccessor(Segment * segment)
        : m_segment(segment)
        {
            m_heap = (m_segment) ? &m_segment->acquireWriteAccess() : 0;
            OSL_ASSERT( m_heap || !m_segment );
        }
    // -------------------------------------------------------------------------
        UpdateAccessor::~UpdateAccessor()
        {
            if (m_segment) m_segment->releaseWriteAccess(*m_heap);
        }
    // -------------------------------------------------------------------------
        Accessor UpdateAccessor::accessor() const
        {
            return Accessor(m_segment);
        }

    // -------------------------------------------------------------------------
        Accessor UpdateAccessor::downgrade()
        {
            Segment * segment = m_segment;
            void const * base = NULL;
            if (m_segment)
            {
                base = m_segment->acquireReadAccess();
                m_segment->releaseWriteAccess(*m_heap);
                m_segment = 0;
            }

            return Accessor(segment, base, SAL_NO_ACQUIRE);
        }

    // -------------------------------------------------------------------------
        void UpdateAccessor::clear()
        {
            if (m_segment)
            {
                m_segment->releaseWriteAccess(*m_heap);
                m_segment = NULL;
            }
        }

    // -------------------------------------------------------------------------
        char * UpdateAccessor::heap_base() const
        {
            return static_cast<char *>(m_heap ? m_heap->base() : NULL);
        }

    // -------------------------------------------------------------------------
        char * Allocator::heap_base() const
        {
            return static_cast<char *>(m_heap ? m_heap->base() : NULL);
        }

    // -------------------------------------------------------------------------
        Allocator::Address Allocator::allocate(Size _sz) const
        {
            OSL_ENSURE(m_heap,"Cannot allocate: Invalid heap");
            return m_heap ? m_heap->allocate(_sz) : Allocator::Address();
        }

    // -------------------------------------------------------------------------
        void Allocator::deallocate(Address _addr) const
        {
            OSL_ENSURE(m_heap,"Cannot deallocate: Invalid heap");
            if (m_heap) m_heap->deallocate(_addr);
        }

    // -------------------------------------------------------------------------

    #if OSL_DEBUG_LEVEL > 0
        void * UpdateAccessor::resolve(AddressType _p) const
        {
            OSL_ENSURE( !_p.is() || m_segment->isValidAddress(_p.value()), "Address does not belong to this segment");
            return _p.is() ? heap_base() + _p.value() : NULL;
        }

        Pointer  UpdateAccessor::reduce(void const * _p) const
        {
            if (_p)
            {
                Pointer::RawAddress addr = static_cast<char const *>(_p) - heap_base();
                OSL_ENSURE( m_segment->isValidAddress(addr), "Pointer does not belong to this segment");
                return Pointer(addr);
            }
            else
                return Pointer();
        }

        void * Allocator::access(Address _addr) const
        {
            OSL_ENSURE( !_addr || m_heap->isValidAddress(_addr), "Address does not belong to this segment");
            return _addr ? heap_base() + _addr : NULL;
        }


        Allocator::Address  Allocator::address(void const * _p) const
        {
            if (_p)
            {
                Address addr = static_cast<char const *>(_p) - heap_base();
                OSL_ENSURE( m_heap->isValidAddress(addr), "Pointer does not belong to this segment");
                return addr;
            }
            else
                return 0;
        }
  #endif // OSL_DEBUG_LEVEL

    // -------------------------------------------------------------------------
    }
// -----------------------------------------------------------------------------
} // namespace configmgr


