/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dlgrename.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 14:59:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef DBAUI_DLGRENAME_HRC
#include "dlgrename.hrc"
#endif
#ifndef _DBAUI_DLGRENAME_HXX
#include "dlgrename.hxx"
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif
#ifndef _DBU_DLG_HRC_
#include "dbu_dlg.hrc"
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................

 
//==================================================================
DlgRename::DlgRename( Window* pParent, const ::rtl::OUString& _sOldName, sal_Bool _bCheck,USHORT _nLength)
		:ModalDialog( pParent, ModuleRes(DLG_RENAME ))
		,aFT_Text(this,	ResId( FT_TEXT))
		,aED_Name(this,	ResId( ED_NAME))
		,aPB_OK(this,		ResId(PB_OK))
		,aPB_CANCEL(this,	ResId(PB_CANCEL))
		,aPB_HELP(this,		ResId(PB_HELP))
{
	String aMsg = aFT_Text.GetText();
	aMsg.SearchAndReplace(String::CreateFromAscii("$name$"),String(_sOldName));
	aFT_Text.SetText(aMsg);
	aED_Name.SetText( _sOldName );
	aED_Name.setCheck(_bCheck); // enable non valid sql chars as well
	aED_Name.SetMaxTextLen(_nLength);
	FreeResource();
}

//------------------------------------------------------------------------------
::rtl::OUString DlgRename::GetValue()
{
	return aED_Name.GetText();
}

// -----------------------------------------------------------------------------
//.........................................................................
}	// namespace dbaui
//.........................................................................


