/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: protdlg.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 19:37:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "protdlg.hrc"
#include "protdlg.hxx"

/* -------------------------------------------------------------------------*/
DetailsButton::DetailsButton(Window* pParent, const ResId& rResId) :
    PushButton(pParent, rResId)
{
    mbExpanded = FALSE;
}

void DetailsButton::Click()
{
    mbExpanded = !mbExpanded;
    ((ProtocolsSelectionDialog *) GetParent()) -> resize(mbExpanded);
}

/* -------------------------------------------------------------------------*/
ToggleButton::ToggleButton(Window* pParent, const ResId& rResId) :
  RadioButton(pParent, rResId)
{
}

void ToggleButton::Click()
{
    ProtocolsSelectionDialog *parent = ((ProtocolsSelectionDialog *)
                                        GetParent());
    BOOL starOn = (&parent->maStar == this);
//    if (starOn) parent->maOther.Check(FALSE);
//    else parent->maStar.Check(FALSE);
    parent->maSelection.Enable(starOn);
    parent->maListGroup.Enable(starOn);
    RadioButton::Click();
}

/* -------------------------------------------------------------------------*/
ProtocolsSelectionDialog::ProtocolsSelectionDialog(Window* pParent,
                                                   ResMgr* pResMgr) :
ModalDialog(pParent, ResId(MD_PROTCHK_DIALOG, pResMgr)),
maRadioGroup(this, ResId(GB_DEFAULT_BROWSER, pResMgr)),
maListGroup(this, ResId(GB_PROTOCOL_CHOICE, pResMgr)),
maStar(this, ResId(RB_STAROFFICE, pResMgr)),
maOther(this, ResId(RB_OTHER, pResMgr)),
maOK(this, ResId(BT_OK, pResMgr)),
maCancel(this, ResId(BT_CANCEL, pResMgr)),
// maHelp(this, ResId(BT_HELP, pResMgr)),      #65702#
maDetails(this, ResId(BT_DETAILS, pResMgr)),
maPerform(this, ResId(CB_PERFORM, pResMgr)),
maSelection(this, ResId(CLB_PROTOCOLS, pResMgr)),
maHttp(ResId(STR_HTTP, pResMgr)),
maFtp(ResId(STR_FTP, pResMgr)),
maHttps(ResId(STR_HTTPS, pResMgr)),
maMail(ResId(STR_MAIL, pResMgr)),
maNews(ResId(STR_NEWS, pResMgr)),
maNoDetails(ResId(STR_NODETAILS, pResMgr)),
maExpanded(GetSizePixel())
{
#ifdef OS2
    maDetails.Show(FALSE);
#endif
    maDetailsStr = maDetails.GetText();
//    maHelp.Show(FALSE);
    maStar.Check();
    maPerform.Check();
    Point zP(maDetails.GetPosPixel());
    Size zS(maDetails.GetSizePixel());
    Point oP(maOK.GetPosPixel());
    maNormal = Size(maExpanded.Width(), zP.Y() + zS.Height() +
                    (oP.Y() * 4 - 24));
    resize(FALSE);
    maStar.GrabFocus();
}

ProtocolsSelectionDialog::~ProtocolsSelectionDialog()
{
    FreeResource();
}

void ProtocolsSelectionDialog::resize(BOOL expanded)
{
    maListGroup.Show(expanded);
    if (expanded)
    {
        maSelection.Enable();
        SetSizePixel(maExpanded);
        maDetails.SetText(maNoDetails);
    }
    else
    {
        maSelection.Disable();
        SetSizePixel(maNormal);
        maDetails.SetText(maDetailsStr);
    }
}

