/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: brwcontrol.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 20:04:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _EXTENSIONS_PROPCTRLR_BRWCONTROL_HXX_
#define _EXTENSIONS_PROPCTRLR_BRWCONTROL_HXX_

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _EXTENSIONS_PROPCTRLR_PCRCOMMON_HXX_
#include "pcrcommon.hxx"
#endif

class Size;
class Point;
class Window;
//............................................................................
namespace pcr
{
//............................................................................

	class IBrowserControlListener;

	//========================================================================
	//= BrowserControlType
	//========================================================================
	enum BrowserControlType
	{
		BCT_UNDEFINED,
		BCT_LISTBOX,
		BCT_COMBOBOX,
		BCT_EDIT,
		BCT_COLORBOX,
		BCT_USERDEFINED,
		BCT_MEDIT,
		BCT_NUMFIELD,
		BCT_DATEFIELD,
		BCT_TIMEFIELD,
		BCT_LEDIT,
		BCT_CURFIELD,
		BCT_CHAREDIT,
		BCT_DATETIME
	};

	//========================================================================
	//= BrowserControlType
	//========================================================================
	class IBrowserControl
	{
	public:
            virtual                         ~IBrowserControl() { };

            virtual void                        setListener(IBrowserControlListener*) = 0;
            virtual IBrowserControlListener*    getListener() = 0;

            virtual void                    SetProperty( const ::rtl::OUString& rString,sal_Bool bIsUnknown = sal_False ) = 0;
            virtual ::rtl::OUString         GetProperty() const = 0;

            virtual sal_Bool                HasList() = 0;
            virtual void                    ClearList() = 0;
            virtual void                    InsertCtrEntry( const ::rtl::OUString& rString, sal_uInt16 nPos = EDITOR_LIST_APPEND ) = 0;

            virtual sal_Bool                IsModified() = 0;
            virtual void                    CommitModified() = 0;

            virtual void                    SetMyName( const ::rtl::OUString &rString ) = 0;
            virtual ::rtl::OUString         GetMyName() const = 0;

            virtual void                    SetLine( sal_uInt16 nLine ) = 0;
            virtual sal_uInt16              GetLine() = 0;

            virtual Window*                 GetMe() = 0;

            virtual void                    SetCtrSize( const Size& rSize ) = 0;
            virtual void                    SetCtrPos( const Point& aPoint ) = 0;
            virtual Point                   GetCtrPos() const = 0;
            virtual Size                    GetCtrSize() const = 0;
	};

//............................................................................
} // namespace pcr
//............................................................................

#endif // _EXTENSIONS_PROPCTRLR_BRWCONTROL_HXX_

