
#ifndef __FRAMEWORK_CLASSES_EVENTSCONFIGURATION_HXX_
#include <classes/eventsconfiguration.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_EVENTSDOCUMENTHANDLER_HXX_
#include <classes/eventsdocumenthandler.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_SAXNAMESPACEFILTER_HXX_
#include <services/saxnamespacefilter.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif

#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

using namespace ::rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::xml::sax;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::io;


namespace framework
{

static Reference< XParser > GetSaxParser(
	// #110897#
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory
	)
{
	// #110897#
	// Reference< XMultiServiceFactory > xServiceManager = ::comphelper::getProcessServiceFactory();
	return Reference< XParser >( xServiceFactory->createInstance(
		::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Parser" )), UNO_QUERY);
}

static Reference< XDocumentHandler > GetSaxWriter(
	// #110897#
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory
	)
{
	// #110897#
	// Reference< XMultiServiceFactory > xServiceManager = ::comphelper::getProcessServiceFactory();
	return Reference< XDocumentHandler >( xServiceFactory->createInstance(
		::rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Writer" )), UNO_QUERY) ;
}

// #110897#
sal_Bool EventsConfiguration::LoadEventsConfig( 
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
	SvStream& rInStream, 
	EventsConfig& aItems )
{
	Reference< XParser > xParser( GetSaxParser( xServiceFactory ) );
	Reference< XInputStream > xInputStream( 
								(::cppu::OWeakObject *)new utl::OInputStreamWrapper( rInStream ), 
								UNO_QUERY );

	// connect stream to input stream to the parser
	InputSource aInputSource;

	aInputSource.aInputStream = xInputStream;

	// create namespace filter and set events document handler inside to support xml namespaces
	Reference< XDocumentHandler > xDocHandler( new OReadEventsDocumentHandler( aItems ));
	Reference< XDocumentHandler > xFilter( new SaxNamespaceFilter( xDocHandler ));

	// connect parser and filter
	xParser->setDocumentHandler( xFilter );

	try
	{
		xParser->parseStream( aInputSource );
		return sal_True;
	}
	catch ( RuntimeException& )
	{
		return sal_False;
	}
	catch( SAXException& )
	{
		return sal_False;
	}
	catch( ::com::sun::star::io::IOException& )
	{
		return sal_False;
	}

	return sal_False;
}

// #110897#
sal_Bool EventsConfiguration::StoreEventsConfig( 
	const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
	SvStream& rOutStream, 
	const EventsConfig& aItems )
{
	Reference< XDocumentHandler > xWriter( GetSaxWriter( xServiceFactory ) );

	Reference< XOutputStream > xOutputStream( 
								(::cppu::OWeakObject *)new utl::OOutputStreamWrapper( rOutStream ), 
								UNO_QUERY );

	Reference< ::com::sun::star::io::XActiveDataSource> xDataSource( xWriter , UNO_QUERY );
	xDataSource->setOutputStream( xOutputStream );

	try
	{
		OWriteEventsDocumentHandler aWriteEventsDocumentHandler( aItems, xWriter );
		aWriteEventsDocumentHandler.WriteEventsDocument();
		return sal_True;
	}
	catch ( RuntimeException& )
	{
		return sal_False;
	}
	catch ( SAXException& )
	{
		return sal_False;
	}
	catch ( ::com::sun::star::io::IOException& )
	{
		return sal_False;
	}

	return sal_False;
}

}
