/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ko_phonetic.h,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:16:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <sal/types.h>

static sal_uInt16 PhoneticIndex_ko[] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 0000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 1000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 2000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0100,   // 4000
	0x0200, 0x0300, 0x0400, 0x0500, 0x0600, 0x0700, 0x0800, 0x0900, 0x0A00, 0x0B00, 0x0C00, 0x0D00, 0x0E00, 0x0F00, 0x1000, 0x1100,   // 5000
	0x1200, 0x1300, 0x1400, 0x1500, 0x1600, 0x1700, 0x1800, 0x1900, 0x1A00, 0x1B00, 0x1C00, 0x1D00, 0x1E00, 0x1F00, 0x2000, 0x2100,   // 6000
	0x2200, 0x2300, 0x2400, 0x2500, 0x2600, 0x2700, 0x2800, 0x2900, 0x2A00, 0x2B00, 0x2C00, 0x2D00, 0x2E00, 0x2F00, 0x3000, 0x3100,   // 7000
	0x3200, 0x3300, 0x3400, 0x3500, 0x3600, 0x3700, 0x3800, 0x3900, 0x3A00, 0x3B00, 0x3C00, 0x3D00, 0x3E00, 0x3F00, 0x4000, 0x4100,   // 8000
	0x4200, 0x4300, 0x4400, 0x4500, 0x4600, 0x4700, 0x4800, 0x4900, 0x4A00, 0x4B00, 0x4C00, 0x4D00, 0x4E00, 0x4F00, 0x5000, 0x5100,   // 9000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x5200, 0x5300, 0x5400, 0x5500,   // A000
	0x5600, 0x5700, 0x5800, 0x5900, 0x5A00, 0x5B00, 0x5C00, 0x5D00, 0x5E00, 0x5F00, 0x6000, 0x6100, 0x6200, 0x6300, 0x6400, 0x6500,   // B000
	0x6600, 0x6700, 0x6800, 0x6900, 0x6A00, 0x6B00, 0x6C00, 0x6D00, 0x6E00, 0x6F00, 0x7000, 0x7100, 0x7200, 0x7300, 0x7400, 0x7500,   // C000
	0x7600, 0x7700, 0x7800, 0x7900, 0x7A00, 0x7B00, 0x7C00, 0x7D00, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // D000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // E000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x7E00, 0xFFFF, 0x7F00, 0x8000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F000
};

static sal_uInt16 PhoneticCharacter_ko[] = {
	0xC77C, 0xC815, 0xFFFF, 0xCE60, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9CC, 0xC7A5, 0xC0BC, 0xC0C1, 0xD558, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF,   // 4E00 - 4E0F
	0xFFFF, 0xCD95, 0xFFFF, 0xFFFF, 0xCC28, 0xBE44, 0xC138, 0xFFFF, 0xAD6C, 0xBCD1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2B9, 0xFFFF,   // 4E10 - 4E1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC911, 0xFFFF, 0xFFFF,   // 4E20 - 4E2F
	0xFFFF, 0xFFFF, 0xACF6, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD658, 0xB2E8, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 4E30 - 4E3F
	0xFFFF, 0xFFFF, 0xC608, 0xB0B4, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C0, 0xFFFF, 0xC0AC, 0xD638, 0xD54D,   // 4E40 - 4E4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD34, 0xFFFF, 0xC2B9, 0xC744, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xAC78, 0xC57C,   // 4E50 - 4E5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC08, 0xFFFF, 0xB3CC, 0xFFFF, 0xFFFF,   // 4E60 - 4E6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC720, 0xFFFF, 0xFFFF, 0xBCFC, 0xC0B4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC74, 0xFFFF,   // 4E70 - 4E7F
	0xFFFF, 0xFFFF, 0xB780, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8CC, 0xFFFF, 0xC5EC, 0xFFFF, 0xFFFF, 0xC0AC, 0xC774, 0xFFFF, 0xC6B0, 0xFFFF,   // 4E80 - 4E8F
	0xC6B8, 0xC6B4, 0xD638, 0xFFFF, 0xC624, 0xC815, 0xFFFF, 0xFFFF, 0xAE0D, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xC544, 0xFFFF,   // 4E90 - 4E9F
	0xFFFF, 0xB9DD, 0xD56D, 0xFFFF, 0xAD50, 0xD574, 0xC5ED, 0xFFFF, 0xD615, 0xFFFF, 0xFFFF, 0xD5A5, 0xACBD, 0xC815, 0xB7C9, 0xFFFF,   // 4EA0 - 4EAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xC778, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 4EB0 - 4EBF
	0xC2ED, 0xC778, 0xFFFF, 0xFFFF, 0xCE21, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xAE08, 0xAC1C, 0xFFFF, 0xC789, 0xFFFF, 0xFFFF,   // 4EC0 - 4ECF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC790, 0xC0AC, 0xD0C0, 0xC7A5, 0xBD80, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3D9, 0xFFFF, 0xCC9C,   // 4ED0 - 4EDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xB300, 0xB839, 0xC774, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 4EE0 - 4EEF
	0xC559, 0xFFFF, 0xC911, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC74, 0xAC1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xC784, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 4EF0 - 4EFF
	0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD56D, 0xC774, 0xAE09, 0xFFFF, 0xC624, 0xAE30, 0xBCF5,   // 4F00 - 4F0F
	0xBC8C, 0xD734, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 4F10 - 4F1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC31,   // 4F20 - 4F2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC18, 0xFFFF, 0xB839, 0xFFFF, 0xC2E0, 0xFFFF, 0xC0AC, 0xFFFF, 0xC0AC, 0xAC00, 0xFFFF, 0xFFFF,   // 4F30 - 4F3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xB2E8, 0xC800, 0xD3EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC704, 0xC800, 0xC8FC,   // 4F40 - 4F4F
	0xC88C, 0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xD558, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5EC, 0xC77C, 0xBD88, 0xC791, 0xFFFF, 0xFFFF, 0xFFFF,   // 4F50 - 4F5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD328, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC591,   // 4F60 - 4F6F
	0xBC31, 0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xAE38, 0xFFFF, 0xFFFF, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xC77C, 0xC0AC,   // 4F70 - 4F7F
	0xFFFF, 0xC2E0, 0xFFFF, 0xAC04, 0xC9C8, 0xFFFF, 0xB798, 0xFFFF, 0xCE58, 0xFFFF, 0xAD11, 0xB840, 0xFFFF, 0xC2DC, 0xFFFF, 0xC8FC,   // 4F80 - 4F8F
	0xFFFF, 0xC720, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB95C, 0xFFFF, 0xCC28, 0xFFFF, 0xFFFF, 0xACF5, 0xFFFF, 0xC758, 0xFFFF, 0xFFFF,   // 4F90 - 4F9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBAA8, 0xD6C4,   // 4FA0 - 4FAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE68, 0xB824, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3B8,   // 4FB0 - 4FBF
	0xFFFF, 0xFFFF, 0xACC4, 0xCD09, 0xC544, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xC900, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xFFFF,   // 4FC0 - 4FCF
	0xFFFF, 0xC6A9, 0xFFFF, 0xACBD, 0xD604, 0xFFFF, 0xFFFF, 0xC18D, 0xFFFF, 0xFFFF, 0xB9AC, 0xFFFF, 0xFFFF, 0xBCF4, 0xFFFF, 0xC0AC,   // 4FD0 - 4FDF
	0xD611, 0xC2E0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xBD80,   // 4FE0 - 4FEF
	0xFFFF, 0xAD6C, 0xFFFF, 0xBC30, 0xFFFF, 0xD45C, 0xFFFF, 0xFFFF, 0xBD09, 0xFFFF, 0xC5C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 4FF0 - 4FFF
	0xFFFF, 0xFFFF, 0xBCD1, 0xFFFF, 0xFFFF, 0xFFFF, 0xB7C9, 0xFFFF, 0xFFFF, 0xCC3D, 0xFFFF, 0xAC1C, 0xFFFF, 0xBC30, 0xFFFF, 0xFFFF,   // 5000 - 500F
	0xFFFF, 0xBB38, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xD589, 0xFFFF, 0xFFFF, 0xD6C4, 0xC758, 0xFFFF, 0xCC99, 0xFFFF, 0xACBD, 0xCC28,   // 5010 - 501F
	0xFFFF, 0xCC3D, 0xFFFF, 0xBC29, 0xCE58, 0xFFFF, 0xAD8C, 0xC885, 0xAC70, 0xFFFF, 0xC608, 0xB95C, 0xD0C1, 0xC65C, 0xFFFF, 0xFFFF,   // 5020 - 502F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC57C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5030 - 503F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC5B8, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC00, 0xAC8C, 0xC704, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3B8,   // 5040 - 504F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD574, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8FC, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF, 0xFFFF,   // 5050 - 505F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC74, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5060 - 506F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE21, 0xC815, 0xC6B0, 0xFFFF, 0xD22C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5070 - 507F
	0xAD34, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF,   // 5080 - 508F
	0xFFFF, 0xAC78, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0B0, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5090 - 509F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD5C, 0xC6A9, 0xFFFF, 0xFFFF,   // 50A0 - 50AF
	0xFFFF, 0xFFFF, 0xC624, 0xC804, 0xFFFF, 0xCC44, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF,   // 50B0 - 50BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA8, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0C1,   // 50C0 - 50CF
	0xFFFF, 0xAD50, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCF5, 0xD76C, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xC704, 0xFFFF,   // 50D0 - 50DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC694, 0xFFFF, 0xC2B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC38, 0xFFFF, 0xFFFF,   // 50E0 - 50EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xBCBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC,   // 50F0 - 50FF
	0xC758, 0xC900, 0xFFFF, 0xFFFF, 0xC5B5, 0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xAC80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5100 - 510F
	0xFFFF, 0xFFFF, 0xC720, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0C1,   // 5110 - 511F
	0xFFFF, 0xB8B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5120 - 512F
	0xFFFF, 0xFFFF, 0xC800, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB824, 0xFFFF, 0xFFFF, 0xB098, 0xFFFF, 0xC5C4, 0xFFFF, 0xFFFF, 0xFFFF,   // 5130 - 513F
	0xC62C, 0xC724, 0xFFFF, 0xC6D0, 0xD615, 0xCDA9, 0xC870, 0xD749, 0xC120, 0xAD11, 0xFFFF, 0xADF9, 0xD0DC, 0xBA74, 0xD1A0, 0xFFFF,   // 5140 - 514F
	0xFFFF, 0xFFFF, 0xC544, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB450, 0xFFFF, 0xFFFF, 0xFFFF,   // 5150 - 515F
	0xFFFF, 0xFFFF, 0xAE0D, 0xFFFF, 0xFFFF, 0xC785, 0xFFFF, 0xB0B4, 0xC804, 0xB7C9, 0xC720, 0xD314, 0xACF5, 0xB959, 0xD61C, 0xFFFF,   // 5160 - 516F
	0xFFFF, 0xACF5, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCD1, 0xAE30, 0xAD6C, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xACB8, 0xFFFF, 0xFFFF, 0xFFFF,   // 5170 - 517F
	0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5D4, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC45, 0xFFFF, 0xFFFF, 0xC7AC, 0xFFFF, 0xFFFF,   // 5180 - 518F
	0xFFFF, 0xFFFF, 0xBAA8, 0xFFFF, 0xFFFF, 0xBA74, 0xFFFF, 0xC6A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5190 - 519F
	0xAD00, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBA85, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBA71, 0xFFFF, 0xB3D9, 0xFFFF, 0xFFFF, 0xFFFF,   // 51A0 - 51AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC57C, 0xB7AD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB82C, 0xFFFF, 0xFFFF,   // 51B0 - 51BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC98, 0xFFFF, 0xC900, 0xFFFF, 0xFFFF, 0xB7C9, 0xFFFF, 0xC870, 0xB989, 0xB3D9, 0xFFFF, 0xFFFF,   // 51C0 - 51CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB984, 0xC751, 0xD76C, 0xFFFF,   // 51D0 - 51DF
	0xFFFF, 0xBC94, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 51E0 - 51EF
	0xD669, 0xAC1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD749, 0xFFFF, 0xCCA0, 0xC694, 0xCD9C, 0xFFFF, 0xFFFF, 0xD568, 0xFFFF, 0xFFFF,   // 51F0 - 51FF
	0xB3C4, 0xFFFF, 0xFFFF, 0xC778, 0xFFFF, 0xFFFF, 0xBD84, 0xC808, 0xC608, 0xFFFF, 0xAC04, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB38, 0xFFFF,   // 5200 - 520F
	0xFFFF, 0xD615, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB82C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF,   // 5210 - 521F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD310, 0xBCC4, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9AC, 0xC0B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD04, 0xFFFF,   // 5220 - 522F
	0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C, 0xC1C4, 0xAD8C, 0xCC30, 0xC790, 0xAC01, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5230 - 523F
	0xFFFF, 0xFFFF, 0xFFFF, 0xCCB4, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE59, 0xFFFF, 0xFFFF, 0xC0AD, 0xADF9, 0xB784, 0xC804, 0xFFFF, 0xFFFF,   // 5240 - 524F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC99, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC15, 0xFFFF, 0xBC15, 0xFFFF, 0xFFFF,   // 5250 - 525F
	0xFFFF, 0xC12C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC789, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80,   // 5260 - 526F
	0xFFFF, 0xFFFF, 0xD560, 0xFFFF, 0xFFFF, 0xCC3D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD45C, 0xFFFF, 0xCD08,   // 5270 - 527F
	0xFFFF, 0xFFFF, 0xFFFF, 0xD68D, 0xFFFF, 0xFFFF, 0xFFFF, 0xADF9, 0xBCBD, 0xB958, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC80, 0xFFFF, 0xFFFF,   // 5280 - 528F
	0xFFFF, 0xC81C, 0xAC80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB825, 0xFFFF, 0xFFFF, 0xFFFF, 0xACF5,   // 5290 - 529F
	0xAC00, 0xFFFF, 0xFFFF, 0xB82C, 0xADFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xB178, 0xAC81, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 52A0 - 52AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD575, 0xFFFF,   // 52B0 - 52BF
	0xFFFF, 0xACBD, 0xFFFF, 0xBC1C, 0xFFFF, 0xCE59, 0xFFFF, 0xC6A9, 0xFFFF, 0xBA74, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xFFFF,   // 52C0 - 52CF
	0xFFFF, 0xFFFF, 0xB975, 0xFFFF, 0xFFFF, 0xB3D9, 0xC6B1, 0xFFFF, 0xAC10, 0xBB34, 0xFFFF, 0xD6C8, 0xFFFF, 0xC2B9, 0xB85C, 0xBAA8,   // 52D0 - 52DF
	0xFFFF, 0xFFFF, 0xC138, 0xC801, 0xADFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 52E0 - 52EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xD6C8, 0xFFFF, 0xB824, 0xFFFF, 0xFFFF, 0xAD8C, 0xFFFF, 0xC791, 0xADE0, 0xFFFF, 0xFFFF, 0xAD6C, 0xBB3C,   // 52F0 - 52FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF, 0xD749, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xD3EC,   // 5300 - 530F
	0xBCF5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xD654, 0xBD81, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5310 - 531F
	0xC7A5, 0xAD11, 0xFFFF, 0xAC11, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD68C,   // 5320 - 532F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD544, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2C9,   // 5330 - 533F
	0xAD6C, 0xC2ED, 0xFFFF, 0xCC9C, 0xC785, 0xFFFF, 0xFFFF, 0xC2B9, 0xC624, 0xD6FC, 0xBC18, 0xFFFF, 0xFFFF, 0xB9CC, 0xFFFF, 0xFFFF,   // 5340 - 534F
	0xFFFF, 0xBE44, 0xC878, 0xD0C1, 0xD611, 0xFFFF, 0xFFFF, 0xB0A8, 0xFFFF, 0xFFFF, 0xBC15, 0xFFFF, 0xBCF5, 0xFFFF, 0xBCC0, 0xFFFF,   // 5350 - 535F
	0xC810, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD18, 0xFFFF, 0xC124, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB18,   // 5360 - 536F
	0xC778, 0xC704, 0xFFFF, 0xFFFF, 0xAC01, 0xB780, 0xFFFF, 0xAD8C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC989, 0xFFFF, 0xACBD,   // 5370 - 537F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC561, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5380 - 538F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC560, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9AC, 0xFFFF, 0xD6C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6D0,   // 5390 - 539F
	0xCE21, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD90, 0xD558, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5FC, 0xFFFF, 0xFFFF,   // 53A0 - 53AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC70, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 53B0 - 53BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xCC38, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xCC28, 0xAE09, 0xC6B0, 0xFFFF, 0xBC18, 0xFFFF, 0xFFFF,   // 53C0 - 53CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC219, 0xFFFF, 0xCDE8, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 53D0 - 53DF
	0xFFFF, 0xC608, 0xCD1D, 0xAD6C, 0xACE0, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE0, 0xC9C0, 0xADDC, 0xC18C, 0xD314, 0xFFFF, 0xAC00,   // 53E0 - 53EF
	0xD0DC, 0xC9C8, 0xC0AC, 0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 53F0 - 53FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xD758, 0xAC01, 0xFFFF, 0xFFFF, 0xFFFF, 0xD569, 0xAE38, 0xC801, 0xFFFF, 0xB3D9, 0xBA85, 0xD6C4, 0xB9AC,   // 5400 - 540F
	0xD1A0, 0xD5A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD70, 0xFFFF, 0xB9B0, 0xFFFF, 0xC74C,   // 5410 - 541F
	0xD3D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xBD84, 0xFFFF, 0xD568, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5420 - 542F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD761, 0xCDE8, 0xFFFF, 0xBB38, 0xD6C4, 0xFFFF, 0xC624, 0xFFFF,   // 5430 - 543F
	0xFFFF, 0xFFFF, 0xB824, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5440 - 544F
	0xFFFF, 0xD0C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5450 - 545F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8FC, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5460 - 546F
	0xFFFF, 0xACE0, 0xFFFF, 0xBBF8, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2E0, 0xD638, 0xBA85, 0xFFFF, 0xFFFF,   // 5470 - 547F
	0xC800, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD654, 0xFFFF, 0xAD6C, 0xFFFF,   // 5480 - 548F
	0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5490 - 549F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xC790, 0xFFFF, 0xFFFF, 0xC9C0, 0xAD50, 0xFFFF, 0xFFFF, 0xFFFF,   // 54A0 - 54AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xD574, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD568, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC778, 0xFFFF, 0xFFFF,   // 54B0 - 54BF
	0xC560, 0xD488, 0xFFFF, 0xFFFF, 0xD64D, 0xFFFF, 0xFFFF, 0xFFFF, 0xD569, 0xC7AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 54C0 - 54CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 54D0 - 54DF
	0xFFFF, 0xC6D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE1, 0xD6A8, 0xFFFF,   // 54E0 - 54EF
	0xFFFF, 0xFFFF, 0xCCA0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 54F0 - 54FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD328, 0xFFFF, 0xC0AC, 0xC9C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9AC, 0xFFFF,   // 5500 - 550F
	0xB2F9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9D0, 0xFFFF, 0xFFFF, 0xFFFF,   // 5510 - 551F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC720,   // 5520 - 552F
	0xFFFF, 0xCC3D, 0xFFFF, 0xFFFF, 0xFFFF, 0xC554, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C0, 0xFFFF,   // 5530 - 553F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C1, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB38,   // 5540 - 554F
	0xFFFF, 0xFFFF, 0xFFFF, 0xACC4, 0xFFFF, 0xFFFF, 0xB2F4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC544, 0xFFFF,   // 5550 - 555F
	0xFFFF, 0xFFFF, 0xFFFF, 0xD568, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5560 - 556F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C, 0xFFFF, 0xFFFF, 0xFFFF,   // 5570 - 557F
	0xAC1D, 0xFFFF, 0xFFFF, 0xFFFF, 0xC120, 0xFFFF, 0xCCA0, 0xB77C, 0xFFFF, 0xD6C4, 0xD568, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5580 - 558F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC9C, 0xD6FC, 0xD658, 0xFFFF, 0xD76C, 0xAC08, 0xFFFF, 0xFFFF,   // 5590 - 559F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6E4, 0xFFFF, 0xC720, 0xC0C1, 0xB07D, 0xAD50, 0xFFFF, 0xB2E8, 0xFFFF,   // 55A0 - 55AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 55B0 - 55BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6C4, 0xFFFF, 0xC0C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 55C0 - 55CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xCC28,   // 55D0 - 55DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xCE58, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 55E0 - 55EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xC8FC, 0xFFFF,   // 55F0 - 55FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C4, 0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5600 - 560F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5610 - 561F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC18C,   // 5620 - 562F
	0xFFFF, 0xFFFF, 0xC870, 0xFFFF, 0xCDE8, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5630 - 563F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5640 - 564F
	0xFFFF, 0xFFFF, 0xFFFF, 0xD5C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5650 - 565F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xD76C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5660 - 566F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD84, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5670 - 567F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6A8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5680 - 568F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5690 - 569F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5F0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE48, 0xFFFF, 0xD5A5, 0xFFFF,   // 56A0 - 56AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC791, 0xFFFF, 0xFFFF, 0xFFFF,   // 56B0 - 56BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB0AD, 0xFFFF, 0xFFFF, 0xD76C, 0xFFFF, 0xFFFF,   // 56C0 - 56CF
	0xFFFF, 0xCD09, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xC0AC, 0xFFFF, 0xFFFF, 0xD68C, 0xFFFF,   // 56D0 - 56DF
	0xC778, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 56E0 - 56EF
	0xACE4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB839, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 56F0 - 56FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xD3EC, 0xC5B4, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD8C, 0xFFFF, 0xFFFF, 0xAD6D, 0xFFFF, 0xC704, 0xFFFF, 0xFFFF,   // 5700 - 570F
	0xFFFF, 0xFFFF, 0xC6D0, 0xC6D0, 0xFFFF, 0xFFFF, 0xB3C4, 0xFFFF, 0xB2E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD1A0,   // 5710 - 571F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADDC, 0xFFFF, 0xFFFF,   // 5720 - 572F
	0xC9C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5730 - 573F
	0xC9C0, 0xFFFF, 0xD310, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADE0, 0xFFFF, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xB2F4, 0xAC10, 0xFFFF,   // 5740 - 574F
	0xC88C, 0xAC31, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5750 - 575F
	0xFFFF, 0xD30C, 0xFFFF, 0xFFFF, 0xACE4, 0xFFFF, 0xD0C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xB300, 0xFFFF,   // 5760 - 576F
	0xACBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C1, 0xFFFF, 0xFFFF, 0xFFFF,   // 5770 - 577F
	0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB300, 0xFFFF, 0xFFFF, 0xD615, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5780 - 578F
	0xFFFF, 0xFFFF, 0xFFFF, 0xD574, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5790 - 579F
	0xC740, 0xFFFF, 0xAD6C, 0xC6D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 57A0 - 57AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 57B0 - 57BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC560, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6A9, 0xC900, 0xFFFF, 0xFFFF, 0xB9E4, 0xFFFF, 0xFFFF, 0xC131, 0xFFFF,   // 57C0 - 57CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5ED,   // 57D0 - 57DF
	0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 57E0 - 57EF
	0xCC44, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DD, 0xFFFF, 0xFFFF, 0xC9D1, 0xFFFF, 0xBC30, 0xAE30, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF,   // 57F0 - 57FF
	0xAD74, 0xFFFF, 0xB2F9, 0xFFFF, 0xFFFF, 0xACAC, 0xD1F4, 0xFFFF, 0xAC15, 0xC721, 0xC545, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5800 - 580F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA9, 0xFFFF,   // 5810 - 581F
	0xFFFF, 0xBCF4, 0xFFFF, 0xFFFF, 0xC81C, 0xFFFF, 0xFFFF, 0xC5F0, 0xFFFF, 0xFFFF, 0xAC10, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC694,   // 5820 - 582F
	0xC5B8, 0xBCF4, 0xFFFF, 0xFFFF, 0xC7A5, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACC4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5830 - 583F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD34, 0xC601, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC1C,   // 5840 - 584F
	0xFFFF, 0xC18C, 0xFFFF, 0xFFFF, 0xD0D1, 0xFFFF, 0xFFFF, 0xB3C4, 0xB2F9, 0xFFFF, 0xCD1D, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0C8, 0xFFFF,   // 5850 - 585F
	0xFFFF, 0xC804, 0xC624, 0xFFFF, 0xD6C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5860 - 586F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC38, 0xFFFF, 0xFFFF, 0xC804, 0xFFFF, 0xC219, 0xFFFF,   // 5870 - 587F
	0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xC11C, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5880 - 588F
	0xFFFF, 0xFFFF, 0xFFFF, 0xBB18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xFFFF, 0xC99D, 0xD5C8,   // 5890 - 589F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB35, 0xB3C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C0, 0xFFFF,   // 58A0 - 58AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xBD84, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xC7A5, 0xFFFF, 0xFFFF, 0xAC04, 0xFFFF,   // 58B0 - 58BF
	0xFFFF, 0xBCBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xC639, 0xFFFF, 0xB2E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6C8, 0xFFFF,   // 58C0 - 58CF
	0xFFFF, 0xD559, 0xFFFF, 0xC555, 0xFFFF, 0xD638, 0xFFFF, 0xFFFF, 0xB8E8, 0xAD11, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD34, 0xB871,   // 58D0 - 58DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xC784, 0xFFFF, 0xFFFF, 0xC7A5,   // 58E0 - 58EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC77C, 0xD638, 0xC11C, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF,   // 58F0 - 58FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD558,   // 5900 - 590F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xC11D, 0xC678, 0xFFFF, 0xFFFF, 0xC219, 0xB2E4, 0xFFFF, 0xC57C, 0xFFFF, 0xFFFF, 0xFFFF,   // 5910 - 591F
	0xFFFF, 0xFFFF, 0xBABD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB300, 0xFFFF, 0xCC9C, 0xD0DC, 0xBD80, 0xFFFF, 0xC694, 0xC559, 0xFFFF,   // 5920 - 592F
	0xFFFF, 0xC2E4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC774, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD611, 0xFFFF,   // 5930 - 593F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5C4, 0xFFFF, 0xFFFF, 0xAE30, 0xB0B4, 0xBD09, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADDC, 0xC8FC,   // 5940 - 594F
	0xD658, 0xACC4, 0xFFFF, 0xFFFF, 0xBD84, 0xD601, 0xFFFF, 0xD22C, 0xFFFF, 0xFFFF, 0xD574, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5950 - 595F
	0xC804, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xFFFF, 0xFFFF, 0xD0C8, 0xC724, 0xC7A5, 0xC11D, 0xBD84, 0xFFFF,   // 5960 - 596F
	0xFFFF, 0xFFFF, 0xFFFF, 0xB140, 0xB178, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC04, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF, 0xFFFF,   // 5970 - 597F
	0xFFFF, 0xFFFF, 0xC5EC, 0xBE44, 0xB9DD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC784, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5980 - 598F
	0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xC694, 0xAE08, 0xFFFF, 0xBB18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5990 - 599F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C0, 0xFFFF, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xD22C, 0xFFFF, 0xFFFF, 0xFFFF,   // 59A0 - 59AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9E4, 0xFFFF, 0xCC98, 0xFFFF, 0xFFFF, 0xCCA9, 0xFFFF,   // 59B0 - 59BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF, 0xBAA8, 0xFFFF, 0xFFFF, 0xC790, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 59C0 - 59CF
	0xC800, 0xACE0, 0xFFFF, 0xC131, 0xC704, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC784, 0xC694, 0xFFFF, 0xAC15, 0xC8FC, 0xFFFF, 0xFFFF,   // 59D0 - 59DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC04, 0xFFFF, 0xC774, 0xFFFF, 0xC9C8, 0xFFFF, 0xD76C, 0xFFFF, 0xD56D, 0xFFFF,   // 59E0 - 59EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5F0, 0xFFFF, 0xFFFF, 0xC778, 0xFFFF, 0xFFFF, 0xFFFF, 0xC790,   // 59F0 - 59FF
	0xFFFF, 0xC704, 0xFFFF, 0xC65C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5A00 - 5A0F
	0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB0AD, 0xFFFF, 0xFFFF, 0xC624, 0xB098, 0xFFFF, 0xFFFF, 0xC5F0,   // 5A10 - 5A1F
	0xC2E0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC544, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5A20 - 5A2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCDE8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC3D, 0xFFFF, 0xFFFF, 0xFFFF,   // 5A30 - 5A3F
	0xFFFF, 0xB8E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD30C, 0xFFFF, 0xFFFF, 0xC644, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5A40 - 5A4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD63C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5A50 - 5A5F
	0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5A60 - 5A6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5A70 - 5A7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5A80 - 5A8F
	0xFFFF, 0xFFFF, 0xB9E4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBBF8, 0xC6D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5A90 - 5A9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5AA0 - 5AAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5AB0 - 5ABF
	0xFFFF, 0xAC00, 0xC218, 0xFFFF, 0xC6D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C8, 0xFFFF, 0xFFFF, 0xD610, 0xFFFF, 0xFFFF, 0xFFFF,   // 5AC0 - 5ACF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5AD0 - 5ADF
	0xFFFF, 0xC801, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD56D, 0xFFFF, 0xFFFF, 0xB208, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5AE0 - 5AEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5AF0 - 5AFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD654, 0xFFFF, 0xFFFF, 0xFFFF, 0xD76C, 0xFFFF, 0xC120, 0xAD50, 0xFFFF, 0xFFFF, 0xFFFF,   // 5B00 - 5B0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5B10 - 5B1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE48, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5B20 - 5B2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5B30 - 5B3F
	0xC0C1, 0xFFFF, 0xFFFF, 0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5B40 - 5B4F
	0xC790, 0xD608, 0xFFFF, 0xFFFF, 0xACF5, 0xC789, 0xFFFF, 0xC790, 0xC874, 0xFFFF, 0xBD80, 0xFFFF, 0xC790, 0xD6A8, 0xFFFF, 0xB9F9,   // 5B50 - 5B5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xACC4, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD574, 0xFFFF, 0xC190, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5B60 - 5B6F
	0xC219, 0xC794, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xD559, 0xFFFF, 0xC720, 0xFFFF, 0xC5BC, 0xFFFF, 0xFFFF, 0xFFFF,   // 5B70 - 5B7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB301, 0xFFFF, 0xC6B0, 0xC218, 0xC548, 0xFFFF, 0xC1A1, 0xC644, 0xFFFF, 0xFFFF, 0xAD49,   // 5B80 - 5B8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xBCF5, 0xFFFF, 0xD0D5, 0xD6A1, 0xC885, 0xAD00, 0xC8FC, 0xC815, 0xC644, 0xC758, 0xFFFF, 0xFFFF, 0xFFFF,   // 5B90 - 5B9F
	0xFFFF, 0xFFFF, 0xAC1D, 0xC120, 0xC2E4, 0xC720, 0xD658, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC131, 0xFFFF, 0xAD81, 0xFFFF,   // 5BA0 - 5BAF
	0xC7AC, 0xFFFF, 0xFFFF, 0xD574, 0xC5F0, 0xC18C, 0xAC00, 0xFFFF, 0xC2E0, 0xC6A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC219,   // 5BB0 - 5BBF
	0xCC44, 0xFFFF, 0xC801, 0xC6D0, 0xAE30, 0xC778, 0xBC00, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF,   // 5BC0 - 5BCF
	0xB9E4, 0xFFFF, 0xD55C, 0xC6B0, 0xC2DD, 0xFFFF, 0xFFFF, 0xB155, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9C9, 0xCC30,   // 5BD0 - 5BDF
	0xFFFF, 0xACFC, 0xCE68, 0xFFFF, 0xC624, 0xC694, 0xC2E4, 0xB155, 0xCC44, 0xC2EC, 0xFFFF, 0xC0AC, 0xAD00, 0xFFFF, 0xB8CC, 0xC900,   // 5BE0 - 5BEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD1D, 0xBCF4, 0xFFFF, 0xCD0C, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5BF0 - 5BFF
	0xFFFF, 0xBD09, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xC7A5, 0xC804, 0xC704, 0xC874, 0xC2EC, 0xFFFF, 0xB300, 0xB3C4, 0xC18C,   // 5C00 - 5C0F
	0xFFFF, 0xC18C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA8, 0xFFFF, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5C10 - 5C1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5C20 - 5C2F
	0xFFFF, 0xCDE8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DC, 0xC724, 0xCC99, 0xACE0, 0xB2C8, 0xFFFF, 0xBBF8, 0xB1E8,   // 5C30 - 5C3F
	0xAD6D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC70, 0xACC4, 0xFFFF, 0xAD74, 0xFFFF, 0xFFFF, 0xC625, 0xFFFF, 0xC2DC, 0xC2DC, 0xFFFF,   // 5C40 - 5C4F
	0xFFFF, 0xC124, 0xFFFF, 0xFFFF, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCD1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5C50 - 5C5F
	0xB3C4, 0xFFFF, 0xB8E8, 0xFFFF, 0xCE35, 0xB9AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC18D, 0xFFFF, 0xFFFF, 0xB454,   // 5C60 - 5C6F
	0xFFFF, 0xC0B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD758, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5C70 - 5C7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5C80 - 5C8F
	0xAE30, 0xC7A0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5C90 - 5C9F
	0xFFFF, 0xAC15, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC554, 0xFFFF, 0xC218, 0xAC11, 0xFFFF, 0xFFFF, 0xFFFF,   // 5CA0 - 5CAF
	0xFFFF, 0xB300, 0xFFFF, 0xC545, 0xFFFF, 0xD638, 0xFFFF, 0xBBFC, 0xC548, 0xFFFF, 0xB839, 0xFFFF, 0xFFFF, 0xFFFF, 0xC810, 0xFFFF,   // 5CB0 - 5CBF
	0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5CC0 - 5CCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE58, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5CD0 - 5CDF
	0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC544, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD09,   // 5CE0 - 5CEF
	0xBD09, 0xFFFF, 0xFFFF, 0xFFFF, 0xD604, 0xFFFF, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC900, 0xFFFF, 0xD611, 0xFFFF, 0xFFFF,   // 5CF0 - 5CFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC22D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB798, 0xAE30, 0xFFFF,   // 5D00 - 5D0F
	0xFFFF, 0xACE4, 0xFFFF, 0xFFFF, 0xCD5C, 0xFFFF, 0xC560, 0xAC15, 0xFFFF, 0xB95C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5D10 - 5D1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC22D, 0xFFFF, 0xBD95, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5D20 - 5D2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5D30 - 5D3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBBF8, 0xAC10, 0xFFFF, 0xFFFF, 0xFFFF,   // 5D40 - 5D4F
	0xB78C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5D50 - 5D5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC22D, 0xFFFF, 0xFFFF, 0xC678, 0xFFFF, 0xFFFF, 0xCC28,   // 5D60 - 5D6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5D70 - 5D7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5D80 - 5D8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB4F1, 0xFFFF, 0xFFFF,   // 5D90 - 5D9F
	0xAD50, 0xFFFF, 0xC694, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5C5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5DA0 - 5DAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC601, 0xFFFF, 0xB839, 0xFFFF, 0xC11C, 0xC545, 0xFFFF, 0xFFFF,   // 5DB0 - 5DBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC678, 0xFFFF, 0xFFFF,   // 5DC0 - 5DCF
	0xFFFF, 0xFFFF, 0xB9CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xC554, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC9C, 0xC8FC, 0xFFFF,   // 5DD0 - 5DDF
	0xFFFF, 0xC21C, 0xC18C, 0xFFFF, 0xFFFF, 0xACF5, 0xC88C, 0xAD50, 0xAC70, 0xFFFF, 0xFFFF, 0xBB34, 0xFFFF, 0xFFFF, 0xCC28, 0xFFFF,   // 5DE0 - 5DEF
	0xFFFF, 0xAE30, 0xC774, 0xC0AC, 0xD30C, 0xFFFF, 0xFFFF, 0xD56D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC190, 0xAC74, 0xFFFF,   // 5DF0 - 5DFF
	0xFFFF, 0xFFFF, 0xC2DC, 0xD3EC, 0xFFFF, 0xFFFF, 0xBC94, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD76C, 0xFFFF, 0xFFFF, 0xFFFF,   // 5E00 - 5E0F
	0xFFFF, 0xD0D5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA9, 0xFFFF, 0xFFFF, 0xC9C8, 0xFFFF, 0xBC31, 0xFFFF, 0xC81C, 0xFFFF, 0xFFFF,   // 5E10 - 5E1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xC11D, 0xFFFF, 0xFFFF,   // 5E20 - 5E2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC7A5, 0xFFFF, 0xFFFF, 0xB300, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBAA8, 0xFFFF, 0xD6C4,   // 5E30 - 5E3F
	0xC815, 0xFFFF, 0xFFFF, 0xFFFF, 0xC545, 0xD3ED, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD669, 0xFFFF, 0xFFFF, 0xFFFF,   // 5E40 - 5E4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE58,   // 5E50 - 5E5F
	0xFFFF, 0xBC88, 0xB2F9, 0xD3D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5E60 - 5E6F
	0xFFFF, 0xFFFF, 0xAC04, 0xD3C9, 0xB144, 0xFFFF, 0xFFFF, 0xBCD1, 0xD589, 0xAC04, 0xFFFF, 0xD658, 0xC720, 0xC720, 0xAE30, 0xFFFF,   // 5E70 - 5E7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7A5, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC11C,   // 5E80 - 5E8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC800, 0xFFFF, 0xC810, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF,   // 5E90 - 5E9F
	0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C4, 0xC88C, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE0, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF,   // 5EA0 - 5EAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC554, 0xC11C, 0xAC15, 0xC6A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC720, 0xFFFF,   // 5EB0 - 5EBF
	0xFFFF, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD558, 0xB834, 0xB791, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5EC0 - 5ECF
	0xAD6C, 0xFFFF, 0xFFFF, 0xACFD, 0xFFFF, 0xFFFF, 0xB8CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8FC, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB18,   // 5ED0 - 5EDF
	0xCC3D, 0xFFFF, 0xD3D0, 0xAD11, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB824, 0xFFFF, 0xFFFF, 0xFFFF,   // 5EE0 - 5EEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xCCAD, 0xFFFF, 0xFFFF, 0xC5F0, 0xC815, 0xFFFF, 0xFFFF, 0xAC74, 0xD68C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5EF0 - 5EFF
	0xFFFF, 0xBCC0, 0xFFFF, 0xFFFF, 0xB871, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DD,   // 5F00 - 5F0F
	0xFFFF, 0xC2DC, 0xFFFF, 0xAD81, 0xC870, 0xC778, 0xFFFF, 0xBD88, 0xD64D, 0xFFFF, 0xFFFF, 0xC774, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C,   // 5F10 - 5F1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD604, 0xD638, 0xFFFF, 0xB178, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5F20 - 5F2F
	0xFFFF, 0xC57D, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC15, 0xFFFF, 0xD544, 0xFFFF, 0xFFFF, 0xFFFF,   // 5F30 - 5F3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C4, 0xFFFF, 0xAC15, 0xFFFF, 0xBBF8, 0xFFFF, 0xB9CC, 0xFFFF,   // 5F40 - 5F4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2E8, 0xD61C, 0xFFFF, 0xD718, 0xFFFF, 0xC774, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5F50 - 5F5F
	0xFFFF, 0xFFFF, 0xD615, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5B8, 0xC6B1, 0xFFFF, 0xCC44, 0xD45C, 0xC870, 0xBE48, 0xD33D, 0xFFFF, 0xFFFF,   // 5F60 - 5F6F
	0xCC3D, 0xC601, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC29, 0xFFFF, 0xC5ED, 0xFFFF, 0xFFFF, 0xD53C, 0xFFFF, 0xFFFF, 0xBD88,   // 5F70 - 5F7F
	0xC655, 0xC815, 0xFFFF, 0xFFFF, 0xFFFF, 0xB300, 0xFFFF, 0xC21C, 0xFFFF, 0xFFFF, 0xD68C, 0xB960, 0xD6C4, 0xFFFF, 0xFFFF, 0xFFFF,   // 5F80 - 5F8F
	0xC11C, 0xACBD, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB4DD, 0xBC30, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC885, 0xFFFF,   // 5F90 - 5F9F
	0xB798, 0xC5B4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD669, 0xBCF5, 0xC21C, 0xFFFF, 0xFFFF, 0xFFFF, 0xBBF8, 0xFFFF,   // 5FA0 - 5FAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9D5, 0xFFFF, 0xB355, 0xFFFF, 0xCCA0, 0xFFFF, 0xFFFF, 0xFFFF, 0xD718, 0xFFFF, 0xFFFF,   // 5FB0 - 5FBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC2EC, 0xFFFF, 0xD544, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xC778, 0xFFFF, 0xFFFF,   // 5FC0 - 5FCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD0C, 0xC9C0, 0xB9DD, 0xB9DD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5FD0 - 5FDF
	0xCDA9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCF8C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 5FE0 - 5FEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB150, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD640, 0xFFFF, 0xBD84,   // 5FF0 - 5FFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC559,   // 6000 - 600F
	0xFFFF, 0xFFFF, 0xB178, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB839, 0xC0AC, 0xFFFF, 0xFFFF,   // 6010 - 601F
	0xD0DC, 0xC774, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE09, 0xFFFF, 0xC131, 0xC6D0, 0xFFFF, 0xAD34, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC81,   // 6020 - 602F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6030 - 603F
	0xFFFF, 0xC784, 0xC21C, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD669, 0xFFFF, 0xFFFF,   // 6040 - 604F
	0xACF5, 0xFFFF, 0xD56D, 0xFFFF, 0xFFFF, 0xC11C, 0xFFFF, 0xFFFF, 0xFFFF, 0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD04, 0xFFFF, 0xFFFF,   // 6050 - 605F
	0xFFFF, 0xFFFF, 0xD68C, 0xC790, 0xD73C, 0xCE58, 0xFFFF, 0xFFFF, 0xD55C, 0xC740, 0xAC01, 0xFFFF, 0xB150, 0xACF5, 0xFFFF, 0xC2DD,   // 6060 - 606F
	0xD761, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6070 - 607F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5F4, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2E4, 0xFFFF, 0xFFFF, 0xC81C, 0xD55C, 0xFFFF, 0xFFFF,   // 6080 - 608F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD68C, 0xFFFF, 0xD328, 0xFFFF, 0xFFFF, 0xFFFF, 0xC1A1, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624,   // 6090 - 609F
	0xC720, 0xFFFF, 0xFFFF, 0xD658, 0xCD1D, 0xFFFF, 0xFFFF, 0xB9AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 60A0 - 60AF
	0xC885, 0xFFFF, 0xBE44, 0xB355, 0xCDCC, 0xFFFF, 0xBBFC, 0xFFFF, 0xACC4, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C4, 0xCC98, 0xFFFF, 0xFFFF,   // 60B0 - 60BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xB3C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 60C0 - 60CF
	0xFFFF, 0xD639, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD640, 0xFFFF, 0xC11D, 0xFFFF, 0xFFFF, 0xC720,   // 60D0 - 60DF
	0xD61C, 0xC545, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 60E0 - 60EF
	0xD0C0, 0xB1CC, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xD669, 0xFFFF, 0xFFFF, 0xC57C, 0xC131, 0xCE21, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 60F0 - 60FF
	0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC74, 0xFFFF, 0xC720, 0xC720, 0xFFFF, 0xFFFF, 0xFFFF, 0xBBFC, 0xD345, 0xC758,   // 6100 - 610F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC545, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xC560, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC10,   // 6110 - 611F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD34, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6120 - 612F
	0xD669, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC3D, 0xFFFF, 0xFFFF, 0xAC1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2E0, 0xFFFF, 0xAC1C, 0xC6D0,   // 6130 - 613F
	0xFFFF, 0xFFFF, 0xC6A9, 0xFFFF, 0xB960, 0xFFFF, 0xFFFF, 0xC740, 0xC790, 0xFFFF, 0xACB8, 0xD0DC, 0xD669, 0xFFFF, 0xFFFF, 0xFFFF,   // 6140 - 614F
	0xFFFF, 0xFFFF, 0xFFFF, 0xD45C, 0xFFFF, 0xBAA8, 0xFFFF, 0xFFFF, 0xCC38, 0xCC38, 0xFFFF, 0xFFFF, 0xFFFF, 0xD2B9, 0xFFFF, 0xD1B5,   // 6150 - 615F
	0xFFFF, 0xFFFF, 0xB9CC, 0xAD00, 0xAC01, 0xFFFF, 0xFFFF, 0xD61C, 0xAC1C, 0xFFFF, 0xFFFF, 0xC885, 0xFFFF, 0xFFFF, 0xB824, 0xFFFF,   // 6160 - 616F
	0xC704, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xAC15, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC99, 0xC695, 0xFFFF,   // 6170 - 617F
	0xFFFF, 0xCD1D, 0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xC99D, 0xFFFF,   // 6180 - 618F
	0xB828, 0xBE59, 0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xD76C, 0xD76C, 0xD0C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6190 - 619F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD84, 0xFFFF, 0xFFFF, 0xB3D9, 0xFFFF, 0xAC8C, 0xFFFF, 0xBBFC, 0xACBD, 0xFFFF, 0xBB34, 0xFFFF,   // 61A0 - 61AF
	0xFFFF, 0xFFFF, 0xD5CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2F4, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC10, 0xFFFF,   // 61B0 - 61BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xADFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC04, 0xD574, 0xC751, 0xC624, 0xBB34, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 61C0 - 61CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 61D0 - 61DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB098, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 61E0 - 61EF
	0xFFFF, 0xFFFF, 0xC9D5, 0xFFFF, 0xFFFF, 0xFFFF, 0xB77C, 0xD68C, 0xD604, 0xFFFF, 0xCC38, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xC758,   // 61F0 - 61FF
	0xB828, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2F9, 0xACFC, 0xFFFF, 0xBB34, 0xFFFF, 0xC220, 0xC218, 0xC735, 0xFFFF,   // 6200 - 620F
	0xC131, 0xC544, 0xACC4, 0xFFFF, 0xFFFF, 0xFFFF, 0xD639, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC99, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADF9,   // 6210 - 621F
	0xFFFF, 0xAC10, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC808, 0xFFFF, 0xFFFF, 0xFFFF, 0xB959, 0xFFFF,   // 6220 - 622F
	0xC804, 0xD76C, 0xFFFF, 0xFFFF, 0xB300, 0xFFFF, 0xD638, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB824, 0xBC29,   // 6230 - 623F
	0xC18C, 0xD3B8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC120, 0xD638, 0xBE44, 0xFFFF, 0xC218, 0xFFFF, 0xC7AC, 0xFFFF, 0xFFFF,   // 6240 - 624F
	0xFFFF, 0xFFFF, 0xFFFF, 0xD0C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6250 - 625F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD84, 0xFFFF,   // 6260 - 626F
	0xFFFF, 0xAE09, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xC561, 0xFFFF, 0xFFFF, 0xC2B9,   // 6270 - 627F
	0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACB0, 0xD30C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6280 - 628F
	0xFFFF, 0xC5B5, 0xC11C, 0xFFFF, 0xFFFF, 0xD22C, 0xFFFF, 0xD56D, 0xC808, 0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6290 - 629F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD53C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 62A0 - 62AF
	0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xC800, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9D0, 0xFFFF, 0xFFFF, 0xC555, 0xCD94, 0xFFFF, 0xFFFF,   // 62B0 - 62BF
	0xFFFF, 0xFFFF, 0xBD88, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB34, 0xB150, 0xB78D, 0xFFFF, 0xFFFF, 0xBC18, 0xBC15, 0xFFFF, 0xB098,   // 62C0 - 62CF
	0xAD34, 0xFFFF, 0xAC70, 0xCC99, 0xBC1C, 0xFFFF, 0xD0C0, 0xC694, 0xAD6C, 0xC878, 0xFFFF, 0xCD08, 0xBC30, 0xFFFF, 0xFFFF, 0xFFFF,   // 62D0 - 62DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD04, 0xC2DD, 0xAE38, 0xC99D,   // 62E0 - 62EF
	0xFFFF, 0xACF5, 0xFFFF, 0xAD8C, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2B5, 0xB098,   // 62F0 - 62FF
	0xFFFF, 0xC9C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C0, 0xFFFF, 0xC548, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6300 - 630F
	0xFFFF, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6310 - 631F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC88C, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4,   // 6320 - 632F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xC5F0, 0xFFFF, 0xB9CC, 0xD611, 0xFFFF,   // 6330 - 633F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC29, 0xFFFF, 0xFFFF, 0xD314, 0xFFFF, 0xFFFF, 0xB0A0,   // 6340 - 634F
	0xC5F0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6350 - 635F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD09, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC70, 0xFFFF,   // 6360 - 636F
	0xFFFF, 0xFFFF, 0xAD8C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA9, 0xFFFF, 0xFFFF, 0xB0A0, 0xB150, 0xFFFF, 0xFFFF, 0xFFFF, 0xC11C,   // 6370 - 637F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC18C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xB3C4, 0xFFFF, 0xFFFF, 0xC7A5, 0xFFFF, 0xFFFF, 0xFFFF,   // 6380 - 638F
	0xFFFF, 0xFFFF, 0xBC30, 0xFFFF, 0xFFFF, 0xFFFF, 0xC561, 0xFFFF, 0xAD74, 0xFFFF, 0xFFFF, 0xAD18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6390 - 639F
	0xB7B5, 0xCC44, 0xD0D0, 0xFFFF, 0xFFFF, 0xC811, 0xFFFF, 0xACF5, 0xCD94, 0xC5C4, 0xC870, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 63A0 - 63AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 63B0 - 63BF
	0xAC04, 0xFFFF, 0xFFFF, 0xFFFF, 0xC720, 0xFFFF, 0xADDC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB18,   // 63C0 - 63CF
	0xC81C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC74D, 0xFFFF, 0xFFFF, 0xFFFF, 0xC591, 0xD658, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 63D0 - 63DF
	0xFFFF, 0xC545, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC8C, 0xD718, 0xFFFF,   // 63E0 - 63EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6D0, 0xFFFF, 0xC57C, 0xC0BD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 63F0 - 63FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC190, 0xFFFF, 0xBC15,   // 6400 - 640F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC18C, 0xFFFF, 0xC694, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF,   // 6410 - 641F
	0xFFFF, 0xFFFF, 0xC9C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC18, 0xD0D1, 0xFFFF, 0xFFFF,   // 6420 - 642F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD734, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC29, 0xFFFF,   // 6430 - 643F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6440 - 644F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC801, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6450 - 645F
	0xCD1D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C0,   // 6460 - 646F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBAA8, 0xBAA8, 0xC811, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6470 - 647F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB85C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6480 - 648F
	0xFFFF, 0xD0F1, 0xC0B4, 0xC694, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB144, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2F9, 0xFFFF,   // 6490 - 649F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA0, 0xBC1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB34, 0xFFFF, 0xD30C, 0xCD2C, 0xFFFF,   // 64A0 - 64AF
	0xCC2C, 0xFFFF, 0xBC15, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 64B0 - 64BF
	0xFFFF, 0xC639, 0xFFFF, 0xFFFF, 0xB85C, 0xCC9C, 0xFFFF, 0xD0DD, 0xFFFF, 0xFFFF, 0xACA9, 0xFFFF, 0xFFFF, 0xC870, 0xACBD, 0xFFFF,   // 64C0 - 64CF
	0xFFFF, 0xFFFF, 0xAE08, 0xFFFF, 0xB2F4, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCBD, 0xFFFF, 0xAC70, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 64D0 - 64DF
	0xFFFF, 0xB300, 0xD0C1, 0xFFFF, 0xFFFF, 0xB78C, 0xCC30, 0xAC70, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC758, 0xFFFF, 0xFFFF, 0xFFFF,   // 64E0 - 64EF
	0xFFFF, 0xFFFF, 0xCC99, 0xFFFF, 0xD655, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD30C, 0xFFFF, 0xFFFF, 0xFFFF, 0xC694, 0xFFFF,   // 64F0 - 64FF
	0xBC18, 0xFFFF, 0xFFFF, 0xFFFF, 0xD130, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6500 - 650F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC12D, 0xFFFF, 0xFFFF,   // 6510 - 651F
	0xFFFF, 0xFFFF, 0xFFFF, 0xB828, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD50, 0xD655, 0xB78C, 0xFFFF, 0xFFFF, 0xC9C0,   // 6520 - 652F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xACE0, 0xC720, 0xAC1C, 0xFFFF, 0xACF5, 0xFFFF, 0xFFFF, 0xBC29, 0xC815,   // 6530 - 653F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE0, 0xFFFF, 0xFFFF, 0xD6A8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC11C, 0xAD50, 0xBBFC,   // 6540 - 654F
	0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xD328, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC3D, 0xFFFF,   // 6550 - 655F
	0xFFFF, 0xFFFF, 0xAC10, 0xC0B0, 0xFFFF, 0xFFFF, 0xB3C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xC591, 0xFFFF, 0xFFFF,   // 6560 - 656F
	0xFFFF, 0xFFFF, 0xACE0, 0xFFFF, 0xC815, 0xC801, 0xFFFF, 0xBD80, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC120, 0xFFFF,   // 6570 - 657F
	0xFFFF, 0xFFFF, 0xB834, 0xD3D0, 0xFFFF, 0xD6A8, 0xFFFF, 0xBB38, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE48, 0xFFFF, 0xFFFF, 0xFFFF,   // 6580 - 658F
	0xBE44, 0xBC18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB450, 0xFFFF, 0xB8CC, 0xFFFF, 0xACE1, 0xC0AC, 0xFFFF, 0xFFFF, 0xC9D0,   // 6590 - 659F
	0xFFFF, 0xC54C, 0xFFFF, 0xFFFF, 0xADFC, 0xCC99, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xC791, 0xCC38, 0xFFFF, 0xFFFF, 0xC0AC,   // 65A0 - 65AF
	0xC2E0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2E8, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xC5B4, 0xC2DC, 0xFFFF, 0xFFFF,   // 65B0 - 65BF
	0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xB824, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC120, 0xC815, 0xFFFF, 0xFFFF, 0xC871,   // 65C0 - 65CF
	0xFFFF, 0xFFFF, 0xB958, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 65D0 - 65DF
	0xBB34, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xC77C, 0xB2E8, 0xFFFF, 0xC9C0, 0xC870, 0xFFFF, 0xFFFF, 0xC21C, 0xC6B1, 0xFFFF, 0xFFFF,   // 65E0 - 65EF
	0xFFFF, 0xD55C, 0xFFFF, 0xFFFF, 0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC655, 0xBBFC, 0xBBFC, 0xB3C8, 0xFFFF, 0xC624,   // 65F0 - 65FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE4, 0xC2B9, 0xFFFF, 0xBC29, 0xD638, 0xFFFF, 0xCC3D, 0xFFFF, 0xBA85, 0xD63C,   // 6600 - 660F
	0xBD84, 0xAE08, 0xFFFF, 0xC5ED, 0xC11D, 0xD754, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCD1, 0xC131,   // 6610 - 661F
	0xC601, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD98, 0xFFFF, 0xB9E4, 0xC791, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC18C, 0xFFFF, 0xC2DC,   // 6620 - 662F
	0xD558, 0xC6B1, 0xFFFF, 0xFFFF, 0xBB18, 0xFFFF, 0xCC3D, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCD1, 0xC559, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6630 - 663F
	0xFFFF, 0xC870, 0xC2DC, 0xD669, 0xD669, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4, 0xFFFF, 0xC9C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xC548,   // 6640 - 664F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC900, 0xFFFF, 0xD604, 0xFFFF, 0xC8FC, 0xD76C, 0xC131,   // 6650 - 665F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xD658, 0xD68C, 0xD638, 0xC2E0, 0xB9CC, 0xFFFF, 0xD0C1, 0xFFFF, 0xFFFF, 0xBCF4, 0xACBD,   // 6660 - 666F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC11D, 0xCCAD, 0xFFFF, 0xC815, 0xADC0, 0xC815, 0xFFFF, 0xC9C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6670 - 667F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6E4, 0xFFFF, 0xFFFF, 0xAC00, 0xD6C8, 0xD718, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC601, 0xFFFF,   // 6680 - 668F
	0xC704, 0xC11C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB09C, 0xC554, 0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBA85, 0xFFFF, 0xFFFF,   // 6690 - 669F
	0xACE0, 0xFFFF, 0xCC3D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7A0, 0xFFFF, 0xFFFF, 0xBAA8, 0xFFFF,   // 66A0 - 66AF
	0xFFFF, 0xFFFF, 0xC7A5, 0xD61C, 0xD3ED, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC12C, 0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xB3C8, 0xFFFF,   // 66B0 - 66BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5FD, 0xFFFF, 0xB825, 0xB2F4, 0xFFFF, 0xD6A8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 66C0 - 66CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC560, 0xFFFF, 0xFFFF, 0xC11C, 0xFFFF, 0xFFFF, 0xC694, 0xD3ED, 0xFFFF, 0xFFFF,   // 66D0 - 66DF
	0xAD11, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD76C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 66E0 - 66EF
	0xC648, 0xFFFF, 0xACE1, 0xC608, 0xACBD, 0xFFFF, 0xFFFF, 0xAC08, 0xC11C, 0xC870, 0xC870, 0xFFFF, 0xB9CC, 0xFFFF, 0xC99D, 0xCCB4,   // 66F0 - 66FF
	0xCD5C, 0xFFFF, 0xFFFF, 0xD68C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6D4, 0xC720, 0xFFFF, 0xBD95, 0xFFFF, 0xBCF5, 0xFFFF, 0xFFFF,   // 6700 - 670F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AD, 0xC9D0, 0xFFFF, 0xB791, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9DD, 0xFFFF, 0xC870, 0xAE30, 0xAE30,   // 6710 - 671F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBABD, 0xB871, 0xBAA9, 0xFFFF, 0xBBF8, 0xB9D0, 0xBCF8, 0xCC30, 0xCD9C, 0xFFFF,   // 6720 - 672F
	0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xBC15, 0xFFFF, 0xD0C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xADA4, 0xFFFF, 0xFFFF, 0xD6C4, 0xFFFF, 0xFFFF,   // 6730 - 673F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC04, 0xFFFF, 0xFFFF, 0xC0BC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9AC, 0xD589,   // 6740 - 674F
	0xC7AC, 0xCD0C, 0xFFFF, 0xD45C, 0xFFFF, 0xFFFF, 0xC7A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB450, 0xFFFF, 0xAE30, 0xC18D,   // 6750 - 675F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD56D, 0xFFFF, 0xBC30,   // 6760 - 676F
	0xAC78, 0xB3D9, 0xFFFF, 0xBB18, 0xFFFF, 0xC800, 0xFFFF, 0xD30C, 0xFFFF, 0xFFFF, 0xFFFF, 0xB274, 0xFFFF, 0xFFFF, 0xC1A1, 0xD310,   // 6770 - 677F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xC655, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xB0A8,   // 6780 - 678F
	0xC11D, 0xFFFF, 0xFFFF, 0xB450, 0xFFFF, 0xCE68, 0xFFFF, 0xB9BC, 0xFFFF, 0xFFFF, 0xB9E4, 0xFFFF, 0xACFC, 0xC9C0, 0xFFFF, 0xFFFF,   // 6790 - 679F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE0,   // 67A0 - 67AF
	0xD3C9, 0xFFFF, 0xFFFF, 0xC9C0, 0xFFFF, 0xFFFF, 0xAC00, 0xAC00, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DC, 0xFFFF,   // 67B0 - 67BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCD1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC31,   // 67C0 - 67CF
	0xBAA8, 0xAC10, 0xCE60, 0xC5FC, 0xC720, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC720, 0xFFFF, 0xFFFF, 0xD0C1, 0xFFFF, 0xFFFF,   // 67D0 - 67DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xAC04, 0xFFFF, 0xFFFF, 0xAC00,   // 67E0 - 67EF
	0xB0B4, 0xC8FC, 0xFFFF, 0xB958, 0xC2DC, 0xCC45, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF,   // 67F0 - 67FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6800 - 680F
	0xFFFF, 0xFFFF, 0xC21C, 0xC804, 0xFFFF, 0xFFFF, 0xC11C, 0xB960, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6810 - 681F
	0xFFFF, 0xAD50, 0xBC31, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B1,   // 6820 - 682F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD575, 0xADFC, 0xFFFF, 0xFFFF, 0xACA9, 0xC7AC, 0xFFFF, 0xFFFF,   // 6830 - 683F
	0xAC78, 0xD56D, 0xACC4, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC548, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C8, 0xFFFF,   // 6840 - 684F
	0xB3D9, 0xC0C1, 0xFFFF, 0xD658, 0xAE38, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6850 - 685F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4, 0xFFFF, 0xFFFF,   // 6860 - 686F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD1B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC04,   // 6870 - 687F
	0xFFFF, 0xB7C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9E4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE1,   // 6880 - 688F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC7AC, 0xCE58, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xFFFF, 0xD6A8,   // 6890 - 689F
	0xFFFF, 0xC644, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xB9AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xC81C,   // 68A0 - 68AF
	0xACC4, 0xACE4, 0xFFFF, 0xC18C, 0xFFFF, 0xBC94, 0xBBF8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 68B0 - 68BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xBCD1, 0xFFFF, 0xFFFF, 0xFFFF, 0xBA74, 0xFFFF, 0xAE30, 0xFFFF, 0xACE4, 0xFFFF, 0xFFFF,   // 68C0 - 68CF
	0xFFFF, 0xFFFF, 0xBD09, 0xFFFF, 0xFFFF, 0xC885, 0xFFFF, 0xC870, 0xADF9, 0xFFFF, 0xBD95, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3D9,   // 68D0 - 68DF
	0xB2F9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC794, 0xACC4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0BC, 0xFFFF,   // 68E0 - 68EF
	0xFFFF, 0xFFFF, 0xC11C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C4, 0xAD00, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 68F0 - 68FF
	0xC644, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC758, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DD, 0xCD94, 0xFFFF,   // 6900 - 690F
	0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6910 - 691F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBA85, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6920 - 692F
	0xC57C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5F0, 0xFFFF, 0xCD98,   // 6930 - 693F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6940 - 694F
	0xFFFF, 0xFFFF, 0xFFFF, 0xD48D, 0xC124, 0xD0C0, 0xFFFF, 0xAC74, 0xFFFF, 0xBB34, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xB989, 0xFFFF,   // 6950 - 695F
	0xB0A8, 0xC720, 0xC720, 0xBBF8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF, 0xC999, 0xFFFF, 0xC5C5, 0xC800, 0xC21C,   // 6960 - 696F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADF9, 0xFFFF, 0xD574, 0xCD94, 0xC601, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6970 - 697F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6980 - 698F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF,   // 6990 - 699F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD669, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC601, 0xFFFF,   // 69A0 - 69AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB958, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0D1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 69B0 - 69BF
	0xFFFF, 0xACE0, 0xFFFF, 0xBC18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xD1F4, 0xCC3D, 0xFFFF, 0xFFFF,   // 69C0 - 69CF
	0xAD34, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 69D0 - 69DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACFD, 0xFFFF, 0xAC1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 69E0 - 69EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADDC, 0xFFFF, 0xC870, 0xFFFF, 0xADFC,   // 69F0 - 69FF
	0xFFFF, 0xFFFF, 0xC545, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC88, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6A00 - 6A0F
	0xFFFF, 0xB7C9, 0xFFFF, 0xB8E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xC800, 0xFFFF, 0xD45C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xC7A5,   // 6A10 - 6A1F
	0xFFFF, 0xBAA8, 0xFFFF, 0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6A20 - 6A2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xBC15, 0xC218, 0xD654, 0xFFFF, 0xFFFF, 0xC900, 0xFFFF, 0xFFFF,   // 6A30 - 6A3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC10, 0xFFFF, 0xFFFF, 0xFFFF, 0xC694, 0xFFFF, 0xFFFF, 0xAD50, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6A40 - 6A4F
	0xFFFF, 0xFFFF, 0xC6B4, 0xC21C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADE4, 0xB4F1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30,   // 6A50 - 6A5F
	0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6A1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6A60 - 6A6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6A70 - 6A7F
	0xB2E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xACA9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5B5, 0xAE08, 0xFFFF,   // 6A80 - 6A8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD68C, 0xFFFF, 0xFFFF, 0xFFFF,   // 6A90 - 6A9F
	0xFFFF, 0xFFFF, 0xAC80, 0xC7A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6AA0 - 6AAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xBE48, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD568, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6AB0 - 6ABF
	0xFFFF, 0xFFFF, 0xB3C4, 0xADA4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6AC0 - 6ACF
	0xFFFF, 0xFFFF, 0xFFFF, 0xB85C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB824, 0xC990, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6AD0 - 6ADF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6AE0 - 6AEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD5CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC575, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6AF0 - 6AFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB780, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD8C, 0xFFFF, 0xC7A5, 0xFFFF, 0xFFFF, 0xFFFF,   // 6B00 - 6B0F
	0xFFFF, 0xFFFF, 0xB780, 0xFFFF, 0xFFFF, 0xFFFF, 0xB78C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6B10 - 6B1F
	0xD760, 0xCC28, 0xFFFF, 0xD754, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6B20 - 6B2F
	0xFFFF, 0xFFFF, 0xC695, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xD760, 0xAD00, 0xFFFF,   // 6B30 - 6B3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD760, 0xD5D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xD0C4, 0xFFFF,   // 6B40 - 6B4F
	0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5EC,   // 6B50 - 6B5F
	0xFFFF, 0xD658, 0xC9C0, 0xC815, 0xCC28, 0xBCF4, 0xBB34, 0xFFFF, 0xFFFF, 0xFFFF, 0xC65C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6B60 - 6B6F
	0xFFFF, 0xFFFF, 0xC138, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB825, 0xADC0, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xBAB0,   // 6B70 - 6B7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC559, 0xC9C4, 0xFFFF, 0xD0DC, 0xFFFF, 0xFFFF, 0xC21C, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6B80 - 6B8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DD, 0xFFFF, 0xC794, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B4, 0xFFFF,   // 6B90 - 6B9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB834, 0xBE48,   // 6BA0 - 6BAF
	0xFFFF, 0xFFFF, 0xC12C, 0xFFFF, 0xFFFF, 0xB2E8, 0xFFFF, 0xC740, 0xFFFF, 0xFFFF, 0xC0B4, 0xFFFF, 0xAC01, 0xFFFF, 0xFFFF, 0xC804,   // 6BB0 - 6BBF
	0xFFFF, 0xD6FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xC758, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB34, 0xFFFF, 0xBAA8, 0xFFFF, 0xB9E4,   // 6BC0 - 6BCF
	0xFFFF, 0xFFFF, 0xB3C5, 0xC721, 0xBE44, 0xFFFF, 0xBE44, 0xBE44, 0xBE44, 0xFFFF, 0xFFFF, 0xBAA8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6BD0 - 6BDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF,   // 6BE0 - 6BEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6BF0 - 6BFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC528,   // 6C00 - 6C0F
	0xFFFF, 0xBBFC, 0xFFFF, 0xB9F9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6C10 - 6C1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6C20 - 6C2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xBE59, 0xC601, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC94, 0xFFFF,   // 6C30 - 6C3F
	0xC815, 0xC999, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC94, 0xFFFF,   // 6C40 - 6C4F
	0xC11D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0B0, 0xFFFF, 0xD55C, 0xFFFF, 0xFFFF, 0xC624, 0xFFFF, 0xFFFF, 0xC5EC, 0xD64D, 0xAC15,   // 6C50 - 6C5F
	0xC9C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE8, 0xFFFF, 0xC655, 0xFFFF, 0xFFFF, 0xC608, 0xFFFF, 0xFFFF,   // 6C60 - 6C6F
	0xD0DC, 0xFFFF, 0xAE09, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB38, 0xFFFF, 0xFFFF, 0xFFFF, 0xACB0, 0xFFFF, 0xFFFF, 0xAE30, 0xBD84, 0xFFFF,   // 6C70 - 6C7F
	0xFFFF, 0xC2EC, 0xAE30, 0xC625, 0xFFFF, 0xC6D0, 0xD56D, 0xC5F0, 0xCE68, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C8, 0xFFFF, 0xFFFF, 0xFFFF,   // 6C80 - 6C8F
	0xBAA9, 0xFFFF, 0xBAB0, 0xB2F5, 0xBA74, 0xBB3C, 0xCDA9, 0xFFFF, 0xFFFF, 0xC0AC, 0xC9C0, 0xD328, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6C90 - 6C9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9D0, 0xFFFF, 0xFFFF, 0xC800, 0xFFFF,   // 6CA0 - 6CAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xD558, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xC720, 0xFFFF, 0xCE58, 0xC18C, 0xACE0, 0xCCA8, 0xC5F0,   // 6CB0 - 6CBF
	0xFFFF, 0xD669, 0xD615, 0xFFFF, 0xC124, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC9C, 0xBC15, 0xFFFF, 0xD544, 0xFFFF, 0xFFFF, 0xFFFF,   // 6CC0 - 6CCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xD64D, 0xFFFF, 0xBC95, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC94, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6CD0 - 6CDF
	0xFFFF, 0xD3EC, 0xD30C, 0xC74D, 0xFFFF, 0xB2C8, 0xFFFF, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xD604, 0xFFFF, 0xFFFF, 0xBC18, 0xBBFC,   // 6CE0 - 6CEF
	0xD0DC, 0xFFFF, 0xFFFF, 0xC601, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6CF0 - 6CFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC591, 0xB82C, 0xFFFF, 0xFFFF, 0xFFFF,   // 6D00 - 6D0F
	0xFFFF, 0xBCF4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC138, 0xFFFF, 0xC218, 0xFFFF, 0xB77D, 0xFFFF, 0xFFFF, 0xB3D9, 0xFFFF,   // 6D10 - 6D1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4, 0xFFFF, 0xC720, 0xFFFF, 0xC124, 0xD64D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6D20 - 6D2F
	0xFFFF, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xC21C, 0xD749, 0xFFFF, 0xAD11, 0xC6D0, 0xFFFF, 0xD65C, 0xFFFF, 0xD761, 0xD30C, 0xFFFF,   // 6D30 - 6D3F
	0xFFFF, 0xB958, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6D40 - 6D4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC808, 0xC900, 0xFFFF, 0xBE48, 0xFFFF, 0xFFFF, 0xFFFF,   // 6D50 - 6D5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC644, 0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF, 0xD638, 0xB791, 0xFFFF, 0xB9AC, 0xFFFF, 0xBD80, 0xFFFF,   // 6D60 - 6D6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC695, 0xFFFF, 0xFFFF, 0xD574, 0xCE68, 0xD611, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD328,   // 6D70 - 6D7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5F4, 0xFFFF, 0xACBD, 0xC18C, 0xC12D, 0xFFFF, 0xFFFF, 0xC6A9, 0xD6A8, 0xC5F0, 0xFFFF,   // 6D80 - 6D8F
	0xFFFF, 0xC18D, 0xFFFF, 0xC5F0, 0xFFFF, 0xCCB4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6D90 - 6D9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC560,   // 6DA0 - 6DAF
	0xFFFF, 0xFFFF, 0xC561, 0xFFFF, 0xFFFF, 0xD568, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6DB0 - 6DBF
	0xC815, 0xFFFF, 0xFFFF, 0xAD8C, 0xCE58, 0xC11D, 0xD6A8, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9BC, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638,   // 6DC0 - 6DCF
	0xFFFF, 0xC219, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C4, 0xC885, 0xB8E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xC1A1, 0xFFFF,   // 6DD0 - 6DDF
	0xFFFF, 0xB2F4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xB95C, 0xC74C, 0xFFFF, 0xFFFF, 0xD68C, 0xFFFF,   // 6DE0 - 6DEF
	0xFFFF, 0xC2EC, 0xFFFF, 0xC21C, 0xFFFF, 0xC5F0, 0xFFFF, 0xD63C, 0xCCAD, 0xC5C4, 0xCC9C, 0xCCA8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6DF0 - 6DFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6E00 - 6E0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0BC, 0xFFFF, 0xD658, 0xC800, 0xAC10, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815,   // 6E10 - 6E1F
	0xAC70, 0xB3C4, 0xFFFF, 0xC0AC, 0xBC1C, 0xC545, 0xC640, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC124, 0xCE21, 0xC704, 0xFFFF, 0xD56D,   // 6E20 - 6E2F
	0xFFFF, 0xFFFF, 0xC120, 0xFFFF, 0xAC08, 0xFFFF, 0xC601, 0xFFFF, 0xC720, 0xFFFF, 0xBB18, 0xFFFF, 0xBBF8, 0xC7AC, 0xD63C, 0xFFFF,   // 6E30 - 6E3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xBC30, 0xBBF8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xB2E8, 0xFFFF, 0xFFFF,   // 6E40 - 6E4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xB2F4, 0xC2DD, 0xFFFF, 0xC815, 0xD669,   // 6E50 - 6E5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xFFFF, 0xFFFF, 0xC778, 0xD0D5,   // 6E60 - 6E6F
	0xFFFF, 0xFFFF, 0xC6D0, 0xB0A8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCF4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6E70 - 6E7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6E80 - 6E8F
	0xC6D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC900, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB958, 0xAD6C, 0xFFFF, 0xBA85,   // 6E90 - 6E9F
	0xFFFF, 0xFFFF, 0xC77C, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACC4, 0xC628, 0xFFFF, 0xFFFF, 0xFFFF, 0xC18C,   // 6EA0 - 6EAF
	0xFFFF, 0xC9C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6EB0 - 6EBF
	0xFFFF, 0xFFFF, 0xBC29, 0xFFFF, 0xCC3D, 0xBA78, 0xFFFF, 0xFFFF, 0xFFFF, 0xD669, 0xFFFF, 0xC790, 0xCC99, 0xFFFF, 0xD615, 0xFFFF,   // 6EC0 - 6ECF
	0xFFFF, 0xD65C, 0xFFFF, 0xC7AC, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6ED0 - 6EDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCB4,   // 6EE0 - 6EEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC801, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE4, 0xB9CC,   // 6EF0 - 6EFF
	0xFFFF, 0xC5B4, 0xD45C, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE60, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8E8,   // 6F00 - 6F0F
	0xFFFF, 0xAC1C, 0xFFFF, 0xFFFF, 0xC5F0, 0xC870, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6F10 - 6F1F
	0xB9C9, 0xFFFF, 0xD55C, 0xB828, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9CC, 0xC9C0, 0xFFFF, 0xFFFF, 0xFFFF,   // 6F20 - 6F2F
	0xFFFF, 0xC218, 0xCC3D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC810, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7A5,   // 6F30 - 6F3F
	0xFFFF, 0xC601, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6F40 - 6F4F
	0xFFFF, 0xBC1C, 0xFFFF, 0xFFFF, 0xACB0, 0xFFFF, 0xFFFF, 0xC9D1, 0xBC18, 0xFFFF, 0xC219, 0xC7A0, 0xFFFF, 0xFFFF, 0xB85C, 0xC11D,   // 6F50 - 6F5F
	0xFFFF, 0xFFFF, 0xD669, 0xFFFF, 0xC724, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2F4, 0xC870, 0xFFFF,   // 6F60 - 6F6F
	0xADA4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC794, 0xFFFF, 0xB3D9, 0xBCF4, 0xB9B0, 0xFFFF,   // 6F70 - 6F7F
	0xFFFF, 0xC0BD, 0xFFFF, 0xFFFF, 0xC9D5, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8FC, 0xD33D, 0xFFFF,   // 6F80 - 6F8F
	0xC6B4, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF, 0xFFFF, 0xAC04, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6F90 - 6F9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xD55C, 0xD0DD, 0xFFFF, 0xFFFF, 0xB840, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD68C, 0xCC2C,   // 6FA0 - 6FAF
	0xFFFF, 0xC804, 0xFFFF, 0xC624, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2F4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2EC, 0xFFFF,   // 6FB0 - 6FBF
	0xACA9, 0xD0C1, 0xB834, 0xB18D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC608, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 6FC0 - 6FCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC601, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C,   // 6FD0 - 6FDF
	0xD638, 0xC720, 0xFFFF, 0xFFFF, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF, 0xB78C, 0xC900, 0xFFFF, 0xFFFF, 0xD0C1,   // 6FE0 - 6FEF
	0xFFFF, 0xBE48, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB824, 0xFFFF,   // 6FF0 - 6FFF
	0xFFFF, 0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xD615, 0xB3C5, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xC2EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xB958,   // 7000 - 700F
	0xFFFF, 0xD3ED, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE48, 0xFFFF, 0xFFFF, 0xB85C, 0xFFFF, 0xD55C, 0xC601, 0xC735, 0xB825, 0xC815, 0xC18C,   // 7010 - 701F
	0xFFFF, 0xFFFF, 0xFFFF, 0xD574, 0xFFFF, 0xFFFF, 0xFFFF, 0xB871, 0xB8B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC601,   // 7020 - 702F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC775, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB780, 0xFFFF,   // 7030 - 703F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD00, 0xFFFF, 0xFFFF, 0xFFFF,   // 7040 - 704F
	0xD615, 0xC1C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF, 0xFFFF,   // 7050 - 705F
	0xFFFF, 0xFFFF, 0xFFFF, 0xB9CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD654, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7060 - 706F
	0xD68C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xC791, 0xC7AC, 0xFFFF, 0xFFFF,   // 7070 - 707F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCDE8, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5FC, 0xFFFF,   // 7080 - 708F
	0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD754, 0xC790, 0xAD11, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7090 - 709F
	0xFFFF, 0xC815, 0xFFFF, 0xFFFF, 0xC18C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD604, 0xAC70, 0xD0C4, 0xFFFF, 0xD615,   // 70A0 - 70AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xBCD1, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8FC, 0xC791, 0xC810, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 70B0 - 70BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB82C, 0xFFFF, 0xFFFF, 0xD734, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624,   // 70C0 - 70CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD64D, 0xB77D, 0xFFFF, 0xFFFF, 0xFFFF, 0xC99D, 0xFFFF, 0xC5F0,   // 70D0 - 70DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 70E0 - 70EF
	0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD33D, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD09, 0xFFFF, 0xFFFF,   // 70F0 - 70FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5B8, 0xFFFF, 0xFFFF, 0xC900, 0xFFFF, 0xFFFF, 0xFFFF,   // 7100 - 710F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC30, 0xBD84, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C8, 0xFFFF,   // 7110 - 711F
	0xFFFF, 0xBB34, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7120 - 712F
	0xC5FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5F0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7130 - 713F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD718, 0xFFFF, 0xB828, 0xD6E4, 0xFFFF, 0xD669, 0xFFFF, 0xC804, 0xFFFF,   // 7140 - 714F
	0xC601, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB09C, 0xFFFF, 0xFFFF, 0xC5F0, 0xFFFF, 0xFFFF, 0xC6B1, 0xFFFF, 0xC0B4, 0xFFFF,   // 7150 - 715F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9E4, 0xD658, 0xD6C4, 0xC870, 0xFFFF, 0xBC88, 0xFFFF, 0xFFFF, 0xC591, 0xFFFF, 0xC790, 0xFFFF,   // 7160 - 716F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC120, 0xFFFF, 0xFFFF,   // 7170 - 717F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B4, 0xC6C5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6C8,   // 7180 - 718F
	0xFFFF, 0xFFFF, 0xD615, 0xFFFF, 0xC6A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD76C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC219,   // 7190 - 719F
	0xFFFF, 0xFFFF, 0xBD09, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xFFFF, 0xFFFF, 0xFFFF,   // 71A0 - 71AF
	0xFFFF, 0xC5F4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD76C, 0xD76C, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE58, 0xFFFF,   // 71B0 - 71BF
	0xFFFF, 0xC5FD, 0xFFFF, 0xC5F0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB4F1, 0xB3C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8CC, 0xFFFF,   // 71C0 - 71CF
	0xB9B0, 0xFFFF, 0xC18C, 0xFFFF, 0xBC88, 0xC5F0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC601,   // 71D0 - 71DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xCC2C, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD09, 0xC12D, 0xFFFF,   // 71E0 - 71EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6C8, 0xC2E0, 0xFFFF, 0xB3C4, 0xC694,   // 71F0 - 71FF
	0xD601, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3ED, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7200 - 720F
	0xB85C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB780, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7210 - 721F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xFFFF, 0xD30C, 0xC7C1, 0xFFFF, 0xFFFF,   // 7220 - 722F
	0xC6D0, 0xFFFF, 0xC704, 0xFFFF, 0xFFFF, 0xC791, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xC57C, 0xD6A8, 0xFFFF, 0xC0C1, 0xC774, 0xFFFF,   // 7230 - 723F
	0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7A5, 0xD3B8, 0xD310, 0xFFFF, 0xFFFF, 0xFFFF, 0xD328, 0xFFFF, 0xFFFF, 0xFFFF,   // 7240 - 724F
	0xFFFF, 0xFFFF, 0xCCA9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C5, 0xC544, 0xFFFF, 0xC6B0, 0xFFFF, 0xBE48, 0xFFFF, 0xBAA8,   // 7250 - 725F
	0xFFFF, 0xBAA8, 0xB8B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBAA9, 0xFFFF, 0xBB3C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7260 - 726F
	0xFFFF, 0xFFFF, 0xC0DD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD2B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xACAC, 0xFFFF, 0xFFFF,   // 7270 - 727F
	0xC11C, 0xB9AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7280 - 728F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7290 - 729F
	0xFFFF, 0xFFFF, 0xB3C5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD76C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACAC, 0xFFFF, 0xFFFF, 0xBC94,   // 72A0 - 72AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 72B0 - 72BF
	0xC0C1, 0xFFFF, 0xAD11, 0xFFFF, 0xC801, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC555, 0xFFFF,   // 72C0 - 72CF
	0xD638, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xC800, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 72D0 - 72DF
	0xFFFF, 0xAD50, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 72E0 - 72EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9AC, 0xD611, 0xFFFF, 0xFFFF, 0xB791, 0xD328, 0xFFFF, 0xFFFF,   // 72F0 - 72FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC608, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7300 - 730F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC3D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9F9, 0xC2DC, 0xC878, 0xFFFF, 0xFFFF,   // 7310 - 731F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC678, 0xFFFF, 0xFFFF, 0xFFFF, 0xC131, 0xC800, 0xBB18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7320 - 732F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC720, 0xC720, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD65C, 0xC6D0,   // 7330 - 733F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC625, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7340 - 734F
	0xC7A5, 0xFFFF, 0xC624, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD90, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7350 - 735F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C5, 0xFFFF, 0xD68C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7360 - 736F
	0xC601, 0xFFFF, 0xD68D, 0xFFFF, 0xFFFF, 0xB835, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xB2EC, 0xD5CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7370 - 737F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD604, 0xFFFF, 0xC790, 0xC194, 0xFFFF, 0xC625, 0xFFFF, 0xC655, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF,   // 7380 - 738F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC9C, 0xFFFF, 0xAD6C, 0xC6B0, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBBFC,   // 7390 - 739F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC724, 0xFFFF, 0xC644, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE48, 0xFFFF, 0xFFFF,   // 73A0 - 73AF
	0xFFFF, 0xFFFF, 0xB839, 0xB300, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD604, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 73B0 - 73BF
	0xBC15, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBBFC, 0xC0B0, 0xFFFF, 0xD544, 0xC9C4, 0xFFFF, 0xAC01,   // 73C0 - 73CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD11, 0xFFFF, 0xFFFF, 0xACF5, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6C4, 0xB77D, 0xFFFF,   // 73D0 - 73DF
	0xC8FC, 0xFFFF, 0xFFFF, 0xC21C, 0xBCF4, 0xC774, 0xD5A5, 0xFFFF, 0xFFFF, 0xD615, 0xADDC, 0xFFFF, 0xFFFF, 0xBC18, 0xFFFF, 0xFFFF,   // 73E0 - 73EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB34, 0xFFFF, 0xC131, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xD604, 0xFFFF,   // 73F0 - 73FF
	0xFFFF, 0xC120, 0xFFFF, 0xAD6C, 0xFFFF, 0xB791, 0xB9AC, 0xC218, 0xFFFF, 0xB958, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7400 - 740F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC644, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE68, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7410 - 741F
	0xC804, 0xC219, 0xD0C1, 0xFFFF, 0xFFFF, 0xD638, 0xAE30, 0xFFFF, 0xACE4, 0xFFFF, 0xAE30, 0xBD09, 0xC644, 0xFFFF, 0xC885, 0xAD00,   // 7420 - 742F
	0xC5FC, 0xFFFF, 0xFFFF, 0xB9BC, 0xAE08, 0xBE44, 0xD30C, 0xFFFF, 0xD0C1, 0xFFFF, 0xBC95, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD63C,   // 7430 - 743F
	0xC6B0, 0xBAA8, 0xFFFF, 0xCD98, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC704, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7440 - 744F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD558, 0xFFFF, 0xC6D0, 0xFFFF, 0xB178, 0xD638, 0xC601, 0xC720, 0xFFFF, 0xC11C, 0xC2AC,   // 7450 - 745F
	0xB958, 0xFFFF, 0xC6A9, 0xFFFF, 0xC694, 0xC628, 0xFFFF, 0xFFFF, 0xC9C4, 0xD615, 0xB9C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB791,   // 7460 - 746F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADFC, 0xFFFF,   // 7470 - 747F
	0xFFFF, 0xFFFF, 0xAE30, 0xB9AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xC120, 0xFFFF, 0xB828, 0xFFFF, 0xC7A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7480 - 748F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xD669, 0xFFFF, 0xBC15, 0xACBD,   // 7490 - 749F
	0xFFFF, 0xC9C4, 0xFFFF, 0xAE30, 0xFFFF, 0xACBD, 0xFFFF, 0xBCBD, 0xCC2C, 0xFFFF, 0xC870, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 74A0 - 74AF
	0xD658, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xC5EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xC219, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0C8, 0xFFFF, 0xC120,   // 74B0 - 74BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB871,   // 74C0 - 74CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC601, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD00, 0xFFFF, 0xCC2C, 0xFFFF, 0xACFC, 0xFFFF, 0xFFFF, 0xFFFF,   // 74D0 - 74DF
	0xD638, 0xFFFF, 0xD45C, 0xD310, 0xFFFF, 0xFFFF, 0xC640, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC639, 0xFFFF,   // 74E0 - 74EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC790, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 74F0 - 74FF
	0xFFFF, 0xBCD1, 0xFFFF, 0xFFFF, 0xACAC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7500 - 750F
	0xFFFF, 0xC99D, 0xFFFF, 0xFFFF, 0xFFFF, 0xC639, 0xFFFF, 0xFFFF, 0xAC10, 0xFFFF, 0xC2EC, 0xCCA8, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0DD,   // 7510 - 751F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC0B0, 0xFFFF, 0xC0DD, 0xC18C, 0xFFFF, 0xC6A9, 0xFFFF, 0xFFFF, 0xBCF4, 0xC6A9, 0xFFFF, 0xFFFF, 0xFFFF,   // 7520 - 752F
	0xC804, 0xC720, 0xAC11, 0xC2E0, 0xFFFF, 0xFFFF, 0xFFFF, 0xB0A8, 0xC804, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7530 - 753F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACC4, 0xFFFF, 0xFFFF, 0xC678,   // 7540 - 754F
	0xFFFF, 0xC804, 0xFFFF, 0xB2F5, 0xBC18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB958, 0xFFFF, 0xC9C4, 0xCD95, 0xBB34, 0xFFFF, 0xFFFF,   // 7550 - 755F
	0xFFFF, 0xFFFF, 0xD544, 0xFFFF, 0xFFFF, 0xB7B5, 0xD734, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC88, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC900,   // 7560 - 756F
	0xC774, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD654, 0xB2F9, 0xFFFF, 0xAE30, 0xFFFF, 0xAC15, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30,   // 7570 - 757F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC15, 0xC8FC, 0xFFFF, 0xFFFF, 0xCCA9, 0xD544, 0xFFFF, 0xFFFF, 0xC18C, 0xC18C,   // 7580 - 758F
	0xFFFF, 0xC758, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0B0, 0xFFFF, 0xFFFF,   // 7590 - 759F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5ED, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 75A0 - 75AF
	0xFFFF, 0xD3EC, 0xD53C, 0xAC10, 0xFFFF, 0xC790, 0xFFFF, 0xFFFF, 0xB2EC, 0xC9C4, 0xFFFF, 0xFFFF, 0xB3D9, 0xC800, 0xC9C8, 0xFFFF,   // 75B0 - 75BF
	0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xBCD1, 0xFFFF, 0xC99D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC774, 0xFFFF, 0xFFFF,   // 75C0 - 75CF
	0xFFFF, 0xFFFF, 0xC591, 0xFFFF, 0xCE58, 0xD754, 0xFFFF, 0xFFFF, 0xB450, 0xACBD, 0xFFFF, 0xD1B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 75D0 - 75DF
	0xFFFF, 0xFFFF, 0xB9AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 75E0 - 75EF
	0xB2F4, 0xFFFF, 0xB9C8, 0xFFFF, 0xCE58, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF,   // 75F0 - 75FF
	0xC5B4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC591, 0xFFFF, 0xFFFF,   // 7600 - 760F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC18C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC628,   // 7610 - 761F
	0xCC99, 0xCC3D, 0xBC18, 0xFFFF, 0xB958, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7620 - 762F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7630 - 763F
	0xFFFF, 0xFFFF, 0xB8CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC554, 0xFFFF, 0xAC04, 0xFFFF,   // 7640 - 764F
	0xFFFF, 0xFFFF, 0xC720, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7650 - 765F
	0xFFFF, 0xCE58, 0xFFFF, 0xFFFF, 0xC808, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB77C, 0xFFFF, 0xFFFF, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF,   // 7660 - 766F
	0xC639, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACC4, 0xFFFF, 0xFFFF, 0xB4F1, 0xBC1C, 0xBC31, 0xBC31, 0xFFFF,   // 7670 - 767F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC801, 0xFFFF, 0xAC1C, 0xD669, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD50, 0xFFFF,   // 7680 - 768F
	0xACE0, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7690 - 769F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD53C, 0xFFFF,   // 76A0 - 76AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBA85,   // 76B0 - 76BF
	0xFFFF, 0xFFFF, 0xC6B0, 0xBC30, 0xFFFF, 0xFFFF, 0xBD84, 0xFFFF, 0xC601, 0xFFFF, 0xC775, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 76C0 - 76CF
	0xFFFF, 0xFFFF, 0xD569, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC131, 0xB3C4, 0xFFFF, 0xC794, 0xB9F9,   // 76D0 - 76DF
	0xFFFF, 0xC9C4, 0xFFFF, 0xAC10, 0xBC18, 0xFFFF, 0xFFFF, 0xB85C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBAA9, 0xFFFF,   // 76E0 - 76EF
	0xFFFF, 0xFFFF, 0xB9F9, 0xFFFF, 0xC9C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC18, 0xFFFF, 0xC21C, 0xFFFF,   // 76F0 - 76FF
	0xFFFF, 0xC131, 0xFFFF, 0xFFFF, 0xBA74, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0D0, 0xBBF8, 0xFFFF, 0xAC04, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7700 - 770F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4, 0xFFFF,   // 7710 - 771F
	0xBA74, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD604, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7720 - 772F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD8C, 0xBAA8, 0xFFFF, 0xC870, 0xFFFF, 0xC548, 0xFFFF, 0xFFFF, 0xFFFF,   // 7730 - 773F
	0xCC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD604, 0xFFFF, 0xFFFF,   // 7740 - 774F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7750 - 775F
	0xFFFF, 0xC218, 0xFFFF, 0xB3C5, 0xFFFF, 0xFFFF, 0xBAA9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7760 - 776F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE0, 0xC608,   // 7770 - 777F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7780 - 778F
	0xFFFF, 0xBA85, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9CC, 0xFFFF,   // 7790 - 779F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCC4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC21C, 0xB8CC, 0xFFFF, 0xFFFF,   // 77A0 - 77AF
	0xAC10, 0xFFFF, 0xFFFF, 0xB3D9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA8, 0xAC80, 0xFFFF, 0xFFFF, 0xAD6C,   // 77B0 - 77BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 77C0 - 77CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD09, 0xFFFF, 0xFFFF, 0xFFFF, 0xBAA8, 0xAE0D, 0xFFFF, 0xFFFF, 0xFFFF,   // 77D0 - 77DF
	0xFFFF, 0xFFFF, 0xC2DC, 0xC758, 0xFFFF, 0xC9C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2E8, 0xC65C, 0xAD50,   // 77E0 - 77EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC11D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 77F0 - 77FF
	0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7800 - 780F
	0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7810 - 781F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C0, 0xCC44, 0xCE68, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9BD, 0xFFFF, 0xFFFF, 0xFFFF,   // 7820 - 782F
	0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xD30C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7830 - 783F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADDC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5F0,   // 7840 - 784F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF,   // 7850 - 785F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB958, 0xACBD, 0xFFFF, 0xFFFF, 0xC5F0,   // 7860 - 786F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD95, 0xFFFF, 0xFFFF, 0xFFFF,   // 7870 - 787F
	0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB85D, 0xC560, 0xC1C4, 0xFFFF,   // 7880 - 788F
	0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC644, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7890 - 789F
	0xFFFF, 0xFFFF, 0xFFFF, 0xAC08, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCBD, 0xFFFF, 0xC11D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 78A0 - 78AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD655, 0xD655, 0xB9C8, 0xFFFF, 0xFFFF, 0xFFFF,   // 78B0 - 78BF
	0xFFFF, 0xC790, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8B0, 0xCC28, 0xFFFF, 0xFFFF, 0xACC4, 0xFFFF,   // 78C0 - 78CF
	0xBC18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 78D0 - 78DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xAE30,   // 78E0 - 78EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC04, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 78F0 - 78FF
	0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD08, 0xFFFF,   // 7900 - 790F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7910 - 791F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB824, 0xB825, 0xBC18, 0xFFFF, 0xFFFF, 0xFFFF,   // 7920 - 792F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF,   // 7930 - 793F
	0xC0AC, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xAE30, 0xC9C0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7940 - 794F
	0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xC9C0, 0xFFFF, 0xFFFF, 0xC870, 0xAC70, 0xD638, 0xCD95, 0xC2E0, 0xFFFF,   // 7950 - 795F
	0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xD45C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C, 0xFFFF, 0xFFFF,   // 7960 - 796F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB85D,   // 7970 - 797F
	0xFFFF, 0xAE08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD654, 0xC815, 0xBCF5,   // 7980 - 798F
	0xFFFF, 0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7990 - 799F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5B4, 0xD76C, 0xFFFF, 0xFFFF, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF, 0xB840, 0xFFFF,   // 79A0 - 79AF
	0xFFFF, 0xB3C4, 0xFFFF, 0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE08, 0xD654, 0xB3C5,   // 79B0 - 79BF
	0xC218, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCD1, 0xB144, 0xCD94, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 79C0 - 79CF
	0xFFFF, 0xACFC, 0xCD08, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870,   // 79D0 - 79DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE6D, 0xFFFF, 0xC9C4, 0xC559, 0xFFFF, 0xC9C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 79E0 - 79EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC774, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 79F0 - 79FF
	0xD76C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC138, 0xFFFF, 0xFFFF, 0xAC04, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF,   // 7A00 - 7A0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC784, 0xFFFF, 0xFFFF, 0xD328, 0xFFFF, 0xC9C1, 0xCE58, 0xFFFF, 0xB989, 0xFFFF, 0xFFFF, 0xD488,   // 7A10 - 7A1F
	0xC870, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC885, 0xFFFF,   // 7A20 - 7A2F
	0xFFFF, 0xCE6D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B1, 0xC9C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C4, 0xAC00, 0xACC4, 0xFFFF, 0xACE0,   // 7A30 - 7A3F
	0xACE1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBAA9, 0xFFFF, 0xFFFF, 0xCE58, 0xFFFF, 0xFFFF, 0xFFFF, 0xC801, 0xC601, 0xFFFF,   // 7A40 - 7A4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7A50 - 7A5F
	0xFFFF, 0xC0C9, 0xC608, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC628, 0xFFFF, 0xD655, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7A60 - 7A6F
	0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xD608, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xAD81, 0xACF5, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xCC9C,   // 7A70 - 7A7F
	0xFFFF, 0xB3CC, 0xFFFF, 0xFFFF, 0xCC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xC694, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7A80 - 7A8F
	0xFFFF, 0xFFFF, 0xC9C8, 0xCC3D, 0xFFFF, 0xC870, 0xFFFF, 0xFFFF, 0xAD70, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD74,   // 7A90 - 7A9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC640, 0xC640, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD81, 0xC694,   // 7AA0 - 7AAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADDC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7AB0 - 7ABF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC2C, 0xADDC, 0xFFFF, 0xB450, 0xFFFF, 0xFFFF, 0xC808, 0xB9BD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7AC0 - 7ACF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB18, 0xFFFF, 0xCC38, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCD1, 0xFFFF, 0xACBD,   // 7AD0 - 7ADF
	0xC7A5, 0xFFFF, 0xFFFF, 0xC900, 0xFFFF, 0xB3D9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xAC08, 0xFFFF, 0xB2E8,   // 7AE0 - 7AEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xC8FD, 0xCD95, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC04,   // 7AF0 - 7AFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD640,   // 7B00 - 7B0F
	0xFFFF, 0xC18C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0DD, 0xFFFF, 0xC801, 0xFFFF, 0xFFFF, 0xD0DC, 0xFFFF,   // 7B10 - 7B1F
	0xB9BD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C, 0xB839, 0xFFFF, 0xFFFF,   // 7B20 - 7B2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC138, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7B30 - 7B3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD544, 0xFFFF, 0xFFFF, 0xB4F1, 0xFFFF, 0xADFC, 0xC804, 0xC21C, 0xFFFF, 0xBC8C,   // 7B40 - 7B4F
	0xAD11, 0xCD95, 0xD1B5, 0xFFFF, 0xB2F5, 0xFFFF, 0xCC45, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7B50 - 7B5F
	0xADE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC131, 0xFFFF, 0xC11C, 0xFFFF,   // 7B60 - 7B6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5F0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xFFFF, 0xFFFF,   // 7B70 - 7B7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7C1,   // 7B80 - 7B8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC15, 0xAE30, 0xFFFF, 0xC0B0, 0xFFFF, 0xFFFF, 0xCC28, 0xFFFF, 0xFFFF, 0xACB8, 0xFFFF, 0xFFFF,   // 7B90 - 7B9F
	0xFFFF, 0xAD00, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF,   // 7BA0 - 7BAF
	0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xC7A0, 0xFFFF, 0xFFFF, 0xFFFF, 0xC800, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7BB0 - 7BBF
	0xC808, 0xD669, 0xFFFF, 0xFFFF, 0xBC94, 0xFFFF, 0xC804, 0xD3B8, 0xFFFF, 0xCD95, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7BC0 - 7BCF
	0xFFFF, 0xFFFF, 0xC2DD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7BD0 - 7BDF
	0xC18C, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7BE0 - 7BEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7BF0 - 7BFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC871, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7C00 - 7C0F
	0xFFFF, 0xFFFF, 0xCC2C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2E8, 0xFFFF,   // 7C10 - 7C1F
	0xFFFF, 0xAC04, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD669, 0xFFFF, 0xFFFF, 0xC7A0, 0xC18C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7C20 - 7C2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA8, 0xB834, 0xBD80,   // 7C30 - 7C3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xB78C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8FC, 0xC801, 0xFFFF, 0xFFFF,   // 7C40 - 7C4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7C50 - 7C5F
	0xB871, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9AC, 0xFFFF, 0xFFFF, 0xFFFF,   // 7C60 - 7C6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xBBF8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7C70 - 7C7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD84, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7C80 - 7C8F
	0xFFFF, 0xFFFF, 0xB9BD, 0xFFFF, 0xFFFF, 0xBC15, 0xFFFF, 0xC870, 0xC810, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC18D,   // 7C90 - 7C9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8FD, 0xFFFF, 0xC7A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB7C9, 0xFFFF,   // 7CA0 - 7CAF
	0xFFFF, 0xB7C9, 0xCC2C, 0xAC31, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF,   // 7CB0 - 7CBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7CC0 - 7CCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2F9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD84, 0xC870,   // 7CD0 - 7CDF
	0xAC15, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB7C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7CE0 - 7CEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACC4, 0xFFFF, 0xFFFF, 0xADDC, 0xFFFF,   // 7CF0 - 7CFF
	0xAE30, 0xFFFF, 0xC8FC, 0xFFFF, 0xC57D, 0xD64D, 0xC6B0, 0xD758, 0xD658, 0xFFFF, 0xBB38, 0xBB38, 0xFFFF, 0xB0A9, 0xFFFF, 0xFFFF,   // 7D00 - 7D0F
	0xB274, 0xFFFF, 0xFFFF, 0xFFFF, 0xC21C, 0xFFFF, 0xFFFF, 0xC0AC, 0xAD49, 0xC9C0, 0xAE09, 0xBD84, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7D10 - 7D1F
	0xC18C, 0xBC29, 0xC0C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC790, 0xC8FC, 0xFFFF, 0xCC30, 0xB8E8,   // 7D20 - 7D2F
	0xC138, 0xFFFF, 0xFFFF, 0xC2E0, 0xFFFF, 0xC800, 0xFFFF, 0xFFFF, 0xFFFF, 0xC18C, 0xAC10, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7D30 - 7D3F
	0xFFFF, 0xFFFF, 0xC885, 0xD604, 0xC870, 0xACBD, 0xBC18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7D40 - 7D4F
	0xACB0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD50, 0xFFFF,   // 7D50 - 7D5F
	0xFFFF, 0xB77D, 0xD604, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE09, 0xFFFF, 0xC735, 0xFFFF, 0xC778, 0xFFFF, 0xFFFF, 0xFFFF, 0xC11C, 0xFFFF,   // 7D60 - 7D6F
	0xFFFF, 0xD1B5, 0xC0AC, 0xAC15, 0xFFFF, 0xFFFF, 0xC808, 0xFFFF, 0xFFFF, 0xACAC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C,   // 7D70 - 7D7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xC218,   // 7D80 - 7D8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC885, 0xFFFF, 0xFFFF, 0xFFFF,   // 7D90 - 7D9F
	0xB85D, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xC720, 0xFFFF, 0xFFFF,   // 7DA0 - 7DAF
	0xFFFF, 0xAC15, 0xB9DD, 0xFFFF, 0xCCA0, 0xCC44, 0xFFFF, 0xFFFF, 0xB95C, 0xFFFF, 0xAE30, 0xD0C4, 0xFFFF, 0xC791, 0xB989, 0xBA74,   // 7DB0 - 7DBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE58, 0xFFFF, 0xFFFF, 0xAE34, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7DC0 - 7DCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC11C, 0xFFFF, 0xD568, 0xFFFF, 0xC120, 0xFFFF, 0xFFFF, 0xC9D1, 0xB2E8, 0xFFFF,   // 7DD0 - 7DDF
	0xCCB4, 0xBBFC, 0xFFFF, 0xC5F0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3B8, 0xC644, 0xFFFF, 0xFFFF, 0xBA74, 0xFFFF, 0xFFFF, 0xC704,   // 7DE0 - 7DEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB828, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE58, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7DF0 - 7DFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4, 0xC561, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7E00 - 7E0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC628, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC15, 0xFFFF, 0xC9C4, 0xD638, 0xC695,   // 7E10 - 7E1F
	0xFFFF, 0xC7AC, 0xFFFF, 0xD604, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD09, 0xFFFF, 0xFFFF, 0xCD95, 0xC5F0,   // 7E20 - 7E2F
	0xFFFF, 0xC885, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD1D, 0xC801, 0xFFFF,   // 7E30 - 7E3F
	0xFFFF, 0xBC88, 0xFFFF, 0xBD95, 0xFFFF, 0xFFFF, 0xBB34, 0xC694, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7E40 - 7E4F
	0xFFFF, 0xFFFF, 0xC99D, 0xFFFF, 0xC9C1, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC694, 0xFFFF,   // 7E50 - 7E5F
	0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2B9, 0xD68C, 0xACC4, 0xFFFF, 0xACAC, 0xFFFF, 0xFFFF,   // 7E60 - 7E6F
	0xC870, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5ED, 0xFFFF, 0xFFFF, 0xACC4, 0xFFFF, 0xFFFF, 0xFFFF,   // 7E70 - 7E7F
	0xFFFF, 0xFFFF, 0xCC2C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC18D, 0xFFFF, 0xFFFF, 0xC804,   // 7E80 - 7E8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC601, 0xFFFF, 0xFFFF, 0xC12C, 0xFFFF, 0xCC2C, 0xFFFF, 0xFFFF, 0xB3C5, 0xB78C, 0xFFFF, 0xFFFF, 0xFFFF,   // 7E90 - 7E9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7EA0 - 7EAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7EB0 - 7EBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7EC0 - 7ECF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7ED0 - 7EDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7EE0 - 7EEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7EF0 - 7EFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7F00 - 7F0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7F10 - 7F1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7F20 - 7F2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xD56D, 0xFFFF, 0xACB0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7F30 - 7F3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC575, 0xFFFF, 0xFFFF, 0xFFFF,   // 7F40 - 7F4F
	0xAD00, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9DD, 0xD55C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7F50 - 7F5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8C4, 0xAD18, 0xFFFF, 0xFFFF, 0xCE58, 0xFFFF,   // 7F60 - 7F6F
	0xBC8C, 0xFFFF, 0xC11C, 0xFFFF, 0xFFFF, 0xB9E4, 0xFFFF, 0xD30C, 0xFFFF, 0xB9AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7F70 - 7F7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB77C, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xC591, 0xFFFF, 0xAC15, 0xFFFF, 0xBBF8, 0xFFFF,   // 7F80 - 7F8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB839, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF,   // 7F90 - 7F9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD70, 0xFFFF, 0xFFFF, 0xFFFF, 0xC120, 0xC758, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7FA0 - 7FAF
	0xFFFF, 0xFFFF, 0xD76C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9AC, 0xAC31, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xFFFF, 0xFFFF,   // 7FB0 - 7FBF
	0xFFFF, 0xC639, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC775, 0xFFFF, 0xC775, 0xFFFF, 0xB839, 0xFFFF,   // 7FC0 - 7FCF
	0xFFFF, 0xFFFF, 0xC2B5, 0xFFFF, 0xC0C1, 0xD761, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC801,   // 7FD0 - 7FDF
	0xCDE8, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3B8, 0xFFFF, 0xC644, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 7FE0 - 7FEF
	0xD55C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD50, 0xFFFF, 0xFFFF, 0xC775, 0xFFFF, 0xFFFF, 0xFFFF,   // 7FF0 - 7FFF
	0xC694, 0xB85C, 0xFFFF, 0xACE0, 0xFFFF, 0xC790, 0xAE30, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xC774, 0xFFFF, 0xFFFF, 0xFFFF,   // 8000 - 800F
	0xB0B4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xBAA8, 0xC6B4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8010 - 801F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF,   // 8020 - 802F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC774, 0xFFFF, 0xFFFF, 0xC57C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0D0, 0xFFFF, 0xACBD,   // 8030 - 803F
	0xFFFF, 0xFFFF, 0xFFFF, 0xB2F4, 0xFFFF, 0xFFFF, 0xB839, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8040 - 804F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC131, 0xFFFF, 0xBE59, 0xFFFF, 0xCDE8, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB38, 0xFFFF,   // 8050 - 805F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB828,   // 8060 - 806F
	0xCD1D, 0xFFFF, 0xC131, 0xC6A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCAD, 0xB871, 0xC728,   // 8070 - 807F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC774, 0xC219, 0xC0AC, 0xC870, 0xFFFF, 0xC721, 0xFFFF, 0xB975, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF,   // 8080 - 808F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD56D, 0xFFFF, 0xAC04, 0xFFFF, 0xFFFF,   // 8090 - 809F
	0xFFFF, 0xACE0, 0xC9C0, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xACAC, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE0D,   // 80A0 - 80AF
	0xFFFF, 0xAD49, 0xC721, 0xFFFF, 0xD6A8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 80B0 - 80BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC704, 0xC8FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC30, 0xFFFF, 0xD0DC, 0xFFFF,   // 80C0 - 80CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC30, 0xAC11, 0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF,   // 80D0 - 80DF
	0xFFFF, 0xD638, 0xFFFF, 0xFFFF, 0xC724, 0xC11C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 80E0 - 80EF
	0xFFFF, 0xAD11, 0xFFFF, 0xFFFF, 0xB3D9, 0xFFFF, 0xFFFF, 0xFFFF, 0xD749, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2A5, 0xFFFF, 0xFFFF,   // 80F0 - 80FF
	0xFFFF, 0xFFFF, 0xC9C0, 0xFFFF, 0xFFFF, 0xD611, 0xCDE8, 0xD611, 0xB9E5, 0xFFFF, 0xCC99, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8100 - 810F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC644, 0xFFFF, 0xAC01, 0xACBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8110 - 811F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC21C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xD0C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3EC,   // 8120 - 812F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC3D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF,   // 8130 - 813F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC561, 0xFFFF, 0xFFFF, 0xC2E0, 0xFFFF,   // 8140 - 814F
	0xBD80, 0xBD80, 0xFFFF, 0xFFFF, 0xAC15, 0xC644, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8150 - 815F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC131, 0xB1CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC885, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8160 - 816F
	0xC694, 0xAC74, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7A5, 0xBCF5, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD1F4,   // 8170 - 817F
	0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACA9, 0xFFFF, 0xBC15, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE0,   // 8180 - 818F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xB9C9, 0xC2AC, 0xFFFF, 0xFFFF,   // 8190 - 819F
	0xAD50, 0xFFFF, 0xFFFF, 0xC9C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD33D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 81A0 - 81AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC120, 0xFFFF, 0xCDCC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC751, 0xFFFF, 0xFFFF, 0xB2F4, 0xD68C, 0xB18D,   // 81B0 - 81BF
	0xB454, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C, 0xFFFF, 0xFFFF,   // 81C0 - 81CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB78D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7A5,   // 81D0 - 81DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC2E0, 0xFFFF, 0xC640, 0xFFFF, 0xC7A5, 0xB9BC, 0xFFFF, 0xC790, 0xFFFF, 0xFFFF, 0xCDE8, 0xFFFF, 0xFFFF,   // 81E0 - 81EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC9C0, 0xCE58, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB300, 0xC9C4, 0xAD6C, 0xFFFF, 0xC720, 0xFFFF,   // 81F0 - 81FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xC5EC, 0xD765, 0xFFFF, 0xAD6C, 0xFFFF, 0xC124, 0xC0AC, 0xFFFF, 0xFFFF,   // 8200 - 820F
	0xFFFF, 0xFFFF, 0xC11C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC9C, 0xC21C, 0xFFFF, 0xBB34, 0xC8FC,   // 8210 - 821F
	0xFFFF, 0xAC15, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD56D, 0xBC29, 0xBC18, 0xFFFF, 0xFFFF, 0xFFFF,   // 8220 - 822F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C0, 0xBC15, 0xD604, 0xFFFF, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8230 - 823F
	0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5EC, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8240 - 824F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC3D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8250 - 825F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC758, 0xFFFF, 0xD568, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC04, 0xB7C9,   // 8260 - 826F
	0xFFFF, 0xAC04, 0xC0C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5FC, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC560, 0xFFFF,   // 8270 - 827F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xFFFF, 0xC791, 0xAD81, 0xFFFF,   // 8280 - 828F
	0xFFFF, 0xFFFF, 0xB9DD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xB454, 0xFFFF, 0xFFFF, 0xC9C0, 0xFFFF, 0xC0BC,   // 8290 - 829F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC1C, 0xD638, 0xFFFF, 0xFFFF, 0xAE08, 0xFFFF, 0xFFFF, 0xBD84, 0xD30C, 0xC608, 0xC2EC,   // 82A0 - 82AF
	0xFFFF, 0xD654, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C0, 0xC6B4, 0xADFC, 0xFFFF, 0xCD94, 0xBAA8, 0xC544, 0xFFFF, 0xC789,   // 82B0 - 82BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 82C0 - 82CF
	0xFFFF, 0xC6D0, 0xC5FC, 0xFFFF, 0xD0DC, 0xCD08, 0xFFFF, 0xBB18, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xD3EC, 0xAD6C,   // 82D0 - 82DF
	0xFFFF, 0xC774, 0xFFFF, 0xFFFF, 0xFFFF, 0xC57D, 0xACE0, 0xC800, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 82E0 - 82EF
	0xFFFF, 0xC601, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE0, 0xD544, 0xFFFF,   // 82F0 - 82FF
	0xFFFF, 0xC904, 0xBB34, 0xBC94, 0xAC00, 0xBAA8, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8300 - 830F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBA85, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8310 - 831F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC790, 0xFFFF, 0xFFFF, 0xB9DD, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCF5,   // 8320 - 832F
	0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xD68C, 0xC778, 0xB2E4, 0xFFFF, 0xC6A9, 0xC5EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8330 - 833F
	0xC21C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD589, 0xFFFF, 0xCD08, 0xD615, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC784,   // 8340 - 834F
	0xFFFF, 0xC774, 0xD669, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8350 - 835F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8360 - 836F
	0xFFFF, 0xFFFF, 0xFFFF, 0xB450, 0xFFFF, 0xFFFF, 0xFFFF, 0xD558, 0xFFFF, 0xFFFF, 0xFFFF, 0xC801, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8370 - 837F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9AC, 0xC7A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF,   // 8380 - 838F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xC2E0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC644, 0xFFFF,   // 8390 - 839F
	0xFFFF, 0xFFFF, 0xD611, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xC544, 0xB9C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 83A0 - 83AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9DD, 0xFFFF, 0xFFFF,   // 83B0 - 83BF
	0xFFFF, 0xCCAD, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD00, 0xFFFF, 0xFFFF, 0xFFFF, 0xB85D, 0xAD6D, 0xFFFF, 0xADE0, 0xFFFF, 0xFFFF, 0xFFFF,   // 83C0 - 83CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xACFC, 0xFFFF, 0xFFFF, 0xCC3D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC44, 0xFFFF, 0xFFFF, 0xFFFF,   // 83D0 - 83DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCF4, 0xFFFF, 0xADFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xD654,   // 83E0 - 83EF
	0xACE0, 0xB989, 0xBE44, 0xFFFF, 0xC554, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC800, 0xFFFF, 0xFFFF, 0xFFFF, 0xC219, 0xFFFF, 0xFFFF,   // 83F0 - 83FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xCDCC, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB798, 0xFFFF, 0xB9F9, 0xD3C9, 0xC704, 0xFFFF,   // 8400 - 840F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8410 - 841F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xFFFF, 0xFFFF, 0xB9CC, 0xFFFF, 0xFFFF, 0xFFFF,   // 8420 - 842F
	0xFFFF, 0xD6E4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC720, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB77D, 0xFFFF, 0xFFFF,   // 8430 - 843F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5FD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8440 - 844F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC800, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8450 - 845F
	0xFFFF, 0xD3EC, 0xFFFF, 0xB3D9, 0xFFFF, 0xFFFF, 0xC704, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xC7A5, 0xFFFF, 0xFFFF, 0xC57D,   // 8460 - 846F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADDC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC999, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8470 - 847F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8480 - 848F
	0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBABD, 0xFFFF, 0xFFFF, 0xC0B0, 0xFFFF, 0xFFFF, 0xFFFF,   // 8490 - 849F
	0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 84A0 - 84AF
	0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC99D, 0xFFFF, 0xFFFF, 0xC57D, 0xCC3D, 0xFFFF, 0xFFFF, 0xD638,   // 84B0 - 84BF
	0xC190, 0xFFFF, 0xBA85, 0xFFFF, 0xCD95, 0xFFFF, 0xC11D, 0xFFFF, 0xFFFF, 0xC6A9, 0xFFFF, 0xAC1C, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF,   // 84C0 - 84CF
	0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 84D0 - 84DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD09, 0xFFFF, 0xB828, 0xFFFF,   // 84E0 - 84EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC21C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8CC, 0xFFFF, 0xFFFF, 0xFFFF,   // 84F0 - 84FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8500 - 850F
	0xFFFF, 0xBA78, 0xFFFF, 0xB9CC, 0xBCF5, 0xFFFF, 0xFFFF, 0xC790, 0xC0BC, 0xFFFF, 0xC6B8, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8E8, 0xFFFF,   // 8510 - 851F
	0xFFFF, 0xCC44, 0xFFFF, 0xC7A5, 0xFFFF, 0xCD1D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC18C, 0xC74C, 0xFFFF, 0xC9C4,   // 8520 - 852F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3D0, 0xFFFF, 0xC704,   // 8530 - 853F
	0xFFFF, 0xB2F4, 0xFFFF, 0xBC88, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD50, 0xFFFF,   // 8540 - 854F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC6B4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD61C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8550 - 855F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC21C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD90, 0xD0D5, 0xBB34, 0xFFFF, 0xFFFF, 0xC18C, 0xFFFF, 0xFFFF,   // 8560 - 856F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8570 - 857F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC15, 0xFFFF, 0xFFFF, 0xBBF8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC758,   // 8580 - 858F
	0xFFFF, 0xAC15, 0xFFFF, 0xFFFF, 0xC7A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC124, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8590 - 859F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC9C, 0xFFFF, 0xD6D9, 0xC0B4, 0xC2E0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC11C,   // 85A0 - 85AF
	0xD6C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 85B0 - 85BF
	0xFFFF, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC790, 0xFFFF, 0xFFFF, 0xFFFF, 0xB78C, 0xC2E0, 0xC7A5,   // 85C0 - 85CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB824, 0xC608, 0xFFFF, 0xFFFF,   // 85D0 - 85DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB4F1, 0xC57D, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC88, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 85E0 - 85EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC800, 0xFFFF, 0xFFFF, 0xB9B0, 0xC870, 0xFFFF, 0xFFFF, 0xFFFF, 0xACFD,   // 85F0 - 85FF
	0xFFFF, 0xFFFF, 0xC608, 0xFFFF, 0xFFFF, 0xFFFF, 0xB85C, 0xC18C, 0xFFFF, 0xFFFF, 0xC628, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8600 - 860F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5BC, 0xBCBD, 0xFFFF, 0xFFFF, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8610 - 861F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB780, 0xFFFF, 0xFFFF,   // 8620 - 862F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB77C,   // 8630 - 863F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF,   // 8640 - 864F
	0xD559, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC74, 0xCC98, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD5C8, 0xB85C, 0xFFFF, 0xC6B0, 0xD638,   // 8650 - 865F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD734, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8660 - 866F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD64D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8670 - 867F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB38, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF,   // 8680 - 868F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC778, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8690 - 869F
	0xFFFF, 0xFFFF, 0xFFFF, 0xACF5, 0xC870, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE58, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 86A0 - 86AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 86B0 - 86BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 86C0 - 86CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD68C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC640, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD50,   // 86D0 - 86DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD569, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C8, 0xFFFF, 0xFFFF,   // 86E0 - 86EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC544, 0xFFFF,   // 86F0 - 86FF
	0xCD09, 0xFFFF, 0xBD09, 0xC2E0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8700 - 870F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C0, 0xFFFF, 0xBE44, 0xFFFF, 0xBC00, 0xFFFF, 0xFFFF, 0xFFFF,   // 8710 - 871F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8720 - 872F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8730 - 873F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC08, 0xFFFF,   // 8740 - 874F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DD, 0xFFFF, 0xD669, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC704,   // 8750 - 875F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD558, 0xFFFF, 0xC2AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8760 - 876F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF, 0xC811, 0xFFFF, 0xC640, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8770 - 877F
	0xFFFF, 0xFFFF, 0xB791, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC735, 0xFFFF, 0xFFFF,   // 8780 - 878F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBA85,   // 8790 - 879F
	0xFFFF, 0xFFFF, 0xD615, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 87A0 - 87AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xB2F9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB77C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 87B0 - 87BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE69, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 87C0 - 87CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 87D0 - 87DF
	0xBC18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC120, 0xFFFF, 0xFFFF, 0xC694,   // 87E0 - 87EF
	0xFFFF, 0xFFFF, 0xCDA9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD574, 0xFFFF, 0xC758, 0xFFFF, 0xFFFF, 0xC12C, 0xFFFF,   // 87F0 - 87FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8800 - 880F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB78D,   // 8810 - 881F
	0xFFFF, 0xFFFF, 0xC900, 0xB824, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8820 - 882F
	0xFFFF, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7A0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8830 - 883F
	0xD608, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC911, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD589, 0xC5F0, 0xFFFF, 0xFFFF,   // 8840 - 884F
	0xFFFF, 0xFFFF, 0xD604, 0xC220, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xC544, 0xFFFF, 0xC704, 0xFFFF, 0xCDA9, 0xFFFF, 0xFFFF,   // 8850 - 885F
	0xFFFF, 0xD615, 0xAD6C, 0xC758, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD45C, 0xFFFF, 0xFFFF, 0xC0BC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8860 - 886F
	0xC1E0, 0xFFFF, 0xB0A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCDA9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE08, 0xAE08,   // 8870 - 887F
	0xFFFF, 0xC6D0, 0xBA8C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xB300, 0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF,   // 8880 - 888F
	0xFFFF, 0xFFFF, 0xB2E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xC9C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE4, 0xFFFF,   // 8890 - 889F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD53C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 88A0 - 88AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 88B0 - 88BF
	0xFFFF, 0xC7AC, 0xB82C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9AC,   // 88C0 - 88CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC608, 0xC720, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD70, 0xFFFF, 0xFFFF, 0xBCF4, 0xC7A5, 0xFFFF, 0xC0AC,   // 88D0 - 88DF
	0xFFFF, 0xB9AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 88E0 - 88EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC0C1, 0xBC30, 0xBC30, 0xFFFF, 0xFFFF, 0xB77C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C, 0xFFFF, 0xFFFF,   // 88F0 - 88FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCF5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8900 - 890F
	0xAC08, 0xFFFF, 0xD3EC, 0xBCF4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC704, 0xBC30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8910 - 891F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC695, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD1F4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8920 - 892F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2B5, 0xFFFF, 0xB8E8, 0xFFFF, 0xFFFF, 0xC124, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8930 - 893F
	0xFFFF, 0xAC15, 0xFFFF, 0xFFFF, 0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8940 - 894F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE08,   // 8950 - 895F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB78C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8960 - 896F
	0xFFFF, 0xFFFF, 0xC2B5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC11C,   // 8970 - 897F
	0xFFFF, 0xC694, 0xFFFF, 0xB2F4, 0xFFFF, 0xFFFF, 0xBCF5, 0xD328, 0xFFFF, 0xFFFF, 0xFFFF, 0xACAC, 0xFFFF, 0xFFFF, 0xFFFF, 0xADDC,   // 8980 - 898F
	0xFFFF, 0xFFFF, 0xFFFF, 0xBA71, 0xFFFF, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8990 - 899F
	0xFFFF, 0xACA9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C4, 0xCE5C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 89A0 - 89AF
	0xFFFF, 0xFFFF, 0xADFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC01, 0xFFFF, 0xFFFF, 0xB78C, 0xFFFF, 0xFFFF,   // 89B0 - 89BF
	0xAD00, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 89C0 - 89CF
	0xFFFF, 0xFFFF, 0xAC01, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 89D0 - 89DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xD574, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 89E0 - 89EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD09, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 89F0 - 89FF
	0xC5B8, 0xFFFF, 0xC815, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACC4, 0xFFFF, 0xC2E0, 0xFFFF, 0xD64D, 0xFFFF, 0xD1A0, 0xFFFF,   // 8A00 - 8A0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xD6C8, 0xFFFF, 0xFFFF, 0xD758, 0xD0C1, 0xAE30, 0xFFFF, 0xFFFF, 0xC640, 0xFFFF, 0xC544, 0xFFFF, 0xC1A1,   // 8A10 - 8A1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xACB0, 0xFFFF, 0xB20C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xC124, 0xFFFF, 0xFFFF,   // 8A20 - 8A2F
	0xFFFF, 0xD5C8, 0xFFFF, 0xFFFF, 0xC18C, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4, 0xC8FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8A30 - 8A3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8A40 - 8A4F
	0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xD3C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC800, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF,   // 8A50 - 8A5F
	0xC601, 0xFFFF, 0xC21C, 0xC608, 0xFFFF, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xADA4, 0xC804, 0xFFFF,   // 8A60 - 8A6F
	0xD790, 0xD654, 0xD574, 0xC0C1, 0xFFFF, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8A70 - 8A7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8FC, 0xFFFF, 0xACFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C0, 0xC778, 0xFFFF, 0xFFFF,   // 8A80 - 8A8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC11C, 0xFFFF, 0xD0C4, 0xFFFF, 0xFFFF, 0xC720, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5B4, 0xFFFF,   // 8A90 - 8A9F
	0xC131, 0xACC4, 0xFFFF, 0xBB34, 0xC624, 0xACE0, 0xC1A1, 0xFFFF, 0xD68C, 0xFFFF, 0xC124, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8AA0 - 8AAF
	0xC218, 0xFFFF, 0xACFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xC758, 0xFFFF, 0xC740, 0xC870,   // 8AB0 - 8ABF
	0xFFFF, 0xFFFF, 0xCCA8, 0xFFFF, 0xC21C, 0xFFFF, 0xFFFF, 0xB2F4, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCAD, 0xFFFF, 0xC7C1, 0xFFFF, 0xCD94,   // 8AC0 - 8ACF
	0xFFFF, 0xFFFF, 0xB7C9, 0xFFFF, 0xFFFF, 0xFFFF, 0xB860, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC720, 0xCCA9, 0xFFFF, 0xFFFF, 0xFFFF,   // 8AD0 - 8ADF
	0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCB4, 0xD574, 0xFFFF, 0xFFFF, 0xC815, 0xAC04, 0xFFFF, 0xC720, 0xC790, 0xFFFF,   // 8AE0 - 8AEF
	0xFFFF, 0xD718, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2EC, 0xD48D, 0xC81C, 0xFFFF, 0xC5B8, 0xFFFF, 0xFFFF, 0xFFFF, 0xB099, 0xFFFF,   // 8AF0 - 8AFF
	0xBAA8, 0xC54C, 0xC704, 0xFFFF, 0xB4F1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBBF8, 0xFFFF,   // 8B00 - 8B0F
	0xBC00, 0xFFFF, 0xFFFF, 0xFFFF, 0xD559, 0xFFFF, 0xC18D, 0xBC29, 0xFFFF, 0xACB8, 0xC775, 0xAC15, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF,   // 8B10 - 8B1F
	0xC694, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBAA8, 0xFFFF, 0xFFFF, 0xC801, 0xB958, 0xFFFF, 0xFFFF, 0xFFFF,   // 8B20 - 8B2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8B30 - 8B3F
	0xFFFF, 0xD654, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC99D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD73C, 0xAE30,   // 8B40 - 8B4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DD, 0xFFFF, 0xB2F4, 0xFFFF, 0xBCF4, 0xFFFF, 0xFFFF, 0xFFFF,   // 8B50 - 8B5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xC5ED,   // 8B60 - 8B6F
	0xC758, 0xFFFF, 0xFFFF, 0xFFFF, 0xACAC, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC608, 0xFFFF, 0xFFFF,   // 8B70 - 8B7F
	0xB3C5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCC0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8B80 - 8B8F
	0xC218, 0xFFFF, 0xCC38, 0xC591, 0xFFFF, 0xFFFF, 0xCC38, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC2C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8B90 - 8B9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8BA0 - 8BAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8BB0 - 8BBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8BC0 - 8BCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8BD0 - 8BDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8BE0 - 8BEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8BF0 - 8BFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8C00 - 8C0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8C10 - 8C1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8C20 - 8C2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACC4,   // 8C30 - 8C3F
	0xFFFF, 0xD65C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB450, 0xFFFF, 0xAE30, 0xFFFF, 0xD48D, 0xFFFF, 0xC644, 0xFFFF, 0xFFFF, 0xFFFF,   // 8C40 - 8C4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8C50 - 8C5F
	0xFFFF, 0xC0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xC608, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8C60 - 8C6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD45C, 0xC2DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8C70 - 8C7F
	0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9E5, 0xFFFF, 0xBAA8, 0xFFFF, 0xFFFF, 0xFFFF,   // 8C80 - 8C8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD328, 0xC815, 0xFFFF,   // 8C90 - 8C9F
	0xBD80, 0xC7AC, 0xACF5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE48, 0xD654, 0xD310, 0xD0D0, 0xAD00, 0xCC45, 0xFFFF, 0xFFFF, 0xC800,   // 8CA0 - 8CAF
	0xC138, 0xFFFF, 0xFFFF, 0xC774, 0xADC0, 0xFFFF, 0xD3C4, 0xB9E4, 0xB300, 0xFFFF, 0xFFFF, 0xBE44, 0xCCA9, 0xC774, 0xFFFF, 0xBB34,   // 8CB0 - 8CBF
	0xD558, 0xBD84, 0xB8B0, 0xC784, 0xD68C, 0xFFFF, 0xFFFF, 0xC790, 0xAC00, 0xFFFF, 0xC801, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8CC0 - 8CCF
	0xFFFF, 0xC9C4, 0xFFFF, 0xBE48, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8B0, 0xFFFF, 0xC0AC, 0xFFFF, 0xC0C1, 0xFFFF,   // 8CD0 - 8CDF
	0xBC30, 0xFFFF, 0xD604, 0xB9E4, 0xCC9C, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C8, 0xFFFF, 0xFFFF, 0xB3C4, 0xFFFF, 0xFFFF,   // 8CE0 - 8CEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xAD6C, 0xC0C8, 0xFFFF, 0xFFFF,   // 8CF0 - 8CFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C0, 0xCDCC, 0xFFFF, 0xC724, 0xC99D, 0xFFFF, 0xCC2C, 0xFFFF, 0xFFFF, 0xC12C, 0xFFFF, 0xFFFF,   // 8D00 - 8D0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC7A5, 0xFFFF, 0xFFFF, 0xC18D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8D10 - 8D1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8D20 - 8D2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8D30 - 8D3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8D40 - 8D4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8D50 - 8D5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC801, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD601, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8D60 - 8D6F
	0xC8FC, 0xFFFF, 0xFFFF, 0xADDC, 0xBD80, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8D70 - 8D7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6D4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8D80 - 8D8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8D90 - 8D9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xCDE8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8DA0 - 8DAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC871, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C0, 0xFFFF,   // 8DB0 - 8DBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC1C, 0xC9C8, 0xFFFF, 0xFFFF, 0xAC00,   // 8DC0 - 8DCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD30C, 0xFFFF, 0xAC70, 0xFFFF, 0xFFFF,   // 8DD0 - 8DDF
	0xFFFF, 0xC801, 0xFFFF, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB85C,   // 8DE0 - 8DEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8DF0 - 8DFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6A9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2F5,   // 8E00 - 8E0F
	0xCC9C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC70, 0xFFFF,   // 8E10 - 8E1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC885, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8E20 - 8E2F
	0xC720, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC885, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8E30 - 8E3F
	0xFFFF, 0xFFFF, 0xC720, 0xFFFF, 0xC81C, 0xFFFF, 0xFFFF, 0xAC74, 0xB3C4, 0xCC28, 0xD61C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8E40 - 8E4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD95, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC801,   // 8E50 - 8E5F
	0xCC99, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8E60 - 8E6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD95, 0xFFFF, 0xAD90, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8E70 - 8E7F
	0xFFFF, 0xC870, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC800, 0xFFFF, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xC57D, 0xFFFF, 0xFFFF,   // 8E80 - 8E8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8E90 - 8E9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9B0, 0xC2E0, 0xAD81, 0xFFFF, 0xFFFF, 0xFFFF,   // 8EA0 - 8EAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8EB0 - 8EBF
	0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC28, 0xC54C, 0xADA4, 0xAD70, 0xFFFF, 0xFFFF,   // 8EC0 - 8ECF
	0xFFFF, 0xFFFF, 0xD5CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5F0,   // 8ED0 - 8EDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8EE0 - 8EEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD95, 0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xC2DD, 0xFFFF,   // 8EF0 - 8EFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xAD50, 0xFFFF, 0xB85C, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8F00 - 8F0F
	0xFFFF, 0xFFFF, 0xCCA9, 0xB9CC, 0xBCF4, 0xACBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB7C9, 0xCE58, 0xD718, 0xB9DD, 0xCCA0,   // 8F10 - 8F1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB828, 0xBCD1, 0xFFFF, 0xBC30, 0xB95C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9D1,   // 8F20 - 8F2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xBCF5, 0xFFFF, 0xBCF5, 0xFFFF, 0xFFFF, 0xC804, 0xC5EC,   // 8F30 - 8F3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD560, 0xC6D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA0, 0xAD50, 0xFFFF,   // 8F40 - 8F4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5EC, 0xFFFF, 0xAD49,   // 8F50 - 8F5F
	0xFFFF, 0xFFFF, 0xB825, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8F60 - 8F6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8F70 - 8F7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8F80 - 8F8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC2E0, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF,   // 8F90 - 8F9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xB784, 0xFFFF, 0xFFFF, 0xD310, 0xFFFF, 0xBCC0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xBCC0,   // 8FA0 - 8FAF
	0xC9C4, 0xC695, 0xB18D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8FB0 - 8FBF
	0xFFFF, 0xFFFF, 0xC6B0, 0xFFFF, 0xFFFF, 0xC2E0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC601, 0xFFFF,   // 8FC0 - 8FCF
	0xFFFF, 0xADFC, 0xFFFF, 0xFFFF, 0xBC18, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 8FD0 - 8FDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xFFFF, 0xC801, 0xBC15, 0xFFFF, 0xC9C8, 0xFFFF, 0xFFFF,   // 8FE0 - 8FEF
	0xC220, 0xFFFF, 0xAC81, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBBF8, 0xFFFF, 0xC801, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xFFFF, 0xFFFF,   // 8FF0 - 8FFF
	0xD1F4, 0xC1A1, 0xAD04, 0xB3C4, 0xFFFF, 0xD6C4, 0xC5ED, 0xFFFF, 0xD615, 0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xC18C, 0xFFFF, 0xD22C,   // 9000 - 900F
	0xCD95, 0xAD6C, 0xFFFF, 0xFFFF, 0xB3C4, 0xACBD, 0xFFFF, 0xB450, 0xFFFF, 0xC800, 0xD1B5, 0xFFFF, 0xFFFF, 0xC11C, 0xB839, 0xC18D,   // 9010 - 901F
	0xC870, 0xC900, 0xBD09, 0xB828, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCB4, 0xFFFF,   // 9020 - 902F
	0xFFFF, 0xC8FC, 0xC9C4, 0xFFFF, 0xFFFF, 0xADDC, 0xFFFF, 0xFFFF, 0xC77C, 0xFFFF, 0xFFFF, 0xFFFF, 0xD54D, 0xFFFF, 0xC720, 0xFFFF,   // 9030 - 903F
	0xFFFF, 0xB454, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xFFFF, 0xFFFF, 0xC720, 0xC6B4, 0xFFFF, 0xD3B8, 0xACFC, 0xFFFF,   // 9040 - 904F
	0xD558, 0xD669, 0xFFFF, 0xB3C4, 0xB2EC, 0xC704, 0xFFFF, 0xFFFF, 0xFFFF, 0xC694, 0xFFFF, 0xFFFF, 0xC190, 0xB2F5, 0xCCB4, 0xFFFF,   // 9050 - 905F
	0xC6D0, 0xC18C, 0xFFFF, 0xACAC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC801, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xCC28, 0xB454,   // 9060 - 906F
	0xFFFF, 0xFFFF, 0xC9C0, 0xFFFF, 0xFFFF, 0xC900, 0xFFFF, 0xCC9C, 0xC120, 0xFFFF, 0xC720, 0xFFFF, 0xB8CC, 0xAC70, 0xFFFF, 0xD53C,   // 9070 - 907F
	0xC694, 0xB9E4, 0xD574, 0xC218, 0xD658, 0xFFFF, 0xFFFF, 0xC774, 0xB9C9, 0xFFFF, 0xBCC0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB77C,   // 9080 - 908F
	0xFFFF, 0xC74D, 0xFFFF, 0xFFFF, 0xFFFF, 0xC639, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9DD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9090 - 909F
	0xFFFF, 0xFFFF, 0xD615, 0xB098, 0xFFFF, 0xFFFF, 0xBC29, 0xFFFF, 0xCD0C, 0xFFFF, 0xC0AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC10,   // 90A0 - 90AF
	0xD0DC, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xC18C, 0xFFFF, 0xFFFF, 0xC800, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 90B0 - 90BF
	0xFFFF, 0xC6B1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD50, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 90C0 - 90CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB791, 0xFFFF,   // 90D0 - 90DF
	0xFFFF, 0xAD70, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACFD, 0xFFFF, 0xFFFF,   // 90E0 - 90EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C4, 0xFFFF, 0xFFFF,   // 90F0 - 90FF
	0xFFFF, 0xFFFF, 0xC545, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9100 - 910F
	0xFFFF, 0xFFFF, 0xCD94, 0xFFFF, 0xFFFF, 0xD5A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9110 - 911F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB4F1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF,   // 9120 - 912F
	0xFFFF, 0xFFFF, 0xB2E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9130 - 913F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC720, 0xC815, 0xCD94, 0xC791, 0xBC30, 0xC8FC, 0xFFFF,   // 9140 - 914F
	0xFFFF, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9150 - 915F
	0xFFFF, 0xFFFF, 0xCD08, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBA85, 0xB77D, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF,   // 9160 - 916F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6A8, 0xFFFF, 0xD639, 0xC0B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9170 - 917F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC21C, 0xFFFF, 0xCDE8, 0xFFFF, 0xCD08, 0xFFFF, 0xC81C, 0xFFFF, 0xFFFF,   // 9180 - 918F
	0xFFFF, 0xFFFF, 0xC131, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xFFFF, 0xFFFF, 0xFFFF,   // 9190 - 919F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC758, 0xC7A5, 0xFFFF, 0xCD08, 0xD61C,   // 91A0 - 91AF
	0xFFFF, 0xBC1C, 0xFFFF, 0xFFFF, 0xB840, 0xAC39, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 91B0 - 91BF
	0xC591, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC44, 0xFFFF, 0xC720, 0xFFFF, 0xC11D, 0xB9AC, 0xC911, 0xC57C, 0xB7C9,   // 91C0 - 91CF
	0xB9AC, 0xAE40, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC1E0, 0xC815, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xCE68, 0xFFFF, 0xFFFF,   // 91D0 - 91DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC9C, 0xFFFF, 0xFFFF, 0xC6B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 91E0 - 91EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 91F0 - 91FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB454, 0xFFFF, 0xFFFF,   // 9200 - 920F
	0xAC80, 0xD310, 0xC0BD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC724, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADE0, 0xFFFF,   // 9210 - 921F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9220 - 922F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB839, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC625, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC804,   // 9230 - 923F
	0xAC11, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC70, 0xFFFF, 0xFFFF, 0xFFFF, 0xD604, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9240 - 924F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACB8, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5F0, 0xFFFF, 0xFFFF, 0xC6D4, 0xFFFF,   // 9250 - 925F
	0xFFFF, 0xFFFF, 0xBC1C, 0xFFFF, 0xAD6C, 0xC220, 0xC815, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9260 - 926F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9270 - 927F
	0xC740, 0xFFFF, 0xFFFF, 0xCD1D, 0xFFFF, 0xB3D9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9280 - 928F
	0xFFFF, 0xC120, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xBA85, 0xFFFF, 0xFFFF, 0xFFFF, 0xD568, 0xFFFF, 0xFFFF, 0xFFFF,   // 9290 - 929F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 92A0 - 92AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC608, 0xFFFF, 0xFFFF, 0xAD6C, 0xC18C, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 92B0 - 92BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF, 0xD611,   // 92C0 - 92CF
	0xFFFF, 0xFFFF, 0xBD09, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 92D0 - 92DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC11C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 92E0 - 92EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC70, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC15, 0xFFFF, 0xFFFF, 0xFFFF,   // 92F0 - 92FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB85D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9300 - 930F
	0xCD94, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xFFFF, 0xC7C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xC21C, 0xB2F4,   // 9310 - 931F
	0xC815, 0xAE30, 0xC804, 0xFFFF, 0xAE30, 0xFFFF, 0xAE08, 0xFFFF, 0xBB18, 0xFFFF, 0xFFFF, 0xC11D, 0xFFFF, 0xFFFF, 0xACE0, 0xCC29,   // 9320 - 932F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9330 - 933F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC601, 0xFFFF, 0xB828, 0xACFC, 0xFFFF, 0xB3C4, 0xFFFF, 0xFFFF,   // 9340 - 934F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC545, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9350 - 935F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC720, 0xFFFF,   // 9360 - 936F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC74, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE68, 0xFFFF, 0xC885, 0xFFFF,   // 9370 - 937F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACB8, 0xFFFF, 0xFFFF, 0xFFFF,   // 9380 - 938F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6A9, 0xFFFF, 0xC1C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9390 - 939F
	0xFFFF, 0xFFFF, 0xFFFF, 0xD615, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xC9C4, 0xFFFF, 0xFFFF,   // 93A0 - 93AF
	0xC77C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 93B0 - 93BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC871, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 93C0 - 93CF
	0xFFFF, 0xC801, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6A9, 0xFFFF,   // 93D0 - 93DF
	0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xB8E8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 93E0 - 93EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC9D1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 93F0 - 93FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6A1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9400 - 940F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC885, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9410 - 941F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC120, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9420 - 942F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCA0, 0xFFFF, 0xFFFF, 0xD0C1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9430 - 943F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC8FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9440 - 944F
	0xFFFF, 0xAC10, 0xAC10, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD11, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9450 - 945F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9460 - 946F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC2C, 0xFFFF, 0xCC29,   // 9470 - 947F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9480 - 948F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9490 - 949F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 94A0 - 94AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 94B0 - 94BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 94C0 - 94CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 94D0 - 94DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 94E0 - 94EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 94F0 - 94FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9500 - 950F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9510 - 951F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9520 - 952F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9530 - 953F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9540 - 954F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9550 - 955F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9560 - 956F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC7A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9570 - 957F
	0xBB38, 0xFFFF, 0xFFFF, 0xC12C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3D0, 0xFFFF, 0xAC1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xC724,   // 9580 - 958F
	0xFFFF, 0xD55C, 0xD55C, 0xAC04, 0xBBFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC11, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9590 - 959F
	0xFFFF, 0xFFFF, 0xFFFF, 0xAC01, 0xD569, 0xBC8C, 0xFFFF, 0xFFFF, 0xADDC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB824, 0xFFFF, 0xFFFF,   // 95A0 - 95AF
	0xFFFF, 0xC5F4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5FC, 0xC54C, 0xFFFF, 0xFFFF, 0xFFFF,   // 95B0 - 95BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC554, 0xFFFF, 0xFFFF, 0xD65C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 95C0 - 95CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD569, 0xAD90, 0xD2C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD00, 0xFFFF, 0xFFFF, 0xFFFF,   // 95D0 - 95DF
	0xFFFF, 0xCC9C, 0xBCBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 95E0 - 95EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 95F0 - 95FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9600 - 960F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF,   // 9610 - 961F
	0xFFFF, 0xCC9C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD310, 0xFFFF, 0xFFFF, 0xFFFF, 0xC644, 0xFFFF,   // 9620 - 962F
	0xFFFF, 0xFFFF, 0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xFFFF, 0xFFFF, 0xFFFF, 0xC544,   // 9630 - 963F
	0xD0C0, 0xFFFF, 0xD53C, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8E8, 0xB9E5, 0xAC15, 0xFFFF, 0xFFFF,   // 9640 - 964F
	0xD55C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3D0, 0xD569, 0xC12C, 0xC2B9, 0xCC99,   // 9650 - 965F
	0xFFFF, 0xFFFF, 0xC6D0, 0xC9C4, 0xC81C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9660 - 966F
	0xC74C, 0xFFFF, 0xFFFF, 0xC9C4, 0xFFFF, 0xB989, 0xB3C4, 0xD568, 0xB959, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC591, 0xFFFF, 0xFFFF,   // 9670 - 967F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xB96D, 0xFFFF, 0xFFFF, 0xFFFF, 0xB300, 0xC218, 0xFFFF, 0xD669, 0xACC4, 0xFFFF,   // 9680 - 968F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACA9, 0xC6B4, 0xFFFF, 0xFFFF, 0xC560, 0xADF9, 0xFFFF, 0xC81C, 0xC7A5, 0xFFFF, 0xFFFF, 0xFFFF,   // 9690 - 969F
	0xFFFF, 0xFFFF, 0xFFFF, 0xB9B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xC218, 0xFFFF, 0xD5D8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 96A0 - 96AF
	0xFFFF, 0xC740, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB840, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC99, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 96B0 - 96BF
	0xC791, 0xC548, 0xFFFF, 0xFFFF, 0xC6C5, 0xC544, 0xC9D1, 0xACE0, 0xFFFF, 0xCE58, 0xFFFF, 0xC900, 0xC790, 0xC639, 0xC800, 0xFFFF,   // 96C0 - 96CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xC218, 0xFFFF, 0xFFFF, 0xC30D, 0xFFFF, 0xCD94, 0xC7A1, 0xFFFF, 0xFFFF, 0xFFFF,   // 96D0 - 96DF
	0xFFFF, 0xFFFF, 0xB9AC, 0xB09C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B0, 0xC6B0, 0xC124, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB38,   // 96E0 - 96EF
	0xBD84, 0xFFFF, 0xC6B4, 0xFFFF, 0xFFFF, 0xFFFF, 0xB839, 0xB8B0, 0xFFFF, 0xBC15, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 96F0 - 96FF
	0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xC9C4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9700 - 970F
	0xFFFF, 0xC810, 0xFFFF, 0xC608, 0xFFFF, 0xFFFF, 0xB9BC, 0xFFFF, 0xFFFF, 0xC601, 0xFFFF, 0xFFFF, 0xC0C1, 0xFFFF, 0xD558, 0xFFFF,   // 9710 - 971F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB34, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9720 - 972F
	0xC0B0, 0xFFFF, 0xB85C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C, 0xFFFF, 0xFFFF,   // 9730 - 973F
	0xFFFF, 0xFFFF, 0xB825, 0xFFFF, 0xC560, 0xFFFF, 0xFFFF, 0xFFFF, 0xB839, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9740 - 974F
	0xFFFF, 0xCCAD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF, 0xBE44, 0xFFFF,   // 9750 - 975F
	0xFFFF, 0xBBF8, 0xBA74, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD601, 0xFFFF, 0xFFFF, 0xFFFF, 0xC778, 0xFFFF, 0xFFFF,   // 9760 - 976F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD654, 0xFFFF, 0xFFFF, 0xC778, 0xFFFF, 0xFFFF, 0xB9D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9770 - 977F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD61C, 0xFFFF, 0xC548, 0xFFFF, 0xACF5,   // 9780 - 978F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9790 - 979F
	0xAD6D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC08, 0xFFFF, 0xFFFF, 0xAD6D, 0xFFFF, 0xD3B8, 0xFFFF, 0xFFFF,   // 97A0 - 97AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 97B0 - 97BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCC9C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC704, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 97C0 - 97CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xD55C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB3C4, 0xFFFF, 0xFFFF, 0xFFFF,   // 97D0 - 97DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 97E0 - 97EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC74C, 0xFFFF, 0xFFFF, 0xC18C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6B4, 0xFFFF, 0xFFFF, 0xFFFF, 0xD5A5,   // 97F0 - 97FF
	0xD638, 0xD608, 0xC815, 0xACBD, 0xFFFF, 0xD56D, 0xC21C, 0xFFFF, 0xC218, 0xFFFF, 0xC6B1, 0xFFFF, 0xC1A1, 0xFFFF, 0xFFFF, 0xFFFF,   // 9800 - 980F
	0xC608, 0xC644, 0xBC18, 0xB3C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xD30C, 0xB839, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9810 - 981F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB450, 0xFFFF, 0xFFFF,   // 9820 - 982F
	0xD611, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xD1F4, 0xFFFF, 0xBE48, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9830 - 983F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C, 0xC561, 0xC545, 0xFFFF,   // 9840 - 984F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC548, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6D0, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xB958, 0xFFFF,   // 9850 - 985F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD638, 0xFFFF, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xC804, 0xFFFF, 0xFFFF, 0xFFFF, 0xD604,   // 9860 - 986F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9870 - 987F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9880 - 988F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9890 - 989F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD48D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0BD,   // 98A0 - 98AF
	0xFFFF, 0xD0DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 98B0 - 98BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD45C, 0xFFFF, 0xFFFF, 0xD45C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 98C0 - 98CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xBC88, 0xFFFF, 0xFFFF, 0xC2DD,   // 98D0 - 98DF
	0xFFFF, 0xC190, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCE59, 0xC74C, 0xBC18,   // 98E0 - 98EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC774, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xD3EC, 0xC2DD, 0xFFFF,   // 98F0 - 98FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xAD50, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD5A5, 0xC591, 0xFFFF, 0xC774, 0xFFFF, 0xFFFF, 0xFFFF,   // 9900 - 990F
	0xCC2C, 0xFFFF, 0xFFFF, 0xC544, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC804, 0xFFFF,   // 9910 - 991F
	0xBCD1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD00, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9920 - 992F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9930 - 993F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xADFC, 0xFFFF, 0xADA4, 0xCC2C, 0xC120, 0xFFFF, 0xFFFF,   // 9940 - 994F
	0xFFFF, 0xAE30, 0xC694, 0xFFFF, 0xC639, 0xFFFF, 0xFFFF, 0xD5A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9950 - 995F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9960 - 996F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9970 - 997F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9980 - 998F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xD5A5, 0xFFFF, 0xFFFF, 0xFFFF, 0xD544, 0xFFFF, 0xFFFF,   // 9990 - 999F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCF5, 0xFFFF, 0xFFFF, 0xD615, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9C8, 0xC5B4, 0xD48D, 0xFFFF,   // 99A0 - 99AF
	0xFFFF, 0xD0C0, 0xFFFF, 0xCE58, 0xC21C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC77C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 99B0 - 99BF
	0xFFFF, 0xBC15, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 99C0 - 99CF
	0xC8FC, 0xB178, 0xAD6C, 0xFFFF, 0xFFFF, 0xAC00, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD80, 0xFFFF, 0xFFFF, 0xFFFF, 0xD0C0, 0xFFFF, 0xC0AC,   // 99D0 - 99DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD574, 0xFFFF, 0xFFFF,   // 99E0 - 99EF
	0xFFFF, 0xB77D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC900,   // 99F0 - 99FF
	0xFFFF, 0xBE59, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBCD1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAE30, 0xAE30,   // 9A00 - 9A0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD3B8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9A10 - 9A1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC74, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9A20 - 9A2F
	0xB4F1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xC18C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9A30 - 9A3F
	0xB9E5, 0xFFFF, 0xFFFF, 0xD45C, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD6A8, 0xFFFF, 0xFFFF,   // 9A40 - 9A4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD50, 0xFFFF, 0xD5D8, 0xFFFF, 0xFFFF, 0xACBD, 0xC5ED, 0xFFFF, 0xFFFF, 0xFFFF, 0xCDE8,   // 9A50 - 9A5F
	0xFFFF, 0xFFFF, 0xB824, 0xFFFF, 0xFFFF, 0xAE30, 0xFFFF, 0xFFFF, 0xFFFF, 0xD658, 0xB824, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9A60 - 9A6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9A70 - 9A7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9A80 - 9A8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9A90 - 9A9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9AA0 - 9AAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD574, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9AB0 - 9ABF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9AC0 - 9ACF
	0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xCCB4, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9AD0 - 9ADF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5FC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC1C, 0xFFFF,   // 9AE0 - 9AEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9AF0 - 9AFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9B00 - 9B0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC218, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9B10 - 9B1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8CC, 0xFFFF, 0xFFFF, 0xD22C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9B20 - 9B2F
	0xFFFF, 0xC6B8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xADC0, 0xFFFF, 0xFFFF, 0xFFFF,   // 9B30 - 9B3F
	0xFFFF, 0xAD34, 0xD63C, 0xBC1C, 0xBC31, 0xB9E4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC704,   // 9B40 - 9B4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9C8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5B4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9B50 - 9B5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB85C,   // 9B60 - 9B6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9B70 - 9B7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC810, 0xFFFF,   // 9B80 - 9B8F
	0xFFFF, 0xD3EC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC548,   // 9B90 - 9B9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD50, 0xFFFF, 0xFFFF, 0xC120, 0xFFFF,   // 9BA0 - 9BAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9BB0 - 9BBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9AC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9BC0 - 9BCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCAD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9BD0 - 9BDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACE4, 0xFFFF, 0xFFFF, 0xFFFF, 0xACBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9BE0 - 9BEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9BF0 - 9BFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD94, 0xFFFF, 0xFFFF,   // 9C00 - 9C0F
	0xC545, 0xFFFF, 0xBCF5, 0xFFFF, 0xFFFF, 0xD558, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9C10 - 9C1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD658, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9C20 - 9C2F
	0xFFFF, 0xFFFF, 0xC624, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9CC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9C30 - 9C3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC15, 0xFFFF, 0xBCC4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9C40 - 9C4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9B0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9C50 - 9C5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9C60 - 9C6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9C70 - 9C7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9C80 - 9C8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9C90 - 9C9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9CA0 - 9CAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9CB0 - 9CBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9CC0 - 9CCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9CD0 - 9CDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC870, 0xFFFF, 0xBD80, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9CE0 - 9CEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xBD09, 0xBA85, 0xFFFF, 0xC5F0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9CF0 - 9CFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC544, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9D00 - 9D0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC6D0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9D10 - 9D1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC559, 0xFFFF, 0xC555, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9D20 - 9D2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD64D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9D30 - 9D3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9D40 - 9D4F
	0xFFFF, 0xACAC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC544, 0xFFFF, 0xFFFF,   // 9D50 - 9D5F
	0xACE1, 0xBB34, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBD95, 0xFFFF, 0xFFFF, 0xFFFF,   // 9D60 - 9D6F
	0xFFFF, 0xFFFF, 0xC791, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9D70 - 9D7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9D80 - 9D8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9D90 - 9D9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBAA9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC575,   // 9DA0 - 9DAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD559, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9DB0 - 9DBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xACC4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9DC0 - 9DCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9DD0 - 9DDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9DE0 - 9DEF
	0xFFFF, 0xFFFF, 0xCDE8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD73C, 0xC751, 0xB85C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9DF0 - 9DFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9E00 - 9E0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC575, 0xFFFF, 0xFFFF, 0xFFFF, 0xB780, 0xFFFF,   // 9E10 - 9E1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9E20 - 9E2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9E30 - 9E3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9E40 - 9E4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9E50 - 9E5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9E60 - 9E6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB85C, 0xFFFF, 0xFFFF, 0xFFFF, 0xD568, 0xFFFF, 0xFFFF, 0xFFFF, 0xC5FC, 0xFFFF, 0xB85D,   // 9E70 - 9E7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9E80 - 9E8F
	0xFFFF, 0xFFFF, 0xAE30, 0xB85D, 0xFFFF, 0xFFFF, 0xFFFF, 0xB824, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC0AC, 0xFFFF, 0xB9B0,   // 9E90 - 9E9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9E5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9EA0 - 9EAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6D, 0xBA74, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB9C8, 0xFFFF, 0xFFFF, 0xD718, 0xFFFF,   // 9EB0 - 9EBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xD669, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC11C, 0xB824, 0xFFFF,   // 9EC0 - 9ECF
	0xFFFF, 0xD751, 0xFFFF, 0xFFFF, 0xAC80, 0xFFFF, 0xFFFF, 0xFFFF, 0xBB35, 0xFFFF, 0xFFFF, 0xB300, 0xCD9C, 0xFFFF, 0xC810, 0xFFFF,   // 9ED0 - 9EDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB2F9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9EE0 - 9EEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBBF8, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9EF0 - 9EFF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC624, 0xBCC4, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC815, 0xFFFF,   // 9F00 - 9F0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xACE0, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9F10 - 9F1F
	0xC11C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9F20 - 9F2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBE44, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9F30 - 9F3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC81C, 0xC7AC, 0xFFFF, 0xFFFF, 0xC7AC, 0xFFFF,   // 9F40 - 9F4F
	0xFFFF, 0xFFFF, 0xCE58, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC800,   // 9F50 - 9F5F
	0xFFFF, 0xB839, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC124, 0xFFFF, 0xFFFF, 0xCC29, 0xFFFF, 0xC5B4, 0xFFFF, 0xFFFF, 0xFFFF,   // 9F60 - 9F6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC545, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9F70 - 9F7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB8E1, 0xFFFF, 0xFFFF,   // 9F80 - 9F8F
	0xBC29, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAC10, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAD6C, 0xFFFF, 0xFFFF, 0xFFFF,   // 9F90 - 9F9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FA0 - 9FAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FB0 - 9FBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FC0 - 9FCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FD0 - 9FDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FE0 - 9FEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FF0 - 9FFF
	0xAC00, 0xAC01, 0xAC02, 0xAC03, 0xAC04, 0xAC05, 0xAC06, 0xAC07, 0xAC08, 0xAC09, 0xAC0A, 0xAC0B, 0xAC0C, 0xAC0D, 0xAC0E, 0xAC0F,   // AC00 - AC0F
	0xAC10, 0xAC11, 0xAC12, 0xAC13, 0xAC14, 0xAC15, 0xAC16, 0xAC17, 0xAC18, 0xAC19, 0xAC1A, 0xAC1B, 0xAC1C, 0xAC1D, 0xAC1E, 0xAC1F,   // AC10 - AC1F
	0xAC20, 0xAC21, 0xAC22, 0xAC23, 0xAC24, 0xAC25, 0xAC26, 0xAC27, 0xAC28, 0xAC29, 0xAC2A, 0xAC2B, 0xAC2C, 0xAC2D, 0xAC2E, 0xAC2F,   // AC20 - AC2F
	0xAC30, 0xAC31, 0xAC32, 0xAC33, 0xAC34, 0xAC35, 0xAC36, 0xAC37, 0xAC38, 0xAC39, 0xAC3A, 0xAC3B, 0xAC3C, 0xAC3D, 0xAC3E, 0xAC3F,   // AC30 - AC3F
	0xAC40, 0xAC41, 0xAC42, 0xAC43, 0xAC44, 0xAC45, 0xAC46, 0xAC47, 0xAC48, 0xAC49, 0xAC4A, 0xAC4B, 0xAC4C, 0xAC4D, 0xAC4E, 0xAC4F,   // AC40 - AC4F
	0xAC50, 0xAC51, 0xAC52, 0xAC53, 0xAC54, 0xAC55, 0xAC56, 0xAC57, 0xAC58, 0xAC59, 0xAC5A, 0xAC5B, 0xAC5C, 0xAC5D, 0xAC5E, 0xAC5F,   // AC50 - AC5F
	0xAC60, 0xAC61, 0xAC62, 0xAC63, 0xAC64, 0xAC65, 0xAC66, 0xAC67, 0xAC68, 0xAC69, 0xAC6A, 0xAC6B, 0xAC6C, 0xAC6D, 0xAC6E, 0xAC6F,   // AC60 - AC6F
	0xAC70, 0xAC71, 0xAC72, 0xAC73, 0xAC74, 0xAC75, 0xAC76, 0xAC77, 0xAC78, 0xAC79, 0xAC7A, 0xAC7B, 0xAC7C, 0xAC7D, 0xAC7E, 0xAC7F,   // AC70 - AC7F
	0xAC80, 0xAC81, 0xAC82, 0xAC83, 0xAC84, 0xAC85, 0xAC86, 0xAC87, 0xAC88, 0xAC89, 0xAC8A, 0xAC8B, 0xAC8C, 0xAC8D, 0xAC8E, 0xAC8F,   // AC80 - AC8F
	0xAC90, 0xAC91, 0xAC92, 0xAC93, 0xAC94, 0xAC95, 0xAC96, 0xAC97, 0xAC98, 0xAC99, 0xAC9A, 0xAC9B, 0xAC9C, 0xAC9D, 0xAC9E, 0xAC9F,   // AC90 - AC9F
	0xACA0, 0xACA1, 0xACA2, 0xACA3, 0xACA4, 0xACA5, 0xACA6, 0xACA7, 0xACA8, 0xACA9, 0xACAA, 0xACAB, 0xACAC, 0xACAD, 0xACAE, 0xACAF,   // ACA0 - ACAF
	0xACB0, 0xACB1, 0xACB2, 0xACB3, 0xACB4, 0xACB5, 0xACB6, 0xACB7, 0xACB8, 0xACB9, 0xACBA, 0xACBB, 0xACBC, 0xACBD, 0xACBE, 0xACBF,   // ACB0 - ACBF
	0xACC0, 0xACC1, 0xACC2, 0xACC3, 0xACC4, 0xACC5, 0xACC6, 0xACC7, 0xACC8, 0xACC9, 0xACCA, 0xACCB, 0xACCC, 0xACCD, 0xACCE, 0xACCF,   // ACC0 - ACCF
	0xACD0, 0xACD1, 0xACD2, 0xACD3, 0xACD4, 0xACD5, 0xACD6, 0xACD7, 0xACD8, 0xACD9, 0xACDA, 0xACDB, 0xACDC, 0xACDD, 0xACDE, 0xACDF,   // ACD0 - ACDF
	0xACE0, 0xACE1, 0xACE2, 0xACE3, 0xACE4, 0xACE5, 0xACE6, 0xACE7, 0xACE8, 0xACE9, 0xACEA, 0xACEB, 0xACEC, 0xACED, 0xACEE, 0xACEF,   // ACE0 - ACEF
	0xACF0, 0xACF1, 0xACF2, 0xACF3, 0xACF4, 0xACF5, 0xACF6, 0xACF7, 0xACF8, 0xACF9, 0xACFA, 0xACFB, 0xACFC, 0xACFD, 0xACFE, 0xACFF,   // ACF0 - ACFF
	0xAD00, 0xAD01, 0xAD02, 0xAD03, 0xAD04, 0xAD05, 0xAD06, 0xAD07, 0xAD08, 0xAD09, 0xAD0A, 0xAD0B, 0xAD0C, 0xAD0D, 0xAD0E, 0xAD0F,   // AD00 - AD0F
	0xAD10, 0xAD11, 0xAD12, 0xAD13, 0xAD14, 0xAD15, 0xAD16, 0xAD17, 0xAD18, 0xAD19, 0xAD1A, 0xAD1B, 0xAD1C, 0xAD1D, 0xAD1E, 0xAD1F,   // AD10 - AD1F
	0xAD20, 0xAD21, 0xAD22, 0xAD23, 0xAD24, 0xAD25, 0xAD26, 0xAD27, 0xAD28, 0xAD29, 0xAD2A, 0xAD2B, 0xAD2C, 0xAD2D, 0xAD2E, 0xAD2F,   // AD20 - AD2F
	0xAD30, 0xAD31, 0xAD32, 0xAD33, 0xAD34, 0xAD35, 0xAD36, 0xAD37, 0xAD38, 0xAD39, 0xAD3A, 0xAD3B, 0xAD3C, 0xAD3D, 0xAD3E, 0xAD3F,   // AD30 - AD3F
	0xAD40, 0xAD41, 0xAD42, 0xAD43, 0xAD44, 0xAD45, 0xAD46, 0xAD47, 0xAD48, 0xAD49, 0xAD4A, 0xAD4B, 0xAD4C, 0xAD4D, 0xAD4E, 0xAD4F,   // AD40 - AD4F
	0xAD50, 0xAD51, 0xAD52, 0xAD53, 0xAD54, 0xAD55, 0xAD56, 0xAD57, 0xAD58, 0xAD59, 0xAD5A, 0xAD5B, 0xAD5C, 0xAD5D, 0xAD5E, 0xAD5F,   // AD50 - AD5F
	0xAD60, 0xAD61, 0xAD62, 0xAD63, 0xAD64, 0xAD65, 0xAD66, 0xAD67, 0xAD68, 0xAD69, 0xAD6A, 0xAD6B, 0xAD6C, 0xAD6D, 0xAD6E, 0xAD6F,   // AD60 - AD6F
	0xAD70, 0xAD71, 0xAD72, 0xAD73, 0xAD74, 0xAD75, 0xAD76, 0xAD77, 0xAD78, 0xAD79, 0xAD7A, 0xAD7B, 0xAD7C, 0xAD7D, 0xAD7E, 0xAD7F,   // AD70 - AD7F
	0xAD80, 0xAD81, 0xAD82, 0xAD83, 0xAD84, 0xAD85, 0xAD86, 0xAD87, 0xAD88, 0xAD89, 0xAD8A, 0xAD8B, 0xAD8C, 0xAD8D, 0xAD8E, 0xAD8F,   // AD80 - AD8F
	0xAD90, 0xAD91, 0xAD92, 0xAD93, 0xAD94, 0xAD95, 0xAD96, 0xAD97, 0xAD98, 0xAD99, 0xAD9A, 0xAD9B, 0xAD9C, 0xAD9D, 0xAD9E, 0xAD9F,   // AD90 - AD9F
	0xADA0, 0xADA1, 0xADA2, 0xADA3, 0xADA4, 0xADA5, 0xADA6, 0xADA7, 0xADA8, 0xADA9, 0xADAA, 0xADAB, 0xADAC, 0xADAD, 0xADAE, 0xADAF,   // ADA0 - ADAF
	0xADB0, 0xADB1, 0xADB2, 0xADB3, 0xADB4, 0xADB5, 0xADB6, 0xADB7, 0xADB8, 0xADB9, 0xADBA, 0xADBB, 0xADBC, 0xADBD, 0xADBE, 0xADBF,   // ADB0 - ADBF
	0xADC0, 0xADC1, 0xADC2, 0xADC3, 0xADC4, 0xADC5, 0xADC6, 0xADC7, 0xADC8, 0xADC9, 0xADCA, 0xADCB, 0xADCC, 0xADCD, 0xADCE, 0xADCF,   // ADC0 - ADCF
	0xADD0, 0xADD1, 0xADD2, 0xADD3, 0xADD4, 0xADD5, 0xADD6, 0xADD7, 0xADD8, 0xADD9, 0xADDA, 0xADDB, 0xADDC, 0xADDD, 0xADDE, 0xADDF,   // ADD0 - ADDF
	0xADE0, 0xADE1, 0xADE2, 0xADE3, 0xADE4, 0xADE5, 0xADE6, 0xADE7, 0xADE8, 0xADE9, 0xADEA, 0xADEB, 0xADEC, 0xADED, 0xADEE, 0xADEF,   // ADE0 - ADEF
	0xADF0, 0xADF1, 0xADF2, 0xADF3, 0xADF4, 0xADF5, 0xADF6, 0xADF7, 0xADF8, 0xADF9, 0xADFA, 0xADFB, 0xADFC, 0xADFD, 0xADFE, 0xADFF,   // ADF0 - ADFF
	0xAE00, 0xAE01, 0xAE02, 0xAE03, 0xAE04, 0xAE05, 0xAE06, 0xAE07, 0xAE08, 0xAE09, 0xAE0A, 0xAE0B, 0xAE0C, 0xAE0D, 0xAE0E, 0xAE0F,   // AE00 - AE0F
	0xAE10, 0xAE11, 0xAE12, 0xAE13, 0xAE14, 0xAE15, 0xAE16, 0xAE17, 0xAE18, 0xAE19, 0xAE1A, 0xAE1B, 0xAE1C, 0xAE1D, 0xAE1E, 0xAE1F,   // AE10 - AE1F
	0xAE20, 0xAE21, 0xAE22, 0xAE23, 0xAE24, 0xAE25, 0xAE26, 0xAE27, 0xAE28, 0xAE29, 0xAE2A, 0xAE2B, 0xAE2C, 0xAE2D, 0xAE2E, 0xAE2F,   // AE20 - AE2F
	0xAE30, 0xAE31, 0xAE32, 0xAE33, 0xAE34, 0xAE35, 0xAE36, 0xAE37, 0xAE38, 0xAE39, 0xAE3A, 0xAE3B, 0xAE3C, 0xAE3D, 0xAE3E, 0xAE3F,   // AE30 - AE3F
	0xAE40, 0xAE41, 0xAE42, 0xAE43, 0xAE44, 0xAE45, 0xAE46, 0xAE47, 0xAE48, 0xAE49, 0xAE4A, 0xAE4B, 0xAE4C, 0xAE4D, 0xAE4E, 0xAE4F,   // AE40 - AE4F
	0xAE50, 0xAE51, 0xAE52, 0xAE53, 0xAE54, 0xAE55, 0xAE56, 0xAE57, 0xAE58, 0xAE59, 0xAE5A, 0xAE5B, 0xAE5C, 0xAE5D, 0xAE5E, 0xAE5F,   // AE50 - AE5F
	0xAE60, 0xAE61, 0xAE62, 0xAE63, 0xAE64, 0xAE65, 0xAE66, 0xAE67, 0xAE68, 0xAE69, 0xAE6A, 0xAE6B, 0xAE6C, 0xAE6D, 0xAE6E, 0xAE6F,   // AE60 - AE6F
	0xAE70, 0xAE71, 0xAE72, 0xAE73, 0xAE74, 0xAE75, 0xAE76, 0xAE77, 0xAE78, 0xAE79, 0xAE7A, 0xAE7B, 0xAE7C, 0xAE7D, 0xAE7E, 0xAE7F,   // AE70 - AE7F
	0xAE80, 0xAE81, 0xAE82, 0xAE83, 0xAE84, 0xAE85, 0xAE86, 0xAE87, 0xAE88, 0xAE89, 0xAE8A, 0xAE8B, 0xAE8C, 0xAE8D, 0xAE8E, 0xAE8F,   // AE80 - AE8F
	0xAE90, 0xAE91, 0xAE92, 0xAE93, 0xAE94, 0xAE95, 0xAE96, 0xAE97, 0xAE98, 0xAE99, 0xAE9A, 0xAE9B, 0xAE9C, 0xAE9D, 0xAE9E, 0xAE9F,   // AE90 - AE9F
	0xAEA0, 0xAEA1, 0xAEA2, 0xAEA3, 0xAEA4, 0xAEA5, 0xAEA6, 0xAEA7, 0xAEA8, 0xAEA9, 0xAEAA, 0xAEAB, 0xAEAC, 0xAEAD, 0xAEAE, 0xAEAF,   // AEA0 - AEAF
	0xAEB0, 0xAEB1, 0xAEB2, 0xAEB3, 0xAEB4, 0xAEB5, 0xAEB6, 0xAEB7, 0xAEB8, 0xAEB9, 0xAEBA, 0xAEBB, 0xAEBC, 0xAEBD, 0xAEBE, 0xAEBF,   // AEB0 - AEBF
	0xAEC0, 0xAEC1, 0xAEC2, 0xAEC3, 0xAEC4, 0xAEC5, 0xAEC6, 0xAEC7, 0xAEC8, 0xAEC9, 0xAECA, 0xAECB, 0xAECC, 0xAECD, 0xAECE, 0xAECF,   // AEC0 - AECF
	0xAED0, 0xAED1, 0xAED2, 0xAED3, 0xAED4, 0xAED5, 0xAED6, 0xAED7, 0xAED8, 0xAED9, 0xAEDA, 0xAEDB, 0xAEDC, 0xAEDD, 0xAEDE, 0xAEDF,   // AED0 - AEDF
	0xAEE0, 0xAEE1, 0xAEE2, 0xAEE3, 0xAEE4, 0xAEE5, 0xAEE6, 0xAEE7, 0xAEE8, 0xAEE9, 0xAEEA, 0xAEEB, 0xAEEC, 0xAEED, 0xAEEE, 0xAEEF,   // AEE0 - AEEF
	0xAEF0, 0xAEF1, 0xAEF2, 0xAEF3, 0xAEF4, 0xAEF5, 0xAEF6, 0xAEF7, 0xAEF8, 0xAEF9, 0xAEFA, 0xAEFB, 0xAEFC, 0xAEFD, 0xAEFE, 0xAEFF,   // AEF0 - AEFF
	0xAF00, 0xAF01, 0xAF02, 0xAF03, 0xAF04, 0xAF05, 0xAF06, 0xAF07, 0xAF08, 0xAF09, 0xAF0A, 0xAF0B, 0xAF0C, 0xAF0D, 0xAF0E, 0xAF0F,   // AF00 - AF0F
	0xAF10, 0xAF11, 0xAF12, 0xAF13, 0xAF14, 0xAF15, 0xAF16, 0xAF17, 0xAF18, 0xAF19, 0xAF1A, 0xAF1B, 0xAF1C, 0xAF1D, 0xAF1E, 0xAF1F,   // AF10 - AF1F
	0xAF20, 0xAF21, 0xAF22, 0xAF23, 0xAF24, 0xAF25, 0xAF26, 0xAF27, 0xAF28, 0xAF29, 0xAF2A, 0xAF2B, 0xAF2C, 0xAF2D, 0xAF2E, 0xAF2F,   // AF20 - AF2F
	0xAF30, 0xAF31, 0xAF32, 0xAF33, 0xAF34, 0xAF35, 0xAF36, 0xAF37, 0xAF38, 0xAF39, 0xAF3A, 0xAF3B, 0xAF3C, 0xAF3D, 0xAF3E, 0xAF3F,   // AF30 - AF3F
	0xAF40, 0xAF41, 0xAF42, 0xAF43, 0xAF44, 0xAF45, 0xAF46, 0xAF47, 0xAF48, 0xAF49, 0xAF4A, 0xAF4B, 0xAF4C, 0xAF4D, 0xAF4E, 0xAF4F,   // AF40 - AF4F
	0xAF50, 0xAF51, 0xAF52, 0xAF53, 0xAF54, 0xAF55, 0xAF56, 0xAF57, 0xAF58, 0xAF59, 0xAF5A, 0xAF5B, 0xAF5C, 0xAF5D, 0xAF5E, 0xAF5F,   // AF50 - AF5F
	0xAF60, 0xAF61, 0xAF62, 0xAF63, 0xAF64, 0xAF65, 0xAF66, 0xAF67, 0xAF68, 0xAF69, 0xAF6A, 0xAF6B, 0xAF6C, 0xAF6D, 0xAF6E, 0xAF6F,   // AF60 - AF6F
	0xAF70, 0xAF71, 0xAF72, 0xAF73, 0xAF74, 0xAF75, 0xAF76, 0xAF77, 0xAF78, 0xAF79, 0xAF7A, 0xAF7B, 0xAF7C, 0xAF7D, 0xAF7E, 0xAF7F,   // AF70 - AF7F
	0xAF80, 0xAF81, 0xAF82, 0xAF83, 0xAF84, 0xAF85, 0xAF86, 0xAF87, 0xAF88, 0xAF89, 0xAF8A, 0xAF8B, 0xAF8C, 0xAF8D, 0xAF8E, 0xAF8F,   // AF80 - AF8F
	0xAF90, 0xAF91, 0xAF92, 0xAF93, 0xAF94, 0xAF95, 0xAF96, 0xAF97, 0xAF98, 0xAF99, 0xAF9A, 0xAF9B, 0xAF9C, 0xAF9D, 0xAF9E, 0xAF9F,   // AF90 - AF9F
	0xAFA0, 0xAFA1, 0xAFA2, 0xAFA3, 0xAFA4, 0xAFA5, 0xAFA6, 0xAFA7, 0xAFA8, 0xAFA9, 0xAFAA, 0xAFAB, 0xAFAC, 0xAFAD, 0xAFAE, 0xAFAF,   // AFA0 - AFAF
	0xAFB0, 0xAFB1, 0xAFB2, 0xAFB3, 0xAFB4, 0xAFB5, 0xAFB6, 0xAFB7, 0xAFB8, 0xAFB9, 0xAFBA, 0xAFBB, 0xAFBC, 0xAFBD, 0xAFBE, 0xAFBF,   // AFB0 - AFBF
	0xAFC0, 0xAFC1, 0xAFC2, 0xAFC3, 0xAFC4, 0xAFC5, 0xAFC6, 0xAFC7, 0xAFC8, 0xAFC9, 0xAFCA, 0xAFCB, 0xAFCC, 0xAFCD, 0xAFCE, 0xAFCF,   // AFC0 - AFCF
	0xAFD0, 0xAFD1, 0xAFD2, 0xAFD3, 0xAFD4, 0xAFD5, 0xAFD6, 0xAFD7, 0xAFD8, 0xAFD9, 0xAFDA, 0xAFDB, 0xAFDC, 0xAFDD, 0xAFDE, 0xAFDF,   // AFD0 - AFDF
	0xAFE0, 0xAFE1, 0xAFE2, 0xAFE3, 0xAFE4, 0xAFE5, 0xAFE6, 0xAFE7, 0xAFE8, 0xAFE9, 0xAFEA, 0xAFEB, 0xAFEC, 0xAFED, 0xAFEE, 0xAFEF,   // AFE0 - AFEF
	0xAFF0, 0xAFF1, 0xAFF2, 0xAFF3, 0xAFF4, 0xAFF5, 0xAFF6, 0xAFF7, 0xAFF8, 0xAFF9, 0xAFFA, 0xAFFB, 0xAFFC, 0xAFFD, 0xAFFE, 0xAFFF,   // AFF0 - AFFF
	0xB000, 0xB001, 0xB002, 0xB003, 0xB004, 0xB005, 0xB006, 0xB007, 0xB008, 0xB009, 0xB00A, 0xB00B, 0xB00C, 0xB00D, 0xB00E, 0xB00F,   // B000 - B00F
	0xB010, 0xB011, 0xB012, 0xB013, 0xB014, 0xB015, 0xB016, 0xB017, 0xB018, 0xB019, 0xB01A, 0xB01B, 0xB01C, 0xB01D, 0xB01E, 0xB01F,   // B010 - B01F
	0xB020, 0xB021, 0xB022, 0xB023, 0xB024, 0xB025, 0xB026, 0xB027, 0xB028, 0xB029, 0xB02A, 0xB02B, 0xB02C, 0xB02D, 0xB02E, 0xB02F,   // B020 - B02F
	0xB030, 0xB031, 0xB032, 0xB033, 0xB034, 0xB035, 0xB036, 0xB037, 0xB038, 0xB039, 0xB03A, 0xB03B, 0xB03C, 0xB03D, 0xB03E, 0xB03F,   // B030 - B03F
	0xB040, 0xB041, 0xB042, 0xB043, 0xB044, 0xB045, 0xB046, 0xB047, 0xB048, 0xB049, 0xB04A, 0xB04B, 0xB04C, 0xB04D, 0xB04E, 0xB04F,   // B040 - B04F
	0xB050, 0xB051, 0xB052, 0xB053, 0xB054, 0xB055, 0xB056, 0xB057, 0xB058, 0xB059, 0xB05A, 0xB05B, 0xB05C, 0xB05D, 0xB05E, 0xB05F,   // B050 - B05F
	0xB060, 0xB061, 0xB062, 0xB063, 0xB064, 0xB065, 0xB066, 0xB067, 0xB068, 0xB069, 0xB06A, 0xB06B, 0xB06C, 0xB06D, 0xB06E, 0xB06F,   // B060 - B06F
	0xB070, 0xB071, 0xB072, 0xB073, 0xB074, 0xB075, 0xB076, 0xB077, 0xB078, 0xB079, 0xB07A, 0xB07B, 0xB07C, 0xB07D, 0xB07E, 0xB07F,   // B070 - B07F
	0xB080, 0xB081, 0xB082, 0xB083, 0xB084, 0xB085, 0xB086, 0xB087, 0xB088, 0xB089, 0xB08A, 0xB08B, 0xB08C, 0xB08D, 0xB08E, 0xB08F,   // B080 - B08F
	0xB090, 0xB091, 0xB092, 0xB093, 0xB094, 0xB095, 0xB096, 0xB097, 0xB098, 0xB099, 0xB09A, 0xB09B, 0xB09C, 0xB09D, 0xB09E, 0xB09F,   // B090 - B09F
	0xB0A0, 0xB0A1, 0xB0A2, 0xB0A3, 0xB0A4, 0xB0A5, 0xB0A6, 0xB0A7, 0xB0A8, 0xB0A9, 0xB0AA, 0xB0AB, 0xB0AC, 0xB0AD, 0xB0AE, 0xB0AF,   // B0A0 - B0AF
	0xB0B0, 0xB0B1, 0xB0B2, 0xB0B3, 0xB0B4, 0xB0B5, 0xB0B6, 0xB0B7, 0xB0B8, 0xB0B9, 0xB0BA, 0xB0BB, 0xB0BC, 0xB0BD, 0xB0BE, 0xB0BF,   // B0B0 - B0BF
	0xB0C0, 0xB0C1, 0xB0C2, 0xB0C3, 0xB0C4, 0xB0C5, 0xB0C6, 0xB0C7, 0xB0C8, 0xB0C9, 0xB0CA, 0xB0CB, 0xB0CC, 0xB0CD, 0xB0CE, 0xB0CF,   // B0C0 - B0CF
	0xB0D0, 0xB0D1, 0xB0D2, 0xB0D3, 0xB0D4, 0xB0D5, 0xB0D6, 0xB0D7, 0xB0D8, 0xB0D9, 0xB0DA, 0xB0DB, 0xB0DC, 0xB0DD, 0xB0DE, 0xB0DF,   // B0D0 - B0DF
	0xB0E0, 0xB0E1, 0xB0E2, 0xB0E3, 0xB0E4, 0xB0E5, 0xB0E6, 0xB0E7, 0xB0E8, 0xB0E9, 0xB0EA, 0xB0EB, 0xB0EC, 0xB0ED, 0xB0EE, 0xB0EF,   // B0E0 - B0EF
	0xB0F0, 0xB0F1, 0xB0F2, 0xB0F3, 0xB0F4, 0xB0F5, 0xB0F6, 0xB0F7, 0xB0F8, 0xB0F9, 0xB0FA, 0xB0FB, 0xB0FC, 0xB0FD, 0xB0FE, 0xB0FF,   // B0F0 - B0FF
	0xB100, 0xB101, 0xB102, 0xB103, 0xB104, 0xB105, 0xB106, 0xB107, 0xB108, 0xB109, 0xB10A, 0xB10B, 0xB10C, 0xB10D, 0xB10E, 0xB10F,   // B100 - B10F
	0xB110, 0xB111, 0xB112, 0xB113, 0xB114, 0xB115, 0xB116, 0xB117, 0xB118, 0xB119, 0xB11A, 0xB11B, 0xB11C, 0xB11D, 0xB11E, 0xB11F,   // B110 - B11F
	0xB120, 0xB121, 0xB122, 0xB123, 0xB124, 0xB125, 0xB126, 0xB127, 0xB128, 0xB129, 0xB12A, 0xB12B, 0xB12C, 0xB12D, 0xB12E, 0xB12F,   // B120 - B12F
	0xB130, 0xB131, 0xB132, 0xB133, 0xB134, 0xB135, 0xB136, 0xB137, 0xB138, 0xB139, 0xB13A, 0xB13B, 0xB13C, 0xB13D, 0xB13E, 0xB13F,   // B130 - B13F
	0xB140, 0xB141, 0xB142, 0xB143, 0xB144, 0xB145, 0xB146, 0xB147, 0xB148, 0xB149, 0xB14A, 0xB14B, 0xB14C, 0xB14D, 0xB14E, 0xB14F,   // B140 - B14F
	0xB150, 0xB151, 0xB152, 0xB153, 0xB154, 0xB155, 0xB156, 0xB157, 0xB158, 0xB159, 0xB15A, 0xB15B, 0xB15C, 0xB15D, 0xB15E, 0xB15F,   // B150 - B15F
	0xB160, 0xB161, 0xB162, 0xB163, 0xB164, 0xB165, 0xB166, 0xB167, 0xB168, 0xB169, 0xB16A, 0xB16B, 0xB16C, 0xB16D, 0xB16E, 0xB16F,   // B160 - B16F
	0xB170, 0xB171, 0xB172, 0xB173, 0xB174, 0xB175, 0xB176, 0xB177, 0xB178, 0xB179, 0xB17A, 0xB17B, 0xB17C, 0xB17D, 0xB17E, 0xB17F,   // B170 - B17F
	0xB180, 0xB181, 0xB182, 0xB183, 0xB184, 0xB185, 0xB186, 0xB187, 0xB188, 0xB189, 0xB18A, 0xB18B, 0xB18C, 0xB18D, 0xB18E, 0xB18F,   // B180 - B18F
	0xB190, 0xB191, 0xB192, 0xB193, 0xB194, 0xB195, 0xB196, 0xB197, 0xB198, 0xB199, 0xB19A, 0xB19B, 0xB19C, 0xB19D, 0xB19E, 0xB19F,   // B190 - B19F
	0xB1A0, 0xB1A1, 0xB1A2, 0xB1A3, 0xB1A4, 0xB1A5, 0xB1A6, 0xB1A7, 0xB1A8, 0xB1A9, 0xB1AA, 0xB1AB, 0xB1AC, 0xB1AD, 0xB1AE, 0xB1AF,   // B1A0 - B1AF
	0xB1B0, 0xB1B1, 0xB1B2, 0xB1B3, 0xB1B4, 0xB1B5, 0xB1B6, 0xB1B7, 0xB1B8, 0xB1B9, 0xB1BA, 0xB1BB, 0xB1BC, 0xB1BD, 0xB1BE, 0xB1BF,   // B1B0 - B1BF
	0xB1C0, 0xB1C1, 0xB1C2, 0xB1C3, 0xB1C4, 0xB1C5, 0xB1C6, 0xB1C7, 0xB1C8, 0xB1C9, 0xB1CA, 0xB1CB, 0xB1CC, 0xB1CD, 0xB1CE, 0xB1CF,   // B1C0 - B1CF
	0xB1D0, 0xB1D1, 0xB1D2, 0xB1D3, 0xB1D4, 0xB1D5, 0xB1D6, 0xB1D7, 0xB1D8, 0xB1D9, 0xB1DA, 0xB1DB, 0xB1DC, 0xB1DD, 0xB1DE, 0xB1DF,   // B1D0 - B1DF
	0xB1E0, 0xB1E1, 0xB1E2, 0xB1E3, 0xB1E4, 0xB1E5, 0xB1E6, 0xB1E7, 0xB1E8, 0xB1E9, 0xB1EA, 0xB1EB, 0xB1EC, 0xB1ED, 0xB1EE, 0xB1EF,   // B1E0 - B1EF
	0xB1F0, 0xB1F1, 0xB1F2, 0xB1F3, 0xB1F4, 0xB1F5, 0xB1F6, 0xB1F7, 0xB1F8, 0xB1F9, 0xB1FA, 0xB1FB, 0xB1FC, 0xB1FD, 0xB1FE, 0xB1FF,   // B1F0 - B1FF
	0xB200, 0xB201, 0xB202, 0xB203, 0xB204, 0xB205, 0xB206, 0xB207, 0xB208, 0xB209, 0xB20A, 0xB20B, 0xB20C, 0xB20D, 0xB20E, 0xB20F,   // B200 - B20F
	0xB210, 0xB211, 0xB212, 0xB213, 0xB214, 0xB215, 0xB216, 0xB217, 0xB218, 0xB219, 0xB21A, 0xB21B, 0xB21C, 0xB21D, 0xB21E, 0xB21F,   // B210 - B21F
	0xB220, 0xB221, 0xB222, 0xB223, 0xB224, 0xB225, 0xB226, 0xB227, 0xB228, 0xB229, 0xB22A, 0xB22B, 0xB22C, 0xB22D, 0xB22E, 0xB22F,   // B220 - B22F
	0xB230, 0xB231, 0xB232, 0xB233, 0xB234, 0xB235, 0xB236, 0xB237, 0xB238, 0xB239, 0xB23A, 0xB23B, 0xB23C, 0xB23D, 0xB23E, 0xB23F,   // B230 - B23F
	0xB240, 0xB241, 0xB242, 0xB243, 0xB244, 0xB245, 0xB246, 0xB247, 0xB248, 0xB249, 0xB24A, 0xB24B, 0xB24C, 0xB24D, 0xB24E, 0xB24F,   // B240 - B24F
	0xB250, 0xB251, 0xB252, 0xB253, 0xB254, 0xB255, 0xB256, 0xB257, 0xB258, 0xB259, 0xB25A, 0xB25B, 0xB25C, 0xB25D, 0xB25E, 0xB25F,   // B250 - B25F
	0xB260, 0xB261, 0xB262, 0xB263, 0xB264, 0xB265, 0xB266, 0xB267, 0xB268, 0xB269, 0xB26A, 0xB26B, 0xB26C, 0xB26D, 0xB26E, 0xB26F,   // B260 - B26F
	0xB270, 0xB271, 0xB272, 0xB273, 0xB274, 0xB275, 0xB276, 0xB277, 0xB278, 0xB279, 0xB27A, 0xB27B, 0xB27C, 0xB27D, 0xB27E, 0xB27F,   // B270 - B27F
	0xB280, 0xB281, 0xB282, 0xB283, 0xB284, 0xB285, 0xB286, 0xB287, 0xB288, 0xB289, 0xB28A, 0xB28B, 0xB28C, 0xB28D, 0xB28E, 0xB28F,   // B280 - B28F
	0xB290, 0xB291, 0xB292, 0xB293, 0xB294, 0xB295, 0xB296, 0xB297, 0xB298, 0xB299, 0xB29A, 0xB29B, 0xB29C, 0xB29D, 0xB29E, 0xB29F,   // B290 - B29F
	0xB2A0, 0xB2A1, 0xB2A2, 0xB2A3, 0xB2A4, 0xB2A5, 0xB2A6, 0xB2A7, 0xB2A8, 0xB2A9, 0xB2AA, 0xB2AB, 0xB2AC, 0xB2AD, 0xB2AE, 0xB2AF,   // B2A0 - B2AF
	0xB2B0, 0xB2B1, 0xB2B2, 0xB2B3, 0xB2B4, 0xB2B5, 0xB2B6, 0xB2B7, 0xB2B8, 0xB2B9, 0xB2BA, 0xB2BB, 0xB2BC, 0xB2BD, 0xB2BE, 0xB2BF,   // B2B0 - B2BF
	0xB2C0, 0xB2C1, 0xB2C2, 0xB2C3, 0xB2C4, 0xB2C5, 0xB2C6, 0xB2C7, 0xB2C8, 0xB2C9, 0xB2CA, 0xB2CB, 0xB2CC, 0xB2CD, 0xB2CE, 0xB2CF,   // B2C0 - B2CF
	0xB2D0, 0xB2D1, 0xB2D2, 0xB2D3, 0xB2D4, 0xB2D5, 0xB2D6, 0xB2D7, 0xB2D8, 0xB2D9, 0xB2DA, 0xB2DB, 0xB2DC, 0xB2DD, 0xB2DE, 0xB2DF,   // B2D0 - B2DF
	0xB2E0, 0xB2E1, 0xB2E2, 0xB2E3, 0xB2E4, 0xB2E5, 0xB2E6, 0xB2E7, 0xB2E8, 0xB2E9, 0xB2EA, 0xB2EB, 0xB2EC, 0xB2ED, 0xB2EE, 0xB2EF,   // B2E0 - B2EF
	0xB2F0, 0xB2F1, 0xB2F2, 0xB2F3, 0xB2F4, 0xB2F5, 0xB2F6, 0xB2F7, 0xB2F8, 0xB2F9, 0xB2FA, 0xB2FB, 0xB2FC, 0xB2FD, 0xB2FE, 0xB2FF,   // B2F0 - B2FF
	0xB300, 0xB301, 0xB302, 0xB303, 0xB304, 0xB305, 0xB306, 0xB307, 0xB308, 0xB309, 0xB30A, 0xB30B, 0xB30C, 0xB30D, 0xB30E, 0xB30F,   // B300 - B30F
	0xB310, 0xB311, 0xB312, 0xB313, 0xB314, 0xB315, 0xB316, 0xB317, 0xB318, 0xB319, 0xB31A, 0xB31B, 0xB31C, 0xB31D, 0xB31E, 0xB31F,   // B310 - B31F
	0xB320, 0xB321, 0xB322, 0xB323, 0xB324, 0xB325, 0xB326, 0xB327, 0xB328, 0xB329, 0xB32A, 0xB32B, 0xB32C, 0xB32D, 0xB32E, 0xB32F,   // B320 - B32F
	0xB330, 0xB331, 0xB332, 0xB333, 0xB334, 0xB335, 0xB336, 0xB337, 0xB338, 0xB339, 0xB33A, 0xB33B, 0xB33C, 0xB33D, 0xB33E, 0xB33F,   // B330 - B33F
	0xB340, 0xB341, 0xB342, 0xB343, 0xB344, 0xB345, 0xB346, 0xB347, 0xB348, 0xB349, 0xB34A, 0xB34B, 0xB34C, 0xB34D, 0xB34E, 0xB34F,   // B340 - B34F
	0xB350, 0xB351, 0xB352, 0xB353, 0xB354, 0xB355, 0xB356, 0xB357, 0xB358, 0xB359, 0xB35A, 0xB35B, 0xB35C, 0xB35D, 0xB35E, 0xB35F,   // B350 - B35F
	0xB360, 0xB361, 0xB362, 0xB363, 0xB364, 0xB365, 0xB366, 0xB367, 0xB368, 0xB369, 0xB36A, 0xB36B, 0xB36C, 0xB36D, 0xB36E, 0xB36F,   // B360 - B36F
	0xB370, 0xB371, 0xB372, 0xB373, 0xB374, 0xB375, 0xB376, 0xB377, 0xB378, 0xB379, 0xB37A, 0xB37B, 0xB37C, 0xB37D, 0xB37E, 0xB37F,   // B370 - B37F
	0xB380, 0xB381, 0xB382, 0xB383, 0xB384, 0xB385, 0xB386, 0xB387, 0xB388, 0xB389, 0xB38A, 0xB38B, 0xB38C, 0xB38D, 0xB38E, 0xB38F,   // B380 - B38F
	0xB390, 0xB391, 0xB392, 0xB393, 0xB394, 0xB395, 0xB396, 0xB397, 0xB398, 0xB399, 0xB39A, 0xB39B, 0xB39C, 0xB39D, 0xB39E, 0xB39F,   // B390 - B39F
	0xB3A0, 0xB3A1, 0xB3A2, 0xB3A3, 0xB3A4, 0xB3A5, 0xB3A6, 0xB3A7, 0xB3A8, 0xB3A9, 0xB3AA, 0xB3AB, 0xB3AC, 0xB3AD, 0xB3AE, 0xB3AF,   // B3A0 - B3AF
	0xB3B0, 0xB3B1, 0xB3B2, 0xB3B3, 0xB3B4, 0xB3B5, 0xB3B6, 0xB3B7, 0xB3B8, 0xB3B9, 0xB3BA, 0xB3BB, 0xB3BC, 0xB3BD, 0xB3BE, 0xB3BF,   // B3B0 - B3BF
	0xB3C0, 0xB3C1, 0xB3C2, 0xB3C3, 0xB3C4, 0xB3C5, 0xB3C6, 0xB3C7, 0xB3C8, 0xB3C9, 0xB3CA, 0xB3CB, 0xB3CC, 0xB3CD, 0xB3CE, 0xB3CF,   // B3C0 - B3CF
	0xB3D0, 0xB3D1, 0xB3D2, 0xB3D3, 0xB3D4, 0xB3D5, 0xB3D6, 0xB3D7, 0xB3D8, 0xB3D9, 0xB3DA, 0xB3DB, 0xB3DC, 0xB3DD, 0xB3DE, 0xB3DF,   // B3D0 - B3DF
	0xB3E0, 0xB3E1, 0xB3E2, 0xB3E3, 0xB3E4, 0xB3E5, 0xB3E6, 0xB3E7, 0xB3E8, 0xB3E9, 0xB3EA, 0xB3EB, 0xB3EC, 0xB3ED, 0xB3EE, 0xB3EF,   // B3E0 - B3EF
	0xB3F0, 0xB3F1, 0xB3F2, 0xB3F3, 0xB3F4, 0xB3F5, 0xB3F6, 0xB3F7, 0xB3F8, 0xB3F9, 0xB3FA, 0xB3FB, 0xB3FC, 0xB3FD, 0xB3FE, 0xB3FF,   // B3F0 - B3FF
	0xB400, 0xB401, 0xB402, 0xB403, 0xB404, 0xB405, 0xB406, 0xB407, 0xB408, 0xB409, 0xB40A, 0xB40B, 0xB40C, 0xB40D, 0xB40E, 0xB40F,   // B400 - B40F
	0xB410, 0xB411, 0xB412, 0xB413, 0xB414, 0xB415, 0xB416, 0xB417, 0xB418, 0xB419, 0xB41A, 0xB41B, 0xB41C, 0xB41D, 0xB41E, 0xB41F,   // B410 - B41F
	0xB420, 0xB421, 0xB422, 0xB423, 0xB424, 0xB425, 0xB426, 0xB427, 0xB428, 0xB429, 0xB42A, 0xB42B, 0xB42C, 0xB42D, 0xB42E, 0xB42F,   // B420 - B42F
	0xB430, 0xB431, 0xB432, 0xB433, 0xB434, 0xB435, 0xB436, 0xB437, 0xB438, 0xB439, 0xB43A, 0xB43B, 0xB43C, 0xB43D, 0xB43E, 0xB43F,   // B430 - B43F
	0xB440, 0xB441, 0xB442, 0xB443, 0xB444, 0xB445, 0xB446, 0xB447, 0xB448, 0xB449, 0xB44A, 0xB44B, 0xB44C, 0xB44D, 0xB44E, 0xB44F,   // B440 - B44F
	0xB450, 0xB451, 0xB452, 0xB453, 0xB454, 0xB455, 0xB456, 0xB457, 0xB458, 0xB459, 0xB45A, 0xB45B, 0xB45C, 0xB45D, 0xB45E, 0xB45F,   // B450 - B45F
	0xB460, 0xB461, 0xB462, 0xB463, 0xB464, 0xB465, 0xB466, 0xB467, 0xB468, 0xB469, 0xB46A, 0xB46B, 0xB46C, 0xB46D, 0xB46E, 0xB46F,   // B460 - B46F
	0xB470, 0xB471, 0xB472, 0xB473, 0xB474, 0xB475, 0xB476, 0xB477, 0xB478, 0xB479, 0xB47A, 0xB47B, 0xB47C, 0xB47D, 0xB47E, 0xB47F,   // B470 - B47F
	0xB480, 0xB481, 0xB482, 0xB483, 0xB484, 0xB485, 0xB486, 0xB487, 0xB488, 0xB489, 0xB48A, 0xB48B, 0xB48C, 0xB48D, 0xB48E, 0xB48F,   // B480 - B48F
	0xB490, 0xB491, 0xB492, 0xB493, 0xB494, 0xB495, 0xB496, 0xB497, 0xB498, 0xB499, 0xB49A, 0xB49B, 0xB49C, 0xB49D, 0xB49E, 0xB49F,   // B490 - B49F
	0xB4A0, 0xB4A1, 0xB4A2, 0xB4A3, 0xB4A4, 0xB4A5, 0xB4A6, 0xB4A7, 0xB4A8, 0xB4A9, 0xB4AA, 0xB4AB, 0xB4AC, 0xB4AD, 0xB4AE, 0xB4AF,   // B4A0 - B4AF
	0xB4B0, 0xB4B1, 0xB4B2, 0xB4B3, 0xB4B4, 0xB4B5, 0xB4B6, 0xB4B7, 0xB4B8, 0xB4B9, 0xB4BA, 0xB4BB, 0xB4BC, 0xB4BD, 0xB4BE, 0xB4BF,   // B4B0 - B4BF
	0xB4C0, 0xB4C1, 0xB4C2, 0xB4C3, 0xB4C4, 0xB4C5, 0xB4C6, 0xB4C7, 0xB4C8, 0xB4C9, 0xB4CA, 0xB4CB, 0xB4CC, 0xB4CD, 0xB4CE, 0xB4CF,   // B4C0 - B4CF
	0xB4D0, 0xB4D1, 0xB4D2, 0xB4D3, 0xB4D4, 0xB4D5, 0xB4D6, 0xB4D7, 0xB4D8, 0xB4D9, 0xB4DA, 0xB4DB, 0xB4DC, 0xB4DD, 0xB4DE, 0xB4DF,   // B4D0 - B4DF
	0xB4E0, 0xB4E1, 0xB4E2, 0xB4E3, 0xB4E4, 0xB4E5, 0xB4E6, 0xB4E7, 0xB4E8, 0xB4E9, 0xB4EA, 0xB4EB, 0xB4EC, 0xB4ED, 0xB4EE, 0xB4EF,   // B4E0 - B4EF
	0xB4F0, 0xB4F1, 0xB4F2, 0xB4F3, 0xB4F4, 0xB4F5, 0xB4F6, 0xB4F7, 0xB4F8, 0xB4F9, 0xB4FA, 0xB4FB, 0xB4FC, 0xB4FD, 0xB4FE, 0xB4FF,   // B4F0 - B4FF
	0xB500, 0xB501, 0xB502, 0xB503, 0xB504, 0xB505, 0xB506, 0xB507, 0xB508, 0xB509, 0xB50A, 0xB50B, 0xB50C, 0xB50D, 0xB50E, 0xB50F,   // B500 - B50F
	0xB510, 0xB511, 0xB512, 0xB513, 0xB514, 0xB515, 0xB516, 0xB517, 0xB518, 0xB519, 0xB51A, 0xB51B, 0xB51C, 0xB51D, 0xB51E, 0xB51F,   // B510 - B51F
	0xB520, 0xB521, 0xB522, 0xB523, 0xB524, 0xB525, 0xB526, 0xB527, 0xB528, 0xB529, 0xB52A, 0xB52B, 0xB52C, 0xB52D, 0xB52E, 0xB52F,   // B520 - B52F
	0xB530, 0xB531, 0xB532, 0xB533, 0xB534, 0xB535, 0xB536, 0xB537, 0xB538, 0xB539, 0xB53A, 0xB53B, 0xB53C, 0xB53D, 0xB53E, 0xB53F,   // B530 - B53F
	0xB540, 0xB541, 0xB542, 0xB543, 0xB544, 0xB545, 0xB546, 0xB547, 0xB548, 0xB549, 0xB54A, 0xB54B, 0xB54C, 0xB54D, 0xB54E, 0xB54F,   // B540 - B54F
	0xB550, 0xB551, 0xB552, 0xB553, 0xB554, 0xB555, 0xB556, 0xB557, 0xB558, 0xB559, 0xB55A, 0xB55B, 0xB55C, 0xB55D, 0xB55E, 0xB55F,   // B550 - B55F
	0xB560, 0xB561, 0xB562, 0xB563, 0xB564, 0xB565, 0xB566, 0xB567, 0xB568, 0xB569, 0xB56A, 0xB56B, 0xB56C, 0xB56D, 0xB56E, 0xB56F,   // B560 - B56F
	0xB570, 0xB571, 0xB572, 0xB573, 0xB574, 0xB575, 0xB576, 0xB577, 0xB578, 0xB579, 0xB57A, 0xB57B, 0xB57C, 0xB57D, 0xB57E, 0xB57F,   // B570 - B57F
	0xB580, 0xB581, 0xB582, 0xB583, 0xB584, 0xB585, 0xB586, 0xB587, 0xB588, 0xB589, 0xB58A, 0xB58B, 0xB58C, 0xB58D, 0xB58E, 0xB58F,   // B580 - B58F
	0xB590, 0xB591, 0xB592, 0xB593, 0xB594, 0xB595, 0xB596, 0xB597, 0xB598, 0xB599, 0xB59A, 0xB59B, 0xB59C, 0xB59D, 0xB59E, 0xB59F,   // B590 - B59F
	0xB5A0, 0xB5A1, 0xB5A2, 0xB5A3, 0xB5A4, 0xB5A5, 0xB5A6, 0xB5A7, 0xB5A8, 0xB5A9, 0xB5AA, 0xB5AB, 0xB5AC, 0xB5AD, 0xB5AE, 0xB5AF,   // B5A0 - B5AF
	0xB5B0, 0xB5B1, 0xB5B2, 0xB5B3, 0xB5B4, 0xB5B5, 0xB5B6, 0xB5B7, 0xB5B8, 0xB5B9, 0xB5BA, 0xB5BB, 0xB5BC, 0xB5BD, 0xB5BE, 0xB5BF,   // B5B0 - B5BF
	0xB5C0, 0xB5C1, 0xB5C2, 0xB5C3, 0xB5C4, 0xB5C5, 0xB5C6, 0xB5C7, 0xB5C8, 0xB5C9, 0xB5CA, 0xB5CB, 0xB5CC, 0xB5CD, 0xB5CE, 0xB5CF,   // B5C0 - B5CF
	0xB5D0, 0xB5D1, 0xB5D2, 0xB5D3, 0xB5D4, 0xB5D5, 0xB5D6, 0xB5D7, 0xB5D8, 0xB5D9, 0xB5DA, 0xB5DB, 0xB5DC, 0xB5DD, 0xB5DE, 0xB5DF,   // B5D0 - B5DF
	0xB5E0, 0xB5E1, 0xB5E2, 0xB5E3, 0xB5E4, 0xB5E5, 0xB5E6, 0xB5E7, 0xB5E8, 0xB5E9, 0xB5EA, 0xB5EB, 0xB5EC, 0xB5ED, 0xB5EE, 0xB5EF,   // B5E0 - B5EF
	0xB5F0, 0xB5F1, 0xB5F2, 0xB5F3, 0xB5F4, 0xB5F5, 0xB5F6, 0xB5F7, 0xB5F8, 0xB5F9, 0xB5FA, 0xB5FB, 0xB5FC, 0xB5FD, 0xB5FE, 0xB5FF,   // B5F0 - B5FF
	0xB600, 0xB601, 0xB602, 0xB603, 0xB604, 0xB605, 0xB606, 0xB607, 0xB608, 0xB609, 0xB60A, 0xB60B, 0xB60C, 0xB60D, 0xB60E, 0xB60F,   // B600 - B60F
	0xB610, 0xB611, 0xB612, 0xB613, 0xB614, 0xB615, 0xB616, 0xB617, 0xB618, 0xB619, 0xB61A, 0xB61B, 0xB61C, 0xB61D, 0xB61E, 0xB61F,   // B610 - B61F
	0xB620, 0xB621, 0xB622, 0xB623, 0xB624, 0xB625, 0xB626, 0xB627, 0xB628, 0xB629, 0xB62A, 0xB62B, 0xB62C, 0xB62D, 0xB62E, 0xB62F,   // B620 - B62F
	0xB630, 0xB631, 0xB632, 0xB633, 0xB634, 0xB635, 0xB636, 0xB637, 0xB638, 0xB639, 0xB63A, 0xB63B, 0xB63C, 0xB63D, 0xB63E, 0xB63F,   // B630 - B63F
	0xB640, 0xB641, 0xB642, 0xB643, 0xB644, 0xB645, 0xB646, 0xB647, 0xB648, 0xB649, 0xB64A, 0xB64B, 0xB64C, 0xB64D, 0xB64E, 0xB64F,   // B640 - B64F
	0xB650, 0xB651, 0xB652, 0xB653, 0xB654, 0xB655, 0xB656, 0xB657, 0xB658, 0xB659, 0xB65A, 0xB65B, 0xB65C, 0xB65D, 0xB65E, 0xB65F,   // B650 - B65F
	0xB660, 0xB661, 0xB662, 0xB663, 0xB664, 0xB665, 0xB666, 0xB667, 0xB668, 0xB669, 0xB66A, 0xB66B, 0xB66C, 0xB66D, 0xB66E, 0xB66F,   // B660 - B66F
	0xB670, 0xB671, 0xB672, 0xB673, 0xB674, 0xB675, 0xB676, 0xB677, 0xB678, 0xB679, 0xB67A, 0xB67B, 0xB67C, 0xB67D, 0xB67E, 0xB67F,   // B670 - B67F
	0xB680, 0xB681, 0xB682, 0xB683, 0xB684, 0xB685, 0xB686, 0xB687, 0xB688, 0xB689, 0xB68A, 0xB68B, 0xB68C, 0xB68D, 0xB68E, 0xB68F,   // B680 - B68F
	0xB690, 0xB691, 0xB692, 0xB693, 0xB694, 0xB695, 0xB696, 0xB697, 0xB698, 0xB699, 0xB69A, 0xB69B, 0xB69C, 0xB69D, 0xB69E, 0xB69F,   // B690 - B69F
	0xB6A0, 0xB6A1, 0xB6A2, 0xB6A3, 0xB6A4, 0xB6A5, 0xB6A6, 0xB6A7, 0xB6A8, 0xB6A9, 0xB6AA, 0xB6AB, 0xB6AC, 0xB6AD, 0xB6AE, 0xB6AF,   // B6A0 - B6AF
	0xB6B0, 0xB6B1, 0xB6B2, 0xB6B3, 0xB6B4, 0xB6B5, 0xB6B6, 0xB6B7, 0xB6B8, 0xB6B9, 0xB6BA, 0xB6BB, 0xB6BC, 0xB6BD, 0xB6BE, 0xB6BF,   // B6B0 - B6BF
	0xB6C0, 0xB6C1, 0xB6C2, 0xB6C3, 0xB6C4, 0xB6C5, 0xB6C6, 0xB6C7, 0xB6C8, 0xB6C9, 0xB6CA, 0xB6CB, 0xB6CC, 0xB6CD, 0xB6CE, 0xB6CF,   // B6C0 - B6CF
	0xB6D0, 0xB6D1, 0xB6D2, 0xB6D3, 0xB6D4, 0xB6D5, 0xB6D6, 0xB6D7, 0xB6D8, 0xB6D9, 0xB6DA, 0xB6DB, 0xB6DC, 0xB6DD, 0xB6DE, 0xB6DF,   // B6D0 - B6DF
	0xB6E0, 0xB6E1, 0xB6E2, 0xB6E3, 0xB6E4, 0xB6E5, 0xB6E6, 0xB6E7, 0xB6E8, 0xB6E9, 0xB6EA, 0xB6EB, 0xB6EC, 0xB6ED, 0xB6EE, 0xB6EF,   // B6E0 - B6EF
	0xB6F0, 0xB6F1, 0xB6F2, 0xB6F3, 0xB6F4, 0xB6F5, 0xB6F6, 0xB6F7, 0xB6F8, 0xB6F9, 0xB6FA, 0xB6FB, 0xB6FC, 0xB6FD, 0xB6FE, 0xB6FF,   // B6F0 - B6FF
	0xB700, 0xB701, 0xB702, 0xB703, 0xB704, 0xB705, 0xB706, 0xB707, 0xB708, 0xB709, 0xB70A, 0xB70B, 0xB70C, 0xB70D, 0xB70E, 0xB70F,   // B700 - B70F
	0xB710, 0xB711, 0xB712, 0xB713, 0xB714, 0xB715, 0xB716, 0xB717, 0xB718, 0xB719, 0xB71A, 0xB71B, 0xB71C, 0xB71D, 0xB71E, 0xB71F,   // B710 - B71F
	0xB720, 0xB721, 0xB722, 0xB723, 0xB724, 0xB725, 0xB726, 0xB727, 0xB728, 0xB729, 0xB72A, 0xB72B, 0xB72C, 0xB72D, 0xB72E, 0xB72F,   // B720 - B72F
	0xB730, 0xB731, 0xB732, 0xB733, 0xB734, 0xB735, 0xB736, 0xB737, 0xB738, 0xB739, 0xB73A, 0xB73B, 0xB73C, 0xB73D, 0xB73E, 0xB73F,   // B730 - B73F
	0xB740, 0xB741, 0xB742, 0xB743, 0xB744, 0xB745, 0xB746, 0xB747, 0xB748, 0xB749, 0xB74A, 0xB74B, 0xB74C, 0xB74D, 0xB74E, 0xB74F,   // B740 - B74F
	0xB750, 0xB751, 0xB752, 0xB753, 0xB754, 0xB755, 0xB756, 0xB757, 0xB758, 0xB759, 0xB75A, 0xB75B, 0xB75C, 0xB75D, 0xB75E, 0xB75F,   // B750 - B75F
	0xB760, 0xB761, 0xB762, 0xB763, 0xB764, 0xB765, 0xB766, 0xB767, 0xB768, 0xB769, 0xB76A, 0xB76B, 0xB76C, 0xB76D, 0xB76E, 0xB76F,   // B760 - B76F
	0xB770, 0xB771, 0xB772, 0xB773, 0xB774, 0xB775, 0xB776, 0xB777, 0xB778, 0xB779, 0xB77A, 0xB77B, 0xB77C, 0xB77D, 0xB77E, 0xB77F,   // B770 - B77F
	0xB780, 0xB781, 0xB782, 0xB783, 0xB784, 0xB785, 0xB786, 0xB787, 0xB788, 0xB789, 0xB78A, 0xB78B, 0xB78C, 0xB78D, 0xB78E, 0xB78F,   // B780 - B78F
	0xB790, 0xB791, 0xB792, 0xB793, 0xB794, 0xB795, 0xB796, 0xB797, 0xB798, 0xB799, 0xB79A, 0xB79B, 0xB79C, 0xB79D, 0xB79E, 0xB79F,   // B790 - B79F
	0xB7A0, 0xB7A1, 0xB7A2, 0xB7A3, 0xB7A4, 0xB7A5, 0xB7A6, 0xB7A7, 0xB7A8, 0xB7A9, 0xB7AA, 0xB7AB, 0xB7AC, 0xB7AD, 0xB7AE, 0xB7AF,   // B7A0 - B7AF
	0xB7B0, 0xB7B1, 0xB7B2, 0xB7B3, 0xB7B4, 0xB7B5, 0xB7B6, 0xB7B7, 0xB7B8, 0xB7B9, 0xB7BA, 0xB7BB, 0xB7BC, 0xB7BD, 0xB7BE, 0xB7BF,   // B7B0 - B7BF
	0xB7C0, 0xB7C1, 0xB7C2, 0xB7C3, 0xB7C4, 0xB7C5, 0xB7C6, 0xB7C7, 0xB7C8, 0xB7C9, 0xB7CA, 0xB7CB, 0xB7CC, 0xB7CD, 0xB7CE, 0xB7CF,   // B7C0 - B7CF
	0xB7D0, 0xB7D1, 0xB7D2, 0xB7D3, 0xB7D4, 0xB7D5, 0xB7D6, 0xB7D7, 0xB7D8, 0xB7D9, 0xB7DA, 0xB7DB, 0xB7DC, 0xB7DD, 0xB7DE, 0xB7DF,   // B7D0 - B7DF
	0xB7E0, 0xB7E1, 0xB7E2, 0xB7E3, 0xB7E4, 0xB7E5, 0xB7E6, 0xB7E7, 0xB7E8, 0xB7E9, 0xB7EA, 0xB7EB, 0xB7EC, 0xB7ED, 0xB7EE, 0xB7EF,   // B7E0 - B7EF
	0xB7F0, 0xB7F1, 0xB7F2, 0xB7F3, 0xB7F4, 0xB7F5, 0xB7F6, 0xB7F7, 0xB7F8, 0xB7F9, 0xB7FA, 0xB7FB, 0xB7FC, 0xB7FD, 0xB7FE, 0xB7FF,   // B7F0 - B7FF
	0xB800, 0xB801, 0xB802, 0xB803, 0xB804, 0xB805, 0xB806, 0xB807, 0xB808, 0xB809, 0xB80A, 0xB80B, 0xB80C, 0xB80D, 0xB80E, 0xB80F,   // B800 - B80F
	0xB810, 0xB811, 0xB812, 0xB813, 0xB814, 0xB815, 0xB816, 0xB817, 0xB818, 0xB819, 0xB81A, 0xB81B, 0xB81C, 0xB81D, 0xB81E, 0xB81F,   // B810 - B81F
	0xB820, 0xB821, 0xB822, 0xB823, 0xB824, 0xB825, 0xB826, 0xB827, 0xB828, 0xB829, 0xB82A, 0xB82B, 0xB82C, 0xB82D, 0xB82E, 0xB82F,   // B820 - B82F
	0xB830, 0xB831, 0xB832, 0xB833, 0xB834, 0xB835, 0xB836, 0xB837, 0xB838, 0xB839, 0xB83A, 0xB83B, 0xB83C, 0xB83D, 0xB83E, 0xB83F,   // B830 - B83F
	0xB840, 0xB841, 0xB842, 0xB843, 0xB844, 0xB845, 0xB846, 0xB847, 0xB848, 0xB849, 0xB84A, 0xB84B, 0xB84C, 0xB84D, 0xB84E, 0xB84F,   // B840 - B84F
	0xB850, 0xB851, 0xB852, 0xB853, 0xB854, 0xB855, 0xB856, 0xB857, 0xB858, 0xB859, 0xB85A, 0xB85B, 0xB85C, 0xB85D, 0xB85E, 0xB85F,   // B850 - B85F
	0xB860, 0xB861, 0xB862, 0xB863, 0xB864, 0xB865, 0xB866, 0xB867, 0xB868, 0xB869, 0xB86A, 0xB86B, 0xB86C, 0xB86D, 0xB86E, 0xB86F,   // B860 - B86F
	0xB870, 0xB871, 0xB872, 0xB873, 0xB874, 0xB875, 0xB876, 0xB877, 0xB878, 0xB879, 0xB87A, 0xB87B, 0xB87C, 0xB87D, 0xB87E, 0xB87F,   // B870 - B87F
	0xB880, 0xB881, 0xB882, 0xB883, 0xB884, 0xB885, 0xB886, 0xB887, 0xB888, 0xB889, 0xB88A, 0xB88B, 0xB88C, 0xB88D, 0xB88E, 0xB88F,   // B880 - B88F
	0xB890, 0xB891, 0xB892, 0xB893, 0xB894, 0xB895, 0xB896, 0xB897, 0xB898, 0xB899, 0xB89A, 0xB89B, 0xB89C, 0xB89D, 0xB89E, 0xB89F,   // B890 - B89F
	0xB8A0, 0xB8A1, 0xB8A2, 0xB8A3, 0xB8A4, 0xB8A5, 0xB8A6, 0xB8A7, 0xB8A8, 0xB8A9, 0xB8AA, 0xB8AB, 0xB8AC, 0xB8AD, 0xB8AE, 0xB8AF,   // B8A0 - B8AF
	0xB8B0, 0xB8B1, 0xB8B2, 0xB8B3, 0xB8B4, 0xB8B5, 0xB8B6, 0xB8B7, 0xB8B8, 0xB8B9, 0xB8BA, 0xB8BB, 0xB8BC, 0xB8BD, 0xB8BE, 0xB8BF,   // B8B0 - B8BF
	0xB8C0, 0xB8C1, 0xB8C2, 0xB8C3, 0xB8C4, 0xB8C5, 0xB8C6, 0xB8C7, 0xB8C8, 0xB8C9, 0xB8CA, 0xB8CB, 0xB8CC, 0xB8CD, 0xB8CE, 0xB8CF,   // B8C0 - B8CF
	0xB8D0, 0xB8D1, 0xB8D2, 0xB8D3, 0xB8D4, 0xB8D5, 0xB8D6, 0xB8D7, 0xB8D8, 0xB8D9, 0xB8DA, 0xB8DB, 0xB8DC, 0xB8DD, 0xB8DE, 0xB8DF,   // B8D0 - B8DF
	0xB8E0, 0xB8E1, 0xB8E2, 0xB8E3, 0xB8E4, 0xB8E5, 0xB8E6, 0xB8E7, 0xB8E8, 0xB8E9, 0xB8EA, 0xB8EB, 0xB8EC, 0xB8ED, 0xB8EE, 0xB8EF,   // B8E0 - B8EF
	0xB8F0, 0xB8F1, 0xB8F2, 0xB8F3, 0xB8F4, 0xB8F5, 0xB8F6, 0xB8F7, 0xB8F8, 0xB8F9, 0xB8FA, 0xB8FB, 0xB8FC, 0xB8FD, 0xB8FE, 0xB8FF,   // B8F0 - B8FF
	0xB900, 0xB901, 0xB902, 0xB903, 0xB904, 0xB905, 0xB906, 0xB907, 0xB908, 0xB909, 0xB90A, 0xB90B, 0xB90C, 0xB90D, 0xB90E, 0xB90F,   // B900 - B90F
	0xB910, 0xB911, 0xB912, 0xB913, 0xB914, 0xB915, 0xB916, 0xB917, 0xB918, 0xB919, 0xB91A, 0xB91B, 0xB91C, 0xB91D, 0xB91E, 0xB91F,   // B910 - B91F
	0xB920, 0xB921, 0xB922, 0xB923, 0xB924, 0xB925, 0xB926, 0xB927, 0xB928, 0xB929, 0xB92A, 0xB92B, 0xB92C, 0xB92D, 0xB92E, 0xB92F,   // B920 - B92F
	0xB930, 0xB931, 0xB932, 0xB933, 0xB934, 0xB935, 0xB936, 0xB937, 0xB938, 0xB939, 0xB93A, 0xB93B, 0xB93C, 0xB93D, 0xB93E, 0xB93F,   // B930 - B93F
	0xB940, 0xB941, 0xB942, 0xB943, 0xB944, 0xB945, 0xB946, 0xB947, 0xB948, 0xB949, 0xB94A, 0xB94B, 0xB94C, 0xB94D, 0xB94E, 0xB94F,   // B940 - B94F
	0xB950, 0xB951, 0xB952, 0xB953, 0xB954, 0xB955, 0xB956, 0xB957, 0xB958, 0xB959, 0xB95A, 0xB95B, 0xB95C, 0xB95D, 0xB95E, 0xB95F,   // B950 - B95F
	0xB960, 0xB961, 0xB962, 0xB963, 0xB964, 0xB965, 0xB966, 0xB967, 0xB968, 0xB969, 0xB96A, 0xB96B, 0xB96C, 0xB96D, 0xB96E, 0xB96F,   // B960 - B96F
	0xB970, 0xB971, 0xB972, 0xB973, 0xB974, 0xB975, 0xB976, 0xB977, 0xB978, 0xB979, 0xB97A, 0xB97B, 0xB97C, 0xB97D, 0xB97E, 0xB97F,   // B970 - B97F
	0xB980, 0xB981, 0xB982, 0xB983, 0xB984, 0xB985, 0xB986, 0xB987, 0xB988, 0xB989, 0xB98A, 0xB98B, 0xB98C, 0xB98D, 0xB98E, 0xB98F,   // B980 - B98F
	0xB990, 0xB991, 0xB992, 0xB993, 0xB994, 0xB995, 0xB996, 0xB997, 0xB998, 0xB999, 0xB99A, 0xB99B, 0xB99C, 0xB99D, 0xB99E, 0xB99F,   // B990 - B99F
	0xB9A0, 0xB9A1, 0xB9A2, 0xB9A3, 0xB9A4, 0xB9A5, 0xB9A6, 0xB9A7, 0xB9A8, 0xB9A9, 0xB9AA, 0xB9AB, 0xB9AC, 0xB9AD, 0xB9AE, 0xB9AF,   // B9A0 - B9AF
	0xB9B0, 0xB9B1, 0xB9B2, 0xB9B3, 0xB9B4, 0xB9B5, 0xB9B6, 0xB9B7, 0xB9B8, 0xB9B9, 0xB9BA, 0xB9BB, 0xB9BC, 0xB9BD, 0xB9BE, 0xB9BF,   // B9B0 - B9BF
	0xB9C0, 0xB9C1, 0xB9C2, 0xB9C3, 0xB9C4, 0xB9C5, 0xB9C6, 0xB9C7, 0xB9C8, 0xB9C9, 0xB9CA, 0xB9CB, 0xB9CC, 0xB9CD, 0xB9CE, 0xB9CF,   // B9C0 - B9CF
	0xB9D0, 0xB9D1, 0xB9D2, 0xB9D3, 0xB9D4, 0xB9D5, 0xB9D6, 0xB9D7, 0xB9D8, 0xB9D9, 0xB9DA, 0xB9DB, 0xB9DC, 0xB9DD, 0xB9DE, 0xB9DF,   // B9D0 - B9DF
	0xB9E0, 0xB9E1, 0xB9E2, 0xB9E3, 0xB9E4, 0xB9E5, 0xB9E6, 0xB9E7, 0xB9E8, 0xB9E9, 0xB9EA, 0xB9EB, 0xB9EC, 0xB9ED, 0xB9EE, 0xB9EF,   // B9E0 - B9EF
	0xB9F0, 0xB9F1, 0xB9F2, 0xB9F3, 0xB9F4, 0xB9F5, 0xB9F6, 0xB9F7, 0xB9F8, 0xB9F9, 0xB9FA, 0xB9FB, 0xB9FC, 0xB9FD, 0xB9FE, 0xB9FF,   // B9F0 - B9FF
	0xBA00, 0xBA01, 0xBA02, 0xBA03, 0xBA04, 0xBA05, 0xBA06, 0xBA07, 0xBA08, 0xBA09, 0xBA0A, 0xBA0B, 0xBA0C, 0xBA0D, 0xBA0E, 0xBA0F,   // BA00 - BA0F
	0xBA10, 0xBA11, 0xBA12, 0xBA13, 0xBA14, 0xBA15, 0xBA16, 0xBA17, 0xBA18, 0xBA19, 0xBA1A, 0xBA1B, 0xBA1C, 0xBA1D, 0xBA1E, 0xBA1F,   // BA10 - BA1F
	0xBA20, 0xBA21, 0xBA22, 0xBA23, 0xBA24, 0xBA25, 0xBA26, 0xBA27, 0xBA28, 0xBA29, 0xBA2A, 0xBA2B, 0xBA2C, 0xBA2D, 0xBA2E, 0xBA2F,   // BA20 - BA2F
	0xBA30, 0xBA31, 0xBA32, 0xBA33, 0xBA34, 0xBA35, 0xBA36, 0xBA37, 0xBA38, 0xBA39, 0xBA3A, 0xBA3B, 0xBA3C, 0xBA3D, 0xBA3E, 0xBA3F,   // BA30 - BA3F
	0xBA40, 0xBA41, 0xBA42, 0xBA43, 0xBA44, 0xBA45, 0xBA46, 0xBA47, 0xBA48, 0xBA49, 0xBA4A, 0xBA4B, 0xBA4C, 0xBA4D, 0xBA4E, 0xBA4F,   // BA40 - BA4F
	0xBA50, 0xBA51, 0xBA52, 0xBA53, 0xBA54, 0xBA55, 0xBA56, 0xBA57, 0xBA58, 0xBA59, 0xBA5A, 0xBA5B, 0xBA5C, 0xBA5D, 0xBA5E, 0xBA5F,   // BA50 - BA5F
	0xBA60, 0xBA61, 0xBA62, 0xBA63, 0xBA64, 0xBA65, 0xBA66, 0xBA67, 0xBA68, 0xBA69, 0xBA6A, 0xBA6B, 0xBA6C, 0xBA6D, 0xBA6E, 0xBA6F,   // BA60 - BA6F
	0xBA70, 0xBA71, 0xBA72, 0xBA73, 0xBA74, 0xBA75, 0xBA76, 0xBA77, 0xBA78, 0xBA79, 0xBA7A, 0xBA7B, 0xBA7C, 0xBA7D, 0xBA7E, 0xBA7F,   // BA70 - BA7F
	0xBA80, 0xBA81, 0xBA82, 0xBA83, 0xBA84, 0xBA85, 0xBA86, 0xBA87, 0xBA88, 0xBA89, 0xBA8A, 0xBA8B, 0xBA8C, 0xBA8D, 0xBA8E, 0xBA8F,   // BA80 - BA8F
	0xBA90, 0xBA91, 0xBA92, 0xBA93, 0xBA94, 0xBA95, 0xBA96, 0xBA97, 0xBA98, 0xBA99, 0xBA9A, 0xBA9B, 0xBA9C, 0xBA9D, 0xBA9E, 0xBA9F,   // BA90 - BA9F
	0xBAA0, 0xBAA1, 0xBAA2, 0xBAA3, 0xBAA4, 0xBAA5, 0xBAA6, 0xBAA7, 0xBAA8, 0xBAA9, 0xBAAA, 0xBAAB, 0xBAAC, 0xBAAD, 0xBAAE, 0xBAAF,   // BAA0 - BAAF
	0xBAB0, 0xBAB1, 0xBAB2, 0xBAB3, 0xBAB4, 0xBAB5, 0xBAB6, 0xBAB7, 0xBAB8, 0xBAB9, 0xBABA, 0xBABB, 0xBABC, 0xBABD, 0xBABE, 0xBABF,   // BAB0 - BABF
	0xBAC0, 0xBAC1, 0xBAC2, 0xBAC3, 0xBAC4, 0xBAC5, 0xBAC6, 0xBAC7, 0xBAC8, 0xBAC9, 0xBACA, 0xBACB, 0xBACC, 0xBACD, 0xBACE, 0xBACF,   // BAC0 - BACF
	0xBAD0, 0xBAD1, 0xBAD2, 0xBAD3, 0xBAD4, 0xBAD5, 0xBAD6, 0xBAD7, 0xBAD8, 0xBAD9, 0xBADA, 0xBADB, 0xBADC, 0xBADD, 0xBADE, 0xBADF,   // BAD0 - BADF
	0xBAE0, 0xBAE1, 0xBAE2, 0xBAE3, 0xBAE4, 0xBAE5, 0xBAE6, 0xBAE7, 0xBAE8, 0xBAE9, 0xBAEA, 0xBAEB, 0xBAEC, 0xBAED, 0xBAEE, 0xBAEF,   // BAE0 - BAEF
	0xBAF0, 0xBAF1, 0xBAF2, 0xBAF3, 0xBAF4, 0xBAF5, 0xBAF6, 0xBAF7, 0xBAF8, 0xBAF9, 0xBAFA, 0xBAFB, 0xBAFC, 0xBAFD, 0xBAFE, 0xBAFF,   // BAF0 - BAFF
	0xBB00, 0xBB01, 0xBB02, 0xBB03, 0xBB04, 0xBB05, 0xBB06, 0xBB07, 0xBB08, 0xBB09, 0xBB0A, 0xBB0B, 0xBB0C, 0xBB0D, 0xBB0E, 0xBB0F,   // BB00 - BB0F
	0xBB10, 0xBB11, 0xBB12, 0xBB13, 0xBB14, 0xBB15, 0xBB16, 0xBB17, 0xBB18, 0xBB19, 0xBB1A, 0xBB1B, 0xBB1C, 0xBB1D, 0xBB1E, 0xBB1F,   // BB10 - BB1F
	0xBB20, 0xBB21, 0xBB22, 0xBB23, 0xBB24, 0xBB25, 0xBB26, 0xBB27, 0xBB28, 0xBB29, 0xBB2A, 0xBB2B, 0xBB2C, 0xBB2D, 0xBB2E, 0xBB2F,   // BB20 - BB2F
	0xBB30, 0xBB31, 0xBB32, 0xBB33, 0xBB34, 0xBB35, 0xBB36, 0xBB37, 0xBB38, 0xBB39, 0xBB3A, 0xBB3B, 0xBB3C, 0xBB3D, 0xBB3E, 0xBB3F,   // BB30 - BB3F
	0xBB40, 0xBB41, 0xBB42, 0xBB43, 0xBB44, 0xBB45, 0xBB46, 0xBB47, 0xBB48, 0xBB49, 0xBB4A, 0xBB4B, 0xBB4C, 0xBB4D, 0xBB4E, 0xBB4F,   // BB40 - BB4F
	0xBB50, 0xBB51, 0xBB52, 0xBB53, 0xBB54, 0xBB55, 0xBB56, 0xBB57, 0xBB58, 0xBB59, 0xBB5A, 0xBB5B, 0xBB5C, 0xBB5D, 0xBB5E, 0xBB5F,   // BB50 - BB5F
	0xBB60, 0xBB61, 0xBB62, 0xBB63, 0xBB64, 0xBB65, 0xBB66, 0xBB67, 0xBB68, 0xBB69, 0xBB6A, 0xBB6B, 0xBB6C, 0xBB6D, 0xBB6E, 0xBB6F,   // BB60 - BB6F
	0xBB70, 0xBB71, 0xBB72, 0xBB73, 0xBB74, 0xBB75, 0xBB76, 0xBB77, 0xBB78, 0xBB79, 0xBB7A, 0xBB7B, 0xBB7C, 0xBB7D, 0xBB7E, 0xBB7F,   // BB70 - BB7F
	0xBB80, 0xBB81, 0xBB82, 0xBB83, 0xBB84, 0xBB85, 0xBB86, 0xBB87, 0xBB88, 0xBB89, 0xBB8A, 0xBB8B, 0xBB8C, 0xBB8D, 0xBB8E, 0xBB8F,   // BB80 - BB8F
	0xBB90, 0xBB91, 0xBB92, 0xBB93, 0xBB94, 0xBB95, 0xBB96, 0xBB97, 0xBB98, 0xBB99, 0xBB9A, 0xBB9B, 0xBB9C, 0xBB9D, 0xBB9E, 0xBB9F,   // BB90 - BB9F
	0xBBA0, 0xBBA1, 0xBBA2, 0xBBA3, 0xBBA4, 0xBBA5, 0xBBA6, 0xBBA7, 0xBBA8, 0xBBA9, 0xBBAA, 0xBBAB, 0xBBAC, 0xBBAD, 0xBBAE, 0xBBAF,   // BBA0 - BBAF
	0xBBB0, 0xBBB1, 0xBBB2, 0xBBB3, 0xBBB4, 0xBBB5, 0xBBB6, 0xBBB7, 0xBBB8, 0xBBB9, 0xBBBA, 0xBBBB, 0xBBBC, 0xBBBD, 0xBBBE, 0xBBBF,   // BBB0 - BBBF
	0xBBC0, 0xBBC1, 0xBBC2, 0xBBC3, 0xBBC4, 0xBBC5, 0xBBC6, 0xBBC7, 0xBBC8, 0xBBC9, 0xBBCA, 0xBBCB, 0xBBCC, 0xBBCD, 0xBBCE, 0xBBCF,   // BBC0 - BBCF
	0xBBD0, 0xBBD1, 0xBBD2, 0xBBD3, 0xBBD4, 0xBBD5, 0xBBD6, 0xBBD7, 0xBBD8, 0xBBD9, 0xBBDA, 0xBBDB, 0xBBDC, 0xBBDD, 0xBBDE, 0xBBDF,   // BBD0 - BBDF
	0xBBE0, 0xBBE1, 0xBBE2, 0xBBE3, 0xBBE4, 0xBBE5, 0xBBE6, 0xBBE7, 0xBBE8, 0xBBE9, 0xBBEA, 0xBBEB, 0xBBEC, 0xBBED, 0xBBEE, 0xBBEF,   // BBE0 - BBEF
	0xBBF0, 0xBBF1, 0xBBF2, 0xBBF3, 0xBBF4, 0xBBF5, 0xBBF6, 0xBBF7, 0xBBF8, 0xBBF9, 0xBBFA, 0xBBFB, 0xBBFC, 0xBBFD, 0xBBFE, 0xBBFF,   // BBF0 - BBFF
	0xBC00, 0xBC01, 0xBC02, 0xBC03, 0xBC04, 0xBC05, 0xBC06, 0xBC07, 0xBC08, 0xBC09, 0xBC0A, 0xBC0B, 0xBC0C, 0xBC0D, 0xBC0E, 0xBC0F,   // BC00 - BC0F
	0xBC10, 0xBC11, 0xBC12, 0xBC13, 0xBC14, 0xBC15, 0xBC16, 0xBC17, 0xBC18, 0xBC19, 0xBC1A, 0xBC1B, 0xBC1C, 0xBC1D, 0xBC1E, 0xBC1F,   // BC10 - BC1F
	0xBC20, 0xBC21, 0xBC22, 0xBC23, 0xBC24, 0xBC25, 0xBC26, 0xBC27, 0xBC28, 0xBC29, 0xBC2A, 0xBC2B, 0xBC2C, 0xBC2D, 0xBC2E, 0xBC2F,   // BC20 - BC2F
	0xBC30, 0xBC31, 0xBC32, 0xBC33, 0xBC34, 0xBC35, 0xBC36, 0xBC37, 0xBC38, 0xBC39, 0xBC3A, 0xBC3B, 0xBC3C, 0xBC3D, 0xBC3E, 0xBC3F,   // BC30 - BC3F
	0xBC40, 0xBC41, 0xBC42, 0xBC43, 0xBC44, 0xBC45, 0xBC46, 0xBC47, 0xBC48, 0xBC49, 0xBC4A, 0xBC4B, 0xBC4C, 0xBC4D, 0xBC4E, 0xBC4F,   // BC40 - BC4F
	0xBC50, 0xBC51, 0xBC52, 0xBC53, 0xBC54, 0xBC55, 0xBC56, 0xBC57, 0xBC58, 0xBC59, 0xBC5A, 0xBC5B, 0xBC5C, 0xBC5D, 0xBC5E, 0xBC5F,   // BC50 - BC5F
	0xBC60, 0xBC61, 0xBC62, 0xBC63, 0xBC64, 0xBC65, 0xBC66, 0xBC67, 0xBC68, 0xBC69, 0xBC6A, 0xBC6B, 0xBC6C, 0xBC6D, 0xBC6E, 0xBC6F,   // BC60 - BC6F
	0xBC70, 0xBC71, 0xBC72, 0xBC73, 0xBC74, 0xBC75, 0xBC76, 0xBC77, 0xBC78, 0xBC79, 0xBC7A, 0xBC7B, 0xBC7C, 0xBC7D, 0xBC7E, 0xBC7F,   // BC70 - BC7F
	0xBC80, 0xBC81, 0xBC82, 0xBC83, 0xBC84, 0xBC85, 0xBC86, 0xBC87, 0xBC88, 0xBC89, 0xBC8A, 0xBC8B, 0xBC8C, 0xBC8D, 0xBC8E, 0xBC8F,   // BC80 - BC8F
	0xBC90, 0xBC91, 0xBC92, 0xBC93, 0xBC94, 0xBC95, 0xBC96, 0xBC97, 0xBC98, 0xBC99, 0xBC9A, 0xBC9B, 0xBC9C, 0xBC9D, 0xBC9E, 0xBC9F,   // BC90 - BC9F
	0xBCA0, 0xBCA1, 0xBCA2, 0xBCA3, 0xBCA4, 0xBCA5, 0xBCA6, 0xBCA7, 0xBCA8, 0xBCA9, 0xBCAA, 0xBCAB, 0xBCAC, 0xBCAD, 0xBCAE, 0xBCAF,   // BCA0 - BCAF
	0xBCB0, 0xBCB1, 0xBCB2, 0xBCB3, 0xBCB4, 0xBCB5, 0xBCB6, 0xBCB7, 0xBCB8, 0xBCB9, 0xBCBA, 0xBCBB, 0xBCBC, 0xBCBD, 0xBCBE, 0xBCBF,   // BCB0 - BCBF
	0xBCC0, 0xBCC1, 0xBCC2, 0xBCC3, 0xBCC4, 0xBCC5, 0xBCC6, 0xBCC7, 0xBCC8, 0xBCC9, 0xBCCA, 0xBCCB, 0xBCCC, 0xBCCD, 0xBCCE, 0xBCCF,   // BCC0 - BCCF
	0xBCD0, 0xBCD1, 0xBCD2, 0xBCD3, 0xBCD4, 0xBCD5, 0xBCD6, 0xBCD7, 0xBCD8, 0xBCD9, 0xBCDA, 0xBCDB, 0xBCDC, 0xBCDD, 0xBCDE, 0xBCDF,   // BCD0 - BCDF
	0xBCE0, 0xBCE1, 0xBCE2, 0xBCE3, 0xBCE4, 0xBCE5, 0xBCE6, 0xBCE7, 0xBCE8, 0xBCE9, 0xBCEA, 0xBCEB, 0xBCEC, 0xBCED, 0xBCEE, 0xBCEF,   // BCE0 - BCEF
	0xBCF0, 0xBCF1, 0xBCF2, 0xBCF3, 0xBCF4, 0xBCF5, 0xBCF6, 0xBCF7, 0xBCF8, 0xBCF9, 0xBCFA, 0xBCFB, 0xBCFC, 0xBCFD, 0xBCFE, 0xBCFF,   // BCF0 - BCFF
	0xBD00, 0xBD01, 0xBD02, 0xBD03, 0xBD04, 0xBD05, 0xBD06, 0xBD07, 0xBD08, 0xBD09, 0xBD0A, 0xBD0B, 0xBD0C, 0xBD0D, 0xBD0E, 0xBD0F,   // BD00 - BD0F
	0xBD10, 0xBD11, 0xBD12, 0xBD13, 0xBD14, 0xBD15, 0xBD16, 0xBD17, 0xBD18, 0xBD19, 0xBD1A, 0xBD1B, 0xBD1C, 0xBD1D, 0xBD1E, 0xBD1F,   // BD10 - BD1F
	0xBD20, 0xBD21, 0xBD22, 0xBD23, 0xBD24, 0xBD25, 0xBD26, 0xBD27, 0xBD28, 0xBD29, 0xBD2A, 0xBD2B, 0xBD2C, 0xBD2D, 0xBD2E, 0xBD2F,   // BD20 - BD2F
	0xBD30, 0xBD31, 0xBD32, 0xBD33, 0xBD34, 0xBD35, 0xBD36, 0xBD37, 0xBD38, 0xBD39, 0xBD3A, 0xBD3B, 0xBD3C, 0xBD3D, 0xBD3E, 0xBD3F,   // BD30 - BD3F
	0xBD40, 0xBD41, 0xBD42, 0xBD43, 0xBD44, 0xBD45, 0xBD46, 0xBD47, 0xBD48, 0xBD49, 0xBD4A, 0xBD4B, 0xBD4C, 0xBD4D, 0xBD4E, 0xBD4F,   // BD40 - BD4F
	0xBD50, 0xBD51, 0xBD52, 0xBD53, 0xBD54, 0xBD55, 0xBD56, 0xBD57, 0xBD58, 0xBD59, 0xBD5A, 0xBD5B, 0xBD5C, 0xBD5D, 0xBD5E, 0xBD5F,   // BD50 - BD5F
	0xBD60, 0xBD61, 0xBD62, 0xBD63, 0xBD64, 0xBD65, 0xBD66, 0xBD67, 0xBD68, 0xBD69, 0xBD6A, 0xBD6B, 0xBD6C, 0xBD6D, 0xBD6E, 0xBD6F,   // BD60 - BD6F
	0xBD70, 0xBD71, 0xBD72, 0xBD73, 0xBD74, 0xBD75, 0xBD76, 0xBD77, 0xBD78, 0xBD79, 0xBD7A, 0xBD7B, 0xBD7C, 0xBD7D, 0xBD7E, 0xBD7F,   // BD70 - BD7F
	0xBD80, 0xBD81, 0xBD82, 0xBD83, 0xBD84, 0xBD85, 0xBD86, 0xBD87, 0xBD88, 0xBD89, 0xBD8A, 0xBD8B, 0xBD8C, 0xBD8D, 0xBD8E, 0xBD8F,   // BD80 - BD8F
	0xBD90, 0xBD91, 0xBD92, 0xBD93, 0xBD94, 0xBD95, 0xBD96, 0xBD97, 0xBD98, 0xBD99, 0xBD9A, 0xBD9B, 0xBD9C, 0xBD9D, 0xBD9E, 0xBD9F,   // BD90 - BD9F
	0xBDA0, 0xBDA1, 0xBDA2, 0xBDA3, 0xBDA4, 0xBDA5, 0xBDA6, 0xBDA7, 0xBDA8, 0xBDA9, 0xBDAA, 0xBDAB, 0xBDAC, 0xBDAD, 0xBDAE, 0xBDAF,   // BDA0 - BDAF
	0xBDB0, 0xBDB1, 0xBDB2, 0xBDB3, 0xBDB4, 0xBDB5, 0xBDB6, 0xBDB7, 0xBDB8, 0xBDB9, 0xBDBA, 0xBDBB, 0xBDBC, 0xBDBD, 0xBDBE, 0xBDBF,   // BDB0 - BDBF
	0xBDC0, 0xBDC1, 0xBDC2, 0xBDC3, 0xBDC4, 0xBDC5, 0xBDC6, 0xBDC7, 0xBDC8, 0xBDC9, 0xBDCA, 0xBDCB, 0xBDCC, 0xBDCD, 0xBDCE, 0xBDCF,   // BDC0 - BDCF
	0xBDD0, 0xBDD1, 0xBDD2, 0xBDD3, 0xBDD4, 0xBDD5, 0xBDD6, 0xBDD7, 0xBDD8, 0xBDD9, 0xBDDA, 0xBDDB, 0xBDDC, 0xBDDD, 0xBDDE, 0xBDDF,   // BDD0 - BDDF
	0xBDE0, 0xBDE1, 0xBDE2, 0xBDE3, 0xBDE4, 0xBDE5, 0xBDE6, 0xBDE7, 0xBDE8, 0xBDE9, 0xBDEA, 0xBDEB, 0xBDEC, 0xBDED, 0xBDEE, 0xBDEF,   // BDE0 - BDEF
	0xBDF0, 0xBDF1, 0xBDF2, 0xBDF3, 0xBDF4, 0xBDF5, 0xBDF6, 0xBDF7, 0xBDF8, 0xBDF9, 0xBDFA, 0xBDFB, 0xBDFC, 0xBDFD, 0xBDFE, 0xBDFF,   // BDF0 - BDFF
	0xBE00, 0xBE01, 0xBE02, 0xBE03, 0xBE04, 0xBE05, 0xBE06, 0xBE07, 0xBE08, 0xBE09, 0xBE0A, 0xBE0B, 0xBE0C, 0xBE0D, 0xBE0E, 0xBE0F,   // BE00 - BE0F
	0xBE10, 0xBE11, 0xBE12, 0xBE13, 0xBE14, 0xBE15, 0xBE16, 0xBE17, 0xBE18, 0xBE19, 0xBE1A, 0xBE1B, 0xBE1C, 0xBE1D, 0xBE1E, 0xBE1F,   // BE10 - BE1F
	0xBE20, 0xBE21, 0xBE22, 0xBE23, 0xBE24, 0xBE25, 0xBE26, 0xBE27, 0xBE28, 0xBE29, 0xBE2A, 0xBE2B, 0xBE2C, 0xBE2D, 0xBE2E, 0xBE2F,   // BE20 - BE2F
	0xBE30, 0xBE31, 0xBE32, 0xBE33, 0xBE34, 0xBE35, 0xBE36, 0xBE37, 0xBE38, 0xBE39, 0xBE3A, 0xBE3B, 0xBE3C, 0xBE3D, 0xBE3E, 0xBE3F,   // BE30 - BE3F
	0xBE40, 0xBE41, 0xBE42, 0xBE43, 0xBE44, 0xBE45, 0xBE46, 0xBE47, 0xBE48, 0xBE49, 0xBE4A, 0xBE4B, 0xBE4C, 0xBE4D, 0xBE4E, 0xBE4F,   // BE40 - BE4F
	0xBE50, 0xBE51, 0xBE52, 0xBE53, 0xBE54, 0xBE55, 0xBE56, 0xBE57, 0xBE58, 0xBE59, 0xBE5A, 0xBE5B, 0xBE5C, 0xBE5D, 0xBE5E, 0xBE5F,   // BE50 - BE5F
	0xBE60, 0xBE61, 0xBE62, 0xBE63, 0xBE64, 0xBE65, 0xBE66, 0xBE67, 0xBE68, 0xBE69, 0xBE6A, 0xBE6B, 0xBE6C, 0xBE6D, 0xBE6E, 0xBE6F,   // BE60 - BE6F
	0xBE70, 0xBE71, 0xBE72, 0xBE73, 0xBE74, 0xBE75, 0xBE76, 0xBE77, 0xBE78, 0xBE79, 0xBE7A, 0xBE7B, 0xBE7C, 0xBE7D, 0xBE7E, 0xBE7F,   // BE70 - BE7F
	0xBE80, 0xBE81, 0xBE82, 0xBE83, 0xBE84, 0xBE85, 0xBE86, 0xBE87, 0xBE88, 0xBE89, 0xBE8A, 0xBE8B, 0xBE8C, 0xBE8D, 0xBE8E, 0xBE8F,   // BE80 - BE8F
	0xBE90, 0xBE91, 0xBE92, 0xBE93, 0xBE94, 0xBE95, 0xBE96, 0xBE97, 0xBE98, 0xBE99, 0xBE9A, 0xBE9B, 0xBE9C, 0xBE9D, 0xBE9E, 0xBE9F,   // BE90 - BE9F
	0xBEA0, 0xBEA1, 0xBEA2, 0xBEA3, 0xBEA4, 0xBEA5, 0xBEA6, 0xBEA7, 0xBEA8, 0xBEA9, 0xBEAA, 0xBEAB, 0xBEAC, 0xBEAD, 0xBEAE, 0xBEAF,   // BEA0 - BEAF
	0xBEB0, 0xBEB1, 0xBEB2, 0xBEB3, 0xBEB4, 0xBEB5, 0xBEB6, 0xBEB7, 0xBEB8, 0xBEB9, 0xBEBA, 0xBEBB, 0xBEBC, 0xBEBD, 0xBEBE, 0xBEBF,   // BEB0 - BEBF
	0xBEC0, 0xBEC1, 0xBEC2, 0xBEC3, 0xBEC4, 0xBEC5, 0xBEC6, 0xBEC7, 0xBEC8, 0xBEC9, 0xBECA, 0xBECB, 0xBECC, 0xBECD, 0xBECE, 0xBECF,   // BEC0 - BECF
	0xBED0, 0xBED1, 0xBED2, 0xBED3, 0xBED4, 0xBED5, 0xBED6, 0xBED7, 0xBED8, 0xBED9, 0xBEDA, 0xBEDB, 0xBEDC, 0xBEDD, 0xBEDE, 0xBEDF,   // BED0 - BEDF
	0xBEE0, 0xBEE1, 0xBEE2, 0xBEE3, 0xBEE4, 0xBEE5, 0xBEE6, 0xBEE7, 0xBEE8, 0xBEE9, 0xBEEA, 0xBEEB, 0xBEEC, 0xBEED, 0xBEEE, 0xBEEF,   // BEE0 - BEEF
	0xBEF0, 0xBEF1, 0xBEF2, 0xBEF3, 0xBEF4, 0xBEF5, 0xBEF6, 0xBEF7, 0xBEF8, 0xBEF9, 0xBEFA, 0xBEFB, 0xBEFC, 0xBEFD, 0xBEFE, 0xBEFF,   // BEF0 - BEFF
	0xBF00, 0xBF01, 0xBF02, 0xBF03, 0xBF04, 0xBF05, 0xBF06, 0xBF07, 0xBF08, 0xBF09, 0xBF0A, 0xBF0B, 0xBF0C, 0xBF0D, 0xBF0E, 0xBF0F,   // BF00 - BF0F
	0xBF10, 0xBF11, 0xBF12, 0xBF13, 0xBF14, 0xBF15, 0xBF16, 0xBF17, 0xBF18, 0xBF19, 0xBF1A, 0xBF1B, 0xBF1C, 0xBF1D, 0xBF1E, 0xBF1F,   // BF10 - BF1F
	0xBF20, 0xBF21, 0xBF22, 0xBF23, 0xBF24, 0xBF25, 0xBF26, 0xBF27, 0xBF28, 0xBF29, 0xBF2A, 0xBF2B, 0xBF2C, 0xBF2D, 0xBF2E, 0xBF2F,   // BF20 - BF2F
	0xBF30, 0xBF31, 0xBF32, 0xBF33, 0xBF34, 0xBF35, 0xBF36, 0xBF37, 0xBF38, 0xBF39, 0xBF3A, 0xBF3B, 0xBF3C, 0xBF3D, 0xBF3E, 0xBF3F,   // BF30 - BF3F
	0xBF40, 0xBF41, 0xBF42, 0xBF43, 0xBF44, 0xBF45, 0xBF46, 0xBF47, 0xBF48, 0xBF49, 0xBF4A, 0xBF4B, 0xBF4C, 0xBF4D, 0xBF4E, 0xBF4F,   // BF40 - BF4F
	0xBF50, 0xBF51, 0xBF52, 0xBF53, 0xBF54, 0xBF55, 0xBF56, 0xBF57, 0xBF58, 0xBF59, 0xBF5A, 0xBF5B, 0xBF5C, 0xBF5D, 0xBF5E, 0xBF5F,   // BF50 - BF5F
	0xBF60, 0xBF61, 0xBF62, 0xBF63, 0xBF64, 0xBF65, 0xBF66, 0xBF67, 0xBF68, 0xBF69, 0xBF6A, 0xBF6B, 0xBF6C, 0xBF6D, 0xBF6E, 0xBF6F,   // BF60 - BF6F
	0xBF70, 0xBF71, 0xBF72, 0xBF73, 0xBF74, 0xBF75, 0xBF76, 0xBF77, 0xBF78, 0xBF79, 0xBF7A, 0xBF7B, 0xBF7C, 0xBF7D, 0xBF7E, 0xBF7F,   // BF70 - BF7F
	0xBF80, 0xBF81, 0xBF82, 0xBF83, 0xBF84, 0xBF85, 0xBF86, 0xBF87, 0xBF88, 0xBF89, 0xBF8A, 0xBF8B, 0xBF8C, 0xBF8D, 0xBF8E, 0xBF8F,   // BF80 - BF8F
	0xBF90, 0xBF91, 0xBF92, 0xBF93, 0xBF94, 0xBF95, 0xBF96, 0xBF97, 0xBF98, 0xBF99, 0xBF9A, 0xBF9B, 0xBF9C, 0xBF9D, 0xBF9E, 0xBF9F,   // BF90 - BF9F
	0xBFA0, 0xBFA1, 0xBFA2, 0xBFA3, 0xBFA4, 0xBFA5, 0xBFA6, 0xBFA7, 0xBFA8, 0xBFA9, 0xBFAA, 0xBFAB, 0xBFAC, 0xBFAD, 0xBFAE, 0xBFAF,   // BFA0 - BFAF
	0xBFB0, 0xBFB1, 0xBFB2, 0xBFB3, 0xBFB4, 0xBFB5, 0xBFB6, 0xBFB7, 0xBFB8, 0xBFB9, 0xBFBA, 0xBFBB, 0xBFBC, 0xBFBD, 0xBFBE, 0xBFBF,   // BFB0 - BFBF
	0xBFC0, 0xBFC1, 0xBFC2, 0xBFC3, 0xBFC4, 0xBFC5, 0xBFC6, 0xBFC7, 0xBFC8, 0xBFC9, 0xBFCA, 0xBFCB, 0xBFCC, 0xBFCD, 0xBFCE, 0xBFCF,   // BFC0 - BFCF
	0xBFD0, 0xBFD1, 0xBFD2, 0xBFD3, 0xBFD4, 0xBFD5, 0xBFD6, 0xBFD7, 0xBFD8, 0xBFD9, 0xBFDA, 0xBFDB, 0xBFDC, 0xBFDD, 0xBFDE, 0xBFDF,   // BFD0 - BFDF
	0xBFE0, 0xBFE1, 0xBFE2, 0xBFE3, 0xBFE4, 0xBFE5, 0xBFE6, 0xBFE7, 0xBFE8, 0xBFE9, 0xBFEA, 0xBFEB, 0xBFEC, 0xBFED, 0xBFEE, 0xBFEF,   // BFE0 - BFEF
	0xBFF0, 0xBFF1, 0xBFF2, 0xBFF3, 0xBFF4, 0xBFF5, 0xBFF6, 0xBFF7, 0xBFF8, 0xBFF9, 0xBFFA, 0xBFFB, 0xBFFC, 0xBFFD, 0xBFFE, 0xBFFF,   // BFF0 - BFFF
	0xC000, 0xC001, 0xC002, 0xC003, 0xC004, 0xC005, 0xC006, 0xC007, 0xC008, 0xC009, 0xC00A, 0xC00B, 0xC00C, 0xC00D, 0xC00E, 0xC00F,   // C000 - C00F
	0xC010, 0xC011, 0xC012, 0xC013, 0xC014, 0xC015, 0xC016, 0xC017, 0xC018, 0xC019, 0xC01A, 0xC01B, 0xC01C, 0xC01D, 0xC01E, 0xC01F,   // C010 - C01F
	0xC020, 0xC021, 0xC022, 0xC023, 0xC024, 0xC025, 0xC026, 0xC027, 0xC028, 0xC029, 0xC02A, 0xC02B, 0xC02C, 0xC02D, 0xC02E, 0xC02F,   // C020 - C02F
	0xC030, 0xC031, 0xC032, 0xC033, 0xC034, 0xC035, 0xC036, 0xC037, 0xC038, 0xC039, 0xC03A, 0xC03B, 0xC03C, 0xC03D, 0xC03E, 0xC03F,   // C030 - C03F
	0xC040, 0xC041, 0xC042, 0xC043, 0xC044, 0xC045, 0xC046, 0xC047, 0xC048, 0xC049, 0xC04A, 0xC04B, 0xC04C, 0xC04D, 0xC04E, 0xC04F,   // C040 - C04F
	0xC050, 0xC051, 0xC052, 0xC053, 0xC054, 0xC055, 0xC056, 0xC057, 0xC058, 0xC059, 0xC05A, 0xC05B, 0xC05C, 0xC05D, 0xC05E, 0xC05F,   // C050 - C05F
	0xC060, 0xC061, 0xC062, 0xC063, 0xC064, 0xC065, 0xC066, 0xC067, 0xC068, 0xC069, 0xC06A, 0xC06B, 0xC06C, 0xC06D, 0xC06E, 0xC06F,   // C060 - C06F
	0xC070, 0xC071, 0xC072, 0xC073, 0xC074, 0xC075, 0xC076, 0xC077, 0xC078, 0xC079, 0xC07A, 0xC07B, 0xC07C, 0xC07D, 0xC07E, 0xC07F,   // C070 - C07F
	0xC080, 0xC081, 0xC082, 0xC083, 0xC084, 0xC085, 0xC086, 0xC087, 0xC088, 0xC089, 0xC08A, 0xC08B, 0xC08C, 0xC08D, 0xC08E, 0xC08F,   // C080 - C08F
	0xC090, 0xC091, 0xC092, 0xC093, 0xC094, 0xC095, 0xC096, 0xC097, 0xC098, 0xC099, 0xC09A, 0xC09B, 0xC09C, 0xC09D, 0xC09E, 0xC09F,   // C090 - C09F
	0xC0A0, 0xC0A1, 0xC0A2, 0xC0A3, 0xC0A4, 0xC0A5, 0xC0A6, 0xC0A7, 0xC0A8, 0xC0A9, 0xC0AA, 0xC0AB, 0xC0AC, 0xC0AD, 0xC0AE, 0xC0AF,   // C0A0 - C0AF
	0xC0B0, 0xC0B1, 0xC0B2, 0xC0B3, 0xC0B4, 0xC0B5, 0xC0B6, 0xC0B7, 0xC0B8, 0xC0B9, 0xC0BA, 0xC0BB, 0xC0BC, 0xC0BD, 0xC0BE, 0xC0BF,   // C0B0 - C0BF
	0xC0C0, 0xC0C1, 0xC0C2, 0xC0C3, 0xC0C4, 0xC0C5, 0xC0C6, 0xC0C7, 0xC0C8, 0xC0C9, 0xC0CA, 0xC0CB, 0xC0CC, 0xC0CD, 0xC0CE, 0xC0CF,   // C0C0 - C0CF
	0xC0D0, 0xC0D1, 0xC0D2, 0xC0D3, 0xC0D4, 0xC0D5, 0xC0D6, 0xC0D7, 0xC0D8, 0xC0D9, 0xC0DA, 0xC0DB, 0xC0DC, 0xC0DD, 0xC0DE, 0xC0DF,   // C0D0 - C0DF
	0xC0E0, 0xC0E1, 0xC0E2, 0xC0E3, 0xC0E4, 0xC0E5, 0xC0E6, 0xC0E7, 0xC0E8, 0xC0E9, 0xC0EA, 0xC0EB, 0xC0EC, 0xC0ED, 0xC0EE, 0xC0EF,   // C0E0 - C0EF
	0xC0F0, 0xC0F1, 0xC0F2, 0xC0F3, 0xC0F4, 0xC0F5, 0xC0F6, 0xC0F7, 0xC0F8, 0xC0F9, 0xC0FA, 0xC0FB, 0xC0FC, 0xC0FD, 0xC0FE, 0xC0FF,   // C0F0 - C0FF
	0xC100, 0xC101, 0xC102, 0xC103, 0xC104, 0xC105, 0xC106, 0xC107, 0xC108, 0xC109, 0xC10A, 0xC10B, 0xC10C, 0xC10D, 0xC10E, 0xC10F,   // C100 - C10F
	0xC110, 0xC111, 0xC112, 0xC113, 0xC114, 0xC115, 0xC116, 0xC117, 0xC118, 0xC119, 0xC11A, 0xC11B, 0xC11C, 0xC11D, 0xC11E, 0xC11F,   // C110 - C11F
	0xC120, 0xC121, 0xC122, 0xC123, 0xC124, 0xC125, 0xC126, 0xC127, 0xC128, 0xC129, 0xC12A, 0xC12B, 0xC12C, 0xC12D, 0xC12E, 0xC12F,   // C120 - C12F
	0xC130, 0xC131, 0xC132, 0xC133, 0xC134, 0xC135, 0xC136, 0xC137, 0xC138, 0xC139, 0xC13A, 0xC13B, 0xC13C, 0xC13D, 0xC13E, 0xC13F,   // C130 - C13F
	0xC140, 0xC141, 0xC142, 0xC143, 0xC144, 0xC145, 0xC146, 0xC147, 0xC148, 0xC149, 0xC14A, 0xC14B, 0xC14C, 0xC14D, 0xC14E, 0xC14F,   // C140 - C14F
	0xC150, 0xC151, 0xC152, 0xC153, 0xC154, 0xC155, 0xC156, 0xC157, 0xC158, 0xC159, 0xC15A, 0xC15B, 0xC15C, 0xC15D, 0xC15E, 0xC15F,   // C150 - C15F
	0xC160, 0xC161, 0xC162, 0xC163, 0xC164, 0xC165, 0xC166, 0xC167, 0xC168, 0xC169, 0xC16A, 0xC16B, 0xC16C, 0xC16D, 0xC16E, 0xC16F,   // C160 - C16F
	0xC170, 0xC171, 0xC172, 0xC173, 0xC174, 0xC175, 0xC176, 0xC177, 0xC178, 0xC179, 0xC17A, 0xC17B, 0xC17C, 0xC17D, 0xC17E, 0xC17F,   // C170 - C17F
	0xC180, 0xC181, 0xC182, 0xC183, 0xC184, 0xC185, 0xC186, 0xC187, 0xC188, 0xC189, 0xC18A, 0xC18B, 0xC18C, 0xC18D, 0xC18E, 0xC18F,   // C180 - C18F
	0xC190, 0xC191, 0xC192, 0xC193, 0xC194, 0xC195, 0xC196, 0xC197, 0xC198, 0xC199, 0xC19A, 0xC19B, 0xC19C, 0xC19D, 0xC19E, 0xC19F,   // C190 - C19F
	0xC1A0, 0xC1A1, 0xC1A2, 0xC1A3, 0xC1A4, 0xC1A5, 0xC1A6, 0xC1A7, 0xC1A8, 0xC1A9, 0xC1AA, 0xC1AB, 0xC1AC, 0xC1AD, 0xC1AE, 0xC1AF,   // C1A0 - C1AF
	0xC1B0, 0xC1B1, 0xC1B2, 0xC1B3, 0xC1B4, 0xC1B5, 0xC1B6, 0xC1B7, 0xC1B8, 0xC1B9, 0xC1BA, 0xC1BB, 0xC1BC, 0xC1BD, 0xC1BE, 0xC1BF,   // C1B0 - C1BF
	0xC1C0, 0xC1C1, 0xC1C2, 0xC1C3, 0xC1C4, 0xC1C5, 0xC1C6, 0xC1C7, 0xC1C8, 0xC1C9, 0xC1CA, 0xC1CB, 0xC1CC, 0xC1CD, 0xC1CE, 0xC1CF,   // C1C0 - C1CF
	0xC1D0, 0xC1D1, 0xC1D2, 0xC1D3, 0xC1D4, 0xC1D5, 0xC1D6, 0xC1D7, 0xC1D8, 0xC1D9, 0xC1DA, 0xC1DB, 0xC1DC, 0xC1DD, 0xC1DE, 0xC1DF,   // C1D0 - C1DF
	0xC1E0, 0xC1E1, 0xC1E2, 0xC1E3, 0xC1E4, 0xC1E5, 0xC1E6, 0xC1E7, 0xC1E8, 0xC1E9, 0xC1EA, 0xC1EB, 0xC1EC, 0xC1ED, 0xC1EE, 0xC1EF,   // C1E0 - C1EF
	0xC1F0, 0xC1F1, 0xC1F2, 0xC1F3, 0xC1F4, 0xC1F5, 0xC1F6, 0xC1F7, 0xC1F8, 0xC1F9, 0xC1FA, 0xC1FB, 0xC1FC, 0xC1FD, 0xC1FE, 0xC1FF,   // C1F0 - C1FF
	0xC200, 0xC201, 0xC202, 0xC203, 0xC204, 0xC205, 0xC206, 0xC207, 0xC208, 0xC209, 0xC20A, 0xC20B, 0xC20C, 0xC20D, 0xC20E, 0xC20F,   // C200 - C20F
	0xC210, 0xC211, 0xC212, 0xC213, 0xC214, 0xC215, 0xC216, 0xC217, 0xC218, 0xC219, 0xC21A, 0xC21B, 0xC21C, 0xC21D, 0xC21E, 0xC21F,   // C210 - C21F
	0xC220, 0xC221, 0xC222, 0xC223, 0xC224, 0xC225, 0xC226, 0xC227, 0xC228, 0xC229, 0xC22A, 0xC22B, 0xC22C, 0xC22D, 0xC22E, 0xC22F,   // C220 - C22F
	0xC230, 0xC231, 0xC232, 0xC233, 0xC234, 0xC235, 0xC236, 0xC237, 0xC238, 0xC239, 0xC23A, 0xC23B, 0xC23C, 0xC23D, 0xC23E, 0xC23F,   // C230 - C23F
	0xC240, 0xC241, 0xC242, 0xC243, 0xC244, 0xC245, 0xC246, 0xC247, 0xC248, 0xC249, 0xC24A, 0xC24B, 0xC24C, 0xC24D, 0xC24E, 0xC24F,   // C240 - C24F
	0xC250, 0xC251, 0xC252, 0xC253, 0xC254, 0xC255, 0xC256, 0xC257, 0xC258, 0xC259, 0xC25A, 0xC25B, 0xC25C, 0xC25D, 0xC25E, 0xC25F,   // C250 - C25F
	0xC260, 0xC261, 0xC262, 0xC263, 0xC264, 0xC265, 0xC266, 0xC267, 0xC268, 0xC269, 0xC26A, 0xC26B, 0xC26C, 0xC26D, 0xC26E, 0xC26F,   // C260 - C26F
	0xC270, 0xC271, 0xC272, 0xC273, 0xC274, 0xC275, 0xC276, 0xC277, 0xC278, 0xC279, 0xC27A, 0xC27B, 0xC27C, 0xC27D, 0xC27E, 0xC27F,   // C270 - C27F
	0xC280, 0xC281, 0xC282, 0xC283, 0xC284, 0xC285, 0xC286, 0xC287, 0xC288, 0xC289, 0xC28A, 0xC28B, 0xC28C, 0xC28D, 0xC28E, 0xC28F,   // C280 - C28F
	0xC290, 0xC291, 0xC292, 0xC293, 0xC294, 0xC295, 0xC296, 0xC297, 0xC298, 0xC299, 0xC29A, 0xC29B, 0xC29C, 0xC29D, 0xC29E, 0xC29F,   // C290 - C29F
	0xC2A0, 0xC2A1, 0xC2A2, 0xC2A3, 0xC2A4, 0xC2A5, 0xC2A6, 0xC2A7, 0xC2A8, 0xC2A9, 0xC2AA, 0xC2AB, 0xC2AC, 0xC2AD, 0xC2AE, 0xC2AF,   // C2A0 - C2AF
	0xC2B0, 0xC2B1, 0xC2B2, 0xC2B3, 0xC2B4, 0xC2B5, 0xC2B6, 0xC2B7, 0xC2B8, 0xC2B9, 0xC2BA, 0xC2BB, 0xC2BC, 0xC2BD, 0xC2BE, 0xC2BF,   // C2B0 - C2BF
	0xC2C0, 0xC2C1, 0xC2C2, 0xC2C3, 0xC2C4, 0xC2C5, 0xC2C6, 0xC2C7, 0xC2C8, 0xC2C9, 0xC2CA, 0xC2CB, 0xC2CC, 0xC2CD, 0xC2CE, 0xC2CF,   // C2C0 - C2CF
	0xC2D0, 0xC2D1, 0xC2D2, 0xC2D3, 0xC2D4, 0xC2D5, 0xC2D6, 0xC2D7, 0xC2D8, 0xC2D9, 0xC2DA, 0xC2DB, 0xC2DC, 0xC2DD, 0xC2DE, 0xC2DF,   // C2D0 - C2DF
	0xC2E0, 0xC2E1, 0xC2E2, 0xC2E3, 0xC2E4, 0xC2E5, 0xC2E6, 0xC2E7, 0xC2E8, 0xC2E9, 0xC2EA, 0xC2EB, 0xC2EC, 0xC2ED, 0xC2EE, 0xC2EF,   // C2E0 - C2EF
	0xC2F0, 0xC2F1, 0xC2F2, 0xC2F3, 0xC2F4, 0xC2F5, 0xC2F6, 0xC2F7, 0xC2F8, 0xC2F9, 0xC2FA, 0xC2FB, 0xC2FC, 0xC2FD, 0xC2FE, 0xC2FF,   // C2F0 - C2FF
	0xC300, 0xC301, 0xC302, 0xC303, 0xC304, 0xC305, 0xC306, 0xC307, 0xC308, 0xC309, 0xC30A, 0xC30B, 0xC30C, 0xC30D, 0xC30E, 0xC30F,   // C300 - C30F
	0xC310, 0xC311, 0xC312, 0xC313, 0xC314, 0xC315, 0xC316, 0xC317, 0xC318, 0xC319, 0xC31A, 0xC31B, 0xC31C, 0xC31D, 0xC31E, 0xC31F,   // C310 - C31F
	0xC320, 0xC321, 0xC322, 0xC323, 0xC324, 0xC325, 0xC326, 0xC327, 0xC328, 0xC329, 0xC32A, 0xC32B, 0xC32C, 0xC32D, 0xC32E, 0xC32F,   // C320 - C32F
	0xC330, 0xC331, 0xC332, 0xC333, 0xC334, 0xC335, 0xC336, 0xC337, 0xC338, 0xC339, 0xC33A, 0xC33B, 0xC33C, 0xC33D, 0xC33E, 0xC33F,   // C330 - C33F
	0xC340, 0xC341, 0xC342, 0xC343, 0xC344, 0xC345, 0xC346, 0xC347, 0xC348, 0xC349, 0xC34A, 0xC34B, 0xC34C, 0xC34D, 0xC34E, 0xC34F,   // C340 - C34F
	0xC350, 0xC351, 0xC352, 0xC353, 0xC354, 0xC355, 0xC356, 0xC357, 0xC358, 0xC359, 0xC35A, 0xC35B, 0xC35C, 0xC35D, 0xC35E, 0xC35F,   // C350 - C35F
	0xC360, 0xC361, 0xC362, 0xC363, 0xC364, 0xC365, 0xC366, 0xC367, 0xC368, 0xC369, 0xC36A, 0xC36B, 0xC36C, 0xC36D, 0xC36E, 0xC36F,   // C360 - C36F
	0xC370, 0xC371, 0xC372, 0xC373, 0xC374, 0xC375, 0xC376, 0xC377, 0xC378, 0xC379, 0xC37A, 0xC37B, 0xC37C, 0xC37D, 0xC37E, 0xC37F,   // C370 - C37F
	0xC380, 0xC381, 0xC382, 0xC383, 0xC384, 0xC385, 0xC386, 0xC387, 0xC388, 0xC389, 0xC38A, 0xC38B, 0xC38C, 0xC38D, 0xC38E, 0xC38F,   // C380 - C38F
	0xC390, 0xC391, 0xC392, 0xC393, 0xC394, 0xC395, 0xC396, 0xC397, 0xC398, 0xC399, 0xC39A, 0xC39B, 0xC39C, 0xC39D, 0xC39E, 0xC39F,   // C390 - C39F
	0xC3A0, 0xC3A1, 0xC3A2, 0xC3A3, 0xC3A4, 0xC3A5, 0xC3A6, 0xC3A7, 0xC3A8, 0xC3A9, 0xC3AA, 0xC3AB, 0xC3AC, 0xC3AD, 0xC3AE, 0xC3AF,   // C3A0 - C3AF
	0xC3B0, 0xC3B1, 0xC3B2, 0xC3B3, 0xC3B4, 0xC3B5, 0xC3B6, 0xC3B7, 0xC3B8, 0xC3B9, 0xC3BA, 0xC3BB, 0xC3BC, 0xC3BD, 0xC3BE, 0xC3BF,   // C3B0 - C3BF
	0xC3C0, 0xC3C1, 0xC3C2, 0xC3C3, 0xC3C4, 0xC3C5, 0xC3C6, 0xC3C7, 0xC3C8, 0xC3C9, 0xC3CA, 0xC3CB, 0xC3CC, 0xC3CD, 0xC3CE, 0xC3CF,   // C3C0 - C3CF
	0xC3D0, 0xC3D1, 0xC3D2, 0xC3D3, 0xC3D4, 0xC3D5, 0xC3D6, 0xC3D7, 0xC3D8, 0xC3D9, 0xC3DA, 0xC3DB, 0xC3DC, 0xC3DD, 0xC3DE, 0xC3DF,   // C3D0 - C3DF
	0xC3E0, 0xC3E1, 0xC3E2, 0xC3E3, 0xC3E4, 0xC3E5, 0xC3E6, 0xC3E7, 0xC3E8, 0xC3E9, 0xC3EA, 0xC3EB, 0xC3EC, 0xC3ED, 0xC3EE, 0xC3EF,   // C3E0 - C3EF
	0xC3F0, 0xC3F1, 0xC3F2, 0xC3F3, 0xC3F4, 0xC3F5, 0xC3F6, 0xC3F7, 0xC3F8, 0xC3F9, 0xC3FA, 0xC3FB, 0xC3FC, 0xC3FD, 0xC3FE, 0xC3FF,   // C3F0 - C3FF
	0xC400, 0xC401, 0xC402, 0xC403, 0xC404, 0xC405, 0xC406, 0xC407, 0xC408, 0xC409, 0xC40A, 0xC40B, 0xC40C, 0xC40D, 0xC40E, 0xC40F,   // C400 - C40F
	0xC410, 0xC411, 0xC412, 0xC413, 0xC414, 0xC415, 0xC416, 0xC417, 0xC418, 0xC419, 0xC41A, 0xC41B, 0xC41C, 0xC41D, 0xC41E, 0xC41F,   // C410 - C41F
	0xC420, 0xC421, 0xC422, 0xC423, 0xC424, 0xC425, 0xC426, 0xC427, 0xC428, 0xC429, 0xC42A, 0xC42B, 0xC42C, 0xC42D, 0xC42E, 0xC42F,   // C420 - C42F
	0xC430, 0xC431, 0xC432, 0xC433, 0xC434, 0xC435, 0xC436, 0xC437, 0xC438, 0xC439, 0xC43A, 0xC43B, 0xC43C, 0xC43D, 0xC43E, 0xC43F,   // C430 - C43F
	0xC440, 0xC441, 0xC442, 0xC443, 0xC444, 0xC445, 0xC446, 0xC447, 0xC448, 0xC449, 0xC44A, 0xC44B, 0xC44C, 0xC44D, 0xC44E, 0xC44F,   // C440 - C44F
	0xC450, 0xC451, 0xC452, 0xC453, 0xC454, 0xC455, 0xC456, 0xC457, 0xC458, 0xC459, 0xC45A, 0xC45B, 0xC45C, 0xC45D, 0xC45E, 0xC45F,   // C450 - C45F
	0xC460, 0xC461, 0xC462, 0xC463, 0xC464, 0xC465, 0xC466, 0xC467, 0xC468, 0xC469, 0xC46A, 0xC46B, 0xC46C, 0xC46D, 0xC46E, 0xC46F,   // C460 - C46F
	0xC470, 0xC471, 0xC472, 0xC473, 0xC474, 0xC475, 0xC476, 0xC477, 0xC478, 0xC479, 0xC47A, 0xC47B, 0xC47C, 0xC47D, 0xC47E, 0xC47F,   // C470 - C47F
	0xC480, 0xC481, 0xC482, 0xC483, 0xC484, 0xC485, 0xC486, 0xC487, 0xC488, 0xC489, 0xC48A, 0xC48B, 0xC48C, 0xC48D, 0xC48E, 0xC48F,   // C480 - C48F
	0xC490, 0xC491, 0xC492, 0xC493, 0xC494, 0xC495, 0xC496, 0xC497, 0xC498, 0xC499, 0xC49A, 0xC49B, 0xC49C, 0xC49D, 0xC49E, 0xC49F,   // C490 - C49F
	0xC4A0, 0xC4A1, 0xC4A2, 0xC4A3, 0xC4A4, 0xC4A5, 0xC4A6, 0xC4A7, 0xC4A8, 0xC4A9, 0xC4AA, 0xC4AB, 0xC4AC, 0xC4AD, 0xC4AE, 0xC4AF,   // C4A0 - C4AF
	0xC4B0, 0xC4B1, 0xC4B2, 0xC4B3, 0xC4B4, 0xC4B5, 0xC4B6, 0xC4B7, 0xC4B8, 0xC4B9, 0xC4BA, 0xC4BB, 0xC4BC, 0xC4BD, 0xC4BE, 0xC4BF,   // C4B0 - C4BF
	0xC4C0, 0xC4C1, 0xC4C2, 0xC4C3, 0xC4C4, 0xC4C5, 0xC4C6, 0xC4C7, 0xC4C8, 0xC4C9, 0xC4CA, 0xC4CB, 0xC4CC, 0xC4CD, 0xC4CE, 0xC4CF,   // C4C0 - C4CF
	0xC4D0, 0xC4D1, 0xC4D2, 0xC4D3, 0xC4D4, 0xC4D5, 0xC4D6, 0xC4D7, 0xC4D8, 0xC4D9, 0xC4DA, 0xC4DB, 0xC4DC, 0xC4DD, 0xC4DE, 0xC4DF,   // C4D0 - C4DF
	0xC4E0, 0xC4E1, 0xC4E2, 0xC4E3, 0xC4E4, 0xC4E5, 0xC4E6, 0xC4E7, 0xC4E8, 0xC4E9, 0xC4EA, 0xC4EB, 0xC4EC, 0xC4ED, 0xC4EE, 0xC4EF,   // C4E0 - C4EF
	0xC4F0, 0xC4F1, 0xC4F2, 0xC4F3, 0xC4F4, 0xC4F5, 0xC4F6, 0xC4F7, 0xC4F8, 0xC4F9, 0xC4FA, 0xC4FB, 0xC4FC, 0xC4FD, 0xC4FE, 0xC4FF,   // C4F0 - C4FF
	0xC500, 0xC501, 0xC502, 0xC503, 0xC504, 0xC505, 0xC506, 0xC507, 0xC508, 0xC509, 0xC50A, 0xC50B, 0xC50C, 0xC50D, 0xC50E, 0xC50F,   // C500 - C50F
	0xC510, 0xC511, 0xC512, 0xC513, 0xC514, 0xC515, 0xC516, 0xC517, 0xC518, 0xC519, 0xC51A, 0xC51B, 0xC51C, 0xC51D, 0xC51E, 0xC51F,   // C510 - C51F
	0xC520, 0xC521, 0xC522, 0xC523, 0xC524, 0xC525, 0xC526, 0xC527, 0xC528, 0xC529, 0xC52A, 0xC52B, 0xC52C, 0xC52D, 0xC52E, 0xC52F,   // C520 - C52F
	0xC530, 0xC531, 0xC532, 0xC533, 0xC534, 0xC535, 0xC536, 0xC537, 0xC538, 0xC539, 0xC53A, 0xC53B, 0xC53C, 0xC53D, 0xC53E, 0xC53F,   // C530 - C53F
	0xC540, 0xC541, 0xC542, 0xC543, 0xC544, 0xC545, 0xC546, 0xC547, 0xC548, 0xC549, 0xC54A, 0xC54B, 0xC54C, 0xC54D, 0xC54E, 0xC54F,   // C540 - C54F
	0xC550, 0xC551, 0xC552, 0xC553, 0xC554, 0xC555, 0xC556, 0xC557, 0xC558, 0xC559, 0xC55A, 0xC55B, 0xC55C, 0xC55D, 0xC55E, 0xC55F,   // C550 - C55F
	0xC560, 0xC561, 0xC562, 0xC563, 0xC564, 0xC565, 0xC566, 0xC567, 0xC568, 0xC569, 0xC56A, 0xC56B, 0xC56C, 0xC56D, 0xC56E, 0xC56F,   // C560 - C56F
	0xC570, 0xC571, 0xC572, 0xC573, 0xC574, 0xC575, 0xC576, 0xC577, 0xC578, 0xC579, 0xC57A, 0xC57B, 0xC57C, 0xC57D, 0xC57E, 0xC57F,   // C570 - C57F
	0xC580, 0xC581, 0xC582, 0xC583, 0xC584, 0xC585, 0xC586, 0xC587, 0xC588, 0xC589, 0xC58A, 0xC58B, 0xC58C, 0xC58D, 0xC58E, 0xC58F,   // C580 - C58F
	0xC590, 0xC591, 0xC592, 0xC593, 0xC594, 0xC595, 0xC596, 0xC597, 0xC598, 0xC599, 0xC59A, 0xC59B, 0xC59C, 0xC59D, 0xC59E, 0xC59F,   // C590 - C59F
	0xC5A0, 0xC5A1, 0xC5A2, 0xC5A3, 0xC5A4, 0xC5A5, 0xC5A6, 0xC5A7, 0xC5A8, 0xC5A9, 0xC5AA, 0xC5AB, 0xC5AC, 0xC5AD, 0xC5AE, 0xC5AF,   // C5A0 - C5AF
	0xC5B0, 0xC5B1, 0xC5B2, 0xC5B3, 0xC5B4, 0xC5B5, 0xC5B6, 0xC5B7, 0xC5B8, 0xC5B9, 0xC5BA, 0xC5BB, 0xC5BC, 0xC5BD, 0xC5BE, 0xC5BF,   // C5B0 - C5BF
	0xC5C0, 0xC5C1, 0xC5C2, 0xC5C3, 0xC5C4, 0xC5C5, 0xC5C6, 0xC5C7, 0xC5C8, 0xC5C9, 0xC5CA, 0xC5CB, 0xC5CC, 0xC5CD, 0xC5CE, 0xC5CF,   // C5C0 - C5CF
	0xC5D0, 0xC5D1, 0xC5D2, 0xC5D3, 0xC5D4, 0xC5D5, 0xC5D6, 0xC5D7, 0xC5D8, 0xC5D9, 0xC5DA, 0xC5DB, 0xC5DC, 0xC5DD, 0xC5DE, 0xC5DF,   // C5D0 - C5DF
	0xC5E0, 0xC5E1, 0xC5E2, 0xC5E3, 0xC5E4, 0xC5E5, 0xC5E6, 0xC5E7, 0xC5E8, 0xC5E9, 0xC5EA, 0xC5EB, 0xC5EC, 0xC5ED, 0xC5EE, 0xC5EF,   // C5E0 - C5EF
	0xC5F0, 0xC5F1, 0xC5F2, 0xC5F3, 0xC5F4, 0xC5F5, 0xC5F6, 0xC5F7, 0xC5F8, 0xC5F9, 0xC5FA, 0xC5FB, 0xC5FC, 0xC5FD, 0xC5FE, 0xC5FF,   // C5F0 - C5FF
	0xC600, 0xC601, 0xC602, 0xC603, 0xC604, 0xC605, 0xC606, 0xC607, 0xC608, 0xC609, 0xC60A, 0xC60B, 0xC60C, 0xC60D, 0xC60E, 0xC60F,   // C600 - C60F
	0xC610, 0xC611, 0xC612, 0xC613, 0xC614, 0xC615, 0xC616, 0xC617, 0xC618, 0xC619, 0xC61A, 0xC61B, 0xC61C, 0xC61D, 0xC61E, 0xC61F,   // C610 - C61F
	0xC620, 0xC621, 0xC622, 0xC623, 0xC624, 0xC625, 0xC626, 0xC627, 0xC628, 0xC629, 0xC62A, 0xC62B, 0xC62C, 0xC62D, 0xC62E, 0xC62F,   // C620 - C62F
	0xC630, 0xC631, 0xC632, 0xC633, 0xC634, 0xC635, 0xC636, 0xC637, 0xC638, 0xC639, 0xC63A, 0xC63B, 0xC63C, 0xC63D, 0xC63E, 0xC63F,   // C630 - C63F
	0xC640, 0xC641, 0xC642, 0xC643, 0xC644, 0xC645, 0xC646, 0xC647, 0xC648, 0xC649, 0xC64A, 0xC64B, 0xC64C, 0xC64D, 0xC64E, 0xC64F,   // C640 - C64F
	0xC650, 0xC651, 0xC652, 0xC653, 0xC654, 0xC655, 0xC656, 0xC657, 0xC658, 0xC659, 0xC65A, 0xC65B, 0xC65C, 0xC65D, 0xC65E, 0xC65F,   // C650 - C65F
	0xC660, 0xC661, 0xC662, 0xC663, 0xC664, 0xC665, 0xC666, 0xC667, 0xC668, 0xC669, 0xC66A, 0xC66B, 0xC66C, 0xC66D, 0xC66E, 0xC66F,   // C660 - C66F
	0xC670, 0xC671, 0xC672, 0xC673, 0xC674, 0xC675, 0xC676, 0xC677, 0xC678, 0xC679, 0xC67A, 0xC67B, 0xC67C, 0xC67D, 0xC67E, 0xC67F,   // C670 - C67F
	0xC680, 0xC681, 0xC682, 0xC683, 0xC684, 0xC685, 0xC686, 0xC687, 0xC688, 0xC689, 0xC68A, 0xC68B, 0xC68C, 0xC68D, 0xC68E, 0xC68F,   // C680 - C68F
	0xC690, 0xC691, 0xC692, 0xC693, 0xC694, 0xC695, 0xC696, 0xC697, 0xC698, 0xC699, 0xC69A, 0xC69B, 0xC69C, 0xC69D, 0xC69E, 0xC69F,   // C690 - C69F
	0xC6A0, 0xC6A1, 0xC6A2, 0xC6A3, 0xC6A4, 0xC6A5, 0xC6A6, 0xC6A7, 0xC6A8, 0xC6A9, 0xC6AA, 0xC6AB, 0xC6AC, 0xC6AD, 0xC6AE, 0xC6AF,   // C6A0 - C6AF
	0xC6B0, 0xC6B1, 0xC6B2, 0xC6B3, 0xC6B4, 0xC6B5, 0xC6B6, 0xC6B7, 0xC6B8, 0xC6B9, 0xC6BA, 0xC6BB, 0xC6BC, 0xC6BD, 0xC6BE, 0xC6BF,   // C6B0 - C6BF
	0xC6C0, 0xC6C1, 0xC6C2, 0xC6C3, 0xC6C4, 0xC6C5, 0xC6C6, 0xC6C7, 0xC6C8, 0xC6C9, 0xC6CA, 0xC6CB, 0xC6CC, 0xC6CD, 0xC6CE, 0xC6CF,   // C6C0 - C6CF
	0xC6D0, 0xC6D1, 0xC6D2, 0xC6D3, 0xC6D4, 0xC6D5, 0xC6D6, 0xC6D7, 0xC6D8, 0xC6D9, 0xC6DA, 0xC6DB, 0xC6DC, 0xC6DD, 0xC6DE, 0xC6DF,   // C6D0 - C6DF
	0xC6E0, 0xC6E1, 0xC6E2, 0xC6E3, 0xC6E4, 0xC6E5, 0xC6E6, 0xC6E7, 0xC6E8, 0xC6E9, 0xC6EA, 0xC6EB, 0xC6EC, 0xC6ED, 0xC6EE, 0xC6EF,   // C6E0 - C6EF
	0xC6F0, 0xC6F1, 0xC6F2, 0xC6F3, 0xC6F4, 0xC6F5, 0xC6F6, 0xC6F7, 0xC6F8, 0xC6F9, 0xC6FA, 0xC6FB, 0xC6FC, 0xC6FD, 0xC6FE, 0xC6FF,   // C6F0 - C6FF
	0xC700, 0xC701, 0xC702, 0xC703, 0xC704, 0xC705, 0xC706, 0xC707, 0xC708, 0xC709, 0xC70A, 0xC70B, 0xC70C, 0xC70D, 0xC70E, 0xC70F,   // C700 - C70F
	0xC710, 0xC711, 0xC712, 0xC713, 0xC714, 0xC715, 0xC716, 0xC717, 0xC718, 0xC719, 0xC71A, 0xC71B, 0xC71C, 0xC71D, 0xC71E, 0xC71F,   // C710 - C71F
	0xC720, 0xC721, 0xC722, 0xC723, 0xC724, 0xC725, 0xC726, 0xC727, 0xC728, 0xC729, 0xC72A, 0xC72B, 0xC72C, 0xC72D, 0xC72E, 0xC72F,   // C720 - C72F
	0xC730, 0xC731, 0xC732, 0xC733, 0xC734, 0xC735, 0xC736, 0xC737, 0xC738, 0xC739, 0xC73A, 0xC73B, 0xC73C, 0xC73D, 0xC73E, 0xC73F,   // C730 - C73F
	0xC740, 0xC741, 0xC742, 0xC743, 0xC744, 0xC745, 0xC746, 0xC747, 0xC748, 0xC749, 0xC74A, 0xC74B, 0xC74C, 0xC74D, 0xC74E, 0xC74F,   // C740 - C74F
	0xC750, 0xC751, 0xC752, 0xC753, 0xC754, 0xC755, 0xC756, 0xC757, 0xC758, 0xC759, 0xC75A, 0xC75B, 0xC75C, 0xC75D, 0xC75E, 0xC75F,   // C750 - C75F
	0xC760, 0xC761, 0xC762, 0xC763, 0xC764, 0xC765, 0xC766, 0xC767, 0xC768, 0xC769, 0xC76A, 0xC76B, 0xC76C, 0xC76D, 0xC76E, 0xC76F,   // C760 - C76F
	0xC770, 0xC771, 0xC772, 0xC773, 0xC774, 0xC775, 0xC776, 0xC777, 0xC778, 0xC779, 0xC77A, 0xC77B, 0xC77C, 0xC77D, 0xC77E, 0xC77F,   // C770 - C77F
	0xC780, 0xC781, 0xC782, 0xC783, 0xC784, 0xC785, 0xC786, 0xC787, 0xC788, 0xC789, 0xC78A, 0xC78B, 0xC78C, 0xC78D, 0xC78E, 0xC78F,   // C780 - C78F
	0xC790, 0xC791, 0xC792, 0xC793, 0xC794, 0xC795, 0xC796, 0xC797, 0xC798, 0xC799, 0xC79A, 0xC79B, 0xC79C, 0xC79D, 0xC79E, 0xC79F,   // C790 - C79F
	0xC7A0, 0xC7A1, 0xC7A2, 0xC7A3, 0xC7A4, 0xC7A5, 0xC7A6, 0xC7A7, 0xC7A8, 0xC7A9, 0xC7AA, 0xC7AB, 0xC7AC, 0xC7AD, 0xC7AE, 0xC7AF,   // C7A0 - C7AF
	0xC7B0, 0xC7B1, 0xC7B2, 0xC7B3, 0xC7B4, 0xC7B5, 0xC7B6, 0xC7B7, 0xC7B8, 0xC7B9, 0xC7BA, 0xC7BB, 0xC7BC, 0xC7BD, 0xC7BE, 0xC7BF,   // C7B0 - C7BF
	0xC7C0, 0xC7C1, 0xC7C2, 0xC7C3, 0xC7C4, 0xC7C5, 0xC7C6, 0xC7C7, 0xC7C8, 0xC7C9, 0xC7CA, 0xC7CB, 0xC7CC, 0xC7CD, 0xC7CE, 0xC7CF,   // C7C0 - C7CF
	0xC7D0, 0xC7D1, 0xC7D2, 0xC7D3, 0xC7D4, 0xC7D5, 0xC7D6, 0xC7D7, 0xC7D8, 0xC7D9, 0xC7DA, 0xC7DB, 0xC7DC, 0xC7DD, 0xC7DE, 0xC7DF,   // C7D0 - C7DF
	0xC7E0, 0xC7E1, 0xC7E2, 0xC7E3, 0xC7E4, 0xC7E5, 0xC7E6, 0xC7E7, 0xC7E8, 0xC7E9, 0xC7EA, 0xC7EB, 0xC7EC, 0xC7ED, 0xC7EE, 0xC7EF,   // C7E0 - C7EF
	0xC7F0, 0xC7F1, 0xC7F2, 0xC7F3, 0xC7F4, 0xC7F5, 0xC7F6, 0xC7F7, 0xC7F8, 0xC7F9, 0xC7FA, 0xC7FB, 0xC7FC, 0xC7FD, 0xC7FE, 0xC7FF,   // C7F0 - C7FF
	0xC800, 0xC801, 0xC802, 0xC803, 0xC804, 0xC805, 0xC806, 0xC807, 0xC808, 0xC809, 0xC80A, 0xC80B, 0xC80C, 0xC80D, 0xC80E, 0xC80F,   // C800 - C80F
	0xC810, 0xC811, 0xC812, 0xC813, 0xC814, 0xC815, 0xC816, 0xC817, 0xC818, 0xC819, 0xC81A, 0xC81B, 0xC81C, 0xC81D, 0xC81E, 0xC81F,   // C810 - C81F
	0xC820, 0xC821, 0xC822, 0xC823, 0xC824, 0xC825, 0xC826, 0xC827, 0xC828, 0xC829, 0xC82A, 0xC82B, 0xC82C, 0xC82D, 0xC82E, 0xC82F,   // C820 - C82F
	0xC830, 0xC831, 0xC832, 0xC833, 0xC834, 0xC835, 0xC836, 0xC837, 0xC838, 0xC839, 0xC83A, 0xC83B, 0xC83C, 0xC83D, 0xC83E, 0xC83F,   // C830 - C83F
	0xC840, 0xC841, 0xC842, 0xC843, 0xC844, 0xC845, 0xC846, 0xC847, 0xC848, 0xC849, 0xC84A, 0xC84B, 0xC84C, 0xC84D, 0xC84E, 0xC84F,   // C840 - C84F
	0xC850, 0xC851, 0xC852, 0xC853, 0xC854, 0xC855, 0xC856, 0xC857, 0xC858, 0xC859, 0xC85A, 0xC85B, 0xC85C, 0xC85D, 0xC85E, 0xC85F,   // C850 - C85F
	0xC860, 0xC861, 0xC862, 0xC863, 0xC864, 0xC865, 0xC866, 0xC867, 0xC868, 0xC869, 0xC86A, 0xC86B, 0xC86C, 0xC86D, 0xC86E, 0xC86F,   // C860 - C86F
	0xC870, 0xC871, 0xC872, 0xC873, 0xC874, 0xC875, 0xC876, 0xC877, 0xC878, 0xC879, 0xC87A, 0xC87B, 0xC87C, 0xC87D, 0xC87E, 0xC87F,   // C870 - C87F
	0xC880, 0xC881, 0xC882, 0xC883, 0xC884, 0xC885, 0xC886, 0xC887, 0xC888, 0xC889, 0xC88A, 0xC88B, 0xC88C, 0xC88D, 0xC88E, 0xC88F,   // C880 - C88F
	0xC890, 0xC891, 0xC892, 0xC893, 0xC894, 0xC895, 0xC896, 0xC897, 0xC898, 0xC899, 0xC89A, 0xC89B, 0xC89C, 0xC89D, 0xC89E, 0xC89F,   // C890 - C89F
	0xC8A0, 0xC8A1, 0xC8A2, 0xC8A3, 0xC8A4, 0xC8A5, 0xC8A6, 0xC8A7, 0xC8A8, 0xC8A9, 0xC8AA, 0xC8AB, 0xC8AC, 0xC8AD, 0xC8AE, 0xC8AF,   // C8A0 - C8AF
	0xC8B0, 0xC8B1, 0xC8B2, 0xC8B3, 0xC8B4, 0xC8B5, 0xC8B6, 0xC8B7, 0xC8B8, 0xC8B9, 0xC8BA, 0xC8BB, 0xC8BC, 0xC8BD, 0xC8BE, 0xC8BF,   // C8B0 - C8BF
	0xC8C0, 0xC8C1, 0xC8C2, 0xC8C3, 0xC8C4, 0xC8C5, 0xC8C6, 0xC8C7, 0xC8C8, 0xC8C9, 0xC8CA, 0xC8CB, 0xC8CC, 0xC8CD, 0xC8CE, 0xC8CF,   // C8C0 - C8CF
	0xC8D0, 0xC8D1, 0xC8D2, 0xC8D3, 0xC8D4, 0xC8D5, 0xC8D6, 0xC8D7, 0xC8D8, 0xC8D9, 0xC8DA, 0xC8DB, 0xC8DC, 0xC8DD, 0xC8DE, 0xC8DF,   // C8D0 - C8DF
	0xC8E0, 0xC8E1, 0xC8E2, 0xC8E3, 0xC8E4, 0xC8E5, 0xC8E6, 0xC8E7, 0xC8E8, 0xC8E9, 0xC8EA, 0xC8EB, 0xC8EC, 0xC8ED, 0xC8EE, 0xC8EF,   // C8E0 - C8EF
	0xC8F0, 0xC8F1, 0xC8F2, 0xC8F3, 0xC8F4, 0xC8F5, 0xC8F6, 0xC8F7, 0xC8F8, 0xC8F9, 0xC8FA, 0xC8FB, 0xC8FC, 0xC8FD, 0xC8FE, 0xC8FF,   // C8F0 - C8FF
	0xC900, 0xC901, 0xC902, 0xC903, 0xC904, 0xC905, 0xC906, 0xC907, 0xC908, 0xC909, 0xC90A, 0xC90B, 0xC90C, 0xC90D, 0xC90E, 0xC90F,   // C900 - C90F
	0xC910, 0xC911, 0xC912, 0xC913, 0xC914, 0xC915, 0xC916, 0xC917, 0xC918, 0xC919, 0xC91A, 0xC91B, 0xC91C, 0xC91D, 0xC91E, 0xC91F,   // C910 - C91F
	0xC920, 0xC921, 0xC922, 0xC923, 0xC924, 0xC925, 0xC926, 0xC927, 0xC928, 0xC929, 0xC92A, 0xC92B, 0xC92C, 0xC92D, 0xC92E, 0xC92F,   // C920 - C92F
	0xC930, 0xC931, 0xC932, 0xC933, 0xC934, 0xC935, 0xC936, 0xC937, 0xC938, 0xC939, 0xC93A, 0xC93B, 0xC93C, 0xC93D, 0xC93E, 0xC93F,   // C930 - C93F
	0xC940, 0xC941, 0xC942, 0xC943, 0xC944, 0xC945, 0xC946, 0xC947, 0xC948, 0xC949, 0xC94A, 0xC94B, 0xC94C, 0xC94D, 0xC94E, 0xC94F,   // C940 - C94F
	0xC950, 0xC951, 0xC952, 0xC953, 0xC954, 0xC955, 0xC956, 0xC957, 0xC958, 0xC959, 0xC95A, 0xC95B, 0xC95C, 0xC95D, 0xC95E, 0xC95F,   // C950 - C95F
	0xC960, 0xC961, 0xC962, 0xC963, 0xC964, 0xC965, 0xC966, 0xC967, 0xC968, 0xC969, 0xC96A, 0xC96B, 0xC96C, 0xC96D, 0xC96E, 0xC96F,   // C960 - C96F
	0xC970, 0xC971, 0xC972, 0xC973, 0xC974, 0xC975, 0xC976, 0xC977, 0xC978, 0xC979, 0xC97A, 0xC97B, 0xC97C, 0xC97D, 0xC97E, 0xC97F,   // C970 - C97F
	0xC980, 0xC981, 0xC982, 0xC983, 0xC984, 0xC985, 0xC986, 0xC987, 0xC988, 0xC989, 0xC98A, 0xC98B, 0xC98C, 0xC98D, 0xC98E, 0xC98F,   // C980 - C98F
	0xC990, 0xC991, 0xC992, 0xC993, 0xC994, 0xC995, 0xC996, 0xC997, 0xC998, 0xC999, 0xC99A, 0xC99B, 0xC99C, 0xC99D, 0xC99E, 0xC99F,   // C990 - C99F
	0xC9A0, 0xC9A1, 0xC9A2, 0xC9A3, 0xC9A4, 0xC9A5, 0xC9A6, 0xC9A7, 0xC9A8, 0xC9A9, 0xC9AA, 0xC9AB, 0xC9AC, 0xC9AD, 0xC9AE, 0xC9AF,   // C9A0 - C9AF
	0xC9B0, 0xC9B1, 0xC9B2, 0xC9B3, 0xC9B4, 0xC9B5, 0xC9B6, 0xC9B7, 0xC9B8, 0xC9B9, 0xC9BA, 0xC9BB, 0xC9BC, 0xC9BD, 0xC9BE, 0xC9BF,   // C9B0 - C9BF
	0xC9C0, 0xC9C1, 0xC9C2, 0xC9C3, 0xC9C4, 0xC9C5, 0xC9C6, 0xC9C7, 0xC9C8, 0xC9C9, 0xC9CA, 0xC9CB, 0xC9CC, 0xC9CD, 0xC9CE, 0xC9CF,   // C9C0 - C9CF
	0xC9D0, 0xC9D1, 0xC9D2, 0xC9D3, 0xC9D4, 0xC9D5, 0xC9D6, 0xC9D7, 0xC9D8, 0xC9D9, 0xC9DA, 0xC9DB, 0xC9DC, 0xC9DD, 0xC9DE, 0xC9DF,   // C9D0 - C9DF
	0xC9E0, 0xC9E1, 0xC9E2, 0xC9E3, 0xC9E4, 0xC9E5, 0xC9E6, 0xC9E7, 0xC9E8, 0xC9E9, 0xC9EA, 0xC9EB, 0xC9EC, 0xC9ED, 0xC9EE, 0xC9EF,   // C9E0 - C9EF
	0xC9F0, 0xC9F1, 0xC9F2, 0xC9F3, 0xC9F4, 0xC9F5, 0xC9F6, 0xC9F7, 0xC9F8, 0xC9F9, 0xC9FA, 0xC9FB, 0xC9FC, 0xC9FD, 0xC9FE, 0xC9FF,   // C9F0 - C9FF
	0xCA00, 0xCA01, 0xCA02, 0xCA03, 0xCA04, 0xCA05, 0xCA06, 0xCA07, 0xCA08, 0xCA09, 0xCA0A, 0xCA0B, 0xCA0C, 0xCA0D, 0xCA0E, 0xCA0F,   // CA00 - CA0F
	0xCA10, 0xCA11, 0xCA12, 0xCA13, 0xCA14, 0xCA15, 0xCA16, 0xCA17, 0xCA18, 0xCA19, 0xCA1A, 0xCA1B, 0xCA1C, 0xCA1D, 0xCA1E, 0xCA1F,   // CA10 - CA1F
	0xCA20, 0xCA21, 0xCA22, 0xCA23, 0xCA24, 0xCA25, 0xCA26, 0xCA27, 0xCA28, 0xCA29, 0xCA2A, 0xCA2B, 0xCA2C, 0xCA2D, 0xCA2E, 0xCA2F,   // CA20 - CA2F
	0xCA30, 0xCA31, 0xCA32, 0xCA33, 0xCA34, 0xCA35, 0xCA36, 0xCA37, 0xCA38, 0xCA39, 0xCA3A, 0xCA3B, 0xCA3C, 0xCA3D, 0xCA3E, 0xCA3F,   // CA30 - CA3F
	0xCA40, 0xCA41, 0xCA42, 0xCA43, 0xCA44, 0xCA45, 0xCA46, 0xCA47, 0xCA48, 0xCA49, 0xCA4A, 0xCA4B, 0xCA4C, 0xCA4D, 0xCA4E, 0xCA4F,   // CA40 - CA4F
	0xCA50, 0xCA51, 0xCA52, 0xCA53, 0xCA54, 0xCA55, 0xCA56, 0xCA57, 0xCA58, 0xCA59, 0xCA5A, 0xCA5B, 0xCA5C, 0xCA5D, 0xCA5E, 0xCA5F,   // CA50 - CA5F
	0xCA60, 0xCA61, 0xCA62, 0xCA63, 0xCA64, 0xCA65, 0xCA66, 0xCA67, 0xCA68, 0xCA69, 0xCA6A, 0xCA6B, 0xCA6C, 0xCA6D, 0xCA6E, 0xCA6F,   // CA60 - CA6F
	0xCA70, 0xCA71, 0xCA72, 0xCA73, 0xCA74, 0xCA75, 0xCA76, 0xCA77, 0xCA78, 0xCA79, 0xCA7A, 0xCA7B, 0xCA7C, 0xCA7D, 0xCA7E, 0xCA7F,   // CA70 - CA7F
	0xCA80, 0xCA81, 0xCA82, 0xCA83, 0xCA84, 0xCA85, 0xCA86, 0xCA87, 0xCA88, 0xCA89, 0xCA8A, 0xCA8B, 0xCA8C, 0xCA8D, 0xCA8E, 0xCA8F,   // CA80 - CA8F
	0xCA90, 0xCA91, 0xCA92, 0xCA93, 0xCA94, 0xCA95, 0xCA96, 0xCA97, 0xCA98, 0xCA99, 0xCA9A, 0xCA9B, 0xCA9C, 0xCA9D, 0xCA9E, 0xCA9F,   // CA90 - CA9F
	0xCAA0, 0xCAA1, 0xCAA2, 0xCAA3, 0xCAA4, 0xCAA5, 0xCAA6, 0xCAA7, 0xCAA8, 0xCAA9, 0xCAAA, 0xCAAB, 0xCAAC, 0xCAAD, 0xCAAE, 0xCAAF,   // CAA0 - CAAF
	0xCAB0, 0xCAB1, 0xCAB2, 0xCAB3, 0xCAB4, 0xCAB5, 0xCAB6, 0xCAB7, 0xCAB8, 0xCAB9, 0xCABA, 0xCABB, 0xCABC, 0xCABD, 0xCABE, 0xCABF,   // CAB0 - CABF
	0xCAC0, 0xCAC1, 0xCAC2, 0xCAC3, 0xCAC4, 0xCAC5, 0xCAC6, 0xCAC7, 0xCAC8, 0xCAC9, 0xCACA, 0xCACB, 0xCACC, 0xCACD, 0xCACE, 0xCACF,   // CAC0 - CACF
	0xCAD0, 0xCAD1, 0xCAD2, 0xCAD3, 0xCAD4, 0xCAD5, 0xCAD6, 0xCAD7, 0xCAD8, 0xCAD9, 0xCADA, 0xCADB, 0xCADC, 0xCADD, 0xCADE, 0xCADF,   // CAD0 - CADF
	0xCAE0, 0xCAE1, 0xCAE2, 0xCAE3, 0xCAE4, 0xCAE5, 0xCAE6, 0xCAE7, 0xCAE8, 0xCAE9, 0xCAEA, 0xCAEB, 0xCAEC, 0xCAED, 0xCAEE, 0xCAEF,   // CAE0 - CAEF
	0xCAF0, 0xCAF1, 0xCAF2, 0xCAF3, 0xCAF4, 0xCAF5, 0xCAF6, 0xCAF7, 0xCAF8, 0xCAF9, 0xCAFA, 0xCAFB, 0xCAFC, 0xCAFD, 0xCAFE, 0xCAFF,   // CAF0 - CAFF
	0xCB00, 0xCB01, 0xCB02, 0xCB03, 0xCB04, 0xCB05, 0xCB06, 0xCB07, 0xCB08, 0xCB09, 0xCB0A, 0xCB0B, 0xCB0C, 0xCB0D, 0xCB0E, 0xCB0F,   // CB00 - CB0F
	0xCB10, 0xCB11, 0xCB12, 0xCB13, 0xCB14, 0xCB15, 0xCB16, 0xCB17, 0xCB18, 0xCB19, 0xCB1A, 0xCB1B, 0xCB1C, 0xCB1D, 0xCB1E, 0xCB1F,   // CB10 - CB1F
	0xCB20, 0xCB21, 0xCB22, 0xCB23, 0xCB24, 0xCB25, 0xCB26, 0xCB27, 0xCB28, 0xCB29, 0xCB2A, 0xCB2B, 0xCB2C, 0xCB2D, 0xCB2E, 0xCB2F,   // CB20 - CB2F
	0xCB30, 0xCB31, 0xCB32, 0xCB33, 0xCB34, 0xCB35, 0xCB36, 0xCB37, 0xCB38, 0xCB39, 0xCB3A, 0xCB3B, 0xCB3C, 0xCB3D, 0xCB3E, 0xCB3F,   // CB30 - CB3F
	0xCB40, 0xCB41, 0xCB42, 0xCB43, 0xCB44, 0xCB45, 0xCB46, 0xCB47, 0xCB48, 0xCB49, 0xCB4A, 0xCB4B, 0xCB4C, 0xCB4D, 0xCB4E, 0xCB4F,   // CB40 - CB4F
	0xCB50, 0xCB51, 0xCB52, 0xCB53, 0xCB54, 0xCB55, 0xCB56, 0xCB57, 0xCB58, 0xCB59, 0xCB5A, 0xCB5B, 0xCB5C, 0xCB5D, 0xCB5E, 0xCB5F,   // CB50 - CB5F
	0xCB60, 0xCB61, 0xCB62, 0xCB63, 0xCB64, 0xCB65, 0xCB66, 0xCB67, 0xCB68, 0xCB69, 0xCB6A, 0xCB6B, 0xCB6C, 0xCB6D, 0xCB6E, 0xCB6F,   // CB60 - CB6F
	0xCB70, 0xCB71, 0xCB72, 0xCB73, 0xCB74, 0xCB75, 0xCB76, 0xCB77, 0xCB78, 0xCB79, 0xCB7A, 0xCB7B, 0xCB7C, 0xCB7D, 0xCB7E, 0xCB7F,   // CB70 - CB7F
	0xCB80, 0xCB81, 0xCB82, 0xCB83, 0xCB84, 0xCB85, 0xCB86, 0xCB87, 0xCB88, 0xCB89, 0xCB8A, 0xCB8B, 0xCB8C, 0xCB8D, 0xCB8E, 0xCB8F,   // CB80 - CB8F
	0xCB90, 0xCB91, 0xCB92, 0xCB93, 0xCB94, 0xCB95, 0xCB96, 0xCB97, 0xCB98, 0xCB99, 0xCB9A, 0xCB9B, 0xCB9C, 0xCB9D, 0xCB9E, 0xCB9F,   // CB90 - CB9F
	0xCBA0, 0xCBA1, 0xCBA2, 0xCBA3, 0xCBA4, 0xCBA5, 0xCBA6, 0xCBA7, 0xCBA8, 0xCBA9, 0xCBAA, 0xCBAB, 0xCBAC, 0xCBAD, 0xCBAE, 0xCBAF,   // CBA0 - CBAF
	0xCBB0, 0xCBB1, 0xCBB2, 0xCBB3, 0xCBB4, 0xCBB5, 0xCBB6, 0xCBB7, 0xCBB8, 0xCBB9, 0xCBBA, 0xCBBB, 0xCBBC, 0xCBBD, 0xCBBE, 0xCBBF,   // CBB0 - CBBF
	0xCBC0, 0xCBC1, 0xCBC2, 0xCBC3, 0xCBC4, 0xCBC5, 0xCBC6, 0xCBC7, 0xCBC8, 0xCBC9, 0xCBCA, 0xCBCB, 0xCBCC, 0xCBCD, 0xCBCE, 0xCBCF,   // CBC0 - CBCF
	0xCBD0, 0xCBD1, 0xCBD2, 0xCBD3, 0xCBD4, 0xCBD5, 0xCBD6, 0xCBD7, 0xCBD8, 0xCBD9, 0xCBDA, 0xCBDB, 0xCBDC, 0xCBDD, 0xCBDE, 0xCBDF,   // CBD0 - CBDF
	0xCBE0, 0xCBE1, 0xCBE2, 0xCBE3, 0xCBE4, 0xCBE5, 0xCBE6, 0xCBE7, 0xCBE8, 0xCBE9, 0xCBEA, 0xCBEB, 0xCBEC, 0xCBED, 0xCBEE, 0xCBEF,   // CBE0 - CBEF
	0xCBF0, 0xCBF1, 0xCBF2, 0xCBF3, 0xCBF4, 0xCBF5, 0xCBF6, 0xCBF7, 0xCBF8, 0xCBF9, 0xCBFA, 0xCBFB, 0xCBFC, 0xCBFD, 0xCBFE, 0xCBFF,   // CBF0 - CBFF
	0xCC00, 0xCC01, 0xCC02, 0xCC03, 0xCC04, 0xCC05, 0xCC06, 0xCC07, 0xCC08, 0xCC09, 0xCC0A, 0xCC0B, 0xCC0C, 0xCC0D, 0xCC0E, 0xCC0F,   // CC00 - CC0F
	0xCC10, 0xCC11, 0xCC12, 0xCC13, 0xCC14, 0xCC15, 0xCC16, 0xCC17, 0xCC18, 0xCC19, 0xCC1A, 0xCC1B, 0xCC1C, 0xCC1D, 0xCC1E, 0xCC1F,   // CC10 - CC1F
	0xCC20, 0xCC21, 0xCC22, 0xCC23, 0xCC24, 0xCC25, 0xCC26, 0xCC27, 0xCC28, 0xCC29, 0xCC2A, 0xCC2B, 0xCC2C, 0xCC2D, 0xCC2E, 0xCC2F,   // CC20 - CC2F
	0xCC30, 0xCC31, 0xCC32, 0xCC33, 0xCC34, 0xCC35, 0xCC36, 0xCC37, 0xCC38, 0xCC39, 0xCC3A, 0xCC3B, 0xCC3C, 0xCC3D, 0xCC3E, 0xCC3F,   // CC30 - CC3F
	0xCC40, 0xCC41, 0xCC42, 0xCC43, 0xCC44, 0xCC45, 0xCC46, 0xCC47, 0xCC48, 0xCC49, 0xCC4A, 0xCC4B, 0xCC4C, 0xCC4D, 0xCC4E, 0xCC4F,   // CC40 - CC4F
	0xCC50, 0xCC51, 0xCC52, 0xCC53, 0xCC54, 0xCC55, 0xCC56, 0xCC57, 0xCC58, 0xCC59, 0xCC5A, 0xCC5B, 0xCC5C, 0xCC5D, 0xCC5E, 0xCC5F,   // CC50 - CC5F
	0xCC60, 0xCC61, 0xCC62, 0xCC63, 0xCC64, 0xCC65, 0xCC66, 0xCC67, 0xCC68, 0xCC69, 0xCC6A, 0xCC6B, 0xCC6C, 0xCC6D, 0xCC6E, 0xCC6F,   // CC60 - CC6F
	0xCC70, 0xCC71, 0xCC72, 0xCC73, 0xCC74, 0xCC75, 0xCC76, 0xCC77, 0xCC78, 0xCC79, 0xCC7A, 0xCC7B, 0xCC7C, 0xCC7D, 0xCC7E, 0xCC7F,   // CC70 - CC7F
	0xCC80, 0xCC81, 0xCC82, 0xCC83, 0xCC84, 0xCC85, 0xCC86, 0xCC87, 0xCC88, 0xCC89, 0xCC8A, 0xCC8B, 0xCC8C, 0xCC8D, 0xCC8E, 0xCC8F,   // CC80 - CC8F
	0xCC90, 0xCC91, 0xCC92, 0xCC93, 0xCC94, 0xCC95, 0xCC96, 0xCC97, 0xCC98, 0xCC99, 0xCC9A, 0xCC9B, 0xCC9C, 0xCC9D, 0xCC9E, 0xCC9F,   // CC90 - CC9F
	0xCCA0, 0xCCA1, 0xCCA2, 0xCCA3, 0xCCA4, 0xCCA5, 0xCCA6, 0xCCA7, 0xCCA8, 0xCCA9, 0xCCAA, 0xCCAB, 0xCCAC, 0xCCAD, 0xCCAE, 0xCCAF,   // CCA0 - CCAF
	0xCCB0, 0xCCB1, 0xCCB2, 0xCCB3, 0xCCB4, 0xCCB5, 0xCCB6, 0xCCB7, 0xCCB8, 0xCCB9, 0xCCBA, 0xCCBB, 0xCCBC, 0xCCBD, 0xCCBE, 0xCCBF,   // CCB0 - CCBF
	0xCCC0, 0xCCC1, 0xCCC2, 0xCCC3, 0xCCC4, 0xCCC5, 0xCCC6, 0xCCC7, 0xCCC8, 0xCCC9, 0xCCCA, 0xCCCB, 0xCCCC, 0xCCCD, 0xCCCE, 0xCCCF,   // CCC0 - CCCF
	0xCCD0, 0xCCD1, 0xCCD2, 0xCCD3, 0xCCD4, 0xCCD5, 0xCCD6, 0xCCD7, 0xCCD8, 0xCCD9, 0xCCDA, 0xCCDB, 0xCCDC, 0xCCDD, 0xCCDE, 0xCCDF,   // CCD0 - CCDF
	0xCCE0, 0xCCE1, 0xCCE2, 0xCCE3, 0xCCE4, 0xCCE5, 0xCCE6, 0xCCE7, 0xCCE8, 0xCCE9, 0xCCEA, 0xCCEB, 0xCCEC, 0xCCED, 0xCCEE, 0xCCEF,   // CCE0 - CCEF
	0xCCF0, 0xCCF1, 0xCCF2, 0xCCF3, 0xCCF4, 0xCCF5, 0xCCF6, 0xCCF7, 0xCCF8, 0xCCF9, 0xCCFA, 0xCCFB, 0xCCFC, 0xCCFD, 0xCCFE, 0xCCFF,   // CCF0 - CCFF
	0xCD00, 0xCD01, 0xCD02, 0xCD03, 0xCD04, 0xCD05, 0xCD06, 0xCD07, 0xCD08, 0xCD09, 0xCD0A, 0xCD0B, 0xCD0C, 0xCD0D, 0xCD0E, 0xCD0F,   // CD00 - CD0F
	0xCD10, 0xCD11, 0xCD12, 0xCD13, 0xCD14, 0xCD15, 0xCD16, 0xCD17, 0xCD18, 0xCD19, 0xCD1A, 0xCD1B, 0xCD1C, 0xCD1D, 0xCD1E, 0xCD1F,   // CD10 - CD1F
	0xCD20, 0xCD21, 0xCD22, 0xCD23, 0xCD24, 0xCD25, 0xCD26, 0xCD27, 0xCD28, 0xCD29, 0xCD2A, 0xCD2B, 0xCD2C, 0xCD2D, 0xCD2E, 0xCD2F,   // CD20 - CD2F
	0xCD30, 0xCD31, 0xCD32, 0xCD33, 0xCD34, 0xCD35, 0xCD36, 0xCD37, 0xCD38, 0xCD39, 0xCD3A, 0xCD3B, 0xCD3C, 0xCD3D, 0xCD3E, 0xCD3F,   // CD30 - CD3F
	0xCD40, 0xCD41, 0xCD42, 0xCD43, 0xCD44, 0xCD45, 0xCD46, 0xCD47, 0xCD48, 0xCD49, 0xCD4A, 0xCD4B, 0xCD4C, 0xCD4D, 0xCD4E, 0xCD4F,   // CD40 - CD4F
	0xCD50, 0xCD51, 0xCD52, 0xCD53, 0xCD54, 0xCD55, 0xCD56, 0xCD57, 0xCD58, 0xCD59, 0xCD5A, 0xCD5B, 0xCD5C, 0xCD5D, 0xCD5E, 0xCD5F,   // CD50 - CD5F
	0xCD60, 0xCD61, 0xCD62, 0xCD63, 0xCD64, 0xCD65, 0xCD66, 0xCD67, 0xCD68, 0xCD69, 0xCD6A, 0xCD6B, 0xCD6C, 0xCD6D, 0xCD6E, 0xCD6F,   // CD60 - CD6F
	0xCD70, 0xCD71, 0xCD72, 0xCD73, 0xCD74, 0xCD75, 0xCD76, 0xCD77, 0xCD78, 0xCD79, 0xCD7A, 0xCD7B, 0xCD7C, 0xCD7D, 0xCD7E, 0xCD7F,   // CD70 - CD7F
	0xCD80, 0xCD81, 0xCD82, 0xCD83, 0xCD84, 0xCD85, 0xCD86, 0xCD87, 0xCD88, 0xCD89, 0xCD8A, 0xCD8B, 0xCD8C, 0xCD8D, 0xCD8E, 0xCD8F,   // CD80 - CD8F
	0xCD90, 0xCD91, 0xCD92, 0xCD93, 0xCD94, 0xCD95, 0xCD96, 0xCD97, 0xCD98, 0xCD99, 0xCD9A, 0xCD9B, 0xCD9C, 0xCD9D, 0xCD9E, 0xCD9F,   // CD90 - CD9F
	0xCDA0, 0xCDA1, 0xCDA2, 0xCDA3, 0xCDA4, 0xCDA5, 0xCDA6, 0xCDA7, 0xCDA8, 0xCDA9, 0xCDAA, 0xCDAB, 0xCDAC, 0xCDAD, 0xCDAE, 0xCDAF,   // CDA0 - CDAF
	0xCDB0, 0xCDB1, 0xCDB2, 0xCDB3, 0xCDB4, 0xCDB5, 0xCDB6, 0xCDB7, 0xCDB8, 0xCDB9, 0xCDBA, 0xCDBB, 0xCDBC, 0xCDBD, 0xCDBE, 0xCDBF,   // CDB0 - CDBF
	0xCDC0, 0xCDC1, 0xCDC2, 0xCDC3, 0xCDC4, 0xCDC5, 0xCDC6, 0xCDC7, 0xCDC8, 0xCDC9, 0xCDCA, 0xCDCB, 0xCDCC, 0xCDCD, 0xCDCE, 0xCDCF,   // CDC0 - CDCF
	0xCDD0, 0xCDD1, 0xCDD2, 0xCDD3, 0xCDD4, 0xCDD5, 0xCDD6, 0xCDD7, 0xCDD8, 0xCDD9, 0xCDDA, 0xCDDB, 0xCDDC, 0xCDDD, 0xCDDE, 0xCDDF,   // CDD0 - CDDF
	0xCDE0, 0xCDE1, 0xCDE2, 0xCDE3, 0xCDE4, 0xCDE5, 0xCDE6, 0xCDE7, 0xCDE8, 0xCDE9, 0xCDEA, 0xCDEB, 0xCDEC, 0xCDED, 0xCDEE, 0xCDEF,   // CDE0 - CDEF
	0xCDF0, 0xCDF1, 0xCDF2, 0xCDF3, 0xCDF4, 0xCDF5, 0xCDF6, 0xCDF7, 0xCDF8, 0xCDF9, 0xCDFA, 0xCDFB, 0xCDFC, 0xCDFD, 0xCDFE, 0xCDFF,   // CDF0 - CDFF
	0xCE00, 0xCE01, 0xCE02, 0xCE03, 0xCE04, 0xCE05, 0xCE06, 0xCE07, 0xCE08, 0xCE09, 0xCE0A, 0xCE0B, 0xCE0C, 0xCE0D, 0xCE0E, 0xCE0F,   // CE00 - CE0F
	0xCE10, 0xCE11, 0xCE12, 0xCE13, 0xCE14, 0xCE15, 0xCE16, 0xCE17, 0xCE18, 0xCE19, 0xCE1A, 0xCE1B, 0xCE1C, 0xCE1D, 0xCE1E, 0xCE1F,   // CE10 - CE1F
	0xCE20, 0xCE21, 0xCE22, 0xCE23, 0xCE24, 0xCE25, 0xCE26, 0xCE27, 0xCE28, 0xCE29, 0xCE2A, 0xCE2B, 0xCE2C, 0xCE2D, 0xCE2E, 0xCE2F,   // CE20 - CE2F
	0xCE30, 0xCE31, 0xCE32, 0xCE33, 0xCE34, 0xCE35, 0xCE36, 0xCE37, 0xCE38, 0xCE39, 0xCE3A, 0xCE3B, 0xCE3C, 0xCE3D, 0xCE3E, 0xCE3F,   // CE30 - CE3F
	0xCE40, 0xCE41, 0xCE42, 0xCE43, 0xCE44, 0xCE45, 0xCE46, 0xCE47, 0xCE48, 0xCE49, 0xCE4A, 0xCE4B, 0xCE4C, 0xCE4D, 0xCE4E, 0xCE4F,   // CE40 - CE4F
	0xCE50, 0xCE51, 0xCE52, 0xCE53, 0xCE54, 0xCE55, 0xCE56, 0xCE57, 0xCE58, 0xCE59, 0xCE5A, 0xCE5B, 0xCE5C, 0xCE5D, 0xCE5E, 0xCE5F,   // CE50 - CE5F
	0xCE60, 0xCE61, 0xCE62, 0xCE63, 0xCE64, 0xCE65, 0xCE66, 0xCE67, 0xCE68, 0xCE69, 0xCE6A, 0xCE6B, 0xCE6C, 0xCE6D, 0xCE6E, 0xCE6F,   // CE60 - CE6F
	0xCE70, 0xCE71, 0xCE72, 0xCE73, 0xCE74, 0xCE75, 0xCE76, 0xCE77, 0xCE78, 0xCE79, 0xCE7A, 0xCE7B, 0xCE7C, 0xCE7D, 0xCE7E, 0xCE7F,   // CE70 - CE7F
	0xCE80, 0xCE81, 0xCE82, 0xCE83, 0xCE84, 0xCE85, 0xCE86, 0xCE87, 0xCE88, 0xCE89, 0xCE8A, 0xCE8B, 0xCE8C, 0xCE8D, 0xCE8E, 0xCE8F,   // CE80 - CE8F
	0xCE90, 0xCE91, 0xCE92, 0xCE93, 0xCE94, 0xCE95, 0xCE96, 0xCE97, 0xCE98, 0xCE99, 0xCE9A, 0xCE9B, 0xCE9C, 0xCE9D, 0xCE9E, 0xCE9F,   // CE90 - CE9F
	0xCEA0, 0xCEA1, 0xCEA2, 0xCEA3, 0xCEA4, 0xCEA5, 0xCEA6, 0xCEA7, 0xCEA8, 0xCEA9, 0xCEAA, 0xCEAB, 0xCEAC, 0xCEAD, 0xCEAE, 0xCEAF,   // CEA0 - CEAF
	0xCEB0, 0xCEB1, 0xCEB2, 0xCEB3, 0xCEB4, 0xCEB5, 0xCEB6, 0xCEB7, 0xCEB8, 0xCEB9, 0xCEBA, 0xCEBB, 0xCEBC, 0xCEBD, 0xCEBE, 0xCEBF,   // CEB0 - CEBF
	0xCEC0, 0xCEC1, 0xCEC2, 0xCEC3, 0xCEC4, 0xCEC5, 0xCEC6, 0xCEC7, 0xCEC8, 0xCEC9, 0xCECA, 0xCECB, 0xCECC, 0xCECD, 0xCECE, 0xCECF,   // CEC0 - CECF
	0xCED0, 0xCED1, 0xCED2, 0xCED3, 0xCED4, 0xCED5, 0xCED6, 0xCED7, 0xCED8, 0xCED9, 0xCEDA, 0xCEDB, 0xCEDC, 0xCEDD, 0xCEDE, 0xCEDF,   // CED0 - CEDF
	0xCEE0, 0xCEE1, 0xCEE2, 0xCEE3, 0xCEE4, 0xCEE5, 0xCEE6, 0xCEE7, 0xCEE8, 0xCEE9, 0xCEEA, 0xCEEB, 0xCEEC, 0xCEED, 0xCEEE, 0xCEEF,   // CEE0 - CEEF
	0xCEF0, 0xCEF1, 0xCEF2, 0xCEF3, 0xCEF4, 0xCEF5, 0xCEF6, 0xCEF7, 0xCEF8, 0xCEF9, 0xCEFA, 0xCEFB, 0xCEFC, 0xCEFD, 0xCEFE, 0xCEFF,   // CEF0 - CEFF
	0xCF00, 0xCF01, 0xCF02, 0xCF03, 0xCF04, 0xCF05, 0xCF06, 0xCF07, 0xCF08, 0xCF09, 0xCF0A, 0xCF0B, 0xCF0C, 0xCF0D, 0xCF0E, 0xCF0F,   // CF00 - CF0F
	0xCF10, 0xCF11, 0xCF12, 0xCF13, 0xCF14, 0xCF15, 0xCF16, 0xCF17, 0xCF18, 0xCF19, 0xCF1A, 0xCF1B, 0xCF1C, 0xCF1D, 0xCF1E, 0xCF1F,   // CF10 - CF1F
	0xCF20, 0xCF21, 0xCF22, 0xCF23, 0xCF24, 0xCF25, 0xCF26, 0xCF27, 0xCF28, 0xCF29, 0xCF2A, 0xCF2B, 0xCF2C, 0xCF2D, 0xCF2E, 0xCF2F,   // CF20 - CF2F
	0xCF30, 0xCF31, 0xCF32, 0xCF33, 0xCF34, 0xCF35, 0xCF36, 0xCF37, 0xCF38, 0xCF39, 0xCF3A, 0xCF3B, 0xCF3C, 0xCF3D, 0xCF3E, 0xCF3F,   // CF30 - CF3F
	0xCF40, 0xCF41, 0xCF42, 0xCF43, 0xCF44, 0xCF45, 0xCF46, 0xCF47, 0xCF48, 0xCF49, 0xCF4A, 0xCF4B, 0xCF4C, 0xCF4D, 0xCF4E, 0xCF4F,   // CF40 - CF4F
	0xCF50, 0xCF51, 0xCF52, 0xCF53, 0xCF54, 0xCF55, 0xCF56, 0xCF57, 0xCF58, 0xCF59, 0xCF5A, 0xCF5B, 0xCF5C, 0xCF5D, 0xCF5E, 0xCF5F,   // CF50 - CF5F
	0xCF60, 0xCF61, 0xCF62, 0xCF63, 0xCF64, 0xCF65, 0xCF66, 0xCF67, 0xCF68, 0xCF69, 0xCF6A, 0xCF6B, 0xCF6C, 0xCF6D, 0xCF6E, 0xCF6F,   // CF60 - CF6F
	0xCF70, 0xCF71, 0xCF72, 0xCF73, 0xCF74, 0xCF75, 0xCF76, 0xCF77, 0xCF78, 0xCF79, 0xCF7A, 0xCF7B, 0xCF7C, 0xCF7D, 0xCF7E, 0xCF7F,   // CF70 - CF7F
	0xCF80, 0xCF81, 0xCF82, 0xCF83, 0xCF84, 0xCF85, 0xCF86, 0xCF87, 0xCF88, 0xCF89, 0xCF8A, 0xCF8B, 0xCF8C, 0xCF8D, 0xCF8E, 0xCF8F,   // CF80 - CF8F
	0xCF90, 0xCF91, 0xCF92, 0xCF93, 0xCF94, 0xCF95, 0xCF96, 0xCF97, 0xCF98, 0xCF99, 0xCF9A, 0xCF9B, 0xCF9C, 0xCF9D, 0xCF9E, 0xCF9F,   // CF90 - CF9F
	0xCFA0, 0xCFA1, 0xCFA2, 0xCFA3, 0xCFA4, 0xCFA5, 0xCFA6, 0xCFA7, 0xCFA8, 0xCFA9, 0xCFAA, 0xCFAB, 0xCFAC, 0xCFAD, 0xCFAE, 0xCFAF,   // CFA0 - CFAF
	0xCFB0, 0xCFB1, 0xCFB2, 0xCFB3, 0xCFB4, 0xCFB5, 0xCFB6, 0xCFB7, 0xCFB8, 0xCFB9, 0xCFBA, 0xCFBB, 0xCFBC, 0xCFBD, 0xCFBE, 0xCFBF,   // CFB0 - CFBF
	0xCFC0, 0xCFC1, 0xCFC2, 0xCFC3, 0xCFC4, 0xCFC5, 0xCFC6, 0xCFC7, 0xCFC8, 0xCFC9, 0xCFCA, 0xCFCB, 0xCFCC, 0xCFCD, 0xCFCE, 0xCFCF,   // CFC0 - CFCF
	0xCFD0, 0xCFD1, 0xCFD2, 0xCFD3, 0xCFD4, 0xCFD5, 0xCFD6, 0xCFD7, 0xCFD8, 0xCFD9, 0xCFDA, 0xCFDB, 0xCFDC, 0xCFDD, 0xCFDE, 0xCFDF,   // CFD0 - CFDF
	0xCFE0, 0xCFE1, 0xCFE2, 0xCFE3, 0xCFE4, 0xCFE5, 0xCFE6, 0xCFE7, 0xCFE8, 0xCFE9, 0xCFEA, 0xCFEB, 0xCFEC, 0xCFED, 0xCFEE, 0xCFEF,   // CFE0 - CFEF
	0xCFF0, 0xCFF1, 0xCFF2, 0xCFF3, 0xCFF4, 0xCFF5, 0xCFF6, 0xCFF7, 0xCFF8, 0xCFF9, 0xCFFA, 0xCFFB, 0xCFFC, 0xCFFD, 0xCFFE, 0xCFFF,   // CFF0 - CFFF
	0xD000, 0xD001, 0xD002, 0xD003, 0xD004, 0xD005, 0xD006, 0xD007, 0xD008, 0xD009, 0xD00A, 0xD00B, 0xD00C, 0xD00D, 0xD00E, 0xD00F,   // D000 - D00F
	0xD010, 0xD011, 0xD012, 0xD013, 0xD014, 0xD015, 0xD016, 0xD017, 0xD018, 0xD019, 0xD01A, 0xD01B, 0xD01C, 0xD01D, 0xD01E, 0xD01F,   // D010 - D01F
	0xD020, 0xD021, 0xD022, 0xD023, 0xD024, 0xD025, 0xD026, 0xD027, 0xD028, 0xD029, 0xD02A, 0xD02B, 0xD02C, 0xD02D, 0xD02E, 0xD02F,   // D020 - D02F
	0xD030, 0xD031, 0xD032, 0xD033, 0xD034, 0xD035, 0xD036, 0xD037, 0xD038, 0xD039, 0xD03A, 0xD03B, 0xD03C, 0xD03D, 0xD03E, 0xD03F,   // D030 - D03F
	0xD040, 0xD041, 0xD042, 0xD043, 0xD044, 0xD045, 0xD046, 0xD047, 0xD048, 0xD049, 0xD04A, 0xD04B, 0xD04C, 0xD04D, 0xD04E, 0xD04F,   // D040 - D04F
	0xD050, 0xD051, 0xD052, 0xD053, 0xD054, 0xD055, 0xD056, 0xD057, 0xD058, 0xD059, 0xD05A, 0xD05B, 0xD05C, 0xD05D, 0xD05E, 0xD05F,   // D050 - D05F
	0xD060, 0xD061, 0xD062, 0xD063, 0xD064, 0xD065, 0xD066, 0xD067, 0xD068, 0xD069, 0xD06A, 0xD06B, 0xD06C, 0xD06D, 0xD06E, 0xD06F,   // D060 - D06F
	0xD070, 0xD071, 0xD072, 0xD073, 0xD074, 0xD075, 0xD076, 0xD077, 0xD078, 0xD079, 0xD07A, 0xD07B, 0xD07C, 0xD07D, 0xD07E, 0xD07F,   // D070 - D07F
	0xD080, 0xD081, 0xD082, 0xD083, 0xD084, 0xD085, 0xD086, 0xD087, 0xD088, 0xD089, 0xD08A, 0xD08B, 0xD08C, 0xD08D, 0xD08E, 0xD08F,   // D080 - D08F
	0xD090, 0xD091, 0xD092, 0xD093, 0xD094, 0xD095, 0xD096, 0xD097, 0xD098, 0xD099, 0xD09A, 0xD09B, 0xD09C, 0xD09D, 0xD09E, 0xD09F,   // D090 - D09F
	0xD0A0, 0xD0A1, 0xD0A2, 0xD0A3, 0xD0A4, 0xD0A5, 0xD0A6, 0xD0A7, 0xD0A8, 0xD0A9, 0xD0AA, 0xD0AB, 0xD0AC, 0xD0AD, 0xD0AE, 0xD0AF,   // D0A0 - D0AF
	0xD0B0, 0xD0B1, 0xD0B2, 0xD0B3, 0xD0B4, 0xD0B5, 0xD0B6, 0xD0B7, 0xD0B8, 0xD0B9, 0xD0BA, 0xD0BB, 0xD0BC, 0xD0BD, 0xD0BE, 0xD0BF,   // D0B0 - D0BF
	0xD0C0, 0xD0C1, 0xD0C2, 0xD0C3, 0xD0C4, 0xD0C5, 0xD0C6, 0xD0C7, 0xD0C8, 0xD0C9, 0xD0CA, 0xD0CB, 0xD0CC, 0xD0CD, 0xD0CE, 0xD0CF,   // D0C0 - D0CF
	0xD0D0, 0xD0D1, 0xD0D2, 0xD0D3, 0xD0D4, 0xD0D5, 0xD0D6, 0xD0D7, 0xD0D8, 0xD0D9, 0xD0DA, 0xD0DB, 0xD0DC, 0xD0DD, 0xD0DE, 0xD0DF,   // D0D0 - D0DF
	0xD0E0, 0xD0E1, 0xD0E2, 0xD0E3, 0xD0E4, 0xD0E5, 0xD0E6, 0xD0E7, 0xD0E8, 0xD0E9, 0xD0EA, 0xD0EB, 0xD0EC, 0xD0ED, 0xD0EE, 0xD0EF,   // D0E0 - D0EF
	0xD0F0, 0xD0F1, 0xD0F2, 0xD0F3, 0xD0F4, 0xD0F5, 0xD0F6, 0xD0F7, 0xD0F8, 0xD0F9, 0xD0FA, 0xD0FB, 0xD0FC, 0xD0FD, 0xD0FE, 0xD0FF,   // D0F0 - D0FF
	0xD100, 0xD101, 0xD102, 0xD103, 0xD104, 0xD105, 0xD106, 0xD107, 0xD108, 0xD109, 0xD10A, 0xD10B, 0xD10C, 0xD10D, 0xD10E, 0xD10F,   // D100 - D10F
	0xD110, 0xD111, 0xD112, 0xD113, 0xD114, 0xD115, 0xD116, 0xD117, 0xD118, 0xD119, 0xD11A, 0xD11B, 0xD11C, 0xD11D, 0xD11E, 0xD11F,   // D110 - D11F
	0xD120, 0xD121, 0xD122, 0xD123, 0xD124, 0xD125, 0xD126, 0xD127, 0xD128, 0xD129, 0xD12A, 0xD12B, 0xD12C, 0xD12D, 0xD12E, 0xD12F,   // D120 - D12F
	0xD130, 0xD131, 0xD132, 0xD133, 0xD134, 0xD135, 0xD136, 0xD137, 0xD138, 0xD139, 0xD13A, 0xD13B, 0xD13C, 0xD13D, 0xD13E, 0xD13F,   // D130 - D13F
	0xD140, 0xD141, 0xD142, 0xD143, 0xD144, 0xD145, 0xD146, 0xD147, 0xD148, 0xD149, 0xD14A, 0xD14B, 0xD14C, 0xD14D, 0xD14E, 0xD14F,   // D140 - D14F
	0xD150, 0xD151, 0xD152, 0xD153, 0xD154, 0xD155, 0xD156, 0xD157, 0xD158, 0xD159, 0xD15A, 0xD15B, 0xD15C, 0xD15D, 0xD15E, 0xD15F,   // D150 - D15F
	0xD160, 0xD161, 0xD162, 0xD163, 0xD164, 0xD165, 0xD166, 0xD167, 0xD168, 0xD169, 0xD16A, 0xD16B, 0xD16C, 0xD16D, 0xD16E, 0xD16F,   // D160 - D16F
	0xD170, 0xD171, 0xD172, 0xD173, 0xD174, 0xD175, 0xD176, 0xD177, 0xD178, 0xD179, 0xD17A, 0xD17B, 0xD17C, 0xD17D, 0xD17E, 0xD17F,   // D170 - D17F
	0xD180, 0xD181, 0xD182, 0xD183, 0xD184, 0xD185, 0xD186, 0xD187, 0xD188, 0xD189, 0xD18A, 0xD18B, 0xD18C, 0xD18D, 0xD18E, 0xD18F,   // D180 - D18F
	0xD190, 0xD191, 0xD192, 0xD193, 0xD194, 0xD195, 0xD196, 0xD197, 0xD198, 0xD199, 0xD19A, 0xD19B, 0xD19C, 0xD19D, 0xD19E, 0xD19F,   // D190 - D19F
	0xD1A0, 0xD1A1, 0xD1A2, 0xD1A3, 0xD1A4, 0xD1A5, 0xD1A6, 0xD1A7, 0xD1A8, 0xD1A9, 0xD1AA, 0xD1AB, 0xD1AC, 0xD1AD, 0xD1AE, 0xD1AF,   // D1A0 - D1AF
	0xD1B0, 0xD1B1, 0xD1B2, 0xD1B3, 0xD1B4, 0xD1B5, 0xD1B6, 0xD1B7, 0xD1B8, 0xD1B9, 0xD1BA, 0xD1BB, 0xD1BC, 0xD1BD, 0xD1BE, 0xD1BF,   // D1B0 - D1BF
	0xD1C0, 0xD1C1, 0xD1C2, 0xD1C3, 0xD1C4, 0xD1C5, 0xD1C6, 0xD1C7, 0xD1C8, 0xD1C9, 0xD1CA, 0xD1CB, 0xD1CC, 0xD1CD, 0xD1CE, 0xD1CF,   // D1C0 - D1CF
	0xD1D0, 0xD1D1, 0xD1D2, 0xD1D3, 0xD1D4, 0xD1D5, 0xD1D6, 0xD1D7, 0xD1D8, 0xD1D9, 0xD1DA, 0xD1DB, 0xD1DC, 0xD1DD, 0xD1DE, 0xD1DF,   // D1D0 - D1DF
	0xD1E0, 0xD1E1, 0xD1E2, 0xD1E3, 0xD1E4, 0xD1E5, 0xD1E6, 0xD1E7, 0xD1E8, 0xD1E9, 0xD1EA, 0xD1EB, 0xD1EC, 0xD1ED, 0xD1EE, 0xD1EF,   // D1E0 - D1EF
	0xD1F0, 0xD1F1, 0xD1F2, 0xD1F3, 0xD1F4, 0xD1F5, 0xD1F6, 0xD1F7, 0xD1F8, 0xD1F9, 0xD1FA, 0xD1FB, 0xD1FC, 0xD1FD, 0xD1FE, 0xD1FF,   // D1F0 - D1FF
	0xD200, 0xD201, 0xD202, 0xD203, 0xD204, 0xD205, 0xD206, 0xD207, 0xD208, 0xD209, 0xD20A, 0xD20B, 0xD20C, 0xD20D, 0xD20E, 0xD20F,   // D200 - D20F
	0xD210, 0xD211, 0xD212, 0xD213, 0xD214, 0xD215, 0xD216, 0xD217, 0xD218, 0xD219, 0xD21A, 0xD21B, 0xD21C, 0xD21D, 0xD21E, 0xD21F,   // D210 - D21F
	0xD220, 0xD221, 0xD222, 0xD223, 0xD224, 0xD225, 0xD226, 0xD227, 0xD228, 0xD229, 0xD22A, 0xD22B, 0xD22C, 0xD22D, 0xD22E, 0xD22F,   // D220 - D22F
	0xD230, 0xD231, 0xD232, 0xD233, 0xD234, 0xD235, 0xD236, 0xD237, 0xD238, 0xD239, 0xD23A, 0xD23B, 0xD23C, 0xD23D, 0xD23E, 0xD23F,   // D230 - D23F
	0xD240, 0xD241, 0xD242, 0xD243, 0xD244, 0xD245, 0xD246, 0xD247, 0xD248, 0xD249, 0xD24A, 0xD24B, 0xD24C, 0xD24D, 0xD24E, 0xD24F,   // D240 - D24F
	0xD250, 0xD251, 0xD252, 0xD253, 0xD254, 0xD255, 0xD256, 0xD257, 0xD258, 0xD259, 0xD25A, 0xD25B, 0xD25C, 0xD25D, 0xD25E, 0xD25F,   // D250 - D25F
	0xD260, 0xD261, 0xD262, 0xD263, 0xD264, 0xD265, 0xD266, 0xD267, 0xD268, 0xD269, 0xD26A, 0xD26B, 0xD26C, 0xD26D, 0xD26E, 0xD26F,   // D260 - D26F
	0xD270, 0xD271, 0xD272, 0xD273, 0xD274, 0xD275, 0xD276, 0xD277, 0xD278, 0xD279, 0xD27A, 0xD27B, 0xD27C, 0xD27D, 0xD27E, 0xD27F,   // D270 - D27F
	0xD280, 0xD281, 0xD282, 0xD283, 0xD284, 0xD285, 0xD286, 0xD287, 0xD288, 0xD289, 0xD28A, 0xD28B, 0xD28C, 0xD28D, 0xD28E, 0xD28F,   // D280 - D28F
	0xD290, 0xD291, 0xD292, 0xD293, 0xD294, 0xD295, 0xD296, 0xD297, 0xD298, 0xD299, 0xD29A, 0xD29B, 0xD29C, 0xD29D, 0xD29E, 0xD29F,   // D290 - D29F
	0xD2A0, 0xD2A1, 0xD2A2, 0xD2A3, 0xD2A4, 0xD2A5, 0xD2A6, 0xD2A7, 0xD2A8, 0xD2A9, 0xD2AA, 0xD2AB, 0xD2AC, 0xD2AD, 0xD2AE, 0xD2AF,   // D2A0 - D2AF
	0xD2B0, 0xD2B1, 0xD2B2, 0xD2B3, 0xD2B4, 0xD2B5, 0xD2B6, 0xD2B7, 0xD2B8, 0xD2B9, 0xD2BA, 0xD2BB, 0xD2BC, 0xD2BD, 0xD2BE, 0xD2BF,   // D2B0 - D2BF
	0xD2C0, 0xD2C1, 0xD2C2, 0xD2C3, 0xD2C4, 0xD2C5, 0xD2C6, 0xD2C7, 0xD2C8, 0xD2C9, 0xD2CA, 0xD2CB, 0xD2CC, 0xD2CD, 0xD2CE, 0xD2CF,   // D2C0 - D2CF
	0xD2D0, 0xD2D1, 0xD2D2, 0xD2D3, 0xD2D4, 0xD2D5, 0xD2D6, 0xD2D7, 0xD2D8, 0xD2D9, 0xD2DA, 0xD2DB, 0xD2DC, 0xD2DD, 0xD2DE, 0xD2DF,   // D2D0 - D2DF
	0xD2E0, 0xD2E1, 0xD2E2, 0xD2E3, 0xD2E4, 0xD2E5, 0xD2E6, 0xD2E7, 0xD2E8, 0xD2E9, 0xD2EA, 0xD2EB, 0xD2EC, 0xD2ED, 0xD2EE, 0xD2EF,   // D2E0 - D2EF
	0xD2F0, 0xD2F1, 0xD2F2, 0xD2F3, 0xD2F4, 0xD2F5, 0xD2F6, 0xD2F7, 0xD2F8, 0xD2F9, 0xD2FA, 0xD2FB, 0xD2FC, 0xD2FD, 0xD2FE, 0xD2FF,   // D2F0 - D2FF
	0xD300, 0xD301, 0xD302, 0xD303, 0xD304, 0xD305, 0xD306, 0xD307, 0xD308, 0xD309, 0xD30A, 0xD30B, 0xD30C, 0xD30D, 0xD30E, 0xD30F,   // D300 - D30F
	0xD310, 0xD311, 0xD312, 0xD313, 0xD314, 0xD315, 0xD316, 0xD317, 0xD318, 0xD319, 0xD31A, 0xD31B, 0xD31C, 0xD31D, 0xD31E, 0xD31F,   // D310 - D31F
	0xD320, 0xD321, 0xD322, 0xD323, 0xD324, 0xD325, 0xD326, 0xD327, 0xD328, 0xD329, 0xD32A, 0xD32B, 0xD32C, 0xD32D, 0xD32E, 0xD32F,   // D320 - D32F
	0xD330, 0xD331, 0xD332, 0xD333, 0xD334, 0xD335, 0xD336, 0xD337, 0xD338, 0xD339, 0xD33A, 0xD33B, 0xD33C, 0xD33D, 0xD33E, 0xD33F,   // D330 - D33F
	0xD340, 0xD341, 0xD342, 0xD343, 0xD344, 0xD345, 0xD346, 0xD347, 0xD348, 0xD349, 0xD34A, 0xD34B, 0xD34C, 0xD34D, 0xD34E, 0xD34F,   // D340 - D34F
	0xD350, 0xD351, 0xD352, 0xD353, 0xD354, 0xD355, 0xD356, 0xD357, 0xD358, 0xD359, 0xD35A, 0xD35B, 0xD35C, 0xD35D, 0xD35E, 0xD35F,   // D350 - D35F
	0xD360, 0xD361, 0xD362, 0xD363, 0xD364, 0xD365, 0xD366, 0xD367, 0xD368, 0xD369, 0xD36A, 0xD36B, 0xD36C, 0xD36D, 0xD36E, 0xD36F,   // D360 - D36F
	0xD370, 0xD371, 0xD372, 0xD373, 0xD374, 0xD375, 0xD376, 0xD377, 0xD378, 0xD379, 0xD37A, 0xD37B, 0xD37C, 0xD37D, 0xD37E, 0xD37F,   // D370 - D37F
	0xD380, 0xD381, 0xD382, 0xD383, 0xD384, 0xD385, 0xD386, 0xD387, 0xD388, 0xD389, 0xD38A, 0xD38B, 0xD38C, 0xD38D, 0xD38E, 0xD38F,   // D380 - D38F
	0xD390, 0xD391, 0xD392, 0xD393, 0xD394, 0xD395, 0xD396, 0xD397, 0xD398, 0xD399, 0xD39A, 0xD39B, 0xD39C, 0xD39D, 0xD39E, 0xD39F,   // D390 - D39F
	0xD3A0, 0xD3A1, 0xD3A2, 0xD3A3, 0xD3A4, 0xD3A5, 0xD3A6, 0xD3A7, 0xD3A8, 0xD3A9, 0xD3AA, 0xD3AB, 0xD3AC, 0xD3AD, 0xD3AE, 0xD3AF,   // D3A0 - D3AF
	0xD3B0, 0xD3B1, 0xD3B2, 0xD3B3, 0xD3B4, 0xD3B5, 0xD3B6, 0xD3B7, 0xD3B8, 0xD3B9, 0xD3BA, 0xD3BB, 0xD3BC, 0xD3BD, 0xD3BE, 0xD3BF,   // D3B0 - D3BF
	0xD3C0, 0xD3C1, 0xD3C2, 0xD3C3, 0xD3C4, 0xD3C5, 0xD3C6, 0xD3C7, 0xD3C8, 0xD3C9, 0xD3CA, 0xD3CB, 0xD3CC, 0xD3CD, 0xD3CE, 0xD3CF,   // D3C0 - D3CF
	0xD3D0, 0xD3D1, 0xD3D2, 0xD3D3, 0xD3D4, 0xD3D5, 0xD3D6, 0xD3D7, 0xD3D8, 0xD3D9, 0xD3DA, 0xD3DB, 0xD3DC, 0xD3DD, 0xD3DE, 0xD3DF,   // D3D0 - D3DF
	0xD3E0, 0xD3E1, 0xD3E2, 0xD3E3, 0xD3E4, 0xD3E5, 0xD3E6, 0xD3E7, 0xD3E8, 0xD3E9, 0xD3EA, 0xD3EB, 0xD3EC, 0xD3ED, 0xD3EE, 0xD3EF,   // D3E0 - D3EF
	0xD3F0, 0xD3F1, 0xD3F2, 0xD3F3, 0xD3F4, 0xD3F5, 0xD3F6, 0xD3F7, 0xD3F8, 0xD3F9, 0xD3FA, 0xD3FB, 0xD3FC, 0xD3FD, 0xD3FE, 0xD3FF,   // D3F0 - D3FF
	0xD400, 0xD401, 0xD402, 0xD403, 0xD404, 0xD405, 0xD406, 0xD407, 0xD408, 0xD409, 0xD40A, 0xD40B, 0xD40C, 0xD40D, 0xD40E, 0xD40F,   // D400 - D40F
	0xD410, 0xD411, 0xD412, 0xD413, 0xD414, 0xD415, 0xD416, 0xD417, 0xD418, 0xD419, 0xD41A, 0xD41B, 0xD41C, 0xD41D, 0xD41E, 0xD41F,   // D410 - D41F
	0xD420, 0xD421, 0xD422, 0xD423, 0xD424, 0xD425, 0xD426, 0xD427, 0xD428, 0xD429, 0xD42A, 0xD42B, 0xD42C, 0xD42D, 0xD42E, 0xD42F,   // D420 - D42F
	0xD430, 0xD431, 0xD432, 0xD433, 0xD434, 0xD435, 0xD436, 0xD437, 0xD438, 0xD439, 0xD43A, 0xD43B, 0xD43C, 0xD43D, 0xD43E, 0xD43F,   // D430 - D43F
	0xD440, 0xD441, 0xD442, 0xD443, 0xD444, 0xD445, 0xD446, 0xD447, 0xD448, 0xD449, 0xD44A, 0xD44B, 0xD44C, 0xD44D, 0xD44E, 0xD44F,   // D440 - D44F
	0xD450, 0xD451, 0xD452, 0xD453, 0xD454, 0xD455, 0xD456, 0xD457, 0xD458, 0xD459, 0xD45A, 0xD45B, 0xD45C, 0xD45D, 0xD45E, 0xD45F,   // D450 - D45F
	0xD460, 0xD461, 0xD462, 0xD463, 0xD464, 0xD465, 0xD466, 0xD467, 0xD468, 0xD469, 0xD46A, 0xD46B, 0xD46C, 0xD46D, 0xD46E, 0xD46F,   // D460 - D46F
	0xD470, 0xD471, 0xD472, 0xD473, 0xD474, 0xD475, 0xD476, 0xD477, 0xD478, 0xD479, 0xD47A, 0xD47B, 0xD47C, 0xD47D, 0xD47E, 0xD47F,   // D470 - D47F
	0xD480, 0xD481, 0xD482, 0xD483, 0xD484, 0xD485, 0xD486, 0xD487, 0xD488, 0xD489, 0xD48A, 0xD48B, 0xD48C, 0xD48D, 0xD48E, 0xD48F,   // D480 - D48F
	0xD490, 0xD491, 0xD492, 0xD493, 0xD494, 0xD495, 0xD496, 0xD497, 0xD498, 0xD499, 0xD49A, 0xD49B, 0xD49C, 0xD49D, 0xD49E, 0xD49F,   // D490 - D49F
	0xD4A0, 0xD4A1, 0xD4A2, 0xD4A3, 0xD4A4, 0xD4A5, 0xD4A6, 0xD4A7, 0xD4A8, 0xD4A9, 0xD4AA, 0xD4AB, 0xD4AC, 0xD4AD, 0xD4AE, 0xD4AF,   // D4A0 - D4AF
	0xD4B0, 0xD4B1, 0xD4B2, 0xD4B3, 0xD4B4, 0xD4B5, 0xD4B6, 0xD4B7, 0xD4B8, 0xD4B9, 0xD4BA, 0xD4BB, 0xD4BC, 0xD4BD, 0xD4BE, 0xD4BF,   // D4B0 - D4BF
	0xD4C0, 0xD4C1, 0xD4C2, 0xD4C3, 0xD4C4, 0xD4C5, 0xD4C6, 0xD4C7, 0xD4C8, 0xD4C9, 0xD4CA, 0xD4CB, 0xD4CC, 0xD4CD, 0xD4CE, 0xD4CF,   // D4C0 - D4CF
	0xD4D0, 0xD4D1, 0xD4D2, 0xD4D3, 0xD4D4, 0xD4D5, 0xD4D6, 0xD4D7, 0xD4D8, 0xD4D9, 0xD4DA, 0xD4DB, 0xD4DC, 0xD4DD, 0xD4DE, 0xD4DF,   // D4D0 - D4DF
	0xD4E0, 0xD4E1, 0xD4E2, 0xD4E3, 0xD4E4, 0xD4E5, 0xD4E6, 0xD4E7, 0xD4E8, 0xD4E9, 0xD4EA, 0xD4EB, 0xD4EC, 0xD4ED, 0xD4EE, 0xD4EF,   // D4E0 - D4EF
	0xD4F0, 0xD4F1, 0xD4F2, 0xD4F3, 0xD4F4, 0xD4F5, 0xD4F6, 0xD4F7, 0xD4F8, 0xD4F9, 0xD4FA, 0xD4FB, 0xD4FC, 0xD4FD, 0xD4FE, 0xD4FF,   // D4F0 - D4FF
	0xD500, 0xD501, 0xD502, 0xD503, 0xD504, 0xD505, 0xD506, 0xD507, 0xD508, 0xD509, 0xD50A, 0xD50B, 0xD50C, 0xD50D, 0xD50E, 0xD50F,   // D500 - D50F
	0xD510, 0xD511, 0xD512, 0xD513, 0xD514, 0xD515, 0xD516, 0xD517, 0xD518, 0xD519, 0xD51A, 0xD51B, 0xD51C, 0xD51D, 0xD51E, 0xD51F,   // D510 - D51F
	0xD520, 0xD521, 0xD522, 0xD523, 0xD524, 0xD525, 0xD526, 0xD527, 0xD528, 0xD529, 0xD52A, 0xD52B, 0xD52C, 0xD52D, 0xD52E, 0xD52F,   // D520 - D52F
	0xD530, 0xD531, 0xD532, 0xD533, 0xD534, 0xD535, 0xD536, 0xD537, 0xD538, 0xD539, 0xD53A, 0xD53B, 0xD53C, 0xD53D, 0xD53E, 0xD53F,   // D530 - D53F
	0xD540, 0xD541, 0xD542, 0xD543, 0xD544, 0xD545, 0xD546, 0xD547, 0xD548, 0xD549, 0xD54A, 0xD54B, 0xD54C, 0xD54D, 0xD54E, 0xD54F,   // D540 - D54F
	0xD550, 0xD551, 0xD552, 0xD553, 0xD554, 0xD555, 0xD556, 0xD557, 0xD558, 0xD559, 0xD55A, 0xD55B, 0xD55C, 0xD55D, 0xD55E, 0xD55F,   // D550 - D55F
	0xD560, 0xD561, 0xD562, 0xD563, 0xD564, 0xD565, 0xD566, 0xD567, 0xD568, 0xD569, 0xD56A, 0xD56B, 0xD56C, 0xD56D, 0xD56E, 0xD56F,   // D560 - D56F
	0xD570, 0xD571, 0xD572, 0xD573, 0xD574, 0xD575, 0xD576, 0xD577, 0xD578, 0xD579, 0xD57A, 0xD57B, 0xD57C, 0xD57D, 0xD57E, 0xD57F,   // D570 - D57F
	0xD580, 0xD581, 0xD582, 0xD583, 0xD584, 0xD585, 0xD586, 0xD587, 0xD588, 0xD589, 0xD58A, 0xD58B, 0xD58C, 0xD58D, 0xD58E, 0xD58F,   // D580 - D58F
	0xD590, 0xD591, 0xD592, 0xD593, 0xD594, 0xD595, 0xD596, 0xD597, 0xD598, 0xD599, 0xD59A, 0xD59B, 0xD59C, 0xD59D, 0xD59E, 0xD59F,   // D590 - D59F
	0xD5A0, 0xD5A1, 0xD5A2, 0xD5A3, 0xD5A4, 0xD5A5, 0xD5A6, 0xD5A7, 0xD5A8, 0xD5A9, 0xD5AA, 0xD5AB, 0xD5AC, 0xD5AD, 0xD5AE, 0xD5AF,   // D5A0 - D5AF
	0xD5B0, 0xD5B1, 0xD5B2, 0xD5B3, 0xD5B4, 0xD5B5, 0xD5B6, 0xD5B7, 0xD5B8, 0xD5B9, 0xD5BA, 0xD5BB, 0xD5BC, 0xD5BD, 0xD5BE, 0xD5BF,   // D5B0 - D5BF
	0xD5C0, 0xD5C1, 0xD5C2, 0xD5C3, 0xD5C4, 0xD5C5, 0xD5C6, 0xD5C7, 0xD5C8, 0xD5C9, 0xD5CA, 0xD5CB, 0xD5CC, 0xD5CD, 0xD5CE, 0xD5CF,   // D5C0 - D5CF
	0xD5D0, 0xD5D1, 0xD5D2, 0xD5D3, 0xD5D4, 0xD5D5, 0xD5D6, 0xD5D7, 0xD5D8, 0xD5D9, 0xD5DA, 0xD5DB, 0xD5DC, 0xD5DD, 0xD5DE, 0xD5DF,   // D5D0 - D5DF
	0xD5E0, 0xD5E1, 0xD5E2, 0xD5E3, 0xD5E4, 0xD5E5, 0xD5E6, 0xD5E7, 0xD5E8, 0xD5E9, 0xD5EA, 0xD5EB, 0xD5EC, 0xD5ED, 0xD5EE, 0xD5EF,   // D5E0 - D5EF
	0xD5F0, 0xD5F1, 0xD5F2, 0xD5F3, 0xD5F4, 0xD5F5, 0xD5F6, 0xD5F7, 0xD5F8, 0xD5F9, 0xD5FA, 0xD5FB, 0xD5FC, 0xD5FD, 0xD5FE, 0xD5FF,   // D5F0 - D5FF
	0xD600, 0xD601, 0xD602, 0xD603, 0xD604, 0xD605, 0xD606, 0xD607, 0xD608, 0xD609, 0xD60A, 0xD60B, 0xD60C, 0xD60D, 0xD60E, 0xD60F,   // D600 - D60F
	0xD610, 0xD611, 0xD612, 0xD613, 0xD614, 0xD615, 0xD616, 0xD617, 0xD618, 0xD619, 0xD61A, 0xD61B, 0xD61C, 0xD61D, 0xD61E, 0xD61F,   // D610 - D61F
	0xD620, 0xD621, 0xD622, 0xD623, 0xD624, 0xD625, 0xD626, 0xD627, 0xD628, 0xD629, 0xD62A, 0xD62B, 0xD62C, 0xD62D, 0xD62E, 0xD62F,   // D620 - D62F
	0xD630, 0xD631, 0xD632, 0xD633, 0xD634, 0xD635, 0xD636, 0xD637, 0xD638, 0xD639, 0xD63A, 0xD63B, 0xD63C, 0xD63D, 0xD63E, 0xD63F,   // D630 - D63F
	0xD640, 0xD641, 0xD642, 0xD643, 0xD644, 0xD645, 0xD646, 0xD647, 0xD648, 0xD649, 0xD64A, 0xD64B, 0xD64C, 0xD64D, 0xD64E, 0xD64F,   // D640 - D64F
	0xD650, 0xD651, 0xD652, 0xD653, 0xD654, 0xD655, 0xD656, 0xD657, 0xD658, 0xD659, 0xD65A, 0xD65B, 0xD65C, 0xD65D, 0xD65E, 0xD65F,   // D650 - D65F
	0xD660, 0xD661, 0xD662, 0xD663, 0xD664, 0xD665, 0xD666, 0xD667, 0xD668, 0xD669, 0xD66A, 0xD66B, 0xD66C, 0xD66D, 0xD66E, 0xD66F,   // D660 - D66F
	0xD670, 0xD671, 0xD672, 0xD673, 0xD674, 0xD675, 0xD676, 0xD677, 0xD678, 0xD679, 0xD67A, 0xD67B, 0xD67C, 0xD67D, 0xD67E, 0xD67F,   // D670 - D67F
	0xD680, 0xD681, 0xD682, 0xD683, 0xD684, 0xD685, 0xD686, 0xD687, 0xD688, 0xD689, 0xD68A, 0xD68B, 0xD68C, 0xD68D, 0xD68E, 0xD68F,   // D680 - D68F
	0xD690, 0xD691, 0xD692, 0xD693, 0xD694, 0xD695, 0xD696, 0xD697, 0xD698, 0xD699, 0xD69A, 0xD69B, 0xD69C, 0xD69D, 0xD69E, 0xD69F,   // D690 - D69F
	0xD6A0, 0xD6A1, 0xD6A2, 0xD6A3, 0xD6A4, 0xD6A5, 0xD6A6, 0xD6A7, 0xD6A8, 0xD6A9, 0xD6AA, 0xD6AB, 0xD6AC, 0xD6AD, 0xD6AE, 0xD6AF,   // D6A0 - D6AF
	0xD6B0, 0xD6B1, 0xD6B2, 0xD6B3, 0xD6B4, 0xD6B5, 0xD6B6, 0xD6B7, 0xD6B8, 0xD6B9, 0xD6BA, 0xD6BB, 0xD6BC, 0xD6BD, 0xD6BE, 0xD6BF,   // D6B0 - D6BF
	0xD6C0, 0xD6C1, 0xD6C2, 0xD6C3, 0xD6C4, 0xD6C5, 0xD6C6, 0xD6C7, 0xD6C8, 0xD6C9, 0xD6CA, 0xD6CB, 0xD6CC, 0xD6CD, 0xD6CE, 0xD6CF,   // D6C0 - D6CF
	0xD6D0, 0xD6D1, 0xD6D2, 0xD6D3, 0xD6D4, 0xD6D5, 0xD6D6, 0xD6D7, 0xD6D8, 0xD6D9, 0xD6DA, 0xD6DB, 0xD6DC, 0xD6DD, 0xD6DE, 0xD6DF,   // D6D0 - D6DF
	0xD6E0, 0xD6E1, 0xD6E2, 0xD6E3, 0xD6E4, 0xD6E5, 0xD6E6, 0xD6E7, 0xD6E8, 0xD6E9, 0xD6EA, 0xD6EB, 0xD6EC, 0xD6ED, 0xD6EE, 0xD6EF,   // D6E0 - D6EF
	0xD6F0, 0xD6F1, 0xD6F2, 0xD6F3, 0xD6F4, 0xD6F5, 0xD6F6, 0xD6F7, 0xD6F8, 0xD6F9, 0xD6FA, 0xD6FB, 0xD6FC, 0xD6FD, 0xD6FE, 0xD6FF,   // D6F0 - D6FF
	0xD700, 0xD701, 0xD702, 0xD703, 0xD704, 0xD705, 0xD706, 0xD707, 0xD708, 0xD709, 0xD70A, 0xD70B, 0xD70C, 0xD70D, 0xD70E, 0xD70F,   // D700 - D70F
	0xD710, 0xD711, 0xD712, 0xD713, 0xD714, 0xD715, 0xD716, 0xD717, 0xD718, 0xD719, 0xD71A, 0xD71B, 0xD71C, 0xD71D, 0xD71E, 0xD71F,   // D710 - D71F
	0xD720, 0xD721, 0xD722, 0xD723, 0xD724, 0xD725, 0xD726, 0xD727, 0xD728, 0xD729, 0xD72A, 0xD72B, 0xD72C, 0xD72D, 0xD72E, 0xD72F,   // D720 - D72F
	0xD730, 0xD731, 0xD732, 0xD733, 0xD734, 0xD735, 0xD736, 0xD737, 0xD738, 0xD739, 0xD73A, 0xD73B, 0xD73C, 0xD73D, 0xD73E, 0xD73F,   // D730 - D73F
	0xD740, 0xD741, 0xD742, 0xD743, 0xD744, 0xD745, 0xD746, 0xD747, 0xD748, 0xD749, 0xD74A, 0xD74B, 0xD74C, 0xD74D, 0xD74E, 0xD74F,   // D740 - D74F
	0xD750, 0xD751, 0xD752, 0xD753, 0xD754, 0xD755, 0xD756, 0xD757, 0xD758, 0xD759, 0xD75A, 0xD75B, 0xD75C, 0xD75D, 0xD75E, 0xD75F,   // D750 - D75F
	0xD760, 0xD761, 0xD762, 0xD763, 0xD764, 0xD765, 0xD766, 0xD767, 0xD768, 0xD769, 0xD76A, 0xD76B, 0xD76C, 0xD76D, 0xD76E, 0xD76F,   // D760 - D76F
	0xD770, 0xD771, 0xD772, 0xD773, 0xD774, 0xD775, 0xD776, 0xD777, 0xD778, 0xD779, 0xD77A, 0xD77B, 0xD77C, 0xD77D, 0xD77E, 0xD77F,   // D770 - D77F
	0xD780, 0xD781, 0xD782, 0xD783, 0xD784, 0xD785, 0xD786, 0xD787, 0xD788, 0xD789, 0xD78A, 0xD78B, 0xD78C, 0xD78D, 0xD78E, 0xD78F,   // D780 - D78F
	0xD790, 0xD791, 0xD792, 0xD793, 0xD794, 0xD795, 0xD796, 0xD797, 0xD798, 0xD799, 0xD79A, 0xD79B, 0xD79C, 0xD79D, 0xD79E, 0xD79F,   // D790 - D79F
	0xD7A0, 0xD7A1, 0xD7A2, 0xD7A3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // D7A0 - D7AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // D7B0 - D7BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // D7C0 - D7CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // D7D0 - D7DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // D7E0 - D7EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // D7F0 - D7FF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F700 - F70F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F710 - F71F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F720 - F72F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F730 - F73F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F740 - F74F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD7A3, 0xD7A3,   // F750 - F75F
	0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3,   // F760 - F76F
	0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3,   // F770 - F77F
	0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3,   // F780 - F78F
	0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3,   // F790 - F79F
	0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3,   // F7A0 - F7AF
	0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xD7A3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F7B0 - F7BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F7C0 - F7CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F7D0 - F7DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F7E0 - F7EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F7F0 - F7FF
	0xAC1C, 0xAC31, 0xAC70, 0xACE0, 0xACE8, 0xAD00, 0xADC0, 0xADC0, 0xADE0, 0xAE00, 0xAE08, 0xB098, 0xB098, 0xB098, 0xB098, 0xB098,   // F900 - F90F
	0xB098, 0xB098, 0xB098, 0xB098, 0xB099, 0xB099, 0xB099, 0xB099, 0xB099, 0xB099, 0xB099, 0xB09C, 0xB09C, 0xB09C, 0xB09C, 0xB09C,   // F910 - F91F
	0xB09C, 0xB0A8, 0xB0A8, 0xB0A8, 0xB0A8, 0xB0A9, 0xB0A9, 0xB0A9, 0xB0AD, 0xB0AD, 0xB0AD, 0xB0AD, 0xB0AD, 0xB0B4, 0xB0C9, 0xB178,   // F920 - F92F
	0xB178, 0xB178, 0xB178, 0xB178, 0xB178, 0xB178, 0xB178, 0xB178, 0xB178, 0xB178, 0xB178, 0xB179, 0xB179, 0xB179, 0xB179, 0xB179,   // F930 - F93F
	0xB179, 0xB17C, 0xB18D, 0xB18D, 0xB18D, 0xB18D, 0xB1CC, 0xB1CC, 0xB1CC, 0xB1CC, 0xB204, 0xB204, 0xB204, 0xB204, 0xB204, 0xB204,   // F940 - F94F
	0xB204, 0xB204, 0xB291, 0xB291, 0xB2A0, 0xB2A5, 0xB2A5, 0xB2A5, 0xB2A5, 0xB2A5, 0xB450, 0xB77C, 0xB77D, 0xB77D, 0xB780, 0xB839,   // F950 - F95F
	0xB85C, 0xB960, 0xB9AC, 0xBC30, 0xBC88, 0xBCC0, 0xBD80, 0xBD88, 0xBE44, 0xC0AD, 0xC0AD, 0xC0BC, 0xC0C9, 0xC0DD, 0xC12D, 0xC138,   // F960 - F96F
	0xC1C4, 0xC2E0, 0xC2EC, 0xC2ED, 0xC57C, 0xC57D, 0xC57D, 0xC591, 0xC591, 0xC591, 0xC591, 0xC591, 0xC591, 0xC591, 0xC591, 0xC5EC,   // F970 - F97F
	0xC5EC, 0xC5EC, 0xC5EC, 0xC5EC, 0xC5EC, 0xC5EC, 0xC5EC, 0xC5EC, 0xC5EC, 0xC5EC, 0xC5ED, 0xC5ED, 0xC5ED, 0xC5ED, 0xC5F0, 0xC5F0,   // F980 - F98F
	0xC5F0, 0xC5F0, 0xC5F0, 0xC5F0, 0xC5F0, 0xC5F0, 0xC5F0, 0xC5F0, 0xC5F0, 0xC5F0, 0xC5F0, 0xC5F0, 0xC5F4, 0xC5F4, 0xC5F4, 0xC5F4,   // F990 - F99F
	0xC5F4, 0xC5F4, 0xC5FC, 0xC5FC, 0xC5FC, 0xC5FC, 0xC5FC, 0xC5FD, 0xC601, 0xC601, 0xC601, 0xC601, 0xC601, 0xC601, 0xC601, 0xC601,   // F9A0 - F9AF
	0xC601, 0xC601, 0xC601, 0xC601, 0xC601, 0xC608, 0xC608, 0xC608, 0xC608, 0xC624, 0xC694, 0xC694, 0xC694, 0xC694, 0xC694, 0xC694,   // F9B0 - F9BF
	0xC694, 0xC694, 0xC694, 0xC694, 0xC6A9, 0xC6B4, 0xC6D0, 0xC720, 0xC720, 0xC720, 0xC720, 0xC720, 0xC720, 0xC720, 0xC720, 0xC720,   // F9C0 - F9CF
	0xC720, 0xC721, 0xC721, 0xC721, 0xC724, 0xC724, 0xC724, 0xC724, 0xC728, 0xC728, 0xC728, 0xC728, 0xC735, 0xC774, 0xC774, 0xC774,   // F9D0 - F9DF
	0xC774, 0xC774, 0xC774, 0xC774, 0xC774, 0xC774, 0xC774, 0xC774, 0xC774, 0xC774, 0xC774, 0xC775, 0xC775, 0xC778, 0xC778, 0xC778,   // F9E0 - F9EF
	0xC778, 0xC778, 0xC778, 0xC778, 0xC784, 0xC784, 0xC784, 0xC785, 0xC785, 0xC785, 0xC7A5, 0xC801, 0xC9C0, 0xC9D1, 0xCC28, 0xCC99,   // F9F0 - F9FF
	0xCCB4, 0xD0C1, 0xD0C1, 0xD0D5, 0xD0DD, 0xD1B5, 0xD3EC, 0xD3ED, 0xD56D, 0xD56D, 0xD604, 0xD655, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FA00 - FA0F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FA10 - FA1F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FA20 - FA2F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FA30 - FA3F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FA40 - FA4F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FA50 - FA5F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FA60 - FA6F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FA70 - FA7F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FA80 - FA8F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FA90 - FA9F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FAA0 - FAAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FAB0 - FABF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FAC0 - FACF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FAD0 - FADF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FAE0 - FAEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // FAF0 - FAFF
};
