/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: zh_pinyin.h,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:16:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <sal/types.h>

static sal_Unicode PinYinStr_zh[] = {
	0x61, 0x00, 0x61, 0x69, 0x00, 0x61, 0x6e, 0x00, 0x61, 0x6e, 0x67, 0x00, 0x61, 0x6f, 0x00, 0x62, 
	0x61, 0x00, 0x62, 0x61, 0x69, 0x00, 0x62, 0x61, 0x6e, 0x00, 0x62, 0x61, 0x6e, 0x67, 0x00, 0x62, 
	0x61, 0x6f, 0x00, 0x62, 0x65, 0x69, 0x00, 0x62, 0x65, 0x6e, 0x00, 0x62, 0x65, 0x6e, 0x67, 0x00, 
	0x62, 0x69, 0x00, 0x62, 0x69, 0x61, 0x6e, 0x00, 0x62, 0x69, 0x61, 0x6f, 0x00, 0x62, 0x69, 0x65, 
	0x00, 0x62, 0x69, 0x6e, 0x00, 0x62, 0x69, 0x6e, 0x67, 0x00, 0x62, 0x6f, 0x00, 0x62, 0x75, 0x00, 
	0x63, 0x61, 0x00, 0x63, 0x61, 0x69, 0x00, 0x63, 0x61, 0x6e, 0x00, 0x63, 0x61, 0x6e, 0x67, 0x00, 
	0x63, 0x61, 0x6f, 0x00, 0x63, 0x65, 0x00, 0x63, 0x65, 0x6e, 0x00, 0x63, 0x65, 0x6e, 0x67, 0x00, 
	0x63, 0x68, 0x61, 0x00, 0x63, 0x68, 0x61, 0x69, 0x00, 0x63, 0x68, 0x61, 0x6e, 0x00, 0x63, 0x68, 
	0x61, 0x6e, 0x67, 0x00, 0x63, 0x68, 0x61, 0x6f, 0x00, 0x63, 0x68, 0x65, 0x00, 0x63, 0x68, 0x65, 
	0x6e, 0x00, 0x63, 0x68, 0x65, 0x6e, 0x67, 0x00, 0x63, 0x68, 0x69, 0x00, 0x63, 0x68, 0x6f, 0x6e, 
	0x67, 0x00, 0x63, 0x68, 0x6f, 0x75, 0x00, 0x63, 0x68, 0x75, 0x00, 0x63, 0x68, 0x75, 0x61, 0x69, 
	0x00, 0x63, 0x68, 0x75, 0x61, 0x6e, 0x00, 0x63, 0x68, 0x75, 0x61, 0x6e, 0x67, 0x00, 0x63, 0x68, 
	0x75, 0x69, 0x00, 0x63, 0x68, 0x75, 0x6e, 0x00, 0x63, 0x68, 0x75, 0x6f, 0x00, 0x63, 0x69, 0x00, 
	0x63, 0x6f, 0x6e, 0x67, 0x00, 0x63, 0x6f, 0x75, 0x00, 0x63, 0x75, 0x00, 0x63, 0x75, 0x61, 0x6e, 
	0x00, 0x63, 0x75, 0x69, 0x00, 0x63, 0x75, 0x6e, 0x00, 0x63, 0x75, 0x6f, 0x00, 0x64, 0x61, 0x00, 
	0x64, 0x61, 0x69, 0x00, 0x64, 0x61, 0x6e, 0x00, 0x64, 0x61, 0x6e, 0x67, 0x00, 0x64, 0x61, 0x6f, 
	0x00, 0x64, 0x65, 0x00, 0x64, 0x65, 0x6e, 0x67, 0x00, 0x64, 0x69, 0x00, 0x64, 0x69, 0x61, 0x00, 
	0x64, 0x69, 0x61, 0x6e, 0x00, 0x64, 0x69, 0x61, 0x6f, 0x00, 0x64, 0x69, 0x65, 0x00, 0x64, 0x69, 
	0x6e, 0x67, 0x00, 0x64, 0x69, 0x75, 0x00, 0x64, 0x6f, 0x6e, 0x67, 0x00, 0x64, 0x6f, 0x75, 0x00, 
	0x64, 0x75, 0x00, 0x64, 0x75, 0x61, 0x6e, 0x00, 0x64, 0x75, 0x69, 0x00, 0x64, 0x75, 0x6e, 0x00, 
	0x64, 0x75, 0x6f, 0x00, 0x65, 0x00, 0x65, 0x69, 0x00, 0x65, 0x6e, 0x00, 0x65, 0x72, 0x00, 0x66, 
	0x61, 0x00, 0x66, 0x61, 0x6e, 0x00, 0x66, 0x61, 0x6e, 0x67, 0x00, 0x66, 0x65, 0x69, 0x00, 0x66, 
	0x65, 0x6e, 0x00, 0x66, 0x65, 0x6e, 0x67, 0x00, 0x66, 0x6f, 0x00, 0x66, 0x6f, 0x75, 0x00, 0x66, 
	0x75, 0x00, 0x67, 0x61, 0x00, 0x67, 0x61, 0x69, 0x00, 0x67, 0x61, 0x6e, 0x00, 0x67, 0x61, 0x6e, 
	0x67, 0x00, 0x67, 0x61, 0x6f, 0x00, 0x67, 0x65, 0x00, 0x67, 0x65, 0x69, 0x00, 0x67, 0x65, 0x6e, 
	0x00, 0x67, 0x65, 0x6e, 0x67, 0x00, 0x67, 0x6f, 0x6e, 0x67, 0x00, 0x67, 0x6f, 0x75, 0x00, 0x67, 
	0x75, 0x00, 0x67, 0x75, 0x61, 0x00, 0x67, 0x75, 0x61, 0x69, 0x00, 0x67, 0x75, 0x61, 0x6e, 0x00, 
	0x67, 0x75, 0x61, 0x6e, 0x67, 0x00, 0x67, 0x75, 0x69, 0x00, 0x67, 0x75, 0x6e, 0x00, 0x67, 0x75, 
	0x6f, 0x00, 0x68, 0x61, 0x00, 0x68, 0x61, 0x69, 0x00, 0x68, 0x61, 0x6e, 0x00, 0x68, 0x61, 0x6e, 
	0x67, 0x00, 0x68, 0x61, 0x6f, 0x00, 0x68, 0x65, 0x00, 0x68, 0x65, 0x69, 0x00, 0x68, 0x65, 0x6e, 
	0x00, 0x68, 0x65, 0x6e, 0x67, 0x00, 0x68, 0x6f, 0x6e, 0x67, 0x00, 0x68, 0x6f, 0x75, 0x00, 0x68, 
	0x75, 0x00, 0x68, 0x75, 0x61, 0x00, 0x68, 0x75, 0x61, 0x69, 0x00, 0x68, 0x75, 0x61, 0x6e, 0x00, 
	0x68, 0x75, 0x61, 0x6e, 0x67, 0x00, 0x68, 0x75, 0x69, 0x00, 0x68, 0x75, 0x6e, 0x00, 0x68, 0x75, 
	0x6f, 0x00, 0x6a, 0x69, 0x00, 0x6a, 0x69, 0x61, 0x00, 0x6a, 0x69, 0x61, 0x6e, 0x00, 0x6a, 0x69, 
	0x61, 0x6e, 0x67, 0x00, 0x6a, 0x69, 0x61, 0x6f, 0x00, 0x6a, 0x69, 0x65, 0x00, 0x6a, 0x69, 0x6e, 
	0x00, 0x6a, 0x69, 0x6e, 0x67, 0x00, 0x6a, 0x69, 0x6f, 0x6e, 0x67, 0x00, 0x6a, 0x69, 0x75, 0x00, 
	0x6a, 0x75, 0x00, 0x6a, 0x75, 0x61, 0x6e, 0x00, 0x6a, 0x75, 0x65, 0x00, 0x6a, 0x75, 0x6e, 0x00, 
	0x6b, 0x61, 0x00, 0x6b, 0x61, 0x69, 0x00, 0x6b, 0x61, 0x6e, 0x00, 0x6b, 0x61, 0x6e, 0x67, 0x00, 
	0x6b, 0x61, 0x6f, 0x00, 0x6b, 0x65, 0x00, 0x6b, 0x65, 0x6e, 0x00, 0x6b, 0x65, 0x6e, 0x67, 0x00, 
	0x6b, 0x6f, 0x6e, 0x67, 0x00, 0x6b, 0x6f, 0x75, 0x00, 0x6b, 0x75, 0x00, 0x6b, 0x75, 0x61, 0x00, 
	0x6b, 0x75, 0x61, 0x69, 0x00, 0x6b, 0x75, 0x61, 0x6e, 0x00, 0x6b, 0x75, 0x61, 0x6e, 0x67, 0x00, 
	0x6b, 0x75, 0x69, 0x00, 0x6b, 0x75, 0x6e, 0x00, 0x6b, 0x75, 0x6f, 0x00, 0x6c, 0x61, 0x00, 0x6c, 
	0x61, 0x69, 0x00, 0x6c, 0x61, 0x6e, 0x00, 0x6c, 0x61, 0x6e, 0x67, 0x00, 0x6c, 0x61, 0x6f, 0x00, 
	0x6c, 0x65, 0x00, 0x6c, 0x65, 0x69, 0x00, 0x6c, 0x65, 0x6e, 0x67, 0x00, 0x6c, 0x69, 0x00, 0x6c, 
	0x69, 0x61, 0x00, 0x6c, 0x69, 0x61, 0x6e, 0x00, 0x6c, 0x69, 0x61, 0x6e, 0x67, 0x00, 0x6c, 0x69, 
	0x61, 0x6f, 0x00, 0x6c, 0x69, 0x65, 0x00, 0x6c, 0x69, 0x6e, 0x00, 0x6c, 0x69, 0x6e, 0x67, 0x00, 
	0x6c, 0x69, 0x75, 0x00, 0x6c, 0x6f, 0x6e, 0x67, 0x00, 0x6c, 0x6f, 0x75, 0x00, 0x6c, 0x75, 0x00, 
	0x6c, 0x75, 0x61, 0x6e, 0x00, 0x6c, 0x75, 0x6e, 0x00, 0x6c, 0x75, 0x6f, 0x00, 0x6c, 0xfc, 0x00, 
	0x6c, 0xfc, 0x65, 0x00, 0x6d, 0x00, 0x6d, 0x61, 0x00, 0x6d, 0x61, 0x69, 0x00, 0x6d, 0x61, 0x6e, 
	0x00, 0x6d, 0x61, 0x6e, 0x67, 0x00, 0x6d, 0x61, 0x6f, 0x00, 0x6d, 0x65, 0x00, 0x6d, 0x65, 0x69, 
	0x00, 0x6d, 0x65, 0x6e, 0x00, 0x6d, 0x65, 0x6e, 0x67, 0x00, 0x6d, 0x69, 0x00, 0x6d, 0x69, 0x61, 
	0x6e, 0x00, 0x6d, 0x69, 0x61, 0x6f, 0x00, 0x6d, 0x69, 0x65, 0x00, 0x6d, 0x69, 0x6e, 0x00, 0x6d, 
	0x69, 0x6e, 0x67, 0x00, 0x6d, 0x69, 0x75, 0x00, 0x6d, 0x6f, 0x00, 0x6d, 0x6f, 0x75, 0x00, 0x6d, 
	0x75, 0x00, 0x6e, 0x61, 0x00, 0x6e, 0x61, 0x69, 0x00, 0x6e, 0x61, 0x6e, 0x00, 0x6e, 0x61, 0x6e, 
	0x67, 0x00, 0x6e, 0x61, 0x6f, 0x00, 0x6e, 0x65, 0x00, 0x6e, 0x65, 0x69, 0x00, 0x6e, 0x65, 0x6e, 
	0x00, 0x6e, 0x65, 0x6e, 0x67, 0x00, 0x6e, 0x67, 0x00, 0x6e, 0x69, 0x00, 0x6e, 0x69, 0x61, 0x6e, 
	0x00, 0x6e, 0x69, 0x61, 0x6e, 0x67, 0x00, 0x6e, 0x69, 0x61, 0x6f, 0x00, 0x6e, 0x69, 0x65, 0x00, 
	0x6e, 0x69, 0x6e, 0x00, 0x6e, 0x69, 0x6e, 0x67, 0x00, 0x6e, 0x69, 0x75, 0x00, 0x6e, 0x6f, 0x6e, 
	0x67, 0x00, 0x6e, 0x6f, 0x75, 0x00, 0x6e, 0x75, 0x00, 0x6e, 0x75, 0x61, 0x6e, 0x00, 0x6e, 0x75, 
	0x6f, 0x00, 0x6e, 0xfc, 0x00, 0x6e, 0xfc, 0x65, 0x00, 0x6f, 0x00, 0x6f, 0x75, 0x00, 0x70, 0x61, 
	0x00, 0x70, 0x61, 0x69, 0x00, 0x70, 0x61, 0x6e, 0x00, 0x70, 0x61, 0x6e, 0x67, 0x00, 0x70, 0x61, 
	0x6f, 0x00, 0x70, 0x65, 0x69, 0x00, 0x70, 0x65, 0x6e, 0x00, 0x70, 0x65, 0x6e, 0x67, 0x00, 0x70, 
	0x69, 0x00, 0x70, 0x69, 0x61, 0x6e, 0x00, 0x70, 0x69, 0x61, 0x6f, 0x00, 0x70, 0x69, 0x65, 0x00, 
	0x70, 0x69, 0x6e, 0x00, 0x70, 0x69, 0x6e, 0x67, 0x00, 0x70, 0x6f, 0x00, 0x70, 0x6f, 0x75, 0x00, 
	0x70, 0x75, 0x00, 0x71, 0x69, 0x00, 0x71, 0x69, 0x61, 0x00, 0x71, 0x69, 0x61, 0x6e, 0x00, 0x71, 
	0x69, 0x61, 0x6e, 0x67, 0x00, 0x71, 0x69, 0x61, 0x6f, 0x00, 0x71, 0x69, 0x65, 0x00, 0x71, 0x69, 
	0x6e, 0x00, 0x71, 0x69, 0x6e, 0x67, 0x00, 0x71, 0x69, 0x6f, 0x6e, 0x67, 0x00, 0x71, 0x69, 0x75, 
	0x00, 0x71, 0x75, 0x00, 0x71, 0x75, 0x61, 0x6e, 0x00, 0x71, 0x75, 0x65, 0x00, 0x71, 0x75, 0x6e, 
	0x00, 0x72, 0x61, 0x6e, 0x00, 0x72, 0x61, 0x6e, 0x67, 0x00, 0x72, 0x61, 0x6f, 0x00, 0x72, 0x65, 
	0x00, 0x72, 0x65, 0x6e, 0x00, 0x72, 0x65, 0x6e, 0x67, 0x00, 0x72, 0x69, 0x00, 0x72, 0x6f, 0x6e, 
	0x67, 0x00, 0x72, 0x6f, 0x75, 0x00, 0x72, 0x75, 0x00, 0x72, 0x75, 0x61, 0x6e, 0x00, 0x72, 0x75, 
	0x69, 0x00, 0x72, 0x75, 0x6e, 0x00, 0x72, 0x75, 0x6f, 0x00, 0x73, 0x61, 0x00, 0x73, 0x61, 0x69, 
	0x00, 0x73, 0x61, 0x6e, 0x00, 0x73, 0x61, 0x6e, 0x67, 0x00, 0x73, 0x61, 0x6f, 0x00, 0x73, 0x65, 
	0x00, 0x73, 0x65, 0x6e, 0x00, 0x73, 0x65, 0x6e, 0x67, 0x00, 0x73, 0x68, 0x61, 0x00, 0x73, 0x68, 
	0x61, 0x69, 0x00, 0x73, 0x68, 0x61, 0x6e, 0x00, 0x73, 0x68, 0x61, 0x6e, 0x67, 0x00, 0x73, 0x68, 
	0x61, 0x6f, 0x00, 0x73, 0x68, 0x65, 0x00, 0x73, 0x68, 0x65, 0x69, 0x00, 0x73, 0x68, 0x65, 0x6e, 
	0x00, 0x73, 0x68, 0x65, 0x6e, 0x67, 0x00, 0x73, 0x68, 0x69, 0x00, 0x73, 0x68, 0x6f, 0x75, 0x00, 
	0x73, 0x68, 0x75, 0x00, 0x73, 0x68, 0x75, 0x61, 0x00, 0x73, 0x68, 0x75, 0x61, 0x69, 0x00, 0x73, 
	0x68, 0x75, 0x61, 0x6e, 0x00, 0x73, 0x68, 0x75, 0x61, 0x6e, 0x67, 0x00, 0x73, 0x68, 0x75, 0x69, 
	0x00, 0x73, 0x68, 0x75, 0x6e, 0x00, 0x73, 0x68, 0x75, 0x6f, 0x00, 0x73, 0x69, 0x00, 0x73, 0x6f, 
	0x6e, 0x67, 0x00, 0x73, 0x6f, 0x75, 0x00, 0x73, 0x75, 0x00, 0x73, 0x75, 0x61, 0x6e, 0x00, 0x73, 
	0x75, 0x69, 0x00, 0x73, 0x75, 0x6e, 0x00, 0x73, 0x75, 0x6f, 0x00, 0x74, 0x61, 0x00, 0x74, 0x61, 
	0x69, 0x00, 0x74, 0x61, 0x6e, 0x00, 0x74, 0x61, 0x6e, 0x67, 0x00, 0x74, 0x61, 0x6f, 0x00, 0x74, 
	0x65, 0x00, 0x74, 0x65, 0x6e, 0x67, 0x00, 0x74, 0x69, 0x00, 0x74, 0x69, 0x61, 0x6e, 0x00, 0x74, 
	0x69, 0x61, 0x6f, 0x00, 0x74, 0x69, 0x65, 0x00, 0x74, 0x69, 0x6e, 0x67, 0x00, 0x74, 0x6f, 0x6e, 
	0x67, 0x00, 0x74, 0x6f, 0x75, 0x00, 0x74, 0x75, 0x00, 0x74, 0x75, 0x61, 0x6e, 0x00, 0x74, 0x75, 
	0x69, 0x00, 0x74, 0x75, 0x6e, 0x00, 0x74, 0x75, 0x6f, 0x00, 0x77, 0x61, 0x00, 0x77, 0x61, 0x69, 
	0x00, 0x77, 0x61, 0x6e, 0x00, 0x77, 0x61, 0x6e, 0x67, 0x00, 0x77, 0x65, 0x69, 0x00, 0x77, 0x65, 
	0x6e, 0x00, 0x77, 0x65, 0x6e, 0x67, 0x00, 0x77, 0x6f, 0x00, 0x77, 0x75, 0x00, 0x78, 0x69, 0x00, 
	0x78, 0x69, 0x61, 0x00, 0x78, 0x69, 0x61, 0x6e, 0x00, 0x78, 0x69, 0x61, 0x6e, 0x67, 0x00, 0x78, 
	0x69, 0x61, 0x6f, 0x00, 0x78, 0x69, 0x65, 0x00, 0x78, 0x69, 0x6e, 0x00, 0x78, 0x69, 0x6e, 0x67, 
	0x00, 0x78, 0x69, 0x6f, 0x6e, 0x67, 0x00, 0x78, 0x69, 0x75, 0x00, 0x78, 0x75, 0x00, 0x78, 0x75, 
	0x61, 0x6e, 0x00, 0x78, 0x75, 0x65, 0x00, 0x78, 0x75, 0x6e, 0x00, 0x79, 0x61, 0x00, 0x79, 0x61, 
	0x6e, 0x00, 0x79, 0x61, 0x6e, 0x67, 0x00, 0x79, 0x61, 0x6f, 0x00, 0x79, 0x65, 0x00, 0x79, 0x69, 
	0x00, 0x79, 0x69, 0x61, 0x6f, 0x00, 0x79, 0x69, 0x6e, 0x00, 0x79, 0x69, 0x6e, 0x67, 0x00, 0x79, 
	0x6f, 0x00, 0x79, 0x6f, 0x6e, 0x67, 0x00, 0x79, 0x6f, 0x75, 0x00, 0x79, 0x75, 0x00, 0x79, 0x75, 
	0x61, 0x6e, 0x00, 0x79, 0x75, 0x65, 0x00, 0x79, 0x75, 0x6e, 0x00, 0x7a, 0x61, 0x00, 0x7a, 0x61, 
	0x69, 0x00, 0x7a, 0x61, 0x6e, 0x00, 0x7a, 0x61, 0x6e, 0x67, 0x00, 0x7a, 0x61, 0x6f, 0x00, 0x7a, 
	0x65, 0x00, 0x7a, 0x65, 0x69, 0x00, 0x7a, 0x65, 0x6e, 0x00, 0x7a, 0x65, 0x6e, 0x67, 0x00, 0x7a, 
	0x68, 0x61, 0x00, 0x7a, 0x68, 0x61, 0x69, 0x00, 0x7a, 0x68, 0x61, 0x6e, 0x00, 0x7a, 0x68, 0x61, 
	0x6e, 0x67, 0x00, 0x7a, 0x68, 0x61, 0x6f, 0x00, 0x7a, 0x68, 0x65, 0x00, 0x7a, 0x68, 0x65, 0x6e, 
	0x00, 0x7a, 0x68, 0x65, 0x6e, 0x67, 0x00, 0x7a, 0x68, 0x69, 0x00, 0x7a, 0x68, 0x6f, 0x6e, 0x67, 
	0x00, 0x7a, 0x68, 0x6f, 0x75, 0x00, 0x7a, 0x68, 0x75, 0x00, 0x7a, 0x68, 0x75, 0x61, 0x00, 0x7a, 
	0x68, 0x75, 0x61, 0x69, 0x00, 0x7a, 0x68, 0x75, 0x61, 0x6e, 0x00, 0x7a, 0x68, 0x75, 0x61, 0x6e, 
	0x67, 0x00, 0x7a, 0x68, 0x75, 0x69, 0x00, 0x7a, 0x68, 0x75, 0x6e, 0x00, 0x7a, 0x68, 0x75, 0x6f, 
	0x00, 0x7a, 0x69, 0x00, 0x7a, 0x6f, 0x6e, 0x67, 0x00, 0x7a, 0x6f, 0x75, 0x00, 0x7a, 0x75, 0x00, 
	0x7a, 0x75, 0x61, 0x6e, 0x00, 0x7a, 0x75, 0x69, 0x00, 0x7a, 0x75, 0x6e, 0x00, 0x7a, 0x75, 0x6f, 
	0x00, 
};

static sal_uInt16 PinYinIndex1_zh[] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 0000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 1000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 2000
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0100, 0x0200,   // 4000
	0x0300, 0x0400, 0x0500, 0x0600, 0x0700, 0x0800, 0x0900, 0x0A00, 0x0B00, 0x0C00, 0x0D00, 0x0E00, 0x0F00, 0x1000, 0x1100, 0x1200,   // 5000
	0x1300, 0x1400, 0x1500, 0x1600, 0x1700, 0x1800, 0x1900, 0x1A00, 0x1B00, 0x1C00, 0x1D00, 0x1E00, 0x1F00, 0x2000, 0x2100, 0x2200,   // 6000
	0x2300, 0x2400, 0x2500, 0x2600, 0x2700, 0x2800, 0x2900, 0x2A00, 0x2B00, 0x2C00, 0x2D00, 0x2E00, 0x2F00, 0x3000, 0x3100, 0x3200,   // 7000
	0x3300, 0x3400, 0x3500, 0x3600, 0x3700, 0x3800, 0x3900, 0x3A00, 0x3B00, 0x3C00, 0x3D00, 0x3E00, 0x3F00, 0x4000, 0x4100, 0x4200,   // 8000
	0x4300, 0x4400, 0x4500, 0x4600, 0x4700, 0x4800, 0x4900, 0x4A00, 0x4B00, 0x4C00, 0x4D00, 0x4E00, 0x4F00, 0x5000, 0x5100, 0x5200,   // 9000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // A000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // B000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // C000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // D000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // E000
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // F000
};

static sal_uInt16 PinYinIndex2_zh[] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x02DB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3000 - 300F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3010 - 301F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3020 - 302F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3030 - 303F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3040 - 304F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3050 - 305F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3060 - 306F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3070 - 307F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3080 - 308F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 3090 - 309F
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 30A0 - 30AF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 30B0 - 30BF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 30C0 - 30CF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 30D0 - 30DF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 30E0 - 30EF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 30F0 - 30FF
	0x05DE, 0x011E, 0x0260, 0x0403, 0x04A8, 0x0590, 0xFFFF, 0x0571, 0x063D, 0x0481, 0x04A8, 0x0590, 0x0212, 0x004D, 0x05FB, 0x032D,   // 4E00 - 4E0F
	0x0175, 0x00A2, 0x00A2, 0x0675, 0x041A, 0x03DF, 0x04C7, 0x04C7, 0x042D, 0x0045, 0x05DB, 0x00D0, 0x0127, 0x04FB, 0x0092, 0x0123,   // 4E10 - 4E1F
	0x042D, 0x02C8, 0x0123, 0x05F7, 0x02C8, 0x05CE, 0x0045, 0x0485, 0x04D0, 0x023C, 0x0186, 0x05CB, 0x040F, 0x065B, 0x0212, 0x0229,   // 4E20 - 4E2F
	0x0163, 0x01AB, 0x00B1, 0x0079, 0x02D7, 0x068C, 0x0666, 0xFFFF, 0x0571, 0x00F4, 0x057A, 0x0666, 0x0231, 0x02BC, 0x0240, 0x03EC,   // 4E30 - 4E3F
	0x016F, 0x05DE, 0x05DE, 0x0355, 0xFFFF, 0x023C, 0x023C, 0x0566, 0x031A, 0x05DE, 0xFFFF, 0x0657, 0x058A, 0x062F, 0x01EF, 0x014F,   // 4E40 - 4E4F
	0x02B0, 0x065B, 0x03F4, 0x03C9, 0x0415, 0x01EF, 0x01A6, 0x0092, 0x0092, 0x05DE, 0x05E6, 0xFFFF, 0x0337, 0x023C, 0x0403, 0x05DB,   // 4E50 - 4E5F
	0x058D, 0x0599, 0x0175, 0x0123, 0xFFFF, 0xFFFF, 0x04D0, 0xFFFF, 0x04C7, 0x0212, 0x035D, 0x0215, 0xFFFF, 0x04C7, 0xFFFF, 0xFFFF,   // 4E60 - 4E6F
	0x0309, 0x02F0, 0xFFFF, 0x0466, 0x058D, 0x05CE, 0x016F, 0x049A, 0x0352, 0x0179, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x040A, 0x0657,   // 4E70 - 4E7F
	0x01B6, 0x0179, 0x02F0, 0x02D7, 0x05DE, 0x0248, 0x02CE, 0xFFFF, 0x05FB, 0x0651, 0x04C7, 0x04C7, 0x014C, 0x00A7, 0x05FB, 0x0290,   // 4E80 - 4E8F
	0x05FB, 0x0607, 0x01EF, 0x0403, 0x058A, 0x0231, 0x04FB, 0x050F, 0x018D, 0x018D, 0x05CB, 0x05A4, 0x05CB, 0x0403, 0x05CB, 0x0212,   // 4E90 - 4E9F
	0x0552, 0x0575, 0x025B, 0x051B, 0x0224, 0x01C5, 0x05DE, 0x0079, 0x01E1, 0x034F, 0xFFFF, 0x0599, 0x0231, 0x0548, 0x02C8, 0x01E1,   // 4EA0 - 4EAF
	0x0231, 0x05DB, 0x041E, 0x004A, 0x05F7, 0x05A4, 0x00F4, 0x02C3, 0x0140, 0x057A, 0x0451, 0x0451, 0x0212, 0xFFFF, 0x0575, 0x05DE,   // 4EB0 - 4EBF
	0x04C7, 0x0451, 0x02B0, 0x011E, 0x061F, 0x022D, 0x0400, 0x00A2, 0x000F, 0x063D, 0x022D, 0x0229, 0x0045, 0x0455, 0x00D0, 0x0168,   // 4EC0 - 4ECF
	0x0481, 0x02F5, 0xFFFF, 0x005B, 0x0691, 0x04C7, 0x051B, 0x063D, 0x016F, 0x0594, 0x0594, 0x0070, 0x01E6, 0x054D, 0x0451, 0x040A,   // 4ED0 - 4EDF
	0x0179, 0x0186, 0x0109, 0x00F0, 0x02DB, 0x05DE, 0x0084, 0x007E, 0x047A, 0x04A8, 0x05DE, 0x034F, 0x0321, 0x0451, 0x0215, 0x0084,   // 4EE0 - 4EEF
	0x05D2, 0x040A, 0x065B, 0x03DF, 0x0571, 0x058A, 0x0219, 0x0215, 0x05D7, 0x0163, 0x005B, 0x0451, 0x0575, 0x015F, 0x0109, 0x0156,   // 4EF0 - 4EFF
	0x065B, 0x0403, 0x03D2, 0x05FB, 0x0115, 0x013C, 0x057E, 0x05DE, 0x05A8, 0x025B, 0x05DE, 0x0212, 0x0002, 0x058A, 0x0212, 0x016F,   // 4F00 - 4F0F
	0x014F, 0x05B7, 0x022D, 0x0023, 0x008D, 0x016F, 0x0526, 0x065B, 0x05F7, 0x020E, 0x0206, 0x05FB, 0x00E1, 0x0607, 0x0481, 0x057A,   // 4F10 - 4F1F
	0x0675, 0x0089, 0x05CB, 0x0594, 0x04A8, 0x007E, 0x02F5, 0x005B, 0x05C7, 0x05A8, 0x057A, 0x0666, 0x0098, 0x05BE, 0x0362, 0x004A,   // 4F20 - 4F2F
	0x019F, 0x0379, 0x0379, 0x05A4, 0x0016, 0x05BB, 0x02DB, 0x0661, 0x04BC, 0x0431, 0x04FB, 0x002B, 0x04FB, 0x0215, 0x03DF, 0x05DE,   // 4F30 - 4F3F
	0x04FB, 0x0002, 0x0651, 0x0110, 0x01C9, 0x0309, 0x00F4, 0x0666, 0x004D, 0x0431, 0x0030, 0x04AE, 0x00CD, 0x057A, 0x0109, 0x0666,   // 4F40 - 4F4F
	0x06AD, 0x05F7, 0x05D2, 0x0537, 0x0638, 0x01D6, 0x0030, 0x0566, 0x04B3, 0x05FB, 0x05DE, 0x0168, 0x06AD, 0x019B, 0x0394, 0x054D,   // 4F50 - 4F5F
	0x0379, 0x05BE, 0x0240, 0x05F2, 0x056A, 0x040A, 0xFFFF, 0x0250, 0xFFFF, 0x03D2, 0x01F6, 0x01D6, 0x02AC, 0x0599, 0x0186, 0x05D2,   // 4F60 - 4F6F
	0x0012, 0x014F, 0x033F, 0x0215, 0x0355, 0x0045, 0x0212, 0x01E1, 0x020E, 0x01B6, 0x0434, 0x053F, 0x0224, 0x00CD, 0x05DE, 0x04C7,   // 4F70 - 4F7F
	0x05AC, 0x04BC, 0x0566, 0x0257, 0x0657, 0x0175, 0x029F, 0x05DE, 0x0098, 0x027C, 0x01B0, 0x02BC, 0x05E6, 0x04C7, 0x032A, 0x0666,   // 4F80 - 4F8F
	0x05BB, 0x05F7, 0x0005, 0x02ED, 0x034B, 0x014C, 0x02F5, 0x0127, 0x0070, 0x0098, 0x05C7, 0x0196, 0x0661, 0x05DE, 0x0466, 0x0219,   // 4F90 - 4F9F
	0x0590, 0x0215, 0x060E, 0x02FD, 0xFFFF, 0x0224, 0x064C, 0x0064, 0x0415, 0x0280, 0x0074, 0x0394, 0x039D, 0x022D, 0x058A, 0x01EB,   // 4FA0 - 4FAF
	0x0236, 0x0092, 0x064C, 0x00E9, 0x00A2, 0x041E, 0x02FD, 0x0240, 0x04D0, 0x0548, 0x04BC, 0x0566, 0x004A, 0x0359, 0x01D2, 0x0033,   // 4FB0 - 4FBF
	0x055E, 0x05FB, 0x058D, 0x00D9, 0x0144, 0x042D, 0x05BB, 0x028A, 0x0279, 0x058A, 0x024C, 0x05DE, 0x016F, 0x02A7, 0x069D, 0x0415,   // 4FC0 - 4FCF
	0x02BC, 0x05F2, 0x020A, 0x0231, 0x0594, 0x0481, 0x03C1, 0x0507, 0x016F, 0x058D, 0x02BC, 0x032D, 0x03F4, 0x001F, 0x05FB, 0x04FB,   // 4FD0 - 4FDF
	0x0590, 0x05A8, 0x05B7, 0x05FB, 0x0537, 0x0089, 0x00A2, 0xFFFF, 0x05CE, 0x02BF, 0x02BC, 0x029F, 0x04FB, 0x0219, 0x05B7, 0x016F,   // 4FE0 - 4FEF
	0x01D6, 0x0240, 0x059F, 0x03C1, 0x0219, 0x0038, 0x0537, 0x015B, 0x0163, 0x05CB, 0x0005, 0x0023, 0x05FB, 0x05A8, 0x0030, 0x0098,   // 4FF0 - 4FFF
	0x007E, 0x0657, 0x0045, 0x0612, 0x05D7, 0x00E1, 0x02BF, 0x0571, 0x029F, 0x005B, 0x0694, 0x0186, 0x01AB, 0x0023, 0x053A, 0x04D0,   // 5000 - 500F
	0x04D0, 0x0321, 0x00FD, 0x0522, 0x0248, 0x00BE, 0x05AC, 0x03DA, 0x0526, 0x01EB, 0x05DE, 0x0403, 0x0537, 0x0179, 0x0231, 0x0229,   // 5010 - 501F
	0x05BB, 0x007E, 0x0229, 0x0156, 0x0657, 0x0270, 0x0243, 0x0694, 0x0240, 0x040A, 0x0379, 0x02F5, 0x068C, 0x0587, 0x02F9, 0x04FE,   // 5020 - 502F
	0x02B7, 0x020A, 0x0127, 0x0691, 0x0027, 0x058A, 0x0240, 0x0355, 0x0053, 0x0219, 0x0633, 0x05DB, 0x0657, 0x049A, 0x0422, 0xFFFF,   // 5030 - 503F
	0x05EA, 0x0092, 0x040A, 0x05CE, 0x03A9, 0x065B, 0x00C3, 0x0215, 0x0229, 0x057A, 0x05FB, 0x0045, 0x0476, 0x0537, 0x057A, 0x03E2,   // 5040 - 504F
	0x05CE, 0x0163, 0x0526, 0x0587, 0x0144, 0x05A4, 0x0089, 0x04C1, 0x0257, 0x0109, 0x06AD, 0x0070, 0x0548, 0x0023, 0x05DB, 0x0200,   // 5050 - 505F
	0x05D7, 0x0638, 0x042D, 0x05CE, 0x05F7, 0x0219, 0x05BB, 0x062F, 0x0074, 0x016F, 0x0030, 0x0657, 0x0694, 0x032D, 0x0212, 0x05DE,   // 5060 - 506F
	0x05A4, 0x05C7, 0x04FB, 0x0133, 0x0064, 0x064C, 0x03BB, 0x0552, 0x0552, 0x0023, 0x060B, 0x02FD, 0x0229, 0x057A, 0x015F, 0x007E,   // 5070 - 507F
	0x0290, 0x0503, 0x0098, 0x0507, 0x0590, 0x016F, 0x05FE, 0x045D, 0x02BC, 0x0466, 0x0607, 0x019B, 0x0306, 0x001A, 0x0110, 0x0526,   // 5080 - 508F
	0x01D2, 0x0229, 0x058D, 0x04A3, 0x040A, 0x0248, 0x005B, 0x00A7, 0x0481, 0x0023, 0x059F, 0x05F2, 0x05D7, 0x051B, 0x0517, 0x0575,   // 5090 - 509F
	0x014F, 0x0045, 0x0215, 0x00F0, 0x060E, 0x0526, 0xFFFF, 0x0041, 0x00A7, 0x03AE, 0x0612, 0x02B3, 0x00E1, 0x05F2, 0x061B, 0x0694,   // 50A0 - 50AF
	0x03DA, 0x04FE, 0x000C, 0x00B1, 0x05FB, 0x0633, 0x069D, 0x04A8, 0x040F, 0x040F, 0x0098, 0x049A, 0x01C9, 0x063D, 0x0422, 0x05CE,   // 50B0 - 50BF
	0x0109, 0x058D, 0x02FD, 0x0023, 0x03E7, 0x022D, 0x02C3, 0x02ED, 0x030D, 0x040A, 0x0594, 0x042D, 0x05EA, 0x0127, 0x0675, 0x0599,   // 50C0 - 50CF
	0x04A3, 0x0415, 0x0236, 0x055E, 0x06A9, 0x0400, 0x058D, 0x02AC, 0x007E, 0x01B0, 0x02CE, 0x0403, 0x0104, 0x0079, 0x057A, 0x063D,   // 50D0 - 50DF
	0x0152, 0x0206, 0x00B1, 0x0544, 0x00F4, 0x0224, 0x023C, 0x0495, 0x015F, 0x0594, 0x0248, 0x0144, 0x0224, 0x0219, 0x054D, 0x02D7,   // 50E0 - 50EF
	0x004A, 0x019F, 0x0594, 0x0507, 0x0594, 0x021E, 0x033B, 0x05DB, 0x022D, 0x0215, 0x0415, 0x03DF, 0x0163, 0x0661, 0x0002, 0x047D,   // 50F0 - 50FF
	0x05DE, 0x024C, 0x039D, 0x04A3, 0x05DE, 0x00F8, 0x0231, 0x05BE, 0x0280, 0x0219, 0x00A7, 0x00F4, 0x0224, 0x049A, 0x060E, 0xFFFF,   // 5100 - 510F
	0x0041, 0x0005, 0x0466, 0x051E, 0x00A2, 0x0074, 0x02A3, 0x0379, 0x022D, 0x040A, 0x0325, 0x058A, 0x0371, 0x0427, 0x0379, 0x007E,   // 5110 - 511F
	0x02D3, 0x02B3, 0x02FD, 0x028A, 0x001F, 0x0130, 0x0038, 0x0612, 0x0657, 0x04FB, 0x05F7, 0x01D2, 0x041E, 0x008D, 0x02BC, 0x0532,   // 5120 - 512F
	0x057A, 0x02E4, 0x00A7, 0x0079, 0x0445, 0x04D0, 0x0206, 0x02BC, 0x02F9, 0x0612, 0x03AE, 0x0526, 0x05CE, 0x02B3, 0x035D, 0x014C,   // 5130 - 513F
	0x058A, 0x0607, 0x0612, 0x05FE, 0x05B1, 0x009C, 0x0643, 0x05B1, 0x0594, 0x01B0, 0x0138, 0x0264, 0x0138, 0x032D, 0x0556, 0x007E,   // 5140 - 514F
	0x014C, 0x0138, 0x014C, 0x022D, 0x0556, 0x04FB, 0x05CE, 0x05CE, 0x04C7, 0x04C7, 0x00F8, 0x040A, 0x012C, 0x015F, 0x0316, 0x05A8,   // 5150 - 515F
	0x012C, 0x0012, 0x0231, 0x02BC, 0x028A, 0x0466, 0x0575, 0x0369, 0x0434, 0x02C8, 0x05FB, 0x000F, 0x0196, 0x02E0, 0x058D, 0xFFFF,   // 5160 - 516F
	0x02A3, 0x0196, 0x053A, 0x01AB, 0x05AC, 0x0045, 0x0403, 0x0240, 0x0110, 0x0691, 0xFFFF, 0x05D2, 0x0219, 0x04CB, 0x0212, 0x05DE,   // 5170 - 517F
	0x0212, 0x0079, 0x0236, 0x0316, 0x0441, 0x0369, 0x05FE, 0x0316, 0x017D, 0x0441, 0x0064, 0x0236, 0x0064, 0x060E, 0x01A2, 0x0236,   // 5180 - 518F
	0x0316, 0x0661, 0x0316, 0x019B, 0x05BB, 0x032D, 0x032A, 0x045D, 0x05E6, 0x05A4, 0x0257, 0x024C, 0x039D, 0x05DE, 0x032A, 0x04C7,   // 5190 - 519F
	0x01AB, 0x0325, 0x065B, 0x06A5, 0x05FE, 0x033F, 0x0275, 0xFFFF, 0x016F, 0x05A4, 0x032A, 0x0045, 0x0127, 0x051E, 0x017D, 0x0163,   // 51A0 - 51AF
	0x0045, 0x01EF, 0x009C, 0x0248, 0x01EF, 0x028A, 0x05DB, 0x02B7, 0x03C5, 0x016F, 0x033B, 0x0127, 0x0594, 0x02D3, 0x0590, 0x0219,   // 51B0 - 51BF
	0x0231, 0x04D0, 0x031D, 0x04A8, 0x0403, 0x019F, 0x0687, 0x04FE, 0x0231, 0x02C8, 0x0422, 0x0115, 0x02DB, 0x0127, 0x0179, 0x0219,   // 51C0 - 51CF
	0x05E6, 0x00D5, 0x0002, 0x02BC, 0x005B, 0x033F, 0x0687, 0x00E1, 0x04FB, 0x0140, 0x022D, 0x02D7, 0x02D7, 0x0394, 0x058D, 0x0130,   // 51D0 - 51DF
	0x0212, 0x0152, 0x0152, 0x0152, 0x0163, 0x0240, 0x00A7, 0xFFFF, 0x0163, 0xFFFF, 0xFFFF, 0x016F, 0x0163, 0x03F4, 0x0163, 0x0253,   // 51E0 - 51EF
	0x0200, 0x0253, 0x0179, 0x0104, 0x03F4, 0x0431, 0x05B1, 0x0280, 0x0556, 0x000C, 0x00A7, 0x0212, 0x00F8, 0x01C9, 0x01C9, 0x061B,   // 51F0 - 51FF
	0x00FD, 0x0115, 0x00FD, 0x0451, 0x0451, 0x00B7, 0x015F, 0x041A, 0x05DE, 0x0212, 0x0257, 0x040A, 0x00E5, 0x00A7, 0x057E, 0x0212,   // 5200 - 520F
	0x00F4, 0x05AC, 0x01F2, 0x0571, 0x0248, 0x02BC, 0x0603, 0x02D3, 0x02E0, 0x061F, 0x017D, 0x00B7, 0x016F, 0x00A7, 0x0431, 0x0240,   // 5210 - 521F
	0x04A3, 0x033B, 0x02DB, 0x065B, 0x03C5, 0x003D, 0x0229, 0x0229, 0x001F, 0x02BC, 0x04A3, 0x003D, 0x0079, 0x0231, 0x01A2, 0x018D,   // 5220 - 522F
	0x00FD, 0x00B7, 0x0290, 0x0279, 0x0140, 0x014C, 0x0657, 0x04D4, 0x0434, 0x0070, 0x00CD, 0x0264, 0x0229, 0x01B6, 0x00CD, 0x01B6,   // 5230 - 523F
	0x0253, 0x0140, 0x0212, 0x0537, 0x0231, 0x02E9, 0x02F9, 0x061F, 0x05FE, 0x00E9, 0x05C3, 0x0264, 0x029C, 0x040A, 0x0070, 0x00B1,   // 5240 - 524F
	0x01A2, 0x0219, 0x00E9, 0x02BC, 0x0537, 0x015B, 0x03FC, 0x0079, 0x0403, 0x00B7, 0x0691, 0x017D, 0x0571, 0x004A, 0x0212, 0x0140,   // 5250 - 525F
	0x0422, 0x05CE, 0x068C, 0x0219, 0x0212, 0x004A, 0x05CE, 0x0240, 0x020E, 0x04C1, 0x0219, 0x0140, 0x0133, 0x058A, 0x01A2, 0x016F,   // 5260 - 526F
	0x04C1, 0x0219, 0x0186, 0x062F, 0x0253, 0x00B7, 0x0243, 0x0079, 0x0559, 0x02ED, 0x02BC, 0x016B, 0x04A3, 0x03E7, 0x0275, 0x0224,   // 5270 - 527F
	0x01A2, 0x0415, 0x0248, 0x01F2, 0x062F, 0x068C, 0x02C3, 0x0240, 0x03DF, 0x02E0, 0x01B6, 0x0224, 0x01B6, 0x0219, 0x0219, 0x0526,   // 5280 - 528F
	0x020E, 0x0212, 0x0219, 0x05DE, 0x0219, 0x0657, 0x0079, 0x00DC, 0x0348, 0x02BC, 0x0666, 0x02BC, 0x05CB, 0x0434, 0x0016, 0x0196,   // 5290 - 529F
	0x0215, 0x058A, 0x0309, 0x02D3, 0x0231, 0x026B, 0x05A4, 0x0657, 0x0127, 0x0666, 0x03A6, 0x0229, 0x0431, 0x04AE, 0x05DE, 0x0666,   // 52A0 - 52AF
	0x0348, 0x02BC, 0x0231, 0x02AC, 0x02AC, 0x0243, 0x0275, 0x05D2, 0x056A, 0x059F, 0x034B, 0x028A, 0x0229, 0x02D3, 0x01D6, 0x04C7,   // 52B0 - 52BF
	0x0264, 0x0231, 0x01D2, 0x004A, 0x033B, 0x0098, 0x02A7, 0x05F2, 0x05F2, 0x032D, 0x0264, 0x05C7, 0x0243, 0x0422, 0x02ED, 0x004D,   // 52C0 - 52CF
	0x0325, 0x029F, 0x02B0, 0x0253, 0x032D, 0x0127, 0x05BB, 0x05BB, 0x0257, 0x058A, 0x05DE, 0x05C7, 0x0582, 0x04C1, 0x02AC, 0x034F,   // 52D0 - 52DF
	0x02ED, 0x03E7, 0x04C7, 0x0212, 0x041E, 0x040F, 0x0224, 0x0434, 0x0599, 0x05DE, 0x0415, 0x0152, 0x0243, 0x054D, 0x0240, 0x00F4,   // 52E0 - 52EF
	0x05A4, 0x0309, 0x05C7, 0x05C7, 0x02FD, 0x02BC, 0x0089, 0x0445, 0x0434, 0x001F, 0x04AE, 0x0607, 0x023C, 0x001F, 0x019B, 0x058A,   // 52F0 - 52FF
	0x0607, 0xFFFF, 0xFFFF, 0x0175, 0x0175, 0x001F, 0x00D0, 0xFFFF, 0x05B1, 0x03DA, 0x0240, 0x052B, 0x0186, 0x0400, 0x0005, 0x03CE,   // 5300 - 530F
	0x016F, 0x0196, 0x00ED, 0x023C, 0x0427, 0x0030, 0x01F2, 0x0023, 0x0362, 0x0098, 0x0156, 0x023C, 0x05DE, 0x060B, 0x021E, 0x025B,   // 5310 - 531F
	0x021E, 0x028A, 0x01EF, 0x0590, 0x0431, 0x0152, 0x01B6, 0x041A, 0x005B, 0x028A, 0x015B, 0x01EF, 0x05FB, 0x01B6, 0x0290, 0x0206,   // 5320 - 532F
	0x00F4, 0x0290, 0x02C3, 0x02C3, 0x050A, 0x0130, 0x023C, 0x0431, 0x058D, 0x03DF, 0x0431, 0x05DE, 0x0005, 0x05CE, 0x0033, 0x0379,   // 5330 - 533F
	0x0431, 0x04C7, 0x05A8, 0x040A, 0x037C, 0x047A, 0x069D, 0x04C1, 0x058A, 0x0206, 0x0016, 0x04C7, 0x058D, 0x0571, 0x01F2, 0x05A4,   // 5340 - 534F
	0x0571, 0x0023, 0x069D, 0x068C, 0x05A4, 0x00F4, 0x0309, 0x0359, 0x00F4, 0x0212, 0x004A, 0x04D9, 0x004D, 0x028A, 0x0033, 0x004D,   // 5350 - 535F
	0x0638, 0x0406, 0x02ED, 0x05F7, 0x02ED, 0x058D, 0x01A2, 0x0587, 0x05A4, 0x0229, 0x0229, 0x057A, 0x0008, 0x0427, 0x0657, 0x0316,   // 5360 - 536F
	0x05E6, 0x057A, 0x04AE, 0x0212, 0x0439, 0x02F0, 0x04C7, 0x0243, 0x05A4, 0x05BB, 0x022D, 0x0439, 0x058A, 0x0212, 0x0144, 0x0422,   // 5370 - 537F
	0x058D, 0xFFFF, 0x007E, 0x01C9, 0x0144, 0x0548, 0x02BC, 0x0648, 0x0005, 0x02BC, 0x05CB, 0x05CB, 0x05CE, 0x04B3, 0x0657, 0x062F,   // 5380 - 538F
	0x03C9, 0xFFFF, 0x0264, 0x05CB, 0x0657, 0x0064, 0x03C9, 0x0537, 0x02BC, 0x04B3, 0x01EB, 0x0548, 0x06A5, 0x00E9, 0x015B, 0x05FE,   // 5390 - 539F
	0x0064, 0x05FE, 0x0599, 0x05CE, 0x02BC, 0x0248, 0x049A, 0x0110, 0x00A7, 0x023C, 0x041E, 0x000C, 0x01B6, 0x05CE, 0x04FB, 0x02BC,   // 53A0 - 53AF
	0x007E, 0x02A3, 0x02BC, 0x05CE, 0x05CE, 0x05FE, 0x04FB, 0x04FB, 0x02D7, 0x042D, 0x0431, 0x0431, 0xFFFF, 0x02B3, 0x0130, 0x0594,   // 53B0 - 53BF
	0x0675, 0x0481, 0x0057, 0x0057, 0x0481, 0x0057, 0x0002, 0x00F0, 0x05F7, 0x0070, 0x0212, 0x05F7, 0x04E5, 0x0152, 0x04CB, 0x01A6,   // 53C0 - 53CF
	0x000F, 0x014F, 0x0476, 0x04C7, 0x04D0, 0x0682, 0x0431, 0x04CB, 0x0033, 0x05BB, 0x0215, 0x03C5, 0x0503, 0x0212, 0x05FB, 0x0503,   // 53D0 - 53DF
	0x011A, 0x046E, 0x00D0, 0x0275, 0x019F, 0x0240, 0x02DB, 0x01A2, 0x052B, 0x0275, 0x0657, 0x0224, 0x0643, 0x000F, 0x011E, 0x0264,   // 53E0 - 53EF
	0x051E, 0x0098, 0x04C7, 0x05F7, 0x042D, 0x03F9, 0x05DB, 0x01D2, 0x04FB, 0x0522, 0x0098, 0x02B0, 0x0115, 0x0212, 0xFFFF, 0x01E6,   // 53F0 - 53FF
	0x0337, 0x05BB, 0x0311, 0x0098, 0x0186, 0x05BE, 0x05D7, 0x0691, 0x01D6, 0x0212, 0x0115, 0x00E5, 0x054D, 0x033F, 0x01EB, 0x02BC,   // 5400 - 540F
	0x0556, 0x0599, 0x062F, 0x0590, 0x05DB, 0x02FD, 0x0000, 0x0306, 0x03BB, 0x05C3, 0x05DE, 0x024C, 0x00A2, 0x02D7, 0x0562, 0x05E6,   // 5410 - 541F
	0x015B, 0x0030, 0x041E, 0x041E, 0x0229, 0x03FC, 0x016B, 0x000F, 0x013C, 0x015F, 0x0144, 0x01C9, 0x0548, 0x01CD, 0x04F1, 0x0403,   // 5420 - 542F
	0x01EF, 0x0657, 0x05E6, 0x058A, 0x058A, 0x0084, 0x0352, 0x00C8, 0x058D, 0x00BE, 0x012C, 0x057E, 0x01EB, 0x03BB, 0x058A, 0x0182,   // 5430 - 543F
	0x05CB, 0x024C, 0x02FD, 0x0144, 0x0186, 0x031D, 0x00F0, 0x0403, 0x0092, 0x058A, 0x0182, 0x016F, 0x0224, 0x01E6, 0x0098, 0x04C1,   // 5440 - 544F
	0x0352, 0x0562, 0x0304, 0x05DE, 0x00F0, 0x03BB, 0x02BC, 0x0023, 0x05FE, 0x01BE, 0xFFFF, 0x040F, 0x058A, 0x0144, 0x04C7, 0x0434,   // 5450 - 545F
	0x03D6, 0x057E, 0x0379, 0x034B, 0x02DB, 0x0441, 0x05F7, 0x0109, 0x0661, 0x04C7, 0x0661, 0x0638, 0x02DB, 0x05DE, 0x0403, 0x03F4,   // 5460 - 546F
	0x0691, 0x01A2, 0x00CD, 0x057A, 0x05BB, 0x01D6, 0x0362, 0x0590, 0x03D2, 0x05DE, 0x059F, 0x04BC, 0x01EF, 0x033F, 0x00ED, 0x0431,   // 5470 - 547F
	0x0240, 0x0179, 0x060B, 0x0566, 0x0140, 0x03FC, 0x03CE, 0x003D, 0x016F, 0x0030, 0x01D6, 0x060B, 0x01D6, 0x01C5, 0x023C, 0x05F2,   // 5480 - 548F
	0x016F, 0x00ED, 0x0661, 0x056A, 0x0250, 0x019F, 0x0250, 0x06AD, 0x004D, 0x02E4, 0x0127, 0x0394, 0x062F, 0x04FB, 0x0594, 0x020E,   // 5490 - 549F
	0x0403, 0x014C, 0x0144, 0x01B0, 0x062F, 0x058D, 0x05DE, 0x02D3, 0x0691, 0x0337, 0x032A, 0x0657, 0x05D7, 0x0212, 0x0661, 0x0186,   // 54A0 - 54AF
	0x04D9, 0x0612, 0x059F, 0x0264, 0x0206, 0x027C, 0x01F6, 0x052B, 0x0594, 0x0144, 0x05BE, 0x05B7, 0x01BE, 0x05CE, 0x02AC, 0x05DE,   // 54B0 - 54BF
	0x0002, 0x03F0, 0x04BC, 0x054D, 0x01E6, 0x05B1, 0x0140, 0x056A, 0x01C2, 0x060E, 0x05F7, 0x0109, 0x03C1, 0x0599, 0x0002, 0x018D,   // 54C0 - 54CF
	0x028A, 0x05CB, 0x00ED, 0x059F, 0x0030, 0x0206, 0xFFFF, 0x01F2, 0xFFFF, 0x0280, 0x0140, 0xFFFF, 0x0212, 0x039D, 0x034B, 0x05EF,   // 54D0 - 54DF
	0x01D2, 0x05FE, 0x02E4, 0x03FC, 0x0311, 0x0186, 0x0144, 0x0098, 0x04AE, 0x02BC, 0x0352, 0x069D, 0x01D6, 0x0279, 0x059F, 0x0594,   // 54E0 - 54EF
	0x02AC, 0x0023, 0x0648, 0x062F, 0x02C8, 0x000F, 0x032A, 0x02B0, 0x050F, 0x016B, 0x004D, 0x01C9, 0x01E1, 0x0191, 0x04F6, 0x0186,   // 54F0 - 54FF
	0x05F7, 0x05CE, 0x019F, 0x019F, 0x0012, 0x01C9, 0x0517, 0x00C3, 0x05DE, 0x0002, 0x0215, 0x0556, 0x0594, 0x01AB, 0x02BC, 0x058D,   // 5500 - 550F
	0x0526, 0x06AD, 0x0344, 0x0089, 0x058A, 0x061B, 0x05CB, 0x012C, 0x0403, 0x0109, 0x041E, 0x0306, 0xFFFF, 0x0196, 0x012C, 0xFFFF,   // 5510 - 551F
	0x02AC, 0x02C8, 0x0517, 0x061B, 0x01FB, 0xFFFF, 0x019B, 0x0212, 0x06AD, 0x0587, 0x0163, 0x05E6, 0x01EF, 0x0403, 0x04CB, 0x057A,   // 5520 - 552F
	0x04D4, 0x007E, 0x014C, 0x02BC, 0x040F, 0x0005, 0x0229, 0x05EF, 0x037C, 0x05FB, 0x053A, 0x029F, 0x049A, 0x058D, 0x0566, 0x01EF,   // 5530 - 553F
	0x0002, 0x0661, 0x03A2, 0x0267, 0x068C, 0x068C, 0x04A8, 0x0109, 0x01E1, 0x02D7, 0x0000, 0x059F, 0x0599, 0x0562, 0x058A, 0x057E,   // 5540 - 554F
	0x00E1, 0x0229, 0x01EF, 0x0403, 0x0403, 0x052B, 0x00F4, 0x00F4, 0x0571, 0x0691, 0x0030, 0x00E1, 0x00C8, 0x01D6, 0x05CB, 0x0403,   // 5550 - 555F
	0x0648, 0x015B, 0x02C8, 0x0594, 0x03DF, 0x049A, 0x029C, 0x061F, 0x0422, 0x01A2, 0x03BE, 0x0648, 0x048E, 0x0675, 0x038C, 0x01BE,   // 5560 - 556F
	0x02F9, 0x05CE, 0x0109, 0x0434, 0x0522, 0x004A, 0x011E, 0x02A7, 0x059F, 0xFFFF, 0x0526, 0x0098, 0x0537, 0x0005, 0x023C, 0x00F4,   // 5570 - 557F
	0x0250, 0x05F2, 0x057A, 0x0359, 0x04A3, 0x05FB, 0x0648, 0x029C, 0x0229, 0x01EB, 0x01C9, 0x011A, 0x0661, 0x0074, 0x0280, 0x044E,   // 5580 - 558F
	0x05FB, 0x05E6, 0x0612, 0x05D7, 0x0587, 0x032D, 0x01EF, 0x0607, 0x00B1, 0x0206, 0x01FB, 0x01FB, 0x058D, 0x01D6, 0x0212, 0x0290,   // 5590 - 559F
	0x065B, 0x057A, 0x049A, 0x05BB, 0x0200, 0x0130, 0x038C, 0x05BE, 0x02C8, 0x05FB, 0x0485, 0x0098, 0x0415, 0x05CE, 0x00F4, 0x03D6,   // 55A0 - 55AF
	0x04C7, 0x02BC, 0x05EF, 0x062F, 0x057A, 0x0332, 0x05EA, 0x03D6, 0xFFFF, 0x0290, 0x058D, 0x05FB, 0x0229, 0x02E9, 0x0279, 0x0060,   // 55B0 - 55BF
	0x020E, 0x0537, 0x05D7, 0x01D6, 0x0000, 0x05B7, 0x040F, 0x048E, 0x05F2, 0x0507, 0x01E6, 0x05A4, 0x0002, 0x0517, 0x0306, 0x0070,   // 55C0 - 55CF
	0x01C5, 0x0264, 0x00ED, 0x0485, 0x008D, 0x0466, 0x0503, 0x0196, 0x0212, 0x03C9, 0x058A, 0x040A, 0x04C7, 0x0186, 0x0691, 0x0229,   // 55D0 - 55DF
	0x02F9, 0x0582, 0x056A, 0x04FB, 0x0098, 0x01D2, 0x0517, 0x0215, 0x01C5, 0x0517, 0x041E, 0x038C, 0x01D6, 0xFFFF, 0x047D, 0x0376,   // 55E0 - 55EF
	0x0186, 0x0352, 0x010C, 0x0002, 0xFFFF, 0x054D, 0x0030, 0x000C, 0x000C, 0x02C3, 0x00E1, 0x0648, 0x0348, 0x0503, 0x0503, 0x0522,   // 55F0 - 55FF
	0x0109, 0x0403, 0x0224, 0x009C, 0x0224, 0x0253, 0x0522, 0x0481, 0x0060, 0x0215, 0xFFFF, 0x059F, 0x03E7, 0x02E9, 0x0172, 0x019F,   // 5600 - 560F
	0x059F, 0x01EF, 0x0206, 0x01BE, 0x03BB, 0x0594, 0x061F, 0x007E, 0x05BB, 0x03F9, 0x0101, 0x0306, 0x0306, 0x01EF, 0x02B3, 0x0130,   // 5610 - 561F
	0x0172, 0x0526, 0x05DB, 0x002B, 0x05EA, 0xFFFF, 0x0224, 0x032A, 0x059F, 0x01F2, 0x0309, 0x0441, 0x06AD, 0x03DA, 0x02AC, 0x059F,   // 5620 - 562F
	0x0212, 0x0666, 0x0084, 0x0290, 0x06A5, 0x059F, 0x04FB, 0x01D2, 0x016F, 0x02CE, 0x0415, 0x058D, 0x05BB, 0x0079, 0x00F4, 0x01D9,   // 5630 - 563F
	0x05C7, 0x058A, 0x06A9, 0x03C5, 0x0098, 0x0290, 0x0057, 0x0612, 0x00D9, 0x00F4, 0x05FB, 0x0562, 0x0092, 0x0224, 0x05DB, 0x058D,   // 5640 - 564F
	0x0403, 0x01D2, 0x02C3, 0x05BB, 0x0104, 0x0206, 0x05E6, 0x0400, 0x0248, 0x041E, 0x05C7, 0x038C, 0x02ED, 0x04FB, 0x05CE, 0x05EA,   // 5650 - 565F
	0x00ED, 0x0638, 0x03B9, 0x0661, 0x022D, 0x039D, 0x0206, 0x0206, 0x0403, 0x0144, 0x061B, 0x05DE, 0x04C7, 0x0224, 0x05FE, 0x0002,   // 5660 - 566F
	0x05F2, 0x05C3, 0x0280, 0x05FB, 0x03D6, 0x00FD, 0x0172, 0x05A8, 0x013C, 0x00F8, 0xFFFF, 0x047D, 0x03DF, 0x03DF, 0x05E6, 0x06A5,   // 5670 - 567F
	0x0394, 0x0109, 0x01C9, 0x051B, 0x020E, 0x0466, 0x01D2, 0x0590, 0x05CE, 0x0140, 0x03DF, 0x00A2, 0x0212, 0x022D, 0x01D2, 0x0537,   // 5680 - 568F
	0x007E, 0xFFFF, 0xFFFF, 0x0050, 0x0537, 0x02ED, 0x0206, 0x001F, 0x05F7, 0x038C, 0x05E6, 0x01EF, 0x0348, 0x0200, 0x0648, 0x02BC,   // 5690 - 569F
	0x02E0, 0xFFFF, 0x035D, 0x059F, 0x0348, 0x05CE, 0x02BC, 0x02ED, 0x02E4, 0x0348, 0x00F4, 0x008D, 0x03F0, 0x03DF, 0x0599, 0x020E,   // 56A0 - 56AF
	0x0348, 0x058D, 0x0140, 0x0279, 0x05CE, 0x0079, 0x05EA, 0x0445, 0x0110, 0x029C, 0x051B, 0x059F, 0x0224, 0x00C8, 0x01FB, 0x020E,   // 56B0 - 56BF
	0x0675, 0x038C, 0x059F, 0x0050, 0x02BC, 0x0079, 0x0074, 0x02BC, 0x05DE, 0x02F9, 0x035D, 0x0612, 0x0507, 0x058D, 0xFFFF, 0x0219,   // 56C0 - 56CF
	0x060B, 0x0666, 0x02A3, 0x038C, 0x035D, 0xFFFF, 0xFFFF, 0x057A, 0x0206, 0x05E6, 0x042D, 0x04FB, 0x0390, 0x0219, 0x0206, 0x05A8,   // 56D0 - 56DF
	0x05E6, 0x0359, 0x0559, 0x0559, 0x013C, 0x025B, 0x05FE, 0x0236, 0x03E2, 0x0607, 0x00D0, 0x01EF, 0x0206, 0x05FE, 0x0144, 0x01BE,   // 56E0 - 56EF
	0x0294, 0x00D0, 0x057A, 0x0556, 0x057A, 0x02F5, 0x01BE, 0x024C, 0x045A, 0x02DB, 0x019F, 0x01BE, 0x051E, 0x01BE, 0x0556, 0x05F7,   // 56F0 - 56FF
	0x01BE, 0x05E6, 0x020A, 0x0400, 0x05FB, 0x01C9, 0x05FE, 0x02F5, 0x0434, 0x05FB, 0x0422, 0x01BE, 0x00BE, 0x057A, 0x05FE, 0x0434,   // 5700 - 570F
	0x0279, 0x0400, 0x05FE, 0x05FE, 0x0144, 0x0556, 0x0556, 0x0556, 0x0559, 0x0300, 0x0206, 0x05DE, 0x05FE, 0x02F0, 0x02F0, 0x0556,   // 5710 - 571F
	0x05CB, 0x0556, 0x0548, 0x04C1, 0x05CE, 0x02ED, 0xFFFF, 0x05CB, 0x060E, 0x057A, 0x0186, 0x05FB, 0x058A, 0x01B6, 0x03DF, 0x05DE,   // 5720 - 572F
	0x0109, 0x040A, 0x040A, 0x064C, 0x068C, 0x00F8, 0x0406, 0xFFFF, 0xFFFF, 0x028A, 0x007E, 0x0403, 0x038C, 0x0348, 0x0212, 0x0215,   // 5730 - 573F
	0x0657, 0x0657, 0x0016, 0x05C7, 0x0552, 0x041E, 0x015F, 0x024C, 0x026B, 0x013C, 0x0156, 0x015F, 0x0027, 0x0522, 0x0257, 0x01F6,   // 5740 - 574F
	0x06AD, 0x026B, 0x0030, 0x05AC, 0x0109, 0x0231, 0x0212, 0x0280, 0x0109, 0x0231, 0x0219, 0x0522, 0x02BC, 0x000F, 0x058A, 0x015F,   // 5750 - 575F
	0x0682, 0x03F9, 0x03C5, 0x0526, 0x0294, 0x0431, 0x0522, 0x0657, 0x0566, 0x0179, 0x03F4, 0x0110, 0x056A, 0x0379, 0x051E, 0x03DF,   // 5760 - 576F
	0x0236, 0x05D2, 0x0168, 0x000C, 0x02E0, 0x042D, 0x034F, 0x0264, 0x019B, 0x05C3, 0x000F, 0x0098, 0x0089, 0x02DB, 0x0666, 0x016F,   // 5770 - 577F
	0x01EF, 0x0657, 0x00BE, 0x029C, 0x02E4, 0x02E4, 0x02ED, 0x000C, 0xFFFF, 0x03CE, 0xFFFF, 0x05AC, 0x054D, 0x0212, 0x0264, 0x02ED,   // 5780 - 578F
	0x00CD, 0x0098, 0x02B3, 0x0175, 0x05E6, 0x01EB, 0x0138, 0x0643, 0x016F, 0x01B0, 0x05D7, 0x0140, 0x0140, 0x01B6, 0x0070, 0x05D2,   // 5790 - 579F
	0x05E6, 0x014F, 0x019B, 0x05FE, 0x011A, 0x05A4, 0x0267, 0x04A8, 0x04CB, 0x0144, 0xFFFF, 0x0110, 0x01E6, 0x05CB, 0x027C, 0x00ED,   // 57A0 - 57AF
	0xFFFF, 0x00F8, 0x0253, 0xFFFF, 0x0362, 0x0005, 0x05AC, 0x0594, 0x01FB, 0x001A, 0x03D2, 0x000F, 0x05DE, 0x05E6, 0x01C9, 0x05BB,   // 57B0 - 57BF
	0x00BE, 0x0067, 0x0191, 0x0002, 0x03DA, 0x0156, 0x0439, 0x05F2, 0x024C, 0x0215, 0x0109, 0x0309, 0x02A7, 0x05BE, 0x0092, 0x04A3,   // 57C0 - 57CF
	0x022D, 0x0648, 0x02D3, 0x02D3, 0x004D, 0x0092, 0xFFFF, 0x004D, 0x04C7, 0x05C7, 0x01BE, 0x0236, 0x05DB, 0x037C, 0x0109, 0x05FB,   // 57D0 - 57DF
	0x004D, 0x058A, 0x0243, 0x050F, 0x03DF, 0x0092, 0x0571, 0x0240, 0x02F5, 0x0651, 0x0270, 0x065B, 0x0127, 0x00F0, 0x0522, 0x0005,   // 57E0 - 57EF
	0x0053, 0x04D0, 0x002B, 0x0257, 0x0657, 0x0140, 0x05DE, 0x0657, 0x05DE, 0x03D2, 0x0212, 0x0687, 0x0403, 0x048A, 0x0240, 0x0379,   // 57F0 - 57FF
	0x0279, 0x0264, 0x0526, 0x0294, 0x0379, 0x0219, 0x0138, 0x022D, 0x017D, 0x05FB, 0x0144, 0x03DA, 0x019F, 0x0556, 0x02B7, 0xFFFF,   // 5800 - 580F
	0x05CB, 0x040A, 0xFFFF, 0x0005, 0x008D, 0x0140, 0x0362, 0x0556, 0x0092, 0x05E6, 0x020A, 0x0030, 0x02C3, 0x01BE, 0x011A, 0x0675,   // 5810 - 581F
	0x01EB, 0x001F, 0x001F, 0x05FB, 0x0109, 0x0316, 0x0229, 0x0469, 0x0144, 0x0191, 0x0257, 0x0694, 0x05FB, 0x0200, 0x0144, 0x05D7,   // 5820 - 582F
	0x05CE, 0x001F, 0x0212, 0x031D, 0x007E, 0x0130, 0x0566, 0x0005, 0x0163, 0x065B, 0x0229, 0x064C, 0x01E1, 0x017D, 0x00B1, 0x0219,   // 5830 - 583F
	0xFFFF, 0x02B3, 0x017D, 0x0200, 0x02B7, 0x0133, 0x0571, 0x05BE, 0x0212, 0x0212, 0x0280, 0x05EA, 0x051B, 0x0092, 0x05F2, 0x0253,   // 5840 - 584F
	0x0507, 0x0507, 0x04C7, 0x032A, 0x051B, 0x0582, 0x0092, 0x0556, 0x0526, 0x0415, 0x065B, 0x02BC, 0x03DA, 0x001A, 0x047D, 0x0616,   // 5850 - 585F
	0x0138, 0x053A, 0x058A, 0x0092, 0x05C7, 0x0186, 0x064C, 0x0002, 0x0196, 0x05CE, 0x0257, 0x053A, 0x05FE, 0x057E, 0x05A4, 0x02E0,   // 5860 - 586F
	0xFFFF, 0x02A7, 0x007E, 0x03DA, 0x002B, 0x008D, 0x02ED, 0x02ED, 0x03BB, 0x040A, 0x031D, 0x0348, 0x0675, 0x04E5, 0x04D0, 0x02E9,   // 5870 - 587F
	0x0098, 0x030D, 0x0038, 0x0231, 0x0064, 0x04D0, 0x0109, 0x063D, 0x0257, 0x05F2, 0x0110, 0x008D, 0x0657, 0x0212, 0x01BE, 0x040F,   // 5880 - 588F
	0x022D, 0x0109, 0x04A8, 0x034F, 0x00E1, 0x05CE, 0x051B, 0x062A, 0x0403, 0x040F, 0x02C8, 0xFFFF, 0x0682, 0x0415, 0x062A, 0x05BB,   // 5890 - 589F
	0x04A3, 0x04A3, 0x000F, 0x0400, 0x0280, 0x0127, 0x0152, 0x0439, 0x0348, 0x013C, 0x013C, 0x06A9, 0x06A5, 0x04C1, 0x0140, 0x0140,   // 58A0 - 58AF
	0x0522, 0x0104, 0x034F, 0x015F, 0x0200, 0x0522, 0x00ED, 0x05DB, 0x00A7, 0xFFFF, 0x000C, 0x040F, 0x0212, 0x0415, 0x0267, 0x05DE,   // 58B0 - 58BF
	0x03DF, 0x0030, 0x0110, 0x021E, 0x05DB, 0x05F2, 0x05C3, 0x0522, 0x02A3, 0x0240, 0x01F6, 0x00F8, 0x0445, 0x040A, 0x05BE, 0x02A3,   // 58C0 - 58CF
	0x032A, 0x01D6, 0x0253, 0x05CB, 0x00FD, 0x01D2, 0x0469, 0xFFFF, 0x02B3, 0x028A, 0x02ED, 0x05CE, 0x0522, 0x057A, 0x01F6, 0x02E4,   // 58D0 - 58DF
	0x02E4, 0x046E, 0x02BC, 0x02D7, 0x0445, 0x0079, 0x05C7, 0x05CE, 0x02B3, 0x000F, 0xFFFF, 0x04C7, 0x0451, 0xFFFF, 0x067B, 0x067B,   // 58E0 - 58EF
	0x04C1, 0x05DE, 0x0309, 0x0264, 0x0666, 0x067B, 0x01EF, 0x01EF, 0x0294, 0x05DE, 0x01EF, 0x05BB, 0x0294, 0x04CB, 0x0311, 0x06A9,   // 58F0 - 58FF
	0x04CB, 0x05DE, 0x0657, 0x019F, 0x00A7, 0x0599, 0x0163, 0x0023, 0xFFFF, 0x0033, 0x050F, 0x043D, 0x02DB, 0x016F, 0x06AD, 0x0590,   // 5900 - 590F
	0x05B1, 0xFFFF, 0x0362, 0x0590, 0x0290, 0x058D, 0x056D, 0x05FE, 0x0316, 0x0507, 0x0140, 0x0140, 0x05DB, 0x0422, 0xFFFF, 0x019B,   // 5910 - 591F
	0x019B, 0x0403, 0x0325, 0x0325, 0x05E6, 0x020E, 0x008D, 0x00ED, 0x061F, 0x053A, 0x051E, 0x016F, 0x01A6, 0x05D7, 0x05D2, 0x01CD,   // 5920 - 592F
	0x0182, 0x04C7, 0x052B, 0x051E, 0x0552, 0x05CE, 0x0030, 0x05DE, 0x027C, 0x0215, 0x0140, 0xFFFF, 0x028A, 0x0607, 0x0215, 0x000F,   // 5930 - 593F
	0x0149, 0x02C3, 0x01FB, 0x0109, 0x05CE, 0x03CE, 0x0243, 0x0403, 0x0355, 0x0163, 0x05A4, 0x015F, 0x0110, 0xFFFF, 0x0290, 0x0699,   // 5940 - 594F
	0x01FB, 0x0403, 0x0253, 0x04B3, 0x0027, 0x05DE, 0x021E, 0x052B, 0x067B, 0x0027, 0x058D, 0x0200, 0x015B, 0x0115, 0x050F, 0x002B,   // 5950 - 595F
	0x0110, 0x000C, 0x04B3, 0x0582, 0x03C5, 0x000C, 0x058A, 0x000C, 0x021E, 0x02C3, 0x0140, 0x0607, 0x021E, 0x04C7, 0x015F, 0x020E,   // 5960 - 596F
	0x0023, 0x02C3, 0x0089, 0x03B2, 0x03A6, 0x011E, 0x0355, 0x040A, 0x0219, 0x051B, 0x023C, 0x0359, 0x0070, 0x01D2, 0x0594, 0x0152,   // 5970 - 597F
	0x0212, 0x04F6, 0x0466, 0x015B, 0x0575, 0x01E6, 0x067B, 0x016F, 0x0306, 0x00F4, 0x0451, 0x016F, 0x0231, 0x05CE, 0x05A4, 0x057E,   // 5980 - 598F
	0x065B, 0x03BE, 0x0130, 0x0212, 0x026B, 0x065B, 0x05D7, 0x022D, 0x0607, 0x0332, 0x03D2, 0x0098, 0x0603, 0x067B, 0x0399, 0x05CE,   // 5990 - 599F
	0x0352, 0x05A8, 0x015F, 0x0030, 0x05FB, 0x0566, 0x0163, 0x05FE, 0x0156, 0x058A, 0x05FB, 0x01B6, 0x0130, 0x000F, 0x0379, 0x0661,   // 59A0 - 59AF
	0x0661, 0x0643, 0x00ED, 0x0355, 0x05FE, 0x0552, 0x05BE, 0x0657, 0x0144, 0x031D, 0x0348, 0x0403, 0x0030, 0x04BC, 0x041A, 0x0144,   // 59B0 - 59BF
	0x01D6, 0x05BB, 0x014F, 0x0651, 0x0379, 0x0016, 0x034F, 0x016F, 0x02DB, 0x0691, 0x0691, 0x04C7, 0x0441, 0x04A3, 0x05D2, 0x040A,   // 59C0 - 59CF
	0x0229, 0x019F, 0x04FB, 0x05AC, 0x057A, 0x0691, 0x0240, 0x04A3, 0x03F0, 0x0451, 0x05D7, 0x054D, 0x021E, 0x04D0, 0x0212, 0x0175,   // 59D0 - 59DF
	0x04A8, 0x0298, 0x0243, 0x0224, 0x019B, 0x02AC, 0x0219, 0x0219, 0x05DE, 0x037C, 0x0657, 0x0212, 0x0212, 0x0594, 0x01E1, 0x01B0,   // 59E0 - 59EF
	0x024C, 0x027C, 0x05CE, 0x033F, 0x02D3, 0x03D2, 0x05CE, 0x05F7, 0x05CE, 0x0070, 0x0594, 0x05E6, 0x0098, 0x01B6, 0x0434, 0x0691,   // 59F0 - 59FF
	0x04FE, 0x057A, 0x01E6, 0x056A, 0x02E9, 0x05CB, 0x044A, 0x0224, 0x02F0, 0x03F4, 0x0594, 0x04AE, 0x02BC, 0x0092, 0x05A4, 0x0311,   // 5A00 - 5A0F
	0xFFFF, 0x0517, 0x034F, 0x057A, 0x0264, 0x029F, 0x00C8, 0x011E, 0x0381, 0x026B, 0x0359, 0x05FB, 0x03AE, 0x03D2, 0x050F, 0x0243,   // 5A10 - 5A1F
	0x04BC, 0x0657, 0x01C9, 0x0109, 0x067B, 0x0144, 0x03F0, 0x055E, 0x0594, 0x032D, 0x058A, 0x05CE, 0x058A, 0x058D, 0x05CE, 0x05FB,   // 5A20 - 5A2F
	0x04FB, 0x05FB, 0x056A, 0x02BC, 0x0594, 0x0240, 0x0431, 0x00BE, 0x0403, 0x0594, 0x0682, 0x0127, 0x007E, 0x02ED, 0x0002, 0x0144,   // 5A30 - 5A3F
	0x0144, 0x02E9, 0x032D, 0x00D0, 0x03FC, 0x0240, 0x03F9, 0x0053, 0x02DB, 0x0571, 0x0038, 0x059F, 0x04D0, 0x0403, 0x0206, 0x016F,   // 5A40 - 5A4F
	0x0587, 0x046E, 0x0522, 0x015B, 0xFFFF, 0x0229, 0x053A, 0x0379, 0x0434, 0x0231, 0x020A, 0x0231, 0x040A, 0x0110, 0x05AC, 0x01EF,   // 5A50 - 5A5F
	0x0571, 0x029F, 0x0030, 0x05E6, 0x00A2, 0x00C8, 0x016F, 0x0231, 0x02F5, 0x05CE, 0x02A3, 0x0294, 0x05E6, 0x05CB, 0xFFFF, 0x02BC,   // 5A60 - 5A6F
	0x0110, 0x0594, 0xFFFF, 0x01F2, 0x05EA, 0x0079, 0x04BC, 0x0548, 0x05D2, 0x05D7, 0x058A, 0x0359, 0x00C8, 0x0215, 0x0552, 0x05BB,   // 5A70 - 5A7F
	0x05FB, 0x057A, 0x0537, 0x0462, 0x031D, 0x00F4, 0x0469, 0x041E, 0xFFFF, 0x058A, 0x040A, 0x00C3, 0x0316, 0x016F, 0x0229, 0x0133,   // 5A80 - 5A8F
	0x058D, 0x065B, 0x031D, 0x0200, 0x032D, 0x0005, 0x05EA, 0x05BE, 0xFFFF, 0x057A, 0x031D, 0x05FE, 0x064C, 0x042D, 0x0537, 0x05A4,   // 5A90 - 5A9F
	0x0566, 0x02C3, 0x0316, 0x0441, 0x04FB, 0x03E2, 0x057A, 0x056A, 0x023C, 0x01EF, 0x000C, 0xFFFF, 0x001F, 0x05BB, 0x0552, 0x01B6,   // 5AA0 - 5AAF
	0x0699, 0x05D7, 0x03DF, 0x058D, 0x05FE, 0x05EA, 0x045D, 0x0466, 0x0098, 0x02E0, 0x031D, 0x03C5, 0x000C, 0x0306, 0x019B, 0x0290,   // 5AB0 - 5ABF
	0x041E, 0x0215, 0x048A, 0x064C, 0x05FE, 0x0070, 0x05F2, 0x033F, 0x05EA, 0x0212, 0x0507, 0x0387, 0x0594, 0x052B, 0x03C9, 0x02A7,   // 5AC0 - 5ACF
	0x0387, 0x001F, 0x0002, 0x03DF, 0x03F0, 0x05DE, 0x03E7, 0x05FB, 0x02B3, 0x05BE, 0x030D, 0x05DE, 0x063D, 0x025B, 0x05F2, 0x0379,   // 5AD0 - 5ADF
	0x02BC, 0x0109, 0x01B6, 0x05CE, 0x022D, 0x0675, 0x007E, 0x0064, 0x01C9, 0x036D, 0x02AC, 0x0348, 0x0648, 0x01EF, 0x01EF, 0x000C,   // 5AE0 - 5AEF
	0x036D, 0x040F, 0xFFFF, 0x0030, 0x019F, 0x058A, 0x0415, 0x0566, 0x0638, 0x0316, 0x0594, 0x0594, 0x0348, 0x02CE, 0x02C3, 0x01F2,   // 5AF0 - 5AFF
	0x01B6, 0x0104, 0x0657, 0x05BB, 0xFFFF, 0x01F2, 0x058D, 0x0206, 0x044A, 0x058D, 0x05CE, 0x0079, 0x0224, 0x031D, 0x0152, 0x0152,   // 5B00 - 5B0F
	0x0594, 0x05DE, 0x057A, 0x0079, 0x0152, 0x04C7, 0x0030, 0x04A3, 0x050F, 0x040F, 0x02C3, 0x01FB, 0xFFFF, 0x0387, 0x0127, 0x05DE,   // 5B10 - 5B1F
	0x0057, 0x0002, 0x0381, 0x0394, 0x0306, 0x053F, 0x00A2, 0x022D, 0x00CD, 0x05FB, 0x03F0, 0xFFFF, 0x05BB, 0x0355, 0x05CE, 0x051E,   // 5B20 - 5B2F
	0x05EA, 0x0057, 0x0387, 0xFFFF, 0x05EA, 0x032D, 0xFFFF, 0x0306, 0x04BC, 0x05AC, 0x0379, 0x0130, 0x02E0, 0x05FE, 0x02A3, 0x05CE,   // 5B30 - 5B3F
	0x04E5, 0x02DB, 0x0224, 0x0381, 0x02A3, 0x0594, 0x05EA, 0x04E5, 0x04D9, 0x0434, 0x032A, 0x02BC, 0x02F0, 0x05CE, 0x0666, 0x02A3,   // 5B40 - 5B4F
	0x0691, 0x0229, 0x0248, 0x0248, 0x0270, 0x0607, 0x0691, 0x0691, 0x00E5, 0x0513, 0x016F, 0x0023, 0x0691, 0x059F, 0x05A8, 0x0325,   // 5B50 - 5B5F
	0x04FB, 0x051E, 0x001F, 0x0212, 0x019F, 0x03A6, 0x05C3, 0xFFFF, 0x0079, 0x01C5, 0x02F0, 0x0513, 0x0362, 0x0337, 0x00D0, 0x0219,   // 5B60 - 5B6F
	0x04D0, 0x0079, 0x05CB, 0x0691, 0x0379, 0x016F, 0x0691, 0x02BC, 0x05C3, 0x004A, 0x0466, 0x0355, 0x038C, 0x038C, 0x05EA, 0x02F0,   // 5B70 - 5B7F
	0x032D, 0x0394, 0x045D, 0x051B, 0x01B6, 0x0633, 0x0427, 0x05FB, 0x04CB, 0x0005, 0x0556, 0x04FE, 0x0571, 0x0462, 0x05D7, 0x01E6,   // 5B80 - 5B8F
	0x05DE, 0x0231, 0x0687, 0x032A, 0x01A6, 0x00F8, 0x01E6, 0x0694, 0x01AB, 0x0661, 0x011E, 0x0571, 0x05DE, 0x001F, 0x04C7, 0x04C7,   // 5B90 - 5B9F
	0x009C, 0x04BC, 0x0264, 0x05BE, 0x04C7, 0x05F7, 0x01FB, 0x05DE, 0x053F, 0x04C7, 0x0594, 0x0196, 0x0092, 0x043D, 0x0196, 0x059F,   // 5BA0 - 5BAF
	0x060E, 0x062F, 0x001F, 0x01C5, 0x05CE, 0x059F, 0x0215, 0x04BC, 0x008D, 0x045D, 0x0200, 0x032A, 0x0275, 0x0285, 0x0041, 0x0507,   // 5BB0 - 5BBF
	0x0053, 0x0612, 0x0212, 0x05FE, 0x0212, 0x05E6, 0x032A, 0x0275, 0x0422, 0x01D6, 0x064C, 0x0219, 0x016F, 0x0394, 0x0045, 0x01FB,   // 5BC0 - 5BCF
	0x031D, 0x041E, 0x01C9, 0x05FB, 0x04C7, 0x0394, 0x022D, 0x0394, 0x0657, 0x05FB, 0x001F, 0x0285, 0x0394, 0x041E, 0x0348, 0x0070,   // 5BD0 - 5BDF
	0x0240, 0x01A2, 0x041E, 0x01EF, 0x058A, 0x02CE, 0x04C7, 0x0394, 0x0633, 0x04BC, 0x057A, 0x05A4, 0x0285, 0x0206, 0x02CE, 0x024C,   // 5BE0 - 5BEF
	0x01FB, 0x05DE, 0x05DE, 0x001F, 0x041E, 0x009C, 0x001F, 0x0163, 0x00E5, 0x0138, 0x04FB, 0x05C7, 0x00FD, 0x02FD, 0x0138, 0x04CB,   // 5BF0 - 5BFF
	0x03F9, 0x0163, 0x0675, 0x016F, 0x04B3, 0x0264, 0x021E, 0x021E, 0x0675, 0x057A, 0x06A9, 0x05C7, 0x04D0, 0x0138, 0x00FD, 0x059F,   // 5C00 - 5C0F
	0x0212, 0x04AE, 0x014C, 0x014C, 0x014C, 0x0172, 0x0219, 0x04D0, 0x008D, 0x04A8, 0x04A8, 0x05FE, 0x0172, 0x007E, 0x02CE, 0x0594,   // 5C10 - 5C1F
	0x0594, 0xFFFF, 0x0575, 0x0575, 0x05F7, 0x02CE, 0x02CE, 0x05D7, 0x0311, 0x0575, 0x0575, 0x0575, 0x0172, 0x05D7, 0x0140, 0x0290,   // 5C20 - 5C2F
	0x065B, 0x023C, 0x0179, 0x019F, 0x0179, 0x0179, 0x0179, 0x0179, 0x04C7, 0x05E6, 0x0098, 0x0260, 0x0379, 0x022D, 0x057A, 0x0387,   // 5C30 - 5C3F
	0x0240, 0x03DF, 0x006B, 0x058D, 0x0030, 0x0240, 0x0229, 0x053A, 0x0431, 0x0537, 0x0229, 0x058A, 0x0115, 0x04C7, 0x04C7, 0x03F4,   // 5C40 - 5C4F
	0x0212, 0x05A4, 0x008D, 0x058D, 0x0379, 0x0638, 0x058D, 0xFFFF, 0x030D, 0x0144, 0x02E9, 0x03F4, 0x0537, 0x015B, 0x04D0, 0x05A4,   // 5C50 - 5C5F
	0x0556, 0x02FD, 0x02FD, 0x058D, 0x006B, 0x02FD, 0x0240, 0x05A4, 0x0240, 0x0248, 0x02CE, 0x0248, 0x04D0, 0x058D, 0x0089, 0x0562,   // 5C60 - 5C6F
	0x0379, 0x04A3, 0x056A, 0x0594, 0x02BC, 0x0144, 0xFFFF, 0xFFFF, 0x02E4, 0x05DE, 0x0403, 0x0451, 0x058A, 0x01C9, 0x04BC, 0x05FB,   // 5C70 - 5C7F
	0x00A7, 0x050F, 0x0403, 0xFFFF, 0x0603, 0x0016, 0x05D7, 0x0008, 0x05CB, 0x058A, 0x0229, 0x0144, 0x0212, 0x040A, 0x015F, 0x0571,   // 5C80 - 5C8F
	0x0403, 0x0067, 0x040A, 0x0403, 0x0070, 0x0229, 0x0431, 0x017D, 0x0594, 0x000C, 0x02A3, 0x00FD, 0x000F, 0x0633, 0x06AD, 0x05D2,   // 5C90 - 5C9F
	0x0240, 0x017D, 0x0264, 0x019B, 0x05C3, 0x004A, 0x02BC, 0x053F, 0x0431, 0x05CE, 0x016F, 0x05B7, 0x0215, 0x02DB, 0x0566, 0x03D2,   // 5CA0 - 5CAF
	0x05F7, 0x00F0, 0x028A, 0x0603, 0x0431, 0x01EF, 0x03F9, 0x033B, 0x0005, 0x053F, 0x02DB, 0x0098, 0xFFFF, 0x0127, 0xFFFF, 0x0290,   // 5CB0 - 5CBF
	0x05B7, 0x0316, 0x054D, 0x05C3, 0x05DE, 0xFFFF, 0x01D6, 0x0264, 0x02F9, 0x0144, 0x016F, 0x05C7, 0x011A, 0x02ED, 0x02A7, 0x014C,   // 5CC0 - 5CCF
	0x0175, 0x0434, 0x054D, 0x05DE, 0x034F, 0x04C7, 0x0005, 0x057A, 0x01EF, 0x0657, 0x032A, 0x02BC, 0x0212, 0x054D, 0x0290, 0x05F7,   // 5CD0 - 5CDF
	0xFFFF, 0x0590, 0x02BC, 0x05D7, 0x0224, 0x0651, 0x02F0, 0x0224, 0x0144, 0x0144, 0x05FB, 0x05DB, 0x004D, 0x0415, 0x043D, 0x0163,   // 5CE0 - 5CEF
	0x0163, 0x0362, 0x02BC, 0x05F7, 0x0594, 0x01E6, 0x00FD, 0x04BC, 0x0092, 0x0556, 0x0191, 0x024C, 0x01D2, 0x0590, 0x05E6, 0x058A,   // 5CF0 - 5CFF
	0x02A7, 0x0257, 0x02AC, 0x029F, 0x0594, 0x0439, 0x0270, 0x009C, 0x009C, 0x051B, 0xFFFF, 0x01F2, 0x0240, 0x029F, 0x0403, 0x033B,   // 5D00 - 5D0F
	0x0294, 0x0294, 0x069D, 0x019F, 0x00E1, 0x05CB, 0x05CB, 0x017D, 0x02F5, 0x02F5, 0x02B7, 0x0248, 0x0140, 0x0092, 0x01BE, 0x05E6,   // 5D10 - 5D1F
	0x0127, 0x01C9, 0x0651, 0x057A, 0x05D7, 0x03DF, 0x05CE, 0x04FE, 0x0229, 0x002B, 0x069D, 0x0248, 0x0127, 0x0638, 0x019F, 0x05E6,   // 5D20 - 5D2F
	0x0691, 0x061F, 0x0200, 0x05FB, 0x057A, 0x05D2, 0x0163, 0x042D, 0x013C, 0x0537, 0x05DE, 0x0657, 0x04C7, 0x060E, 0x05D7, 0x0144,   // 5D30 - 5D3F
	0x0666, 0x0257, 0x02FD, 0x05CE, 0x031D, 0x0179, 0x0212, 0x0212, 0x01FB, 0x0548, 0x04C1, 0x031D, 0x040A, 0x058A, 0x05FB, 0x0694,   // 5D40 - 5D4F
	0x02A3, 0x0229, 0x05CE, 0x05CE, 0x057A, 0x0694, 0x0070, 0x050F, 0x045D, 0x0264, 0x041E, 0x05FB, 0x0403, 0x02E9, 0x0556, 0x0138,   // 5D50 - 5D5F
	0x058D, 0x0582, 0x005B, 0x00F8, 0x045D, 0x0229, 0x0002, 0x02E0, 0x058A, 0x04FE, 0x0415, 0x0691, 0x057A, 0x002B, 0x0110, 0x00E9,   // 5D60 - 5D6F
	0x040A, 0x05F2, 0x038C, 0x00E9, 0x0212, 0xFFFF, 0xFFFF, 0x04FE, 0x0694, 0x021E, 0x02CE, 0xFFFF, 0x0079, 0x0109, 0x0067, 0x011E,   // 5D70 - 5D7F
	0x0556, 0x02E9, 0x063D, 0x0638, 0x0638, 0x000C, 0x0060, 0x0431, 0x040F, 0x06A5, 0x06A5, 0x00FD, 0x00FD, 0x058D, 0x05FB, 0x004A,   // 5D80 - 5D8F
	0x02E4, 0x0599, 0x006B, 0x004A, 0x041E, 0x0224, 0x05CE, 0x02AC, 0x0638, 0x02D7, 0x02CE, 0x02CE, 0x022D, 0x0104, 0x0140, 0x06A9,   // 5D90 - 5D9F
	0x0224, 0x01B6, 0x05D7, 0x0415, 0x05D7, 0x0248, 0x0638, 0x05DE, 0x05C3, 0x0362, 0x05DB, 0x05DB, 0x05DE, 0x0144, 0x0594, 0x0212,   // 5DA0 - 5DAF
	0x05A4, 0x0264, 0x050F, 0x0109, 0x000C, 0x06A5, 0xFFFF, 0x05DE, 0x045D, 0x00FD, 0x02DB, 0x060B, 0x05FB, 0x0603, 0x05E6, 0xFFFF,   // 5DB0 - 5DBF
	0x0229, 0x02BC, 0x050F, 0x02E4, 0x02E4, 0x0110, 0x05EA, 0x058D, 0x0240, 0x0079, 0x05EA, 0x0290, 0x05CE, 0x057A, 0x0362, 0x0434,   // 5DC0 - 5DCF
	0x0084, 0x00DC, 0x02F0, 0x0110, 0x0110, 0x038C, 0x05CE, 0x05CE, 0x05CE, 0x0362, 0x05CE, 0x00B1, 0x01B6, 0x00B1, 0x0661, 0x0200,   // 5DD0 - 5DDF
	0x0231, 0x05C7, 0x0084, 0x0084, 0x02D3, 0x0196, 0x06AD, 0x0415, 0x0240, 0x0196, 0xFFFF, 0x058A, 0xFFFF, 0xFFFF, 0x0074, 0x042D,   // 5DE0 - 5DEF
	0x042D, 0x0212, 0x05DE, 0x04FB, 0x000F, 0x0657, 0x0643, 0x0599, 0x05DE, 0x022D, 0x05C7, 0x0243, 0xFFFF, 0x05C7, 0x022D, 0x016F,   // 5DF0 - 5DFF
	0x060B, 0x0030, 0x04C7, 0x004D, 0x011E, 0x04D9, 0x0152, 0x038C, 0x04C7, 0x015F, 0x03BE, 0x0657, 0x058D, 0x01EF, 0x00F4, 0x057A,   // 5E00 - 5E0F
	0x063D, 0x0526, 0x00F0, 0x0306, 0x03D2, 0x03BE, 0x0544, 0x016F, 0x02C3, 0x0657, 0x0661, 0x004A, 0x0657, 0x0109, 0x0348, 0x05DE,   // 5E10 - 5E1F
	0x05DE, 0x03F4, 0x0406, 0x0243, 0x0466, 0x04D9, 0x00F0, 0x064C, 0x04EC, 0x0415, 0x064C, 0x04C7, 0x043D, 0x058D, 0x001A, 0x00F0,   // 5E20 - 5E2F
	0x01B6, 0x00A2, 0x03F4, 0x063D, 0x049A, 0x0571, 0x00F0, 0x057A, 0x007E, 0x049A, 0x0403, 0x061F, 0x01BE, 0x0316, 0x0130, 0x01EB,   // 5E30 - 5E3F
	0x064C, 0x05BB, 0x032A, 0x057A, 0x0587, 0x016F, 0x05DE, 0x001A, 0x03F4, 0xFFFF, 0x0196, 0x03C5, 0x0200, 0x00FD, 0x032A, 0x0215,   // 5E40 - 5E4F
	0x0532, 0x0206, 0x065B, 0x0491, 0x030D, 0x034F, 0x0038, 0x01BE, 0x061F, 0x034F, 0x001A, 0x063D, 0x0236, 0x0079, 0x016F, 0x0657,   // 5E50 - 5E5F
	0x01EF, 0x0152, 0x00B7, 0x0030, 0x0030, 0xFFFF, 0x032A, 0x0415, 0x00F4, 0x015F, 0x0325, 0x001A, 0x00A2, 0x0337, 0x00A7, 0x0229,   // 5E60 - 5E6F
	0x0594, 0x02A3, 0x0179, 0x03F4, 0x037C, 0x0219, 0x0045, 0x0045, 0x05AC, 0x0179, 0x05D7, 0x01FB, 0x05F7, 0x05F7, 0x0212, 0x01B0,   // 5E70 - 5E7F
	0x03DF, 0x0548, 0x061F, 0x01B0, 0x067B, 0x0348, 0x0422, 0x0030, 0x041E, 0x013C, 0x00B7, 0x01B6, 0x05CB, 0x0012, 0x0229, 0x05BB,   // 5E80 - 5E8F
	0x02ED, 0x058A, 0xFFFF, 0x0279, 0x05EA, 0x0109, 0x03CE, 0x0110, 0x05CB, 0x0332, 0x0191, 0x00CD, 0x016F, 0x054D, 0x03C9, 0x015B,   // 5E90 - 5E9F
	0x0599, 0x05DE, 0x0657, 0x053F, 0x0657, 0x05B7, 0x0130, 0x06AD, 0x059F, 0x0556, 0x01B6, 0x0279, 0x03C9, 0x0548, 0x05F7, 0x004D,   // 5EA0 - 5EAF
	0x0045, 0x0092, 0x029F, 0x0030, 0x0212, 0x0005, 0x04D0, 0x025B, 0x05F2, 0x0566, 0x04FE, 0x04D0, 0x0422, 0x05FB, 0x05FB, 0x0332,   // 5EB0 - 5EBF
	0x0503, 0x0064, 0x0599, 0x015B, 0x023C, 0x01D6, 0x0206, 0x02E0, 0x049A, 0x02C3, 0x02A7, 0x0503, 0x0219, 0x03FC, 0x0422, 0x023C,   // 5EC0 - 5ECF
	0x023C, 0x041E, 0x000C, 0x0298, 0x02E9, 0x05E6, 0x02CE, 0x00F0, 0x02ED, 0x05DE, 0x00A7, 0x0079, 0x0556, 0x04FB, 0x05A8, 0x0332,   // 5ED0 - 5EDF
	0x007E, 0x058A, 0x015B, 0x01B0, 0xFFFF, 0x01A6, 0x0030, 0x040F, 0x05A4, 0x02D7, 0x02D7, 0x02CE, 0x02ED, 0xFFFF, 0x05EA, 0x0594,   // 5EE0 - 5EEF
	0x0548, 0x05F2, 0x02BC, 0x0548, 0x05E6, 0x05C7, 0x05CE, 0x0548, 0x0109, 0x03F9, 0x0219, 0x0206, 0x0355, 0x0206, 0x0196, 0x037C,   // 5EF0 - 5EFF
	0x0253, 0x0033, 0x05DE, 0x0403, 0x039D, 0x015F, 0x0240, 0x05CE, 0x05DE, 0x0616, 0x0030, 0x05DE, 0x05DE, 0x014C, 0x0481, 0x04C7,   // 5F00 - 5F0F
	0x014C, 0x04C7, 0x04C7, 0x0196, 0x0115, 0x05E6, 0x01EF, 0x016F, 0x01E6, 0x058A, 0x055E, 0x0098, 0x040F, 0x000F, 0x04BC, 0x0109,   // 5F10 - 5F1F
	0x063D, 0x0248, 0x052B, 0x016F, 0x0109, 0x032A, 0x0594, 0x01EF, 0x0084, 0x03A6, 0x0231, 0x064C, 0x05DE, 0x032A, 0x0434, 0x0571,   // 5F20 - 5F2F
	0x04AE, 0x0476, 0x05BE, 0x0231, 0x0115, 0x063D, 0x021E, 0x040F, 0x002B, 0x00F4, 0x040F, 0x0030, 0x0030, 0x04B3, 0x00F4, 0x0219,   // 5F30 - 5F3F
	0x019B, 0xFFFF, 0x014F, 0x0030, 0x0275, 0xFFFF, 0x003D, 0x059F, 0x00F4, 0x028A, 0x040F, 0x01E6, 0x032A, 0x0298, 0x0571, 0x0248,   // 5F40 - 5F4F
	0x0212, 0x0212, 0x01B6, 0x00F8, 0x02ED, 0x02ED, 0x0559, 0x0206, 0x0657, 0x0206, 0x0206, 0x05DE, 0x05DE, 0x05DE, 0x05DE, 0x020E,   // 5F50 - 5F5F
	0x020E, 0x04A3, 0x05AC, 0x063D, 0x054D, 0x05CE, 0x05CE, 0x05FB, 0x0098, 0x0053, 0x0038, 0x0115, 0x0041, 0x03DA, 0x05F2, 0x03E7,   // 5F60 - 5F6F
	0x063D, 0x05EA, 0x0098, 0x0098, 0x068C, 0x0566, 0x0212, 0x03C9, 0x065B, 0x05DE, 0x0575, 0x0089, 0x0030, 0x0109, 0x02DB, 0x016F,   // 5F70 - 5F7F
	0x0575, 0x0651, 0x00D9, 0x0575, 0x0231, 0x00F0, 0x058D, 0x05C7, 0x01DD, 0x05D2, 0x01F6, 0x02FD, 0x01EB, 0x0575, 0x0092, 0x0657,   // 5F80 - 5F8F
	0x05BB, 0x0231, 0x0556, 0x00D0, 0xFFFF, 0x029F, 0x00D0, 0x0101, 0x03C1, 0x058D, 0xFFFF, 0x0403, 0x007E, 0x0657, 0x00D0, 0x0661,   // 5F90 - 5F9F
	0x029F, 0x05FB, 0x05A4, 0x0229, 0x0219, 0x0098, 0x0215, 0x0033, 0x0200, 0x016F, 0x05C7, 0x057A, 0x03C9, 0x05D7, 0x057A, 0x058D,   // 5FA0 - 5FAF
	0x0651, 0x03E7, 0x0098, 0x0101, 0x0651, 0x0657, 0x003D, 0x0101, 0x009C, 0x0089, 0x0224, 0x057A, 0x0224, 0x0206, 0x031D, 0x02E4,   // 5FB0 - 5FBF
	0x0599, 0x001F, 0x0431, 0x05A8, 0x05A8, 0x0030, 0x05DE, 0x02B0, 0x0451, 0x00FD, 0x011E, 0x0175, 0x0212, 0x0451, 0x0451, 0x0079,   // 5FC0 - 5FCF
	0x0522, 0x052F, 0x052F, 0x0179, 0x0403, 0x00F0, 0x00E5, 0x0657, 0x0575, 0x0311, 0x058D, 0x0152, 0x05EA, 0x053A, 0x033B, 0x033B,   // 5FD0 - 5FDF
	0x065B, 0x009C, 0x058A, 0x0212, 0x058A, 0x058D, 0x05DB, 0x05F7, 0x0571, 0x0694, 0x065B, 0x0280, 0x05FB, 0x0033, 0x0657, 0x0098,   // 5FE0 - 5FEF
	0x00E1, 0x008D, 0x051E, 0x0562, 0x040A, 0x037C, 0x020A, 0x05B1, 0x0399, 0x0575, 0x0594, 0x05A8, 0x025B, 0x01EF, 0x0253, 0x015F,   // 5FF0 - 5FFF
	0x01F6, 0x051E, 0x04FE, 0x058A, 0x03BB, 0x007E, 0x00B7, 0x0240, 0x05DE, 0x001F, 0x0084, 0x033B, 0x03DF, 0x06AD, 0x0626, 0x05D2,   // 6000 - 600F
	0x0275, 0x0016, 0x03A6, 0x0362, 0x0651, 0x03BE, 0x004D, 0x0544, 0x01EF, 0x01EF, 0x0240, 0x00ED, 0x02C3, 0x04FB, 0x0661, 0x0109,   // 6010 - 601F
	0x00F0, 0x05DE, 0x0556, 0x05F7, 0x016F, 0x0212, 0x03DA, 0x05AC, 0x05FE, 0x0379, 0x01A6, 0x016F, 0x058D, 0x0030, 0x05F7, 0x041A,   // 6020 - 602F
	0x05BE, 0x0694, 0x0045, 0x0200, 0x05BB, 0x00A7, 0x03DF, 0x058D, 0x058D, 0x0522, 0xFFFF, 0x0694, 0x0138, 0xFFFF, 0xFFFF, 0x05DE,   // 6030 - 603F
	0x0098, 0x036D, 0x05C7, 0x04C7, 0x058D, 0x02AC, 0x01E1, 0x028A, 0x034B, 0x0657, 0x05A4, 0x02C3, 0x053F, 0x0200, 0x011A, 0x01D2,   // 6040 - 604F
	0x0270, 0x01B6, 0x01E1, 0x058D, 0x059F, 0x04D0, 0x047D, 0x01EF, 0x042D, 0x05D2, 0x0206, 0x0206, 0x0098, 0x0215, 0x05DE, 0x05B1,   // 6050 - 605F
	0x01A6, 0x02D7, 0x0206, 0x0691, 0x05BB, 0x0098, 0x0599, 0x03B2, 0x01DD, 0x0149, 0x0264, 0x0127, 0x053A, 0x0196, 0x0434, 0x058D,   // 6060 - 606F
	0x0406, 0x0603, 0x03DA, 0x0267, 0x0101, 0x0206, 0x0144, 0xFFFF, 0x054D, 0x05CE, 0x0253, 0x0064, 0x0362, 0x0607, 0x0311, 0x05F2,   // 6070 - 607F
	0x05F2, 0x0243, 0x0311, 0x0294, 0x0415, 0x0603, 0x05FB, 0x05FB, 0x0229, 0x058D, 0x0648, 0x02D7, 0x0537, 0x01C9, 0x01D2, 0x041A,   // 6080 - 608F
	0x0537, 0x004D, 0x05DE, 0x040A, 0x0206, 0x058D, 0x0023, 0x030D, 0x05DE, 0x01E1, 0x04FE, 0x0434, 0x0092, 0x0290, 0x058A, 0x058A,   // 6090 - 609F
	0x05F7, 0x02BC, 0x02C8, 0x01FB, 0x00D0, 0x05DE, 0x0603, 0x02BC, 0x0390, 0x0362, 0x0144, 0x0439, 0x05BE, 0x040A, 0x058A, 0x033B,   // 60A0 - 60AF
	0x00D0, 0x015B, 0x0023, 0x0101, 0x00E1, 0x007E, 0x0321, 0x02BC, 0x0212, 0x01AB, 0x01AB, 0x05AC, 0x00FD, 0x0403, 0x0270, 0x053A,   // 60B0 - 60BF
	0x02F5, 0x058D, 0x0257, 0x0294, 0x0379, 0x0422, 0x00A2, 0x013C, 0x01BE, 0x0079, 0x0231, 0x0571, 0x05FE, 0x022D, 0x0212, 0x02D7,   // 60C0 - 60CF
	0x05FB, 0x020E, 0x01D6, 0x0434, 0x05CE, 0x0537, 0x0537, 0x038C, 0x0575, 0x00C8, 0x01EF, 0x020A, 0x058D, 0x007E, 0x05A8, 0x057A,   // 60D0 - 60DF
	0x0206, 0x0144, 0x046E, 0x0694, 0x0219, 0x05F2, 0x0110, 0x0240, 0x0057, 0x0092, 0x0101, 0x0023, 0x041A, 0x0057, 0x00F4, 0x01AB,   // 60E0 - 60EF
	0x0140, 0x0362, 0x0607, 0x0599, 0x0682, 0x011A, 0x0200, 0x00C3, 0x0427, 0x044E, 0x05AC, 0x0064, 0x0033, 0x020A, 0x0694, 0x0537,   // 60F0 - 60FF
	0x0415, 0x00A2, 0x0023, 0x05BE, 0x057A, 0x0186, 0x040A, 0x057A, 0x05FB, 0x05FB, 0x0030, 0x05BE, 0x01FB, 0x033B, 0x0030, 0x05DE,   // 6100 - 610F
	0x032D, 0x05F2, 0x0253, 0x00F8, 0x05E6, 0x0144, 0x008D, 0x034B, 0x0406, 0x0264, 0x05FB, 0x0002, 0x041A, 0x05CE, 0x03AE, 0x0179,   // 6110 - 611F
	0x0607, 0x0694, 0x047D, 0x02B7, 0x015F, 0xFFFF, 0x0290, 0x0290, 0x0439, 0x0196, 0x0607, 0x0507, 0x0507, 0x0403, 0x05D7, 0x04FE,   // 6120 - 612F
	0x0200, 0xFFFF, 0x019F, 0x0240, 0x00B7, 0x051B, 0x05A4, 0x0253, 0x0651, 0x05F2, 0x0060, 0x0513, 0x04BC, 0x004A, 0x0253, 0x05FE,   // 6130 - 613F
	0x05A4, 0x020A, 0x05F2, 0x05D2, 0x02BC, 0x048A, 0x052B, 0x05E6, 0x00CD, 0x05BB, 0x040A, 0x051E, 0x0200, 0x0607, 0x04BC, 0x033F,   // 6140 - 614F
	0xFFFF, 0x04B3, 0x00D0, 0x03E7, 0x0348, 0x034F, 0x01BE, 0x0098, 0x0057, 0x0057, 0x0057, 0x00E1, 0x033B, 0x0379, 0x063D, 0x054D,   // 6150 - 615F
	0x000C, 0x04E5, 0x030D, 0x01AB, 0x0439, 0x061B, 0x023C, 0x0206, 0x0253, 0x02C3, 0x03BB, 0x04FE, 0x022D, 0x05E6, 0x02FD, 0x04A8,   // 6160 - 616F
	0x057A, 0x0559, 0x030D, 0x040A, 0x0648, 0x05F2, 0x0422, 0x025B, 0x0109, 0x0657, 0x02FD, 0x0243, 0x0403, 0x0403, 0x05FB, 0x03F4,   // 6170 - 617F
	0x02CE, 0x0694, 0x05F7, 0x00B7, 0x0657, 0x054D, 0x0092, 0x0403, 0x0431, 0x03DA, 0x0023, 0x003D, 0x00C3, 0x0224, 0x062A, 0x0098,   // 6180 - 618F
	0x02C3, 0x03F4, 0x0290, 0x0206, 0x0415, 0x0092, 0x05E6, 0x05E6, 0x058D, 0x058D, 0x00F4, 0x0522, 0x0140, 0x0138, 0x0138, 0x0507,   // 6190 - 619F
	0x0248, 0x0064, 0x059F, 0x0152, 0x015F, 0x02AC, 0x02AC, 0x009C, 0x01C9, 0x0403, 0x0594, 0x033B, 0x0231, 0x02CE, 0x058A, 0x0057,   // 61A0 - 61AF
	0x0248, 0x00A2, 0x0594, 0x0522, 0x04C1, 0x03DF, 0x05DE, 0x00A7, 0x0594, 0x0362, 0x00F4, 0x0522, 0x0231, 0x04FE, 0x01C9, 0x0224,   // 61B0 - 61BF
	0x057A, 0x01FB, 0x0127, 0x041E, 0x041E, 0x0431, 0x0060, 0x0267, 0x05A4, 0x05EA, 0x000C, 0x0316, 0x05DE, 0x02D7, 0x048E, 0x024C,   // 61C0 - 61CF
	0x01F6, 0x0321, 0x02A3, 0x0002, 0x02D7, 0x05CE, 0x01A2, 0x0590, 0x0098, 0x05FB, 0x05E6, 0x00F0, 0x0325, 0x0002, 0x0325, 0x0138,   // 61D0 - 61DF
	0x0403, 0x0348, 0x02A3, 0x0321, 0x00A2, 0x0657, 0x03AE, 0x03AE, 0x05CE, 0x05D2, 0x004A, 0x0657, 0x05AC, 0x028A, 0x05F7, 0x016F,   // 61E0 - 61EF
	0x02E0, 0x0337, 0x0092, 0xFFFF, 0x0079, 0x0325, 0x02A3, 0x01F6, 0x05BE, 0x0445, 0x0079, 0x0212, 0x0240, 0x01FB, 0x04B3, 0x05DE,   // 61F0 - 61FF
	0x02C3, 0x0359, 0x032A, 0x0526, 0x0248, 0x017D, 0x017D, 0x067B, 0x0186, 0x0603, 0x058A, 0x0219, 0x05BB, 0x04D0, 0x045D, 0x058D,   // 6200 - 620F
	0x0092, 0x0587, 0x0229, 0x0186, 0x0219, 0x040F, 0x020E, 0x040F, 0x0638, 0x0127, 0x0403, 0x0215, 0x011A, 0x0053, 0x0215, 0x0212,   // 6210 - 621F
	0x04C7, 0x0257, 0x0212, 0x0290, 0x0175, 0x0104, 0x0638, 0x00B7, 0x0186, 0x0219, 0x0229, 0x05FB, 0x0219, 0x05CE, 0x02ED, 0x058D,   // 6220 - 622F
	0x0638, 0x058D, 0x058D, 0x00C8, 0x00F0, 0x0431, 0x01EF, 0x01EF, 0x01EF, 0x0144, 0x04C7, 0x02BC, 0x0316, 0x01EF, 0x02BC, 0x0156,   // 6230 - 623F
	0x0517, 0x0033, 0x0110, 0x0236, 0x04A8, 0x05DE, 0x05DE, 0x04A3, 0x01EF, 0x015B, 0x05CE, 0x04CB, 0x04CB, 0x0053, 0x062F, 0x042D,   // 6240 - 624F
	0x02B0, 0x0400, 0x000F, 0x00ED, 0x0455, 0x016F, 0xFFFF, 0x060E, 0x0566, 0x063D, 0x0115, 0x025B, 0x05FB, 0x0279, 0x01C9, 0x04BC,   // 6250 - 625F
	0x0070, 0x0098, 0x019F, 0x0275, 0x058A, 0x0566, 0x040A, 0x0657, 0x0070, 0x0298, 0x0321, 0x048A, 0x05D2, 0x0399, 0x0016, 0x0089,   // 6260 - 626F
	0x044A, 0x058D, 0x040A, 0x0016, 0x0215, 0x05FB, 0x016F, 0x000C, 0x058D, 0x03DF, 0x0657, 0x0691, 0x0144, 0x013C, 0x0643, 0x0092,   // 6270 - 627F
	0x0212, 0x05CE, 0x028A, 0x0033, 0x0084, 0x0240, 0x057E, 0x01EF, 0x0603, 0x0248, 0x000F, 0x041E, 0x064C, 0x0651, 0x0607, 0x0571,   // 6280 - 628F
	0x0352, 0x05DE, 0x04D0, 0x066A, 0x03FC, 0x0552, 0x012C, 0x025B, 0x0648, 0x03FC, 0x016F, 0x03CE, 0x000F, 0x000C, 0x061F, 0x0559,   // 6290 - 629F
	0x0275, 0x02F5, 0x040F, 0xFFFF, 0x01EF, 0x001F, 0x0045, 0x0657, 0x03DA, 0x0522, 0x0400, 0x03DF, 0x051E, 0x05D7, 0x064C, 0x062F,   // 62A0 - 62AF
	0x05D2, 0x001F, 0x01D6, 0x0379, 0x05DE, 0x0109, 0x0098, 0x03DF, 0x060B, 0x0348, 0x0348, 0x008D, 0x05CB, 0x00A2, 0x0431, 0x033B,   // 62B0 - 62BF
	0x00A7, 0x0215, 0x016F, 0x062F, 0x0666, 0x00F4, 0x0074, 0x034F, 0x037C, 0x029C, 0x016F, 0x03CE, 0x0016, 0x03C1, 0x02D7, 0x0352,   // 62C0 - 62CF
	0x01A6, 0x040A, 0x0240, 0x0566, 0x000F, 0x0566, 0x0566, 0x000C, 0x0240, 0x068C, 0x03C5, 0x0643, 0x0012, 0x0012, 0x0109, 0x0379,   // 62D0 - 62DF
	0x0240, 0x0298, 0x02E4, 0x0219, 0x0406, 0x05F2, 0x02A3, 0x0394, 0x004A, 0x061F, 0x040A, 0x01DD, 0x0298, 0x04C7, 0x0229, 0x0651,   // 62E0 - 62EF
	0x0390, 0x0196, 0x0196, 0x0434, 0x04DF, 0x0562, 0x0612, 0x0260, 0x0098, 0x05A4, 0x0064, 0x0206, 0x03F0, 0x066F, 0x04C7, 0x0352,   // 62F0 - 62FF
	0x004A, 0x0098, 0x01A2, 0x0657, 0x0298, 0x0140, 0x0140, 0x0657, 0x041A, 0x0005, 0x039D, 0x064C, 0x0186, 0x0224, 0x027C, 0x0127,   // 6300 - 630F
	0x0466, 0x053F, 0x02D3, 0x062F, 0x02FD, 0x011A, 0x056A, 0x0248, 0xFFFF, 0x0240, 0x0657, 0x02F0, 0x05CB, 0x066A, 0x051B, 0x05A4,   // 6310 - 631F
	0x0362, 0x00F8, 0x0224, 0x0651, 0x0212, 0x0206, 0x0594, 0xFFFF, 0x0002, 0x0566, 0x03AE, 0x00E9, 0x004A, 0x0191, 0x0537, 0x064C,   // 6320 - 632F
	0x0092, 0x0517, 0x0517, 0x026B, 0x031D, 0x02E4, 0x0240, 0x03DA, 0x0219, 0x05DE, 0x0548, 0x04A3, 0x03AE, 0x0571, 0x05A4, 0x0070,   // 6330 - 633F
	0x0163, 0x0224, 0x058A, 0x024C, 0x023C, 0x054D, 0x0294, 0x020E, 0x0556, 0x068C, 0x03FC, 0x02FD, 0x000F, 0x01C9, 0x04AE, 0x038C,   // 6340 - 634F
	0x0243, 0x04B3, 0x04D0, 0x05DB, 0x0248, 0x004D, 0x01FB, 0x004D, 0x024C, 0x05DE, 0x0633, 0x02FD, 0x0503, 0x0566, 0x02AC, 0x0513,   // 6350 - 635F
	0x001A, 0x0219, 0x01FB, 0x00FD, 0xFFFF, 0x0571, 0x041E, 0x03DA, 0x04B3, 0x02D3, 0x033B, 0x0321, 0x016F, 0x0012, 0x0240, 0x00FD,   // 6360 - 636F
	0x0587, 0x0002, 0x0243, 0x0603, 0x0694, 0x008D, 0x00BE, 0x0229, 0x0556, 0x0027, 0x0352, 0x037C, 0x03AE, 0x069D, 0x0587, 0x058D,   // 6370 - 637F
	0x0594, 0x0092, 0x0110, 0x048A, 0x02F5, 0x0422, 0x017D, 0x0140, 0x04CB, 0x0115, 0x03FC, 0x0109, 0x063D, 0x01BA, 0x0212, 0x052B,   // 6380 - 638F
	0x0406, 0x0403, 0x03C1, 0x04D0, 0x040A, 0x02DB, 0x05DB, 0x05CB, 0x0248, 0x0651, 0x02C8, 0x01A2, 0x05DE, 0x020E, 0x04A3, 0x011E,   // 6390 - 639F
	0x0300, 0x0053, 0x0522, 0x0089, 0x0045, 0x0229, 0x0537, 0x0270, 0x055E, 0x05CE, 0x00E9, 0x0699, 0x0240, 0x053A, 0x040A, 0x0267,   // 63A0 - 63AF
	0x0012, 0x04CB, 0x0229, 0x02ED, 0x01A6, 0xFFFF, 0xFFFF, 0x0657, 0x00F4, 0xFFFF, 0x0079, 0x048A, 0x01AB, 0x03DA, 0x05FE, 0x03AE,   // 63B0 - 63BF
	0x0219, 0x0651, 0x023C, 0x0219, 0x05FB, 0x05CE, 0x0290, 0x0359, 0x01E6, 0x0462, 0x03DF, 0x057A, 0x047D, 0x0699, 0x05BE, 0x0332,   // 63C0 - 63CF
	0x0537, 0x038C, 0x0070, 0x04C7, 0x0694, 0x064C, 0x05DE, 0x04F1, 0x01E1, 0x0033, 0x05D2, 0x01FB, 0x05CE, 0x0612, 0x0005, 0x05BB,   // 63D0 - 63DF
	0x05CB, 0x0587, 0x0264, 0x00AB, 0x0212, 0x0537, 0x029C, 0x029C, 0x0092, 0x0253, 0x023C, 0x023C, 0x0556, 0x0229, 0x0206, 0x0191,   // 63E0 - 63EF
	0x009C, 0x04F6, 0x04B3, 0x05A4, 0x05FE, 0x040A, 0x05DB, 0x0070, 0x062F, 0x0023, 0x05D7, 0xFFFF, 0xFFFF, 0x02A3, 0x057E, 0x041E,   // 63F0 - 63FF
	0x0079, 0x0186, 0x02E9, 0x0694, 0x0191, 0x0224, 0x019B, 0x041E, 0x05F2, 0x0439, 0x00A2, 0x00AB, 0x0638, 0x0513, 0x0513, 0x004A,   // 6400 - 640F
	0x00A7, 0x045D, 0x001A, 0x00E9, 0x048A, 0x0264, 0x05D7, 0x00FD, 0x0657, 0x03A6, 0x05A4, 0x0219, 0x0503, 0x042D, 0x0182, 0x0594,   // 6410 - 641F
	0x04F6, 0x0485, 0x022D, 0x0337, 0x0144, 0x00BE, 0x03AE, 0x04A3, 0x051B, 0x0229, 0x0526, 0x03C5, 0x0016, 0x00ED, 0x02BC, 0x052B,   // 6420 - 642F
	0x01EF, 0x0657, 0x056A, 0x0590, 0x040A, 0x057E, 0x040F, 0x008D, 0x064C, 0x0144, 0x05A4, 0x03AE, 0x0434, 0x0070, 0x062F, 0x0186,   // 6430 - 643F
	0x058A, 0x0149, 0x04B3, 0x0196, 0x04B3, 0x04D0, 0x0012, 0x05D7, 0x0041, 0x0503, 0x0522, 0x049A, 0x0079, 0x0517, 0x02CE, 0x009C,   // 6440 - 644F
	0x00B7, 0x01BE, 0x0045, 0x0163, 0x04D9, 0x0109, 0x0403, 0xFFFF, 0x0633, 0x02C3, 0x0092, 0x0098, 0x01AB, 0x02ED, 0x02F9, 0x02E9,   // 6450 - 645F
	0x0694, 0x0175, 0x01EF, 0x062F, 0x00B7, 0x0526, 0x01F2, 0x00E1, 0x0355, 0x0348, 0x021E, 0x01B6, 0x05EA, 0x0657, 0x000C, 0x0657,   // 6460 - 646F
	0x0098, 0x030D, 0x04A3, 0x0275, 0x04D0, 0x0517, 0x0559, 0x0643, 0x0348, 0x0348, 0x0648, 0x0079, 0x026B, 0x0038, 0x021E, 0x05E6,   // 6470 - 647F
	0x019B, 0x040A, 0x02CE, 0x0212, 0x05EA, 0x0248, 0x03EC, 0x03EC, 0x02AC, 0x013C, 0x0594, 0x0469, 0x0290, 0x0612, 0x05DE, 0x0594,   // 6480 - 648F
	0x0092, 0x0092, 0x047A, 0x0362, 0x01E1, 0x04FB, 0x01C9, 0x0200, 0x00ED, 0x06A9, 0x037C, 0x02D7, 0x0651, 0x0206, 0x067B, 0x0224,   // 6490 - 649F
	0x0212, 0x0060, 0x00F4, 0x00F4, 0x0089, 0x004A, 0x0089, 0x0248, 0x059F, 0x02CE, 0x0027, 0x016F, 0x0415, 0x004A, 0x00E9, 0x068C,   // 64A0 - 64AF
	0x0675, 0x0566, 0x0400, 0x041E, 0x013C, 0x037C, 0xFFFF, 0x05A4, 0x02ED, 0x0224, 0x00DC, 0x051B, 0x01C9, 0x0415, 0x066A, 0x0219,   // 64B0 - 64BF
	0x0179, 0x05F2, 0x02B3, 0x0298, 0x02ED, 0x04A3, 0x068C, 0x061F, 0x0400, 0x00C8, 0x0212, 0x00F8, 0x048E, 0x0060, 0x0422, 0x0231,   // 64C0 - 64CF
	0x01FB, 0x0229, 0x041E, 0x0280, 0x00F4, 0x05A4, 0x0186, 0x03DF, 0x004A, 0x000C, 0x0240, 0x05DB, 0xFFFF, 0xFFFF, 0x0503, 0x032A,   // 64D0 - 64DF
	0x0212, 0x051E, 0x068C, 0x00FD, 0x05AC, 0x02A3, 0x0050, 0x0240, 0x05DB, 0x0466, 0x05DB, 0x05DB, 0x0379, 0x020E, 0x0212, 0x0041,   // 64E0 - 64EF
	0x0394, 0x0186, 0x0657, 0x0229, 0x0298, 0x0348, 0x0219, 0x05A4, 0x02D3, 0x0522, 0x0012, 0x0503, 0x02ED, 0x0300, 0x044A, 0x0657,   // 64F0 - 64FF
	0x03C5, 0x05D2, 0x02B3, 0x047A, 0x04D0, 0x0612, 0x037C, 0x0594, 0x024C, 0x020E, 0x0300, 0x029C, 0x01C9, 0x05EA, 0x02ED, 0x02E4,   // 6500 - 650F
	0x040A, 0x040A, 0x0612, 0x040A, 0x02A3, 0x0481, 0x05EA, 0x031D, 0x0445, 0x0079, 0xFFFF, 0x00DC, 0x05A4, 0x04B3, 0x02F9, 0x024C,   // 6510 - 651F
	0x032A, 0x02BC, 0x0612, 0x02F0, 0x0522, 0x06A0, 0x02BC, 0x0110, 0x056A, 0x00F8, 0x0224, 0x0248, 0x02A3, 0x02BC, 0x035D, 0x0657,   // 6520 - 652F
	0x01B6, 0x01B6, 0x0403, 0x05A8, 0x03F9, 0x03F9, 0x04CB, 0x0260, 0x05F7, 0x0175, 0x0175, 0x0196, 0x0179, 0x0016, 0x0156, 0x0651,   // 6530 - 653F
	0x004A, 0x0110, 0x0275, 0x033B, 0x058A, 0x019F, 0x0186, 0x0064, 0x059F, 0x032A, 0x00A7, 0x0186, 0x0109, 0x05BB, 0x0224, 0x033B,   // 6540 - 654F
	0x008D, 0x023C, 0x04BC, 0x0140, 0x05FB, 0x0098, 0x000C, 0x0012, 0x05BB, 0x0224, 0x0140, 0x02C3, 0x038C, 0x0030, 0x007E, 0x0110,   // 6550 - 655F
	0x0140, 0x05DE, 0x0179, 0x0481, 0x0264, 0x05CE, 0x013C, 0x0403, 0x012C, 0x059F, 0x0140, 0x0224, 0x0231, 0x05D2, 0x0590, 0x020A,   // 6560 - 656F
	0x04D0, 0x0002, 0x0415, 0x0002, 0x0651, 0x0109, 0x064C, 0x016F, 0x04D0, 0x02CE, 0x0431, 0x05B1, 0x058D, 0x0224, 0xFFFF, 0x0415,   // 6570 - 657F
	0x068C, 0x05DE, 0x02C3, 0x0030, 0x02BC, 0x05C3, 0x059F, 0x057E, 0x05C3, 0x0403, 0x0403, 0x0633, 0x0041, 0x0248, 0x0633, 0x02A7,   // 6580 - 658F
	0x015B, 0x0016, 0x0016, 0x02A3, 0x05FB, 0x02A3, 0x057A, 0x012C, 0x04C1, 0x02CE, 0x0215, 0x01EF, 0x05A4, 0x0215, 0x05FB, 0x064C,   // 6590 - 659F
	0x0224, 0x0587, 0x053F, 0x012C, 0x022D, 0x0098, 0x05E6, 0x016F, 0x040F, 0x0638, 0x0431, 0x068C, 0x0638, 0x0133, 0x068C, 0x04FB,   // 65A0 - 65AF
	0x05A8, 0x068C, 0x068C, 0x041E, 0x02D7, 0x068C, 0x00A7, 0x0133, 0x0666, 0x0156, 0x05A4, 0x01CD, 0x058A, 0x04C7, 0x03D2, 0x05F7,   // 65B0 - 65BF
	0xFFFF, 0x03C9, 0x0403, 0x0638, 0x0316, 0x02FD, 0x03D2, 0x03DF, 0x02E0, 0x016F, 0x0156, 0x05BE, 0x0231, 0x0231, 0x0379, 0x069D,   // 65C0 - 65CF
	0x0643, 0x05DE, 0x02E0, 0x04AE, 0x0219, 0xFFFF, 0x05DE, 0x0403, 0x0657, 0x0152, 0x03E7, 0x0152, 0x0638, 0x01A6, 0x050F, 0x05FB,   // 65D0 - 65DF
	0x058A, 0x0212, 0x0212, 0x0212, 0x020E, 0x045A, 0x00F4, 0x023C, 0x0657, 0x061B, 0x05A4, 0x053F, 0x05C7, 0x05BB, 0x0172, 0x029C,   // 65E0 - 65EF
	0x0179, 0x01C9, 0x051E, 0x0109, 0x05BB, 0x0079, 0x04C7, 0x028A, 0x05D2, 0x04C7, 0x0575, 0x033B, 0x033B, 0x0562, 0x00C3, 0x058A,   // 65F0 - 65FF
	0x0607, 0x0023, 0x0008, 0x061F, 0x0016, 0x0229, 0x0294, 0x04C1, 0x01EF, 0x0156, 0x01D2, 0x01B6, 0x007E, 0x05BE, 0x033F, 0x020A,   // 6600 - 660F
	0x015F, 0x041E, 0x01EF, 0x05DE, 0x058D, 0x05A8, 0x05CE, 0x061F, 0x0156, 0x0522, 0x04BC, 0x0240, 0x05D2, 0x0612, 0x0045, 0x05AC,   // 6610 - 661F
	0x05EA, 0x05BE, 0x03D2, 0x064C, 0x02DB, 0x00C3, 0x01D2, 0x031D, 0x06AD, 0x0348, 0x0033, 0x05BB, 0x020A, 0x0643, 0x0694, 0x04C7,   // 6620 - 662F
	0x04C7, 0x05FB, 0x015B, 0x011A, 0x0316, 0x0379, 0x007E, 0x057E, 0x0127, 0x0002, 0x0045, 0x0008, 0x0661, 0x02E4, 0x0594, 0x028A,   // 6630 - 663F
	0x053F, 0x0084, 0x04C7, 0x0200, 0x0200, 0x05BE, 0x0290, 0x05BB, 0x0224, 0x022D, 0x0657, 0x022D, 0x04A8, 0x054D, 0x01E6, 0x05CE,   // 6640 - 664F
	0x0175, 0x0599, 0x049E, 0x059F, 0x05DB, 0x0607, 0x0206, 0x01C9, 0x01C9, 0x024C, 0x0571, 0x0594, 0x0294, 0x0661, 0x058D, 0x04C1,   // 6650 - 665F
	0x04C1, 0x004D, 0x0648, 0x0648, 0x058A, 0x01C9, 0x0206, 0x01D2, 0x008D, 0x0571, 0x053A, 0x068C, 0x06A5, 0x0661, 0x0400, 0x0231,   // 6660 - 666F
	0x058D, 0x04A3, 0x05DE, 0x058D, 0x0422, 0x0403, 0x0231, 0x01B6, 0x064C, 0x05DE, 0x0657, 0x0005, 0x0571, 0x02D7, 0x02C8, 0x007E,   // 6670 - 667F
	0x0575, 0x059F, 0x0612, 0xFFFF, 0x05BE, 0x0191, 0x05DE, 0x0590, 0x0607, 0x0206, 0x016F, 0x033B, 0x0290, 0x01D6, 0x05EA, 0x0130,   // 6680 - 668F
	0x057A, 0x04D0, 0x0422, 0x0316, 0x0359, 0x0219, 0x03A9, 0x0005, 0x05D2, 0x00C3, 0x05D7, 0x0517, 0x0400, 0x033F, 0x0224, 0x0253,   // 6690 - 669F
	0x0182, 0x0582, 0x007E, 0x0403, 0x01D2, 0x05CE, 0x02BC, 0x0002, 0x0212, 0x01B6, 0x0321, 0x0612, 0x05A4, 0x01D2, 0x034F, 0x0348,   // 66A0 - 66AF
	0x00D0, 0x0379, 0x063D, 0x0206, 0x001F, 0x01C9, 0x05BE, 0x00B1, 0x02CE, 0x0594, 0x00F4, 0x0231, 0x03EC, 0x02D7, 0x0562, 0x058D,   // 66B0 - 66BF
	0x05DE, 0x0212, 0x028A, 0x00F0, 0x05DB, 0x05DB, 0x02BC, 0x0522, 0x054D, 0x059F, 0x015B, 0x041E, 0x0643, 0x01D2, 0x05DE, 0x0599,   // 66C0 - 66CF
	0x05AC, 0x0491, 0x0224, 0x001F, 0x0231, 0xFFFF, 0x0002, 0x05DB, 0x0466, 0x04D0, 0x0325, 0x05C7, 0x05D7, 0x0400, 0x02BC, 0x008D,   // 66D0 - 66DF
	0x028A, 0x011A, 0xFFFF, 0x05CE, 0x020E, 0x02ED, 0x058D, 0x045D, 0x02E4, 0x035D, 0x02F9, 0x02F0, 0x049E, 0x0526, 0x05CE, 0x00A7,   // 66E0 - 66EF
	0x0603, 0x0603, 0x0431, 0x05DB, 0x0191, 0x066F, 0x01EF, 0x01D6, 0x04D0, 0x0060, 0x0060, 0x04C1, 0x030D, 0x006B, 0x006B, 0x0537,   // 66F0 - 66FF
	0x06A5, 0x0057, 0x05BB, 0x0206, 0x05E6, 0x041A, 0x015F, 0x03DF, 0x0603, 0x05F7, 0x0469, 0x03DA, 0x0016, 0x016F, 0x02DB, 0x015B,   // 6700 - 670F
	0x0431, 0xFFFF, 0x03B2, 0x053F, 0x04F6, 0x064C, 0x02A7, 0x02A7, 0x0243, 0x033F, 0x0200, 0x0575, 0x0562, 0x0643, 0x0212, 0x0403,   // 6710 - 671F
	0x05EA, 0x0694, 0x0575, 0x054D, 0x02A7, 0xFFFF, 0x0325, 0x02E4, 0x034F, 0x0104, 0x057A, 0x0348, 0x0027, 0x062F, 0x0666, 0x0666,   // 6720 - 672F
	0xFFFF, 0x0666, 0x0451, 0x000F, 0x03F9, 0x0140, 0x0140, 0x00FD, 0x02BC, 0x042D, 0x0212, 0x023C, 0x0030, 0x05B7, 0x0548, 0x00CD,   // 6730 - 673F
	0x049A, 0xFFFF, 0x060B, 0x0434, 0x040A, 0x05FB, 0x0179, 0x058A, 0x0070, 0x04A3, 0x05C7, 0x0152, 0x058A, 0x0691, 0x02BC, 0x05AC,   // 6740 - 674F
	0x0053, 0x00E5, 0x0451, 0x04AE, 0x0648, 0x0109, 0x063D, 0x0311, 0x0098, 0x05DE, 0x019F, 0x0196, 0x0130, 0x05DE, 0x0403, 0x04D0,   // 6750 - 675F
	0x017D, 0x053F, 0xFFFF, 0xFFFF, 0xFFFF, 0x029F, 0x04A3, 0x0311, 0x05D2, 0x0306, 0x0332, 0x04FB, 0x05FE, 0x01CD, 0x015B, 0x0023,   // 6760 - 676F
	0x0229, 0x0127, 0x0182, 0x05D7, 0x0594, 0x00A7, 0x00C3, 0x03BE, 0x04D0, 0x01F2, 0x05A8, 0x00A2, 0x0666, 0x00A2, 0x04FE, 0x0016,   // 6770 - 677F
	0x04FE, 0x0212, 0x0603, 0x0607, 0x019B, 0x0212, 0x0316, 0x03DF, 0x0030, 0x0575, 0x0008, 0x0156, 0x015F, 0x05DE, 0x016F, 0x0359,   // 6780 - 678F
	0x058D, 0x01EF, 0x05CB, 0x012C, 0x05C7, 0x064C, 0x05D7, 0x02D7, 0x046E, 0x0144, 0x031D, 0x0643, 0x01BE, 0x0657, 0x0694, 0x0607,   // 6790 - 679F
	0xFFFF, 0x012C, 0x04D0, 0x061B, 0xFFFF, 0x02BC, 0x02ED, 0x0219, 0x0092, 0x04FE, 0x040F, 0x0163, 0x0359, 0x059F, 0x0594, 0x0279,   // 67A0 - 67AF
	0x03F4, 0x051E, 0x058D, 0x0657, 0x01A6, 0x059F, 0x0215, 0x0215, 0x019B, 0x001F, 0x0348, 0x05DE, 0x05DB, 0x0485, 0x04C7, 0x038C,   // 67B0 - 67BF
	0x0030, 0x0566, 0x05DE, 0x02DB, 0x0045, 0x0379, 0x029C, 0x01D6, 0x0016, 0x0152, 0x065B, 0x00F0, 0x00CD, 0x05D2, 0x016F, 0x004A,   // 67C0 - 67CF
	0x034B, 0x0179, 0x0403, 0x0441, 0x0462, 0x0316, 0x0643, 0x04FE, 0x0648, 0x0590, 0x05F7, 0x04BC, 0x0240, 0x0566, 0x06AD, 0x0359,   // 67D0 - 67DF
	0x0394, 0x05F2, 0x0109, 0x0657, 0x062F, 0x0070, 0x00F4, 0x019F, 0xFFFF, 0x023C, 0x000C, 0x016F, 0x0219, 0x004A, 0x0140, 0x0264,   // 67E0 - 67EF
	0x0355, 0x0666, 0x0030, 0x02E0, 0x0074, 0x062F, 0x04FB, 0x0666, 0x03D2, 0x04C7, 0x01A6, 0x0070, 0x05D7, 0x0092, 0x023C, 0x04C7,   // 67F0 - 67FF
	0x0657, 0x02E0, 0x031D, 0xFFFF, 0x045D, 0x062F, 0xFFFF, 0x0038, 0x0638, 0x0657, 0x02E4, 0x0127, 0x02ED, 0xFFFF, 0x02BC, 0x02A3,   // 6800 - 680F
	0x05F2, 0x04D0, 0x05C7, 0x04DF, 0x0403, 0x064C, 0x0403, 0x02BC, 0x0098, 0x0599, 0x064C, 0x02BC, 0x0507, 0x01A2, 0x0257, 0x0045,   // 6810 - 681F
	0x0451, 0x059F, 0x004A, 0x0451, 0x0045, 0x0691, 0x00A2, 0x05DE, 0x00CD, 0x05BB, 0x0666, 0x0219, 0x06A5, 0x014C, 0x014C, 0x05FB,   // 6820 - 682F
	0x014F, 0x0196, 0x0260, 0x02AC, 0x0638, 0x02BC, 0xFFFF, 0x05D2, 0x01D6, 0x018D, 0x0657, 0x0098, 0x0186, 0x060E, 0x02F0, 0x014F,   // 6830 - 683F
	0x0229, 0x01E1, 0x01B6, 0x052B, 0x01B0, 0x057A, 0x028A, 0x0466, 0x0005, 0x0005, 0x0243, 0x05DE, 0x068C, 0x0279, 0x0657, 0x0427,   // 6840 - 684F
	0x054D, 0x0485, 0x0485, 0x01FB, 0x0229, 0x023C, 0x05C3, 0x0140, 0x0682, 0x05FB, 0x0612, 0xFFFF, 0x05EA, 0xFFFF, 0xFFFF, 0x0638,   // 6850 - 685F
	0x05CB, 0x044A, 0x064C, 0x00F8, 0x0403, 0x0415, 0x01F2, 0x01B6, 0x021E, 0x067B, 0x05C7, 0x0517, 0x0517, 0x064C, 0x0023, 0x0548,   // 6860 - 686F
	0x0298, 0x0231, 0x004A, 0x0027, 0x016F, 0x046E, 0x054D, 0x0248, 0x058D, 0x02A7, 0x02E0, 0x0163, 0x0403, 0x057E, 0x024C, 0x0179,   // 6870 - 687F
	0x00D9, 0x02C8, 0x042D, 0x0548, 0x05F7, 0x031D, 0x001A, 0x02E4, 0x03DA, 0x067B, 0x0109, 0x05BE, 0x0556, 0x061B, 0x000C, 0x019F,   // 6880 - 688F
	0x0030, 0x0109, 0x01C9, 0x0691, 0x0657, 0x0451, 0x0023, 0x0191, 0x0219, 0x01FB, 0x0571, 0x03AE, 0x0215, 0x053F, 0x0212, 0x059F,   // 6890 - 689F
	0x02FD, 0x0285, 0x04AE, 0x0067, 0x015F, 0x04FE, 0x0325, 0x058A, 0x02BC, 0x02BC, 0x012C, 0x0067, 0x05EA, 0x0517, 0x0240, 0x0537,   // 68A0 - 68AF
	0x05A4, 0x0294, 0x068C, 0x04D0, 0x0079, 0x0152, 0x057A, 0x0231, 0x02BC, 0x0045, 0xFFFF, 0xFFFF, 0x052B, 0x0657, 0x029F, 0x02C3,   // 68B0 - 68BF
	0x0219, 0x068C, 0x02DB, 0x02BC, 0x0403, 0x0045, 0x02F5, 0x00D0, 0x040A, 0x032D, 0x0403, 0x0403, 0x0053, 0x01BA, 0x0079, 0x0101,   // 68C0 - 68CF
	0x015B, 0x03C1, 0x001A, 0x03FC, 0x020A, 0x0694, 0x0092, 0x061B, 0x0212, 0x02BC, 0x03DA, 0x05FB, 0x05FB, 0x019F, 0x020A, 0x0127,   // 68D0 - 68DF
	0x0526, 0x017D, 0x0575, 0x0109, 0x058D, 0x0152, 0x0092, 0x0638, 0x0403, 0x05FE, 0x05CE, 0x05FB, 0x0434, 0x05DE, 0x0491, 0x0451,   // 68E0 - 68EF
	0x00BE, 0x02B7, 0x0403, 0x068C, 0x016F, 0x0264, 0x029F, 0x0699, 0x0699, 0x0643, 0x01AB, 0x015F, 0x015F, 0x008D, 0x0427, 0x038C,   // 68F0 - 68FF
	0x0571, 0x01BE, 0x02ED, 0x01D2, 0x0229, 0x05DE, 0x00A2, 0x0240, 0x0240, 0x0092, 0x06AD, 0x02C8, 0x040F, 0x0657, 0x0682, 0x05CB,   // 6900 - 690F
	0x0240, 0x0023, 0x0224, 0x068C, 0x0691, 0x0041, 0x03DA, 0x011E, 0x00A7, 0x04A3, 0xFFFF, 0xFFFF, 0x0219, 0x01B6, 0x058D, 0x0130,   // 6910 - 691F
	0x040A, 0xFFFF, 0x0290, 0xFFFF, 0x02F9, 0x0657, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x03DA, 0x04A3, 0xFFFF, 0x0566, 0x0491, 0x0140,   // 6920 - 692F
	0x05DB, 0x016F, 0x057A, 0x057A, 0x0133, 0x0215, 0x0694, 0x0219, 0x05DE, 0x04BC, 0x058D, 0x05CE, 0x05CE, 0x00B1, 0x0638, 0x00C3,   // 6930 - 693F
	0x05FB, 0x01D6, 0x062F, 0x0587, 0x0033, 0x0030, 0x05D7, 0x020E, 0x05BB, 0x0476, 0x05D2, 0x029C, 0x05CE, 0x0027, 0x020A, 0x0290,   // 6940 - 694F
	0x0229, 0x0290, 0x04FB, 0x0163, 0x05A4, 0x0566, 0x0212, 0x0219, 0x034F, 0x0316, 0x00A7, 0x01EF, 0x01EF, 0x02C3, 0x02B7, 0x0548,   // 6950 - 695F
	0x0359, 0x05FB, 0x05F7, 0x031D, 0x04FE, 0x05BE, 0x05BE, 0x05EA, 0x064C, 0x03E2, 0x011A, 0x0212, 0x0229, 0x05DB, 0x00A7, 0x04F1,   // 6960 - 696F
	0x05FB, 0x00D5, 0x057A, 0x031D, 0x0109, 0x0212, 0x0229, 0x0253, 0x042D, 0x05EA, 0x0462, 0x01E1, 0x02E9, 0x02B0, 0xFFFF, 0x01B6,   // 6970 - 697F
	0x03F0, 0xFFFF, 0x0175, 0x0522, 0x02A3, 0x0607, 0x05FB, 0x008D, 0x02FD, 0x0240, 0xFFFF, 0xFFFF, 0xFFFF, 0x05A4, 0x0215, 0x05DE,   // 6980 - 698F
	0x0638, 0x016F, 0x03AE, 0x032A, 0x02A7, 0x045D, 0x019F, 0x0219, 0x0240, 0x051B, 0x05D7, 0x064C, 0x001A, 0x049A, 0x05FE, 0x0691,   // 6990 - 699F
	0x033F, 0x0507, 0x0215, 0x05D7, 0x0229, 0x0200, 0x0179, 0x015B, 0x062F, 0x040A, 0x0306, 0x0513, 0x05FE, 0x05A4, 0x045D, 0x04C7,   // 69A0 - 69AF
	0x0657, 0x00E1, 0x0607, 0x0548, 0x02E0, 0x045D, 0x0526, 0x0439, 0x0633, 0x04FB, 0x04C1, 0x051B, 0x0264, 0x058D, 0x019F, 0x0403,   // 69B0 - 69BF
	0x0260, 0x0182, 0x0513, 0x03C5, 0x052B, 0x0186, 0x05C7, 0x0110, 0x03A2, 0x0212, 0x04F6, 0x019B, 0x00BE, 0x040F, 0x0070, 0x040A,   // 69C0 - 69CF
	0x01F6, 0x031D, 0x05BB, 0x017D, 0x0182, 0x068C, 0x0566, 0x0415, 0x05D2, 0x0110, 0x0215, 0x0219, 0x06A5, 0xFFFF, 0x02E4, 0x0041,   // 69D0 - 69DF
	0x0666, 0xFFFF, 0x058D, 0x0403, 0x02C3, 0x0206, 0x05F2, 0x040A, 0x01BE, 0x0175, 0x0175, 0x0559, 0x01F2, 0x0403, 0x0491, 0x00E1,   // 69E0 - 69EF
	0x002B, 0x05F7, 0x01EF, 0x021E, 0x01EF, 0x01FB, 0x0290, 0x05DE, 0x05DE, 0x0182, 0x025B, 0x01B6, 0x01B6, 0x0060, 0x030D, 0x022D,   // 69F0 - 69FF
	0x0109, 0x067B, 0x02B0, 0x02A7, 0x008D, 0x00D0, 0x02BC, 0x05B7, 0x0422, 0x04E5, 0x0152, 0x054D, 0x01AB, 0x0212, 0x0517, 0x02B3,   // 6A00 - 6A0F
	0x02ED, 0x02C8, 0x032A, 0x02E9, 0x0084, 0x0507, 0x0264, 0x00A7, 0x0526, 0x0038, 0x02ED, 0x023C, 0x04D0, 0x062F, 0x04D0, 0x063D,   // 6A10 - 6A1F
	0x0321, 0x0348, 0x0387, 0x05D2, 0x053F, 0x03DA, 0x0666, 0x049A, 0x058D, 0x0434, 0x01E1, 0x0219, 0x00D0, 0xFFFF, 0xFFFF, 0x040F,   // 6A20 - 6A2F
	0xFFFF, 0x05EA, 0x014C, 0x05A8, 0x0657, 0x0415, 0x06A5, 0x00D0, 0x0400, 0x04D0, 0x01F2, 0x0290, 0x064C, 0x06A9, 0x0603, 0x0638,   // 6A30 - 6A3F
	0x058D, 0x05C7, 0x0110, 0x014F, 0x0179, 0x0348, 0x058A, 0x0415, 0x044A, 0x02D7, 0x02E0, 0x0415, 0x0594, 0x0472, 0x0152, 0x0638,   // 6A40 - 6A4F
	0x0566, 0x02AC, 0x0607, 0x04F1, 0x055E, 0x0092, 0x0526, 0x0325, 0x0240, 0x0092, 0x0507, 0x0248, 0x0248, 0x0522, 0x0206, 0x0212,   // 6A50 - 6A5F
	0x03AE, 0x0599, 0x0566, 0x0394, 0x046E, 0x0666, 0x054D, 0x062A, 0x015F, 0x0427, 0x0441, 0x01E1, 0x0067, 0x019F, 0x02E0, 0x02AC,   // 6A60 - 6A6F
	0x0182, 0x00A7, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0212, 0x012C, 0xFFFF, 0x02ED, 0xFFFF, 0xFFFF, 0x05FE, 0x051B, 0x04D0, 0x021E,   // 6A70 - 6A7F
	0x0522, 0x02D7, 0x039D, 0x05E6, 0x058D, 0x050F, 0x04A3, 0x06A5, 0x05BE, 0x0092, 0x0179, 0x0240, 0x06A5, 0x05DE, 0x041E, 0x0400,   // 6A80 - 6A8F
	0x05CE, 0x02B3, 0x0163, 0x0206, 0x00F8, 0x0212, 0x050F, 0x004A, 0x0030, 0x011E, 0x00A7, 0x066A, 0x01B6, 0x0212, 0x0215, 0x0215,   // 6A90 - 6A9F
	0x0422, 0x0648, 0x0219, 0x040F, 0x00FD, 0x05DE, 0x0038, 0x04FE, 0x04B3, 0x02D7, 0x02BC, 0x0070, 0x0325, 0x05E6, 0x052B, 0x051E,   // 6AA0 - 6AAF
	0x032D, 0x0403, 0xFFFF, 0x0041, 0x020E, 0x0212, 0x040A, 0x032A, 0x0394, 0x05DE, 0x0182, 0x0219, 0x05E6, 0x014C, 0x0422, 0x05CE,   // 6AB0 - 6ABF
	0x0403, 0x032A, 0x0643, 0x01B6, 0x00C3, 0x0212, 0x0290, 0x03F9, 0x0104, 0x00A7, 0xFFFF, 0x032D, 0x05F7, 0x0657, 0x01B0, 0x040A,   // 6AC0 - 6ACF
	0x02B3, 0x02B3, 0x047A, 0x02ED, 0xFFFF, 0x00DC, 0x02FD, 0x0337, 0x0206, 0x03BB, 0x02FD, 0x0657, 0x0182, 0x0130, 0x05FE, 0x02BC,   // 6AD0 - 6ADF
	0x015B, 0x0666, 0x0503, 0x02C3, 0xFFFF, 0x00A7, 0xFFFF, 0x0666, 0x02ED, 0x05CE, 0x02BC, 0x0666, 0x008D, 0x0229, 0x0144, 0x0507,   // 6AE0 - 6AEF
	0x01F6, 0x038C, 0x05FB, 0x02E4, 0x029F, 0xFFFF, 0x0594, 0xFFFF, 0x0240, 0x059F, 0x02DB, 0x05EA, 0x0219, 0x05E6, 0x05F7, 0x05EA,   // 6AF0 - 6AFF
	0x0599, 0x039D, 0x004A, 0x0079, 0x02A3, 0x0240, 0x04E5, 0x04B3, 0x057A, 0x00D0, 0x0434, 0x0431, 0xFFFF, 0xFFFF, 0x05FB, 0x02F9,   // 6B00 - 6B0F
	0x02BC, 0x0612, 0x02F0, 0x00F8, 0x0248, 0xFFFF, 0x02A3, 0x02A3, 0x0666, 0x02B3, 0x02BC, 0x000F, 0x035D, 0x05FB, 0x02DB, 0xFFFF,   // 6B10 - 6B1F
	0x040A, 0x00CD, 0x01FB, 0x05A8, 0x05FB, 0x05FB, 0x040A, 0x03BB, 0x05BB, 0x0084, 0x00A7, 0x0403, 0x0253, 0x05DE, 0x0248, 0x058D,   // 6B20 - 6B2F
	0x05BB, 0x0590, 0x05FB, 0x0280, 0x02A7, 0x0285, 0x04F6, 0x058D, 0x0144, 0x05DE, 0x0403, 0x01EF, 0x0098, 0x041E, 0x0285, 0x0257,   // 6B30 - 6B3F
	0x0285, 0x0257, 0x00B1, 0x049A, 0xFFFF, 0x05E6, 0x05A8, 0x05A4, 0x05FB, 0x040A, 0x059F, 0x05DE, 0x0186, 0x058A, 0x0522, 0x022D,   // 6B40 - 6B4F
	0x03BB, 0x01EF, 0x0537, 0x01FB, 0x05BB, 0x03D6, 0x058D, 0x059F, 0x01EF, 0x04B3, 0xFFFF, 0x02C3, 0x00A7, 0x05DE, 0x0257, 0x05FB,   // 6B50 - 6B5F
	0x00C8, 0x01FB, 0x0657, 0x0651, 0x00CD, 0x004D, 0x058A, 0x0403, 0x004D, 0x004D, 0x056D, 0x0240, 0x040A, 0x0098, 0x048E, 0x0098,   // 6B60 - 6B6F
	0x048E, 0x065B, 0x050F, 0x050F, 0x02BC, 0x00E9, 0x05FB, 0x02BC, 0x01B6, 0x00F0, 0x00F0, 0x04FB, 0x0219, 0x0648, 0x0348, 0x0348,   // 6B70 - 6B7F
	0x05D7, 0x0348, 0x00D9, 0x05D2, 0x053A, 0x04C1, 0x00F0, 0x04A8, 0x05BB, 0x05C7, 0x04D0, 0x0057, 0x0248, 0x03E7, 0x0406, 0x042D,   // 6B80 - 6B8F
	0x0507, 0x0422, 0x0607, 0x02C3, 0x05DE, 0x016B, 0x0657, 0x05DB, 0x0057, 0x020A, 0x00F4, 0x0212, 0x05DB, 0xFFFF, 0x0607, 0x057E,   // 6B90 - 6B9F
	0x00A2, 0x0041, 0x0537, 0x022D, 0x04A8, 0x05E6, 0x0115, 0x00D9, 0x0206, 0x00DC, 0x05DE, 0x00F4, 0x0130, 0x021E, 0x02C3, 0x0041,   // 6BA0 - 6BAF
	0x0130, 0x0219, 0x0219, 0x04D0, 0x03BB, 0x0133, 0x0666, 0x05E6, 0x0422, 0x05DE, 0x049A, 0x0264, 0x0264, 0x05D7, 0x05C7, 0x0110,   // 6BB0 - 6BBF
	0x0206, 0x0206, 0x019F, 0x0439, 0x0212, 0x05DE, 0x03BB, 0x0206, 0x0133, 0x05DE, 0x059F, 0x058A, 0x01AB, 0x034F, 0x031D, 0x031D,   // 6BC0 - 6BCF
	0x0002, 0x06AD, 0x0130, 0x05FB, 0x0030, 0x0030, 0x0030, 0x03DF, 0x03DF, 0x0030, 0x0079, 0x0316, 0xFFFF, 0xFFFF, 0x03DF, 0xFFFF,   // 6BD0 - 6BDF
	0x0215, 0x0638, 0x047D, 0x034F, 0x0566, 0x05C7, 0x014C, 0x045D, 0x0594, 0x0240, 0x034F, 0x01D2, 0x042D, 0x012C, 0xFFFF, 0x0522,   // 6BE0 - 6BEF
	0x03D2, 0x0240, 0x0140, 0x00E1, 0x0030, 0x0481, 0xFFFF, 0x0316, 0x050F, 0x04D0, 0x05FB, 0x0566, 0x01D6, 0x0219, 0x051B, 0x0481,   // 6BF0 - 6BFF
	0x02FD, 0x034F, 0x02BC, 0x054D, 0x045D, 0x007E, 0x0400, 0x02ED, 0x0638, 0x048A, 0x0638, 0x0325, 0x02ED, 0x0431, 0x011A, 0x04C7,   // 6C00 - 6C0F
	0x0109, 0x033B, 0x0248, 0x0311, 0x0403, 0x03EC, 0x0355, 0x0403, 0x00FD, 0x0594, 0x00B1, 0x015F, 0x045A, 0x0369, 0xFFFF, 0x016F,   // 6C10 - 6C1F
	0x04BC, 0x0127, 0x0422, 0x0403, 0x05E6, 0x058D, 0x01C5, 0x05D2, 0x0005, 0x05CB, 0x0264, 0x0422, 0x05CB, 0x0127, 0x00F4, 0x02FD,   // 6C20 - 6C2F
	0x0422, 0x05D2, 0x0607, 0x0607, 0x04EC, 0x04EC, 0x0651, 0x0045, 0x05F2, 0x00F8, 0x04EC, 0x02B0, 0x0379, 0x0562, 0x0152, 0x01B6,   // 6C30 - 6C3F
	0x0548, 0x0657, 0x042D, 0x0041, 0x061F, 0x032D, 0x00DC, 0x0206, 0x0115, 0x01C9, 0x0070, 0x068C, 0x00B1, 0x0571, 0x0152, 0x00F0,   // 6C40 - 6C4F
	0x058D, 0x0566, 0x0311, 0x042D, 0x0403, 0x04A3, 0x03C1, 0x01C9, 0x040A, 0x058A, 0x058A, 0x05C7, 0x04FB, 0x0466, 0x0196, 0x021E,   // 6C50 - 6C5F
	0x0098, 0x058A, 0xFFFF, 0xFFFF, 0x0526, 0x0657, 0x0098, 0x040A, 0x032A, 0x019F, 0x0575, 0x0422, 0x0231, 0x046E, 0x024C, 0x01E6,   // 6C60 - 6C6F
	0x051E, 0x0434, 0x0212, 0x0033, 0x0033, 0x0179, 0x057E, 0x065B, 0x0156, 0x05B1, 0x0248, 0x01EF, 0xFFFF, 0x0403, 0x015F, 0x05BB,   // 6C70 - 6C7F
	0x05BB, 0x041E, 0x05DE, 0x0587, 0x0607, 0x05FE, 0x01CD, 0x05CE, 0x04BC, 0x008D, 0x00F4, 0x05F7, 0x013C, 0x01EF, 0x020E, 0x0403,   // 6C80 - 6C8F
	0x034F, 0x0462, 0x031D, 0x051B, 0x032D, 0x058A, 0x009C, 0x053A, 0x0030, 0x049A, 0x0657, 0x03D2, 0x03C5, 0x0682, 0x060B, 0x019B,   // 6C90 - 6C9F
	0x02E0, 0x031D, 0x061F, 0x0163, 0x03BB, 0x02BC, 0x02F5, 0x005B, 0x0163, 0x057A, 0x01EF, 0x0348, 0x031D, 0x04D0, 0x0240, 0x0612,   // 6CA0 - 6CAF
	0x0566, 0x0566, 0x0140, 0x01D6, 0x02BC, 0x032A, 0x05DE, 0x016F, 0x015B, 0x05F7, 0x053A, 0x0657, 0x0643, 0x019F, 0x0638, 0x05CE,   // 6CB0 - 6CBF
	0x04FB, 0x028A, 0x0236, 0x0240, 0x05A4, 0x042D, 0x05DE, 0x0215, 0x065B, 0x0434, 0x004A, 0x0206, 0x032A, 0x0027, 0x068C, 0x00A7,   // 6CC0 - 6CCF
	0x02B0, 0x05F7, 0x019F, 0x01E6, 0x0179, 0x014F, 0x0316, 0x04FB, 0x01EF, 0x03F4, 0x00CD, 0x0152, 0x0657, 0x0507, 0x0394, 0x0092,   // 6CD0 - 6CDF
	0x02DB, 0x03CE, 0x004A, 0x0403, 0x04FB, 0x0379, 0x0240, 0x0603, 0x0666, 0x04C1, 0x02B3, 0x05BE, 0x05C3, 0x016F, 0x03C5, 0x033B,   // 6CE0 - 6CEF
	0x051E, 0x05D2, 0x0212, 0x05F2, 0x01AB, 0x002B, 0x05C3, 0x02E4, 0x02ED, 0x00F4, 0x02F9, 0x05A4, 0x03F9, 0x061F, 0x0231, 0x05E6,   // 6CF0 - 6CFF
	0x0661, 0x0229, 0x05DE, 0x0206, 0x0206, 0x06A5, 0x0092, 0x05E6, 0x057A, 0x01EB, 0x0219, 0x05D2, 0x02D3, 0x04FB, 0x0212, 0x014C,   // 6D00 - 6D0F
	0x05AC, 0x016F, 0x047A, 0x0691, 0x0657, 0x05E6, 0x058A, 0x058D, 0x0260, 0x0666, 0x021E, 0x02F9, 0xFFFF, 0x0005, 0x0127, 0x05DE,   // 6D10 - 6D1F
	0x034B, 0x02B3, 0x05DE, 0x032A, 0x0434, 0x022D, 0x03F9, 0x057A, 0x059F, 0x05A4, 0x01E6, 0x05BB, 0x0507, 0x028A, 0x052B, 0x041A,   // 6D20 - 6D2F
	0x0240, 0x014C, 0x0661, 0x0466, 0x03F4, 0x05C7, 0x05B1, 0x0657, 0x01B0, 0x01FB, 0x033F, 0x020E, 0x056A, 0x0406, 0x03C1, 0x058A,   // 6D30 - 6D3F
	0x0431, 0x02E0, 0x05DE, 0x0215, 0x0231, 0x040A, 0x021E, 0x0224, 0x064C, 0x04C7, 0x068C, 0x0064, 0xFFFF, 0x0206, 0x0212, 0x02E0,   // 6D40 - 6D4F
	0x0079, 0x020A, 0x01EF, 0x039D, 0x05C7, 0x022D, 0x02D3, 0x042D, 0x057A, 0x0648, 0x024C, 0x01C9, 0x001A, 0x0311, 0x068C, 0x05F7,   // 6D50 - 6D5F
	0x058D, 0x004A, 0x012C, 0x01FB, 0x01E6, 0x05DE, 0x0400, 0x05EA, 0x02A3, 0x01D2, 0x02A7, 0x01C9, 0x02BC, 0x0191, 0x016F, 0x058A,   // 6D60 - 6D6F
	0x02BC, 0x00C3, 0x0163, 0x05DE, 0x05FB, 0x054D, 0x02AC, 0x01C5, 0x022D, 0x0215, 0x009C, 0x0582, 0x031D, 0x050F, 0x0092, 0x03D2,   // 6D70 - 6D7F
	0x0594, 0x04BC, 0x0556, 0x0294, 0x03F0, 0x038C, 0x01C9, 0x0231, 0x059F, 0x04B3, 0x037C, 0x0556, 0x05F2, 0x059F, 0x0594, 0x0548,   // 6D80 - 6D8F
	0x0144, 0x0507, 0x0562, 0x0243, 0x0067, 0x0537, 0x02BC, 0x04EC, 0x04FB, 0x02B3, 0x04EC, 0x052B, 0x0130, 0x02AC, 0x029F, 0x02C3,   // 6D90 - 6D9F
	0x057A, 0x0587, 0x0607, 0x01FB, 0x0109, 0xFFFF, 0x0472, 0x0219, 0x063D, 0x048E, 0x016F, 0x01AB, 0x05AC, 0x04CB, 0x04DF, 0x05CB,   // 6DA0 - 6DAF
	0x00C8, 0x063D, 0x05DB, 0x0270, 0x0571, 0x01C9, 0x0566, 0x0127, 0x01D6, 0x0587, 0x0240, 0x0179, 0x02C8, 0x020A, 0x051B, 0x068C,   // 6DB0 - 6DBF
	0x0110, 0x041A, 0x0101, 0x0243, 0x0691, 0x058D, 0x059F, 0x0403, 0x019F, 0x01BE, 0x01C9, 0x02D7, 0x0526, 0x0661, 0x03DA, 0x01D2,   // 6DC0 - 6DCF
	0x007E, 0x04D0, 0x0403, 0x0156, 0x0098, 0x02ED, 0x0362, 0x0240, 0x052B, 0x00D0, 0x02B3, 0x0657, 0x03DA, 0x015B, 0x04FE, 0x053A,   // 6DD0 - 6DDF
	0x03DF, 0x00F4, 0x05FB, 0x0379, 0x05FB, 0x02ED, 0x0179, 0x032A, 0x0231, 0x02DB, 0x02F5, 0x05E6, 0x00E1, 0x0431, 0x01F6, 0x05FB,   // 6DE0 - 6DEF
	0x037C, 0x04BC, 0x03E7, 0x00C3, 0x01EF, 0x05FE, 0x029F, 0x020A, 0x0422, 0x05CE, 0x040A, 0x053A, 0x0332, 0x0657, 0x05E6, 0x032A,   // 6DF0 - 6DFF
	0x0027, 0x05FE, 0x057E, 0x044E, 0x015B, 0x0422, 0x05FE, 0x0264, 0x0212, 0x04B3, 0x05FE, 0x048E, 0x02ED, 0x0691, 0x0130, 0xFFFF,   // 6E00 - 6E0F
	0x0219, 0x032D, 0x03DF, 0x058D, 0x05FB, 0x05FE, 0x04BC, 0x04BC, 0x0462, 0x01FB, 0x0666, 0x0219, 0x03A9, 0x05FB, 0x042D, 0x0548,   // 6E10 - 6E1F
	0x0431, 0x0130, 0x0163, 0x062F, 0x004A, 0x0587, 0x0587, 0x0109, 0x057A, 0x057E, 0x0466, 0x05A4, 0x0064, 0x057A, 0x0186, 0x017D,   // 6E20 - 6E2F
	0x05CE, 0x01E6, 0x05BE, 0x032A, 0x0264, 0x0316, 0x05EA, 0x05CE, 0x05F7, 0x01E6, 0x0332, 0x05AC, 0x031D, 0x060E, 0x020A, 0x0355,   // 6E30 - 6E3F
	0x0290, 0x04C7, 0x0144, 0x03C1, 0x031D, 0x02C3, 0x0403, 0x0403, 0x031D, 0x053A, 0x00D5, 0x057A, 0x0057, 0x0559, 0x032D, 0x05BB,   // 6E40 - 6E4F
	0x0348, 0x05BB, 0x0212, 0x03D6, 0x0219, 0x0219, 0x01EF, 0x0163, 0x0599, 0x05DE, 0x05E6, 0x0638, 0x04C7, 0x0229, 0x064C, 0x0200,   // 6E50 - 6E5F
	0x0522, 0x05FB, 0x0030, 0x033B, 0x04C7, 0x0556, 0x04C1, 0x05F2, 0x0240, 0x065B, 0xFFFF, 0x042D, 0x0224, 0xFFFF, 0x05E6, 0x0526,   // 6E60 - 6E6F
	0x02E4, 0x020E, 0x05FE, 0x0359, 0x0016, 0x05F7, 0x0434, 0x00BE, 0x02C8, 0x0079, 0x05CE, 0x00C3, 0x038C, 0x0691, 0x0571, 0x04C7,   // 6E70 - 6E7F
	0x030D, 0x05EA, 0x029C, 0x0290, 0xFFFF, 0x0219, 0x05BB, 0x02E9, 0x01B6, 0x0175, 0xFFFF, 0xFFFF, 0x03F9, 0x022D, 0x01B6, 0x0526,   // 6E80 - 6E8F
	0x05FE, 0x0517, 0x05FE, 0x02C3, 0x05D7, 0x0325, 0x0687, 0x04C1, 0x0264, 0x051E, 0x051B, 0x056A, 0x02E0, 0x019B, 0x048A, 0x033F,   // 6E90 - 6E9F
	0x062F, 0x04C7, 0x05DE, 0x02F5, 0x0306, 0x0400, 0x057A, 0x02BC, 0x0053, 0x058A, 0x058D, 0x057E, 0x040F, 0x0064, 0x04C7, 0x0507,   // 6EA0 - 6EAF
	0x05DE, 0x064C, 0x0503, 0x0607, 0x05B7, 0x05E6, 0x045D, 0x020A, 0x0507, 0x0507, 0x0379, 0x051B, 0x04C7, 0x0466, 0x057A, 0x03C5,   // 6EB0 - 6EBF
	0x00A7, 0x00A7, 0x03C9, 0x0582, 0x005B, 0x0337, 0x01D6, 0x0110, 0x01D2, 0x0200, 0x058D, 0x0691, 0x0109, 0x0657, 0x05EA, 0x016F,   // 6EC0 - 6ECF
	0x0229, 0x01F2, 0x0186, 0x0691, 0x052B, 0x0532, 0x050F, 0x0030, 0x0224, 0x0206, 0x01BA, 0x05E6, 0x0182, 0x02E4, 0x0657, 0x05CE,   // 6ED0 - 6EDF
	0x04B3, 0x030D, 0x05EA, 0x00C3, 0x02FD, 0x02A3, 0x02F0, 0x059F, 0x0041, 0x0522, 0x05FB, 0x05B7, 0x01EF, 0x0030, 0x0038, 0x0657,   // 6EE0 - 6EEF
	0x021E, 0x0275, 0x04BC, 0x04A8, 0x0109, 0x032A, 0x000C, 0x02ED, 0x01EF, 0x01EF, 0x05F7, 0x0079, 0x0152, 0x05F2, 0x01BA, 0x030D,   // 6EF0 - 6EFF
	0x0422, 0x05FB, 0x03E7, 0x0212, 0x05CB, 0x0224, 0x0403, 0x058D, 0x0212, 0x02ED, 0x02FD, 0x02E4, 0x022D, 0x01BE, 0x00D0, 0x02E9,   // 6F00 - 6F0F
	0x0657, 0x0175, 0x040F, 0x02BC, 0x05CE, 0x0060, 0x0224, 0x00D0, 0x00C3, 0x0559, 0x03BB, 0x0532, 0x05DB, 0x058D, 0x032A, 0x0526,   // 6F10 - 6F1F
	0x0348, 0x04A8, 0x01C9, 0x02C3, 0x02A3, 0x056A, 0x02BC, 0x040A, 0x0163, 0x05BE, 0x05DE, 0x030D, 0x0691, 0x0311, 0x025B, 0x02F9,   // 6F20 - 6F2F
	0x03DA, 0x04D0, 0x063D, 0x063D, 0x009C, 0x05BB, 0x01FB, 0x0298, 0x0219, 0x05CE, 0x00B7, 0x02CE, 0x00E1, 0x0537, 0x05D2, 0x021E,   // 6F30 - 6F3F
	0x00D0, 0x05EA, 0x01E6, 0x05B7, 0x04D0, 0x01AB, 0x05EA, 0x059F, 0xFFFF, 0xFFFF, 0x05BB, 0x02C3, 0x0657, 0x057A, 0x03DF, 0x05FB,   // 6F40 - 6F4F
	0x0224, 0x03F9, 0x0599, 0x0206, 0x0229, 0x058A, 0x03BE, 0x0212, 0x03C5, 0x057A, 0x059F, 0x040A, 0x040A, 0x058D, 0x02ED, 0x058D,   // 6F50 - 6F5F
	0x0513, 0x013C, 0x0200, 0x033B, 0x0472, 0x0507, 0x02CE, 0x064C, 0x065B, 0x05DE, 0x0109, 0x0571, 0x00F4, 0x0522, 0x0084, 0x05C7,   // 6F60 - 6F6F
	0x0290, 0xFFFF, 0x04AE, 0x0556, 0x0666, 0x047A, 0x01D9, 0x0030, 0x04A3, 0x0079, 0x0079, 0x04D0, 0x054D, 0x0400, 0x02D7, 0x057A,   // 6F70 - 6F7F
	0x048E, 0x048E, 0x0092, 0x0236, 0x0092, 0x01F2, 0x0224, 0x02AC, 0x0089, 0x0179, 0x00E5, 0x01E1, 0x04FB, 0x04D0, 0x03DA, 0x01C9,   // 6F80 - 6F8F
	0x0607, 0x02E0, 0x01E6, 0x016F, 0x01D2, 0x01D6, 0x0594, 0x0219, 0x04A3, 0x058D, 0x000C, 0x02ED, 0x02A3, 0xFFFF, 0x05FB, 0x02D7,   // 6F90 - 6F9F
	0x033B, 0x061B, 0x00F8, 0x01FB, 0x061F, 0x05A4, 0x05FB, 0x02BC, 0x04C7, 0x05C3, 0x02DB, 0x030D, 0x0691, 0x05F2, 0x0280, 0x0057,   // 6FA0 - 6FAF
	0x02C3, 0x0110, 0x05DB, 0x000C, 0x01FB, 0x02C3, 0x0079, 0x030D, 0x00F4, 0x00F4, 0x05DE, 0x050F, 0x03DF, 0x0240, 0x051B, 0x041E,   // 6FB0 - 6FBF
	0x0212, 0x068C, 0x02C3, 0x039D, 0x01BE, 0x022D, 0x015F, 0x048E, 0x0212, 0x050F, 0x0206, 0x00A7, 0x051B, 0x04FE, 0x011E, 0x048E,   // 6FC0 - 6FCF
	0x0666, 0x029F, 0x0041, 0x02C3, 0x032A, 0x04C7, 0x04D0, 0x032A, 0x0394, 0x05EA, 0x05EA, 0x0325, 0x022D, 0x0403, 0x0030, 0x0212,   // 6FD0 - 6FDF
	0x01D2, 0x0466, 0x06A5, 0x0587, 0x052B, 0x05E6, 0x05E6, 0x0138, 0x00CD, 0x020E, 0x0231, 0x02A3, 0x024C, 0x0002, 0x0400, 0x068C,   // 6FE0 - 6FEF
	0x057A, 0x0041, 0x019F, 0x040A, 0x05AC, 0x0041, 0x0298, 0x015B, 0xFFFF, 0x0041, 0x0219, 0x0138, 0x02F9, 0x02F9, 0x02FD, 0x02BC,   // 6FF0 - 6FFF
	0x05F7, 0x05D2, 0x02ED, 0x04FB, 0x0229, 0x05EA, 0x0130, 0x0575, 0x0206, 0x05A4, 0x03C5, 0x04BC, 0x0038, 0x0079, 0x0337, 0x02E0,   // 7000 - 700F
	0x0219, 0x0400, 0x048E, 0x0092, 0x019F, 0x0041, 0x020E, 0x0594, 0x02ED, 0x041E, 0x01C9, 0x05EA, 0x045D, 0x02BC, 0x0231, 0x059F,   // 7010 - 701F
	0x05EA, 0x050F, 0x057A, 0x05A4, 0x01F6, 0x01D2, 0x0666, 0x02E4, 0x029F, 0x0138, 0x0152, 0x01EF, 0x029F, 0xFFFF, 0xFFFF, 0x05EA,   // 7020 - 702F
	0x032A, 0x0212, 0x02C3, 0x0219, 0x05EA, 0x015F, 0x02D7, 0x05DE, 0x0219, 0x0603, 0x0079, 0x00F0, 0x0445, 0x0219, 0x02A3, 0x0152,   // 7030 - 703F
	0x04E5, 0x05FE, 0x068C, 0x0163, 0x04B3, 0x02B3, 0x02A3, 0x00D0, 0x0431, 0x05F2, 0x040A, 0x014F, 0x01AB, 0x0439, 0x05CE, 0x01D2,   // 7040 - 704F
	0xFFFF, 0x047A, 0x0612, 0x02F0, 0x05CE, 0x02BC, 0x032A, 0x00F4, 0x0522, 0x00F8, 0x0224, 0x0079, 0xFFFF, 0x01D2, 0x000F, 0x0666,   // 7050 - 705F
	0x02A3, 0x02A3, 0x035D, 0x0571, 0x02F0, 0x0434, 0x0594, 0x05CE, 0x0179, 0x05CE, 0x05FB, 0x020E, 0x0038, 0x0337, 0x01B0, 0x0104,   // 7060 - 706F
	0x0206, 0x059F, 0x059F, 0xFFFF, 0x01E6, 0x02DB, 0x061B, 0x0675, 0x023C, 0x062F, 0x05A4, 0x0098, 0x068C, 0x060E, 0x060E, 0x0057,   // 7070 - 707F
	0x05D2, 0x0403, 0x065B, 0x015F, 0x0399, 0x01B6, 0x057E, 0x03F9, 0x05DE, 0x02ED, 0x00BE, 0x03DF, 0x0253, 0x03C5, 0x05CE, 0x0253,   // 7080 - 708F
	0x03C9, 0x034F, 0x0084, 0x02CE, 0x01B6, 0x025B, 0x013C, 0x01B0, 0x05A8, 0x0657, 0x01B0, 0x05A8, 0x057A, 0x040F, 0x0033, 0x00ED,   // 7090 - 709F
	0x0590, 0x0651, 0x0666, 0x0264, 0x0643, 0x016F, 0x000F, 0x0140, 0x0140, 0x02DB, 0x068C, 0x05BE, 0x0240, 0x0522, 0x03CE, 0x0236,   // 70A0 - 70AF
	0x03CE, 0x051E, 0x051E, 0x0045, 0x05D2, 0x054D, 0x01C9, 0x0666, 0x062F, 0x0110, 0x057A, 0x04C7, 0x02C3, 0x0098, 0x03F4, 0xFFFF,   // 70B0 - 70BF
	0x01EF, 0x04F6, 0x02A3, 0x0548, 0x0224, 0x05BB, 0x05AC, 0x0434, 0x02D3, 0x01FB, 0x05D2, 0x059F, 0x05B7, 0x0594, 0x05E6, 0x058A,   // 70C0 - 70CF
	0x0661, 0x05D7, 0x04C7, 0x057A, 0x054D, 0x054D, 0x060E, 0x0253, 0x01E6, 0x02F9, 0x0590, 0x0666, 0x05BE, 0x0651, 0x03F9, 0x05CE,   // 70D0 - 70DF
	0x0206, 0x01B0, 0x0648, 0x0206, 0x0260, 0xFFFF, 0x0152, 0x04AE, 0x05DB, 0x0206, 0xFFFF, 0x0526, 0x022D, 0x044E, 0xFFFF, 0x058D,   // 70E0 - 70EF
	0x016F, 0x0236, 0x0089, 0x0400, 0x0231, 0x068C, 0x0548, 0x0571, 0x01C5, 0x03DA, 0x02A7, 0x04A3, 0x01EF, 0x0163, 0x0098, 0x045D,   // 70F0 - 70FF
	0x01EF, 0xFFFF, 0x04D0, 0x02A7, 0x05C7, 0x05C7, 0x0248, 0x059F, 0x058D, 0x05CE, 0x01C9, 0x067B, 0x0431, 0x0109, 0x05A4, 0x0403,   // 7100 - 710F
	0x058A, 0xFFFF, 0xFFFF, 0x01C9, 0x05CE, 0x01FB, 0x0321, 0x0240, 0x00FD, 0x0023, 0x015F, 0x02D7, 0x0294, 0x020A, 0x00C3, 0x058D,   // 7110 - 711F
	0x00E1, 0x058A, 0x01E6, 0x0240, 0x016F, 0x0603, 0x0224, 0x00D0, 0x0163, 0x03F4, 0x0427, 0x00E1, 0x058D, 0x0427, 0x05A8, 0x068C,   // 7120 - 712F
	0x05CE, 0x05CE, 0x05DE, 0x0248, 0x05FB, 0x017D, 0x0441, 0x03DF, 0x05CE, 0xFFFF, 0x04C1, 0x007E, 0x04AE, 0xFFFF, 0xFFFF, 0xFFFF,   // 7130 - 713F
	0xFFFF, 0x008D, 0x01D6, 0x0290, 0x065B, 0x0133, 0x05CB, 0x0206, 0x0163, 0x02C3, 0x05BE, 0x05AC, 0x0200, 0x0224, 0x0219, 0x0030,   // 7140 - 714F
	0x05EA, 0x0666, 0x057A, 0x0559, 0x053A, 0x058D, 0x03A9, 0x03A9, 0x0079, 0x05CE, 0x0236, 0x0236, 0x05FB, 0x031D, 0x049A, 0x058A,   // 7150 - 715F
	0x05DB, 0x05A8, 0x0427, 0x0462, 0x031D, 0x01FB, 0x05BB, 0x0643, 0x057A, 0x0152, 0x042D, 0x050F, 0x05D2, 0x02D3, 0x0666, 0xFFFF,   // 7160 - 716F
	0x0182, 0x01A2, 0x001F, 0x01EF, 0x0607, 0x0590, 0xFFFF, 0xFFFF, 0x0033, 0x057A, 0x055E, 0x0526, 0x0084, 0x04A3, 0x0607, 0x004A,   // 7170 - 717F
	0x0200, 0x05A4, 0x058D, 0x058A, 0x058D, 0x0607, 0x01D6, 0x01D6, 0x058D, 0x0607, 0x05B1, 0x0355, 0x0260, 0xFFFF, 0x05D7, 0x05C7,   // 7180 - 718F
	0x033F, 0x02C3, 0x05EA, 0x057E, 0x045D, 0xFFFF, 0xFFFF, 0x040F, 0x02E0, 0x058D, 0x0030, 0x0038, 0x00D0, 0x02ED, 0x0219, 0x04D0,   // 7190 - 719F
	0x05DE, 0x02E9, 0x0163, 0x050F, 0x05DE, 0x0532, 0x0248, 0x0694, 0x0607, 0x01EF, 0x05DE, 0x0657, 0x000C, 0x057A, 0x02CE, 0x01C9,   // 71A0 - 71AF
	0x03BB, 0x044E, 0x0236, 0x030D, 0xFFFF, 0x04A8, 0x00DC, 0x062A, 0x0219, 0x058D, 0x058D, 0x058D, 0x05DE, 0x059F, 0x0098, 0x0200,   // 71B0 - 71BF
	0x0079, 0x05DB, 0x040A, 0x0441, 0x05CE, 0x0594, 0x0415, 0x06A9, 0x0104, 0x013C, 0x04BC, 0x0224, 0x015F, 0x04FB, 0x02CE, 0x05FB,   // 71C0 - 71CF
	0x02D7, 0x054D, 0x04AE, 0x015F, 0x0152, 0x05CE, 0x05C7, 0x02A3, 0x031D, 0x0526, 0x05DE, 0x0231, 0x0321, 0xFFFF, 0xFFFF, 0x05EA,   // 71D0 - 71DF
	0x05FB, 0x05DE, 0x05C3, 0x02A3, 0x051E, 0x061B, 0x0057, 0x050F, 0x058D, 0x0439, 0x00D0, 0x02C3, 0x0206, 0x0666, 0x05A4, 0x02DB,   // 71E0 - 71EF
	0x057A, 0x05DE, 0x05A4, 0x0643, 0x0206, 0xFFFF, 0xFFFF, 0x02A3, 0x0466, 0x0594, 0x0260, 0x05C7, 0x022D, 0x00A2, 0x00FD, 0x05D7,   // 71F0 - 71FF
	0x01D6, 0x02A3, 0x0038, 0x045D, 0x02BC, 0x0348, 0x001F, 0x0476, 0x0109, 0x02FD, 0x000C, 0x05C7, 0x028A, 0x04F6, 0xFFFF, 0x02BC,   // 7200 - 720F
	0x02ED, 0x0248, 0x02CE, 0x05CE, 0x058D, 0x05A4, 0x02E4, 0x05CE, 0xFFFF, 0x0445, 0x0603, 0x02A3, 0x00D0, 0x0248, 0x054D, 0x01AB,   // 7210 - 721F
	0xFFFF, 0x0089, 0x032A, 0x0526, 0x02A3, 0x0666, 0x02A3, 0x02DB, 0x00DC, 0x05FB, 0x066A, 0x02A3, 0x03BE, 0x0651, 0x03CE, 0x0643,   // 7220 - 722F
	0x05FE, 0x0002, 0x057A, 0xFFFF, 0x0248, 0x0248, 0x016F, 0x05DB, 0x000F, 0x011A, 0x05DB, 0x05D7, 0x069D, 0x04E5, 0x014C, 0x03C5,   // 7230 - 723F
	0x00B1, 0x0264, 0x0616, 0x0616, 0x040F, 0x011A, 0x040F, 0x03E2, 0x0016, 0x03C5, 0x04AE, 0x0219, 0x03C1, 0x0130, 0x05F2, 0x0552,   // 7240 - 724F
	0x0552, 0x0033, 0x011A, 0x001A, 0x004A, 0x001A, 0x05F7, 0xFFFF, 0x0130, 0x05CB, 0x0092, 0x0399, 0x0092, 0x03F0, 0x023C, 0x034B,   // 7250 - 725F
	0x051B, 0x034F, 0x02AC, 0x0451, 0x0311, 0x0156, 0x0316, 0x034F, 0x0451, 0x058A, 0x05CE, 0x014F, 0x0023, 0x04FB, 0x0219, 0x019F,   // 7260 - 726F
	0x05F7, 0x019F, 0x04C1, 0x034F, 0x0109, 0x040A, 0x0434, 0x0434, 0x0691, 0x052F, 0x058D, 0x0311, 0x026B, 0x040A, 0x058A, 0x019F,   // 7270 - 727F
	0x058D, 0x02BC, 0x02BC, 0x03FC, 0x0212, 0x017D, 0x0657, 0x0027, 0x0434, 0x0472, 0x0130, 0x0240, 0x0215, 0x0219, 0x0163, 0x03E2,   // 7280 - 728F
	0x0264, 0x0240, 0x0260, 0x00A7, 0x058D, 0x0023, 0x02F9, 0x0229, 0x0306, 0x0481, 0x057A, 0x02BC, 0x013C, 0x054D, 0x048E, 0x021E,   // 7290 - 729F
	0x058D, 0x02BC, 0x0130, 0x02D3, 0x03DF, 0x03E7, 0x001F, 0x058D, 0x00A2, 0x057A, 0x0290, 0x00A2, 0x0434, 0x0434, 0x000F, 0x0152,   // 72A0 - 72AF
	0x042D, 0x004A, 0x0074, 0x00C8, 0x0005, 0x0229, 0x067B, 0x01B0, 0x0306, 0x05F7, 0x025B, 0x004A, 0x01EB, 0x05CB, 0x01C9, 0x01FB,   // 72B0 - 72BF
	0x067B, 0x0607, 0x028A, 0x0399, 0x0109, 0x0422, 0x065B, 0x0607, 0x0023, 0x03DF, 0x0240, 0x0379, 0x04C1, 0x03CE, 0x0590, 0x0566,   // 72C0 - 72CF
	0x01EF, 0x02DB, 0x015B, 0x03DF, 0x0379, 0x04C1, 0x05F7, 0x019B, 0x0603, 0x0240, 0x00F4, 0x004A, 0x019F, 0x0594, 0x0394, 0x01FB,   // 72D0 - 72DF
	0x01DD, 0x0224, 0x01D6, 0x0643, 0x0212, 0x01FB, 0x04A3, 0x051B, 0x045D, 0x04CB, 0x054D, 0x02AC, 0x0130, 0x0590, 0x04C7, 0x0280,   // 72E0 - 72EF
	0x0651, 0x05FB, 0x0513, 0x05FB, 0x0030, 0x0311, 0x058D, 0x0243, 0x02BC, 0x0590, 0x05E6, 0x050A, 0x02A7, 0x0023, 0x0657, 0x05CE,   // 72F0 - 72FF
	0x049A, 0x02BC, 0x0657, 0x0594, 0x0231, 0x01C9, 0x015B, 0x05D7, 0x000F, 0x0403, 0x0379, 0x0038, 0x05E6, 0x02BC, 0x02D3, 0x0219,   // 7300 - 730F
	0x040F, 0x0294, 0x05CE, 0x01BE, 0x0694, 0x032A, 0x007E, 0x05DE, 0x0657, 0x0651, 0x05CB, 0x0325, 0x0053, 0x00D9, 0x04B3, 0x02D3,   // 7310 - 731F
	0xFFFF, 0x02F9, 0x01EF, 0x0694, 0x01EF, 0x057A, 0x0163, 0x0587, 0x05FE, 0x05AC, 0x0666, 0x0316, 0x057A, 0x05FE, 0x0594, 0x0559,   // 7320 - 732F
	0x05CB, 0x0362, 0x05A4, 0x0215, 0x01EB, 0x0033, 0x05F7, 0x05F7, 0x031D, 0x0070, 0x05D7, 0x0513, 0x004A, 0x033F, 0x01F2, 0x05FE,   // 7330 - 733F
	0x0503, 0x0306, 0x05FE, 0x00F0, 0x05FB, 0x04C7, 0x01D2, 0xFFFF, 0x05DE, 0x064C, 0x00B7, 0x01D2, 0x030D, 0x0231, 0x021E, 0x0348,   // 7340 - 734F
	0x063D, 0x0079, 0x000C, 0x000C, 0x01D2, 0x00E1, 0x0027, 0x0248, 0x0030, 0x0030, 0x0200, 0x004D, 0x02D7, 0x05FB, 0x054D, 0x05D7,   // 7350 - 735F
	0x02CE, 0x04F6, 0x059F, 0x04CB, 0xFFFF, 0x058D, 0x0186, 0x0243, 0x0130, 0x0206, 0x0280, 0x0594, 0x05A4, 0x051B, 0x0594, 0x05C7,   // 7360 - 736F
	0x0394, 0x0033, 0x020E, 0x03A2, 0x0325, 0x02D3, 0x0362, 0x01B0, 0x04CB, 0x02ED, 0x051B, 0x0594, 0x032A, 0x0445, 0x01FB, 0x0362,   // 7370 - 737F
	0x02F9, 0x0594, 0x0403, 0x0431, 0x05BE, 0x0332, 0x0691, 0x02FD, 0x02ED, 0x05FB, 0x0507, 0x0575, 0x042D, 0x0172, 0x011E, 0x02B0,   // 7380 - 738F
	0x000F, 0x0212, 0x01E6, 0x0109, 0x00B1, 0x0179, 0x023C, 0x05FB, 0x0403, 0x05FB, 0x05D2, 0x0306, 0x01E6, 0x058A, 0x016F, 0x057E,   // 7390 - 739F
	0x0229, 0x05CB, 0x0041, 0x0033, 0x002B, 0x0603, 0x0248, 0x0607, 0x0248, 0x0571, 0x0219, 0x031D, 0x00F4, 0x03DF, 0x057A, 0x01FB,   // 73A0 - 73AF
	0x0594, 0x040F, 0x02DB, 0x00F0, 0x05DE, 0x0005, 0x03F4, 0x0110, 0x016F, 0x05BE, 0x058D, 0x004A, 0x00CD, 0x019B, 0x0215, 0x04AE,   // 73B0 - 73BF
	0x03F9, 0x00CD, 0x0264, 0x0441, 0x04C1, 0x04BC, 0x05DE, 0x069D, 0x0215, 0x033B, 0x04A3, 0x02E0, 0x0030, 0x064C, 0x064C, 0x0248,   // 73C0 - 73CF
	0x014F, 0x02E4, 0x022D, 0x0224, 0x0219, 0x02BC, 0x01B0, 0x0594, 0x0661, 0x0196, 0x05CE, 0x05B7, 0x05D2, 0x05BB, 0x02F9, 0x0507,   // 73D0 - 73DF
	0x0666, 0x041E, 0x0267, 0x05C7, 0x001F, 0x014C, 0x0599, 0x05D7, 0x0590, 0x01E1, 0x01B6, 0x009C, 0x05BB, 0x0016, 0x03D2, 0xFFFF,   // 73E0 - 73EF
	0x00F8, 0x05EA, 0x020A, 0x057E, 0x0144, 0x0092, 0x0537, 0x058A, 0x058A, 0x0092, 0x024C, 0x031D, 0x0023, 0x0548, 0x0594, 0x00C8,   // 73F0 - 73FF
	0x01C9, 0x05BE, 0x05CE, 0x042D, 0x0434, 0x02A7, 0x02BC, 0x05B7, 0x016F, 0x02E0, 0x05DB, 0x058D, 0x02DB, 0x02BC, 0x022D, 0x02C3,   // 7400 - 740F
	0x0517, 0x0517, 0xFFFF, 0x0571, 0x0110, 0x0045, 0x0638, 0x00E1, 0x033B, 0x05FB, 0x0240, 0x008D, 0x029F, 0x057E, 0x04C1, 0x057A,   // 7410 - 741F
	0x0110, 0x00A7, 0x068C, 0x03D2, 0x0092, 0x01EF, 0x0403, 0x0144, 0x0294, 0x007E, 0x0403, 0x002B, 0x0571, 0x02ED, 0x00D0, 0x01AB,   // 7420 - 742F
	0x05CE, 0x0115, 0x0023, 0x02D7, 0x041E, 0x03DF, 0x03BE, 0x040F, 0x068C, 0x041E, 0x014F, 0xFFFF, 0x0427, 0x0130, 0x0229, 0x020A,   // 7430 - 743F
	0x05FB, 0x0316, 0x031D, 0x00C3, 0x05BE, 0x0537, 0x05AC, 0x00F0, 0x0462, 0x033B, 0x064C, 0x057A, 0x0469, 0x01FB, 0x05A4, 0x00B1,   // 7440 - 744F
	0x0219, 0x0675, 0x05D2, 0x02C3, 0x0434, 0x0590, 0x0133, 0x05FE, 0x05DB, 0x0362, 0x01EF, 0x05EA, 0x05FB, 0x0200, 0x046E, 0x048E,   // 7450 - 745F
	0x02E0, 0xFFFF, 0x045D, 0x0517, 0x05D7, 0x057E, 0x058A, 0x022D, 0x022D, 0x05EA, 0x0306, 0x052B, 0x02E0, 0x0526, 0x02BC, 0x02A7,   // 7460 - 746F
	0x01B6, 0x053A, 0x040F, 0x00E9, 0x0248, 0x0643, 0x05D7, 0x0002, 0x0041, 0x0556, 0x007E, 0x0294, 0x0675, 0x00D0, 0x022D, 0x05DE,   // 7470 - 747F
	0x00E1, 0x00D0, 0x0403, 0x02BC, 0x05EA, 0x0517, 0x042D, 0x05BE, 0x000C, 0x02C3, 0x030D, 0x063D, 0x05E6, 0xFFFF, 0x05EA, 0x057A,   // 7480 - 748F
	0x02ED, 0x058A, 0x0104, 0xFFFF, 0x062A, 0x05C7, 0x0431, 0x00F8, 0x02D7, 0x02CE, 0x0427, 0x0507, 0x0200, 0x01B6, 0x0400, 0x0231,   // 7490 - 749F
	0x0152, 0x022D, 0x02E0, 0x0212, 0xFFFF, 0x0231, 0x0002, 0x0030, 0x0057, 0x0431, 0x061B, 0x00F8, 0x0224, 0x01BA, 0x0522, 0x0206,   // 74A0 - 74AF
	0x01FB, 0x048E, 0x050F, 0x053A, 0xFFFF, 0x05FB, 0x022D, 0x016F, 0x0041, 0x04D0, 0x057E, 0x06A5, 0x02A3, 0x058D, 0x0212, 0x05BE,   // 74B0 - 74BF
	0x0469, 0x020E, 0x0175, 0x02B3, 0x0130, 0x02BC, 0x0657, 0x0462, 0x02BC, 0x0612, 0x0427, 0x0648, 0x01B6, 0x050F, 0x029C, 0x02E4,   // 74C0 - 74CF
	0x02ED, 0x02BC, 0x0612, 0x02A3, 0x05EA, 0x032A, 0x0599, 0x058D, 0x01AB, 0x00FD, 0x0612, 0x01FB, 0x01A2, 0x001F, 0x011A, 0x03CE,   // 74D0 - 74DF
	0x01EF, 0x0657, 0x03E7, 0x0016, 0x0445, 0x02BC, 0x056A, 0xFFFF, 0x021E, 0x040A, 0x0016, 0x03D6, 0x0156, 0x00F4, 0x0582, 0x03BB,   // 74E0 - 74EF
	0xFFFF, 0xFFFF, 0xFFFF, 0x01EF, 0x02DB, 0x05DE, 0x03F4, 0x00CD, 0xFFFF, 0x0243, 0x007E, 0x0098, 0xFFFF, 0x00F8, 0x0325, 0x004D,   // 74F0 - 74FF
	0x00BE, 0x03F4, 0x0033, 0x0661, 0x064C, 0xFFFF, 0x00CD, 0x05EA, 0x0403, 0x0594, 0x02E9, 0x0109, 0x03BB, 0x0325, 0x0675, 0x002B,   // 7500 - 750F
	0x02D7, 0x062A, 0x058A, 0x03DF, 0x00F4, 0x0582, 0x05EA, 0x05CE, 0x0179, 0x00F0, 0x04BC, 0x053A, 0x053A, 0x01C9, 0x007E, 0x04C1,   // 7510 - 751F
	0x0422, 0x04BC, 0x0079, 0x0079, 0x046E, 0x04C1, 0x0507, 0x04BC, 0x05F2, 0x04D9, 0x02ED, 0x016F, 0x05F2, 0x002B, 0xFFFF, 0x0394,   // 7520 - 752F
	0x053A, 0x05F7, 0x0215, 0x04BC, 0x062F, 0x0110, 0x016F, 0x0359, 0x0110, 0x03F4, 0x011E, 0x01F2, 0x0548, 0x0434, 0x060E, 0x0325,   // 7530 - 753F
	0x0030, 0x0403, 0x02E0, 0x05C7, 0x02E0, 0x007E, 0x034F, 0x0607, 0x0152, 0x016F, 0x0191, 0x053A, 0x0229, 0x0229, 0x0434, 0x057A,   // 7540 - 754F
	0x016F, 0x053A, 0x034F, 0xFFFF, 0x03C5, 0x021E, 0x056A, 0x00ED, 0x0359, 0x02E0, 0x0027, 0x064C, 0x00A7, 0x034F, 0x034F, 0x0064,   // 7550 - 755F
	0xFFFF, 0x0175, 0x0030, 0x00ED, 0x0657, 0x0300, 0x0403, 0x0300, 0x03C5, 0xFFFF, 0x0152, 0x01F2, 0x05FB, 0x05FB, 0x034F, 0x024C,   // 7560 - 756F
	0x05DE, 0x02E0, 0x04B3, 0x011A, 0x00A2, 0x01F2, 0x00F8, 0x00C8, 0x0212, 0x0571, 0x021E, 0x0092, 0x007E, 0x0562, 0x02B3, 0x0212,   // 7570 - 757F
	0x0070, 0x02E0, 0x011A, 0x0559, 0x02D7, 0x021E, 0x021E, 0x00A2, 0x004A, 0x011A, 0x011A, 0x03DF, 0x038C, 0x00F4, 0x04D0, 0x04D0,   // 7580 - 758F
	0x0657, 0x05DE, 0x00B7, 0x0355, 0x011E, 0x0030, 0x0229, 0x02CE, 0x0196, 0x0186, 0x023C, 0x0661, 0x0590, 0x04A3, 0x05BB, 0x03B5,   // 7590 - 759F
	0x02BC, 0x05D2, 0x008D, 0x05F7, 0x000F, 0x0229, 0x0248, 0x058D, 0x0590, 0x00E1, 0x0030, 0x05DE, 0x02BC, 0x0694, 0x00B7, 0x0163,   // 75A0 - 75AF
	0x0666, 0x03CE, 0x03DF, 0x0179, 0x0264, 0x00CD, 0x05A4, 0x0403, 0x00F4, 0x064C, 0x014F, 0x0657, 0x0532, 0x0240, 0x0212, 0x015B,   // 75B0 - 75BF
	0x0240, 0x0110, 0x0215, 0x0594, 0x062F, 0x0045, 0x038C, 0x0651, 0x05F2, 0x0231, 0x0434, 0x009C, 0x054D, 0x05DE, 0x0229, 0x057A,   // 75C0 - 75CF
	0x0206, 0x0140, 0x05D2, 0x0098, 0x0657, 0x01DD, 0x05CB, 0x031D, 0x012C, 0x0231, 0x059F, 0x054D, 0x0556, 0x0311, 0x03DF, 0x059F,   // 75D0 - 75DF
	0x050A, 0x0400, 0x02BC, 0x0657, 0x00E9, 0x0140, 0x058A, 0x049A, 0x02AC, 0x04CB, 0x01FB, 0x0594, 0x05DE, 0x03DA, 0x063D, 0x01AB,   // 75E0 - 75EF
	0x0522, 0x015B, 0x0306, 0x02D7, 0x0098, 0x0212, 0x053A, 0x0005, 0x0098, 0x0030, 0x0030, 0x033B, 0x019F, 0x0138, 0x0144, 0x057A,   // 75F0 - 75FF
	0x05FB, 0x00E1, 0x05CB, 0x0666, 0x058D, 0x00F4, 0x04BC, 0x065B, 0x0212, 0x05FB, 0x01EB, 0x0163, 0x029C, 0x05D2, 0x04BC, 0x0556,   // 7600 - 760F
	0x05FB, 0x01A2, 0x057E, 0x01FB, 0x0279, 0x0215, 0x05E6, 0x05DE, 0x02E9, 0x048A, 0x0248, 0x0098, 0x058D, 0x01AB, 0x05DE, 0x057E,   // 7610 - 761F
	0x0212, 0x00B7, 0x0016, 0x02B3, 0x02E0, 0x0074, 0x04CB, 0x03B5, 0x0110, 0x00ED, 0x003D, 0x0522, 0x063D, 0x0038, 0x04BC, 0x00D9,   // 7620 - 762F
	0x02F9, 0x05DE, 0x0694, 0x00A2, 0x063D, 0x0633, 0x0503, 0x0517, 0x0439, 0x0115, 0x02E9, 0x02E9, 0x0348, 0x022D, 0x05E6, 0x05EA,   // 7630 - 763F
	0x0200, 0x016F, 0x02CE, 0x02E4, 0x0415, 0x02E0, 0x02AC, 0x0594, 0x015B, 0x00F4, 0x05E6, 0x01D6, 0x0002, 0x0016, 0x0594, 0x01AB,   // 7640 - 764F
	0x01A6, 0x039D, 0x05FB, 0x057A, 0x05DE, 0x05F2, 0x03DF, 0x02B3, 0x02BC, 0x04D0, 0x00F4, 0x02D7, 0x0110, 0x02D7, 0x029F, 0x003D,   // 7650 - 765F
	0x0212, 0x0098, 0x05D2, 0x05BE, 0x0229, 0x0651, 0xFFFF, 0x02BC, 0x020E, 0x029F, 0x0212, 0x0110, 0x0594, 0x05EA, 0x05E6, 0x0431,   // 7660 - 766F
	0x05F2, 0x0522, 0x0110, 0x02F9, 0x02F0, 0x02F0, 0x004A, 0xFFFF, 0x01B6, 0x03F9, 0x014F, 0x0104, 0x014F, 0x0012, 0x0012, 0x041A,   // 7670 - 767F
	0x0030, 0x061B, 0x061B, 0x0316, 0x0101, 0x03BE, 0x0229, 0x0200, 0x01B6, 0x00CD, 0x02DB, 0x0182, 0x0348, 0x0212, 0x0224, 0x03DA,   // 7680 - 768F
	0x0182, 0x0002, 0x0144, 0x01D2, 0x01C9, 0x0030, 0x0571, 0x00A2, 0x040A, 0x058D, 0x0002, 0x0236, 0x01D2, 0x0200, 0x01D2, 0x061F,   // 7690 - 769F
	0x00E1, 0x01D2, 0x059F, 0x05DB, 0x03F9, 0x01D2, 0x0224, 0x0002, 0x05AC, 0x0200, 0x02BC, 0x03E7, 0x01D6, 0x0224, 0x03DF, 0x0179,   // 76A0 - 76AF
	0x03CE, 0x0661, 0x024C, 0x042D, 0x00E5, 0x0439, 0x062F, 0x019F, 0x024C, 0x024C, 0x0661, 0x062F, 0x019F, 0x0638, 0x0130, 0x033B,   // 76B0 - 76BF
	0x0403, 0x05EA, 0x05FB, 0x0023, 0x0643, 0x065B, 0x03D6, 0x01D6, 0x05EA, 0x01D6, 0x05DE, 0x004A, 0x0571, 0x01D6, 0x0008, 0x0638,   // 76C0 - 76CF
	0x05CE, 0x0219, 0x01D6, 0x05FB, 0x0290, 0x0152, 0x0186, 0x00FD, 0x03C5, 0x016F, 0x042D, 0x04C1, 0x00FD, 0x02ED, 0x0638, 0x0325,   // 76D0 - 76DF
	0x02ED, 0x022D, 0x05BB, 0x0219, 0x03C5, 0x01AB, 0x0005, 0x02ED, 0x05BB, 0x0661, 0x00F8, 0x0005, 0x019F, 0x02BC, 0x034F, 0x011E,   // 76E0 - 76EF
	0x0179, 0x05BB, 0x0311, 0x0311, 0x0657, 0x0403, 0x0571, 0x053A, 0x0599, 0x013C, 0x05A8, 0x058D, 0x03C5, 0x0163, 0x013C, 0x033B,   // 76F0 - 76FF
	0x033F, 0x04C1, 0x04C7, 0x0607, 0x032D, 0x03C5, 0x0156, 0x0332, 0x00F4, 0x031D, 0x0316, 0x0257, 0x0594, 0x0275, 0x04C7, 0x05D2,   // 7700 - 770F
	0x0651, 0x05D7, 0x04BC, 0x020E, 0x00ED, 0x064C, 0x028A, 0x0240, 0x04BC, 0x05DE, 0x04C1, 0x031D, 0x0348, 0x0666, 0x064C, 0x064C,   // 7710 - 771F
	0x032D, 0x0109, 0x05FE, 0x011A, 0x05DE, 0x0691, 0x0691, 0x0084, 0x062F, 0x05BE, 0x0045, 0x032A, 0x02E4, 0x050F, 0x054D, 0x032A,   // 7720 - 772F
	0x011A, 0x05DE, 0x014C, 0x033F, 0x05BE, 0x0098, 0x028A, 0x0243, 0x034B, 0x064C, 0x053F, 0x05D2, 0x05CE, 0x0348, 0x065B, 0x0309,   // 7730 - 773F
	0x0643, 0x0651, 0x031D, 0x0517, 0x04AE, 0x01C9, 0x01FB, 0x0109, 0x0092, 0x00E9, 0x0243, 0x0144, 0x0571, 0x0594, 0x058D, 0x0294,   // 7740 - 774F
	0x029F, 0x0219, 0x04A3, 0x053A, 0x020A, 0x0571, 0x02DB, 0x04C7, 0x0427, 0x02D3, 0x05CB, 0x0231, 0x0651, 0x02BC, 0x029F, 0x050F,   // 7750 - 775F
	0x0243, 0x04EC, 0x050F, 0x0130, 0x03DF, 0x03DF, 0x034F, 0x020A, 0x0379, 0x02ED, 0x0182, 0x0229, 0x0053, 0x0661, 0x05FB, 0x020A,   // 7760 - 776F
	0x0306, 0x0590, 0x05AC, 0x0206, 0x01BA, 0xFFFF, 0x00C3, 0x0219, 0x031D, 0x0130, 0x01EB, 0x05BE, 0x0537, 0x0290, 0x0182, 0x046E,   // 7770 - 777F
	0x0316, 0x05BB, 0x014F, 0x057E, 0x0332, 0x00A2, 0x0290, 0x032A, 0x0582, 0x0275, 0x00F8, 0x008D, 0x0264, 0x0503, 0x0590, 0x0427,   // 7780 - 778F
	0x0316, 0x033F, 0x030D, 0x04EC, 0x061F, 0x063D, 0x05DE, 0x0115, 0x0275, 0x0348, 0x04F1, 0x00D0, 0x02E9, 0x0098, 0x030D, 0x03E7,   // 7790 - 779F
	0x0092, 0x0212, 0x0325, 0x01FB, 0x0472, 0x03EC, 0x058D, 0x0415, 0x0400, 0x0666, 0x0104, 0x04BC, 0x04F1, 0x02CE, 0x0089, 0x0594,   // 77A0 - 77AF
	0x0257, 0x05DB, 0x05BB, 0x054D, 0x058A, 0x02D7, 0x0290, 0x0219, 0x05DB, 0x0002, 0x0206, 0x0638, 0x0219, 0x019F, 0x0643, 0x0240,   // 77B0 - 77BF
	0x057A, 0x00A2, 0x0212, 0x0394, 0x05C7, 0x05D7, 0x020E, 0x0325, 0x032D, 0x0041, 0x032D, 0x02BC, 0x01B0, 0x0248, 0x05BE, 0x032D,   // 77C0 - 77CF
	0x020E, 0x02ED, 0x0325, 0x02E4, 0x01AB, 0x030D, 0x058D, 0x00A7, 0x0526, 0x0257, 0x0666, 0x0316, 0x022D, 0x02D7, 0x05FB, 0x04F6,   // 77D0 - 77DF
	0x0064, 0x0248, 0x04C7, 0x05DE, 0x04BC, 0x0657, 0x01EB, 0x04BC, 0x05EA, 0x0240, 0x0661, 0x0224, 0x00E9, 0x0133, 0x0002, 0x0224,   // 77E0 - 77EF
	0x062A, 0x020E, 0x0012, 0x04C7, 0x011E, 0x0403, 0x0212, 0x0691, 0x0179, 0x058A, 0x0566, 0x0279, 0x040F, 0x058D, 0x0152, 0x028A,   // 77F0 - 77FF
	0x00F8, 0x0306, 0x049A, 0x00F4, 0x0248, 0x02BC, 0x016F, 0x033B, 0x03AE, 0x01F2, 0x025B, 0x0657, 0x0403, 0x0257, 0x0229, 0x015F,   // 7800 - 780F
	0x0144, 0x05CB, 0x03DF, 0x0648, 0x05CE, 0x050F, 0x0675, 0x0089, 0x013C, 0x03C5, 0x05CE, 0xFFFF, 0x0163, 0x014F, 0x0348, 0x062F,   // 7810 - 781F
	0x0431, 0x05FB, 0x0264, 0x0566, 0x0566, 0x0109, 0x0633, 0x064C, 0x0144, 0x015B, 0x034F, 0x0666, 0x02BC, 0x0033, 0x03A6, 0x03F4,   // 7820 - 782F
	0x03DA, 0x02DB, 0x03CE, 0x02B0, 0x03F9, 0x004A, 0x03F9, 0x04BC, 0x060B, 0x0002, 0x02BC, 0x02E4, 0x054D, 0xFFFF, 0x02BC, 0x028A,   // 7830 - 783F
	0x00A7, 0x026B, 0x0434, 0x0666, 0x028A, 0x01B6, 0x0144, 0x0362, 0x0215, 0x02ED, 0x057A, 0x0002, 0x02F9, 0x0267, 0x05AC, 0x05CE,   // 7840 - 784F
	0x0127, 0x03DA, 0x058D, 0xFFFF, 0x01E6, 0x04F6, 0x0590, 0x0415, 0xFFFF, 0x057A, 0x0415, 0xFFFF, 0x026B, 0x059F, 0x0439, 0x0079,   // 7850 - 785F
	0x02A7, 0x01E6, 0x05FB, 0x059F, 0x0590, 0x0311, 0x02E4, 0xFFFF, 0x0089, 0x0089, 0x0587, 0x02E0, 0x05EA, 0x0311, 0x0439, 0x05CE,   // 7860 - 786F
	0x00E9, 0x0294, 0x05FB, 0xFFFF, 0xFFFF, 0x02ED, 0x008D, 0x0219, 0xFFFF, 0x04FE, 0x068C, 0x026B, 0x03DA, 0x05CE, 0x0682, 0x0270,   // 7870 - 787F
	0x006B, 0x0403, 0x0694, 0x0422, 0x02D7, 0x024C, 0x004A, 0x011E, 0x033B, 0x0115, 0x0219, 0x01D6, 0x02E0, 0x0002, 0x050F, 0x0439,   // 7880 - 788F
	0x02DB, 0x0023, 0x05E6, 0x0138, 0x058A, 0x0403, 0x02F5, 0x0571, 0x0110, 0x017D, 0x0023, 0x0403, 0x008D, 0x0469, 0x05CE, 0x011A,   // 7890 - 789F
	0x011E, 0x0661, 0x0566, 0x0229, 0x05EA, 0x0033, 0x0264, 0x0030, 0x057A, 0x04F6, 0x064C, 0x0133, 0x0590, 0x00F8, 0x0537, 0x0362,   // 78A0 - 78AF
	0x03DA, 0x0219, 0x0109, 0x0522, 0x0070, 0xFFFF, 0x0403, 0xFFFF, 0x0163, 0x05BE, 0x0439, 0x0439, 0x0306, 0x0196, 0x037C, 0x0507,   // 78B0 - 78BF
	0x0144, 0x00CD, 0x02E0, 0x04FB, 0x0526, 0x001A, 0x01F2, 0x03DF, 0x057A, 0x0485, 0x02B3, 0x00E9, 0x053A, 0x0590, 0x058D, 0x02C3,   // 78C0 - 78CF
	0x03C5, 0x057A, 0x0607, 0x0138, 0x0648, 0x0264, 0x029C, 0xFFFF, 0x0422, 0x01BA, 0x0675, 0x0079, 0x0403, 0x000C, 0x03DA, 0x02ED,   // 78D0 - 78DF
	0x02ED, 0x0257, 0x040F, 0x008D, 0x05E6, 0x02B3, 0x0038, 0x0403, 0x0348, 0x0403, 0x00E1, 0x0694, 0x0422, 0x00C8, 0xFFFF, 0x0212,   // 78E0 - 78EF
	0x04A3, 0x02AC, 0x0431, 0x062A, 0x0104, 0x0219, 0x058D, 0x02D7, 0x011E, 0x0110, 0x0200, 0x03C5, 0x060B, 0x0415, 0x0109, 0x02BC,   // 78F0 - 78FF
	0x0219, 0x0224, 0x058D, 0x063D, 0x0415, 0x013C, 0x0219, 0x05FB, 0x0682, 0x01D6, 0x020E, 0x0633, 0x02B3, 0x0264, 0x00A7, 0x0212,   // 7900 - 790F
	0x0439, 0x00F8, 0x0587, 0x021E, 0x03DF, 0x03DF, 0x05FB, 0x03F0, 0x0403, 0x0002, 0x0264, 0x0219, 0x05FB, 0x0469, 0x0325, 0x03CE,   // 7910 - 791F
	0x0691, 0x004A, 0xFFFF, 0x0337, 0x0050, 0x0594, 0x028A, 0x02B3, 0x02B3, 0x0657, 0x02BC, 0x02BC, 0x0152, 0x0439, 0x03CE, 0x05EA,   // 7920 - 792F
	0x02BC, 0x02E4, 0x02E4, 0x0348, 0x004A, 0x04E5, 0x01AB, 0x02A3, 0x0612, 0x05CE, 0x04C7, 0x04C7, 0x02BC, 0x0455, 0x04B3, 0x0603,   // 7930 - 793F
	0x04FB, 0x0403, 0x051B, 0x0306, 0x05A4, 0x05D7, 0x0594, 0x0657, 0x0403, 0x0657, 0x002B, 0x04D0, 0x009C, 0xFFFF, 0x05DE, 0x04C7,   // 7940 - 794F
	0x05F7, 0x0657, 0x053F, 0x016F, 0x016F, 0x032A, 0x069D, 0x0657, 0x050A, 0x031D, 0x06AD, 0x0431, 0x01EF, 0x0666, 0x04BC, 0x050F,   // 7950 - 795F
	0x00CD, 0x0074, 0x032A, 0x02FD, 0x05FB, 0x0599, 0x058A, 0x053F, 0x03E7, 0x0666, 0x01B6, 0x0590, 0x0657, 0x0212, 0x0182, 0x064C,   // 7960 - 796F
	0x0182, 0x04EC, 0x022D, 0x064C, 0x0175, 0x0294, 0x0109, 0x00FD, 0x020E, 0x052B, 0x0403, 0x019F, 0x01AB, 0x06A5, 0x02DB, 0x02ED,   // 7970 - 797F
	0x0045, 0x022D, 0x00FD, 0x0657, 0x02ED, 0x04A3, 0x0023, 0x0648, 0x0206, 0x05F7, 0x058D, 0x05E6, 0x0691, 0x020E, 0x064C, 0x016F,   // 7980 - 798F
	0x05FE, 0x058A, 0x0594, 0x05D2, 0x0537, 0x05DE, 0x031D, 0x04FB, 0x0109, 0xFFFF, 0x068C, 0x064C, 0x05F2, 0x0212, 0x0182, 0x0526,   // 7990 - 799F
	0x0098, 0x0306, 0x051B, 0xFFFF, 0x05BE, 0x0403, 0x05FB, 0x058D, 0x0212, 0x04FB, 0x0079, 0x05BE, 0x0206, 0x050F, 0x02BC, 0x039D,   // 79A0 - 79AF
	0x0379, 0x00FD, 0x02BC, 0x0445, 0x0603, 0x0537, 0x0612, 0x02B3, 0x0462, 0x05FB, 0x05FB, 0x02BC, 0x05A4, 0x041E, 0x01D6, 0x0556,   // 79B0 - 79BF
	0x05B7, 0x04FB, 0x0451, 0x0556, 0x0691, 0x0070, 0x0179, 0x05DE, 0x0594, 0x0045, 0x037C, 0x042D, 0x042D, 0x009C, 0x015F, 0x01D2,   // 79C0 - 79CF
	0x0607, 0x0264, 0x0332, 0x0657, 0x0231, 0x0030, 0x0657, 0x05FB, 0x032A, 0x0279, 0x0016, 0x03DF, 0x0379, 0x02BC, 0x05F7, 0x069D,   // 79D0 - 79DF
	0x03DF, 0x000F, 0x02DB, 0x0348, 0x0092, 0x037C, 0x041E, 0x05D2, 0x06AD, 0x0657, 0x0657, 0x04D0, 0x0240, 0x0691, 0x051E, 0x0212,   // 79E0 - 79EF
	0x0092, 0x054D, 0x0657, 0x020E, 0x01D6, 0x05E6, 0x0691, 0x0657, 0x0229, 0x0451, 0x0130, 0x05DE, 0x0666, 0x0206, 0x039D, 0x016F,   // 79F0 - 79FF
	0x058D, 0x0260, 0x02A7, 0x016F, 0x061F, 0x04EC, 0x02FD, 0x0294, 0x0179, 0x0231, 0x0537, 0x0092, 0x0556, 0x04AE, 0x04EC, 0x05CB,   // 7A00 - 7A0F
	0x02F5, 0x02ED, 0x019F, 0x06AD, 0x0451, 0x0687, 0x001A, 0x0012, 0x0212, 0x0657, 0x0657, 0x0294, 0x02B7, 0x03DA, 0x0264, 0x0045,   // 7A10 - 7A1F
	0x00A2, 0x06A5, 0x05FB, 0x0507, 0xFFFF, 0xFFFF, 0x05DE, 0x058D, 0x0033, 0x0212, 0x016F, 0x0030, 0x03AE, 0x0229, 0x065B, 0x0694,   // 7A20 - 7A2F
	0x05BB, 0x0092, 0x00FD, 0x057E, 0x02C3, 0x0691, 0x05FB, 0x0212, 0x05BB, 0x064C, 0x0657, 0x00FD, 0x0215, 0x0212, 0x0182, 0x0182,   // 7A30 - 7A3F
	0x019F, 0x045D, 0x050F, 0xFFFF, 0x0212, 0x025B, 0x034F, 0x04A3, 0x0321, 0x0657, 0x0212, 0x02ED, 0x0507, 0x0212, 0x05EA, 0x057E,   // 7A40 - 7A4F
	0x042D, 0x048E, 0xFFFF, 0x05DE, 0x0200, 0x041A, 0x0212, 0x050F, 0x059F, 0x0400, 0x0224, 0x068C, 0x054D, 0xFFFF, 0x02FD, 0x050F,   // 7A50 - 7A5F
	0x039D, 0x048E, 0x0206, 0x0445, 0x03AE, 0x05FB, 0xFFFF, 0x0212, 0x055E, 0x057E, 0x0092, 0x020E, 0x0196, 0x02FD, 0x0038, 0xFFFF,   // 7A60 - 7A6F
	0x0445, 0x0248, 0x02BC, 0x0612, 0x05C3, 0x056A, 0x023C, 0x0427, 0x058D, 0x0427, 0x0270, 0x05FB, 0x0491, 0x0231, 0x05D7, 0x00B1,   // 7A70 - 7A7F
	0x0687, 0x0556, 0x02AC, 0x041A, 0x0633, 0x05D7, 0x0033, 0x001F, 0x05D7, 0x0045, 0x05FB, 0x0666, 0x0224, 0x0415, 0x0115, 0x058A,   // 7A80 - 7A8F
	0x01B6, 0x05D7, 0x0657, 0x00B1, 0x05D7, 0x053F, 0x0224, 0x00B7, 0x0236, 0x059F, 0x0092, 0x0275, 0x00DC, 0x0587, 0x00F4, 0x0279,   // 7A90 - 7A9F
	0x0264, 0x0682, 0x05BB, 0x0507, 0xFFFF, 0x0290, 0x012C, 0xFFFF, 0x05E6, 0x0587, 0x056A, 0x05CB, 0x05FB, 0x0240, 0x0427, 0x05D7,   // 7AA0 - 7AAF
	0x05D7, 0x053F, 0x02CE, 0x05FB, 0x053A, 0x0115, 0x0240, 0x02CE, 0x058D, 0x058A, 0x0290, 0x00B7, 0x0240, 0xFFFF, 0x0285, 0x02E4,   // 7AB0 - 7ABF
	0x0092, 0x00E1, 0x03E7, 0x061B, 0x00DC, 0x0415, 0x0427, 0x012C, 0x061B, 0x061B, 0x041A, 0x02BC, 0x00A7, 0x04C7, 0x016F, 0x040A,   // 7AC0 - 7ACF
	0x00A7, 0x01E6, 0x0403, 0x040A, 0x0196, 0x04C7, 0x04D0, 0x0332, 0x0240, 0x0638, 0x0666, 0x02DB, 0x02E4, 0x0045, 0x0231, 0x0231,   // 7AD0 - 7ADF
	0x063D, 0x05DE, 0x04FB, 0x024C, 0x01E6, 0x054D, 0x04FE, 0x0231, 0x0115, 0x05DE, 0x04D0, 0x0231, 0x0431, 0x0229, 0x03F4, 0x0133,   // 7AE0 - 7AEF
	0x04AE, 0x0675, 0x006B, 0x0104, 0x00E5, 0x01F6, 0x0231, 0x0257, 0x0231, 0x0666, 0x0666, 0x02B0, 0x03DA, 0x05FB, 0x0098, 0x0179,   // 7AF0 - 7AFF
	0x0311, 0x0666, 0xFFFF, 0x0130, 0x0212, 0x059F, 0x000F, 0x050A, 0x0212, 0x064C, 0x0643, 0x0513, 0x05CB, 0x0682, 0x05FE, 0x01EF,   // 7B00 - 7B0F
	0x017D, 0x059F, 0x0067, 0x03DF, 0x0030, 0x0219, 0x05DE, 0x0127, 0x04A3, 0x04C1, 0x0590, 0x0109, 0x0666, 0x0352, 0x0098, 0x019F,   // 7B10 - 7B1F
	0x02BC, 0x041A, 0x033B, 0x001F, 0x053F, 0x04FB, 0x016F, 0x0064, 0x0027, 0x014F, 0x00ED, 0x0691, 0x0109, 0x02DB, 0x061F, 0x03A6,   // 7B20 - 7B2F
	0x016F, 0x019B, 0x0152, 0x0215, 0x0186, 0x0152, 0x04C7, 0x0316, 0x03F9, 0xFFFF, 0x0219, 0x0427, 0x02E4, 0xFFFF, 0x0033, 0x02F9,   // 7B30 - 7B3F
	0x01B6, 0x0431, 0x0098, 0x05E6, 0x05D7, 0x0594, 0x0030, 0x0427, 0x01A2, 0x0104, 0x0224, 0x022D, 0x0434, 0x0513, 0x0466, 0x014F,   // 7B40 - 7B4F
	0x028A, 0x0666, 0x054D, 0x0212, 0x00ED, 0x01CD, 0x0064, 0x065B, 0x0275, 0x029F, 0x0030, 0x049E, 0x00F8, 0x0651, 0x0064, 0x016F,   // 7B50 - 7B5F
	0x0607, 0x0556, 0x03BE, 0x02BC, 0x02A7, 0x0240, 0x01AB, 0x0219, 0x01C9, 0x054D, 0x0590, 0x0657, 0x0092, 0x050A, 0x04C7, 0x0666,   // 7B60 - 7B6F
	0x06AD, 0x059F, 0x04AE, 0x0548, 0x0215, 0x05CE, 0x0182, 0x0280, 0x0179, 0x00A2, 0x028A, 0x017D, 0x0607, 0xFFFF, 0x040A, 0x059F,   // 7B70 - 7B7F
	0x0219, 0x0400, 0x029F, 0x0699, 0x0030, 0x0030, 0x0030, 0x0186, 0x0098, 0x01A6, 0x05FB, 0x0219, 0x0643, 0x019F, 0x0098, 0x0651,   // 7B80 - 7B8F
	0x0422, 0x049A, 0x0661, 0x02ED, 0x004A, 0x0212, 0x02D7, 0x050A, 0x024C, 0x016F, 0x062F, 0x019F, 0x0270, 0x040A, 0x040A, 0x024C,   // 7B90 - 7B9F
	0x00BE, 0x01AB, 0x05FE, 0x0064, 0x0240, 0x004A, 0x061F, 0x041A, 0x0566, 0x02F9, 0x00F4, 0x059F, 0x0476, 0x0219, 0xFFFF, 0x0033,   // 7BA0 - 7BAF
	0x0513, 0x0599, 0x0594, 0x03F4, 0x064C, 0x04C1, 0x01EF, 0x04C7, 0x0666, 0x0603, 0x00C3, 0x016F, 0x058A, 0x0127, 0x04F6, 0x0212,   // 7BB0 - 7BBF
	0x0229, 0x0200, 0x05AC, 0x031D, 0x0152, 0x00B1, 0x0675, 0x03E2, 0x0163, 0x0666, 0x01E6, 0x041A, 0x01EB, 0x042D, 0x0332, 0x040A,   // 7BC0 - 7BCF
	0xFFFF, 0x0290, 0xFFFF, 0x02E9, 0x0607, 0x01D6, 0x0526, 0x0603, 0x00A2, 0x0182, 0x015B, 0x0476, 0x0651, 0x019B, 0x038C, 0x040A,   // 7BD0 - 7BDF
	0x059F, 0x00DC, 0x0196, 0x03C9, 0x0130, 0x02BC, 0x0030, 0x068C, 0x00A7, 0x049E, 0x0098, 0x0666, 0x040F, 0x02E4, 0x02A3, 0x0219,   // 7BE0 - 7BEF
	0x004D, 0x02BC, 0x0206, 0x0030, 0x0109, 0x00D0, 0x05CE, 0x03DA, 0x0491, 0x00DC, 0x03C1, 0x03E7, 0x012C, 0x05FB, 0x0337, 0x0675,   // 7BF0 - 7BFF
	0x061F, 0x058D, 0x01BE, 0x05DE, 0x01EF, 0x0079, 0x0275, 0x00D9, 0x03F4, 0x061B, 0x0212, 0x01B6, 0x0507, 0x02E9, 0x062F, 0x02ED,   // 7C00 - 7C0F
	0x037C, 0x0517, 0x00DC, 0xFFFF, 0x0517, 0x02B0, 0x0133, 0x02C8, 0x059F, 0x004A, 0x032A, 0x049E, 0x00F8, 0x02CE, 0x00F4, 0x0110,   // 7C10 - 7C1F
	0x016F, 0x0219, 0x033B, 0x0290, 0x00F0, 0x0415, 0x0104, 0x0200, 0x0513, 0x02AC, 0x0612, 0x059F, 0x02ED, 0x04C7, 0x0612, 0xFFFF,   // 7C20 - 7C2F
	0x03C1, 0x0403, 0x03C1, 0x0179, 0x0240, 0x0130, 0x02ED, 0x05CE, 0x004A, 0x00F8, 0x047D, 0x0264, 0x019B, 0x040A, 0x02C3, 0x004D,   // 7C30 - 7C3F
	0x0661, 0x029F, 0xFFFF, 0x02A3, 0x0290, 0x05FB, 0x0603, 0x01D2, 0x064C, 0x051E, 0x0537, 0x032A, 0x00A2, 0x0212, 0xFFFF, 0x0403,   // 7C40 - 7C4F
	0x0532, 0x0675, 0x0661, 0x0152, 0x0503, 0x0661, 0x040A, 0x0298, 0x0532, 0x02ED, 0x02ED, 0x0219, 0x0566, 0x05EA, 0x05FB, 0x029F,   // 7C50 - 7C5F
	0x02E4, 0xFFFF, 0x02C3, 0x02A3, 0x040A, 0x0603, 0x065B, 0x0431, 0x02C3, 0x0033, 0x0133, 0x06A0, 0x02BC, 0x049E, 0x02F9, 0x05EA,   // 7C60 - 7C6F
	0x0603, 0x068C, 0x05BB, 0x032A, 0x0109, 0x0152, 0x04BC, 0x0648, 0x04BC, 0x03B2, 0x05A4, 0x02B3, 0x0594, 0x0691, 0x0379, 0x00E5,   // 7C70 - 7C7F
	0x063D, 0x040A, 0xFFFF, 0x0030, 0x0016, 0x058A, 0x049A, 0x025B, 0x0462, 0x015F, 0x0030, 0x00E1, 0x05E6, 0x02BC, 0x0098, 0x051E,   // 7C80 - 7C8F
	0xFFFF, 0x000F, 0x02BC, 0x0179, 0x0240, 0x03F9, 0x0348, 0x00D9, 0x0638, 0x0661, 0x02BC, 0x0507, 0x053F, 0x02BC, 0x058D, 0x0507,   // 7C90 - 7C9F
	0x01E6, 0x054D, 0x0691, 0x0064, 0x0603, 0x0661, 0x02D7, 0x067B, 0x0012, 0xFFFF, 0x015F, 0x032D, 0x0431, 0xFFFF, 0x02C8, 0x0594,   // 7CA0 - 7CAF
	0x016F, 0x02C8, 0x0057, 0x0231, 0x02BC, 0x0603, 0x02ED, 0x0240, 0x0403, 0x00E1, 0x0012, 0x007E, 0x02D7, 0x0694, 0x0231, 0x01BE,   // 7CB0 - 7CBF
	0xFFFF, 0x0481, 0x0481, 0x0526, 0x0033, 0x0462, 0x032D, 0x01EB, 0x05BB, 0x0694, 0x01EF, 0x0219, 0x0612, 0x00CD, 0x02BC, 0x05A4,   // 7CC0 - 7CCF
	0x016F, 0x03AE, 0x0023, 0x019F, 0x05B7, 0x0182, 0x0526, 0x042D, 0xFFFF, 0x0060, 0x067B, 0x0526, 0x032A, 0x0481, 0x015F, 0x061B,   // 7CD0 - 7CDF
	0x025B, 0x021E, 0x0348, 0x0481, 0x0481, 0x03AE, 0x0098, 0x02C8, 0x021E, 0x0280, 0x004A, 0x01FB, 0x04D0, 0x0694, 0x0219, 0x03AE,   // 7CE0 - 7CEF
	0x0559, 0x038C, 0x02BC, 0x06AD, 0x0109, 0x038C, 0x053F, 0x02A3, 0x032A, 0x032A, 0x023C, 0x058D, 0x0196, 0x0651, 0x023C, 0x05F7,   // 7CF0 - 7CFF
	0x0212, 0x0070, 0x0661, 0x05C7, 0x0603, 0x01E6, 0x05FB, 0x01D6, 0x0571, 0x0451, 0x057E, 0x057E, 0x042D, 0x0352, 0x0691, 0x0552,   // 7D00 - 7D0F
	0x0399, 0x016B, 0x0229, 0x04D0, 0x00C3, 0x03DF, 0x05E6, 0x049A, 0x01E6, 0x0657, 0x0212, 0x015F, 0x0607, 0x0451, 0x00F4, 0x022D,   // 7D10 - 7D1F
	0x0507, 0x0156, 0x0517, 0x00E1, 0x023C, 0x062F, 0x000F, 0x022D, 0x016F, 0x0657, 0x0403, 0x0691, 0x00A2, 0x01E6, 0x062F, 0x02B3,   // 7D20 - 7D2F
	0x058D, 0x016F, 0x05A4, 0x04BC, 0x0023, 0x0666, 0x0431, 0x02DB, 0x0666, 0x04AE, 0x0179, 0x05D2, 0x016F, 0x0566, 0x064C, 0x00F0,   // 7D30 - 7D3F
	0x00A7, 0x04C7, 0x065B, 0x0594, 0x069D, 0x0236, 0x0016, 0x0240, 0x03BE, 0x04D0, 0x06A5, 0x028A, 0x0231, 0x0451, 0x01E1, 0x05A4,   // 7D40 - 7D4F
	0x0229, 0x0666, 0x00A2, 0x01A2, 0x0012, 0x0248, 0x028A, 0x01EF, 0x00CD, 0x0191, 0x0191, 0x052B, 0x05A4, 0x0279, 0x0224, 0x0434,   // 7D50 - 7D5F
	0x0175, 0x02F9, 0x05BE, 0x002B, 0x0594, 0x016F, 0x0189, 0x054D, 0x045D, 0x053F, 0x05E6, 0x02B3, 0x05A4, 0x0434, 0x05BB, 0x01C5,   // 7D60 - 7D6F
	0x011A, 0x054D, 0x04FB, 0x021E, 0x0599, 0x0206, 0x0248, 0x0657, 0x0219, 0x0243, 0x0098, 0x032D, 0x064C, 0x02FD, 0x0092, 0x042D,   // 7D70 - 7D7F
	0x04D0, 0x001A, 0x054D, 0x059F, 0x0571, 0x041E, 0x0191, 0x05B7, 0x0537, 0x05B7, 0x05A4, 0x01E6, 0x058D, 0x016F, 0x0548, 0x050F,   // 7D80 - 7D8F
	0x0138, 0x0294, 0x016F, 0x0231, 0x01EF, 0x0657, 0x05CE, 0x0236, 0x0163, 0x0212, 0x05BB, 0xFFFF, 0x0694, 0x02D7, 0x0140, 0x02BC,   // 7D90 - 7D9F
	0x02FD, 0x02C8, 0x00A2, 0x0434, 0x04AE, 0x0403, 0x0403, 0x0687, 0x0403, 0x0571, 0x040A, 0x0594, 0x04CB, 0x057A, 0x0403, 0x052B,   // 7DA0 - 7DAF
	0x0571, 0x017D, 0x0575, 0x002B, 0x0682, 0x0053, 0x01BE, 0x00E1, 0x02F5, 0x02E0, 0x0403, 0x0638, 0x0023, 0x00C8, 0x02DB, 0x032D,   // 7DB0 - 7DBF
	0x0403, 0x0229, 0x0522, 0x0694, 0x01BA, 0x0699, 0x05DE, 0x0691, 0x05AC, 0x02C8, 0x022D, 0x015B, 0x046E, 0x033B, 0x05FB, 0x0694,   // 7DC0 - 7DCF
	0x0152, 0x02FD, 0x05BB, 0xFFFF, 0x04A8, 0xFFFF, 0x05BB, 0x0599, 0x0219, 0x0264, 0x0594, 0x0469, 0x032D, 0x0212, 0x0133, 0x065B,   // 7DD0 - 7DDF
	0x0109, 0x033B, 0x0332, 0x05FE, 0x05A4, 0x001F, 0x04FB, 0x042D, 0x0033, 0x01FB, 0x0191, 0x0694, 0x032D, 0x057A, 0x016F, 0x057A,   // 7DE0 - 7DEF
	0x05FB, 0x019B, 0x0332, 0x0229, 0x02C3, 0x0694, 0x0033, 0x0607, 0x05E6, 0x0537, 0x01A2, 0x0657, 0x0607, 0x0092, 0x0079, 0x00F0,   // 7DF0 - 7DFF
	0x0215, 0x05FE, 0x0694, 0x05BB, 0x04C1, 0xFFFF, 0x0191, 0xFFFF, 0x05EA, 0x022D, 0x05DE, 0x0682, 0x0379, 0x001A, 0x019F, 0x03C5,   // 7E00 - 7E0F
	0x0661, 0x0219, 0x00E9, 0x0434, 0x04E5, 0x0607, 0x0590, 0x04D9, 0x058D, 0x045D, 0x052B, 0x016F, 0x0607, 0x064C, 0x0182, 0x0466,   // 7E10 - 7E1F
	0x01EF, 0x060E, 0x0532, 0x0594, 0x0507, 0x064C, 0x0694, 0x052B, 0x0200, 0x0053, 0x0030, 0x0163, 0x00D9, 0x02BC, 0x0517, 0x05E6,   // 7E20 - 7E2F
	0x058D, 0x0694, 0x02B3, 0x0675, 0x040A, 0x030D, 0x0657, 0x02FD, 0x0348, 0x03E7, 0x02C3, 0x032A, 0x05BE, 0x0694, 0x0212, 0x04A3,   // 7E30 - 7E3F
	0x050F, 0x0152, 0x04D9, 0x002B, 0x05DE, 0x048A, 0x034B, 0x0661, 0x040F, 0x020A, 0x0594, 0x058D, 0xFFFF, 0x05B7, 0x0441, 0x05BE,   // 7E40 - 7E4F
	0x0206, 0x0415, 0x062A, 0x06AD, 0x0657, 0x04A3, 0x0481, 0x02D7, 0x05FB, 0x0152, 0x02CE, 0x00C8, 0x06A9, 0x0219, 0x044A, 0x0079,   // 7E50 - 7E5F
	0x046E, 0x05B7, 0x0206, 0x01F2, 0x06A0, 0x058D, 0x040F, 0xFFFF, 0x00ED, 0x04C1, 0x0206, 0x058D, 0x048E, 0x0219, 0x021E, 0x01FB,   // 7E60 - 7E6F
	0x0415, 0x00D0, 0x0229, 0x0224, 0x004A, 0x0079, 0x05DE, 0x0362, 0x050F, 0x05DE, 0x049E, 0x05BB, 0x0212, 0x0041, 0x040A, 0x0219,   // 7E70 - 7E7F
	0x0400, 0x05C7, 0x06A0, 0x0403, 0x03DA, 0x02BC, 0x0348, 0x02B3, 0x05A4, 0x06A0, 0x028A, 0x05F7, 0x05BB, 0x02B3, 0x0594, 0x0079,   // 7E80 - 7E8F
	0xFFFF, 0x02ED, 0x0079, 0x05EA, 0x0053, 0x0599, 0x0594, 0x06A5, 0x06A0, 0x02F9, 0x058D, 0x00FD, 0x02A3, 0x02B3, 0x02C3, 0x032A,   // 7E90 - 7E9F
	0x023C, 0x05FB, 0x01E6, 0x0661, 0x0594, 0x01D6, 0x0603, 0x0212, 0x0571, 0x028A, 0x0212, 0x0451, 0x057A, 0x0607, 0x01E6, 0x00C3,   // 7EA0 - 7EAF
	0x03DF, 0x049A, 0x017D, 0x0352, 0x0451, 0x0694, 0x02F5, 0x015F, 0x0657, 0x057E, 0x0156, 0x0666, 0x064C, 0x0399, 0x04D0, 0x0594,   // 7EB0 - 7EBF
	0x0179, 0x05A4, 0x016F, 0x02C3, 0x069D, 0x04BC, 0x058D, 0x0657, 0x065B, 0x0661, 0x0016, 0x016F, 0x00A7, 0x04AE, 0x05DE, 0x0231,   // 7EC0 - 7ECF
	0x00F0, 0x001A, 0x045D, 0x0229, 0x0279, 0x044A, 0x011A, 0x01CD, 0x0206, 0x0189, 0x05BE, 0x021E, 0x02F9, 0x0248, 0x0224, 0x054D,   // 7ED0 - 7EDF
	0x0191, 0x059F, 0x0243, 0x05B7, 0x058D, 0x050F, 0x052B, 0x0212, 0x0537, 0x0212, 0x05BB, 0x02DB, 0x05E6, 0x05BB, 0x0403, 0x015B,   // 7EE0 - 7EEF
	0x00C8, 0x04A8, 0x01BA, 0x04C1, 0x057A, 0x032D, 0x04CB, 0x002B, 0x00A2, 0x052B, 0x02E0, 0x0434, 0x0694, 0x0638, 0x0571, 0x02FD,   // 7EF0 - 7EFF
	0x0682, 0x0691, 0x0264, 0x0599, 0x0219, 0x032D, 0x02A3, 0x0537, 0x0332, 0x0212, 0x0607, 0x0206, 0x04FB, 0x0140, 0x0133, 0x0033,   // 7F00 - 7F0F
	0x0594, 0x019B, 0x0682, 0x01FB, 0x0109, 0x02FD, 0x0033, 0x033B, 0x05FE, 0x022D, 0x016F, 0x0466, 0x064C, 0x0163, 0x00E1, 0x0182,   // 7F10 - 7F1F
	0x0079, 0x02BC, 0x05DE, 0x0219, 0x0041, 0x03E7, 0x030D, 0x02B3, 0x05EA, 0x0517, 0x034B, 0x048A, 0x05A4, 0x02CE, 0x04A3, 0x062A,   // 7F20 - 7F2F
	0x021E, 0x040A, 0x0415, 0x01FB, 0x0224, 0x06A0, 0x016B, 0x05A4, 0x017D, 0x016B, 0x0439, 0x016B, 0x0439, 0x004A, 0x03F4, 0x01EB,   // 7F30 - 7F3F
	0xFFFF, 0x017D, 0x05EA, 0x05EA, 0x0422, 0x0590, 0x01AB, 0x06A9, 0x0522, 0xFFFF, 0x0422, 0x0582, 0x05EA, 0x02B3, 0x0522, 0x02ED,   // 7F40 - 7F4F
	0x01AB, 0x0575, 0x017D, 0x0575, 0x0575, 0x01C9, 0xFFFF, 0x02F9, 0x016F, 0x032A, 0x014F, 0x019F, 0x0666, 0x0240, 0x0316, 0x019F,   // 7F50 - 7F5F
	0x033B, 0x017D, 0x000F, 0x01A2, 0x0537, 0x0243, 0x016F, 0x02D7, 0x05CE, 0x0643, 0x06A5, 0x01A2, 0x068C, 0x05FB, 0x0657, 0x0005,   // 7F60 - 7F6F
	0x014F, 0x02A3, 0x04D0, 0x04FB, 0x03DF, 0x0306, 0x02E0, 0x000F, 0x014F, 0x02BC, 0x0084, 0x057A, 0x0030, 0x0212, 0x062A, 0x054D,   // 7F70 - 7F7F
	0x02E0, 0x0212, 0x0243, 0x032A, 0x0643, 0x02F9, 0x03DF, 0x0212, 0x0212, 0x02F0, 0x05D2, 0x0337, 0x040F, 0x051B, 0x031D, 0x05D2,   // 7F80 - 7F8F
	0x05F7, 0x05F7, 0x015F, 0x000F, 0x0182, 0x05D2, 0x019F, 0x040F, 0x0616, 0x0182, 0x02DB, 0x05DE, 0x0666, 0x0109, 0x05B7, 0x040F,   // 7F90 - 7F9F
	0x05DE, 0x0594, 0x045D, 0x043D, 0x043D, 0x040A, 0x01FB, 0x0517, 0x0594, 0x05DE, 0x05D2, 0x040F, 0x0594, 0x05FB, 0x0191, 0x0229,   // 7FA0 - 7FAF
	0x0526, 0x05FE, 0x058D, 0x0152, 0x04A3, 0x015F, 0x04A3, 0x02C3, 0x02B3, 0x0191, 0x03A2, 0x040F, 0x0079, 0x05FB, 0x0196, 0x05DE,   // 7FB0 - 7FBF
	0x009C, 0x0582, 0x015F, 0x01E6, 0x0098, 0x0098, 0x00E1, 0x016F, 0x0590, 0x03D6, 0x05DE, 0x029C, 0x05DE, 0x03DF, 0x02DB, 0x02E0,   // 7FC0 - 7FCF
	0x0657, 0x0431, 0x058D, 0x05A4, 0x0599, 0x058D, 0x058D, 0x0403, 0x0415, 0x0206, 0x0206, 0x04D0, 0x048E, 0x01E6, 0x021E, 0x0109,   // 7FD0 - 7FDF
	0x00E1, 0x015B, 0x052B, 0x049A, 0x0098, 0x0666, 0x0219, 0x05BE, 0x04C7, 0x03E2, 0x0694, 0x0571, 0x0206, 0x01EB, 0x01D6, 0x01D6,   // 7FE0 - 7FEF
	0x01C9, 0x000C, 0x03E7, 0x05DE, 0x02C3, 0x0431, 0xFFFF, 0x02D7, 0x03D6, 0x0415, 0x000C, 0x0152, 0x05DE, 0x0206, 0x05BE, 0x00FD,   // 7FF0 - 7FFF
	0x05D7, 0x02AC, 0xFFFF, 0x0260, 0x0316, 0x0648, 0x0403, 0x019B, 0x019B, 0x019B, 0x011A, 0x011A, 0x014C, 0x04D4, 0x0469, 0x014C,   // 8000 - 800F
	0x0355, 0x0675, 0x02B3, 0x0548, 0x0691, 0x0191, 0x0084, 0x01D2, 0x0607, 0x03BE, 0x03DF, 0x0098, 0x04FB, 0x0431, 0x0215, 0x0240,   // 8010 - 801F
	0x020E, 0x00A7, 0x02AC, 0x02F5, 0x0212, 0x0526, 0x03BB, 0x02E9, 0x03A2, 0x021E, 0x03C9, 0x061F, 0x02E9, 0x0212, 0x02AC, 0x020E,   // 8020 - 802F
	0x05F7, 0x0348, 0x01F6, 0x014C, 0x0648, 0x011E, 0x05DB, 0x00ED, 0x04FE, 0x041E, 0x0607, 0x0098, 0x00F4, 0x00F4, 0x01E6, 0x0191,   // 8030 - 803F
	0x0657, 0xFFFF, 0x038C, 0x00F4, 0x064C, 0x0089, 0x02DB, 0x0651, 0x05F7, 0x056A, 0x02CE, 0x02E4, 0x0657, 0x0394, 0x053F, 0x014C,   // 8040 - 804F
	0x05CB, 0x011A, 0x01BE, 0xFFFF, 0x02C3, 0x01D2, 0x04C1, 0x02D3, 0x03F0, 0x0231, 0x0240, 0x0030, 0x0109, 0x01BE, 0x057E, 0x05BB,   // 8050 - 805F
	0x03F4, 0x00D0, 0xFFFF, 0xFFFF, 0x0548, 0x05FB, 0x00D0, 0x0290, 0x02C3, 0x0290, 0x00D0, 0x02C3, 0x0582, 0x0290, 0x02C3, 0x02C3,   // 8060 - 806F
	0x00D0, 0x000C, 0x04C1, 0x04FE, 0x0548, 0x0290, 0x038C, 0x0657, 0x00F4, 0x0394, 0xFFFF, 0x0212, 0x0548, 0x0548, 0x02E4, 0x05FB,   // 8070 - 807F
	0x05FB, 0x0643, 0x04FB, 0x0507, 0x05DE, 0x0507, 0x04FB, 0x0643, 0x0643, 0x0462, 0x05DE, 0x02B3, 0x0212, 0x042D, 0x0267, 0x0060,   // 8080 - 808F
	0x0186, 0x0109, 0x01FB, 0x0200, 0x05DE, 0x0451, 0x059F, 0x0466, 0x0661, 0x05FE, 0x0130, 0x017D, 0x045D, 0x0179, 0x0070, 0x0587,   // 8090 - 809F
	0x007E, 0x019F, 0x0657, 0x041E, 0x016F, 0x015B, 0x0016, 0x03D2, 0x03C9, 0x0219, 0x0156, 0x0687, 0x05F7, 0x0352, 0x0008, 0x0267,   // 80A0 - 80AF
	0x0441, 0x0196, 0x05FB, 0x057E, 0x05D7, 0x022D, 0x03DF, 0x040A, 0x058D, 0x058D, 0x015B, 0x0267, 0x0231, 0x051E, 0x04BC, 0x065B,   // 80B0 - 80BF
	0x063D, 0x05A4, 0x04BC, 0x057A, 0x0661, 0x011A, 0x00F4, 0x015B, 0x000F, 0x004A, 0x0431, 0x053A, 0x0023, 0x01A2, 0x051E, 0x0691,   // 80C0 - 80CF
	0x0279, 0x0657, 0x0379, 0x03F4, 0x0691, 0x016F, 0x03C9, 0x064C, 0x0594, 0x06AD, 0x03D2, 0x0215, 0x04C1, 0x0657, 0x001F, 0x034F,   // 80D0 - 80DF
	0x0431, 0x01EF, 0x0264, 0x05DE, 0x05E6, 0x05BB, 0x05D2, 0x02E4, 0x0127, 0x0250, 0x02ED, 0x0231, 0x03A6, 0x05CE, 0x03C9, 0x027C,   // 80E0 - 80EF
	0x05DE, 0x01B0, 0x01C5, 0x0186, 0x0127, 0x0657, 0x0224, 0x05B1, 0x05B1, 0x014C, 0x0005, 0x05AC, 0x03E2, 0x0371, 0x0691, 0xFFFF,   // 80F0 - 80FF
	0x0092, 0x053F, 0x0657, 0x00E1, 0x031D, 0x05A4, 0x00E1, 0x05A4, 0x0348, 0x0309, 0x0212, 0x05A4, 0xFFFF, 0x0280, 0x047A, 0x0616,   // 8100 - 810F
	0x0403, 0x0362, 0x032A, 0x039D, 0x02F0, 0x0571, 0x004A, 0x057E, 0x0571, 0x042D, 0x0224, 0x0231, 0x05F7, 0x01E1, 0x00E9, 0x02D3,   // 8110 - 811F
	0x04A3, 0x0548, 0x031D, 0x00C3, 0x04BC, 0x05A4, 0xFFFF, 0x0243, 0x00D9, 0x05B7, 0x05A8, 0x0566, 0x03CE, 0x0092, 0x0369, 0x016F,   // 8120 - 812F
	0x012C, 0x0566, 0x0387, 0x0362, 0x03DF, 0x019F, 0x02F9, 0x02BC, 0x02C3, 0x063D, 0x00E1, 0x0229, 0x02C8, 0x04EC, 0x03DF, 0x0038,   // 8130 - 813F
	0x02F5, 0x03E2, 0x01BE, 0x0243, 0x00BE, 0x00F4, 0x053A, 0x0369, 0x0231, 0x0229, 0x029C, 0x05DB, 0x0000, 0x0451, 0x04BC, 0x00C8,   // 8140 - 814F
	0x016F, 0x016F, 0x0240, 0x015B, 0x040F, 0x0571, 0x0127, 0x03DF, 0x01BE, 0x0694, 0x011E, 0x058A, 0x031D, 0x0469, 0x0675, 0x0657,   // 8150 - 815F
	0x00D5, 0x01A2, 0x03BB, 0x0109, 0x0005, 0x05AC, 0x0362, 0x04D0, 0x04DF, 0x0359, 0x0607, 0x065B, 0x0462, 0x0144, 0x047D, 0x0556,   // 8160 - 816F
	0x05D7, 0x0219, 0x057A, 0x0224, 0x05FB, 0x0215, 0x0133, 0x0030, 0x007E, 0x016F, 0x0594, 0x0379, 0x032D, 0x056A, 0x0532, 0x055E,   // 8170 - 817F
	0x001A, 0x040A, 0x02FD, 0x056A, 0x04CB, 0x0526, 0x0507, 0x0682, 0x0186, 0x05DE, 0x004A, 0x02CE, 0x0212, 0x03DF, 0x05A4, 0x0182,   // 8180 - 818F
	0x02FD, 0x0041, 0xFFFF, 0x007E, 0x02ED, 0x01BE, 0x03C9, 0x00AB, 0x0038, 0x021E, 0x016F, 0x0526, 0x0348, 0x058D, 0x0675, 0x02FD,   // 8190 - 819F
	0x0224, 0x05EA, 0x02FD, 0x0657, 0x05C3, 0x00C3, 0x02D7, 0x054D, 0x03DA, 0x0379, 0x00AB, 0x02CE, 0x00E1, 0x01B6, 0x059F, 0x0532,   // 81A0 - 81AF
	0x0152, 0x0657, 0x0224, 0x04A3, 0x01EF, 0x00E1, 0x0472, 0x05A8, 0x050F, 0x015F, 0x05EA, 0x04A3, 0x01A2, 0x00F4, 0x0280, 0x039D,   // 81B0 - 81BF
	0x0562, 0x02C3, 0x0030, 0x05F2, 0x0248, 0x00A7, 0x05DE, 0x0243, 0x029C, 0x02C3, 0x048A, 0x0562, 0x019F, 0x0403, 0x00E1, 0x0041,   // 81C0 - 81CF
	0x05C7, 0x0362, 0x020E, 0x0616, 0x0594, 0x0038, 0x05AC, 0x0285, 0x029C, 0x05CE, 0x02ED, 0x01EF, 0x060B, 0x02F9, 0x0431, 0x0616,   // 81D0 - 81DF
	0x02F0, 0x0379, 0x060B, 0x008D, 0x040A, 0x0587, 0x01B0, 0x0616, 0x02D7, 0x01B0, 0x0691, 0x0224, 0x038C, 0x00A2, 0x0212, 0x0182,   // 81E0 - 81EF
	0x00A2, 0x032D, 0x038C, 0x0657, 0x0657, 0x0186, 0x0219, 0x011A, 0x0657, 0x05B7, 0x051E, 0x064C, 0x023C, 0x0594, 0x05FB, 0x0070,   // 81F0 - 81FF
	0x05D7, 0x05FB, 0x009C, 0x058D, 0x058D, 0x023C, 0x05FB, 0x05FB, 0x05AC, 0x0240, 0x023C, 0x05A8, 0x04B3, 0x04B3, 0x04B3, 0x023C,   // 8200 - 820F
	0x04C7, 0x0522, 0x04D0, 0x04C7, 0x053A, 0x00F4, 0x0400, 0x0400, 0x01AB, 0x01F2, 0x053A, 0x00B1, 0x04F1, 0x0590, 0x058A, 0x0661,   // 8210 - 821F
	0x00FD, 0x00B1, 0x04A3, 0x05DE, 0xFFFF, 0x03BE, 0x051E, 0x0152, 0x0016, 0x00B1, 0x01CD, 0x0156, 0x0016, 0x0030, 0x02ED, 0x065B,   // 8220 - 822F
	0x0219, 0x005B, 0x02DB, 0x0666, 0x061F, 0x0140, 0x004A, 0x0594, 0x0186, 0x00B1, 0x0215, 0x02ED, 0x01E6, 0x03C9, 0x058D, 0xFFFF,   // 8230 - 823F
	0x016F, 0x061B, 0x0163, 0x02BC, 0x04AE, 0x05FB, 0x02A7, 0x0548, 0xFFFF, 0x057A, 0x004A, 0x0325, 0x037C, 0x0240, 0x0200, 0x04CB,   // 8240 - 824F
	0x0694, 0x0033, 0x0316, 0x011A, 0xFFFF, 0x001A, 0x0070, 0x05DE, 0x0503, 0x005B, 0x0060, 0x02E9, 0x00F0, 0xFFFF, 0x05D7, 0x009C,   // 8250 - 825F
	0xFFFF, 0x00F8, 0x040F, 0x02ED, 0x05DE, 0x0229, 0x0219, 0x020E, 0x0325, 0x0403, 0x02ED, 0x02ED, 0x0079, 0x04E5, 0x018D, 0x02C8,   // 8260 - 826F
	0x0219, 0x0219, 0x048E, 0x05CE, 0x016F, 0x03F4, 0x05CE, 0x05CE, 0x0060, 0x0060, 0x05DE, 0x02B0, 0x0548, 0x0224, 0x0002, 0x0355,   // 8270 - 827F
	0x053F, 0x0224, 0x0229, 0x03DA, 0x0571, 0x05DE, 0x0074, 0x032D, 0x032A, 0x0179, 0x040A, 0x05FB, 0x05FB, 0x04AE, 0x05B1, 0x0130,   // 8280 - 828F
	0x0590, 0x0403, 0x0311, 0x0691, 0x0206, 0x050F, 0x0657, 0x0599, 0x0030, 0x016F, 0x0562, 0x057A, 0x058A, 0x0657, 0x0403, 0x04A3,   // 8290 - 829F
	0x057E, 0x040A, 0x0451, 0x016B, 0x0275, 0x0229, 0x02ED, 0x0666, 0x0212, 0x041E, 0x0403, 0x05CE, 0x015F, 0x000F, 0x046E, 0x05A8,   // 82A0 - 82AF
	0x0212, 0x01F2, 0x01F2, 0x0156, 0x058A, 0x0248, 0x019B, 0x0657, 0x0607, 0x041E, 0x000C, 0x00A7, 0x0316, 0x05CB, 0x015B, 0x0455,   // 82B0 - 82BF
	0x01CD, 0x00D0, 0x05E6, 0x05F7, 0x0033, 0x05DE, 0xFFFF, 0x057A, 0x02BC, 0x03DF, 0x0144, 0x0594, 0x007E, 0x005B, 0x0666, 0x0507,   // 82C0 - 82CF
	0x05DE, 0x05FE, 0x0441, 0x02DB, 0x051E, 0x053F, 0x0109, 0x0332, 0x0422, 0x02BC, 0x044A, 0x0264, 0x034F, 0x03D2, 0x001F, 0x019B,   // 82D0 - 82DF
	0x033B, 0x05DE, 0x05DE, 0x0240, 0x03EC, 0x0476, 0x0279, 0x0666, 0x0379, 0x004A, 0x0045, 0x04A3, 0x042D, 0x05D7, 0x0594, 0x0027,   // 82E0 - 82EF
	0x01E6, 0x05EA, 0x062F, 0x0127, 0x0240, 0x011A, 0x038C, 0x0179, 0x01EF, 0x03F4, 0x031D, 0x016F, 0x04C1, 0x019F, 0x0030, 0x057A,   // 82F0 - 82FF
	0x016F, 0x068C, 0x0316, 0x0152, 0x041A, 0x0316, 0x0316, 0x000F, 0x0691, 0x0348, 0x0691, 0x0109, 0x0098, 0x019B, 0x0231, 0x02E4,   // 8300 - 830F
	0xFFFF, 0x0387, 0xFFFF, 0x05C3, 0x05EA, 0x0427, 0x0186, 0x033F, 0x02BC, 0x045D, 0x05E6, 0x018D, 0x040A, 0x0074, 0x008D, 0x05FB,   // 8310 - 831F
	0x05B7, 0x0691, 0x02D3, 0x058A, 0x0140, 0x0290, 0x0064, 0x0219, 0x00CD, 0x019B, 0x01B0, 0x0311, 0x0070, 0x0224, 0x0224, 0x016F,   // 8320 - 832F
	0x05FB, 0x0666, 0x0691, 0x021E, 0x0206, 0x05E6, 0x0070, 0x014F, 0x045D, 0x0466, 0x009C, 0x0311, 0x054D, 0x065B, 0xFFFF, 0x0666,   // 8330 - 833F
	0x05C7, 0x01FB, 0x027C, 0x0434, 0x0175, 0x00ED, 0x0231, 0x05AC, 0x00B1, 0x0060, 0x0231, 0x014C, 0x0005, 0x04CB, 0x0098, 0x0451,   // 8340 - 834F
	0x0219, 0x0537, 0x0200, 0x03F4, 0x02BC, 0x022D, 0x02AC, 0x045D, 0x067B, 0x00ED, 0x0215, 0x044A, 0x0030, 0x0064, 0x0415, 0x0206,   // 8350 - 835F
	0x0403, 0x00F8, 0xFFFF, 0x045D, 0x020A, 0x05EA, 0x02F9, 0x05EA, 0x040A, 0x022D, 0x0513, 0x05E6, 0x0309, 0x01E6, 0x0661, 0x05D7,   // 8360 - 836F
	0x0130, 0x057A, 0x00A7, 0x012C, 0x016F, 0x0451, 0x05E6, 0x01D6, 0x0030, 0x004D, 0x0607, 0x0109, 0x0556, 0x050F, 0x050F, 0x0092,   // 8370 - 837F
	0x008D, 0x058A, 0x003D, 0x058D, 0x0191, 0x02BC, 0x0400, 0x0666, 0x0348, 0x02BC, 0x067B, 0x0212, 0x0140, 0x042D, 0x049A, 0x0517,   // 8380 - 838F
	0x008D, 0x0163, 0x0240, 0x031D, 0x0325, 0x05AC, 0x0231, 0x0089, 0x05A8, 0x024C, 0x05CE, 0x0548, 0x05F7, 0x00E9, 0x01AB, 0x01C9,   // 8390 - 839F
	0x05F7, 0x00E9, 0x0215, 0x0575, 0x05F7, 0x0399, 0x04AE, 0x0594, 0x02A7, 0x016F, 0x0144, 0x0348, 0x057E, 0x0229, 0x0359, 0x034F,   // 83A0 - 83AF
	0x0257, 0x029F, 0x02C3, 0x04C7, 0x0587, 0x0556, 0x0594, 0x020E, 0x05F7, 0x05EA, 0x05EA, 0xFFFF, 0x00C3, 0x0311, 0x0311, 0x00CD,   // 83B0 - 83BF
	0x05FB, 0x0231, 0x0109, 0x0431, 0x0127, 0x0219, 0x0699, 0x019F, 0x029C, 0x02ED, 0x0240, 0x057A, 0x024C, 0x038C, 0x0294, 0x01D6,   // 83C0 - 83CF
	0x0400, 0x060E, 0x0182, 0x01BE, 0x016F, 0x02F5, 0x007E, 0x00A2, 0x04FE, 0x00BE, 0x0638, 0x0321, 0x0053, 0x000F, 0x02BC, 0x0556,   // 83D0 - 83DF
	0x004A, 0x01C9, 0x001F, 0x041E, 0x0243, 0x058D, 0x041E, 0x0109, 0x0229, 0x0400, 0x00F8, 0x022D, 0x0643, 0x051E, 0x0191, 0x01F2,   // 83E0 - 83EF
	0x019F, 0x02DB, 0x015B, 0x022D, 0x0005, 0x0575, 0x002B, 0x0661, 0x05CE, 0x069D, 0x0219, 0x02D7, 0x0522, 0x04D0, 0x053A, 0x00FD,   // 83F0 - 83FF
	0x01EF, 0x0212, 0x01D6, 0x00E1, 0x052B, 0x00C3, 0x0023, 0x007E, 0x01FB, 0x015B, 0x029F, 0x0403, 0x0325, 0x03F4, 0x057A, 0x00F4,   // 8400 - 840F
	0x049A, 0x01FB, 0x05CE, 0x05DE, 0x053F, 0x0403, 0x0571, 0x0064, 0x0355, 0xFFFF, 0x0566, 0x023C, 0x0544, 0x02F9, 0xFFFF, 0xFFFF,   // 8410 - 841F
	0x0325, 0xFFFF, 0xFFFF, 0x011E, 0x05EA, 0x05EA, 0x05EA, 0x059F, 0x047A, 0x042D, 0x0264, 0x0599, 0x0571, 0x05FB, 0x05FB, 0x016F,   // 8420 - 842F
	0x02C3, 0x05BE, 0x05BE, 0x0359, 0x061F, 0x0587, 0x00C3, 0x059F, 0x05FB, 0x03E2, 0x0316, 0x0005, 0x0144, 0x02F9, 0x05EA, 0x020E,   // 8430 - 843F
	0x01A2, 0x021E, 0x0571, 0x06AD, 0x06AD, 0x0240, 0x001F, 0x0462, 0x058D, 0x05A4, 0x0005, 0x0431, 0x0219, 0x016F, 0x02FD, 0x02FD,   // 8440 - 844F
	0x03D6, 0x0163, 0x01E6, 0x01E6, 0x01EB, 0x05CE, 0x0556, 0x0666, 0x0691, 0x0599, 0x04BC, 0x0186, 0x0406, 0x0231, 0x032A, 0x0200,   // 8450 - 845F
	0x04BC, 0x0400, 0x0186, 0x0127, 0x0661, 0x040A, 0x057A, 0x004A, 0x057A, 0x03BE, 0x0212, 0x01EF, 0x0616, 0x0215, 0x0133, 0x05D7,   // 8460 - 846F
	0x024C, 0x00D0, 0x0434, 0x057A, 0x0594, 0x0290, 0x0548, 0x020A, 0x058D, 0x04C7, 0x0403, 0x02A3, 0x0694, 0x05D7, 0x05FE, 0x031D,   // 8470 - 847F
	0x0607, 0x04D0, 0x0109, 0x0675, 0x01AB, 0xFFFF, 0x0427, 0x0079, 0x0253, 0x0290, 0xFFFF, 0x021E, 0x02E9, 0x057A, 0x03C1, 0xFFFF,   // 8480 - 848F
	0x0503, 0x05E6, 0x04C7, 0x00C3, 0x04C7, 0x0607, 0x064C, 0x02A7, 0x03A6, 0x0325, 0x01D6, 0x0439, 0x050A, 0x05FE, 0x02BC, 0x0240,   // 8490 - 849F
	0x058D, 0x001A, 0x00A7, 0x05BB, 0x0556, 0x02E0, 0x020E, 0x064C, 0x040A, 0x069D, 0x03F9, 0x00E9, 0x05FE, 0x00A7, 0x05FB, 0x0280,   // 84A0 - 84AF
	0x03C5, 0x0400, 0x0400, 0x0352, 0x04F6, 0x058D, 0x015F, 0x0607, 0x0651, 0x0219, 0x0212, 0x0476, 0x005B, 0x0149, 0x032A, 0x01D2,   // 84B0 - 84BF
	0x0513, 0x064C, 0x033F, 0xFFFF, 0x05BB, 0x02E0, 0x058D, 0x019F, 0x02A7, 0x045D, 0x0582, 0x0175, 0x00E9, 0x04C7, 0x0526, 0x02F9,   // 84C0 - 84CF
	0x0466, 0x0517, 0x0594, 0x0023, 0x05D7, 0x01B6, 0x0030, 0x0694, 0x01BA, 0xFFFF, 0x05B7, 0x0064, 0xFFFF, 0x02A3, 0xFFFF, 0x0212,   // 84D0 - 84DF
	0x02BC, 0x0057, 0x02A7, 0x05FB, 0xFFFF, 0x05EA, 0x0348, 0x0115, 0x05B7, 0x058A, 0x054D, 0x0666, 0x03DA, 0x0005, 0x02C3, 0x00D0,   // 84E0 - 84EF
	0x058D, 0x03F4, 0x042D, 0x022D, 0x00C3, 0x0229, 0x057A, 0x055E, 0x0060, 0x05FB, 0x05DE, 0x0212, 0x02CE, 0x0030, 0x02ED, 0x05BB,   // 84F0 - 84FF
	0x004D, 0x063D, 0x02F9, 0x040F, 0x030D, 0x05CE, 0x02B7, 0x0212, 0x0038, 0x01BA, 0x01C9, 0x0109, 0x0507, 0x02ED, 0x04B3, 0x04A8,   // 8500 - 850F
	0x0109, 0x0337, 0x05C7, 0x030D, 0x004A, 0x0109, 0x00E9, 0x0648, 0x0491, 0x05BE, 0x05FB, 0x01EF, 0x000C, 0x032A, 0x02E9, 0x00D9,   // 8510 - 851F
	0x065B, 0x0053, 0x03F9, 0x021E, 0x032A, 0x00D0, 0x0387, 0x0206, 0x024C, 0x05E6, 0x0219, 0x037C, 0x04D0, 0x05E6, 0x0290, 0x008D,   // 8520 - 852F
	0x01EF, 0x049A, 0x0275, 0x040A, 0x0306, 0x005B, 0x061F, 0x040F, 0x012C, 0x02C3, 0x02D7, 0x0275, 0x0002, 0x0030, 0x02BC, 0x057A,   // 8530 - 853F
	0x0212, 0x040A, 0x04C1, 0x0152, 0x0325, 0x03BB, 0x0079, 0x0110, 0x05C7, 0x0224, 0x046E, 0x046E, 0x02B3, 0x05FB, 0x0415, 0x00A7,   // 8540 - 854F
	0x01F2, 0x0219, 0x0309, 0x0607, 0x001F, 0x05F7, 0x0431, 0x02ED, 0x044A, 0x0206, 0x0144, 0x0537, 0x015B, 0x0248, 0x06A5, 0x014F,   // 8550 - 855F
	0x0466, 0x015F, 0x0290, 0x04F1, 0x046E, 0x05CB, 0x05BB, 0x016F, 0x0248, 0x00F8, 0x058A, 0x054D, 0x04FB, 0x059F, 0x058D, 0x05F2,   // 8560 - 856F
	0x057E, 0x04AE, 0x0403, 0x0219, 0x0607, 0x0513, 0x02DB, 0x05FB, 0x0590, 0x0582, 0x0212, 0x01E6, 0x04FB, 0x0104, 0x02B3, 0x05BE,   // 8570 - 857F
	0x0607, 0x05FB, 0x058D, 0x01D2, 0x004A, 0x01D2, 0x0002, 0x057A, 0x0206, 0x057A, 0x0212, 0x00CD, 0x0599, 0x02F0, 0x0337, 0x05DE,   // 8580 - 858F
	0x02B7, 0x021E, 0x0057, 0x04BC, 0x040F, 0x02C3, 0x0264, 0x05FE, 0x00ED, 0x0537, 0x0526, 0x05C3, 0x0030, 0x0638, 0x0513, 0x02C3,   // 8590 - 859F
	0x0152, 0x011E, 0x059F, 0x019F, 0x05A4, 0x04D0, 0x0219, 0x0260, 0x01E6, 0x047A, 0x05A8, 0x05C7, 0x05D7, 0x0012, 0x0503, 0x04D0,   // 85A0 - 85AF
	0x05C7, 0x0138, 0x03F0, 0x057A, 0x0371, 0x00A2, 0x0309, 0x0466, 0x03E7, 0x051E, 0x0403, 0x061B, 0x008D, 0x064C, 0x014C, 0x0379,   // 85B0 - 85BF
	0x05EA, 0x0182, 0x00D0, 0x059F, 0x0403, 0x014F, 0x0219, 0x05BB, 0x0290, 0x0229, 0x0033, 0x0109, 0x032A, 0x02A3, 0x022D, 0x005B,   // 85C0 - 85CF
	0x0332, 0x0427, 0x041A, 0x0594, 0xFFFF, 0x03BB, 0x0594, 0x0507, 0x02FD, 0x05DE, 0x05BB, 0x05A4, 0x02BC, 0x05DE, 0x029C, 0x02B3,   // 85D0 - 85DF
	0x0224, 0x0109, 0x0657, 0x03DF, 0x0532, 0x05D7, 0x0348, 0x01FB, 0x0038, 0x0152, 0x0503, 0x0522, 0x055E, 0x0427, 0x0415, 0x057A,   // 85E0 - 85EF
	0x02E0, 0x0206, 0x04D0, 0x0182, 0x0607, 0xFFFF, 0x02BC, 0x0666, 0x0666, 0x0002, 0x02D7, 0x061B, 0x05BE, 0x008D, 0x029F, 0x020E,   // 85F0 - 85FF
	0x0566, 0x058A, 0x046E, 0x046E, 0x0403, 0x01E1, 0x02ED, 0x0507, 0x055E, 0x0311, 0x0607, 0x03F0, 0x05FB, 0x05C7, 0x0212, 0x0236,   // 8600 - 860F
	0x05BE, 0x0348, 0xFFFF, 0x0507, 0x0236, 0xFFFF, 0x038C, 0x004A, 0x0445, 0x05DE, 0x0594, 0x05FB, 0x0240, 0x02C3, 0x02C3, 0x05E6,   // 8610 - 861F
	0x040F, 0x05EA, 0x02E4, 0x0552, 0x057A, 0x0603, 0x02DB, 0x0431, 0x05D7, 0x0152, 0x032A, 0x02A3, 0x0290, 0x02A3, 0x0212, 0x00F8,   // 8620 - 862F
	0xFFFF, 0x02B3, 0x02B3, 0x054D, 0x0163, 0x0657, 0x057A, 0x0290, 0x0638, 0x01F6, 0x02BC, 0x0212, 0x032A, 0x02B3, 0x01F6, 0x02F9,   // 8630 - 863F
	0x0212, 0x0362, 0x02ED, 0x0219, 0xFFFF, 0xFFFF, 0x02B3, 0x0434, 0x059F, 0x05DE, 0x02F0, 0x0321, 0x003D, 0x01EF, 0x01EF, 0x02ED,   // 8640 - 864F
	0x03B5, 0x02FD, 0x0657, 0x059F, 0x040A, 0x00A7, 0x01EF, 0x05BB, 0x00E9, 0x016F, 0x05BB, 0x05BB, 0x02ED, 0x01EF, 0x05FB, 0x01D2,   // 8650 - 865F
	0x0224, 0x0240, 0x01BE, 0x001F, 0x05CE, 0x0638, 0x0638, 0x0290, 0x0016, 0x058D, 0x04D0, 0x009C, 0x042D, 0x0115, 0x0212, 0x042D,   // 8660 - 866F
	0x011E, 0x04C7, 0xFFFF, 0x0109, 0x0648, 0x04B3, 0x05FB, 0x0179, 0x0691, 0x01E6, 0x0206, 0x0325, 0x0186, 0x050F, 0x0590, 0x0074,   // 8670 - 867F
	0x04C7, 0x05DE, 0x0306, 0x0599, 0x0156, 0x0144, 0x03BE, 0x0098, 0x040A, 0x057E, 0x057E, 0x046E, 0x001A, 0x03DF, 0x0603, 0x0603,   // 8680 - 868F
	0x024C, 0x0403, 0x0441, 0x05E6, 0x0403, 0x0057, 0x05FE, 0x0248, 0x0206, 0x040A, 0x0403, 0x065B, 0x05CB, 0x01D2, 0x034F, 0x0575,   // 8690 - 869F
	0x015F, 0x015F, 0x01CD, 0x0196, 0x061B, 0x016F, 0x0441, 0x0229, 0x016F, 0x0098, 0x012C, 0x001F, 0x0594, 0x0379, 0x052F, 0x042D,   // 86A0 - 86AF
	0x05F7, 0x062F, 0x03F4, 0x0098, 0x05F7, 0x01D6, 0x01C9, 0x0240, 0x02BC, 0x016F, 0x0441, 0x062F, 0x019B, 0x03DF, 0x004A, 0x0594,   // 86B0 - 86BF
	0x0666, 0x0115, 0x003D, 0x0045, 0x019F, 0x0441, 0x0431, 0x04B3, 0x0544, 0x02DB, 0x019F, 0x00F4, 0x019F, 0x05EA, 0x02BC, 0x0092,   // 86C0 - 86CF
	0x0431, 0x034B, 0x0186, 0x00CD, 0x0206, 0x0206, 0x0311, 0x016F, 0x05D2, 0x056A, 0x02D3, 0x0666, 0x05DE, 0x0594, 0x0298, 0x0224,   // 86D0 - 86DF
	0x02BC, 0x05DE, 0x03F4, 0x0212, 0x01C2, 0x04B3, 0x05DE, 0x0575, 0x0348, 0x0427, 0x041A, 0x01B6, 0x0196, 0x0657, 0x030D, 0xFFFF,   // 86E0 - 86EF
	0x0648, 0x0215, 0x0362, 0x04FB, 0x0403, 0x05AC, 0x02D3, 0x042D, 0x04AE, 0x05F2, 0x0215, 0x055E, 0x0089, 0x0012, 0x0144, 0x01C9,   // 86F0 - 86FF
	0x04D0, 0x05BE, 0x0163, 0x04BC, 0x064C, 0x016F, 0x0594, 0x0648, 0x058A, 0x016F, 0x02BC, 0x02A7, 0x0030, 0x00A7, 0x05FE, 0x05F7,   // 8700 - 870F
	0x0229, 0x00F4, 0x05CE, 0x0548, 0x0110, 0x055E, 0x0206, 0x0587, 0x0657, 0x04FE, 0x015B, 0x0240, 0x032A, 0x0403, 0x0403, 0x05FB,   // 8710 - 871F
	0x024C, 0x029C, 0x0325, 0x040F, 0x04FB, 0x058D, 0x02F5, 0x02BC, 0x011A, 0x053F, 0x052B, 0x0294, 0x0179, 0x01C9, 0x05FB, 0x001A,   // 8720 - 872F
	0x015B, 0x03DF, 0x057A, 0x013C, 0x05DE, 0x05FE, 0x0507, 0x0434, 0x040A, 0x046E, 0x0379, 0x0422, 0x057A, 0x02C8, 0x01BE, 0x0571,   // 8730 - 873F
	0x0127, 0x0144, 0x0016, 0x068C, 0x0575, 0x0057, 0x05D2, 0x05EA, 0x01BE, 0x0079, 0xFFFF, 0x029C, 0x0264, 0x0212, 0x05A4, 0x0548,   // 8740 - 874F
	0x0309, 0x05BB, 0x032D, 0x05FB, 0x0229, 0x04C7, 0x05BE, 0x0200, 0x05CE, 0x0033, 0x0462, 0x057A, 0x016F, 0x05FE, 0x031D, 0x057A,   // 8750 - 875F
	0x016F, 0x0469, 0x05A4, 0x05F7, 0x05F7, 0x0316, 0x0590, 0x05EA, 0x04C7, 0x009C, 0x0526, 0x0666, 0x0694, 0x0537, 0x016F, 0x05FE,   // 8760 - 876F
	0x0290, 0x0325, 0x029C, 0x0130, 0x01EF, 0x042D, 0x011A, 0x02BC, 0x01A2, 0x0607, 0x0240, 0x0359, 0x02E9, 0x00C3, 0x045D, 0x05EA,   // 8770 - 877F
	0x021E, 0x0562, 0x02A7, 0x03C9, 0x04FB, 0x058D, 0x058D, 0x058D, 0x05FE, 0x0582, 0x02C3, 0x0503, 0x0016, 0x045D, 0x045D, 0x0212,   // 8780 - 878F
	0x058A, 0x05B7, 0x01C9, 0x041E, 0x05DE, 0x0030, 0x01F2, 0x0526, 0x05DE, 0x0130, 0x0355, 0x01D6, 0x01EF, 0x058D, 0x0306, 0x033F,   // 8790 - 879F
	0x05DE, 0x057E, 0x05EA, 0x0532, 0x05FB, 0x005B, 0xFFFF, 0xFFFF, 0x030D, 0xFFFF, 0x04A8, 0x04C7, 0x0060, 0x0098, 0x0109, 0x000C,   // 87A0 - 87AF
	0x02ED, 0x057A, 0x0657, 0x0526, 0x008D, 0x03E7, 0x0431, 0x03DF, 0x05FB, 0x0219, 0x02F9, 0x02E9, 0x041E, 0x065B, 0x05E6, 0x021E,   // 87B0 - 87BF
	0x04D9, 0x057E, 0x0224, 0x0571, 0x0648, 0x0648, 0x0306, 0x0306, 0x01BE, 0x02CE, 0x0316, 0x058D, 0x00D0, 0x02BC, 0x030D, 0x059F,   // 87C0 - 87CF
	0xFFFF, 0x063D, 0x0311, 0x0599, 0x0348, 0x0691, 0x04FB, 0x042D, 0x052F, 0x0657, 0x03DA, 0x03DA, 0x0224, 0x0431, 0x003D, 0x02CE,   // 87D0 - 87DF
	0x03C5, 0x01B6, 0x058D, 0x0212, 0x0675, 0x0200, 0x015B, 0x02AC, 0x0248, 0x0248, 0x0206, 0x05E6, 0x0079, 0x0224, 0x04A3, 0x044A,   // 87E0 - 87EF
	0x059F, 0x058A, 0x009C, 0x05C7, 0x04FB, 0xFFFF, 0x0092, 0x00F8, 0x02BC, 0x05A4, 0x04A3, 0x05DE, 0x0231, 0x00ED, 0x0079, 0x0403,   // 87F0 - 87FF
	0x0691, 0x0599, 0x04B3, 0x02F9, 0x041E, 0x05EA, 0x0074, 0x02BC, 0x061F, 0x05BE, 0x02C3, 0x0666, 0x061F, 0x05A4, 0x0311, 0x05A4,   // 8800 - 880F
	0x0403, 0x045D, 0x0219, 0x0325, 0x01D2, 0x0466, 0x020E, 0x068C, 0x0229, 0x0041, 0x01D6, 0x0337, 0x0152, 0x02B3, 0x0229, 0x029C,   // 8810 - 881F
	0x032A, 0x02BC, 0x00C3, 0x02BC, 0x042D, 0x038C, 0x02ED, 0x0130, 0x059F, 0x0666, 0x02E4, 0x02BC, 0x02E4, 0x0163, 0x05DB, 0x03DF,   // 8820 - 882F
	0x0445, 0x019F, 0x0243, 0x05EA, 0xFFFF, 0x058D, 0x0057, 0x0431, 0x0434, 0x0130, 0x0057, 0x030D, 0x0431, 0x0229, 0x0666, 0x062F,   // 8830 - 883F
	0x05A4, 0x0200, 0x03B2, 0x03D2, 0x03B2, 0x05A8, 0x065B, 0x0348, 0x014C, 0x0337, 0x0337, 0x04C7, 0x05AC, 0x05CE, 0x0257, 0x05FE,   // 8840 - 884F
	0xFFFF, 0x02DB, 0x05BE, 0x04D0, 0x0594, 0x054D, 0x02E4, 0x0229, 0x0594, 0x05CB, 0x01EF, 0x057A, 0x00FD, 0x009C, 0x057A, 0x00FD,   // 8850 - 885F
	0x0687, 0x01E1, 0x0431, 0x05DE, 0x05DE, 0x004D, 0x0179, 0x05FB, 0x0038, 0x0070, 0x05DE, 0x04A3, 0x008D, 0x016F, 0x01BA, 0x015F,   // 8860 - 886F
	0x04D9, 0x0229, 0x0352, 0x065B, 0x00F4, 0x045A, 0x065B, 0x065B, 0x05A4, 0x0403, 0x05A4, 0x0441, 0x0657, 0x0451, 0x041E, 0x022D,   // 8870 - 887F
	0x024C, 0x05FE, 0x031D, 0x0074, 0x000C, 0x0387, 0x0206, 0x0441, 0x0215, 0x0566, 0x02DB, 0x00F0, 0x001F, 0x03CE, 0x05D7, 0x06AD,   // 8880 - 888F
	0x0030, 0x04AE, 0x0522, 0x0240, 0x01D6, 0x05C3, 0x05B7, 0x064C, 0x05DE, 0x03BE, 0x004A, 0x0109, 0x056A, 0x016F, 0x01BA, 0x0657,   // 8890 - 889F
	0x0657, 0x0441, 0x03C5, 0x05DE, 0x0316, 0xFFFF, 0x0352, 0x0275, 0x05BE, 0x0079, 0x0431, 0x0023, 0x05FB, 0x058D, 0xFFFF, 0x004A,   // 88A0 - 88AF
	0xFFFF, 0x016F, 0x05DE, 0x0098, 0x0279, 0x0451, 0x021E, 0x0215, 0x00E5, 0x0348, 0x0229, 0x014C, 0x0186, 0x0466, 0x0666, 0x01B6,   // 88B0 - 88BF
	0x05E6, 0x0053, 0x02D3, 0xFFFF, 0xFFFF, 0x067B, 0x00F8, 0xFFFF, 0x0294, 0x0267, 0x0387, 0x04D0, 0x0215, 0x0294, 0x0092, 0x02BC,   // 88C0 - 88CF
	0x0243, 0x04BC, 0x03FC, 0x0186, 0x05DE, 0x05FB, 0x008D, 0x02E0, 0x042D, 0x043D, 0x0212, 0x05DE, 0x004D, 0x067B, 0x04EC, 0x049A,   // 88D0 - 88DF
	0x043D, 0x02BC, 0x02C3, 0x02C3, 0x0279, 0x0219, 0x016B, 0x0522, 0x0030, 0x01BA, 0x052B, 0x05FE, 0x02DB, 0x0098, 0x007E, 0x00A2,   // 88E0 - 88EF
	0x0140, 0x0038, 0x02C8, 0x04A8, 0x03D2, 0x03D2, 0x015B, 0x05FE, 0x02F9, 0x01BE, 0x05CE, 0x0130, 0x0537, 0x0657, 0x0240, 0x0403,   // 88F0 - 88FF
	0x0212, 0x0657, 0x01A2, 0x0267, 0xFFFF, 0x0537, 0x04C7, 0x016F, 0x009C, 0x05A4, 0x0033, 0x011A, 0x0294, 0x0133, 0x05B7, 0x05B7,   // 8900 - 890F
	0x01D6, 0x05FE, 0x001F, 0x001F, 0x016F, 0x05FB, 0x0559, 0x05CE, 0x0206, 0x0023, 0x00A7, 0x02FD, 0xFFFF, 0xFFFF, 0x0607, 0x051B,   // 8910 - 891F
	0x019B, 0x00ED, 0x01F6, 0x045D, 0x05FE, 0x0466, 0x0355, 0x0236, 0x0517, 0x0016, 0x0562, 0x0098, 0x0485, 0x0387, 0x05EA, 0x0229,   // 8920 - 892F
	0x040A, 0x01F6, 0x0279, 0x02C3, 0x02A3, 0x02BC, 0x0648, 0x04C7, 0x02FD, 0x05DE, 0x011A, 0x05A4, 0x0594, 0x057A, 0x0038, 0x0060,   // 8930 - 893F
	0x0212, 0x040F, 0x0491, 0x001F, 0x0599, 0xFFFF, 0x0400, 0x0219, 0x0675, 0x0219, 0x06A5, 0x0212, 0x00F4, 0x060B, 0x0152, 0x004A,   // 8940 - 894F
	0x0599, 0x05A8, 0x003D, 0x044A, 0x030D, 0x02A3, 0x000C, 0x0140, 0x0206, 0x0060, 0x050F, 0x039D, 0x0079, 0x02C3, 0x0030, 0x022D,   // 8950 - 895F
	0x00F8, 0x04D0, 0x0522, 0x0030, 0x02A3, 0x0400, 0x0466, 0x0657, 0xFFFF, 0x04D0, 0x056A, 0x04C7, 0x0012, 0x05A4, 0x004A, 0x008D,   // 8960 - 896F
	0x029F, 0x02E4, 0x058D, 0x0594, 0x02A3, 0x0648, 0x00F0, 0xFFFF, 0x0612, 0x04C7, 0x0219, 0x03C5, 0x05DE, 0xFFFF, 0x05CB, 0x058D,   // 8970 - 897F
	0x058D, 0x05D7, 0x0163, 0x0522, 0xFFFF, 0xFFFF, 0x016F, 0x000F, 0x01D6, 0x0212, 0x0212, 0x0219, 0x01AB, 0x0033, 0x05CE, 0x01B6,   // 8980 - 898F
	0x0248, 0x03E2, 0x0316, 0x032A, 0x032A, 0x0337, 0x04C7, 0x04FB, 0x0638, 0x02F9, 0x0248, 0x0348, 0x053F, 0x02C3, 0x05D7, 0x0657,   // 8990 - 899F
	0x024C, 0x058D, 0x04A3, 0x057A, 0x058D, 0x053A, 0x05FB, 0x02A3, 0x0144, 0x0130, 0x041E, 0x03C9, 0x0212, 0x033F, 0x03F4, 0x019B,   // 89A0 - 89AF
	0x0431, 0x0638, 0x022D, 0x01AB, 0x0104, 0x0219, 0x02F9, 0x0431, 0x0219, 0x057A, 0x0248, 0x0431, 0x02F9, 0x02A3, 0x04BC, 0x0109,   // 89B0 - 89BF
	0x01AB, 0x0219, 0x01AB, 0x05CE, 0x01B6, 0x032A, 0x04C7, 0x0079, 0x02A3, 0x0248, 0x0212, 0x058D, 0x0109, 0x053A, 0x05FB, 0x019B,   // 89C0 - 89CF
	0x022D, 0x0431, 0x0224, 0x023C, 0x022D, 0x00D9, 0x0248, 0x0657, 0x0084, 0x0212, 0x019F, 0x00F4, 0x06A5, 0x0109, 0x04A8, 0x01F2,   // 89D0 - 89DF
	0x0434, 0x0186, 0x0657, 0x0229, 0x01B6, 0x0196, 0x00A7, 0x0229, 0x01FB, 0x042D, 0x05AC, 0x0507, 0x0379, 0x0212, 0x02ED, 0x0657,   // 89E0 - 89EF
	0x0666, 0x0030, 0x05AC, 0x01EF, 0x04A8, 0x0196, 0x0657, 0x05C3, 0x00A7, 0x058D, 0x05DE, 0x02BC, 0x0248, 0x058D, 0x05CE, 0x058D,   // 89F0 - 89FF
	0x05CE, 0x05CE, 0x011E, 0x016F, 0x042D, 0x042D, 0x0224, 0x01E6, 0x0212, 0x0152, 0x05C7, 0x0115, 0x01E6, 0x0070, 0x052B, 0x05BB,   // 8A00 - 8A0F
	0x0229, 0x05DE, 0x0451, 0x05C7, 0x05E6, 0x04A3, 0x0403, 0x0566, 0x0212, 0x05C7, 0x05E6, 0x0144, 0x015F, 0x05CB, 0x05D7, 0x04FE,   // 8A10 - 8A1F
	0x04BC, 0x05E6, 0x05A8, 0x0248, 0x059F, 0x0366, 0x008D, 0x05F7, 0x0657, 0x05B1, 0x0156, 0x05A8, 0x0084, 0x04B3, 0x0594, 0x047A,   // 8A20 - 8A2F
	0x0687, 0x05BB, 0x05DE, 0x05DE, 0x0507, 0x0098, 0x01D6, 0x04BC, 0x01D6, 0x05BB, 0x064C, 0x0666, 0x0651, 0x019B, 0x0691, 0x0691,   // 8A30 - 8A3F
	0x0638, 0x019F, 0x016F, 0x0219, 0x011A, 0x02DB, 0x0109, 0x05D2, 0x02BC, 0x0362, 0x03C5, 0x0661, 0x0179, 0x04C7, 0x0240, 0x000C,   // 8A40 - 8A4F
	0x062F, 0x0566, 0x05DE, 0x0431, 0x0643, 0x03F4, 0x0030, 0x05B1, 0x00A7, 0x000F, 0x00ED, 0x069D, 0x052B, 0x0666, 0x00CD, 0x0648,   // 8A50 - 8A5F
	0x05F2, 0x05BB, 0x05C7, 0x05DE, 0x0200, 0x01D6, 0x04C7, 0x0070, 0x0224, 0x04C7, 0x01DD, 0x0070, 0x019B, 0x01B6, 0x0434, 0x0206,   // 8A60 - 8A6F
	0x0229, 0x01F2, 0x0175, 0x0599, 0x0206, 0x04BC, 0x00A2, 0x054D, 0x032A, 0x0638, 0x033F, 0x0144, 0x0206, 0x05CE, 0x05B1, 0x01A2,   // 8A70 - 8A7F
	0x014C, 0x002B, 0x053F, 0x0098, 0x02B3, 0x0666, 0x028A, 0x027C, 0x058A, 0x05FB, 0x0532, 0x0212, 0x0657, 0x0451, 0x0507, 0x02A7,   // 8A80 - 8A8F
	0x0144, 0x028A, 0x0144, 0x04C7, 0x0548, 0x00F4, 0x0023, 0x0079, 0x05F7, 0x01E1, 0x0415, 0x041E, 0x04D4, 0x0005, 0x05FB, 0x059F,   // 8A90 - 8A9F
	0x0092, 0x0229, 0x0594, 0x058A, 0x058A, 0x0182, 0x04FE, 0x0400, 0x0206, 0x0231, 0x04F6, 0x064C, 0x04F6, 0x0130, 0xFFFF, 0x007E,   // 8AA0 - 8AAF
	0x04EC, 0x0229, 0x0264, 0x0431, 0x00D0, 0x059F, 0x050F, 0x0575, 0x05BE, 0x015B, 0x0098, 0x051B, 0x05DE, 0x0352, 0x05E6, 0x0115,   // 8AB0 - 8ABF
	0x03DF, 0x00C8, 0x0079, 0x008D, 0x0687, 0x0212, 0x0403, 0x0522, 0x00BE, 0x057A, 0x0240, 0x0422, 0x0219, 0x0651, 0x061F, 0x0699,   // 8AC0 - 8ACF
	0x040A, 0x068C, 0x02C8, 0x0219, 0x0666, 0x01D2, 0x02F5, 0x04BC, 0x0038, 0x01F6, 0x03E2, 0x05FB, 0x011A, 0x05BB, 0x03E2, 0x04C7,   // 8AD0 - 8ADF
	0x05BE, 0x04C7, 0x020A, 0x01F2, 0x0144, 0x065B, 0x0109, 0x05A4, 0x016F, 0x0400, 0x0548, 0x0219, 0x0403, 0x05FB, 0x0691, 0x00B1,   // 8AE0 - 8AEF
	0x058D, 0x0206, 0x05E6, 0x0005, 0x0594, 0x0359, 0x008D, 0x0163, 0x0666, 0x05D2, 0x05CE, 0x01E1, 0x05BE, 0x0186, 0x03AE, 0x0403,   // 8AF0 - 8AFF
	0x034B, 0x05DB, 0x057A, 0xFFFF, 0x0532, 0x0699, 0x04A3, 0x0219, 0x004A, 0xFFFF, 0x0200, 0x020E, 0x0186, 0x05EA, 0x032A, 0x059F,   // 8B00 - 8B0F
	0x032A, 0x058D, 0x040F, 0x008D, 0x03B5, 0x04FB, 0x0507, 0x001A, 0x0098, 0x040A, 0x04C7, 0x021E, 0x05FE, 0x05A4, 0x05C3, 0x052B,   // 8B10 - 8B1F
	0x05D7, 0x05D7, 0x01EF, 0x05FB, 0x0038, 0x00D0, 0x0422, 0x02BC, 0x0348, 0x0348, 0x04A8, 0x0648, 0x0344, 0x0219, 0x061F, 0x062F,   // 8B20 - 8B2F
	0x02C3, 0x02E9, 0x0057, 0x03BB, 0x01AB, 0x058D, 0x068C, 0x000C, 0x000C, 0x022D, 0x0648, 0x05DE, 0x01EF, 0x021E, 0x030D, 0x0084,   // 8B30 - 8B3F
	0x01C9, 0x01F2, 0x0079, 0x05BB, 0x062A, 0x048E, 0x058D, 0x04B3, 0x0138, 0x0651, 0x0362, 0x02A3, 0x0144, 0x05EA, 0x0248, 0x0212,   // 8B40 - 8B4F
	0x06A9, 0x0224, 0x004A, 0x0206, 0x0675, 0x058A, 0x0219, 0x062F, 0x04C7, 0x0415, 0x0522, 0x0626, 0x0400, 0x04C1, 0x05BE, 0x061B,   // 8B50 - 8B5F
	0x0638, 0x00F8, 0x050F, 0x040A, 0x0212, 0x0224, 0x0231, 0x02C3, 0x03A2, 0x05DE, 0x0002, 0x0638, 0x03DF, 0x0206, 0x01F2, 0x05DE,   // 8B60 - 8B6F
	0x05DE, 0x04A3, 0x0445, 0x03A2, 0x040A, 0x0682, 0x051B, 0x01EF, 0x0661, 0x01D2, 0x0379, 0x05EA, 0x0219, 0x05FB, 0x0219, 0x0206,   // 8B70 - 8B7F
	0x0130, 0x0648, 0x05BE, 0x0612, 0x02B3, 0x04BC, 0x057A, 0x0079, 0x02BC, 0x05DE, 0x0033, 0x0648, 0x05CE, 0x0144, 0x00A2, 0x057A,   // 8B80 - 8B8F
	0x00A2, 0x05D7, 0x0079, 0x0445, 0x05E6, 0x02A3, 0x008D, 0x020E, 0x0648, 0x01FB, 0x0612, 0x05DE, 0x00F8, 0x0638, 0x05CE, 0x0130,   // 8B90 - 8B9F
	0x05CE, 0x0212, 0x011E, 0x016F, 0x0451, 0x0212, 0x0229, 0x01E6, 0x052B, 0x0445, 0x04A3, 0x0403, 0x0566, 0x05C7, 0x05DE, 0x05C7,   // 8BA0 - 8BAF
	0x0212, 0x0451, 0x021E, 0x0206, 0x03BB, 0x0240, 0x05CB, 0x0366, 0x05BB, 0x0144, 0x02F5, 0x05B1, 0x04FE, 0x0163, 0x04B3, 0x0156,   // 8BB0 - 8BBF
	0x0248, 0x0651, 0x019F, 0x01D6, 0x03F4, 0x069D, 0x0657, 0x05B1, 0x062F, 0x0507, 0x064C, 0x0109, 0x0661, 0x00CD, 0x0431, 0x0643,   // 8BC0 - 8BCF
	0x0030, 0x05DE, 0x05DE, 0x028A, 0x02B3, 0x04C7, 0x01A2, 0x04C7, 0x0229, 0x0206, 0x0092, 0x0666, 0x04BC, 0x01F2, 0x00F4, 0x019B,   // 8BD0 - 8BDF
	0x0434, 0x01B6, 0x05C7, 0x05DE, 0x0651, 0x0175, 0x0599, 0x0070, 0x020A, 0x05BB, 0x0661, 0x0229, 0x058A, 0x05FB, 0x0415, 0x058A,   // 8BE0 - 8BEF
	0x0182, 0x05F7, 0x0206, 0x028A, 0x04F6, 0x04FE, 0x0146, 0x0422, 0x0666, 0x0699, 0x03AE, 0x0130, 0x068C, 0x015B, 0x0264, 0x057A,   // 8BF0 - 8BFF
	0x05FB, 0x04B7, 0x04BC, 0x0115, 0x0079, 0x02C8, 0x0687, 0x050F, 0x0522, 0x04BC, 0x05DE, 0x034B, 0x008D, 0x011A, 0x0200, 0x0219,   // 8C00 - 8C0F
	0x05A4, 0x05C3, 0x05DB, 0x057A, 0x0144, 0x05FB, 0x05BE, 0x0079, 0x0691, 0x0005, 0x05CE, 0x0109, 0x032A, 0x03E2, 0x05BB, 0x0348,   // 8C10 - 8C1F
	0x00F8, 0x0507, 0x05A4, 0x05D7, 0x001A, 0x04C7, 0x040A, 0x032A, 0x022D, 0x030D, 0x0648, 0x0219, 0x0344, 0x0522, 0x0219, 0x0415,   // 8C20 - 8C2F
	0x02A3, 0x0400, 0x0248, 0x05CE, 0x040A, 0x0638, 0x008D, 0x019F, 0x040A, 0x01E6, 0x05CB, 0x0248, 0x01E6, 0x01C9, 0x01E6, 0x0403,   // 8C30 - 8C3F
	0x058D, 0x020E, 0x02CE, 0x01C9, 0x0130, 0x02E4, 0x012C, 0x021E, 0x0403, 0x0098, 0x0163, 0x0104, 0x0571, 0x0030, 0x04D0, 0x0594,   // 8C40 - 8C4F
	0x0163, 0x0657, 0x0657, 0x05CE, 0x05CE, 0x04C7, 0x00A7, 0x0206, 0x0562, 0x05DE, 0x0562, 0x05DE, 0x0219, 0x000F, 0x01EB, 0x0144,   // 8C50 - 8C5F
	0x00D9, 0x0599, 0x01FB, 0x0219, 0x0267, 0x0175, 0x0431, 0x016F, 0x058D, 0x0041, 0x01D2, 0x05FB, 0x0666, 0x0215, 0x015F, 0x058D,   // 8C60 - 8C6F
	0x01EF, 0x057E, 0x01FB, 0x0041, 0x0109, 0x0694, 0x015F, 0x05DE, 0x0657, 0x001F, 0x0074, 0x01C9, 0x03DF, 0x0352, 0x03DF, 0x019B,   // 8C70 - 8C7F
	0x0140, 0x05F7, 0x0115, 0x0348, 0x04FB, 0x05B7, 0x01FB, 0x0294, 0x01D6, 0x01D6, 0x0348, 0x0005, 0x0316, 0x02BC, 0x0379, 0x0030,   // 8C80 - 8C8F
	0x05FB, 0x0215, 0x0559, 0x0316, 0x03DF, 0x058D, 0x0144, 0x0240, 0x0348, 0x00A7, 0x0522, 0x01FB, 0x0431, 0x0023, 0x064C, 0x05FE,   // 8C90 - 8C9F
	0x016F, 0x0053, 0x0196, 0x052F, 0x05DE, 0x01CD, 0x0571, 0x03F0, 0x020E, 0x0152, 0x0522, 0x01AB, 0x061F, 0x0657, 0x014C, 0x0666,   // 8CA0 - 8CAF
	0x04C7, 0x0030, 0x0691, 0x014C, 0x01B6, 0x03E2, 0x0033, 0x0309, 0x00F0, 0x04C1, 0x028A, 0x015B, 0x0544, 0x05DE, 0x0098, 0x0316,   // 8CB0 - 8CBF
	0x01D6, 0x0030, 0x02ED, 0x02D7, 0x0206, 0x0175, 0x03E2, 0x0691, 0x0215, 0x05BB, 0x0622, 0x0224, 0x0175, 0x0616, 0x0219, 0x05EA,   // 8CC0 - 8CCF
	0x05C7, 0x064C, 0x04B3, 0x0041, 0x0041, 0x042D, 0x04B3, 0x00B1, 0x0616, 0x0661, 0x029F, 0x0612, 0x04FB, 0x008D, 0x04A8, 0x053A,   // 8CD0 - 8CDF
	0x03D2, 0x0191, 0x0594, 0x0309, 0x0219, 0x050F, 0x016F, 0x00F4, 0x00D0, 0x00D0, 0x0657, 0x0212, 0x063D, 0x0130, 0x022D, 0x05B1,   // 8CE0 - 8CEF
	0x04F1, 0x0607, 0x001F, 0x060E, 0x029F, 0x0163, 0x005B, 0x0212, 0x04C1, 0x0002, 0x0675, 0x016F, 0x019B, 0x047D, 0x061F, 0x02CE,   // 8CF0 - 8CFF
	0x057A, 0x0012, 0x008D, 0x0675, 0x0657, 0x0682, 0x0038, 0x0607, 0x062A, 0x0522, 0x0612, 0x05CE, 0xFFFF, 0x04A3, 0x0571, 0x05EA,   // 8D00 - 8D0F
	0x022D, 0x0179, 0x0594, 0x0616, 0x0030, 0x0130, 0x04D0, 0x05CE, 0xFFFF, 0x05BE, 0x02E4, 0x0179, 0x0616, 0x0023, 0x064C, 0x016F,   // 8D10 - 8D1F
	0x05FE, 0x0196, 0x0053, 0x061F, 0x0594, 0x0012, 0x063D, 0x020E, 0x0657, 0x0152, 0x0522, 0x03F0, 0x0033, 0x019B, 0x0666, 0x01AB,   // 8D20 - 8D2F
	0x014C, 0x0219, 0x0030, 0x04C7, 0x0544, 0x01B6, 0x028A, 0x00F0, 0x0316, 0x015B, 0x01D6, 0x05DE, 0x0622, 0x0657, 0x0215, 0x0206,   // 8D30 - 8D3F
	0x0691, 0x02D7, 0x02ED, 0x0616, 0x0691, 0x0175, 0x022D, 0x042D, 0x064C, 0x029F, 0x04B3, 0x016F, 0x0130, 0x0212, 0x04D0, 0x04A8,   // 8D40 - 8D4F
	0x00CD, 0x0030, 0x0661, 0x0191, 0x03D2, 0x00F4, 0x029F, 0x0163, 0x0682, 0x016F, 0x0675, 0x047D, 0x061F, 0x05CE, 0x0612, 0x0607,   // 8D50 - 8D5F
	0x062A, 0x04A3, 0x05EA, 0x0179, 0x0098, 0x058D, 0x04B3, 0x0359, 0x05B1, 0x058D, 0x0092, 0x01D6, 0x0092, 0x0648, 0x0590, 0x0526,   // 8D60 - 8D6F
	0x0699, 0x0699, 0x02BC, 0x023C, 0x016F, 0x0643, 0x0179, 0x0403, 0x04A3, 0x0427, 0x041E, 0x0594, 0x00CD, 0x0248, 0x041E, 0x0098,   // 8D70 - 8D7F
	0x00CD, 0x008D, 0x008D, 0x011A, 0x0240, 0x0084, 0x0109, 0x048E, 0x0638, 0x0666, 0x0603, 0x0431, 0x0229, 0x0098, 0x00A7, 0x01A2,   // 8D80 - 8D8F
	0x05C3, 0x0691, 0x053F, 0x0140, 0x02D3, 0x0179, 0x0517, 0x00D9, 0x058D, 0x0643, 0x0507, 0x05E6, 0x0240, 0x0219, 0x0439, 0x0526,   // 8D90 - 8D9F
	0x00C8, 0x00E1, 0x02ED, 0x0431, 0x00F8, 0x042D, 0x0691, 0x0537, 0x0431, 0x0098, 0x0200, 0x0415, 0x0415, 0x05D7, 0x061B, 0x0603,   // 8DA0 - 8DAF
	0xFFFF, 0x0612, 0x0612, 0x069D, 0x03BE, 0x001F, 0x0279, 0x01D6, 0x013C, 0x0248, 0x016F, 0x008D, 0x0219, 0x0156, 0x0657, 0x051B,   // 8DB0 - 8DBF
	0x0603, 0x03BE, 0x0403, 0x0603, 0x040F, 0x0566, 0x051E, 0x05DE, 0x037C, 0x02DB, 0x031D, 0x000F, 0x011A, 0x0279, 0x0566, 0x0215,   // 8DC0 - 8DCF
	0x00CD, 0x03CE, 0x0406, 0x0666, 0x0240, 0x011A, 0x0657, 0x016F, 0x03C5, 0x0240, 0x04A3, 0x004A, 0x0379, 0x0240, 0x02BC, 0x018D,   // 8DD0 - 8DDF
	0x05DE, 0x0212, 0x00F0, 0x0594, 0x0224, 0x0140, 0x00A7, 0x0434, 0x027C, 0x066F, 0x01B6, 0x0427, 0x0290, 0x0599, 0x0098, 0x02ED,   // 8DE0 - 8DEF
	0x002B, 0x0657, 0x0215, 0x053F, 0x0053, 0x0219, 0x00ED, 0x0415, 0x0030, 0x0594, 0x0140, 0x0212, 0x0240, 0x0212, 0x04D0, 0x0556,   // 8DF0 - 8DFF
	0x00A7, 0x05AC, 0x038C, 0x059F, 0x004A, 0x05C3, 0x043D, 0x034B, 0x04D0, 0x02C8, 0x05F2, 0x0224, 0x00A2, 0x059F, 0xFFFF, 0x051B,   // 8E00 - 8E0F
	0x0219, 0x0403, 0x0587, 0x057A, 0x00C8, 0x0229, 0x0212, 0x038C, 0x0240, 0x0240, 0x02F5, 0x02ED, 0x02B7, 0x01F6, 0x0240, 0x0098,   // 8E10 - 8E1F
	0x0571, 0x0434, 0x0537, 0x004A, 0x069D, 0x041A, 0x0403, 0x00D9, 0x0694, 0x0053, 0x0694, 0x03C5, 0x0657, 0x0651, 0x0110, 0x0657,   // 8E20 - 8E2F
	0x05FB, 0x0140, 0x013C, 0x00C3, 0x05F2, 0x065B, 0x0109, 0x062F, 0x008D, 0x00AB, 0x0219, 0x01A2, 0x0526, 0x0240, 0x016F, 0x069D,   // 8E30 - 8E3F
	0x011A, 0x03E2, 0x0462, 0x03AE, 0x0537, 0x0070, 0x055E, 0x0219, 0x00FD, 0x00E9, 0x058D, 0x051B, 0x040F, 0x0638, 0x0110, 0x0537,   // 8E40 - 8E4F
	0x0212, 0x038C, 0x03C5, 0x02E0, 0x0638, 0x0030, 0x009C, 0x02ED, 0x02CE, 0x00D9, 0x0526, 0x00F0, 0x0507, 0x058D, 0x0290, 0x0212,   // 8E50 - 8E5F
	0x0657, 0x040F, 0x0109, 0x030D, 0x0694, 0x02C3, 0x002B, 0x061B, 0x037C, 0x003D, 0x055E, 0x0240, 0x0104, 0x006B, 0x0594, 0x0152,   // 8E60 - 8E6F
	0x00A7, 0x065B, 0x013C, 0x004A, 0x00D9, 0x069D, 0x0248, 0x0248, 0x02D7, 0x051B, 0x0415, 0x0415, 0x0400, 0x02CE, 0x013C, 0x00DC,   // 8E70 - 8E7F
	0x028A, 0x061B, 0x051B, 0x0030, 0x0030, 0x0666, 0x0240, 0x00A7, 0x0415, 0x013C, 0x00A2, 0x0212, 0x058A, 0x0603, 0x037C, 0x02D7,   // 8E80 - 8E8F
	0x02D3, 0x0657, 0x02BC, 0x0657, 0x0079, 0x00A7, 0x0133, 0x057A, 0x02E4, 0x02D7, 0x0594, 0x057A, 0x06A0, 0x02A3, 0x05A4, 0x0445,   // 8E90 - 8E9F
	0x05A4, 0x038C, 0x051B, 0x0431, 0x0229, 0x00DC, 0x06A0, 0x058D, 0x0290, 0x0248, 0x02D7, 0x04BC, 0x0196, 0x00F4, 0xFFFF, 0x0431,   // 8EA0 - 8EAF
	0x0537, 0x0140, 0x0140, 0x0196, 0x02A7, 0xFFFF, 0x02F9, 0x0002, 0x0212, 0x0240, 0x0526, 0xFFFF, 0xFFFF, 0x05CE, 0xFFFF, 0x025B,   // 8EB0 - 8EBF
	0x0431, 0x02E9, 0x02AC, 0x0140, 0x0657, 0xFFFF, 0x0537, 0x00FD, 0xFFFF, 0x05FB, 0x0089, 0x05CB, 0x01B6, 0x024C, 0x057A, 0x0603,   // 8EC0 - 8ECF
	0x05A8, 0x0109, 0x05BE, 0x0152, 0x0451, 0x04A3, 0x040F, 0x04D0, 0x0562, 0x008D, 0x00F0, 0x0144, 0x0352, 0x0403, 0x0316, 0x0469,   // 8ED0 - 8EDF
	0x0451, 0x040A, 0x0675, 0x01E6, 0x01EF, 0x0431, 0x0200, 0x0109, 0x02DB, 0x00F0, 0x000C, 0x064C, 0x0152, 0x028A, 0x0008, 0x03DA,   // 8EE0 - 8EEF
	0x0023, 0x019F, 0x019F, 0x03CE, 0x0666, 0x045D, 0x0144, 0x000F, 0x0661, 0x0657, 0x05D7, 0x0264, 0x05DE, 0x0422, 0x04C7, 0x03F4,   // 8EF0 - 8EFF
	0x014C, 0x0427, 0x0240, 0x0224, 0x01B0, 0x02ED, 0x0253, 0x0434, 0x0661, 0x060E, 0x0657, 0x0240, 0x02C8, 0x05FB, 0x04AE, 0x05F7,   // 8F00 - 8F0F
	0x01FB, 0x0607, 0x0648, 0x0571, 0x016F, 0x0422, 0x0661, 0x0379, 0x02DB, 0x0648, 0x0638, 0x02C8, 0x0691, 0x0206, 0x0575, 0x00C8,   // 8F10 - 8F1F
	0x01BE, 0x0257, 0x05DE, 0x03DA, 0x040A, 0x01BA, 0x037C, 0x03F4, 0x01AB, 0x0023, 0x02F5, 0x03C1, 0x02C8, 0x0469, 0x0462, 0x0212,   // 8F20 - 8F2F
	0x05D2, 0x0594, 0x00B1, 0x00D5, 0x00C3, 0x0186, 0x05F7, 0x01E6, 0x04D0, 0x016F, 0x0691, 0x016F, 0x057E, 0x0027, 0x0638, 0x05FB,   // 8F30 - 8F3F
	0x057E, 0x052B, 0x019F, 0x064C, 0x0590, 0x05FE, 0x02ED, 0x023C, 0x0084, 0x0675, 0x057A, 0x020A, 0xFFFF, 0x0089, 0x0224, 0x0638,   // 8F40 - 8F4F
	0x0400, 0x02AC, 0x015F, 0x0152, 0x02D7, 0x0186, 0x048E, 0x0257, 0x01FB, 0x05DE, 0x0212, 0x0138, 0x014C, 0x05FB, 0x0594, 0x01E6,   // 8F50 - 8F5F
	0x02B3, 0x03D2, 0x02BC, 0x02BC, 0x02ED, 0x02D7, 0x0089, 0x05CB, 0x01B6, 0x05BE, 0x00F0, 0x0451, 0x0675, 0x0144, 0x02F5, 0x0469,   // 8F60 - 8F6F
	0x01E6, 0x019F, 0x0264, 0x02ED, 0x0661, 0x0657, 0x05DE, 0x01EF, 0x064C, 0x02BC, 0x05D7, 0x0422, 0x04C7, 0x060E, 0x0657, 0x0224,   // 8F70 - 8F7F
	0x0661, 0x0434, 0x02ED, 0x0224, 0x0648, 0x016F, 0x02C8, 0x037C, 0x0023, 0x0206, 0x01BA, 0x0575, 0x02C8, 0x00C8, 0x0691, 0x00D5,   // 8F80 - 8F8F
	0x016F, 0x0212, 0x057E, 0x04D0, 0x03D2, 0x05FE, 0x0590, 0x0638, 0x02ED, 0x0648, 0x02D7, 0x05A8, 0x019F, 0x00CD, 0x00CD, 0x03DF,   // 8F90 - 8F9F
	0x06A5, 0x0033, 0x029C, 0x029C, 0x00CD, 0x05C3, 0x0016, 0x0033, 0x0033, 0x0033, 0xFFFF, 0x0033, 0x0016, 0x00CD, 0x0033, 0x0033,   // 8FA0 - 8FAF
	0x008D, 0x0466, 0x039D, 0x039D, 0x064C, 0x00C8, 0x00C8, 0xFFFF, 0x0455, 0x0033, 0x0033, 0xFFFF, 0xFFFF, 0x02CE, 0x00ED, 0x0079,   // 8FB0 - 8FBF
	0x0179, 0x040A, 0x05FB, 0x05FB, 0x0403, 0x05C7, 0x05DE, 0x01BE, 0x0309, 0x0403, 0x060B, 0x0575, 0xFFFF, 0x0687, 0x05EA, 0x0537,   // 8FC0 - 8FCF
	0x0607, 0x022D, 0x01CD, 0x05CB, 0x0152, 0x058A, 0x051B, 0x0144, 0x01C5, 0x0648, 0xFFFF, 0x022D, 0x05FE, 0x057A, 0x02C3, 0x0098,   // 8FD0 - 8FDF
	0x0089, 0x0379, 0x053F, 0x0657, 0x05DE, 0x0236, 0x0215, 0x008D, 0x00F0, 0x014C, 0x0109, 0x03F9, 0x0575, 0x011A, 0x061F, 0x052B,   // 8FE0 - 8FEF
	0x04D0, 0x0566, 0xFFFF, 0x0231, 0x0206, 0x054D, 0x05F7, 0x032A, 0x002B, 0x0212, 0x0355, 0x05DE, 0x0229, 0x0682, 0x02D3, 0x05C7,   // 8FF0 - 8FFF
	0x055E, 0x04FE, 0x04C7, 0x052B, 0x03C9, 0x01EB, 0x0379, 0x013C, 0x0236, 0x05BE, 0x05C7, 0x004D, 0x05F7, 0x059F, 0x042D, 0x0552,   // 9000 - 900F
	0x0666, 0x042D, 0x0109, 0x0109, 0x0556, 0x0231, 0x0537, 0x012C, 0x05DE, 0x0648, 0x054D, 0x01B0, 0x058A, 0x04C7, 0x0092, 0x0507,   // 9010 - 901F
	0x061B, 0x043D, 0x0163, 0x02C3, 0x0517, 0x0206, 0x02BC, 0xFFFF, 0x06A5, 0x0027, 0x00E9, 0x0248, 0x002B, 0x01FB, 0x00F0, 0x02ED,   // 9020 - 902F
	0x05F7, 0x0661, 0x022D, 0x05FB, 0x00C8, 0x0290, 0x057A, 0x0537, 0x05DE, 0x00ED, 0x05FE, 0x02F9, 0x0030, 0x03AE, 0x05FB, 0x00F8,   // 9030 - 903F
	0x050F, 0x013C, 0x050F, 0x05CE, 0x00B1, 0x0098, 0x0537, 0x05FB, 0x04C7, 0x064C, 0x05F7, 0x0607, 0x0144, 0x0033, 0x01BE, 0x0144,   // 9040 - 904F
	0x0590, 0x0200, 0x042D, 0x00FD, 0x00ED, 0x057A, 0xFFFF, 0x05DE, 0x019B, 0x05D7, 0x00A7, 0x02E0, 0x05C7, 0x051B, 0x0109, 0x0098,   // 9050 - 905F
	0x05FE, 0x0507, 0x051B, 0x040A, 0xFFFF, 0x05D7, 0x01AB, 0x063D, 0x000C, 0x04C7, 0x0064, 0x0507, 0x0507, 0x061B, 0x0648, 0x013C,   // 9060 - 906F
	0x0657, 0x02E9, 0x0098, 0x00E9, 0x02D7, 0x06A9, 0x044A, 0x040A, 0x05BE, 0x05FB, 0x05DE, 0x058A, 0x02CE, 0x0240, 0x04C7, 0x0030,   // 9070 - 907F
	0x05D7, 0x0309, 0x05A4, 0x050F, 0x01FB, 0x0638, 0x0104, 0x014C, 0x0332, 0x0033, 0x0033, 0x029C, 0x02BC, 0x05FE, 0x05F7, 0x02F9,   // 9080 - 908F
	0x02BC, 0x05DE, 0x0548, 0x0104, 0x0403, 0x05F2, 0x04A3, 0x01C9, 0x05FB, 0x0311, 0x0466, 0x0427, 0xFFFF, 0x028A, 0x016F, 0x025B,   // 9090 - 909F
	0x0041, 0x0156, 0x05AC, 0x0352, 0xFFFF, 0x04BC, 0x001A, 0x05FE, 0x00E5, 0x020E, 0x05A4, 0x001A, 0x058A, 0x0240, 0x05F7, 0x01C9,   // 90A0 - 90AF
	0x051E, 0x042D, 0x0030, 0x03DF, 0x0045, 0x04AE, 0x0023, 0x056A, 0x0109, 0x0699, 0x05DB, 0x02D7, 0x028A, 0x01B6, 0x0666, 0x04C7,   // 90B0 - 90BF
	0x0279, 0x05FB, 0x0175, 0x01D6, 0x041A, 0x0657, 0x0212, 0x05C7, 0x01EB, 0x05AC, 0x0224, 0x058D, 0x01B6, 0x03AE, 0x02A7, 0x0215,   // 90C0 - 90CF
	0x0280, 0x0651, 0x02A7, 0x0607, 0x05CE, 0x0092, 0x012C, 0x058D, 0x02FD, 0x016F, 0x058A, 0x016F, 0x0182, 0x01D2, 0x02A7, 0x0215,   // 90D0 - 90DF
	0x0191, 0x024C, 0x05EA, 0x004A, 0x058D, 0x0023, 0x02BC, 0x0607, 0x004D, 0x059F, 0x0403, 0x03DF, 0x0422, 0x01BE, 0xFFFF, 0x0522,   // 90E0 - 90EF
	0x0699, 0x03F4, 0x029F, 0x0379, 0x008D, 0x05F7, 0x004D, 0x0599, 0x00F4, 0x0240, 0x05F2, 0x0415, 0x05DE, 0x0130, 0x05CE, 0x031D,   // 90F0 - 90FF
	0x0476, 0x0023, 0x0144, 0x05FB, 0x0243, 0x05FB, 0x0607, 0x01EB, 0x0290, 0x0599, 0x0599, 0x0503, 0x0526, 0x033F, 0x058D, 0x0466,   // 9100 - 910F
	0x00A7, 0x0691, 0x0699, 0x0240, 0x058A, 0x0599, 0x0607, 0x01D2, 0x05F2, 0x0030, 0x0316, 0x0084, 0x016F, 0x02CE, 0x05E6, 0x0675,   // 9110 - 911F
	0x01EF, 0x0415, 0x05CE, 0x063D, 0x0152, 0x058A, 0x05BB, 0x0104, 0x0030, 0x05A8, 0x0030, 0x006B, 0x057A, 0x0651, 0x0316, 0x04A3,   // 9120 - 912F
	0x02D7, 0x03F9, 0x00F4, 0x0325, 0x05DB, 0x0060, 0x0280, 0x0163, 0x0325, 0x0699, 0x028A, 0x02C3, 0x0612, 0x0079, 0x05F7, 0x0403,   // 9130 - 913F
	0x05CE, 0x0079, 0x00E9, 0x02DB, 0x01FB, 0x058D, 0x0163, 0x0612, 0x02BC, 0x05F7, 0x011E, 0x042D, 0x068C, 0x03D2, 0x0661, 0x05DE,   // 9140 - 914F
	0x0179, 0x05FB, 0x023C, 0x05CE, 0x06A5, 0x0316, 0x00F4, 0x05BB, 0x0552, 0x064C, 0x015F, 0xFFFF, 0xFFFF, 0x0607, 0x051E, 0x053A,   // 9150 - 915F
	0x0406, 0x0566, 0x06AD, 0x01C9, 0x019F, 0x0507, 0x014F, 0x00A2, 0x00F0, 0x033F, 0x02AC, 0x00C8, 0x00A2, 0x05F7, 0x054D, 0x0657,   // 9160 - 916F
	0x0594, 0x021E, 0x0092, 0x05E6, 0x0556, 0x0224, 0x031D, 0x0279, 0x050A, 0x02B3, 0x0400, 0x06A5, 0x01C5, 0x05CE, 0x04C7, 0x0381,   // 9170 - 917F
	0x057A, 0x02ED, 0x02A3, 0x05CE, 0x052B, 0x03D2, 0x0638, 0x00C3, 0x0522, 0x06A5, 0x00C8, 0x00D9, 0x0294, 0x0537, 0x0594, 0x0130,   // 9180 - 918F
	0x01EF, 0x05BB, 0x05AC, 0x0522, 0x042D, 0x00C3, 0x0607, 0x014F, 0x0264, 0x0503, 0x032A, 0x0434, 0x00A2, 0x00E9, 0x0607, 0x05F2,   // 9190 - 919F
	0x0008, 0x062F, 0x01C5, 0x0526, 0x021E, 0x03E7, 0x02AC, 0x05FB, 0x02BC, 0x061B, 0x02AC, 0x05DE, 0x021E, 0x004D, 0x0224, 0x058D,   // 91A0 - 91AF
	0x0522, 0x014F, 0x039D, 0x05DE, 0x02BC, 0x0240, 0x05CE, 0x05DE, 0x0381, 0x0466, 0x05C7, 0x00A2, 0x05CE, 0x02DB, 0x032A, 0x032A,   // 91B0 - 91BF
	0x0381, 0x05A8, 0x0224, 0x04C7, 0x032A, 0x05CE, 0x0033, 0x0053, 0x04C7, 0x05F7, 0x04C7, 0x04C7, 0x02BC, 0x065B, 0x05DB, 0x02C8,   // 91C0 - 91CF
	0x02BC, 0x022D, 0x022D, 0x0172, 0x05DE, 0x02CE, 0x00FD, 0x0643, 0x011E, 0x02BC, 0x042D, 0x01D6, 0x016F, 0x064C, 0x0657, 0x000F,   // 91D0 - 91DF
	0x02F0, 0x016F, 0x0355, 0x0115, 0x04A3, 0x0415, 0x0275, 0x00B1, 0x0691, 0x0152, 0x05FB, 0x01F2, 0x01C9, 0x0196, 0x0403, 0x0311,   // 91E0 - 91EF
	0x0219, 0x0109, 0x04FB, 0x058D, 0x05DE, 0x0074, 0x051B, 0x0556, 0x058D, 0x03B2, 0x040A, 0xFFFF, 0x0219, 0x03DF, 0x05DB, 0x05E6,   // 91F0 - 91FF
	0x000F, 0x0156, 0x008D, 0x0219, 0x0552, 0x0603, 0x05CE, 0x016F, 0x004D, 0x0352, 0x05A8, 0x0144, 0x0248, 0x013C, 0x019B, 0x05E6,   // 9200 - 920F
	0x040A, 0x0016, 0x0212, 0x0451, 0x0084, 0x0399, 0x015F, 0x0607, 0x05DE, 0x041E, 0x03DF, 0x01BE, 0x01E6, 0x05E6, 0x024C, 0x04C7,   // 9210 - 921F
	0x05DE, 0x065B, 0x038C, 0x0175, 0x045A, 0x020E, 0x051E, 0x025B, 0xFFFF, 0x02ED, 0xFFFF, 0xFFFF, 0x0140, 0x0691, 0x0379, 0x0556,   // 9220 - 922F
	0x04C7, 0x033B, 0x019F, 0x0264, 0x02DB, 0x0045, 0x05DE, 0x019F, 0x000F, 0x03DF, 0x05FB, 0x04FB, 0x06AD, 0x004D, 0x05F7, 0x0110,   // 9230 - 923F
	0x0215, 0x064C, 0x04C7, 0x04C7, 0x0544, 0x0240, 0x0638, 0x051B, 0x0566, 0x05BE, 0x0643, 0x001F, 0x01D6, 0x0030, 0x04C1, 0x00A7,   // 9240 - 924F
	0x04C7, 0x004A, 0x0666, 0x0098, 0x060B, 0x03F9, 0x054D, 0x040A, 0x016F, 0x0633, 0x02E0, 0x040A, 0x016F, 0x02BC, 0x0603, 0x03DF,   // 9250 - 925F
	0x05D2, 0x0016, 0x004A, 0x0229, 0x019B, 0x04D0, 0x0651, 0x034F, 0x0379, 0x058D, 0x0109, 0x0215, 0x034F, 0x0522, 0x04BC, 0x05DE,   // 9260 - 926F
	0x04FB, 0x028A, 0x0250, 0x0023, 0x0219, 0x054D, 0x05AC, 0x01E6, 0x0224, 0x0098, 0x014C, 0x0186, 0x0045, 0x04C7, 0x034B, 0x0215,   // 9270 - 927F
	0x05E6, 0x024C, 0x0661, 0x009C, 0x04A8, 0x054D, 0x0348, 0x02B3, 0x0212, 0x05FB, 0x05BB, 0x0451, 0x00E5, 0x0657, 0x0427, 0x04A3,   // 9280 - 928F
	0x0098, 0x0594, 0x05AC, 0x0434, 0x03DF, 0x05DE, 0x0666, 0x01EB, 0x033F, 0x027C, 0x05D7, 0x0594, 0x0594, 0x05B7, 0x024C, 0x0070,   // 9290 - 929F
	0x02AC, 0x0212, 0x05F2, 0x0466, 0x032A, 0x05DE, 0x05E6, 0x01B0, 0x0005, 0x0123, 0x05F7, 0x048E, 0x0260, 0x040A, 0x02F0, 0xFFFF,   // 92A0 - 92AF
	0x0002, 0x0115, 0x01C9, 0x046E, 0x04C7, 0x026B, 0x042D, 0x059F, 0x0648, 0x05B7, 0x0616, 0x0537, 0x00E9, 0x01A2, 0x0196, 0x065B,   // 92B0 - 92BF
	0x012C, 0x02FD, 0x031D, 0x02A7, 0x0571, 0x05A8, 0x0607, 0x0023, 0x058A, 0x0507, 0x05FB, 0x0079, 0x0548, 0x004A, 0x01C9, 0x0215,   // 92C0 - 92CF
	0x01E6, 0x00DC, 0x0163, 0x0079, 0x0571, 0x0657, 0x04FB, 0x05BE, 0x058A, 0x058A, 0x053F, 0x0196, 0x068C, 0x0300, 0x05AC, 0x041E,   // 92D0 - 92DF
	0x04BC, 0x01C9, 0xFFFF, 0x05DB, 0x00A7, 0x062A, 0x0240, 0x0594, 0x0144, 0x0311, 0x0400, 0x02BC, 0x04C7, 0x046E, 0x0092, 0x0182,   // 92E0 - 92EF
	0x02BC, 0x052F, 0xFFFF, 0x0666, 0xFFFF, 0x0556, 0x02E0, 0x06A5, 0x0240, 0x007E, 0x05FE, 0x0219, 0x017D, 0x0115, 0x052B, 0x007E,   // 92F0 - 92FF
	0x02F5, 0x01BE, 0x02DB, 0x0023, 0x02ED, 0x02BC, 0x0422, 0x03D2, 0x0243, 0x033B, 0x06A5, 0x03DA, 0x0005, 0x03DF, 0x0594, 0x05CB,   // 9300 - 930F
	0x0682, 0x02B3, 0x0000, 0x0270, 0x051B, 0x0294, 0x0130, 0x057A, 0x00BE, 0x0691, 0x0651, 0x0027, 0x038C, 0x00D0, 0x00C3, 0x0522,   // 9310 - 931F
	0x011E, 0x0403, 0x040A, 0x068C, 0x0403, 0x05FB, 0x022D, 0x01AB, 0x0316, 0x007E, 0x0110, 0x058D, 0x02C3, 0x052B, 0x019F, 0x00E9,   // 9320 - 932F
	0x04D0, 0x064C, 0x02ED, 0x0325, 0x02ED, 0x01F2, 0x0038, 0x0172, 0x029F, 0x0267, 0x0682, 0xFFFF, 0x0355, 0x0571, 0x0612, 0xFFFF,   // 9330 - 933F
	0x0101, 0x0594, 0xFFFF, 0x020E, 0x02C8, 0xFFFF, 0x0321, 0x0253, 0x05EA, 0x0109, 0x02C3, 0x01BE, 0x0594, 0x0130, 0x0556, 0x057A,   // 9340 - 934F
	0x00D0, 0x016F, 0x0462, 0x0212, 0x0144, 0x0462, 0x008D, 0x0537, 0x062F, 0x01E6, 0x05D2, 0x0133, 0x0590, 0x05FB, 0x026B, 0x05AC,   // 9350 - 935F
	0x0200, 0x057A, 0x016F, 0x0643, 0x0070, 0x041A, 0x04B3, 0x01E6, 0x0290, 0x03AE, 0x034B, 0x0415, 0x0415, 0x01EB, 0x064C, 0x020E,   // 9360 - 936F
	0x01FB, 0x05DB, 0x033B, 0x0219, 0x0133, 0x0219, 0x04FB, 0x0290, 0x01EF, 0x05BE, 0x0616, 0x0229, 0x064C, 0x0033, 0x065B, 0x0691,   // 9370 - 937F
	0x05B7, 0x05DB, 0x031D, 0x03C1, 0x0002, 0x0229, 0xFFFF, 0x031D, 0x0070, 0x051B, 0x001A, 0x0590, 0x02C3, 0x0517, 0x058D, 0x02E0,   // 9380 - 938F
	0x069D, 0x05DB, 0x03A2, 0x0582, 0x045D, 0x0526, 0x0517, 0x040F, 0x0186, 0x04F6, 0x00BE, 0x004A, 0x03C5, 0x051B, 0x0030, 0x0485,   // 9390 - 939F
	0x017D, 0x0691, 0x058A, 0x05EA, 0x0200, 0x053F, 0x02E0, 0x0253, 0x0513, 0x049A, 0x0503, 0x0571, 0x01D2, 0x064C, 0x064C, 0x02F9,   // 93A0 - 93AF
	0x05DE, 0x05FE, 0x0526, 0x038C, 0x058D, 0x0215, 0x0186, 0x0306, 0x0243, 0x045D, 0xFFFF, 0x0517, 0xFFFF, 0xFFFF, 0xFFFF, 0x0352,   // 93B0 - 93BF
	0x02ED, 0x0517, 0x0275, 0x069D, 0x0559, 0x05B7, 0x01AB, 0x05BE, 0x02C3, 0x04CB, 0x000C, 0x030D, 0x0348, 0x02F9, 0x0030, 0x057A,   // 93C0 - 93CF
	0x02E0, 0x0109, 0x0415, 0x020E, 0x05E6, 0x02ED, 0x000C, 0x026B, 0x040F, 0x00E1, 0x0403, 0x007E, 0x0526, 0x030D, 0x05F2, 0x0079,   // 93D0 - 93DF
	0x0163, 0x0231, 0x0038, 0x04D0, 0x02E9, 0x05B7, 0x00D0, 0x02E4, 0x0612, 0x0219, 0x0060, 0x02BC, 0x0590, 0x058D, 0x025B, 0xFFFF,   // 93E0 - 93EF
	0x002B, 0xFFFF, 0xFFFF, 0x0651, 0x02ED, 0x01F2, 0x0212, 0x0400, 0x0206, 0x040F, 0x03F9, 0x02D7, 0x0517, 0x05B7, 0x0481, 0x0092,   // 93F0 - 93FF
	0x0290, 0x0481, 0x02E0, 0x0362, 0x0200, 0x03EC, 0x050F, 0x0152, 0x0415, 0x00B1, 0x05D2, 0x0526, 0x0599, 0x0248, 0x0224, 0x06A9,   // 9400 - 940F
	0x02CE, 0x0229, 0x02AC, 0x0138, 0x0522, 0x0612, 0x0212, 0x0219, 0x065B, 0x0104, 0x02E9, 0x05EA, 0x0138, 0x0248, 0x03A2, 0x0537,   // 9410 - 941F
	0x0400, 0x0544, 0xFFFF, 0xFFFF, 0x011E, 0x04A3, 0x0253, 0x0219, 0x015B, 0x050F, 0x02ED, 0x0243, 0x0206, 0x05FB, 0x02C3, 0x068C,   // 9420 - 942F
	0x0415, 0x040A, 0x068C, 0x02B3, 0x0030, 0x0544, 0x01FB, 0x05DB, 0x0140, 0x01BE, 0x00F8, 0x0240, 0x015F, 0x00ED, 0x0023, 0x05DE,   // 9430 - 943F
	0x0002, 0x00F8, 0x05C7, 0x0115, 0x0666, 0x01E1, 0x0682, 0x0212, 0x038C, 0x051B, 0x020E, 0x0422, 0x0041, 0x05EA, 0x0290, 0x0394,   // 9440 - 944F
	0x05BB, 0x0219, 0x0219, 0x040F, 0x0070, 0x0657, 0x0337, 0x02BC, 0x02B3, 0x0212, 0x06A0, 0x028A, 0x04A8, 0x03DA, 0x029C, 0x0130,   // 9450 - 945F
	0x04F6, 0x00C8, 0x02FD, 0x0038, 0x001F, 0x02ED, 0xFFFF, 0xFFFF, 0x02E4, 0x0144, 0x02ED, 0x05A8, 0x0219, 0x02A3, 0x004A, 0x0219,   // 9460 - 946F
	0x05D7, 0x0079, 0x0599, 0x0219, 0x058D, 0x01AB, 0x005B, 0x038C, 0x02B3, 0x00DC, 0x0431, 0x03C5, 0x02F9, 0x06A0, 0x02F0, 0x061B,   // 9470 - 947F
	0x038C, 0x0248, 0x0526, 0x04D0, 0x02A3, 0x022D, 0x0172, 0x05DE, 0x064C, 0x011E, 0x0643, 0x03F9, 0x02CE, 0x0556, 0x040A, 0x00B1,   // 9480 - 948F
	0x04A3, 0x047A, 0x0152, 0x0115, 0x0321, 0x03B2, 0x05D2, 0x0074, 0x05AC, 0x0175, 0x004D, 0x051E, 0x0240, 0x013C, 0x0084, 0x065B,   // 9490 - 949F
	0x0352, 0x0023, 0x017D, 0x0016, 0x040A, 0x05D7, 0x041E, 0x024C, 0x058A, 0x019B, 0x025B, 0x0156, 0x020E, 0x0552, 0x0399, 0x000F,   // 94A0 - 94AF
	0x05FB, 0x040A, 0x0651, 0x040A, 0x019F, 0x004A, 0x0264, 0x03F9, 0x004D, 0x004A, 0x0603, 0x06A0, 0x034F, 0x0522, 0x0215, 0x0110,   // 94B0 - 94BF
	0x05F7, 0x0544, 0x004A, 0x02DB, 0x04F6, 0x040A, 0x0316, 0x001F, 0x04C7, 0x05BE, 0x0566, 0x0030, 0x0379, 0x03DF, 0x0140, 0x05AC,   // 94C0 - 94CF
	0x0260, 0x02AC, 0x014C, 0x0311, 0x05CB, 0x05F7, 0x0092, 0x0215, 0x05DB, 0x0362, 0x0657, 0x00F8, 0x054D, 0x02FD, 0x0115, 0x05E6,   // 94D0 - 94DF
	0x0253, 0x062F, 0x0666, 0x0594, 0x0548, 0x0123, 0x0594, 0x01F2, 0x0434, 0x049A, 0x01C2, 0x05D7, 0x0186, 0x033F, 0x0651, 0x048E,   // 94E0 - 94EF
	0x0224, 0x05DE, 0x0079, 0x009C, 0x0526, 0x0005, 0x05E6, 0x0466, 0x0666, 0x02AC, 0x0400, 0x058A, 0x029F, 0x052F, 0x02C3, 0x026B,   // 94F0 - 94FF
	0x059F, 0x0517, 0x02BC, 0x062A, 0x00A7, 0x01BE, 0x0182, 0x0144, 0x05B7, 0x00E9, 0x0300, 0x0163, 0x05A8, 0x02E0, 0x0253, 0x0219,   // 9500 - 950F
	0x046E, 0x0537, 0x02A7, 0x041E, 0x0240, 0x0000, 0x0422, 0x0648, 0x03AE, 0x00E9, 0x0316, 0x0027, 0x0403, 0x0101, 0x0264, 0x0294,   // 9510 - 951F
	0x007E, 0x058D, 0x019F, 0x02F9, 0x00BE, 0x0682, 0x022D, 0x0657, 0x0594, 0x0243, 0x020E, 0x03D2, 0x0522, 0x011E, 0x0219, 0x0240,   // 9520 - 952F
	0x0325, 0x0691, 0x041A, 0x05EA, 0x0253, 0x040F, 0x04FB, 0x0144, 0x0070, 0x0415, 0x065B, 0x0133, 0x0503, 0x0200, 0x01FB, 0x0002,   // 9530 - 953F
	0x0130, 0x031D, 0x02E9, 0x0691, 0x015B, 0x031D, 0x0348, 0x064C, 0x004A, 0x0186, 0x038C, 0x0526, 0x0243, 0x038C, 0x0352, 0x02E0,   // 9540 - 954F
	0x01D2, 0x001A, 0x05DE, 0x0215, 0x0041, 0x045D, 0x0038, 0x0526, 0x030D, 0x02F9, 0x002B, 0x05F2, 0x0231, 0x0109, 0x069D, 0x05BE,   // 9550 - 955F
	0x02E0, 0x0079, 0x0248, 0x02CE, 0x0400, 0x02ED, 0x013C, 0x02A3, 0x0400, 0x00DC, 0x040F, 0x0104, 0x020E, 0x02B3, 0x01FB, 0x068C,   // 9560 - 956F
	0x02C3, 0x05DE, 0x0070, 0x0038, 0x029C, 0x0079, 0x0599, 0x007E, 0x007E, 0x023C, 0x000C, 0x011A, 0x0431, 0x02CE, 0x032A, 0x007E,   // 9570 - 957F
	0x0321, 0x0306, 0x04DF, 0x04A3, 0x020E, 0x0321, 0x05CE, 0x0030, 0x01C9, 0x0030, 0xFFFF, 0x0253, 0x025B, 0x002B, 0x01E6, 0x0472,   // 9580 - 958F
	0x0481, 0x0594, 0x0594, 0x0219, 0x033B, 0x0590, 0x033B, 0x012C, 0x062F, 0x0362, 0xFFFF, 0x03DA, 0x0264, 0x02DB, 0x0033, 0x0030,   // 9590 - 959F
	0x0472, 0x01D6, 0x01AB, 0x0186, 0x01D6, 0x014F, 0x00A7, 0x01E6, 0x01B6, 0x033B, 0xFFFF, 0x0294, 0x02A7, 0x02FD, 0x0548, 0x049A,   // 95A0 - 95AF
	0x05CE, 0x0603, 0x0603, 0x0079, 0x0431, 0x02D7, 0x007E, 0x049E, 0x0294, 0x05CE, 0x033B, 0x05CE, 0x0144, 0x020A, 0x05FB, 0x057E,   // 95B0 - 95BF
	0x0599, 0xFFFF, 0x0599, 0x0431, 0x05D7, 0x057E, 0x0016, 0x0005, 0x057A, 0x05E6, 0x0298, 0x0439, 0x02A3, 0x0130, 0xFFFF, 0xFFFF,   // 95C0 - 95CF
	0x053A, 0x038C, 0x00ED, 0x0253, 0x01D6, 0x0439, 0x00B7, 0x01AB, 0x012C, 0x0403, 0x0290, 0x0526, 0x01AB, 0x03E7, 0x0257, 0x058D,   // 95D0 - 95DF
	0x0206, 0x0079, 0x03DF, 0x00F8, 0x01FB, 0x051B, 0x057E, 0xFFFF, 0x0321, 0x04DF, 0x04A3, 0x05CE, 0x01C9, 0x0030, 0x057E, 0x00B7,   // 95E0 - 95EF
	0x0472, 0x057A, 0x0594, 0x01E6, 0x0219, 0x033B, 0x025B, 0x0321, 0x062F, 0x0362, 0x01B6, 0x057E, 0x051B, 0x033B, 0x02FD, 0x0253,   // 95F0 - 95FF
	0x014F, 0x0186, 0x01D6, 0x0294, 0x023C, 0x0603, 0x02A7, 0x0130, 0x05FB, 0x05CE, 0x007E, 0x058D, 0x057E, 0x020A, 0x05CE, 0x05CE,   // 9600 - 960F
	0x0079, 0x02A3, 0x0431, 0x0206, 0x0298, 0x0439, 0x01D6, 0x053A, 0x00ED, 0x0439, 0x0257, 0x01FB, 0x016F, 0x016F, 0x02B0, 0x0138,   // 9610 - 961F
	0x05A8, 0x040A, 0x058A, 0x05DE, 0x0566, 0x05E6, 0x05D2, 0x012C, 0x0144, 0x04C1, 0x0016, 0x03D2, 0x026B, 0x0607, 0x0469, 0x0657,   // 9620 - 962F
	0x03DF, 0x0231, 0x0156, 0x05D2, 0x05E6, 0x064C, 0x0229, 0x0092, 0x0144, 0x0431, 0x0109, 0x069D, 0x06AD, 0x0110, 0x02DB, 0x0000,   // 9630 - 963F
	0x0566, 0x0566, 0x03F9, 0x0045, 0x016F, 0x0212, 0x02E0, 0x02E4, 0x008D, 0x05AC, 0x0140, 0x02E9, 0x0348, 0x021E, 0x04D0, 0x0140,   // 9640 - 964F
	0x0594, 0x014C, 0x01B6, 0x058A, 0x0175, 0x04A3, 0x024C, 0x0415, 0x05AC, 0x00C3, 0x016F, 0x0030, 0x04A3, 0x04A3, 0x04C1, 0x0657,   // 9650 - 965F
	0x0400, 0x012C, 0x05FE, 0x064C, 0x00A7, 0x0594, 0x0657, 0x038C, 0x0607, 0x0594, 0x03D2, 0x03D2, 0x0699, 0x05DE, 0x0138, 0x02F5,   // 9660 - 966F
	0x05E6, 0x0240, 0x00BE, 0x008D, 0x03DF, 0x02DB, 0x052B, 0x0594, 0x02ED, 0xFFFF, 0x0594, 0x05E6, 0x0666, 0x05D2, 0x0455, 0x04A3,   // 9670 - 967F
	0x009C, 0x05CE, 0x05E6, 0x05FB, 0x0537, 0x05FB, 0x02E4, 0x057A, 0x057A, 0x038C, 0x0138, 0x050F, 0x0005, 0x0200, 0x0229, 0x050F,   // 9680 - 968F
	0x05E6, 0x0175, 0x05CE, 0x0206, 0x0186, 0x0607, 0x058A, 0x057A, 0x0002, 0x058D, 0x0526, 0x0212, 0x063D, 0x00FD, 0x000C, 0x058D,   // 9690 - 969F
	0x05E6, 0x047A, 0x044A, 0x02D7, 0x055E, 0x0104, 0x03DF, 0x050F, 0x050F, 0x05FB, 0x0594, 0x015F, 0x0379, 0x014C, 0x0212, 0x00FD,   // 96A0 - 96AF
	0x058D, 0x05E6, 0x0657, 0x0206, 0x02E4, 0x058D, 0x02BC, 0x02BC, 0x02BC, 0x0682, 0x01D6, 0x0657, 0x0513, 0x0243, 0x0359, 0x05DE,   // 96B0 - 96BF
	0x0439, 0x05CE, 0x041E, 0x05CB, 0x05B1, 0x05CB, 0x0212, 0x019F, 0x01FB, 0x0657, 0x019B, 0x024C, 0x00CD, 0x05F2, 0x0240, 0x00A7,   // 96C0 - 96CF
	0x01EF, 0x060B, 0x02F9, 0x05FB, 0x00A2, 0x0115, 0x050F, 0x01C9, 0x020E, 0x04E5, 0x01AB, 0x00A7, 0x060B, 0x05F2, 0x0212, 0x050F,   // 96D0 - 96DF
	0x00A2, 0x02E0, 0x02BC, 0x0359, 0x05C3, 0x060B, 0x0212, 0x0212, 0x05FB, 0x05FB, 0x05C3, 0x0352, 0x016B, 0x048E, 0x034F, 0x057E,   // 96E0 - 96EF
	0x015F, 0x03C9, 0x0607, 0x02BC, 0x02BC, 0x05D2, 0x02DB, 0x02B3, 0x0005, 0x001F, 0x0325, 0x0110, 0x00F8, 0x01CD, 0x058A, 0x0643,   // 96F0 - 96FF
	0x05BB, 0x0212, 0x034F, 0x008D, 0x059F, 0x062F, 0x0548, 0x064C, 0x03D2, 0x031D, 0x02DB, 0x0403, 0x00A2, 0x020E, 0x049A, 0x015B,   // 9700 - 970F
	0x0582, 0x0638, 0x05EA, 0x0379, 0x00A2, 0x0562, 0x02D7, 0xFFFF, 0x0127, 0x05EA, 0x058A, 0x02DB, 0x04E5, 0x02DB, 0x0590, 0x01E6,   // 9710 - 971F
	0x05E6, 0x0309, 0x0348, 0x0607, 0x02E0, 0x0325, 0x0041, 0x058A, 0x057A, 0x0298, 0x05E6, 0x058D, 0x05DE, 0x0002, 0x00F4, 0x0104,   // 9720 - 972F
	0x0594, 0x05FB, 0x02ED, 0x02E4, 0x00F0, 0x0212, 0x03C9, 0x05D2, 0x000F, 0x03DF, 0x057A, 0xFFFF, 0x058D, 0x0212, 0x0309, 0x0325,   // 9730 - 973F
	0x0325, 0x02B3, 0x02BC, 0x020E, 0x0002, 0x015B, 0x00F0, 0x02E4, 0x02DB, 0x0002, 0x0163, 0x02BC, 0x001F, 0xFFFF, 0x01D6, 0x01D6,   // 9740 - 974F
	0x0045, 0x0422, 0x0422, 0x0231, 0x0403, 0x064C, 0x0231, 0x0092, 0x0422, 0x0231, 0x0231, 0x0110, 0x0231, 0x053A, 0x015B, 0x015B,   // 9750 - 975F
	0x0260, 0x032A, 0x032D, 0x032D, 0x03CE, 0x05DB, 0x053A, 0x0206, 0x05DB, 0x0186, 0x011E, 0x0451, 0x0219, 0x0451, 0x0109, 0x0130,   // 9760 - 976F
	0x058A, 0x0451, 0x041E, 0x022D, 0x05C3, 0x0399, 0x000F, 0x05E6, 0x047A, 0x0451, 0x0348, 0x069D, 0x00ED, 0x0016, 0x05DE, 0x05D7,   // 9770 - 977F
	0x052B, 0x0023, 0x0215, 0x01E6, 0x03CE, 0x05D2, 0x0348, 0x05E6, 0x0215, 0x052B, 0x0212, 0x05A4, 0x0005, 0x0005, 0x01DD, 0x0196,   // 9780 - 978F
	0x0196, 0x00ED, 0x0415, 0x0548, 0x0571, 0x05EA, 0x050F, 0x053F, 0x0415, 0x05BE, 0x0270, 0x002B, 0x051B, 0x063D, 0x0045, 0x0298,   // 9790 - 979F
	0x0240, 0x029C, 0x05A4, 0x0462, 0x001A, 0x05DE, 0x042D, 0x042D, 0x01D6, 0x059F, 0x034F, 0x0240, 0x0219, 0x0033, 0x0109, 0x0219,   // 97A0 - 97AF
	0xFFFF, 0x052B, 0x019B, 0x051B, 0x0023, 0x05A4, 0x03C5, 0x0186, 0x0030, 0x0298, 0x0526, 0x02E9, 0x01B6, 0x0415, 0x05C3, 0x0212,   // 97B0 - 97BF
	0x0219, 0x021E, 0x0079, 0x00ED, 0x020E, 0x0594, 0x040A, 0x0130, 0x056A, 0x0219, 0x02A3, 0x057A, 0x0451, 0x016F, 0x031D, 0x0243,   // 97C0 - 97CF
	0x0186, 0x057A, 0x0415, 0x01C9, 0x007E, 0xFFFF, 0x0462, 0x05C7, 0x04B3, 0x057A, 0x0186, 0x0023, 0x052B, 0x019B, 0x0607, 0x0182,   // 97D0 - 97DF
	0x0030, 0x057A, 0x0206, 0x04D0, 0x056A, 0x0130, 0x057A, 0x0451, 0x016F, 0x01C9, 0x057A, 0x0607, 0x052B, 0x023C, 0x023C, 0x0594,   // 97E0 - 97EF
	0x05A4, 0x0594, 0x0212, 0x05E6, 0x060B, 0x0607, 0x04AE, 0x02F9, 0x03DA, 0x0200, 0x05EA, 0x0607, 0x03DA, 0x05E6, 0x05E6, 0x0599,   // 97F0 - 97FF
	0x01EF, 0x05DB, 0x011E, 0x0422, 0x03C5, 0x0599, 0x04F1, 0x01C9, 0x05BB, 0x05DE, 0x05BB, 0x019F, 0x04FE, 0x0290, 0x0403, 0x01CD,   // 9800 - 980F
	0x05FB, 0x0571, 0x0016, 0x013C, 0x0109, 0x00F4, 0x03C5, 0x03F9, 0x02DB, 0x0092, 0x0231, 0x02B3, 0x01D6, 0x0415, 0x0144, 0x0144,   // 9810 - 981F
	0x057A, 0x0229, 0x01A2, 0x04BC, 0x05DE, 0x05DE, 0x0264, 0x0138, 0x03E2, 0x03F4, 0x02B3, 0x016F, 0x0215, 0x0552, 0x0206, 0x0290,   // 9820 - 982F
	0x0215, 0x02B0, 0x0548, 0x0092, 0x05EA, 0x024C, 0x01EF, 0x01C9, 0x0231, 0x055E, 0x055E, 0x03F0, 0x029F, 0x055E, 0x0691, 0x0691,   // 9830 - 983F
	0x00BE, 0x011E, 0x029F, 0x05CE, 0x01C9, 0x040A, 0x0264, 0x00E1, 0x0236, 0x041E, 0x05DE, 0x047D, 0x0537, 0x0144, 0x0144, 0x05CE,   // 9840 - 984F
	0x020A, 0x0257, 0x05F2, 0x0675, 0x05CE, 0x0594, 0x05A8, 0x05DE, 0x05FE, 0x0485, 0x0110, 0x0110, 0x021E, 0x0279, 0x02B3, 0x02CE,   // 9850 - 985F
	0x03E7, 0x05DE, 0x030D, 0x0403, 0x05D7, 0x01D2, 0x0415, 0x019F, 0x05C7, 0x040A, 0x0206, 0x0638, 0x0466, 0x01E6, 0x0041, 0x0594,   // 9860 - 986F
	0x03F0, 0x02ED, 0x02A3, 0x038C, 0x0434, 0x05DB, 0x011E, 0x0422, 0x01C9, 0x0599, 0x04F1, 0x05BB, 0x05BB, 0x0571, 0x019F, 0x013C,   // 9870 - 987F
	0x0403, 0x0016, 0x04FE, 0x01CD, 0x05FB, 0x02ED, 0x02DB, 0x03F9, 0x0231, 0x0229, 0x0215, 0x0548, 0x01D6, 0x05EA, 0x0236, 0x0264,   // 9880 - 988F
	0x05DE, 0x03F0, 0x0206, 0x055E, 0x01C9, 0x05EA, 0x05EA, 0x0264, 0x0537, 0x05F2, 0x0144, 0x0675, 0x05CE, 0x0144, 0x038C, 0x030D,   // 9890 - 989F
	0x0110, 0x0485, 0x01D2, 0x02B3, 0x0638, 0x0466, 0x03F0, 0x0434, 0x0163, 0x0038, 0xFFFF, 0x016F, 0x0590, 0x0638, 0x0038, 0x047A,   // 98A0 - 98AF
	0x014F, 0x051E, 0x02D3, 0x01A2, 0x05BE, 0x04AE, 0x0240, 0x0038, 0x04FB, 0x057A, 0x05D2, 0x05D7, 0x0503, 0x0253, 0x048A, 0x0152,   // 98B0 - 98BF
	0x02E0, 0x058D, 0x02CE, 0x03E7, 0x03E7, 0x02E0, 0x0038, 0x0038, 0x0038, 0x02CE, 0xFFFF, 0x048E, 0x0163, 0x0038, 0x0163, 0x05D2,   // 98C0 - 98CF
	0x0638, 0x0038, 0x047A, 0x0240, 0x04FB, 0x0503, 0x05D7, 0x02E0, 0x03E7, 0x0038, 0x0038, 0x015B, 0x0152, 0x015B, 0x015B, 0x04C7,   // 98D0 - 98DF
	0x04C7, 0x0057, 0x0212, 0x011E, 0x04FB, 0x0566, 0x0219, 0x0513, 0x0599, 0x0562, 0x0451, 0x05FB, 0x0243, 0x0098, 0x05E6, 0x0152,   // 98E0 - 98EF
	0x0152, 0x0513, 0x05E6, 0x0666, 0x05DE, 0x0633, 0x0030, 0x0229, 0x052B, 0x02E0, 0x00CD, 0x0544, 0x04FB, 0x001F, 0x04C7, 0x0140,   // 98F0 - 98FF
	0x01C5, 0x0451, 0x053A, 0x0224, 0x0215, 0x0045, 0x05D7, 0x054D, 0x00CD, 0x0599, 0x05D2, 0x05D2, 0x014C, 0x05CE, 0x02B0, 0x05DE,   // 9900 - 990F
	0x0057, 0x004A, 0x0369, 0x0144, 0x004D, 0x024C, 0x012C, 0x0507, 0x05FB, 0x04C7, 0x05D7, 0x020A, 0x01BE, 0x04C7, 0x0219, 0x0682,   // 9910 - 991F
	0x0045, 0x0594, 0x004D, 0x05DB, 0x0522, 0x015B, 0x063D, 0x057A, 0x01AB, 0x0144, 0x03A9, 0x020A, 0x01EF, 0x0200, 0x0544, 0x0206,   // 9920 - 992F
	0x0219, 0x01EB, 0x01D6, 0x05AC, 0x015F, 0x057A, 0x019F, 0x0070, 0x04FE, 0x0526, 0x004A, 0x0182, 0x058D, 0x0290, 0x02E0, 0x0503,   // 9930 - 993F
	0x052B, 0x05DB, 0x0607, 0x0348, 0x0526, 0x030D, 0x0030, 0x05FB, 0x05B7, 0x022D, 0x0481, 0x0290, 0x0675, 0x04A3, 0x0098, 0x00F4,   // 9940 - 994F
	0x05DE, 0x0212, 0x044A, 0x0092, 0x05F2, 0x052B, 0x0206, 0x0599, 0x0638, 0x015F, 0x01C5, 0x0325, 0x05CE, 0x0348, 0x0079, 0x0599,   // 9950 - 995F
	0x02F9, 0x06A0, 0x035D, 0x04C7, 0x011E, 0x0212, 0x0566, 0x05AC, 0x0562, 0x058D, 0x0451, 0x05FB, 0x0098, 0x0152, 0x05E6, 0x0219,   // 9960 - 996F
	0x04C7, 0x001F, 0x04FB, 0x0140, 0x05DE, 0x014C, 0x044A, 0x0599, 0x01D6, 0x02B0, 0x0224, 0x058D, 0x0045, 0x004A, 0x012C, 0x0144,   // 9970 - 997F
	0x05FB, 0x0369, 0x024C, 0x01BE, 0x020A, 0x0594, 0x01AB, 0x0070, 0x0290, 0x019F, 0x0503, 0x0079, 0x05DB, 0x0348, 0x004A, 0x02E0,   // 9980 - 998F
	0x05B7, 0x022D, 0x030D, 0x0481, 0x0675, 0x035D, 0x04CB, 0x0290, 0x01BE, 0x0599, 0x015F, 0x000F, 0x0379, 0x0030, 0x004A, 0x0556,   // 9990 - 999F
	0x01C9, 0x015B, 0x0219, 0x05CE, 0x0002, 0x016F, 0x0594, 0x057E, 0x05A8, 0x015F, 0x0041, 0x05AC, 0x0306, 0x05FB, 0x0163, 0x01C9,   // 99A0 - 99AF
	0x0109, 0x0566, 0x0566, 0x0098, 0x05C7, 0x0666, 0x0657, 0x03D2, 0x05A8, 0x045A, 0x047A, 0x05E6, 0x057E, 0x0657, 0x00F4, 0x02FD,   // 99B0 - 99BF
	0x05F7, 0x004A, 0x001F, 0x0280, 0x0566, 0x05DE, 0x0431, 0x057E, 0x0431, 0x0236, 0x004A, 0x0643, 0x05FE, 0x03DA, 0x0661, 0x0240,   // 99C0 - 99CF
	0x0666, 0x03A6, 0x0240, 0x03DF, 0x0616, 0x0215, 0x02DB, 0x064C, 0x051E, 0x016F, 0x05D2, 0x04C7, 0x0030, 0x0566, 0x0566, 0x04FB,   // 99D0 - 99DF
	0x02E0, 0x0306, 0x03E2, 0x052B, 0x0657, 0x045D, 0x0532, 0x0127, 0x05C7, 0x0434, 0x04BC, 0x0236, 0x014C, 0x01C5, 0x004A, 0xFFFF,   // 99E0 - 99EF
	0x05E6, 0x02F9, 0xFFFF, 0x00F4, 0x05A4, 0x02E0, 0x0240, 0x04FE, 0x041E, 0x0311, 0x02C8, 0x01C9, 0x0556, 0x05BE, 0x055E, 0x024C,   // 99F0 - 99FF
	0x0144, 0x0092, 0x05AC, 0x0002, 0x02ED, 0x0682, 0x0661, 0x04B3, 0x03E2, 0x0294, 0x052B, 0x029F, 0x0694, 0x0264, 0x0403, 0x0403,   // 9A00 - 9A0F
	0x05CE, 0x015B, 0x048A, 0x05CE, 0x0229, 0x05D7, 0x058A, 0x03E2, 0x00D0, 0x03E2, 0x040A, 0x015B, 0x0200, 0x0219, 0x020E, 0x05FB,   // 9A10 - 9A1F
	0x0537, 0x0434, 0x0590, 0x0694, 0x0290, 0x0462, 0x04FB, 0x01A2, 0x0566, 0x0290, 0x0503, 0x040A, 0x0092, 0x0657, 0x02E0, 0x03C9,   // 9A20 - 9A2F
	0x0532, 0x058D, 0x0060, 0x0130, 0x05CE, 0x05FE, 0x0699, 0x048A, 0x04A3, 0x02BC, 0x0657, 0x04E5, 0x02ED, 0x058D, 0x02F9, 0x063D,   // 9A30 - 9A3F
	0x0348, 0x000C, 0x0057, 0x03E7, 0x00D0, 0x0431, 0x0030, 0x0657, 0x05FB, 0x05BB, 0x01F2, 0x004A, 0x0507, 0x059F, 0x02D7, 0x0638,   // 9A40 - 9A4F
	0x013C, 0x02E0, 0x0566, 0x062A, 0x0522, 0x0224, 0x0544, 0x05CE, 0x02F9, 0x0638, 0x0231, 0x05DE, 0x05DB, 0x0566, 0x0041, 0x0699,   // 9A50 - 9A5F
	0x05CE, 0x03DA, 0x02FD, 0x0532, 0x0599, 0x0212, 0x04E5, 0x0240, 0x058D, 0x01FB, 0x02BC, 0x0038, 0x0306, 0x05FB, 0x0566, 0x05C7,   // 9A60 - 9A6F
	0x0098, 0x0431, 0x045A, 0x004A, 0x02FD, 0x0616, 0x04C7, 0x04FB, 0x016F, 0x0240, 0x0699, 0x0666, 0x0566, 0x03A6, 0x0215, 0x05DE,   // 9A70 - 9A7F
	0x051E, 0x059F, 0x0306, 0x05E6, 0x0224, 0x01F2, 0x02F9, 0x01C5, 0x03E2, 0x0038, 0x02BC, 0x0092, 0x05CE, 0x05AC, 0x041E, 0x024C,   // 9A80 - 9A8F
	0x0403, 0x0403, 0x0264, 0x0682, 0x0694, 0x0507, 0x0057, 0x03E2, 0x0657, 0x0290, 0x048A, 0x058A, 0x000C, 0x02E0, 0x040A, 0x04A3,   // 9A90 - 9A9F
	0x03E7, 0x02F9, 0x00D0, 0x0638, 0x0661, 0x0212, 0x04E5, 0x0599, 0x019F, 0x057A, 0x057A, 0x057A, 0x05FB, 0x0179, 0x05DE, 0x0008,   // 9AA0 - 9AAF
	0x0552, 0x05A4, 0x004A, 0x0030, 0x00CD, 0x0537, 0x0109, 0x0279, 0x01C5, 0x0415, 0x01EB, 0x027C, 0x0186, 0x055E, 0x0191, 0x03E2,   // 9AB0 - 9ABF
	0x0030, 0x0264, 0x0406, 0x05FB, 0x050F, 0x02E9, 0x004A, 0x059F, 0x001A, 0x004A, 0x00E9, 0x0285, 0x0041, 0x0348, 0x02CE, 0x02E9,   // 9AC0 - 9ACF
	0x0362, 0x0130, 0x0616, 0x050F, 0x0537, 0x0041, 0x0285, 0x02ED, 0x0182, 0x0182, 0x0415, 0x0260, 0x0415, 0x02AC, 0x061B, 0x0038,   // 9AD0 - 9ADF
	0x0294, 0x0294, 0x0537, 0x0156, 0x05B7, 0x0441, 0x0316, 0x00F4, 0x0294, 0x0041, 0x014F, 0x053F, 0x03DF, 0x0691, 0x014F, 0x0441,   // 9AE0 - 9AEF
	0x0537, 0x03CE, 0x03DF, 0x0316, 0x016F, 0x014C, 0x045D, 0x0431, 0xFFFF, 0x05B7, 0x01A2, 0x0212, 0x03DA, 0x066A, 0x04AE, 0x049A,   // 9AF0 - 9AFF
	0x0537, 0x02BC, 0x0041, 0x0694, 0x0537, 0x03DA, 0x04FE, 0x0651, 0x0434, 0x0694, 0x04F1, 0x0219, 0x0140, 0x01EF, 0x029C, 0x023C,   // 9B00 - 9B0F
	0x0403, 0x02C3, 0x064C, 0x0041, 0x03DA, 0x0348, 0x0481, 0x030D, 0x030D, 0x0495, 0x05BB, 0x02D3, 0x040A, 0x040A, 0x039D, 0x01FB,   // 9B10 - 9B1F
	0x0280, 0x0394, 0x0041, 0x02D3, 0x0445, 0x012C, 0x012C, 0x0362, 0x01E6, 0x058D, 0x012C, 0x0257, 0x012C, 0x012C, 0x023C, 0x007E,   // 9B20 - 9B2F
	0x05FB, 0x05FB, 0x02BC, 0x0243, 0x016F, 0x040A, 0x01B6, 0x0694, 0x02E0, 0x01B6, 0x04A8, 0x05FB, 0x01B6, 0x031D, 0x0212, 0x0403,   // 9B30 - 9B3F
	0x0229, 0x0290, 0x020A, 0x000F, 0x03F9, 0x031D, 0x05BB, 0x05CE, 0x059F, 0x02C8, 0x05FB, 0x055E, 0x0403, 0x0575, 0x02C8, 0x057A,   // 9B40 - 9B4F
	0x0219, 0x0098, 0x03E7, 0x0030, 0x0348, 0x0212, 0x05BB, 0x00A2, 0x05CE, 0x0638, 0x05FB, 0x00FD, 0x0451, 0x0212, 0x000F, 0x01E6,   // 9B50 - 9B5F
	0x0566, 0x0115, 0x0212, 0x05FB, 0x0144, 0x0439, 0x049A, 0x01CD, 0x0562, 0x0348, 0x0175, 0x04BC, 0x0152, 0x05FE, 0x03DF, 0x02ED,   // 9B60 - 9B6F
	0x057E, 0x01EF, 0x02ED, 0x060B, 0x0156, 0x015F, 0x0352, 0x05F7, 0xFFFF, 0xFFFF, 0x01D6, 0x0590, 0x0431, 0x01C9, 0x03DF, 0x02DB,   // 9B70 - 9B7F
	0x0566, 0x000F, 0x042D, 0x03F4, 0x016F, 0x0030, 0x0212, 0x057A, 0x0240, 0x0115, 0x000F, 0x05F7, 0x01BA, 0x03DF, 0x037C, 0x05AC,   // 9B80 - 9B8F
	0x051E, 0x001F, 0x016F, 0x062F, 0x0240, 0x019F, 0xFFFF, 0xFFFF, 0xFFFF, 0x051B, 0x0229, 0x04D4, 0x01EB, 0x0599, 0x014C, 0x0005,   // 9B90 - 9B9F
	0x057A, 0x053F, 0x0666, 0x05E6, 0x02D3, 0x02F9, 0x054D, 0x05DE, 0x0403, 0x0045, 0x057A, 0x0224, 0x0400, 0x01B6, 0x0594, 0x0186,   // 9BA0 - 9BAF
	0x0206, 0xFFFF, 0xFFFF, 0x0260, 0xFFFF, 0x0140, 0x024C, 0x0537, 0x032D, 0x04AE, 0x060B, 0x0517, 0x041E, 0x05FB, 0x0369, 0x0648,   // 9BB0 - 9BBF
	0x01BA, 0x0191, 0xFFFF, 0x058A, 0x042D, 0x0548, 0x016F, 0x01FB, 0x00A2, 0x02BC, 0x049A, 0x049A, 0x0182, 0x0325, 0xFFFF, 0xFFFF,   // 9BC0 - 9BCF
	0xFFFF, 0xFFFF, 0x05F2, 0x0379, 0x0691, 0x0403, 0x0422, 0x0599, 0x0369, 0x00C3, 0x0212, 0x0115, 0x041A, 0x019F, 0x0661, 0x0127,   // 9BD0 - 9BDF
	0x029F, 0x015B, 0x0379, 0x05DE, 0x0294, 0x02ED, 0x023C, 0x007E, 0x0231, 0x02F5, 0x02DB, 0x0699, 0x02BC, 0x0325, 0x0694, 0x0657,   // 9BE0 - 9BEF
	0x037C, 0xFFFF, 0xFFFF, 0xFFFF, 0x04C7, 0x048A, 0x020A, 0x0537, 0x01EB, 0x05AC, 0x0240, 0x029C, 0x0694, 0x0212, 0x0033, 0x0033,   // 9BF0 - 9BFF
	0x01FB, 0x0434, 0x0212, 0x057A, 0x057A, 0x05FB, 0x00C3, 0x0462, 0x011A, 0x0200, 0x02C3, 0x05CE, 0x042D, 0x042D, 0x0219, 0x0030,   // 9C00 - 9C0F
	0x0144, 0x05D2, 0x016F, 0x047D, 0x0219, 0x01C2, 0x0566, 0x01EF, 0xFFFF, 0x0476, 0xFFFF, 0x057E, 0x0219, 0x01D2, 0x058A, 0x03C9,   // 9C10 - 9C1F
	0x048A, 0x02E0, 0x0306, 0x04C7, 0x04C7, 0x01AB, 0x0691, 0x0532, 0x051B, 0x05D7, 0x0186, 0x045D, 0x040A, 0x0403, 0x057E, 0x0476,   // 9C20 - 9C2F
	0xFFFF, 0x02C3, 0x000C, 0x02B0, 0x0206, 0x033B, 0x0212, 0x053F, 0x0431, 0x0219, 0x048A, 0x030D, 0x058D, 0x042D, 0x0038, 0x0212,   // 9C30 - 9C3F
	0x0212, 0x0666, 0x021E, 0x042D, 0x0675, 0x05F2, 0x063D, 0x025B, 0x05C3, 0x003D, 0x0248, 0x0431, 0x0599, 0x004A, 0x0224, 0x05C7,   // 9C40 - 9C4F
	0x0507, 0x0200, 0x06A9, 0x04A3, 0x04A3, 0x0152, 0x01B6, 0x02D7, 0x05C7, 0x0332, 0x058D, 0xFFFF, 0x0599, 0x015F, 0x01AB, 0x01EB,   // 9C50 - 9C5F
	0x0280, 0x0622, 0x048A, 0x0638, 0x0179, 0x01B6, 0x04C1, 0x02BC, 0x007E, 0xFFFF, 0xFFFF, 0x0002, 0x0466, 0x0212, 0x05BB, 0x020E,   // 9C60 - 9C6F
	0xFFFF, 0x02BC, 0x02D3, 0x02BC, 0x0337, 0x064C, 0x0599, 0x0144, 0x02ED, 0x01AB, 0x02BC, 0x0594, 0x05FB, 0x00FD, 0x0212, 0x05F7,   // 9C70 - 9C7F
	0x0562, 0x02ED, 0x0156, 0x000F, 0x0264, 0x000F, 0x03F4, 0x037C, 0x02ED, 0x05F7, 0x062F, 0x016F, 0x000F, 0x001F, 0x01EB, 0x03DF,   // 9C80 - 9C8F
	0x051E, 0x01B6, 0x0229, 0x0260, 0x057A, 0x014C, 0x054D, 0x0622, 0x01EB, 0x0280, 0x0212, 0x0224, 0x0594, 0x062F, 0x0599, 0x05C7,   // 9C90 - 9C9F
	0x0191, 0x02BC, 0x02C3, 0x0219, 0x02BC, 0x04C7, 0x053F, 0x01BA, 0x049A, 0x01FB, 0x024C, 0x0212, 0x05F2, 0x0422, 0x02DB, 0x0403,   // 9CA0 - 9CAF
	0x0699, 0x015B, 0x0294, 0x007E, 0x019F, 0x0379, 0x037C, 0x0115, 0x0231, 0x04BC, 0x04C7, 0x0691, 0x015F, 0x011A, 0x0030, 0x007E,   // 9CB0 - 9CBF
	0x0537, 0x057E, 0x057A, 0x047D, 0x0144, 0x042D, 0x016F, 0x0200, 0x0434, 0x021E, 0x0033, 0x048A, 0x000C, 0x0403, 0x051B, 0x01AB,   // 9CC0 - 9CCF
	0x05D7, 0x03C9, 0x0219, 0x02B0, 0x0038, 0x05C3, 0x003D, 0x030D, 0x033B, 0x05F2, 0x057A, 0x058D, 0x01B6, 0x04A3, 0x02D7, 0x06A9,   // 9CD0 - 9CDF
	0x01EF, 0x0179, 0x02BC, 0x04A3, 0x01AB, 0x0387, 0x05DE, 0x016F, 0x02BC, 0x023C, 0x004D, 0x05CE, 0x016F, 0x0115, 0x0212, 0x0163,   // 9CE0 - 9CEF
	0xFFFF, 0x0179, 0x04C7, 0x0163, 0x033F, 0x001F, 0x05FE, 0x0657, 0x01EF, 0x040A, 0x016F, 0x015F, 0x057E, 0x0219, 0x04C7, 0x05FB,   // 9CF0 - 9CFF
	0x016B, 0x05E1, 0x0240, 0x0248, 0x03DF, 0x01FB, 0x064C, 0x001F, 0x05CE, 0x05CB, 0x0651, 0x0156, 0x0163, 0x057E, 0x03BB, 0x052F,   // 9D00 - 9D0F
	0x0215, 0x03A6, 0x02DB, 0x0337, 0x016F, 0x0566, 0x057E, 0x02BC, 0x0033, 0x0657, 0x0186, 0x05FE, 0x0691, 0x0431, 0x059F, 0x0098,   // 9D10 - 9D1F
	0x00F4, 0x0240, 0x05F7, 0x019F, 0x065B, 0x05FB, 0x05D2, 0x045D, 0x05CB, 0x0657, 0x05FB, 0xFFFF, 0x05EA, 0x0682, 0x058A, 0x014C,   // 9D20 - 9D2F
	0x01A2, 0x0002, 0x0657, 0x05CE, 0x01E1, 0x0224, 0x0212, 0x02D3, 0x0666, 0x0451, 0x0537, 0x01E6, 0x02F9, 0x0466, 0x034B, 0x0186,   // 9D30 - 9D3F
	0x0451, 0x0224, 0x05B7, 0x0661, 0x0098, 0x02F9, 0xFFFF, 0xFFFF, 0xFFFF, 0x02F0, 0x0215, 0x0212, 0x05FB, 0x01FB, 0x0566, 0x004D,   // 9D40 - 9D4F
	0x058A, 0x0243, 0x05FB, 0x004A, 0x05C7, 0x05C7, 0x0030, 0x058D, 0x024C, 0x0240, 0x0556, 0x0231, 0x0537, 0x0144, 0x0144, 0x028A,   // 9D50 - 9D5F
	0x01EF, 0x058A, 0x04BC, 0x029C, 0xFFFF, 0xFFFF, 0x02ED, 0x0045, 0x04D0, 0x016F, 0x0005, 0x0643, 0x03DA, 0x041E, 0x040A, 0x0023,   // 9D60 - 9D6F
	0x0115, 0x02ED, 0x0439, 0x0219, 0x0240, 0x0556, 0x05CB, 0x05FE, 0x0403, 0x02BC, 0x05DB, 0x0682, 0x0270, 0x0140, 0x0294, 0x04C1,   // 9D70 - 9D7F
	0x0403, 0x0231, 0x0379, 0x0144, 0x0231, 0x0691, 0x029F, 0x0127, 0x0403, 0x00C3, 0x0191, 0x0240, 0x0431, 0xFFFF, 0xFFFF, 0x0212,   // 9D80 - 9D8F
	0x04D0, 0xFFFF, 0x0098, 0x0332, 0x0462, 0x016F, 0x042D, 0x0537, 0x01EF, 0x0537, 0x0144, 0x0229, 0x0316, 0x016F, 0x00C3, 0x0556,   // 9D90 - 9D9F
	0x05CE, 0x01D6, 0x05FE, 0x03E2, 0x0607, 0x031D, 0x01EF, 0x05EA, 0x013C, 0x034F, 0x0240, 0xFFFF, 0x005B, 0x0156, 0x0186, 0x05EA,   // 9DA0 - 9DAF
	0x05FE, 0x05BE, 0x0582, 0x04C7, 0x01D6, 0x00A7, 0x0526, 0x0590, 0x0476, 0x02E0, 0x0212, 0x019F, 0x0219, 0x0687, 0x01C9, 0x0691,   // 9DB0 - 9DBF
	0x00CD, 0x05DE, 0x05D7, 0x05CE, 0x0212, 0x02BC, 0x053A, 0x0275, 0x0537, 0x0537, 0x0379, 0x0556, 0x0306, 0x0224, 0x02E0, 0x064C,   // 9DC0 - 9DCF
	0x008D, 0x02BC, 0x0675, 0x0648, 0x000C, 0x05D7, 0x05DE, 0x03BB, 0x0098, 0x0657, 0x02CE, 0x045D, 0x02E9, 0x0030, 0x04E5, 0x068C,   // 9DD0 - 9DDF
	0x05FB, 0x058A, 0x0248, 0x05E6, 0x0522, 0x04FB, 0x0224, 0x05DE, 0x01F2, 0x0030, 0x05EA, 0x0507, 0x0200, 0x0152, 0x0224, 0x02CE,   // 9DE0 - 9DEF
	0x05CE, 0x0260, 0x023C, 0x0594, 0x0594, 0x0556, 0x0309, 0x06A9, 0x05FB, 0x05EA, 0x02ED, 0x0559, 0x0594, 0x05C3, 0x05DE, 0x03DF,   // 9DF0 - 9DFF
	0x04D0, 0x02F9, 0x0403, 0x05DE, 0x0212, 0x0648, 0x05FB, 0x0638, 0x05DB, 0x05D2, 0x03DF, 0x0394, 0x01EF, 0x032A, 0x05EA, 0x0325,   // 9E00 - 9E0F
	0x0109, 0x0603, 0x05FB, 0x02B3, 0x004A, 0x02ED, 0x01D6, 0x02E4, 0x04E5, 0x0603, 0x05EA, 0x01AB, 0x0431, 0x02BC, 0x02F0, 0x0387,   // 9E10 - 9E1F
	0x023C, 0x0212, 0x05FE, 0x033F, 0x04C7, 0x03BB, 0x05CB, 0x005B, 0x001F, 0x064C, 0x019F, 0x0127, 0x02ED, 0x05CB, 0x059F, 0x05D2,   // 9E20 - 9E2F
	0x02DB, 0x0098, 0x0431, 0x05FE, 0x05C3, 0x0566, 0x04FB, 0x0657, 0x014C, 0x01A2, 0x05B7, 0x01E1, 0x0661, 0x0186, 0x02F0, 0x01E6,   // 9E30 - 9E3F
	0x058A, 0x004A, 0x02BC, 0x0243, 0x01EF, 0x0144, 0x05FB, 0x0594, 0x0537, 0x058A, 0x0439, 0x0332, 0x0005, 0x0294, 0x0023, 0x03DA,   // 9E40 - 9E4F
	0x040A, 0x00C3, 0x0191, 0x05FE, 0x0507, 0x01EF, 0x01D6, 0x0144, 0x019F, 0x042D, 0x00CD, 0x031D, 0x058A, 0x05DE, 0x05D7, 0x0582,   // 9E50 - 9E5F
	0x02E0, 0x0212, 0x05DE, 0x0219, 0x01D6, 0x05DE, 0x05EA, 0x0648, 0x02E0, 0x02CE, 0x0224, 0x023C, 0x05FB, 0x02ED, 0x01FB, 0x0638,   // 9E60 - 9E6F
	0x05EA, 0x01EF, 0x0325, 0x01AB, 0x04E5, 0x02ED, 0x022D, 0x02DB, 0x0219, 0x0594, 0x00E9, 0x0219, 0x0219, 0x05CE, 0x00E9, 0x02ED,   // 9E70 - 9E7F
	0x05F7, 0x00D9, 0x0212, 0x0038, 0x00D9, 0x03CE, 0x0666, 0x024C, 0x0666, 0x0219, 0x032A, 0x032A, 0x058A, 0x02E0, 0x008D, 0x024C,   // 9E80 - 9E8F
	0x02D7, 0x0379, 0x0403, 0x02ED, 0x023C, 0x024C, 0x0231, 0x02BC, 0x0599, 0x05CE, 0x0215, 0x032A, 0x02BC, 0x04B3, 0x063D, 0x02D7,   // 9E90 - 9E9F
	0x0231, 0x0403, 0x02DB, 0x05CE, 0x00D9, 0x0309, 0x0309, 0x0186, 0x0084, 0x016F, 0x032D, 0x032D, 0x016F, 0x03CE, 0x0431, 0x0431,   // 9EA0 - 9EAF
	0x034B, 0x016F, 0x0594, 0x029F, 0x0431, 0x032D, 0x0098, 0x0163, 0x016F, 0x0431, 0x032D, 0x0306, 0x0306, 0x0348, 0x0206, 0xFFFF,   // 9EB0 - 9EBF
	0x0699, 0x036D, 0x015F, 0x0200, 0x0200, 0x022D, 0x01B0, 0x053A, 0x0552, 0x01E6, 0x058D, 0x028A, 0x01E6, 0x04D0, 0x02BC, 0x037C,   // 9EC0 - 9ECF
	0x0098, 0x01D9, 0x01D9, 0x05DE, 0x040A, 0x064C, 0x058D, 0x0559, 0x0348, 0x0348, 0x040A, 0x00F0, 0x00A7, 0x05F7, 0x0110, 0x05DE,   // 9ED0 - 9EDF
	0x0590, 0x05CE, 0x0431, 0x031D, 0x05CE, 0x0422, 0x05FB, 0x02BC, 0x00F8, 0x0130, 0x0057, 0x05E6, 0x0005, 0x05CE, 0x0522, 0x0005,   // 9EE0 - 9EEF
	0x064C, 0x00F0, 0x0057, 0x05DE, 0x031D, 0x00F4, 0x05CE, 0x0130, 0x02ED, 0x0657, 0x015F, 0x016F, 0x016F, 0x033B, 0x033B, 0x05FE,   // 9EF0 - 9EFF
	0x00D9, 0x0431, 0x0084, 0x056A, 0x0666, 0x0657, 0x0311, 0x000C, 0x003D, 0x0566, 0x0030, 0x05FE, 0x0084, 0x0566, 0x011E, 0x032A,   // 9F00 - 9F0F
	0x0355, 0x011E, 0x0691, 0x019F, 0x019F, 0x0127, 0x015F, 0x052B, 0x05FE, 0x03DF, 0x007E, 0x0182, 0x0403, 0x05FE, 0x0526, 0x0532,   // 9F10 - 9F1F
	0x04D0, 0x04D0, 0x015F, 0x015B, 0x057E, 0x000F, 0x0115, 0x0566, 0x054D, 0x0431, 0x04C1, 0x04C7, 0x05F7, 0x04C7, 0x0548, 0x058A,   // 9F20 - 9F2F
	0x037C, 0x0231, 0x020A, 0x0240, 0x05CE, 0x0556, 0x04FB, 0x058D, 0x0594, 0x05CE, 0x02B3, 0x0030, 0x05D7, 0x05CE, 0x01C9, 0x0206,   // 9F30 - 9F3F
	0x058A, 0x01EB, 0x058D, 0x0186, 0x062F, 0x05B7, 0x0582, 0x062F, 0x039D, 0x035D, 0x0403, 0x0633, 0x0212, 0x0691, 0x0212, 0x0212,   // 9F40 - 9F4F
	0x0403, 0x0212, 0x0098, 0x008D, 0x008D, 0x01D6, 0x05CB, 0x0267, 0x05A4, 0x001F, 0x061F, 0x04C7, 0x0691, 0x0098, 0x037C, 0x0240,   // 9F50 - 9F5F
	0x053F, 0x02DB, 0x02DB, 0x00A7, 0x0434, 0x05A4, 0x05E6, 0x038C, 0x023C, 0x038C, 0x00C8, 0x0294, 0x05FB, 0x00A7, 0x05DE, 0x0379,   // 9F60 - 9F6F
	0x00E9, 0x00C8, 0x0431, 0x037C, 0x0594, 0x05FB, 0x0144, 0x0587, 0x05DE, 0x0098, 0x0699, 0x0110, 0x00A7, 0x022D, 0x05CB, 0x0098,   // 9F70 - 9F7F
	0x008D, 0x01D6, 0x05E6, 0x0240, 0x02DB, 0x001F, 0x053F, 0x0691, 0x05E6, 0x05FB, 0x00C8, 0x0431, 0x0587, 0x02E4, 0x03C9, 0x0196,   // 9F80 - 9F8F
	0x03C9, 0x05CE, 0x02E4, 0x02E4, 0x0196, 0x0257, 0x051B, 0x02DB, 0x051B, 0x02E4, 0x0196, 0x0257, 0x01B6, 0x042D, 0x003D, 0x01B6,   // 9F90 - 9F9F
	0x0603, 0x00BE, 0x01D6, 0x0248, 0x05A4, 0x0603, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FA0 - 9FAF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FB0 - 9FBF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FC0 - 9FCF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FD0 - 9FDF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FE0 - 9FEF
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,   // 9FF0 - 9FFF
};
