/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: indexentrysupplier_ko_dict.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:10:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define INDEXENTRYSUPPLIER_ko_dict
#include <indexentrysupplier_asian.hxx>
#include <data/indexdata_ko_dict.h>

namespace com { namespace sun { namespace star { namespace i18n {

rtl::OUString SAL_CALL IndexEntrySupplier_ko_dict::getIndexCharacter( const rtl::OUString& rIndexEntry,
	const lang::Locale& rLocale, const rtl::OUString& rSortAlgorithm ) throw (com::sun::star::uno::RuntimeException) {
	return IndexEntrySupplier_CJK::getIndexString(rIndexEntry.toChar(), idxStr, idx1, idx2);
}

rtl::OUString SAL_CALL IndexEntrySupplier_ko_dict::getIndexKey( const rtl::OUString& IndexEntry,
	const rtl::OUString& PhoneticEntry, const lang::Locale& rLocale ) 
	throw (com::sun::star::uno::RuntimeException)
{
	return IndexEntrySupplier_CJK::getIndexString(
	    PhoneticEntry.getLength() > 0 ? PhoneticEntry.toChar() : IndexEntry.toChar(), idxStr, idx1, idx2);
}

sal_Int16 SAL_CALL IndexEntrySupplier_ko_dict::compareIndexEntry( 
	const rtl::OUString& IndexEntry1, const rtl::OUString& PhoneticEntry1, const lang::Locale& rLocale1,
	const rtl::OUString& IndexEntry2, const rtl::OUString& PhoneticEntry2, const lang::Locale& rLocale2 )
	throw (com::sun::star::uno::RuntimeException)
{
	sal_Int16 result =  collator->compareString(
		PhoneticEntry1.getLength() > 0 ? PhoneticEntry1 : IndexEntry1,
		PhoneticEntry2.getLength() > 0 ? PhoneticEntry2 : IndexEntry2);

	if (result == 0 && (PhoneticEntry1.getLength() > 0 || PhoneticEntry2.getLength()))
	    return collator->compareString(IndexEntry1, IndexEntry2);
	else
	    return result;
}

} } } }
