

package org.netbeans.modules.openoffice;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;

import org.openide.compiler.*;
import org.openide.compiler.Compiler;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author  Michael Bohn
 *
 */



public class OOURDCompilerType extends ExternalCompilerType {
    
    /** Default process template.
     */
    private static final NbProcessDescriptor DEFAULT = new NbProcessDescriptor(
    // PROCESS NAME:
    "{" + OOURDCompilerGroup.Format.TAG_UDKINSTALL_DIRECTORY + "}"
    + System.getProperty("file.separator") + "bin"
    + System.getProperty("file.separator") + "javamaker",
    // LIST OF ARGUMENTS INCLUDING OPTIONS:
    "-O{" + OOURDCompilerGroup.Format.TAG_OUTPUT_DIRECTORY + "} " +
    "-nD -B/UCR " +
    "-T{" + OOURDCompilerGroup.Format.TAG_TARGET_ELEMENT + "} " +
    "{" + OOURDCompilerGroup.Format.TAG_NEEDED_LIBS + "} " +
    " {" + OOURDCompilerGroup.Format.TAG_RDB_FILE + "}" ,
    // DESCRIPTION FOR USER OF HOW TO MODIFY THE ARGUMENTS:
    NbBundle.getBundle(OOURDCompilerType.class).getString("MSG_format_hint_MCT")
    );
    
    /** Current make target for regular makes.
     */
    private String target = ""; // default to use make's own default
    
    
    
    /** Create a new compiler type.
     */
    public OOURDCompilerType() {
        setExternalCompiler(DEFAULT);
        // setErrorExpression (ERROR_EXPRS[0]);
    }
    
    /** Get the display name.
     * Workaround for 1.0 core bug; not needed in 1.1 core.
     * @return the name
     */
    protected String displayName() {
        try {
            return java.beans.Introspector.getBeanInfo(getClass()).getBeanDescriptor().getDisplayName();
        } catch (Exception e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions"))
                e.printStackTrace();
            return getClass().getName();
        }
    }
    
    
    
    
    
    
    
    
    
    /** Get the help context.
     * @return help for the compiler
     */
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    /** Add a proper compiler to the job.
     * @param job the job
     * @param type the style of compilation, controlling the target
     * @param obj the makefile
     */
    public void prepareJob(CompilerJob job, Class type, DataObject obj) {
        if (type.equals(CompilerCookie.Compile.class)){
            OOREGCompilerType cCompilerType = new OOREGCompilerType();
            //   job.add (new OOURDCompiler (obj.getPrimaryFile (), getExternalCompiler (), getErrorExpression (),target));
            job.add(new OOREGCompiler(obj.getPrimaryFile(),cCompilerType.getExternalCompiler() , cCompilerType.getErrorExpression()));}
        ; // do nothing
    }
    
}
