
package org.netbeans.modules.openoffice.wizard.nodes;

import java.beans.FeatureDescriptor;
import java.util.StringTokenizer;
import org.netbeans.modules.openoffice.wizard.panels.idl.*;

import org.netbeans.modules.openoffice.wizard.keys.*;
import org.netbeans.modules.openoffice.*;

import org.openide.nodes.AbstractNode;
import java.util.Vector;
import org.openide.nodes.Node;


public class StructMemberNode extends LeafNode
{

    public StructMemberNode(NameKey namedkey)
    {
        super(namedkey);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/declarator");
    }

    public String generateSelf(int i)
    {
        String s = new String();
        for(int j = 0; j < i; j++)
            s = s + "    ";

        AliasKey aliaskey = (AliasKey)key;
        s = s + aliaskey.getType() + " ";
        s = s + getName();
        s = s + ";\n";
        return s;
    }

    public BasePanel getEditPanel()
    {
        AliasPanel aliaspanel = new AliasPanel();
        aliaspanel.setName(getName());
        aliaspanel.setType(((AliasKey)key).getType());
        
        return aliaspanel;
    }

    public void reInit(BasePanel BasePanel)
    {
        if(BasePanel instanceof AliasPanel)
        {
            AliasPanel aliaspanel = (AliasPanel)BasePanel;
            String s = aliaspanel.getName();
            String s1 = aliaspanel.getType();
            AliasKey aliaskey = (AliasKey)key;
            if(!aliaskey.getName().equals(s))
            {
                setName(s);
                aliaskey.setName(s);
            }
            if(!aliaskey.getType().equals(s1))
                aliaskey.setType(s1);
         }
    }

    
    public void generateImports(Vector Imports1)
    {   
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/declarator";
}
