/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SchXMLWrapper.cxx,v $
 *
 *  $Revision: 1.27 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:53:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "SchXMLWrapper.hxx"

#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HXX_
#include <com/sun/star/container/XNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HXX_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HXX_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XSTATUSINDICATORSUPPLIER_HPP_
#include <com/sun/star/task/XStatusIndicatorSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XIMPORTER_HPP_
#include <com/sun/star/document/XImporter.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XFILTER_HPP_
#include <com/sun/star/document/XFilter.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XEXPORTER_HPP_
#include <com/sun/star/document/XExporter.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif

#ifndef _SFXDOCFILE_HXX
#include <sfx2/docfile.hxx>
#endif
#ifndef _SFXECODE_HXX
#include <svtools/sfxecode.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _XMLGRHLP_HXX
#include <svx/xmlgrhlp.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _COMPHELPER_GENERICPROPERTYSET_HXX_
#include <comphelper/genericpropertyset.hxx>
#endif
#ifndef _COMPHELPER_PROPERTSETINFO_HXX_
#include <comphelper/propertysetinfo.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_SAVEOPT_HXX
#include <svtools/saveopt.hxx>
#endif

#ifndef _COM_SUN_STAR_EMBED_XSTORAGE_HPP_
#include <com/sun/star/embed/XStorage.hpp>
#endif
#ifndef _COM_SUN_STAR_EMBED_ELEMENTMODES_HPP_
#include <com/sun/star/embed/ElementModes.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XERRORHANDLER_HPP_
#include <com/sun/star/xml/sax/XErrorHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XENTITYRESOLVER_HPP_
#include <com/sun/star/xml/sax/XEntityResolver.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_INPUTSOURCE_HPP_
#include <com/sun/star/xml/sax/InputSource.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XDTDHANDLER_HPP_
#include <com/sun/star/xml/sax/XDTDHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XSTREAM_HPP_
#include <com/sun/star/io/XStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATACONTROL_HPP_
#include <com/sun/star/io/XActiveDataControl.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_SAXPARSEEXCEPTION_HPP_
#include <com/sun/star/xml/sax/SAXParseException.hpp>
#endif
#ifndef _COM_SUN_STAR_PACKAGES_ZIP_ZIPIOEXCEPTION_HPP_
#include <com/sun/star/packages/zip/ZipIOException.hpp>
#endif

#define XML_STRING(i, x) sal_Char __READONLY_DATA i[sizeof(x)] = x
#define MAP_LEN(x) x, sizeof(x) - 1

XML_STRING( sXML_metaStreamName, 		"meta.xml");
XML_STRING( sXML_styleStreamName,		"styles.xml" );
XML_STRING( sXML_contentStreamName,		"content.xml" );
XML_STRING( sXML_oldContentStreamName,	"Content.xml" );

XML_STRING( sXML_export_chart_meta_service, 		"com.sun.star.comp.Chart.XMLMetaExporter" );
XML_STRING( sXML_export_chart_styles_service, 		"com.sun.star.comp.Chart.XMLStylesExporter" );
XML_STRING( sXML_export_chart_content_service,		"com.sun.star.comp.Chart.XMLContentExporter" );
XML_STRING( sXML_export_chart_old_content_service,	"com.sun.star.office.sax.exporter.Chart" );

XML_STRING( sXML_import_chart_meta_service, 		"com.sun.star.comp.Chart.XMLMetaImporter" );
XML_STRING( sXML_import_chart_styles_service,		"com.sun.star.comp.Chart.XMLStylesImporter" );
XML_STRING( sXML_import_chart_content_service,		"com.sun.star.comp.Chart.XMLContentImporter" );
XML_STRING( sXML_import_chart_old_content_service,	"com.sun.star.office.sax.importer.Chart" );

// Oasis
XML_STRING( sXML_export_chart_oasis_styles_service,     "com.sun.star.comp.Chart.XMLOasisStylesExporter" );
XML_STRING( sXML_export_chart_oasis_content_service,    "com.sun.star.comp.Chart.XMLOasisContentExporter" );

XML_STRING( sXML_import_chart_oasis_styles_service,     "com.sun.star.comp.Chart.XMLOasisStylesImporter" );
XML_STRING( sXML_import_chart_oasis_content_service,    "com.sun.star.comp.Chart.XMLOasisContentImporter" );

using namespace ::com::sun::star;
using namespace ::rtl;
using namespace comphelper;

SchXMLWrapper::SchXMLWrapper( const uno::Reference< frame::XModel >& xModel,
                              SfxMedium& rMedium,
							  sal_Bool bShowProgress ) :
		mxModel( xModel ),
        mxStorage( rMedium.GetStorage() ),
        mpMedium( &rMedium ),
		mbShowProgress( bShowProgress )
{}


sal_Int32 SchXMLWrapper::ImportStream(
	const ::rtl::OUString& rsStreamName,
	const ::rtl::OUString& rsServiceName,
	uno::Reference< xml::sax::XParser >& xParser,
	uno::Reference< lang::XMultiServiceFactory >& xServiceFactory,
	uno::Reference< document::XGraphicObjectResolver >& xGraphObjResolver,
	uno::Reference< beans::XPropertySet >& rPropSet	)
{
	xml::sax::InputSource aParserInput;
    uno::Reference < io::XStream > xStream;
	uno::Reference< io::XActiveDataSource > xSource;
    sal_Bool bEncrypted = sal_False;

    try
	{
		String sStreamName( rsStreamName );
        uno::Reference < container::XNameAccess > xAccess( mxStorage, uno::UNO_QUERY );
        if ( !xAccess->hasByName( rsStreamName ) || !mxStorage->isStreamElement( rsStreamName ) )
			return sal_False;

        xStream = mxStorage->openStreamElement( sStreamName, embed::ElementModes::READ );
        uno::Reference < beans::XPropertySet > xSet( xStream, uno::UNO_QUERY );
        if( !xSet.is())
			return sal_False;

        uno::Any aAny = xSet->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Encrypted" ) ) );
        aAny >>= bEncrypted;

		if( rPropSet.is() )
		{
			OUString sPropName( RTL_CONSTASCII_USTRINGPARAM("StreamName") );
			rPropSet->setPropertyValue( sPropName, uno::makeAny( rsStreamName ) );
		}

        aParserInput.aInputStream = xStream->getInputStream();
		if( aParserInput.aInputStream.is() )
		{
			sal_Int32 nArgs = 0;
			if( mxStatusIndicator.is())
				nArgs++;
			if( xGraphObjResolver.is())
				nArgs++;
			if( rPropSet.is())
				nArgs++;

			uno::Sequence< uno::Any > aArgs( nArgs );

			nArgs = 0;
			if( mxStatusIndicator.is())
				aArgs[ nArgs++ ] <<= mxStatusIndicator;

			if( xGraphObjResolver.is())
				aArgs[ nArgs++ ] <<= xGraphObjResolver;

			if( rPropSet.is())
				aArgs[ nArgs++ ] <<= rPropSet;

			uno::Reference< xml::sax::XDocumentHandler > xDocHandler(
				xServiceFactory->createInstanceWithArguments( rsServiceName, aArgs ),
				uno::UNO_QUERY );

			if( xDocHandler.is() )
			{
				uno::Reference< document::XImporter > xImporter( xDocHandler, uno::UNO_QUERY );
				uno::Reference< lang::XComponent > xComponent( mxModel, uno::UNO_QUERY );

				if( xImporter.is() )
				{
					xImporter->setTargetDocument( xComponent );
					xParser->setDocumentHandler( xDocHandler );

					xParser->parseStream( aParserInput );
				}
			}
		}
	}
    catch( packages::WrongPasswordException& )
	{
		return ERRCODE_SFX_WRONGPASSWORD;
	}
	catch( xml::sax::SAXParseException& aEx )
    {
        if( bEncrypted )
            return ERRCODE_SFX_WRONGPASSWORD;

#ifdef DBG_UTIL
		// convert rtl::OUString => tools String => ByteString
		String aStr( aEx.Message );
		ByteString aBStr( aStr, RTL_TEXTENCODING_ASCII_US );
		ByteString aBStrStreamName = ByteString( String( rsStreamName ), RTL_TEXTENCODING_ASCII_US );
		DBG_ERROR2( "SAX parse exception caught during import of \"%s\" stream(): %s",
					aBStrStreamName.GetBuffer(),
					aBStr.GetBuffer());
#endif
        return ERRCODE_SFX_GENERAL;
    }
	catch( xml::sax::SAXException& aEx )
    {
        if( bEncrypted )
            return ERRCODE_SFX_WRONGPASSWORD;

#ifdef DBG_UTIL
		// convert rtl::OUString => tools String => ByteString
		String aStr( aEx.Message );
		ByteString aBStr( aStr, RTL_TEXTENCODING_ASCII_US );
		ByteString aBStrStreamName = ByteString( String( rsStreamName ), RTL_TEXTENCODING_ASCII_US );
		DBG_ERROR2( "SAX exception caught during import of \"%s\" stream(): %s",
					aBStrStreamName.GetBuffer(),
					aBStr.GetBuffer());
#endif
        return ERRCODE_SFX_GENERAL;
    }
  	catch( packages::zip::ZipIOException& aEx )
    {
#ifdef DBG_UTIL
		// convert rtl::OUString => tools String => ByteString
		String aStr( aEx.Message );
		ByteString aBStr( aStr, RTL_TEXTENCODING_ASCII_US );
		ByteString aBStrStreamName = ByteString( String( rsStreamName ), RTL_TEXTENCODING_ASCII_US );
		DBG_ERROR2( "IO exception caught during import of \"%s\" stream(): %s",
					aBStrStreamName.GetBuffer(),
					aBStr.GetBuffer());
#endif
        return ERRCODE_IO_BROKENPACKAGE;
	}
  	catch( io::IOException& aEx )
    {
#ifdef DBG_UTIL
		// convert rtl::OUString => tools String => ByteString
		String aStr( aEx.Message );
		ByteString aBStr( aStr, RTL_TEXTENCODING_ASCII_US );
		ByteString aBStrStreamName = ByteString( String( rsStreamName ), RTL_TEXTENCODING_ASCII_US );
		DBG_ERROR2( "IO exception caught during import of \"%s\" stream(): %s",
					aBStrStreamName.GetBuffer(),
					aBStr.GetBuffer());
#endif
        return ERRCODE_SFX_GENERAL;
	}
	catch( uno::Exception& aEx )
	{
#ifdef DBG_UTIL
		// convert rtl::OUString => tools String => ByteString
		String aStr( aEx.Message );
		ByteString aBStr( aStr, RTL_TEXTENCODING_ASCII_US );
		ByteString aBStrStreamName = ByteString( String( rsStreamName ), RTL_TEXTENCODING_ASCII_US );
		DBG_ERROR2( "UNO exception caught during import of \"%s\" stream(): %s",
					aBStrStreamName.GetBuffer(),
					aBStr.GetBuffer());
#endif
        return ERRCODE_SFX_GENERAL;
	}

	return 0;
}

sal_Int32 SchXMLWrapper::Import()
{
	sal_Int32 nWarning = 0;
    bool bOasis = (SotStorage::GetVersion( mxStorage ) > SOFFICE_FILEFORMAT_60);

	if( !mxModel.is() )
	{
		DBG_ERROR("Got NO Model in XMLImport");
		return sal_False;
	}

	uno::Reference<lang::XServiceInfo> xServiceInfo( mxModel, uno::UNO_QUERY );

	if( !xServiceInfo.is() || !xServiceInfo->supportsService( OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.chart.ChartDocument" ) ) ) )
	{
		DBG_ERROR( "Model is no ChartDocument in XMLImport" );
		return sal_False;
	}

	uno::Reference< lang::XMultiServiceFactory> xServiceFactory( ::comphelper::getProcessServiceFactory() );

	if( !xServiceFactory.is() )
	{
		DBG_ERROR( "XMLReader::Read: got no service manager" );
		return sal_False;
	}

	// get the sax parser component
	uno::Reference< xml::sax::XParser > xXMLParser(
		xServiceFactory->createInstance( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.xml.sax.Parser" ))),
		uno::UNO_QUERY );

	if( ! xXMLParser.is() )
	{
		DBG_ERROR( "com.sun.star.xml.sax.Parser service missing" );
		return sal_False;
	}

	// create XPropertySet with three properties for status indicator
	comphelper::PropertyMapEntry aInfoMap[] =
	{
		{ "PrivateData", sizeof("PrivateData")-1, 0,
			  &::getCppuType( (uno::Reference<uno::XInterface> *)0 ),
			  beans::PropertyAttribute::MAYBEVOID, 0 },
		{ "BaseURI", sizeof("BaseURI")-1, 0,
			  &::getCppuType( (OUString *)0 ),
			  beans::PropertyAttribute::MAYBEVOID, 0 },
		{ "StreamRelPath", sizeof("StreamRelPath")-1, 0,
			  &::getCppuType( (OUString *)0 ),
			  beans::PropertyAttribute::MAYBEVOID, 0 },
		{ "StreamName", sizeof("StreamName")-1, 0,
			  &::getCppuType( (OUString *)0 ),
			  beans::PropertyAttribute::MAYBEVOID, 0 },
		{ "BuildId", sizeof("BuildId")-1, 0,
			  &::getCppuType( (OUString *)0 ),
			  ::com::sun::star::beans::PropertyAttribute::MAYBEVOID, 0 },
		{ NULL, 0, 0, NULL, 0, 0 }
	};
	uno::Reference< beans::XPropertySet > xInfoSet(
				comphelper::GenericPropertySet_CreateInstance(
							new comphelper::PropertySetInfo( aInfoMap ) ) );

	// Set base URI
	OUString aHierarchName;
	if ( mxModel.is() )
	{
		uno::Sequence< beans::PropertyValue > aModProps = mxModel->getArgs();
		for ( sal_Int32 nInd = 0; nInd < aModProps.getLength(); nInd++ )
            if ( aModProps[nInd].Name.equals(
						::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "HierarchicalDocumentName" ) ) ) )
			{
				// Actually this argument only has meaning for embedded documents
				aModProps[nInd].Value >>= aHierarchName;
			}
	}

	OUString sPropName( RTL_CONSTASCII_USTRINGPARAM("BaseURI") );
    xInfoSet->setPropertyValue( sPropName, uno::makeAny( mpMedium->GetBaseURL() ) );

	if( aHierarchName.getLength() )
	{
		sPropName = OUString(RTL_CONSTASCII_USTRINGPARAM("StreamRelPath"));
		xInfoSet->setPropertyValue( sPropName, uno::makeAny( aHierarchName ) );
	}

	// create graphics resolver component
    SvXMLGraphicHelper* pGraphicHelper = SvXMLGraphicHelper::Create( mxStorage, GRAPHICHELPER_MODE_READ );
	uno::Reference< document::XGraphicObjectResolver > xGraphObjResolver = pGraphicHelper;

	// import meta information
	ImportStream(
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_metaStreamName )),
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_import_chart_meta_service )),
		xXMLParser, xServiceFactory, xGraphObjResolver, xInfoSet );

	// import styles
    ImportStream(
		::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_styleStreamName )),
        bOasis
        ? ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_import_chart_oasis_styles_service ))
        : ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_import_chart_styles_service )),
		xXMLParser, xServiceFactory, xGraphObjResolver, xInfoSet );

	// import content
    nWarning = ImportStream(
        ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_contentStreamName )),
        bOasis
        ? ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_import_chart_oasis_content_service ))
        : ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_import_chart_content_service )),
        xXMLParser, xServiceFactory, xGraphObjResolver, xInfoSet );

	// import of "content.xml" didn't work - try old "Content.xml" stream
	if( nWarning != 0 )
	{
		nWarning = ImportStream(
			::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_oldContentStreamName )),
			::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_import_chart_old_content_service )),
			xXMLParser, xServiceFactory, xGraphObjResolver, xInfoSet );
	}

	// graphics resolver has to be destroyed this way!
	SvXMLGraphicHelper::Destroy( pGraphicHelper );

	return nWarning;
}

// -----------------------------------------------------------------------------

sal_Bool SchXMLWrapper::ExportStream(
	const ::rtl::OUString& rsStreamName,
	const ::rtl::OUString& rsServiceName,
	uno::Reference< io::XActiveDataSource >& xDataSource,
	uno::Reference< lang::XMultiServiceFactory>& xServiceFactory,
	uno::Sequence< uno::Any >& aArgs )
{
	sal_Bool bRet = sal_False;
    uno::Reference < io::XStream > xStream;

	try
	{
		// create output stream
        xStream = mxStorage->openStreamElement( rsStreamName, embed::ElementModes::READWRITE | embed::ElementModes::TRUNCATE );
        uno::Reference < beans::XPropertySet > xSet( xStream, uno::UNO_QUERY );
        if( !xSet.is())
			return sal_False;

		rtl::OUString sMIMEType( RTL_CONSTASCII_USTRINGPARAM( "text/xml" ) );
		uno::Any aAny;
		aAny <<= sMIMEType;
        xSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "MediaType" )), aAny );

        // "Encrypted" means "Encryptable". Has to be set for all but the meta stream (which doesn't exist in charts)
        aAny <<= (sal_Bool)(sal_True);
//REMOVE	        xSet->setPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Encrypted" )), aAny );
        xSet->setPropertyValue(
			::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "UseCommonStoragePasswordEncryption" )),
			aAny );

		if( xDataSource.is())
            xDataSource->setOutputStream( xStream->getOutputStream() );


		// set Base URL
		uno::Reference< beans::XPropertySet > xInfoSet;
		if( aArgs.getLength() > 0 )
			aArgs.getConstArray()[0] >>= xInfoSet;
		DBG_ASSERT( xInfoSet.is(), "missing property set" );
		if( xInfoSet.is() )
		{
			OUString sPropName( RTL_CONSTASCII_USTRINGPARAM("StreamName") );
			xInfoSet->setPropertyValue( sPropName, uno::makeAny( rsStreamName ) );
		}

		uno::Reference< document::XFilter > xFilter(
			xServiceFactory->createInstanceWithArguments( rsServiceName, aArgs ),
			uno::UNO_QUERY );

		if( xFilter.is())
		{
			uno::Reference< document::XExporter > xExporter( xFilter, uno::UNO_QUERY );
			if( xExporter.is())
			{
				uno::Reference< lang::XComponent > xModelComponent( mxModel, uno::UNO_QUERY );
				xExporter->setSourceDocument( xModelComponent );
			}

			// empty Descriptior (formerly FileName was given)
			uno::Sequence< beans::PropertyValue > aEmptyDescriptor( 0 );
			bRet = xFilter->filter( aEmptyDescriptor );

            // stream is closed by SAX parser
            //if( bRet && xStream.is())
            //    xStream->getOutputStream()->closeOutput();
		}
	}
	catch( uno::Exception aEx )
	{
#ifdef DBG_UTIL
		// convert rtl::OUString => tools String => ByteString
		String aStr( aEx.Message );
		ByteString aBStr( aStr, RTL_TEXTENCODING_ASCII_US );
		ByteString aBStrStreamName = ByteString( String( rsStreamName ), RTL_TEXTENCODING_ASCII_US );
		DBG_ERROR2( "Exception caught during Export of \"%s\" stream(): %s",
					aBStrStreamName.GetBuffer(),
					aBStr.GetBuffer());
#endif
	}

	return bRet;
}

sal_Bool SchXMLWrapper::Export()
{
    bool bOasis = (SotStorage::GetVersion( mxStorage ) > SOFFICE_FILEFORMAT_60);
	sal_Bool bRet = sal_False;

	try
	{
		if( !mxModel.is() )
		{
			DBG_ERROR("Got NO Model in XMLExport");
			return sal_False;
		}

		uno::Reference< lang::XServiceInfo > xServiceInfo( mxModel, uno::UNO_QUERY );

		if( ! xServiceInfo.is() || !xServiceInfo->supportsService(
			OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.chart.ChartDocument" ) ) ) )
		{
			DBG_ERROR( "Model is no ChartDocument in XMLExport" );
			return sal_False;
		}

		uno::Reference< lang::XMultiServiceFactory> xServiceFactory( ::comphelper::getProcessServiceFactory() );

		if( !xServiceFactory.is() )
		{
			DBG_ERROR( "got no service manager" );
			return sal_False;
		}

		uno::Reference< uno::XInterface > xWriter( xServiceFactory->createInstance(
			OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.xml.sax.Writer" ) ) ) );

		if( !xWriter.is() )
		{
			DBG_ERROR( "com.sun.star.xml.sax.Writer service missing" );
			return sal_False;
		}
		uno::Reference<xml::sax::XDocumentHandler > xHandler( xWriter, uno::UNO_QUERY );
		uno::Sequence< beans::PropertyValue > aEmptyDescriptor( 0 );


		/** property map for export info set */
		PropertyMapEntry aExportInfoMap[] =
		{
			{ MAP_LEN( "UsePrettyPrinting"),0, &::getBooleanCppuType(),				::com::sun::star::beans::PropertyAttribute::MAYBEVOID, 0},
			{ "BaseURI", sizeof("BaseURI")-1, 0,
				  &::getCppuType( (OUString *)0 ),
				  beans::PropertyAttribute::MAYBEVOID, 0 },
			{ "StreamRelPath", sizeof("StreamRelPath")-1, 0,
				  &::getCppuType( (OUString *)0 ),
				  beans::PropertyAttribute::MAYBEVOID, 0 },
			{ "StreamName", sizeof("StreamName")-1, 0,
				  &::getCppuType( (OUString *)0 ),
				  beans::PropertyAttribute::MAYBEVOID, 0 },
			{ NULL, 0, 0, NULL, 0, 0 }
		};

		uno::Reference< beans::XPropertySet > xInfoSet( GenericPropertySet_CreateInstance( new PropertySetInfo( aExportInfoMap ) ) );

		SvtSaveOptions aSaveOpt;
		OUString sUsePrettyPrinting(RTL_CONSTASCII_USTRINGPARAM("UsePrettyPrinting"));
		sal_Bool bUsePrettyPrinting( aSaveOpt.IsPrettyPrinting() );
		xInfoSet->setPropertyValue( sUsePrettyPrinting, uno::makeAny( bUsePrettyPrinting ) );


        SvXMLGraphicHelper* pGraphicHelper = SvXMLGraphicHelper::Create( mxStorage, GRAPHICHELPER_MODE_WRITE, sal_False );
		uno::Reference< document::XGraphicObjectResolver > xGraphObjResolver( pGraphicHelper );
		uno::Reference< io::XActiveDataSource > xDataSource( xWriter, uno::UNO_QUERY );

		// Set base URI
		OUString aHierarchName;
		if ( mxModel.is() )
		{
			uno::Sequence< beans::PropertyValue > aModProps = mxModel->getArgs();
			for ( sal_Int32 nInd = 0; nInd < aModProps.getLength(); nInd++ )
                if ( aModProps[nInd].Name.equals(
							::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "HierarchicalDocumentName" ) ) ) )
				{
					// Actually this argument only has meaning for embedded documents
					aModProps[nInd].Value >>= aHierarchName;
				}
		}

		OUString sPropName( RTL_CONSTASCII_USTRINGPARAM("BaseURI") );
        xInfoSet->setPropertyValue( sPropName, uno::makeAny( mpMedium->GetBaseURL( true ) ) );

		if( aHierarchName.getLength() )
		{
			sPropName = OUString(RTL_CONSTASCII_USTRINGPARAM("StreamRelPath"));
			xInfoSet->setPropertyValue( sPropName, uno::makeAny( aHierarchName ) );
		}

		// there is no meta info needed in charts - they are always OLE objects
		// export meta
//  		uno::Sequence< uno::Any > aMetaArgs( 1 );
//  		aMetaArgs[ 0 ] <<= xHandler;
//  		bRet = ExportStream(
//  			::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_metaStreamName )),
//  			::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_export_chart_meta_service )),
//  			xDataSource, xServiceFactory, aMetaArgs );

		// prepare arguments: document handler / status indicator and graphics resolver
		sal_Int32 nArgs = 2;
		if( mxStatusIndicator.is())
			nArgs++;
		if( xGraphObjResolver.is())
			nArgs++;

		uno::Sequence< uno::Any > aArgs( nArgs );

		nArgs = 0;
		aArgs[ nArgs++ ] <<= xInfoSet;
		aArgs[ nArgs++ ] <<= xHandler;

		if( mxStatusIndicator.is())
			aArgs[ nArgs++ ] <<= mxStatusIndicator;
		if( xGraphObjResolver.is())
			aArgs[ nArgs++ ] <<= xGraphObjResolver;

		// styles export
        bRet = ExportStream(
            ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_styleStreamName )),
            bOasis
            ? ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_export_chart_oasis_styles_service ))
            : ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_export_chart_styles_service )),
            xDataSource, xServiceFactory, aArgs );

		// content export
		bRet = ExportStream(
			::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_contentStreamName )),
            bOasis
            ? ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_export_chart_oasis_content_service ))
            : ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( sXML_export_chart_content_service )),
			xDataSource, xServiceFactory, aArgs );

		// graphics resolver has to be destroyed this way!
		SvXMLGraphicHelper::Destroy( pGraphicHelper );
	}
	catch( uno::Exception aEx )
	{
#ifdef DBG_UTIL
		// convert rtl::OUString => tools String => ByteString
		String aStr( aEx.Message );
		ByteString aBStr( aStr, RTL_TEXTENCODING_ASCII_US );
		DBG_ERROR1( "Exception caught during Export of : %s", aBStr.GetBuffer());
#endif
	}

	return bRet;
}
