/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fu3d.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:19:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _VIEWPT3D_HXX //autogen
#include <svx/viewpt3d.hxx>
#endif


#pragma hdrstop
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif

#include <sfx2/viewfrm.hxx>
#include <svx/svxids.hrc>

#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#include "app.hrc"
#include "schresid.hxx"
#include "strings.hrc"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "un3dview.hxx"
#include "chtscene.hxx"
#include <svx/camera3d.hxx>
#include "fu3d.hxx"
#include "viewdlg.hxx"

#ifndef _E3D_UNDO_HXX
#include "svx/e3dundo.hxx"
#endif

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/
#define RAD2DDEG(fAngle) ( (long)(((fAngle)*1800.0/F_PI)+3600.0)%3600 )
#define DDEG2RAD(fAngle) (  (double)(fAngle)*F_PI/1800.0 )

SchFu3D::SchFu3D(SchViewShell     *pViewSh,
				 SchWindow        *pWin,
				 SchView          *pView,
				 ChartModel *pDoc,
				 SfxRequest       &rReq)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	short nXOld, nYOld, nZOld;

	pDoc->GetAngles (nXOld, nYOld, nZOld);


	ChartScene* pScene = pDoc->GetScene();
	Matrix4D aSceneMatrix = pScene->GetTransform();
	Vector3D aVRot,aVTrans,aVShear,aVScale;
	aSceneMatrix.Decompose(aVScale,aVTrans,aVRot,aVShear);
	nXOld=RAD2DDEG(aVRot.X());
	nYOld=RAD2DDEG(aVRot.Y());
	nZOld=RAD2DDEG(aVRot.Z());


//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//    SchView3DDlg* pDlg = new SchView3DDlg(&(pViewSh->GetViewFrame()->GetWindow()), nXOld, nYOld, nZOld);
	SchView3DDlg* pDlg = new SchView3DDlg(NULL, nXOld, nYOld, nZOld);

	//if (pDoc->ChartStyle() == CHSTYLE_3D_PIE)
	if(!pDoc->IsReal3D())
	{
//        pDlg->SetMax(850, 3600, 900);
		pDlg->SetMax(3600, 3600,3600);
		pDlg->SetMin(0, 0, 0);
		pDlg->DisableOnPie ();
	}
	else
	{
//        pDlg->SetMax(900, 900, 900);
		pDlg->SetMax(3600, 3600,3600);
		pDlg->SetMin(0, 0, 0);
	}

	if (pDlg->Execute() == RET_OK)
	{
		if( pViewShell )
			pViewShell->GetViewFrame()->GetDispatcher()->Execute(
				SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON );

		short nXAngle = pDlg->GetXAngle();
		short nYAngle = pDlg->GetYAngle();
		short nZAngle = pDlg->GetZAngle();
		pScene = pDoc->GetScene();

        // #i22858# don't add this UndoAction. It results in a GPF.  Undo does
        // not work quite right, but the problem here is that the Decompose()
        // method cannot return the correct angles.
// 		if(pScene)
// 		{
// 			Matrix4D aOldTrans = pScene->GetTransform();
// 			pScene->ResetTransform();
// 			pScene->FitSnapRectToBoundVol();
// 			pScene->SetRectsDirty();
// 			E3dRotateUndoAction* pUndo = new E3dRotateUndoAction(
// 				pDoc,
// 				pScene,
// 				aOldTrans,
// 				pScene->GetTransform());
// 			pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
// 		}

		if (nXAngle != nXOld || nYAngle != nYOld || nZAngle != nZOld)
		{
			pDoc->SetAngles(nXAngle, nYAngle, nZAngle);

			if(pDoc->IsReal3D())
			{
				Rectangle& rRect = pDoc->GetChartRect();
				long	nW = rRect.GetWidth();
				long	nH = rRect.GetHeight();

				Camera3D aCam(pScene->GetCamera());
				aCam.SetViewWindow(-nW/2, -nH/2, nW, nH);
				aCam.Reset();
				aCam.SetProjection(pDoc->GetProjection());
				aCam.RotateAroundLookAt(DEG2RAD((double)nYAngle / (double)10),
										DEG2RAD((double)nXAngle / (double)10));
				aCam.SetBankAngle(DEG2RAD(-(double)nZAngle / (double)10));
				pScene->SetCamera(aCam);
/*				Matrix4D aMatrix;
				aMatrix.RotateX(DDEG2RAD(nXAngle));
				aMatrix.RotateY(DDEG2RAD(nYAngle));
				aMatrix.RotateZ(DDEG2RAD(nZAngle));
				pScene->SetTransform(aMatrix);*/
			}

			pDoc->SetChanged();

			if(	!pDoc->IsReal3D()/*(pDoc->ChartStyle() == CHSTYLE_3D_PIE)*/ ||pDoc->ShowXAxisTitle() ||  pDoc->ShowYAxisTitle() || pDoc->ShowZAxisTitle())
			{
				pDoc->BuildChart(FALSE);
			}
			else
			{
				pWindow->Invalidate();
			}

			SchUndo3DView* pUndo = new SchUndo3DView(*pDoc, nXOld, nYOld, nZOld,
													 nXAngle, nYAngle, nZAngle);
			pUndo->SetComment(String(SchResId(STR_UNDO_3D_VIEW)));

			pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
		}
	}

	RemarkObject ();
	delete pDlg;
	rReq.Done();
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchFu3D::~SchFu3D()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFu3D::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFu3D::Deactivate()
{
}



