/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: undgraut.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:28:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS
#include <svx/chrtitem.hxx>

#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "undgraut.hxx"

TYPEINIT1(SchUndoDiagramAutoPilot, SchUndoAction);


/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchUndoDiagramAutoPilot::~SchUndoDiagramAutoPilot()
{
    // if there was no change, both pointers may point to the same object
    if (pOldPieSegOfs == pNewPieSegOfs)
        delete[] pOldPieSegOfs;
    else
    {
        delete[] pOldPieSegOfs;        
        delete[] pNewPieSegOfs;
    }
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoDiagramAutoPilot::Undo()
{

	for (short i = 0; i < nOldPieSegCount; i++)
		rDoc.SetPieSegOfs( i, pOldPieSegOfs[ i ] );

	rDoc.ShowMainTitle ()  = bOldShowMainTitle;
	rDoc.MainTitle ()      = aOldMainTitle;
	rDoc.ShowSubTitle ()   = bOldShowSubTitle;
	rDoc.SubTitle ()       = aOldSubTitle;
	rDoc.ShowXAxisTitle () = bOldShowXAxisTitle;
	rDoc.XAxisTitle ()     = aOldXAxisTitle;
	rDoc.ShowYAxisTitle () = bOldShowYAxisTitle;
	rDoc.YAxisTitle ()     = aOldYAxisTitle;
	rDoc.ShowZAxisTitle () = bOldShowZAxisTitle;
	rDoc.ZAxisTitle ()     = aOldZAxisTitle;
	rDoc.ShowXAxis(bOldShowXAxis);
	rDoc.ShowXGridMain ()  = bOldShowXGridMain;
	rDoc.ShowXGridHelp ()  = bOldShowXGridHelp;
	rDoc.ShowXDescr(bOldShowXDescr);
	rDoc.ShowYAxis (bOldShowYAxis);
	rDoc.ShowYGridMain ()  = bOldShowYGridMain;
	rDoc.ShowYGridHelp ()  = bOldShowYGridHelp;
	rDoc.ShowYDescr (bOldShowYDescr);
	rDoc.ShowZAxis (bOldShowZAxis);
	rDoc.ShowZGridMain ()  = bOldShowZGridMain;
	rDoc.ShowZGridHelp ()  = bOldShowZGridHelp;
	rDoc.ShowZDescr (bOldShowZDescr);
	rDoc.SetSwitchData (bOldSwitchData);

	SfxItemSet aAttr(rDoc.GetLegendAttr());
	aAttr.Put(SvxChartLegendPosItem(eOldLegendPos));
	rDoc.PutLegendAttr(aAttr);

	//#54870# ChangeChart MUSS! aufgerufen werden!!!
	rDoc.ChangeChart( eOldStyle );
	rDoc.BuildChart(FALSE);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoDiagramAutoPilot::Redo()
{

	for (short i = 0; i < nNewPieSegCount; i++)
		rDoc.SetPieSegOfs( i, pNewPieSegOfs[ i ] );

	rDoc.ShowMainTitle ()  = bNewShowMainTitle;
	rDoc.MainTitle ()      = aNewMainTitle;
	rDoc.ShowSubTitle ()   = bNewShowSubTitle;
	rDoc.SubTitle ()       = aNewSubTitle;
	rDoc.ShowXAxisTitle () = bNewShowXAxisTitle;
	rDoc.XAxisTitle ()     = aNewXAxisTitle;
	rDoc.ShowYAxisTitle () = bNewShowYAxisTitle;
	rDoc.YAxisTitle ()     = aNewYAxisTitle;
	rDoc.ShowZAxisTitle () = bNewShowZAxisTitle;
	rDoc.ZAxisTitle ()     = aNewZAxisTitle;
	rDoc.ShowXAxis (bNewShowXAxis);
	rDoc.ShowXGridMain ()  = bNewShowXGridMain;
	rDoc.ShowXGridHelp ()  = bNewShowXGridHelp;
	rDoc.ShowXDescr (bNewShowXDescr);
	rDoc.ShowYAxis (bNewShowYAxis);
	rDoc.ShowYGridMain ()  = bNewShowYGridMain;
	rDoc.ShowYGridHelp ()  = bNewShowYGridHelp;
	rDoc.ShowYDescr (bNewShowYDescr);
	rDoc.ShowZAxis (bNewShowZAxis);
	rDoc.ShowZGridMain ()  = bNewShowZGridMain;
	rDoc.ShowZGridHelp ()  = bNewShowZGridHelp;
	rDoc.ShowZDescr (bNewShowZDescr);
	rDoc.SetSwitchData (bNewSwitchData);

	//#54870# ChangeChart muss aufgerufen werden!
	rDoc.ChangeChart( eNewStyle );
	rDoc.BuildChart(FALSE);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchUndoDiagramAutoPilot::CanRepeat(SfxRepeatTarget& rView) const
{
	return FALSE;
}



