/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SchTransferable.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:11:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "SchTransferable.hxx"

#include "schmod.hxx"

#ifndef _SVDMODEL_HXX
#include <svx/svdmodel.hxx>
#endif
#ifndef _SVDXCGV_HXX
#include <svx/svdxcgv.hxx>
#endif
#ifndef _SVDPAGE_HXX
#include <svx/svdpage.hxx>
#endif

#ifndef _SVDOGRAF_HXX
#include <svx/svdograf.hxx>
#endif
#ifndef _CPPUHELPER_QUERYINTERFACE_HXX_
#include <cppuhelper/queryinterface.hxx>
#endif
// header for class OGuard
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
// header for class Application
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _UNTOOLS_UCBSTREAMHELPER_HXX
#include <unotools/ucbstreamhelper.hxx>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#include <tools/shl.hxx>

#define SCH_TRANSFER_OBJECTTYPE_OLE			0x00000001
#define SCH_TRANSFER_OBJECTTYPE_DRAWMODEL   0x00000002

using namespace ::com::sun::star;

SchTransferable::SchTransferable( SdrModel* pObjModel,
                                  SdrExchangeView* pSrcView,
                                  const TransferableObjectDescriptor& rObjDesc,
                                  sal_Bool bLateInit /* sal_False */ ) :
    mpContentModel   ( pObjModel ),
    mpSourceView     ( pSrcView ),
    mpOwnModel       ( NULL ),
    mpOwnView        ( NULL ),
    mpGraphic        ( NULL ),
    maObjDesc        ( rObjDesc ),
    mbLateInit       ( bLateInit ),
    mbDataCreated    ( false )
{
    if( ! mbLateInit )
        CreateData();
}

SchTransferable::~SchTransferable()
{
    ::vos::OGuard aGuard( Application::GetSolarMutex());

    ObjectReleased();

    // note: the external view is NOT owned by the transferable
    if( mpOwnView )
        delete mpOwnView;

    // important: delete model after view!
    if( mpOwnModel )
        delete mpOwnModel;
    else if( mpContentModel )
    {
        // the transferable owns the model
        delete mpContentModel;
    }

    if( mpGraphic )
        delete mpGraphic;
}

void SchTransferable::CreateData()
{
    // copy to clipboard
	if( mpContentModel && ! mpSourceView )
	{
        ::vos::OGuard aGuard( Application::GetSolarMutex());
		const SdrPage* pPage = mpContentModel->GetPage( 0 );

		if( pPage && pPage->GetObjCount() == 1 )
		{
			SdrObject* pObj = pPage->GetObj( 0 );
			if( pObj->ISA( SdrGrafObj ))
			{
				if( mpGraphic )
					delete mpGraphic;

				mpGraphic = new Graphic( ((SdrGrafObj*) pObj )->GetTransformedGraphic());
			}
		}

        // get size of selected objects

        mpOwnView = new SdrExchangeView( mpContentModel );
        Point aPos;
        SdrPageView* pPv = mpOwnView->ShowPagePgNum( 0, aPos );
        mpOwnView->MarkAll( pPv );
        Size aSize = mpOwnView->GetAllMarkedRect().GetSize();
        maObjDesc.maSize = aSize;
        mpSourceView = mpOwnView;
	}
    // drag and drop and selection clipboard
    else if( mpSourceView && ! mpContentModel )
	{
        ::vos::OGuard aGuard( Application::GetSolarMutex());
        const SdrMarkList&	rMarkList = mpSourceView->GetMarkedObjectList();

		if( rMarkList.GetMarkCount() == 1 )
		{
			const SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();

			if ( pObj && pObj->ISA( SdrGrafObj ) )
				mpGraphic = new Graphic( ((SdrGrafObj*) pObj )->GetTransformedGraphic());
		}

        mpOwnModel = mpSourceView->GetMarkedObjModel();
        mpContentModel = mpOwnModel;
	}

	mbDataCreated = true;
}

// protected - implementation of TransferableHelper methods
void SchTransferable::AddSupportedFormats()
{
    if( ! mbLateInit &&
		! mbDataCreated )
	    CreateData();

	if( mpGraphic )
	{
		AddFormat( SOT_FORMATSTR_ID_SVXB );

		if( mpGraphic->GetType() == GRAPHIC_BITMAP )
		{
			AddFormat( SOT_FORMAT_BITMAP );
			AddFormat( SOT_FORMAT_GDIMETAFILE );
		}
		else
		{
			AddFormat( SOT_FORMAT_GDIMETAFILE );
			AddFormat( SOT_FORMAT_BITMAP );
		}
	}
    else
    {
        AddFormat( SOT_FORMAT_GDIMETAFILE );
        AddFormat( SOT_FORMAT_BITMAP );
    }
}

sal_Bool SchTransferable::GetData( const datatransfer::DataFlavor& rFlavor )
{
	sal_uInt32	nFormat = SotExchange::GetFormat( rFlavor );
	sal_Bool	bOK = sal_False;

	if( mbLateInit )
		CreateData();

	DBG_ASSERT( mbDataCreated, "Clipboard data has not been created!" );

	if( HasFormat( nFormat ) )
	{
		if( ( nFormat == SOT_FORMATSTR_ID_LINKSRCDESCRIPTOR ||
			  nFormat == SOT_FORMATSTR_ID_OBJECTDESCRIPTOR ))
		{
            bOK = SetTransferableObjectDescriptor( maObjDesc, rFlavor );
		}
		else if( nFormat == FORMAT_GDIMETAFILE ||
                 nFormat == FORMAT_BITMAP )
        {
            DBG_ASSERT( mpSourceView, "Invalid View!" );
            if( mpSourceView )
            {
                if( nFormat == FORMAT_GDIMETAFILE )
                {
                    bOK = SetGDIMetaFile( mpSourceView->GetAllMarkedMetaFile( TRUE ), rFlavor );
                }
                else if( nFormat == FORMAT_BITMAP )
                {
                    bOK = SetBitmap( mpSourceView->GetAllMarkedBitmap( TRUE ), rFlavor );
                }
            }
        }
		else if( nFormat == FORMAT_STRING )
		{
			bOK = SetString( String(), rFlavor );
		}
		else if( ( nFormat == SOT_FORMATSTR_ID_SVXB ) && mpGraphic )
		{
            bOK = SetGraphic( *mpGraphic, rFlavor );
		}
		else if( nFormat == SOT_FORMATSTR_ID_EMBED_SOURCE )
		{
            DBG_ERROR( "No longer supported" );
            bOK = sal_False;
		}
	}

	return bOK;	
}

sal_Bool SchTransferable::WriteObject(
	SotStorageStreamRef& rxOStm, void* pUserObject, sal_uInt32 nUserObjectId,
	const datatransfer::DataFlavor& rFlavor )
{
    if( nUserObjectId == SCH_TRANSFER_OBJECTTYPE_DRAWMODEL ||
        nUserObjectId == SCH_TRANSFER_OBJECTTYPE_OLE )
        DBG_ERROR( "No longer supported" );

    return sal_False;

    // paste as OLE-Chart and paste of objects as drwing format are no longer supported (see #90893#)
#if 0
	sal_Bool bRet = sal_False;

	switch( nUserObjectId )
	{
		case SCH_TRANSFER_OBJECTTYPE_OLE  :
			{
                DBG_ERROR( "No longer supported" );
                bRet = sal_False;
			}
			break;

        case SCH_TRANSFER_OBJECTTYPE_DRAWMODEL:
            {
                SdrModel* pDrawModel = (SdrModel*)pUserObject;

//BFS04                pDrawModel->SetStreamingSdrModel( TRUE );

                //  SdrModel stream operator doesn't support XML
                //! call XML export here!
                rxOStm->SetVersion( SOFFICE_FILEFORMAT_50 );

                rxOStm->SetBufferSize( 0xff00 );
//BFS01                pDrawModel->PreSave();
                pDrawModel->GetItemPool().SetFileFormatVersion( (USHORT)rxOStm->GetVersion() );
                pDrawModel->GetItemPool().Store( *rxOStm );
                *rxOStm << *pDrawModel;
//BFS01                pDrawModel->PostSave();
                rxOStm->Commit();
//BFS04                pDrawModel->SetStreamingSdrModel( FALSE );
                bRet = ( rxOStm->GetError() == ERRCODE_NONE );
            }
            break;

		default:
			break;
	}

	return bRet;
#endif
}

void SchTransferable::ObjectReleased()
{
	::vos::OGuard aGuard( Application::GetSolarMutex());

	if( this == SCH_MOD1()->GetDragTransferable())
		SCH_MOD1()->SetDragTransferable( NULL );

	if( this == SCH_MOD1()->GetClipboardTransferable())
		SCH_MOD1()->SetClipboardTransferable( NULL );

	if( this == SCH_MOD1()->GetSelectionClipboardTransferable())
		SCH_MOD1()->SetSelectionClipboardTransferable( NULL );

    TransferableHelper::ObjectReleased();
}

// XUnoTunnel
sal_Int64 SAL_CALL SchTransferable::getSomething( const uno::Sequence< sal_Int8 >& aIdentifier )
	throw( uno::RuntimeException )
{
	if( aIdentifier.getLength() == 16 && 0 == rtl_compareMemory( getUnoTunnelId().getConstArray(),
																 aIdentifier.getConstArray(), 16 ) )
	{
		return (sal_Int64)this;
	}
	return 0;
}

// helper for XUnoTunnel
SchTransferable* SchTransferable::getImplementation( uno::Reference< uno::XInterface > xData ) throw()
{
	uno::Reference< lang::XUnoTunnel > xUT( xData, uno::UNO_QUERY );
	if( xUT.is() )
		return (SchTransferable*)xUT->getSomething( SchTransferable::getUnoTunnelId() );
	else
		return NULL;
}

// generate a uniqueId
const uno::Sequence< sal_Int8 > & SchTransferable::getUnoTunnelId() throw()
{
	static uno::Sequence< sal_Int8 > * pSeq = 0;
	if( !pSeq )
	{
		osl::Guard< osl::Mutex > aGuard( osl::Mutex::getGlobalMutex() );
		if( !pSeq )
		{
			static uno::Sequence< sal_Int8 > aSeq( 16 );
			rtl_createUuid( (sal_uInt8*)aSeq.getArray(), 0, sal_True );
			pSeq = &aSeq;
		}
	}
	return *pSeq;
}
