/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuconnct.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:37:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include "fuconnct.hxx"

#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
//CHINA001 #include <svx/connect.hxx>
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef SD_VIEW_HXX
#include "View.hxx"
#endif
#ifndef SD_VIEW_SHELL_HXX
#include "ViewShell.hxx"
#endif
#include "drawdoc.hxx"
#include <svx/svxdlg.hxx> //CHINA001
#include <svx/dialogs.hrc> //CHINA001

namespace sd {

TYPEINIT1( FuConnectionDlg, FuPoor );

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

FuConnectionDlg::FuConnectionDlg (
    ViewShell* pViewSh, 
    ::sd::Window* pWin, 
    ::sd::View* pView,
    SdDrawDocument* pDoc, 
    SfxRequest& rReq)
    : FuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	SfxItemSet aNewAttr( pDoc->GetPool() );
	pView->GetAttributes( aNewAttr );

	const SfxItemSet* pArgs = rReq.GetArgs();
    ::std::auto_ptr<AbstractSfxSingleTabDialog> pDlg (NULL);

	if( !pArgs )
	{
		//CHINA001 SvxConnectionDialog* pDlg = new SvxConnectionDialog( NULL, aNewAttr, pView );
		SvxAbstractDialogFactory* pFact = SvxAbstractDialogFactory::Create();
		DBG_ASSERT(pFact, "Dialogdiet Factory fail!");//CHINA001
		pDlg.reset (pFact->CreateSfxSingleTabDialog( NULL,
                aNewAttr, 
                pView,
                ResId(RID_SVXPAGE_CONNECTION)));
		DBG_ASSERT(pDlg.get()!=NULL, "Dialogdiet fail!");//CHINA001
		USHORT nResult = pDlg->Execute();

		switch( nResult )
		{
			case RET_OK:
			{
				pArgs = pDlg->GetOutputItemSet();
				rReq.Done( *pArgs );
			}
			break;

			default:
                return; // Abbruch
		}
	}
	pView->SetAttributes( *pArgs );
}

} // end of namespace sd
