/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ViewShellCache.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:19:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_VIEW_SHELL_CACHE_HXX
#define SD_VIEW_SHELL_CACHE_HXX

#include "ShellFactory.hxx"
#include <memory>

namespace sd
{

class ViewShellManager;

/** The task of the view shell cache is to provide view shells that are
    displayed in one of the panes.  Its goal is to reduce the number of
    times view shells are created.  For this it uses the fact that view
    shells in the side panes are generally not replaced by another view
    shell but made temporarily hidden.  In the center pane there are a
    limited number of view shells of which a few can be stored and be made
    visible if requested.

    The cache knows about view shells and parent windows, not about panes.
    It therefore does not know whether a view shell belongs to one of the
    side panes.
*/
class ViewShellCache
{
public:
    ViewShellCache (ViewShellManager& rManager);
    ~ViewShellCache (void);

    /** Get a view shell of the specified type that will be displayed in the
        specified window.  It lies in the responsibility of the cache
        whether it creates a new shell or uses one in the cache.
    */
    ViewShell* GetViewShell (
        ShellId nId,
        ::Window* pParentWindow,
        FrameView* pFrameView);

    /** The given view shell is not displayed any longer.  It lies in the
        responsibility of the cache whether it destroys the shell or stores
        it for later use.
    */
    void ReleaseViewShell (ViewShell* pViewShell);

    /** Clear the view shell cache.  Following calls are ignored.
    */
    void Shutdown (void);

private:
    class Implementation;
    ::std::auto_ptr<Implementation> mpImpl;
};

} // end of namespace sd

#endif
