/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: MasterPagesContainerSelector.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:40:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "MasterPagesContainerSelector.hxx"

#include "MasterPageContainer.hxx"
#include "PreviewValueSet.hxx"

namespace {

typedef ::std::pair<int, ::sd::toolpanel::controls::MasterPageContainer::Token> UserData;

} //end of anonymous namespace



namespace sd { namespace toolpanel { namespace controls {

TYPEINIT1(MasterPagesContainerSelector, MasterPagesSelector);



MasterPagesContainerSelector::MasterPagesContainerSelector (
    TreeNode* pParent,
    SdDrawDocument& rDocument,
    ViewShellBase& rBase)
    : MasterPagesSelector(pParent,rDocument,rBase)
{
}




MasterPagesContainerSelector::~MasterPagesContainerSelector (void)
{
    MasterPageContainer::Instance().RemoveCallback (
        LINK(this,MasterPagesContainerSelector,PreviewAvailableCallback));
}




SdPage* MasterPagesContainerSelector::GetSelectedMasterPage (void)
{
    SdPage* pMasterPage = NULL;
    USHORT nIndex = mpPageSet->GetSelectItemId();
    MasterPageContainer::Token* pToken 
        = reinterpret_cast<MasterPageContainer::Token*>(mpPageSet->GetItemData (nIndex));
    if (pToken != NULL)
    {
        pMasterPage = MasterPageContainer::Instance().GetPageObjectForToken(*pToken);
        if (pMasterPage != NULL)
        {
            // When there is no preview in the value set then create one
            // by rendering the master page.
            Size aImageSize (mpPageSet->GetItemImage(nIndex).GetSizePixel());
            if (aImageSize.Width()<=0 || aImageSize.Height()<=0)
                mpPageSet->SetItemImage (
                    nIndex, 
                    MasterPageContainer::Instance().GetPreviewForToken(
                        *pToken,
                        mnPreviewWidth));
        }
    }
    return pMasterPage;
}




IMPL_LINK(MasterPagesContainerSelector,PreviewAvailableCallback,void*,pUserData)
{
    UserData* pData = reinterpret_cast<UserData*>(pUserData);
    mpPageSet->SetItemImage (
        pData->first, 
        MasterPageContainer::Instance().GetPreviewForToken (
            pData->second,
            mnPreviewWidth));
    delete pUserData;
    return 0;
}




void MasterPagesContainerSelector::AddItemForPage (
    const String& sURL,
    const String& sPageName,
    SdPage* pMasterPage,
    Image aPreview,
    bool bCreatePreview)
{
    AddItemForToken (
        MasterPageContainer::Instance().PutMasterPage (
            sURL,
            sPageName,
            String(),
            pMasterPage,
            aPreview));
}




void MasterPagesContainerSelector::AddItemForToken (
    MasterPageContainer::Token aToken,
    bool bCreatePreview)
{
    if (aToken != MasterPageContainer::NIL_TOKEN)
    {
        int nIndex = mpPageSet->GetItemCount() + 1;
        Image aPreview;
        if (bCreatePreview)
            aPreview = MasterPageContainer::Instance().GetPreviewForToken(
                aToken,
                mnPreviewWidth,
                LINK(this,MasterPagesContainerSelector,PreviewAvailableCallback),
                new UserData(nIndex, aToken));
        else
            aPreview = MasterPageContainer::Instance().GetPreviewForToken(
                aToken,
                mnPreviewWidth);
        mpPageSet->InsertItem (
            nIndex,
            aPreview,
            MasterPageContainer::Instance().GetPageNameForToken (aToken));
        mpPageSet->SetItemData (
            nIndex, 
            new MasterPageContainer::Token(aToken));
    }
}




void MasterPagesContainerSelector::UpdateAllPreviews (void)
{
    MasterPageContainer::Token* pToken;
    for (USHORT nIndex=1; nIndex<=mpPageSet->GetItemCount(); nIndex++)
    {
        pToken = reinterpret_cast<MasterPageContainer::Token*>(
            mpPageSet->GetItemData (nIndex));
        if (pToken != NULL)
            mpPageSet->SetItemImage (nIndex,
                MasterPageContainer::Instance().GetPreviewForToken (
                    *pToken,
                    mnPreviewWidth));
    }
    GetParentNode()->RequestResize();
}




void MasterPagesContainerSelector::UpdatePreview (USHORT nIndex)
{
    MasterPageContainer::Token* pToken (
        reinterpret_cast<MasterPageContainer::Token*>(
            mpPageSet->GetItemData (nIndex)));
    if (pToken != NULL)
    {
        mpPageSet->SetItemImage (nIndex,
            MasterPageContainer::Instance().GetPreviewForToken (
                *pToken,
                mnPreviewWidth));
        GetParentNode()->RequestResize();
    }
}




void MasterPagesContainerSelector::InvalidatePreview (const SdPage* pPage)
{
    MasterPageContainer::Token* pToken;
    for (USHORT nIndex=1; nIndex<=mpPageSet->GetItemCount(); nIndex++)
    {
        pToken = reinterpret_cast<MasterPageContainer::Token*>(
            mpPageSet->GetItemData (nIndex));
        if (pToken != NULL)
            if (MasterPageContainer::Instance().GetPageObjectForToken(*pToken, false) == pPage)
            {
                MasterPagesSelector::InvalidatePreview(nIndex);
                break;
            }
    }
}




void MasterPagesContainerSelector::Clear (void)
{
    for (USHORT nIndex=1; nIndex<=mpPageSet->GetItemCount(); nIndex++)
    {
        delete reinterpret_cast<MasterPageContainer::Token*>(
            mpPageSet->GetItemData (nIndex));
    }
    MasterPagesSelector::Clear();
}

} } } // end of namespace ::sd::toolpanel::controls
