/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: clientsh.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:36:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SOERR_HXX //autogen
#include <so3/soerr.hxx>
#endif
#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#include <so3/applet.hxx>
#ifndef GCC
#pragma hdrstop
#endif

#define _SFX_CLIENTSH_CXX

#include "clientsh.hxx"
#include "docfile.hxx"
#include "virtmenu.hxx"
#include "app.hxx"
#include "mnumgr.hxx"
#include "stbmgr.hxx"
#include "viewfrm.hxx"
#include "viewsh.hxx"
#include "dispatch.hxx"
#include "contenv.hxx"
#include "objsh.hxx"
#include "interno.hxx"
#if SUPD<613//MUSTINI
#include "inimgr.hxx"
#endif

//! wg. HACK
#include "plugobj.hxx"
#include "frameobj.hxx"

#define SFX_CLIENTACTIVATE_TIMEOUT 100

//--------------------------------------------------------------------

struct SfxInPlaceClient_Impl
{
	Timer	aTimer;
	//SvInPlaceMenuBar*	pMenuBar;
};

//--------------------------------------------------------------------

SfxInPlaceClient::SfxInPlaceClient( SfxViewShell * pViewShell, Window * pDraw ) :
	pImp( new SfxInPlaceClient_Impl ),
	pViewSh( pViewShell )
{
	WorkWindow* pTop;
/*!!! (pb) needs new implementation
	if ( Application::IsPresentationMode() )
	{
		// Wg. Mega-Hack im Impress mu\s die Presentation leider wieder mal
		// spezialbehandelt werden; das ViewFrameWindow oder TaskWindow liegen
		// leider au\serhalb des PresentaionWindow !
		pTop = (WorkWindow*) SFX_APP()->GetTopWindow();
	}
	else
*/
	{
        pTop = (WorkWindow*) &pViewSh->GetViewFrame()->GetFrame()->GetWindow();
	}

	// Bis zur 314 erstmal gleich erzeugen
	SetViewData( new SfxContainerEnv_Impl( this, pViewShell->GetViewFrame(), pTop, pDraw ) );

	pImp->aTimer.SetTimeout( SFX_CLIENTACTIVATE_TIMEOUT );
	pImp->aTimer.SetTimeoutHdl( LINK( this, SfxInPlaceClient, TimerHdl_Impl ) );
}

//--------------------------------------------------------------------

SfxInPlaceClient::SfxInPlaceClient( SfxViewShell * pViewShell,
									SvInPlaceClient * pPar )
:	SvInPlaceClient( /*
		new SfxContainerEnv_Impl( pViewShell->GetViewFrame(), pPar )*/ ),
	pImp( NULL ),
	pViewSh( pViewShell )
{
}

//--------------------------------------------------------------------

SfxInPlaceClient::~SfxInPlaceClient()
{
	SvClientData *pData = GetClientData();
	SetViewData( NULL );
	delete pData;
	pImp->aTimer.Stop();
	delete pImp;
}

//--------------------------------------------------------------------

void SfxInPlaceClient::Opened( BOOL bOpen )
{
	// SO2 l"a\st das Zerst"oren der Objeckte leider jederzeit zu
	SvInPlaceClientRef aIPClient( this );
	SvInPlaceClient::Opened(bOpen);
	if ( bOpen )
	{
		if ( GetIPObj()->GetMiscStatus() & SVOBJ_MISCSTATUS_ALWAYSACTIVATE )
		{
#if SUPD<613//MUSTINI
			BOOL bApplets = SFX_INIMANAGER()->IsAppletsEnabled();
#else
			BOOL bApplets = sal_False;
#endif
			SvAppletObjectRef aAppRef = GetIPObj();
			if ( !pViewSh->PlugInsActive() || aAppRef.Is() && !bApplets )
				GetProtocol().Reset2Open();
		}
	}
}

//--------------------------------------------------------------------

void SfxInPlaceClient::Connected( BOOL bConnect )
{
	// SO2 l"a\st das Zerst"oren der Objeckte leider jederzeit zu
	SvInPlaceClientRef aIPClient( this );

	SvInPlaceClient::Connected(bConnect);
	if ( bConnect )
	{
		pViewSh->NewIPClient_Impl(this);
		if ( pViewSh->PlugInsActive() )
			pImp->aTimer.Start();
	}
	else
	{
		pImp->aTimer.Stop();
		pViewSh->IPClientGone_Impl(this);
	}
}

//--------------------------------------------------------------------

void SfxInPlaceClient::UIActivate( BOOL bActivate )
{
	// SO2 l"a\st das Zerst"oren der Objeckte leider jederzeit zu
	SvInPlaceClientRef aIPClient( this );

	if (bActivate)
	{
		pViewSh->DisconnectClients_Impl(this);
		pViewSh->GetViewFrame()->GetBindings().InvalidateAll(TRUE);
        pViewSh->GetViewFrame()->GetDispatcher()->Flush();

		pViewSh->UIActivate( GetIPObj() );
	}

	SvInPlaceClient::UIActivate( bActivate );

	if (!bActivate)
	{
		pViewSh->UIDeactivate( GetIPObj() );
//		pViewSh->GetWindow()->GrabFocus();
		pViewSh->GetViewFrame()->GetBindings().InvalidateAll(TRUE);
	}

/* InPlace in InPlace ...
	if( !GetParent() )
	{ // Root-Client
		if( bActivate )
			aPaintApp.GetToolBox()->Hide();
		else if( !GetUIActiveClient() )
			// letzter Client im MDI-Win wird deaktiviert
			aPaintApp.GetToolBox()->Show();
	}
	else if( !GetUIActiveClient() && GetParent()->IsInPlaceActive() )
		// Kein andere aktiviert, also Parent aktivieren
		GetParent()->GetIPObj()->DoUIActivate( TRUE );
*/
}

//--------------------------------------------------------------------

void SfxInPlaceClient::RequestObjAreaPixel( const Rectangle & rObjRect )
{
	GetEnv()->SvContainerEnvironment::RequestObjAreaPixel( rObjRect );
}

//--------------------------------------------------------------------

void SfxInPlaceClient::Embedded( BOOL bEmbedding )
{
	// SO2 l"a\st das Zerst"oren der Objeckte leider jederzeit zu
	SvInPlaceClientRef aIPClient( this );

	SvInPlaceClient::Embedded( bEmbedding );
	if (bEmbedding)
        GetEmbedObj()->SetDocumentName( pViewSh->GetViewFrame()->GetObjectShell()->GetTitle() );
	else
        pViewSh->GetViewFrame()->GetFrame()->GrabFocusOnComponent_Impl();
}


IMPL_LINK( SfxInPlaceClient, TimerHdl_Impl, Timer*, pTimer )

/*	[Beschreibung]

	Ein Client wurde connected, weil das Objekt ACTIVATE_WHENVISIBLE hat.
	Dann soll es nach kurzer Zeit automatisch aktiviert werden.

*/

{
	// Diesen Client referenzieren, da er evtl. im DoVerb abfliegen k"onnte,
	// wenn das PlugIn fehlschl"agt
	SvInPlaceClientRef aIPClient( this );
	SfxInPlaceObject *pObj = pViewSh->GetFrame()->GetObjectShell()->GetInPlaceObject();
	Rectangle aVisArea = pObj->GetVisArea();
	GetViewShell()->CheckIPClient_Impl( this, aVisArea );
	return 0;
}

void SfxInPlaceClient::InPlaceActivate( BOOL bActivate )
{
	// SO2 l"a\st das Zerst"oren der Objeckte leider jederzeit zu
	SvInPlaceClientRef aIPClient( this );

	if ( bActivate )
	{
		// Falls der Activate-Timer noch l"auft.
		pImp->aTimer.Stop();

		// FullPlugs, die als Objekte eingef"ugt wurden, m"ussen noch auf volle
		// Fenstergr"o\se gebracht werden
		SvPlugInObjectRef aRef = GetIPObj();
		if ( aRef.Is() )
		{
			//! HACK
			TimerHdl_Impl(0);
//			pImp->aTimer.Start();

			if ( aRef->GetPlugInMode() == PLUGIN_FULL )
			{
				pViewSh->SetBorderPixel(SvBorder());
				Window *pWin = pViewSh->GetWindow();
				Size aSize = pWin->GetOutputSizePixel();
				aSize = pWin->PixelToLogic(aSize);
				Rectangle aRect = Rectangle ( pWin->PixelToLogic(Point()), aSize);
				GetClientData()->SetObjArea(aRect);
			}
		}
	}
}

// F"urs Update erstmal schnell rein damit ...

void SfxInPlaceClient::MakeViewData()
{
}

void SfxInPlaceClient::FreeViewData()
{
}

void SfxInPlaceClient::MakeVisible()
{
}

//========================================================================
ErrCode	SfxInPlaceClient::GetContURL
(
	INetURLObject & rURL
)
/*	[Beschreibung]

	[Querverweise]

	<SvEmbeddedClient::GetContURL>
*/
{
	SfxMedium * pMed = pViewSh->GetViewFrame()->GetObjectShell()->GetMedium();
	if( rURL.SetSmartURL( pMed->GetName() ) )
		return ERRCODE_NONE;
	else
	{
		rURL = INetURLObject();
		return ERRCODE_SO_GENERALERROR;
	}
}

