/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ucbhelp.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:52:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// includes --------------------------------------------------------------
#include "ucbhelp.hxx"

#ifndef _COM_SUN_STAR_UCB_XCONTENTIDENTIFIERFACTORY_HPP_
#include <com/sun/star/ucb/XContentIdentifierFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include <com/sun/star/ucb/XContentProviderManager.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDINFO_HPP_
#include <com/sun/star/ucb/XCommandInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDPROCESSOR_HPP_
#include <com/sun/star/ucb/XCommandProcessor.hpp>
#endif
#ifndef  _COM_SUN_STAR_TASK_XINTERACTIONHANDLER_HPP_
#include <com/sun/star/task/XInteractionHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_OPENCOMMANDARGUMENT2_HPP_
#include <com/sun/star/ucb/OpenCommandArgument2.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_OPENMODE_HPP_
#include <com/sun/star/ucb/OpenMode.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTY_HPP_
#include <com/sun/star/beans/Property.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGENOTIFIER_HPP_
#include <com/sun/star/beans/XPropertiesChangeNotifier.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASINK_HPP_
#include <com/sun/star/io/XActiveDataSink.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATACONTROL_HPP_
#include <com/sun/star/io/XActiveDataControl.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XSEEKABLE_HPP_
#include <com/sun/star/io/XSeekable.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase2.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif
#ifndef _VOS_CONDITN_HXX_
#include <vos/conditn.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef  _UNOTOOLS_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include <vcl/svapp.hxx>
#include <svtools/cntwids.hrc>

#ifndef _SFXCANCEL_HXX
#include <svtools/cancel.hxx>
#endif

#include "sfxuno.hxx"

//----------------------------------------------------------------------------

using namespace rtl;
using namespace cppu;
using namespace vos;
using namespace com::sun::star::beans;
using namespace com::sun::star::container;
using namespace com::sun::star::lang;
using namespace com::sun::star::task;
using namespace com::sun::star::ucb;
using namespace com::sun::star::uno;
using namespace com::sun::star::sdbc;
using namespace com::sun::star::io;

static Reference< XInteractionHandler >	globalInteractionHandler;
static Reference< XProgressHandler >	globalProgressHandler;

//----------------------------------------------------------------------------

#define APP_VENDOR_TYPE_PREFIX	"application/"##INET_VENDOR_SCHEME_PREFIX
#define CHAOS_TYPE_PREFIX		".chaos/"
#define VIEW_DELIMITER			"#.view:"

//----------------------------------------------------------------------------

//============================================================================
//
//	UcbTaskEnvironment.
//
//============================================================================

class UcbTaskEnvironment : public WeakImplHelper1< XCommandEnvironment >
{
	Reference< XInteractionHandler > m_xInteractionHandler;
	Reference< XProgressHandler > m_xProgressHandler;

public:
			UcbTaskEnvironment( const Reference< XInteractionHandler>& rxInteractionHandler,
								const Reference< XProgressHandler>& rxProgressHandler );

	virtual Reference<XInteractionHandler> SAL_CALL getInteractionHandler() throw (RuntimeException)
	{ return m_xInteractionHandler; }

	virtual Reference<XProgressHandler> SAL_CALL getProgressHandler() throw (RuntimeException)
	{ return m_xProgressHandler; }
};

//----------------------------------------------------------------------------

static OUString getPropName_Impl( USHORT nPropId )
{
	OUString aPropName;
	switch ( nPropId ) {
        case WID_FLAG_READONLY :
                aPropName = DEFINE_CONST_OUSTRING("IsReadOnly");
				break;
		case WID_FLAG_IS_FOLDER :
				aPropName = DEFINE_CONST_OUSTRING("IsFolder");
				break;
		case WID_FLAG_IS_DOCUMENT :
				aPropName = DEFINE_CONST_OUSTRING("IsDocument");
				break;
		case WID_TARGET_URL :
				aPropName = DEFINE_CONST_OUSTRING("TargetURL");
				break;
		case WID_DOCUMENT_HEADER :
				aPropName = DEFINE_CONST_OUSTRING("DocumentHeader");
				break;
		case WID_IS_READ :
				aPropName = DEFINE_CONST_OUSTRING("IsRead");
				break;
		case WID_IS_PROTECTED :
				aPropName = DEFINE_CONST_OUSTRING("IsProtected");
				break;
		case WID_UPDATE :
				aPropName = DEFINE_CONST_OUSTRING("update");
				break;
		case WID_OPEN :
				aPropName = DEFINE_CONST_OUSTRING("open");
				break;
		case WID_INSERT :
				aPropName = DEFINE_CONST_OUSTRING("insert");
				break;
		case WID_TRANSFER :
				aPropName = DEFINE_CONST_OUSTRING("transfer");
				break;
		case WID_TITLE :
				aPropName = DEFINE_CONST_OUSTRING("Title");
				break;
		default:
#ifdef DBG_UTIL
				ByteString aErr( "Unknown PropertyId: " );
				aErr += ByteString::CreateFromInt32( (int) nPropId );
				aErr += " ! Can't get property name!";
				DBG_ERRORFILE( aErr.GetBuffer() );
#endif
				break;
	};
	return aPropName;
}

//----------------------------------------------------------------------------

class WrpJobList;

//============================================================================
//
//	WrpJob and WrpJobList.
//
//============================================================================

class WrpJob
{
	::vos::OMutex               maMutex;
	WrpJobList*					mpParent;
	Reference < XCommandProcessor> mxProcessor;
	sal_Int32                   mnId;
	sal_Bool                    mbDone;

public:
							WrpJob( WrpJobList* pParent, const Reference < XCommandProcessor > xProcessor, sal_Int32 nId );

							~WrpJob();

	void					SetParent( WrpJobList* pParent );
	void					Abort();
	void                    Done()
							{
								::vos::OGuard aGuard( maMutex );
								mbDone = TRUE;
							}
	BOOL                    IsDone()
							{
								::vos::OGuard aGuard( maMutex );
								return mbDone;
							}
};

//----------------------------------------------------------------------------

class WrpJobList : private List
{
	NAMESPACE_VOS(OMutex)	maMutex;

public:
							List::Count;
							List::First;
							List::Next;

							WrpJobList();
							~WrpJobList();

	WrpJob*                 CreateJob( const Reference < XCommandProcessor > xProcessor, sal_Int32 nId );
	void					RemoveJob( const WrpJob* pJob );
	void					AbortAll();
};

//----------------------------------------------------------------------------
WrpJob::WrpJob( WrpJobList* pParent,
			    const Reference < XCommandProcessor > xProcessor,
				sal_Int32 nId )
{
	mpParent = pParent;
	mbDone = FALSE;
	mnId = nId;
	mxProcessor = xProcessor;
}

//----------------------------------------------------------------------------
WrpJob::~WrpJob()
{
	if ( mpParent )
		mpParent->RemoveJob( this );
}

//----------------------------------------------------------------------------
void WrpJob::SetParent( WrpJobList* pParent )
{
	OGuard aGuard( maMutex );
	mpParent = pParent;
}

//----------------------------------------------------------------------------
void WrpJob::Abort()
{
	OGuard aGuard( maMutex );

	if ( !mbDone )
	{
		mxProcessor->abort( mnId );
		mbDone = TRUE;
	}
}

WrpJobList::WrpJobList()
	: List( 4, 4 )
{
}

//----------------------------------------------------------------------------
WrpJobList::~WrpJobList()
{
	AbortAll();
}

//----------------------------------------------------------------------------
WrpJob* WrpJobList::CreateJob( const Reference < XCommandProcessor > xProcessor, sal_Int32 nId )
{
	OGuard aGuard( maMutex );
	WrpJob* pJob = new WrpJob( this, xProcessor, nId );
	Insert( pJob, LIST_APPEND );
	return pJob;
}

//----------------------------------------------------------------------------
void WrpJobList::AbortAll()
{
	OGuard aGuard( maMutex );
	while ( Count() )
	{
		WrpJob* pJob = (WrpJob*) Remove( (ULONG) NULL );
		pJob->Abort();
		delete pJob;
	}
}

//----------------------------------------------------------------------------
void WrpJobList::RemoveJob( const WrpJob* pJob )
{
	OGuard aGuard( maMutex );
	Remove( (void*) pJob );
}

//-------------------------------------------------------------------------
UcbTaskEnvironment::UcbTaskEnvironment( const Reference< XInteractionHandler >& rxInteractionHandler,
										const Reference< XProgressHandler >& rxProgressHandler )
	: m_xInteractionHandler( rxInteractionHandler )
	, m_xProgressHandler( rxProgressHandler )
{
}

//============================================================================
//
//	Ucb.
//
//============================================================================

#define UCB_MODULE_PREFIX "cnt"

class Ucb
{
	Reference< XMultiServiceFactory >	   m_xFac;
	Reference< XContentProviderManager >   m_xProvMgr;
	Reference< XContentProvider >   	   m_xProv;
	Reference< XContentIdentifierFactory > m_xIdFac;
	sal_Bool m_bInited : 1;

public:
	Ucb();
	~Ucb();

	sal_Bool init();

	XContentIdentifierFactory*	getContentIdentifierFactory();
	XContentProvider* 			getContentProvider();
};

//-------------------------------------------------------------------------

static Ucb* pUcb = NULL;

//-------------------------------------------------------------------------
Ucb::Ucb()
: m_bInited( sal_False )
{
    m_xFac = ::comphelper::getProcessServiceFactory();
}

//-------------------------------------------------------------------------
Ucb::~Ucb()
{
}

//-------------------------------------------------------------------------
sal_Bool Ucb::init()
{
	if ( m_bInited )
		return sal_True;

#if 0 //@@@ SB: That old hack of initializing the UCB with a
	  // XMultiServiceFactory is no longer supported/required:
	// init remote ucb
	Reference< XInitialization > xInit(
		m_xFac->createInstance(
			DEFINE_CONST_UNICODE("com.sun.star.ucb.UniversalContentBroker") ), UNO_QUERY );

	if (xInit.is())
	{
		try
		{
			Sequence<Any> params(1);

			params.getArray()[0] = makeAny(m_xFac);

			xInit->initialize(params);
		}
		catch (Exception&)
		{
		}
	}
#endif

	//////////////////////////////////////////////////////////////////////
	// Create and UCB service.
	//////////////////////////////////////////////////////////////////////

	if ( m_xFac.is() )
	{
		// Create auto configured UCB:
		Sequence< Any > aArgs(1);
		aArgs[0] <<= sal_True;
		Reference< XInterface > xIfc(
			m_xFac->createInstanceWithArguments(
				DEFINE_CONST_UNICODE("com.sun.star.ucb.UniversalContentBroker"),
				aArgs ) );

		if ( xIfc.is() )
			m_xProvMgr = Reference< XContentProviderManager >::query( xIfc );
	}

	m_bInited = sal_True;
	return m_bInited;
}

//-------------------------------------------------------------------------
XContentIdentifierFactory* Ucb::getContentIdentifierFactory()
{
	if ( !m_xIdFac.is() )
	{
		if ( init() )
			m_xIdFac =
				Reference< XContentIdentifierFactory >::query( m_xProvMgr );
	}

	return m_xIdFac.get();
}

//-------------------------------------------------------------------------
XContentProvider* Ucb::getContentProvider()
{
	if ( !m_xProv.is() )
	{
		if ( init() )
			m_xProv = Reference< XContentProvider >::query( m_xProvMgr );
	}

	return m_xProv.get();
}

//============================================================================
//
//	ProgressHandler_Impl.
//
//============================================================================

class ProgressHandler_Impl: public cppu::OWeakObject,
							public XProgressHandler
{
	Link	m_aProgress;

public:
							ProgressHandler_Impl() {}

	void					SetProgressLink( const Link& rLink )
								{ m_aProgress = rLink; }

	virtual Any SAL_CALL	queryInterface( const Type & rType )
								throw (RuntimeException);

	virtual void SAL_CALL	acquire() throw (RuntimeException)
								{ OWeakObject::acquire(); }

	virtual void SAL_CALL	release() throw (RuntimeException)
								{ OWeakObject::release(); }

	virtual void SAL_CALL	push(const Any & rStatus) throw (RuntimeException);

	virtual void SAL_CALL	update(const Any & rStatus)
								throw (RuntimeException);

	virtual void SAL_CALL	pop() throw (RuntimeException);
};

//----------------------------------------------------------------------------
// virtual
Any SAL_CALL ProgressHandler_Impl::queryInterface( const Type & rType )
	throw (RuntimeException)
{
	Any aRet( ::cppu::queryInterface(	rType,
										static_cast< XProgressHandler* >( this )));

	if ( aRet.hasValue() )
		return aRet ;
	else
		return OWeakObject::queryInterface( rType );
}

//----------------------------------------------------------------------------
// virtual
void SAL_CALL ProgressHandler_Impl::push( const Any & rStatus )
	throw (RuntimeException)
{
}

//----------------------------------------------------------------------------
// virtual
void SAL_CALL ProgressHandler_Impl::update( const Any & rStatus )
	throw (RuntimeException)
{
	if ( m_aProgress.IsSet() )
		m_aProgress.Call( 0 );
}

//----------------------------------------------------------------------------
// virtual
void SAL_CALL ProgressHandler_Impl::pop()
	throw (RuntimeException)
{
}

//----------------------------------------------------------------------------
//
//	WrpJobList
//
//----------------------------------------------------------------------------


//============================================================================
//
//	UCB_Helper.
//
//============================================================================

WrpJobList * UCB_Helper::mpJobList = NULL;

//----------------------------------------------------------------------------
Any UCB_Helper::GetProperty( Reference < XContent > xContent, USHORT nPropId )
{
	OUString aName = getPropName_Impl( nPropId );
	if ( xContent.is() && aName.getLength() )
	{
		Sequence< Property > aProps( 1 );
		Property& rProp = aProps.getArray()[ 0 ];

		rProp.Name       = aName;
		rProp.Handle     = -1; /* unknown */

		Any aArg;
		aArg <<= aProps;

		Any aResult = ExecuteCommand( xContent,
									  DEFINE_CONST_OUSTRING( "getPropertyValues" ),
									  aArg );
		Reference< XRow > xValues;
		if ( aResult >>= xValues )
		{
			if ( xValues.is() )
			return xValues->getObject( 1, Reference< XNameAccess>() );
    	}
	}

	return Any();
}

//----------------------------------------------------------------------------
Any UCB_Helper::GetProperty( const String& rURL, USHORT nPropId )
{
	Any aRet;
	Reference < XContent > xContent = CreateContent( rURL );
	aRet = GetProperty( xContent, nPropId );
	return aRet;
}

//----------------------------------------------------------------------------
void UCB_Helper::SetProperty( const String& rURL, USHORT nPropId, const Any& rValue )
{
	Reference < XContent > xContent = CreateContent( rURL );
	SetProperty( xContent, nPropId, rValue );
}

//----------------------------------------------------------------------------
void UCB_Helper::SetProperty( Reference < XContent > xContent, USHORT nPropId, const Any& rValue )
{
	OUString aName = getPropName_Impl( nPropId );
	if ( xContent.is() && aName.getLength() )
	{
		Sequence< PropertyValue > aProps( 1 );
		PropertyValue& rProp = aProps.getArray()[ 0 ];

		rProp.Name       = aName;
		rProp.Handle     = -1; /* unknown */
		rProp.Value      = rValue;

		Any aArg;
		aArg <<= aProps;
		ExecuteCommand( xContent, DEFINE_CONST_OUSTRING( "setPropertyValues" ), aArg );
	}
}

//----------------------------------------------------------------------------
BOOL UCB_Helper::HasCommand( Reference < XContent > xContent,
							 USHORT nWhich )
{
	if ( !xContent.is() )
		return FALSE;

	OUString aCmdName = getPropName_Impl( nWhich );
	if ( ! aCmdName.getLength() )
		return FALSE;

	Any aRet = ExecuteCommand( xContent,
							   DEFINE_CONST_OUSTRING( "getCommandInfo" ),
							   Any() );

	Reference < XCommandInfo > xInfo;
	aRet >>= xInfo;
	if ( ! xInfo.is() )
		return FALSE;

	BOOL bRet = xInfo->hasCommandByName( aCmdName );

	return bRet;
}

//----------------------------------------------------------------------------
void UCB_Helper::ExecuteCommand( const String& rURL,
								 USHORT nId,
								 sal_Bool *pSuccess )
{
	Reference < XContent > xContent = CreateContent( rURL );
	ExecuteCommand( xContent, nId, Any(), pSuccess );
}

//----------------------------------------------------------------------------
void UCB_Helper::ExecuteCommand( const String& rURL,
								 USHORT nId,
								 const Any& rArgument,
								 sal_Bool *pSuccess )
{
	Reference < XContent > xContent = CreateContent( rURL );
	ExecuteCommand( xContent, nId, rArgument, pSuccess );
}

//----------------------------------------------------------------------------
void UCB_Helper::ExecuteCommand( Reference < XContent > xContent,
								 USHORT nId,
								 sal_Bool *pSuccess )
{
	ExecuteCommand( xContent, nId, Any(), pSuccess );
}

//----------------------------------------------------------------------------
void UCB_Helper::ExecuteCommand( Reference < XContent > xContent,
								 USHORT nId,
								 const Any& rArgument,
								 sal_Bool *pSuccess )
{
	OUString aName = getPropName_Impl( nId );
	if ( !xContent.is() || !aName.getLength() )
		return;

	ExecuteCommand( xContent, aName, rArgument, pSuccess );
}

//----------------------------------------------------------------------------
Any UCB_Helper::ExecuteCommand( Reference < XContent > xContent,
								const OUString& rName,
								const Any& rArgument,
								sal_Bool *pSuccess )
{
	Reference< XCommandProcessor > xProc( xContent, UNO_QUERY );
	if ( xProc.is() )
	{
        sal_Int32 nId = xProc->createCommandIdentifier();

        Command aCommand;
        aCommand.Name     = rName;
        aCommand.Handle   = -1; /* unknown */
        aCommand.Argument = rArgument;

        if ( !mpJobList )
            mpJobList = new WrpJobList();
        WrpJob* pJob = mpJobList->CreateJob( xProc, nId );

        Reference< XCommandEnvironment > xEnv( new UcbTaskEnvironment( globalInteractionHandler, globalProgressHandler ) );

        Any aResult;
        bool bException = false;
        bool bAborted = false;

        ULONG nAcquireCount = 0;
        IMutex& rMutex = Application::GetSolarMutex();
        if ( rMutex.tryToAcquire() )
            nAcquireCount = Application::ReleaseSolarMutex() - 1;

		try
		{
            // CommandId!
            aResult = xProc->execute( aCommand, nId, xEnv );
		}
		catch ( CommandAbortedException )
		{
			bAborted = true;
		}
		catch ( Exception )
		{
			bException = true;
		}

		if ( nAcquireCount )
			Application::AcquireSolarMutex( nAcquireCount );

		if ( !bAborted && !bException )
			pJob->Done();

		if ( pSuccess )
		{
			if ( bAborted || bException )
				*pSuccess = sal_False;
			else
				*pSuccess = sal_True;
		}

#ifdef DB_UTIL
		if( bException )
		{
			String aStr( "Executing " );
			aStr += U2S( aName );
			aStr += " with Exception!";
			DBG_ERROR( aStr.GetBuffer() );
		}
		else if ( bAborted )
		{
			String aStr( "Executing " );
			aStr += U2S( aName );
			aStr += " with Abort!";
			DBG_ERROR( aStr.GetBuffer() );
		}
#endif
		delete pJob;
		return aResult;
	}

	return Any();
}

//----------------------------------------------------------------------------
Any UCB_Helper::ExecuteOpenCommand( Reference < XContent > xContent,
									const Any& rArgument,
									sal_Int32 nCmdId,
									Reference< XCommandEnvironment > xEnv,
									sal_Bool &rSuccess )
{
	Reference< XCommandProcessor > xProc( xContent, UNO_QUERY );

	if ( xProc.is() )
	{
		Command aCommand;
		aCommand.Name     = getPropName_Impl( WID_OPEN );
		aCommand.Handle   = WID_OPEN;
		aCommand.Argument = rArgument;

		if ( !mpJobList )
			mpJobList = new WrpJobList();

		WrpJob* pJob = mpJobList->CreateJob( xProc, nCmdId );

		Any aResult;
		bool bException = false;
		bool bAborted = false;

		ULONG nAcquireCount = 0;
		IMutex& rMutex = Application::GetSolarMutex();
		if ( rMutex.tryToAcquire() )
			nAcquireCount = Application::ReleaseSolarMutex() - 1;

		try
		{
			rSuccess = sal_False;
			aResult = xProc->execute( aCommand, nCmdId, xEnv );
			rSuccess = sal_True;
		}
		catch ( CommandAbortedException )
		{
			bAborted = true;
		}
		catch ( Exception )
		{
			bException = true;
		}

		if ( nAcquireCount )
			Application::AcquireSolarMutex( nAcquireCount );

		if ( !bAborted && !bException )
			pJob->Done();

#ifdef DB_UTIL
		if( bException )
		{
			String aStr( "Executing " );
			aStr += U2S( aName );
			aStr += " with Exception!";
			DBG_ERROR( aStr.GetBuffer() );
		}
		else if ( bAborted )
		{
			String aStr( "Executing " );
			aStr += U2S( aName );
			aStr += " with Abort!";
			DBG_ERROR( aStr.GetBuffer() );
		}
#endif
		delete pJob;
		return aResult;
	}

	return Any();
}

//----------------------------------------------------------------------------
Reference < XContent > UCB_Helper::CreateContent( const String& rURL )
{
	OUString aURL ( rURL );
	return CreateContent( aURL );
}

//----------------------------------------------------------------------------
Reference < XContent > UCB_Helper::CreateContent( const OUString& rURL )
{
	Reference < XContent > aRet;

	Reference< XContentIdentifierFactory > xIdFac =
		pUcb->getContentIdentifierFactory();

	if ( !xIdFac.is() )
		return aRet;

	try
	{
        Reference< XContentIdentifier > xId =
            xIdFac->createContentIdentifier( rURL );

        if ( !xId.is() )
            return aRet;

        //////////////////////////////////////////////////////////////////////
        // Get XContentProvider interface from UCB and let it create a
        // content for the given identifier.
        //////////////////////////////////////////////////////////////////////

        Reference< XContentProvider > xProv = pUcb->getContentProvider();
        if ( !xProv.is() )
            return aRet;

		aRet = xProv->queryContent( xId );
	}
	catch ( IllegalIdentifierException ) {}

	return aRet;
}

//----------------------------------------------------------------------------
void UCB_Helper::Initialize()
{
    Reference< XMultiServiceFactory > xFactory = ::comphelper::getProcessServiceFactory();
	globalInteractionHandler= Reference< XInteractionHandler > (
				xFactory->createInstance( DEFINE_CONST_UNICODE("com.sun.star.task.InteractionHandler") ), UNO_QUERY );

	globalProgressHandler = new ProgressHandler_Impl();
	if ( !pUcb )
		pUcb = new Ucb;
}

//----------------------------------------------------------------------------
void UCB_Helper::Deinitialize()
{
	delete pUcb;

//	CntSystem::Deinitialize();

	globalInteractionHandler = NULL;
}

//----------------------------------------------------------------------------
void UCB_Helper::SetConnectionMode( BOOL bOn )
{
	// bOn == Offline
//      CntConnModeItem aItem( WID_CONNECTION_MODE, bOffLine ? CNT_CONN_MODE_OFFLINE: CNT_CONN_MODE_ONLINE );
//      CNT_SYS()->Put( aItem );
//    DBG_ERRORFILE( "NYI" );
}

//----------------------------------------------------------------------------
BOOL UCB_Helper::GetConnectionMode()
{
//    DBG_ERRORFILE( "NYI" );
	return FALSE;
}

