/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: activityanimationbasenode.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:38:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_ACTIVITYANIMATIONBASENODE_HXX
#define _SLIDESHOW_ACTIVITYANIMATIONBASENODE_HXX

#include <animationbasenode.hxx>

namespace presentation
{
    namespace internal
    {
        /** Base class for animation nodes operating a full-blown Activity.
			
			Groups some common code for property, path, and transform
            animation nodes.
         */
        class ActivityAnimationBaseNode : public AnimationBaseNode
        {
        public:
            ActivityAnimationBaseNode( const ::com::sun::star::uno::Reference< 
                                       		::com::sun::star::animations::XAnimationNode >&	xNode, 
                                       const BaseContainerNodeSharedPtr&					rParent,
                                       const NodeContext& 									rContext );

            /** Overridden, because our Activity will do that by itself

				Typically, a full-blown Activity has its own intrinsic
				duration, thus, no need to schedule explicit stop
				events.
             */
            virtual void scheduleDeactivationEvent() const;
        };
    }
}

#endif /* _SLIDESHOW_ACTIVITYANIMATIONBASENODE_HXX */
