#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: remover.pm,v $
#
#   $Revision: 1.3 $
#
#   last change: $Author: rt $ $Date: 2005/09/08 09:32:11 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************


package pre2par::remover;

############################################
# Remover
############################################

sub remove_leading_and_ending_whitespaces
{
	my ( $stringref ) = @_;

	$$stringref =~ s/^\s*//g;
	$$stringref =~ s/\s*$//g;	
}

sub remove_leading_and_ending_quotationmarks
{
	my ( $stringref ) = @_;

	$$stringref =~ s/^\s*\"//g;
	$$stringref =~ s/\"\s*$//g;	
}

sub remove_leading_and_ending_slashes
{
	my ( $stringref ) = @_;

	$$stringref =~ s/^\s*\///g;
	$$stringref =~ s/\/\s*$//g;	
}

sub remove_leading_and_ending_backslashes
{
	my ( $stringref ) = @_;

	$$stringref =~ s/^\s*\\//g;
	$$stringref =~ s/\\\s*$//g;	
}

1;
