/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: strcrypt.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 16:28:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVTOOLS_STRCRYPT_HXX_
#include <strcrypt.hxx>
#endif

#ifndef _RTL_CIPHER_H_
#include <rtl/cipher.h>
#endif
#ifndef _RTL_DIGEST_H_ 
#include <rtl/digest.h>
#endif
#ifndef _SAL_TYPES_H_ 
#include <sal/types.h>
#endif
#ifndef _TOOLS_DEBUG_HXX 
#include <tools/debug.hxx>
#endif
#ifndef _STRING_HXX 
#include <tools/string.hxx>
#endif

namespace unnamed_svtools_strcrypt {}
using namespace unnamed_svtools_strcrypt;
	// unnamed namespaces don't work well yet...

//============================================================================
namespace unnamed_svtools_strcrypt {

const sal_uInt8 aCipherKey[]
	= { 0x5b, 0xbb, 0x0a, 0xa2, 0x62, 0x2a, 0xa6, 0x87,
		0x9a, 0x62, 0xd7, 0x48, 0xf9, 0x2d, 0x6c, 0x89 };

}

//============================================================================
//
//  SvStringEncode
//
//============================================================================

ByteString SvStringEncode(ByteString const & rSource)
{
	sal_uInt32 nLength = rSource.Len();
	if (nLength == 0)
		return rSource;

	// First, write MD5 of plaintext length into buffer:
	ByteString aTarget;
	sal_uInt32 nInputSize = (nLength + 7) & ~7; // multiple of 8
	sal_Char * pBuffer
		= aTarget.AllocBuffer(2 * (RTL_DIGEST_LENGTH_MD5 + nInputSize));
	rtl_digest_MD5(&nLength, sizeof nLength,
				   reinterpret_cast< sal_uInt8 * >(pBuffer),
				   RTL_DIGEST_LENGTH_MD5);

	// Initialize cipher algorithm with MD5 of plaintext length:
	rtlCipher aCipher = rtl_cipher_create(rtl_Cipher_AlgorithmBF,
										  rtl_Cipher_ModeCBC);
	DBG_ASSERT(aCipher != 0, "SvStringEncode(): Bad cipher");
	rtlCipherError aError
		= rtl_cipher_init(aCipher, rtl_Cipher_DirectionEncode,
						  aCipherKey, sizeof aCipherKey,
						  reinterpret_cast< sal_uInt8 * >(pBuffer),
						  RTL_DIGEST_LENGTH_MD5);
	DBG_ASSERT(aError == rtl_Cipher_E_None, "SvStringEncode(): Bad cipher");

	// Second, append ciphertext to buffer:
	aError = rtl_cipher_encode(aCipher, rSource.GetBuffer(), nLength,
							   reinterpret_cast< sal_uInt8 * >(
								   pBuffer + RTL_DIGEST_LENGTH_MD5),
							   nInputSize);
	DBG_ASSERT(aError == rtl_Cipher_E_None, "SvStringEncode(): Bad cipher");

	// Encode whole buffer:
	sal_Char * p = pBuffer + RTL_DIGEST_LENGTH_MD5 + nInputSize;
	sal_Char * q = pBuffer + 2 * (RTL_DIGEST_LENGTH_MD5 + nInputSize);
	while (p != pBuffer)
	{
		sal_uInt8 n = *--p;
		*--q = sal_Char('a' + (n & 15));
		*--q = sal_Char('a' + (n >> 4));
	}
	return aTarget;
}

//============================================================================
//
//  SvStringDecode
//
//============================================================================

ByteString SvStringDecode(ByteString const & rSource)
{
	sal_uInt32 nLength = rSource.Len();
	if (nLength == 0)
		return rSource;

	// Length of encoded ciphertext must equal
	//   2 * (RTL_DIGEST_LENGTH_MD5 + n * 8) == 32 + n * 16 == (n + 2) * 16
	// for some positive n:
	if (nLength % 16 != 0 || nLength < 48)
	{
		DBG_ERROR("SvStringDecode(): Bad input");
		return ByteString();
	}

	// Decode whole buffer:
	nLength /= 2;
	sal_uInt8 * pBuffer = new sal_uInt8[nLength];
	sal_Char const * p = rSource.GetBuffer();
	sal_Char const * pEnd = p + rSource.Len();
	sal_uInt8 * q = pBuffer;
	while (p != pEnd)
	{
		sal_Char c1 = *p++;
		sal_Char c2 = *p++;
		if (c1 < 'a' || c1 > 'p' || c2 < 'a' || c2 > 'p')
		{
			DBG_ERROR("SvStringDecode(): Bad input");
			delete[] pBuffer;
			return ByteString();
		}
		*q++ = sal_uInt8(((c1 - 'a') << 4) | (c2 - 'a'));
	}

	// Initialize cipher algorithm with MD5 of plaintext length:
	rtlCipher aCipher = rtl_cipher_create(rtl_Cipher_AlgorithmBF,
										  rtl_Cipher_ModeCBC);
	DBG_ASSERT(aCipher != 0, "SvStringEncode(): Bad cipher");
	rtlCipherError aError
		= rtl_cipher_init(aCipher, rtl_Cipher_DirectionDecode,
						  aCipherKey, sizeof aCipherKey,
						  pBuffer, RTL_DIGEST_LENGTH_MD5);
	DBG_ASSERT(aError == rtl_Cipher_E_None, "SvStringEncode(): Bad cipher");

	// Decrypt ciphertext:
	nLength -= RTL_DIGEST_LENGTH_MD5;
	ByteString aTarget;
	sal_Char * pTargetBuf = aTarget.AllocBuffer(nLength);
	aError = rtl_cipher_decode(aCipher,
							   pBuffer + RTL_DIGEST_LENGTH_MD5, nLength,
							   reinterpret_cast< sal_uInt8 * >(pTargetBuf),
							   nLength);
	DBG_ASSERT(aError == rtl_Cipher_E_None, "SvStringEncode(): Bad cipher");
	delete[] pBuffer;

	// Trim length:
	aTarget.Erase(rtl_str_getLength(pTargetBuf));
	return aTarget;
}

